/* global define, $$, parseFloat, LZString, plugins, require */
/*jslint browser: true, devel: false*/
/*jshint undef: true, unused: false */

/**
 * Sustituye los line-breaks por val
 * @param {String} val val
 * @title LBTo(val)
 */
String.prototype.LBTo = function(val) {
	val = val || "<br>";
	return this.replace(/(?:\r\n|\r|\n)/g, val);
};

if(!String.linkify)
{
	/**
	 * Añade los <a>
	 * @return {String} [String con tags <a]
	 */
	String.prototype.linkify = function() {
		var mask,
			 seudoMask,
			 emailMask;

		// http://, https://, ftp://
		var urlPattern = /\b(?:https?|ftp):\/\/[a-z0-9-+&@#\/%?=~_|!:,.;]*[a-z0-9-+&@#\/%=~_|]/gim;

		// www. sans http:// or https://
		var pseudoUrlPattern = /(^|[^\/])(www\.[\S]+(\b|$))/gim;

		// Email addresses
		var emailAddressPattern = /[\w.]+@[a-zA-Z_-]+?(?:\.[a-zA-Z]{2,6})+/gim;

		// Mascara
		if (window.cordova)
		{
			mask = "<a href=\"#\" class=\"external\" onclick=\"navigator.app.loadUrl('$&', { openExternal:true });\">$&</a>";
			seudoMask= "<a href=\"#\" class=\"external\"  onclick=\"navigator.app.loadUrl('http://$2', { openExternal:true });\">$&</a>";
			emailMask= "<a href=\"#\" class=\"external\"  onclick=\"navigator.app.loadUrl('mailto:$&', { openExternal:true });\">$&</a>";
		}
		/*else if (app.config.firefox && app.config.webOs)
		{
			mask = "<a href=\"#\" onclick='window.open(\"$&\", \"TreblonExtarnal\", \"resizable,scrollbars,status\");'>$&</a>";
			seudoMask = "<a href=\"#\" onclick='window.open(\"http://$2\", \"TreblonExtarnal\", \"resizable,scrollbars,status\");'>$&</a>";
			emailMask = '<a href="#" onclick="window.open(\'mailto:$&\');">$&</a>';
		}*/
		else
		{
			mask = "<a href=\"#\" class=\"external\" onclick='window.open(\"$&\", \"_blank\");'>$&</a>";
			seudoMask = "<a href=\"#\" class=\"external\" onclick='window.open(\"http://$2\", \"_blank\");'>$&</a>";
			emailMask = '<a href="#" class=\"external\" onclick="window.open(\'mailto:$&\');">$&</a>';
		}
		return this
			.replace(urlPattern, mask)	//'<a href="$&" target="_blank">$&</a>'
			.replace(pseudoUrlPattern, seudoMask) //'<a href="#" onclick="window.open(\'http://$2\', \'_system\');">$2</a>')
			.replace(emailAddressPattern, emailMask); //'<a href="#" onclick="window.open(\'mailto:$&\');">$&</a>');
		};
}

define("events", function() {
	var pub = {},
		 events = {},
		 nill;

	pub.add = function(ev, f) {
		if (!Array.isArray(ev))
		{
			if (ev.indexOf(",") >=0)
				ev = ev.split(",").map(function(i) {
					return i.trim();
				});
			else
				ev = ev.split(" ");
		}
		for (var i = 0; i < ev.length; i++) {
			 if (!events[ev[i]]) events[ev[i]] = [];
			 events[ev[i]].push(f);
		}
	};

	pub.remove = function(ev, f) {
		if(!ev)
			 return;
		if (!Array.isArray(ev))
		{
			if (ev.indexOf(",") >=0)
				ev = ev.split(",").map(function(i) {
				return i.trim();
				});
			else
				ev = ev.split(" ");
		}
		for (var i = 0; i < ev.length; i++) {
			 if (events[ev[i]]) {
				  var evts = events[ev[i]];
				  for (var j = 0; j < evts.length; j++) {
						if (f === nill)
							 delete evts[j];
						if (evts[j] === f) {
							 evts.splice(j, 1);
							 break;
						}
				  }
			 }
		}
	};

	pub.trigger = function(ev, args, scope) {
		var ret = true;
		scope = scope || window;
		if (!Array.isArray(ev))
		{
			if (ev.indexOf(",") >=0)
				ev = ev.split(",").map(function(i) {
					return i.trim();
				});
			else
				ev = ev.split(" ");
		}
		if (!Array.isArray(args)) args = [args];
		for (var i = 0; i < ev.length; i++) {
			 if (events[ev[i]]) {
				  var evts = events[ev[i]].slice(0);
				  for (var j = 0; j < evts.length; j++)
						if (evts[j] && evts[j].apply && evts[j].apply(scope, args) === false)
							 ret = false;
			 }
		}
		return ret;
	};

	/*document.addEventListener("DOMContentLoaded", function() {
		pub.trigger("ready");
	});*/

	return pub;
});

define("util", function() {
	var pub = {},
		 nill;

	pub.parseInputs = function(inputValues) {
		var obj = {};
		for (var i = 0, len = inputValues.length; i < len; i++)
		{
			var item = inputValues[i];
			if (item.type === 'checkbox') {
				obj[item.id] = item.checked;
			}
			else {
				obj[item.id] = item.value;
			}
		}
		return obj;
	};

	function esNull(o)
	{
		return o === nill || o === null || o === "undefined";
	}
	pub.esNull = esNull;

	pub.esVacio= function(str) {
		if (!str) return true;
		str = str.toString();
		return str.trim() === "";
	};

	pub.vibrate = function(ms) {
		ms = ms || 250;
		try {
			navigator.vibrate(ms);
		} catch(e) {
			return;
		}
	};

	function _date(newDate) {
		var self = this;
		this.Date = new Date(newDate || Date.now());
		Object.defineProperty(this, "time", {
		 get: function() {return self.Date.getTime();},
		 set: function(x) {self.Date.setTime(x);}
		});
		Object.defineProperty(this, "year", {
		 get: function() {
				return this.Date.getFullYear();
			},
			set: function(x) {
				var year = x.toString();

				if (year.length < 4)
					return;
				x = parseInt(year, 10);
				if (x < 1970) x = 2016;
				this.Date.setFullYear(x);
			}
		});
		Object.defineProperty(this, "mes", {
		 get: function() {
				return self.Date.getMonth();
			},
			set: function(x) {
				self.Date.setMonth(x);
			}
		});
		Object.defineProperty(this, "dia", {
			get: function() {
				return self.Date.getDate();
			},
			set: function(x) {
				self.Date.setDate(x);
			}
		});
		Object.defineProperty(this, "hora", {
			get: function() {
				return self.Date.getHours();
			},
			set: function(x) {
				self.Date.setHours(x);
			}
		});
		Object.defineProperty(this, "minutos", {
			get: function() {
				return self.Date.getMinutes() < 10? "0" + self.Date.getMinutes(): self.Date.getMinutes();
			},
			set:function(x) {
				self.Date.setMinutes(x);
			}
		});
	}

	pub.date = new _date();
	pub.Date = _date;

	(function(root) {
		var dateFormat = function () {
			var token = /d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,
				timezone = /\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,
				timezoneClip = /[^-+\dA-Z]/g,
				pad = function (val, len) {
					val = String(val);
					len = len || 2;
					while (val.length < len)
						val = "0" + val;
					return val;
				};

			// Regexes and supporting functions are cached through closure
			return function (date, mask, utc)	{
				var dF = dateFormat;

				// You can't provide utc if you skip other args (use the "UTC:" mask prefix)
				if (arguments.length === 1 && Object.prototype.toString.call(date) === "[object String]" && !/\d/.test(date)) {
					mask = date;
					date = undefined;
				}

				// Passing date through Date applies Date.parse, if necessary
				date = date ? new Date(date) : new Date();
				if (isNaN(date))
					throw SyntaxError("invalid date");

				mask = String(dF.masks[mask] || mask || dF.masks["default"]);

				// Allow setting the utc argument via the mask
				if (mask.slice(0, 4) === "UTC:") {
					mask = mask.slice(4);
					utc = true;
				}

				var _ = utc ? "getUTC" : "get",
						  d = date[_ + "Date"](),
						  D = date[_ + "Day"](),
						  m = date[_ + "Month"](),
						  y = date[_ + "FullYear"](),
						  H = date[_ + "Hours"](),
						  M = date[_ + "Minutes"](),
						  s = date[_ + "Seconds"](),
						  L = date[_ + "Milliseconds"](),
						  o = utc ? 0 : date.getTimezoneOffset(),
						  flags = {
							  d: d,
							  dd: pad(d),
							  ddd: dF.i18n.dayNames[D],
							  dddd: dF.i18n.dayNames[D + 7],
							  m: m + 1,
							  mm: pad(m + 1),
							  mmm: dF.i18n.monthNames[m],
							  mmmm: dF.i18n.monthNames[m + 12],
							  yy: String(y).slice(2),
							  yyyy: y,
							  h: H % 12 || 12,
							  hh: pad(H % 12 || 12),
							  H: H,
							  HH: pad(H),
							  M: M,
							  MM: pad(M),
							  s: s,
							  ss: pad(s),
							  l: pad(L, 3),
							  L: pad(L > 99 ? Math.round(L / 10) : L),
							  t: H < 12 ? "a" : "p",
							  tt: H < 12 ? "am" : "pm",
							  T: H < 12 ? "A" : "P",
							  TT: H < 12 ? "AM" : "PM",
							  Z: utc ? "UTC" : (String(date).match(timezone) || [""]).pop().replace(timezoneClip, ""),
							  o: (o > 0 ? "-" : "+") + pad(Math.floor(Math.abs(o) / 60) * 100 + Math.abs(o) % 60, 4),
							  S: ["th", "st", "nd", "rd"][d % 10 > 3 ? 0 : (d % 100 - d % 10 !== 10) * d % 10]
						  };

				return mask.replace(token, function ($0) {
					return $0 in flags ? flags[$0] : $0.slice(1, $0.length - 1);
				});
			};
		}();

		// Some common format strings
		dateFormat.masks = {
			"default": "ddd mmm dd yyyy HH:MM:ss",
			shortDate: "m/d/yy",
			mediumDate: "mmm d, yyyy",
			longDate: "mmmm d, yyyy",
			fullDate: "dddd, mmmm d, yyyy",
			shortTime: "h:MM TT",
			mediumTime: "h:MM:ss TT",
			longTime: "h:MM:ss TT Z",
			isoDate: "yyyy-mm-dd",
			isoTime: "HH:MM:ss",
			isoDateTime: "yyyy-mm-dd'T'HH:MM:ss",
			isoUtcDateTime: "UTC:yyyy-mm-dd'T'HH:MM:ss'Z'"
		};

		// Internationalization strings
		dateFormat.i18n = {
			dayNames: [
				"Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa",
				"Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"
			],
			monthNames: [
				"Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic",
				"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"
			]
		};

		// For convenience...
		Date.prototype.format = function (mask, utc) {
			return dateFormat(this, mask, utc);
		};

		root.dateFormat = dateFormat;

		root.prototype.setDia = function(dia) {
			if (typeof(dia) === "string")
			{
				dia = parseInt(dia, 10);
			}
			this.Date.setDate(dia);
		};
		root.prototype.setMes = function(mes) {
			var index = parseInt(mes) || 0;
			if (typeof(mes) === "string")
			{
				if (dateFormat.i18n.monthNames.indexOf(mes) > -1)
				{
					index = dateFormat.i18n.monthName.indexOf(mes);
					if (index > 11)
						index = index - 12;

				}
			}
			this.Date.setMonth(index);
		};
		root.prototype.setYear = function(year) {
			year = parseInt(year) || 2016;
			if (year < 2000)
				year = year + 2000;
			this.Date.setYear(year);
		};

		/*root.__defineGetter__('diaStr', function() { return this.Date.format("dddd"); });
		root.__defineGetter__("mesStr", function() { return this.Date.format("mmmm"); });*/

	})(_date);

	/*
	 *
	 * @param {Object} m Objeto a maestro
	 * @param {Object} e Objeto a extender
	 * @returns {@var;e|@this;}
	 */
	pub.extend = function(m, e) {
		e = e || this;
		for (var x in m)
			e[x] = m[x];
		return e;
	};

	function toFloat(str, decimals, toStr) {
		str = str || 0;
		str = str.toString().replace(/,/g, ".").split(".").splice(0, 2).join(".");
		str = decimals? parseFloat(str).toFixed(decimals): parseFloat(str);
		if (toStr)
			return str.toString().replace(".", ",");
		else
			return parseFloat(str);
	}

	pub.toFloat = function(obj, item, decimals, toStr) {
		if (!item || typeof(item) === "number")
			return toFloat(obj, item, decimals);
		/*var str = obj[item] || 0;
		str = str.toString().replace(/,/g, ".").split(".").splice(0, 2).join(".");
		str = decimals? parseFloat(str).toFixed(decimals): parseFloat(str);
		obj[item] = str;*/
		obj[item] = toFloat(obj[item], decimals, toStr);
		return toFloat(obj[item], decimals, toStr);
	};

	/**
	* ordena un array dentro de un JSON
	* @param {Array} objArray a ordenar
	* @param {string} prop del array a ordenar
	* @param {Number} direction 1 ascendente -1 descendente
	*/
	pub.orderArray = function (objArray, prop, direction) {
		if (arguments.length<2) throw new Error("orderArray requiere 2 argumentos.");
		var direct = arguments.length>2 ? arguments[2] : 1; //Default to ascending

		if (objArray && objArray.constructor===Array)
		{
			var propPath = (prop.constructor===Array) ? prop : prop.split(".");
			objArray.sort(function(a, b) {
				for (var p in propPath)
				{
					if (a[propPath[p]] && b[propPath[p]])
					{
						a = a[propPath[p]];
						b = b[propPath[p]];
					}
				}
				// convert numeric strings to integers
				try {
					a = a.match(/^\d+$/) ? +a : a;
					b = b.match(/^\d+$/) ? +b : b;
					return ( (a < b) ? -1*direct : ((a > b) ? 1*direct : 0) );
				} catch(e){
					return 0;
				}
			});
		}
	};

	/**
	 * ayepromise.js
	 * @license BSD - https://github.com/cburgmer/ayepromise/commit/299eb65b5ce227873b2f1724c8f5b2bfa723680a
	 * https://github.com/cburgmer/ayepromise
	 */
	(function(app) {
		 'use strict';

		 var ayepromise = {};

		 /* Wrap an arbitrary number of functions and allow only one of them to be
			 executed and only once */
		 var once = function () {
			  var wasCalled = false;

			  return function wrapper(wrappedFunction) {
					return function () {
						 if (wasCalled) {
							  return;
						 }
						 wasCalled = true;
						 wrappedFunction.apply(null, arguments);
					};
			  };
		 };

		 var getThenableIfExists = function (obj) {
			 //console.log("getThenableIfExists", obj);
			  // Make sure we only access the accessor once as required by the spec
			  var then = obj && obj.then;

			  if (obj !== null &&
					typeof obj === "object" &&
					typeof then === "function") {

					return function() { return then.apply(obj, arguments); };
			  }
		 };

		 var aThenHandler = function (onFulfilled, onRejected) {
			  var defer = ayepromise.defer();

			  var doHandlerCall = function (func, value) {
					//setTimeout(function () {
						 var returnValue;
						 try {
							  returnValue = func.apply(null, value);
						 } catch (e) {
							  defer.reject(e);
							  return;
						 }

						 if (returnValue === defer.promise) {
							  defer.reject(new TypeError('Cannot resolve promise with itself'));
						 } else {
							  defer.resolve(returnValue);
						 }
					//}, 1);
			  };

			  return {
					promise: defer.promise,
					callFulfilled: function (value) {
						 if (onFulfilled && onFulfilled.call) {
							  doHandlerCall(onFulfilled, value);
						 } else {
							  defer.resolve(value);
						 }
					},
					callRejected: function (value) {
						 if (onRejected && onRejected.call) {
							  doHandlerCall(onRejected, value);
						 } else {
							  defer.reject(value);
						 }
					}
			  };
		 };

		 // States
		 var PENDING = 0,
			  FULFILLED = 1,
			  REJECTED = 2;

		 ayepromise.defer = function () {
			  var state = PENDING,
					outcome,
					thenHandlers = [];

			  var doFulfill = function (value) {
					state = FULFILLED;
					outcome = value;

					thenHandlers.forEach(function (then) {
						 then.callFulfilled(outcome);
					});
			  };

			  var doReject = function (error) {
				  //console.log("doReject", error, arguments);
					state = REJECTED;
					outcome = arguments;

					thenHandlers.forEach(function (then) {
						 then.callRejected(outcome);
					});
			  };

			  var executeThenHandlerDirectlyIfStateNotPendingAnymore = function (then) {
					if (state === FULFILLED) {
						 then.callFulfilled(outcome);
					} else if (state === REJECTED) {
						 then.callRejected(outcome);
					}
			  };

			  var registerThenHandler = function (onFulfilled, onRejected) {
					var thenHandler = aThenHandler(onFulfilled, onRejected);

					thenHandlers.push(thenHandler);

					executeThenHandlerDirectlyIfStateNotPendingAnymore(thenHandler);

					return thenHandler.promise;
			  };

			  var safelyResolveThenable = function (thenable) {
				  //console.log ("safelyResolveThenable", thenable);
					// Either fulfill, reject or reject with error
					var onceWrapper = once();
					try {
						 thenable(
							  onceWrapper(transparentlyResolveThenablesAndFulfill),
							  onceWrapper(doReject)
						 );
					} catch (e) {
						 onceWrapper(doReject)(e);
					}
			  };

			  var transparentlyResolveThenablesAndFulfill = function (value) {
					var thenable;
					//console.log("transparentlyResolveThenablesAndFulfill", value, arguments);
					try {
						 thenable = getThenableIfExists(value);
					} catch (e) {
						 doReject(e);
						 return;
					}

				  if (thenable) {
						 safelyResolveThenable(thenable);
					} else {
						 doFulfill(arguments);
					}
			  };

			  var onceWrapper = once();
			  return {
					resolve: onceWrapper(transparentlyResolveThenablesAndFulfill),
					reject: onceWrapper(doReject),
					promise: {
						 then: registerThenHandler,
						 fail: function (onRejected) {
							  return registerThenHandler(null, onRejected);
						 },
						 catch: function (onRejected) {
							  return registerThenHandler(null, onRejected);
						 }
					}
			  };
		 };
		 //return ayepromise;
		 app.Deferred = ayepromise.defer;
		 app.defer = ayepromise.defer;
	})(pub);

	pub.timeout = function(time, arg) {
		var dfrd = pub.Deferred();

		if (typeof(time) !== "number")
		{
			arg = time;
			time = void 0;
		}

		setTimeout(function() {
			dfrd.resolve(arg);
		}, time);
		return dfrd.promise;
	};

	pub.uuid =  function () {
		var S4 = function () {
			return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
		};
		return (S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4());
   };

	// compartir
	//SocialSharing.prototype.share = function (message, subject, fileOrFileArray, url, successCallback, errorCallback)
	pub.shareImgUrl = function(msg, url) {
		var dfrd = pub.defer();

		if (window.plugins && plugins.socialsharing)
			window.plugins.socialsharing.share(msg, null, url, null, function(res) {
				dfrd.resolve(res);
			}, function(error) {
				dfrd.reject(error);
			});
		else
			dfrd.reject();
		return dfrd.promise;
	};
	pub.shareImgData = function(filename, data) {
		var dfrd = pub.defer();

		if (window.plugins && plugins.socialsharing)
			window.plugins.socialsharing.share(null, filename, data, null, function(res) {
				dfrd.resolve(res);
			}, function(error) {
				dfrd.reject(error);
			});

		return dfrd.promise;
	};
	pub.shareText = function(msg, title) {
		var dfrd = pub.defer();

		if (window.plugins && plugins.socialsharing)
			window.plugins.socialsharing.share(msg, title, null, null, function(res) {
				dfrd.resolve(res);
			}, function(error) {
				dfrd.reject(error);
			});

		return dfrd.promise;
	};

	return pub;
});

define("http", ["util", "events", "cache"], function(util, events, cache) {
	function http(options) {
		var dfrd = util.Deferred();

		options.method = options.method || "GET";
		options.dataType = options.dataType || "json";

		if (options.method === "GET" && !options.noCache && cache.find(options.url + "?" + $$.serializeObject(options.data)))
		{
			return cache.get(options.url + "?" + $$.serializeObject(options.data));
		}


		events.trigger("ajax:start", [options.data]);

		options.success = function(data) {
			if (typeof(data) === "object" || Array.isArray(data))
				dfrd.resolve(data);
			else
			{
				var d;
				try {
					data = d = JSON.parse(data);
				} catch(e) {
					d= data;
				}
				dfrd.resolve(d);
			}
			if (!options.noCache)
				cache.set(options.url, data);
		};
		options.error = function(xhr, error) {
			//console.error(xhr, error);
			if (xhr.statusText.toLowerCase() === "ok")
				dfrd.resolve();
			else
			{
				dfrd.reject(xhr, error);
				events.trigger("ajax:error", [xhr, error]);
			}
		};
		options.complete = function(xhr, status) {
			events.trigger("ajax:finally", [xhr, status]);
		};

		if (options.method !== "GET")
			options.processData = false;

		options.contentType= options.contentType || "application/json; charset=utf-8";

		$$.ajax(options);
		return dfrd.promise;
	}

	function get(url, data)
	{
		var noCache = false;
		if (data && data.noCache)
		{
			noCache = data.noCache;
			delete data.noCache;
		}
		return http({
			data: data,
			url: url,
			noCache: noCache
		});
	}

	function post(url, data)
	{
		if (typeof(data) === "object")
			data = JSON.stringify(data);

		return http({
			url: url,
			data: data,
			method: "POST"
		});
	}

	return {
		http: http,
		get: get,
		post: post
	};
});

define("cache", ["util"], function(util) {
	var pub = {},
		 cache = [];

	cache = JSON.parse(localStorage.getItem("cache")) || cache;

	for (var i = 0, len = cache.length; i < len; i++)
	{
		if (cache [i] && cache[i].expired < Date.now())
		{
			cache.splice(i, 1);
			i--;
		}
	}

	localStorage.setItem("cache", JSON.stringify(cache));

	function findId(id)
	{
		for (var i = 0, len = cache.length; i < len; i++)
		{
			if (cache[i].id === id)
				return i + 1;
		}
		return 0;
	}

	pub.find = findId;
	pub.get = function(id) {
		var i = findId(id),
			 dfrd = util.Deferred();
		setTimeout(function() {
			if (!i)
				dfrd.reject();
			else
				dfrd.resolve(cache[i - 1].data);
		}, 100);

		return dfrd.promise;
	};

	pub.set = function(id, data) {
		var i = findId(id),
			 expired = data.expired || Date.now() + (1000*60*60*24*7);

		if (i)
		{
			cache[--i].data = data;
			cache[i].expired = expired;
		}
		else
			cache.push({
				id: id,
				data: data,
				expired: expired
			});
		localStorage.setItem("cache", JSON.stringify(cache));
	};

	return pub;
});

define("Json", ["util"], function(util) {
	var pub = {},
		 nill,
		 filter = ['objectId','parent', 'id', 'updatedAt', 'createdAt', 'tarea', 'sync', '__type', 'ndx', 'coments', 'file', 'parentID', 'totalComents', 'unreadComents', 'syncId', 'channel', 'owner', 'links', 'peticiones', 'group'];


	LZString.compress = function (str) {
			if (typeof(str) !== "string")
				return str;
			if (str === nill || str.trim() === "")
				return "";
			else return LZString.compressToUTF16(str);
		};
	LZString.decompress = function (str) {
			var r;
			if (typeof(str) !== "string")
				return str;
			if (str === nill || str.trim() === "")
				return "";
			else
				r = LZString.decompressFromUTF16(str);
			if (!r || r === "null")
				return "";
			else
				return r;
		};

	pub.compress = function(obj, filtro, de) {
		var result = {};
		filtro = filtro || [];
		if (filtro.constructor !== Array)
			filtro = filtro.split(',').map(function(i) {
				return i.trim();
			});

		for(var key in obj)
		{
			if (filtro.indexOf(key) !== -1 || util.esVacio(obj[key]))
					result[key] = obj[key];
			else if (obj[key] instanceof Array === false &&
						obj[key] instanceof Object === false &&
						key.indexOf('_') === -1 &&
						key.indexOf('$') === -1 &&
						filter.indexOf(key) === -1)
			{
				if (de)
					result[key] = LZString.decompress(obj[key]);
				else
					result[key] = LZString.compress(obj[key]);
			}
		}
		return result;
	};
	pub.decompress = function(obj, filtro) {
		return pub.compress(obj, filtro, true);
	};

	pub.excludeKeys = filter;
	return pub;
});

/*window.addEventListener("load", function(event) {
	require(["events"], function(events) {
		setTimeout(function() {
			events.trigger("ready", event);
		}, 500);
	});
}, false);*/


//Object.watch polyfill
/*
* object.watch v0.0.1: Cross-browser object.watch
*
* By Elijah Grey, http://eligrey.com
*
* A shim that partially implements object.watch and object.unwatch
* in browsers that have accessor support.
*
* Public Domain.
* NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.
*/
/*
if (!Object.prototype.watch)
    Object.prototype.watch = function (prop, handler) {
        var oldval = this[prop], newval = oldval,
        getter = function () {
            return newval;
        },
        setter = function (val) {
            oldval = newval;
            return (newval = handler.call(this, prop, oldval, val));
        };
        if (delete this[prop]) { // can't watch constants
            if (Object.defineProperty) // ECMAScript 5
                Object.defineProperty(this, prop, {
                    get: getter,
                    set: setter
                });
            else if (Object.prototype.__defineGetter__ && Object.prototype.__defineSetter__) { // legacy
                Object.prototype.__defineGetter__.call(this, prop, getter);
                Object.prototype.__defineSetter__.call(this, prop, setter);
            }
        }
    };

// object.unwatch
if (!Object.prototype.unwatch)
    Object.prototype.unwatch = function (prop) {
        var val = this[prop];
        delete this[prop]; // remove accessors
        this[prop] = val;
    };
*/
