/* global define, $$, document, vacio, device, require, JPEGEncoder */
/*jslint browser: true, devel: false*/
/*jshint undef: true, unused: false */

define(["util"], function(util) {
	/* Imagen manipulacion
	buscar javascript canvas toDataURL("assets/img/png");
	*/

	var pub = {
			jpegSuport: false,
			init: false
		},
		canvas = document.createElement("canvas");

	if (canvas.toDataURL("image/jpeg").search("image/jpeg") >= 0)
	{
		pub.init = pub.jpegSuport = true;
		/*include("lib/j.js", (function() {
			alert('js.cargado');
			this.init = true;
			alert(biblioImg.init);
		}).call(biblioImg));*/
	}
	else
		pub.init = true;


	function getBase64FromImageUrl(URL)
	{
		var img = new Image(),
			 dfrd = util.defer();

		if (URL.substring(0, 4) === "http")
			img.setAttribute('crossOrigin', 'anonymous');
		img.onload = function () {
			var //canvas = document.createElement("canvas"),
				 dataURL,
				 jpg = null;
			canvas.width = img.width;
			canvas.height = img.height;

			var ctx = canvas.getContext("2d");

			ctx.drawImage(img, 0, 0);
			if (pub.init && !pub.jpegSuport)
			{
				// no soporta JPEG
				jpg = new JPEGEncoder(50);
				dataURL = jpg.encode(ctx.getImageData(0,0,canvas.width,canvas.height));
			}
			else
				dataURL = canvas.toDataURL("image/jpeg");

			dfrd.resolve(dataURL);
		};
		img.onerror = function() {
			dfrd.reject();
		};
		img.setAttribute("src", URL);
		return dfrd.promise;
	}

	function resizeImage(opt)
	{
		var options = {
				url: opt.url || "",
				width: opt. width || 600,
				format: opt.format || "image/jpeg", // image/png - image/webp - image/octet-stream
				quality: opt.quality || 0.5, // 0.1 low -  1.0 high
			},
			dfrd = util.defer();
		//app.alert("comenzamos con el resizeImage");
		if (options.url === "")
			throw "resizeImage necesita {url: 'url de la imagen'}";

		var img = new Image(),
						//canvas,
						ctx;

		if (options.url.substring(0, 4) === "http")
			img.setAttribute('crossOrigin', 'anonymous');
		//canvas = document.createElement("canvas");
		canvas.width = options.width;
		ctx = canvas.getContext("2d");
		//app.alert("ahora biene el onload");
		img.onload = function() {
			if (img.width <= options.width)
			{
				//alert(img.src.length);
				dfrd.resolve(img.src);
				return;
			}
			canvas.height = canvas.width * (img.height / img.width);

			var dataURL,
				 jpg = null;

			ctx.drawImage(img, 0,0,img.width,img.height,0,0,canvas.width, canvas.height);
			if (pub.init && !pub.jpegSuport && options.format === "image/jpeg")
			{
				// no soporta JPEG
				jpg = new JPEGEncoder(options.quality * 100);
				dataURL = jpg.encode(ctx.getImageData(0,0,canvas.width,canvas.height));
			}
			else
				dataURL = canvas.toDataURL(options.format, options.quality);

			dfrd.resolve(dataURL);
		};
		img.onerror = function() {
			dfrd.reject();
		};
		//img.src = options.url;
		img.setAttribute("src", options.url);
		return dfrd.promise;
	}

	function eraseCanvas(canvas, contenedor)
	{
		var _eraseCanvas = function (canvas) {
			var c = canvas.slice(canvas.indexOf("#") +1);
			canvas = document.getElementById(c);
			var ctx = canvas.getContext("2d"),
				 imageData = ctx.getImageData(0,0, canvas.width, canvas.height),
				 d = imageData.data,
				 L = d.length;

			for ( var i = 3; i < L; i += 4 )
			{
				d[i] = 0;
			}
			ctx.putImageData(imageData, 0,0);
			/*ctx.clearRect(0, 0, canvas.width, canvas.height);
			var w = canvas.width;

			canvas.width = 1;
			canvas.width = w;*/
		};

		if (!contenedor)
		{
			setTimeout(function() {
				_eraseCanvas(canvas);
			});
			return;
		}
		var $contenedor = document.getElementById(contenedor.slice(contenedor.indexOf("#") +1)),
			c = canvas.slice(canvas.indexOf("#") +1),
			$oldCanvas = document.getElementById(c),
			$canvas = document.createElement('canvas');
		if (!$contenedor)
			$contenedor = document.getElementsByClassName(contenedor.slice(contenedor.indexOf(".") +1))[0];
		//alert($contenedor.style.height);
		$canvas.style.width = $oldCanvas.style.width;
		$canvas.style.height = $oldCanvas.style.height;
		$contenedor.removeChild($oldCanvas);
		$canvas.setAttribute("id", c);
		$contenedor.appendChild($canvas);
	}

	pub.getBase64FromImageUrl = getBase64FromImageUrl;
	pub.resizeImage = resizeImage;
	pub.eraseCanvas = eraseCanvas;

	return pub;
});
