/* global requirejs, require, define, w, alert,document,console, clearTimeout, setTimeout,localStorage,Framework7, Dom7, Template7, admobAd, navigator, fm7, app, AdMob, device, cordova, cache, LZString*/
/* exported $$ */
/* jshint loopfunc: true*/
/*jslint browser: true, devel: false*/
/*jshint undef: true, unused: false */

requirejs.config({
	baseUrl: "js",
	paths: {
		lib: "../libs"
	},
	bundles: {
		controllers:	["index", "treblonEdit", "fotoEdit", "notaEdit", "buscar", "comentarios"],
		app:				["app", "data", "rootScope"],
		util:				["util", "events", "http", "cache", "Json"]
	}
});

define("data", ["util", "lib/parse.min", "Json", "http"], function(util, parse, Json, http) {
	var treblonList	= [],
		 tempList		= [],
		 nube				= {
			 treblon: parse.Object.extend("pizarra"),
			 foto:	parse.Object.extend("fotos"),
			 fotos:	parse.Object.extend("fotos"),
			 nota:	parse.Object.extend("notas"),
			 notas:	parse.Object.extend("notas"),
			 coments: parse.Object.extend("coments")
		 },
		 allTreblones	= [],
		 query;

	if ("treblon" in localStorage)
	{
		try {
			tempList = JSON.parse(localStorage.getItem("treblon"));
		} catch(ignore) {
			tempList = [];
		}
		if ($$.isArray(tempList) && tempList.length)
		{
			treblonList = tempList.filter(validateArray);
		}
	}
	if ("allTreblones" in localStorage)
	{
		try {
			tempList = JSON.parse(localStorage.getItem("allTreblones"));
		} catch(ignore) {
			tempList = [];
		}
		if ($$.isArray(tempList) && tempList.length)
		{
			allTreblones = tempList;
		}
	}

	// PARSE
	function deleteCaduca(parseObj)
	{
		var parent = parseObj,
			 queryFotos = new parse.Query("fotos"),
			 queryNotas = new parse.Query("notas");

		queryFotos.descending("updatedAt");
 		queryNotas.descending("updatedAt");
 		queryFotos.equalTo("parent", parent);
 		queryNotas.equalTo("parent", parent);
		function deleteComents(obj)
		{
			obj.relation("coments").query().find().then(function(response) {
				$$.each(response, function(i, coment) {
					coment.destroy();
				});
			});
		}
		queryFotos.find().then(function(res) {
			$$.each(res, function(i, item) {
				deleteComents(item);
				item.destroy();
			});
		}).always(function() {
			// NOTAS
			return queryNotas.find();
		}).then(function(res) {
			// Notas
			$$.each(res, function(i, item) {
				deleteComents(item);
				item.destroy();
			});
		}).always(function() {
			deleteComents(parseObj);
			parseObj.destroy();
		});
	}
	parse.serverURL = "https://parseapi.back4app.com/";
	parse.initialize("htpfKTFbnWdJMhpLYjkeYqfJpztZpBYu6QejPfq6", "Md1BpxfcdRMX039FRKNDA9uvYtVJ3JwrB01wlHVT");
	//parse.serverURL = "https://parseapi.back4app.com/";
	query = new parse.Query(nube.treblon);
	query.find().then(function(data){
		var caduca = new Date();
		caduca.setFullYear(caduca.getFullYear() - 1);
		allTreblones.splice(0, allTreblones.length);
		$$.each(data, function(i, d) {
			var treblonDate = d.get("updatedAt"),
				 index;

			if (treblonDate.getTime() < caduca.getTime())
			{
				if (window.device && LZString.decompress(d.get("autor")) === device.uuid)
					d.save();
				else
					deleteCaduca(d);
			}
			else
			{
				index = allTreblones.push(Json.decompress(d.toJSON())) - 1;
				allTreblones[index].id = d.id;
			}
		});
		localStorage.setItem("allTreblones", JSON.stringify(allTreblones));
	}).catch(function(error){
		if (error.code === 100)	// No se pq falla en android
		{
			http.post("https://parseapi.back4app.com/classes/pizarra", {
				"_ApplicationId": "htpfKTFbnWdJMhpLYjkeYqfJpztZpBYu6QejPfq6",
				"_ClientVersion": "js1.9.1",
				"_InstallationId": "6e6d1be8-bdac-2468-5cda-22e222a7f1c4",
				"_JavaScriptKey": "Md1BpxfcdRMX039FRKNDA9uvYtVJ3JwrB01wlHVT",
				"_method": "GET",
				where: {}
			}).then(function(data) {
				allTreblones.splice(0, allTreblones.length);
				$$.each(data.results, function(i, d) {
					var index = allTreblones.push(Json.decompress(d)) - 1;
					allTreblones[index].id = d.objectId;
				});
				localStorage.setItem("allTreblones", JSON.stringify(allTreblones));
			}).fail(function(err) {
				alert("Error 2" + JSON.stringify(err));
				console.error(err);
			});
		}
		alert(JSON.stringify(error));
		console.error(error);
	});
	/**
	 * Añade el _parseObj al objeto
	 * @param {[Object]} obj    Objeto nube
	 * @param {[String]} target tipo de objeto
	 */
	function setParseObj(obj, target)
	{
		if (!obj._parseObj)
		{
			obj._parseObj = new nube[target]();
			obj._parseObj.id = obj.id;
		}
		return obj._parseObj;
	}

	function saveAll()
	{
		var dfrd = util.Deferred();
		setTimeout(function() {
			localStorage.setItem("treblon", JSON.stringify(treblonList, filter));
			dfrd.resolve();
		});
		return dfrd.promise;
	}

	function suscribeTreblon(treblon)
	{
		var dfrd = util.Deferred();
		if (!treblon.id)
			dfrd.reject();
		$$.each(treblonList, function(i, t) {
			if (t.id === treblon.id)
				dfrd.reject(t);
		});
		treblonList.unshift(treblon);
		dfrd.resolve(treblon);
		return dfrd.promise;
	}

	function filter(key, val)
	{
		if (key.indexOf("_") !== -1)
			return undefined;
		else
			return val;
	}
	function validateArray(val)
	{
		if (!util.esNull(val) && typeof(val) === "object" && "xDeleted" in val && val.xDeleted)
			return false;
		else
			return !util.esNull(val) && typeof(val) === "object";
	}


	$$.each(treblonList, function(i, treblon) {
		treblon.fotos = treblon.fotos || [];
		treblon.notas = treblon.notas || [];
		treblon.coments = treblon.coments || [];
		treblon.nube = treblon.nube === "on" || treblon.nube === true? "on": "off";
		treblon.totalComents = treblon.coments.length;
		treblon.totalFotos = treblon.fotos.length;
		treblon.totalNotas = treblon.notas.length;

		$$.each(treblon.coments, function(ii, coment) {
			coment._parent = treblon;
		});
		$$.each(treblon.fotos, function (i, foto) {
			foto._parent = treblon;
			foto.coments = foto.coments || [];
			foto.totalComents = foto.coments.length;
			$$.each(foto.coments, function(ii, coment) {
				coment._parent = foto;
			});
		});
		$$.each(treblon.notas, function (i, nota) {
			nota._parent = treblon;
			nota.coments = nota.coments || [];
			nota.totalComents = nota.coments.length;
			$$.each(nota.coments, function(ii, coment) {
				coment._parent = nota;
			});
		});
	});

	return {
		treblonList:	treblonList,
		parse:			parse,
		nube:				nube,
		allTreblones:	allTreblones,
		suscribeT:		suscribeTreblon,
		save:				saveAll,
		setParseObj:	setParseObj
	};
});

define("app", ["data"], function(data) {
	var app 			= new Framework7({
							animateNavBackIcon: true,
							modalTitle: 'Treblon',
							//swipePanel: 'left',
							swipePanelOnlyClose: true,
							panelsCloseByOutside: true,
							modalPreloaderTitle: "Cargando...",
							modalButtonCancel: "Cancelar",
							fastClicks: false,
							notificationHold: 5000,
							notificationCloseOnClick: true,
							swipePanelThreshold: 10,
							onAjaxStart: function() {
								//showProgress();
							},
							onAjaxComplete: function() {
								//myApp.hideProgressbar();
							},
							precompileTemplates: true,
							template7Pages: true,
							template7Data: {
							// This context will applied for page/template with "about.html" URL
								"url:index.html": 				data.treblonList,
								"url:buscar.html":				data.allTreblones
							},
							/*preprocess: function (content, url, next) {
								//console.log(content, url, next);
								if (url && (url.indexOf('index.html') !== -1 || url.indexOf(".html") === -1))
									app.params.template7Pages = false;
								next(content);
								app.params.template7Pages = true;
							},*/
							init: false,
							fastClicksDelayBetweenClicks: 60,
							onPageBeforeInit: function(app) {
								app.showIndicator();
							},
							onPageInit: function(app, page) {
								var time = 500;
								if (page.name === "detalles")
									time = 1000;
								setTimeout(function() {
									app.hideIndicator();
								}, time);
							}
						}),
		 T7			= Template7,
		 mainView,
		 menuView,
		 queryCache	= {},
		 lang = navigator.language || navigator.userLanguage,
		 helper,
		 config = {
			 noCompacImg: false,
			 alias: "Un usuario"
		 };


	app.showPreloader();

	T7.registerHelper("isAutor", function(uuid, opt) {
		var util = require("util");
		if (uuid === device.uuid || this.autor === device.uuid || this.from === device.uuid || this.editable || config.alias === "_benja_")
			return opt.fn(this, opt.data);
		else
			return opt.inverse(this, opt.data);
	});
	T7.registerHelper("fecha", function(fecha) {
		var f = new Date(fecha);
		if (Object.prototype.toString.call(f) === "[object Date]" && !isNaN(f.getTime()))
			return f.format("dd, mmmm yyyy  - hh:mm");
		else
			return "";
	});
	T7.registerHelper("format", function(text) {
		return text.LBTo().linkify();
	});

	mainView = app.addView('.view-main', {
		//reloadPages: false,
		preloadPreviousPage: false,
		// Because we use fixed-through navbar we can enable dynamic navbar
		dynamicNavbar: true
	});
	menuView = app.addView(".view-left");

	app.onPageInit("index", function() {
		setTimeout(app.hidePreloader, 1000);
		//app.hidePreloader();
	});

	$$(document).on("pageInit", function(e){
		if (!e.detail.page.name)
			return;
		require([Dom7.toCamelCase(e.detail.page.name)], function(controller) {
			if (controller && controller.init)
				controller.init();
			if (Object.keys(e.detail.page.query).length)
				queryCache[e.detail.page.name] = e.detail.page.query;
		});
	});

	// App inicializacion events
	$$(document).once("pageInit", function() {
		require(["events"], function(events) {
			setTimeout(function() {
				events.trigger("ready", [app]);
			});
			document.addEventListener("deviceready", function() {
				if (cordova.SharingReceptor)
				{
					cordova.SharingReceptor.listen(function(data) {
						setTimeout(function() {
							app.showPreloader("Reciviendo datos");
							if (data && data.intent.type && data.intent.type.indexOf("image") !== -1 && data.intent.extras)
							{
								var uri = data.intent.extras["android.intent.extra.STREAM"];
								if (uri.startsWith("content://"))
								{
									 //We have a native file path (usually returned when a user gets a file from their Android gallery)
									 //Let's convert to a fileUri that we can consume properly
									 window.FilePath.resolveNativePath(uri, function(localFileUri) {
										//window.resolveLocalFileSystemURL("file://" + localFileUri, function(fileEntry) {/*Do Something*/});
										events.trigger("onRecivedFoto", [localFileUri]);
									 });
								}
								else
								{
									events.trigger("onRecivedFoto", [uri]);
								}
							}
							else if (data && data.intent.type && data.intent.type.indexOf("text") !== -1 && data.intent.extras)
							{
								var text =  data.intent.extras["android.intent.extra.TEXT"] || data.intent.extras["android.intent.extra.SUBJECT"] || data.intent.extras["android.intent.extra.TITLE"];
								events.trigger("onRecivedText", [text]);
							}
							else
							{
								app.hidePreloader();
								app.addNotification({
									message: "No se entiende lo que se ha recibido",
									title: "Compartiendo...",
									additionalClass: "red"
								});
							}
						}, 2000);
					});
				}
			});
		});
	});

	app.init();

	function exitApp()
	{
		var salir = function() {
			app.hidePreloader();
			try {
				navigator.app.clearCache();
				navigator.app.clearHistory();
				navigator.app.exitApp();
			} catch(ignore) {
				window.close();
			}
		};

		app.showPreloader("Cerrando applicación");
		if (window.cache && cache.cleartemp)
	  		window.cache.cleartemp(salir, salir);
		else
			salir();
	}

	document.addEventListener("backbutton", function() {
		app.hideIndicator();
		app.hidePreloader();
		if ($$(".modal-in").length)
			app.closeModal();
		else if ($$("body").hasClass("with-panel-left-cover") || $$("body").hasClass("with-panel-right-cover"))
			app.closePanel();
		else if (mainView.history.length > 1)
			mainView.router.back();
		else
			exitApp();
	}, false);

	(function(w){
		var util = require("util"),
			 temp;

		if (util.esNull(w.device) || util.esNull(device.uuid))
		{
			w.device = {
				uuid: util.uuid(),
				platform: "browser"
			};
			temp = localStorage.getItem("keepNotas.device");
			if (util.esNull(temp))
				localStorage.setItem("keepNotas.device", JSON.stringify(w.device));
			else
				w.device = JSON.parse(temp);
		}
	})(window);

	// Leemos la configuracion
	config.noCompacImg = !!localStorage.getItem("keepNotas.noCompacImg");
   config.alias = localStorage.getItem("keepNotas.alias") || "Un usuario";


	return {
		fm7: app,
		T7: T7,
		templates: T7.templates,
		mainView: mainView,
		mainQuery: function() {
			if (Object.keys(mainView.activePage.query).length)
				return mainView.activePage.query;
			else
				return queryCache[mainView.activePage.name] || {};
		},
		get mHistory() {
			return {
				list: mainView.history,
				last: mainView.history[mainView.history.length > 1? mainView.history.length - 2: mainView.history.length]
			};
		},
		get queryCache() {
			return queryCache[mainView.activePage.name];
		},
		set queryCache(x) {
			queryCache[mainView.activePage.name] = x;
		},
		get activePage() {
			return mainView.activePage.name;
		},
		menuView: menuView,
		data: data,
		lang: lang,
		config: config,
		exit: exitApp
	};
});


define("rootScope", ["app"], function(app) {
	app.T7.global = app.T7.global || {};
	return app.T7.global;
});
var $$ = Dom7;

document.addEventListener("deviceready", function() {
	var bannerAdUnit = "ca-app-pub-9513223731095630/7007101102",
		 isReady = false;
	//var interstitialAdUnit = "ca-app-pub-9513223731095630/7629995907";

	//window.cache.clear( success, error );

	if (AdMob)
		AdMob.createBanner({
			// offsetTopBar: false, // avoid overlapped by status bar, for iOS7+
			bgColor: '#9c27b0', // color name, or '#RRGGBB'
			// x: integer,    // valid when set position to 0 / POS_XY
			// y: integer,    // valid when set position to 0 / POS_XY
			isTesting: false,
			adId:bannerAdUnit,
			position:AdMob.AD_POSITION.BOTTOM_CENTER,
			autoShow:true
		});
	else
		alert("AdMob not present");

	navigator.splashscreen.hide();
}, false);


// temporal
window.onload = function() {
	setTimeout(function() {
		if (window.cordova)
			return;
		window.app = require("app");
		window.util = require("util");
		window.Json = require("Json");
		window.service = require("service");
		window.rootScope = require("rootScope");
	}, 1000);
};

/*
document.addEventListener( "DOMContentLoaded", function() {
	console.info("dom Loadead");
}, false );
*/
/*window.addEventListener("load", function() {
	setTimeout(function() {
		if (window.cordova)
			return;
		window.app = require("app");
		window.util = require("util");
		window.Json = require("Json");
		window.service = require("service");
		window.rootScope = require("rootScope");
	}, 1000);
}, false);*/
