/* global define, $$, LZString, vacio, Json, device*/
/*jslint browser: true, devel: false*/
/*jshint undef: true, unused: false */

define("service", ["data", "events", "util", "Json", "http"], function(data, events, util, Json, http) {
	var pub = {};

	/**
	 * [saveTreblon description]
	 * @param  {[Object]} treblon [description]
	 * @return {[Promise]}         [description]
	 */
	pub.saveTreblon = function(treblon) {
		var nube = data.setParseObj(treblon, "treblon");

		nube.set("nombre", LZString.compress(treblon.nombre));
		nube.set("descripcion", LZString.compress(treblon.descripcion));
		nube.set("clave", LZString.compress(treblon.clave));
		nube.set("color", LZString.compress(treblon.color));
		nube.set("autor", LZString.compress(treblon.autor));
		nube.save().then(function(d) {
			treblon.updatedAt = d.get("updatedAt").toISOString();
			treblon.id = d.id;
			data.save();
			events.trigger("onTreblonSaved", treblon);
			// Comprobamos si el treblon tiene fotos y notas sin publicar
			if (treblon.fotos)
			{
				$$.each(treblon.fotos, function(i, foto) {
					foto.parent = treblon;
					if (!foto.id)
					{
						pub.saveFoto(foto, true /*no update parent*/).then(function() {
							data.save();
						});
					}
				});
			}
			if (treblon.notas)
			{
				$$.each(treblon.notas, function(i, nota) {
					nota.parent = treblon;
					if (!nota.id)
						pub.saveNota(nota, true /*no update parent*/).then(function() {
							data.save();
						});
				});
			}
		}).fail(function(error) {
			events.trigger("onTreblonSavedError", [treblon, error]);
		});
	};
	pub.syncTreblon = function(treblon) {
		var query = new data.parse.Query(data.nube.treblon),
			 treblonDate = new Date(treblon.updatedAt),
			 dfrd = util.Deferred();

		if (!treblon.id)
		{
			return dfrd.promise;
		}

		query.get(treblon.id).then(function(_data) {
			var recived = Json.decompress(_data.toJSON(), "updatedAt");

			treblon._parseObj = _data;
			treblon.nube = "on";

			if (!treblon.updatedAt)
			{
				util.extend(recived, treblon);
				dfrd.resolve(_data);
			}

			if (treblon.clave !== recived.clave)
			{
				dfrd.resolve(_data);
				return;
			}

			if (treblon.updatedAt.substring(0,20) === recived.updatedAt.substring(0,20))
			{
				// Son iguales
				if (util.esVacio(treblon.fotos) || util.esVacio(treblon.notas))
					dfrd.resolve(_data);
				return;
			}

			if (treblonDate < _data.get("updatedAt"))
			{
				// Local mas viejo
				util.extend(recived, treblon);
				dfrd.resolve(_data);
			}
			else
			{
				_data.set("nombre", LZString.compress(treblon.nombre));
				_data.set("descripcion", LZString.compress(treblon.descripcion));
				_data.set("clave", LZString.compress(treblon.clave));
				_data.set("color", LZString.compress(treblon.color));
				_data.set("autor", LZString.compress(treblon.autor));
				_data.save().then(function(d) {
					treblon.updatedAt = d.get("updatedAt").toISOString();
					data.save();
				});
			}
		}).catch(function(err) {
			if (err.code === 101) // Object Not Found
			{
				// El treblon ha sido eliminado de la nube
				if (treblon.autor === device.uuid)
					pub.saveTreblon(treblon);
				else
					dfrd.reject(err);
			}
			else
				dfrd.reject(err);
		});

		return dfrd.promise;
	};

	pub.syncContent = function(treblon) {
		var parent = treblon._parseObj,
			 queryFotos = new data.parse.Query("fotos"),
			 queryNotas = new data.parse.Query("notas"),
			 queryComen = new data.parse.Query("coments"),
			 promise		= new data.parse.Promise();

		if (util.esNull(treblon.id))
			return;

		queryFotos.descending("updatedAt");
		queryNotas.descending("updatedAt");
		queryComen.ascending("updatedAt");
		queryFotos.equalTo("parent", parent);
		queryNotas.equalTo("parent", parent);
		queryComen.equalTo("parent", parent);

		// FOTOS
		queryFotos.find().then(function(res) {
			var fotosRecived = [];

			if (!treblon.fotos)
				treblon.fotos = [];

			$$.each(res, function(i, item) {
				fotosRecived.push(Json.decompress(item.toJSON(), "updatedAt"));
				fotosRecived[i].id = item.id;
				fotosRecived[i]._parseObj = item;
				fotosRecived[i]._parent = treblon;
				if (!fotosRecived[i].img && !fotosRecived[i].foto)
				{
					fotosRecived[i].img = item.get("file");
					fotosRecived[i].foto = fotosRecived[i].img;
				}
			});

			if (treblon.fotos.length !== res.length || (treblon.fotos.length && res.length && treblon.fotos[0].updatedAt !== fotosRecived[0].updatedAt))
			{
				treblon.unreadFotos = res.length - treblon.fotos.length;
				treblon.totalFotos = res.length;
				treblon.fotos = fotosRecived;
				events.trigger("onTreblonFotosUpdate", [fotosRecived]);
			}
		}).catch(function(error) {
			promise.reject(error);
		}).always(function() {
			// NOTAS
			queryNotas.find().then(function(res) {
				var notasRecived = [];

				if (!treblon.notas)
					treblon.notas = [];

				$$.each(res, function(i, item) {
					notasRecived.push(Json.decompress(item.toJSON(), "updatedAt"));
					notasRecived[i].id = item.id;
					notasRecived[i]._parseObj = item;
					notasRecived[i]._parent = treblon;
				});

				if (treblon.notas.length !== res.length || (treblon.notas.length && res.length && treblon.notas[0].updatedAt !== notasRecived[0].updatedAt))
				{
					treblon.unreadNotas = res.length - treblon.notas.length;
					treblon.totalNotas = res.length;
					treblon.notas = notasRecived;
					events.trigger("onTreblonNotasUpdate", [notasRecived]);
				}
				promise.resolve();
			}).catch(function(error) {
				promise.reject(error);
			});
		});
		return promise;
	};

	pub.syncComent = function(obj) {
		var coments = obj._parseObj.relation("coments"),
			 dfrd = util.Deferred();

		if (!obj.coments)
			obj.coments = [];

		coments.query().ascending("updatedAt").find().then(function(response) {
			var comentsRecived = [];
			$$.each(response, function(i, coment) {
				comentsRecived.push(Json.decompress(coment.toJSON()));
				comentsRecived[i].id = coment.id;
				comentsRecived[i]._parent = obj;
				comentsRecived[i]._parseObj = coment;
				comentsRecived[i].updatedAt = coment.updatedAt;
			});
			obj.unreadComents = response.length - (obj.totalComents || 0);
			obj.totalComents =  response.length;

			obj.coments = comentsRecived;
			dfrd.resolve(comentsRecived);
		}).fail(function(error) {
			dfrd.reject(error);
		});

		return dfrd.promise;
	};

	function deleteAllComents(obj)
	{
		var dfrd = util.defer(),
			 coments = obj._parseObj.relation("coments");


		coments.query().find().then(function(response) {
			$$.each(response, function(i, coment) {
				coment.destroy();
			});
			obj.totalComents =  0;

			obj.coments =[];
			dfrd.resolve(response);
		}).fail(function(error) {
			dfrd.reject(error);
		});
		return dfrd.promise;
	}

	pub.saveComent =  function(coment) {
		var dfrd = util.defer();

		if (!coment._parent)
			return;

		data.setParseObj(coment, "coments").set("msg", LZString.compress(coment.msg));
		coment._parseObj.set("from", LZString.compress(coment.from));
		coment._parseObj.set("alias", LZString.compress(coment.alias));
		coment._parseObj.save().then(function(parseObj) {
			coment.updatedAt = parseObj.get("updatedAt").toISOString();
			coment.id = parseObj.id;
			coment._parseObj = parseObj;
			if (!coment._parent._parseObj.id)
				coment._parent._parseObj.id = coment._parent.id;
			coment._parent._parseObj.relation("coments").add(parseObj);
			return coment._parent._parseObj.save();
		}).then(function(parent) {
			coment._parent.updatedAt = parent.get("updatedAt").toISOString();
			dfrd.resolve(coment);
		}).catch(function(error) {
			if (coment.id && coment._parseObj)
				coment._parseObj.destroy();
			dfrd.reject(error);
		});
		return dfrd.promise;
	};
	pub.deleteComent = function(coment) {
		if (!coment.id)
			return util.defer().promise;

		data.setParseObj(coment, "coments");

		if (coment._parent._parseObj)
		{
			coment._parent._parseObj.relation("coments").remove(coment._parseObj);
			coment._parent._parseObj.save().then(function(res) {
				coment._parent.updatedAt = res.get("updatedAt").toISOString();
				data.save();
			});
		}
		return coment._parseObj.destroy();
	};

	pub.saveFoto = function(foto, noUpdateParent) {
		var file = new data.parse.File(Date.now().toString(), {base64: foto.foto}),
			 tum	= new data.parse.File(Date.now().toString(), {base64: foto.img}),
			 dfrd	= util.defer();

		data.setParseObj(foto, "foto");

		file.save().then(function() {
			return tum.save();
		}, function(error) {
			dfrd.resolve(error);
		}).then(function() {
			foto._parseObj.set("cab", LZString.compress(foto.cab));
			foto._parseObj.set("pie", LZString.compress(foto.pie));
			foto._parseObj.set("editable", foto.editable);
			foto._parseObj.set("autor", LZString.compress(foto.autor));
			foto._parseObj.set("donde", LZString.compress("parse"));
			foto._parseObj.set("foto", LZString.compress(file.url()));
			foto._parseObj.set("img", LZString.compress(tum.url()));
			foto._parseObj.set("parent", foto._parent._parseObj);
			foto._parseObj.set("color", LZString.compress(foto.color));
			return foto._parseObj.save();
		}, function(error) {
			dfrd.reject(error);
			deleteFile(file.url());
		}).then(function(parseObj) {
			foto.updatedAt = parseObj.get("updatedAt").toISOString();
			foto.id = parseObj.id;
			foto.img = tum.url();
			foto.foto = file.url();
			foto._parseObj = parseObj;
			if (!noUpdateParent)
				foto._parent._parseObj.save().then(function(res) {
					foto._parent.updatedAt = res.get("updatedAt").toISOString();
					data.save();
				});

			dfrd.resolve(foto);
		}).catch(function(error) {
			dfrd.reject(error);
			deleteFile(file.url());
			deleteFile(tum.url());
		});

		return dfrd.promise;
	};
	pub.updateFoto = function(foto) {
		var dfrd = util.defer();

		if (!foto.id)
		{
			dfrd.reject("No tiene ID");
			return dfrd.promise;
		}
		data.setParseObj(foto, "foto").set("cab", LZString.compress(foto.cab));
		foto._parseObj.set("pie", LZString.compress(foto.pie));
		foto._parseObj.set("editable", foto.editable);
		foto._parseObj.set("autor", LZString.compress(foto.autor));
		foto._parseObj.set("donde", LZString.compress("parse"));
		foto._parseObj.save().then(function(parseObj) {
			foto.updatedAt = parseObj.get("updatedAt").toISOString();
			return foto._parent._parseObj.save();
		}).then(function(res) {
			foto._parent.updatedAt = res.get("updatedAt").toISOString();
			data.save();
			dfrd.resolve(foto);
		}).catch(function(error) {
			dfrd.reject(error);
		});

		return dfrd.promise;
	};
	pub.deleteFoto = function(foto, noUpdateParent) {
		var dfrd = util.defer();

		if (!foto.id)
			return dfrd.promise;
		data.setParseObj(foto, "foto").destroy().then(function() {
			var urlImg,
				 urlFoto;
			deleteFile(foto.img);
			deleteFile(foto.foto);

			if (!noUpdateParent && foto.parent && foto.parent._parseObj)
			{
				foto.parent._parseObj.save().then(function(res) {
					foto.parent.updatedAt = res.get("updatedAt").toISOString();
				});
			}
			deleteAllComents(foto);
			dfrd.resolve();
		}).catch(function(error) {
			dfrd.reject(error);
		});
		return dfrd.promise;
	};

	function deleteFile(url)
	{
		var filename = url.split("/");
		filename = filename[filename.length-1];
		return http.http({
			url: "https://parseapi.back4app.com/files/" + filename,
			headers: {
				"x-parse-application-id": "htpfKTFbnWdJMhpLYjkeYqfJpztZpBYu6QejPfq6",
				"x-parse-master-key": "GI2iAfhAVlgjFKTye53oQVjwFHnNlJjrmunqGIgL"
			},
			method: "DELETE"
		});
	}
	pub.deleteFile = deleteFile;

	pub.saveNota = function(nota, noUpdateParent) {
		var dfrd = util.defer();

		data.setParseObj(nota, "nota").set("titulo", LZString.compress(nota.titulo));
		nota._parseObj.set("detalle", LZString.compress(nota.detalle));
		nota._parseObj.set("autor", LZString.compress(nota.autor));
		nota._parseObj.set("editable", nota.editable);
		nota._parseObj.set("parent", nota._parent._parseObj);
		nota._parseObj.save().then(function(parseObj) {
			nota._parseObj = parseObj;
			nota.id = parseObj.id;
			nota.updatedAt = parseObj.get("updatedAt").toISOString();
			if (!noUpdateParent)
				return nota._parent._parseObj.save();
		}).then(function(res) {
			if (res)
				nota._parent.updatedAt = res.get("updatedAt").toISOString();
			dfrd.resolve(nota);
		}).catch(function(error) {
			dfrd.reject(error);
		});
		return dfrd.promise;
	};
	pub.deleteNota = function(nota, noUpdateParent) {
		var dfrd = util.defer();
		if (!nota.id)
			return dfrd.promise;
		data.setParseObj(nota, "nota").destroy().then(function() {
			if (!noUpdateParent && nota.parent && nota.parent._parseObj)
			{
				nota.parent._parseObj.save();
			}
			deleteAllComents(nota);
			dfrd.resolve();
		}).catch(function(error) {
			dfrd.reject(error);
		});
		return dfrd.promise;
	};

	pub.deleteTreblon = function(treblon) {
		var dfrd = util.defer();

		if (!treblon.id)
			return dfrd.promise;

		data.setParseObj(treblon, "treblon");

		$$.each(treblon.fotos, function(i, foto) {
			pub.deleteFoto(foto, true);
		});
		$$.each(treblon.notas, function(i, nota) {
			pub.deleteNota(nota, true);
		});
		treblon._parseObj.destroy().then(function() {
			deleteAllComents(treblon);
			delete treblon.id;
			dfrd.resolve();
		}).catch(function(error) {
			dfrd.reject(error);
		});
		return dfrd.promise;
	};

	return pub;
});
