/* global define, $$, cordova, LocalFileSystem */
/*jslint browser: true, devel: false*/
/*jshint undef: true, unused: false */

define(["util"], function(util) {
	var fileEntry,
		 dirEntry;

	function invoke(options)
	{
		var dfrd = util.defer(),
			 location = window.PERSISTENT;

		options = util.extend(options, {
			cache:	false,
			documents: false,
			sdcard:	true
		});

		if (window.cordova && window.cordova.file)
		{
			if (options.sdcard)
			{
				if (options.documents)
					location = cordova.file.externalDataDirectory;
				else
					location = cordova.file.externalRootDirectory;
				if (options.cache)
					location = cordova.file.externalCacheDirectry;
			}
			else
			{
				if (options.cache)
					location = cordova.file.cacheDirectry;
				else
					location = cordova.file.dataDirectory;
			}
		}
		window.resolveLocalFileSystemURL(location, function(dir) {
			dirEntry = dir;
			dfrd.resolve(dir);
		}, function() {
			window.requestFileSystem(LocalFileSystem.PERSISTENT, 0, function(dir) {
				dirEntry = dir;
				dfrd.resolve(dir);
			}, function(error) {
				dfrd.reject(error);
			});
		});

		return dfrd.promise;
	}

	function accessDir(rootDirEntry, folders, promise)
	{
		promise = promise || util.defer();
		dirEntry = rootDirEntry;
		if (typeof(folders) === "string")
			folders = folders.split("/");

		// Throw out './' or '/' and move on to prevent something like '/foo/.//bar'.
		if (folders[0] === '.' || folders[0] === '')
			folders.splice(0, 1);

		if (!folders.length)
		{
			promise.resolve(dirEntry);
			return promise.promise;
		}
		rootDirEntry.getDirectory(folders[0], {create: true}, function(_dirEntry) {
			if (folders.length)
				accessDir(_dirEntry, folders.slice(1), promise);
			else
			{
				dirEntry = _dirEntry;
				promise.resolve(dirEntry);
			}
		}, function(e){
			//console.log("error crando dir ", e);
			promise.fail(e);
		});

		return promise.promise;
	}

	function getFile(filename, fs)
	{
		var dfrd = util.defer();

		fs = fs || dirEntry;
		fs.getFile(filename, {create:true, exclusive: false}, function(file) {
			//console.log("got the file", file);
			fileEntry = file;
			dfrd.resolve(file);
		}, function(e) {
			//console.log("getFile error ", e);
			dfrd.reject(e);
		});
		return dfrd.promise;
	}

	function write(text, file)
	{
		var writer,
			 dfrd = util.defer();

		file = file || fileEntry;

		file.createWriter(function(writer) {
			writer.onerror = dfrd.reject;
			writer.onwriteend = dfrd.resolve;
			try {
				writer.write(text);
			} catch(e) {
				writer.write(new Blob([text], {type: "text/plain"}));
			}
		}, function(error) {
			dfrd.reject(error);
		});

		return dfrd.promise;
	}

	function read(file)
	{
		var dfrd = util.defer();

		file = file || fileEntry;
		file.file(function (dbFile) {
			var reader = new FileReader();
			reader.onloadend = function (evt) {
				if (evt.target.readyState !== FileReader.DONE)
					return;
				if (evt.target.error)
				{
					/*switch(evt.target.error.code) {
						case evt.target.error.NOT_FOUND_ERR:
						  alert('File Not Found!');
						  break;
						case evt.target.error.NOT_READABLE_ERR:
						  alert('File is not readable');
						  break;
						case evt.target.error.ABORT_ERR:
						  break; // noop
						default:
						  alert('An error occurred reading this file.');
					};*/
					dfrd.reject(evt.target.error);
				}
				else
					dfrd.resolve(evt.target.result);
			};
			reader.readAsText(dbFile);
		}, function(error) {
			dfrd.reject(error);
		});

		return dfrd.promise;
	}

	function download(text, name, mime)
	{
		var a = document.createElement("a"),
			 file = new Blob([text], {type: mime || "image/jpeg"});
		//var file = new Blob([text], {type: type});
		a.href = URL.createObjectURL(file);
		//console.log(URL.createObjectURL(file));
		//console.log(text, name, a);
		a.download = name;
		a.setAttribute("class","external");
		document.body.appendChild(a);
		a.click();
		document.getElementsByTagName('body')[0].removeChild(a);
	}
	return {
		invoke: invoke,
		accessDir: accessDir,
		getFile: getFile,
		write: write,
		read: read,
		download: download
	};
});
