var AI = (function(Matrix, Point){
	
	var AI = {};

	var mapsize;

	AI.init = function(m){
		mapsize = m;

		this.lines = new Matrix(mapsize, mapsize, {
			fn: function(){
				return new Matrix(mapsize, mapsize, {def : 0});
			}
		});

		this.lines2 = new Matrix(mapsize, mapsize, {
			fn: function(){
				return new Matrix(mapsize, mapsize, {def : 0});
			}
		});

		this.line_van = new Matrix(mapsize, mapsize, {def: 0})
	};

	function calc_lines2(m){
		var r = new Matrix(mapsize, mapsize, {
			fn: function(){
				return new Matrix(mapsize, mapsize, {def : 0});
			}
		});

		for (var ix = 0; ix < mapsize; ++ix)
		for (var iy = 0; iy < mapsize; ++iy){

			for (var jx = 0; jx < mapsize; ++jx)
			for (var jy = 0; jy < mapsize; ++jy){
		
				for (var kx = 0; kx < mapsize; ++kx)
				for (var ky = 0; ky < mapsize; ++ky){
					
					r[ix][iy][jx][jy] += m[kx][ky][jx][jy] * m[ix][iy][kx][ky];
					//ez jó, 0-t és egyeseket csinált
				}
		
			}

		}

		return r;
	}

	AI.on_line_add = function(line){
		this.line_van[line.a.x][line.a.y]++;
		this.line_van[line.b.x][line.b.y]++;

		this.lines[line.a.x][line.a.y][line.b.x][line.b.y] = 1;
		this.lines[line.b.x][line.b.y][line.a.x][line.a.y] = 1;
		
		this.lines2 = calc_lines2(this.lines);
	}

	AI.ok = function(x, y){
	    var active_dots = map.dots.clone();
	    active_dots.and(selected_map, map.width - x, map.height - y);
	    map.lines_shadow(active_dots, new Point(x, y));

		var max = null;

		for (var i = 0; i < mapsize; ++i){
			for (var j = 0; j < mapsize; ++j){
				if (active_dots[i][j]){
					var prio = this.lines2[x][y][i][j];
					if (prio === 0){
						prio = -(this.line_van[x][y] + this.line_van[i][j]) * .5
					}

					if (max === null || prio > max.prio){
						max = {
							a: new Point(i, j),
							prio: prio
						};
					}
				}
			}
		}

		return max;
	};

	AI.step = function(){
		var x = (Math.random() * mapsize) | 0;
		var y = (Math.random() * mapsize) | 0;

		var max = null;

		for (var i = x; i != x - 1; ++i){
			for (var j = y; j != y - 1; ++j){

				var b = this.ok(i, j);
				if (b !== null && b.prio != -1 && (max === null || max.prio < b.prio)){
					b.b = new Point(i, j);
					max = b;
				}

				if (j + 1 === mapsize){
					if (y === 0)
						break;
					j = -1;
				}
			}

			if (i + 1 === mapsize){
				if (x === 0)
					break;
				i = -1;
			}
		}

		map.set_a(max.a);
		map.set_b(max.b);

	};

	return AI;

})(Matrix, Point);