var svg;

var mode;
var size;

var start_btn;
var top_btn;
var mode_btns = [];
var size_btns = [];

function set_mode(s){
	mode = s;
	localStorage["last-mode"] = s;

	if (s === 0){
		mode_btns[0].style = "opacity: 1";
		mode_btns[1].style = "opacity: .2";
	}else{
		mode_btns[0].style = "opacity: .2";
		mode_btns[1].style = "opacity: 1";
	}
}

function set_size(s){
	size = s;
	localStorage["last-size"] = s;

	for (var i = 0; i < 3; ++i){
		if (i === s)
			size_btns[i].style = "opacity: 1";
		else
			size_btns[i].style = "opacity: .2";
	}
}

window.onload = function(){
	svg = document.getElementById("svg");
	start_btn = document.getElementById("start");
	top_btn = document.getElementById("toplist");
	size_btns[0] = document.getElementById("size-0");
	size_btns[1] = document.getElementById("size-1");
	size_btns[2] = document.getElementById("size-2");
	mode_btns[0] = document.getElementById("mode-0");
	mode_btns[1] = document.getElementById("mode-1");
	
	size_btns[0].onclick = function(){ set_size(0) };
	size_btns[1].onclick = function(){ set_size(1) };
	size_btns[2].onclick = function(){ set_size(2) };
	mode_btns[0].onclick = function(){ set_mode(0) };
	mode_btns[1].onclick = function(){ set_mode(1) };

	start_btn.onclick = function(){
		window.location = "index.html#" + mode + size;
	};

	top_btn.onclick = function(){
		window.location = "records.html";
	};

	svg.setAttribute("height", window.innerHeight);
	svg.setAttribute("width", window.innerWidth);
	
	width = window.innerWidth;
	height = (window.innerWidth / 360) * 640;
	svg.setAttribute("viewBox", "0 0 360 640");
	svg.setAttribute("width", window.innerWidth);
	svg.setAttribute("height", (window.innerWidth / 360) * 640);

	set_size(localStorage["last-size"] ? parseInt(localStorage["last-size"]) : 1);
	set_mode(localStorage["last-mode"] ? parseInt(localStorage["last-mode"]) : 1);
}