var canvas, g;

var map;
var paintInterval;

var selected_map;

var SIZE = 20;
var MAPSIZE = 5;
var SPACE;

var playerColors = ["#9885ff", "#90ff81"];
var playerImgs = [];
var menuImg;

var currentPlayer = 0;
var playerStay = false;

var territores = [0, 0];
var mode;

window.onload = function(){
    GUI.init();
    mode = parseInt(location.hash[1]);
    var ssize = location.hash[2];

    if (ssize === '0')
        MAPSIZE = 4;
    else if (ssize === '1')
        MAPSIZE = 5;
    else
        MAPSIZE = 6;

    if (mode)
        AI.init(MAPSIZE);

    SIZE = (window.innerWidth / MAPSIZE) | 0;
    SPACE = (MAPSIZE - 1) * (MAPSIZE - 1) * 2;

    canvas = document.getElementById('canvas');
    g = canvas.getContext("2d");

    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;

    playerImgs[0] = new Image();
    playerImgs[0].src = "imgs/next-0.png";
    playerImgs[1] = new Image();
    playerImgs[1].src = "imgs/next-1.png";
    menuImg = new Image();
    menuImg.src = "imgs/menu.png";

    // CONTROLS

    var temp_touch;

    canvas.ontouchstart = function(evt){
        if (currentPlayer === 1 && mode === 1)
            return;
        evt.preventDefault();
        var t = evt.changedTouches[0];

        temp_touch = {
            x: (t.clientX / SIZE) | 0,
            y: (t.clientY / SIZE) | 0,
        }

        if (temp_touch.y >= map.height || temp_touch.x >= map.width){
            temp_touch = null;
        }
    };

    canvas.ontouchmove = function(evt){
        if (currentPlayer === 1 && mode === 1)
            return;
        evt.preventDefault();
        var t = evt.changedTouches[0];

        var p = {
            x: t.clientX,
            y: t.clientY,
        }

        if (!map.a){
            map.set_a(temp_touch);
            temp_touch = null;
        }
        map.set_bb(p);
    }

    canvas.ontouchend = canvas.ontouchcancel = canvas.ontouchleave = function(evt){
        if (currentPlayer === 1 && mode === 1)
            return;
        evt.preventDefault();
        var t = evt.changedTouches[0];

        var p = {
            x: (t.clientX / SIZE) | 0,
            y: (t.clientY / SIZE) | 0,
        }

        if (map.a){
            if (map.a.x === p.x && map.a.y === p.y){
                map.set_a(null);
            }else if (map.active_dots && map.active_dots[p.x][p.y]){
                map.set_b(p);
            }else{
                map.set_a(null);
            }
        }else{
            map.set_a(temp_touch);
        }

        map.set_bb(null);
    }

    canvas.onclick = function(e){
        if (t.clientX > ((canvas.height - 20) / 2)  && t.clientY > canvas.width)
            GUI.show_sure_menu();
    }

    // INTIZALIZE GAME

    var width = MAPSIZE;
    var height = MAPSIZE;

    map = new Map(width, height);

    function asd(a, b){
        for (var i = 2; i < 5; ++i){
            if (a % i === 0 && b % i === 0){
                return true;
            }
        }

        return false;
    }

    selected_map = new Matrix(2 * width + 1, 2 * height + 1);
    for (var i = 0; i <= width; ++i){
        for (var j = 0; j <= height; ++j){
            var z = (i != j || i === 1) && (i != 0 || j === 1) && (j != 0 || i === 1) && !asd(i, j);
            selected_map[width + i][height + j] = z;
            selected_map[width - i][height - j] = z;
            selected_map[width + i][height - j] = z;
            selected_map[width - i][height + j] = z;
        }
    }

    paintInterval = setInterval(paint, 100);
}

function paint(){
    g.beginPath();
    g.rect(0, 0, canvas.width, canvas.height);
    g.fillStyle = '#353535';
    g.fill();

    map.draw(g);

    // állás jelző kör

    var r = (canvas.height - canvas.width - 20) / 2;

    g.beginPath();
    g.fillStyle = 'rgba(0, 0, 0, .2)';
    g.arc(canvas.width / 2, canvas.width + r, r, 0, 2 * Math.PI, false);
    g.fill();

    g.beginPath();
    g.fillStyle = playerColors[0];
    g.moveTo(canvas.width / 2, canvas.width + r);
    g.lineTo(canvas.width / 2, canvas.width);
    g.arc(canvas.width / 2, canvas.width + r, r, -0.5 * Math.PI, (-(territores[0] / SPACE) - .25) * Math.PI * 2, true);
    g.lineTo(canvas.width / 2, canvas.width + r);
    g.fill();


    g.beginPath();
    g.fillStyle = playerColors[1];
    g.moveTo(canvas.width / 2, canvas.width + r);
    g.lineTo(canvas.width / 2, canvas.width);
    g.arc(canvas.width / 2, canvas.width + r, r, -0.5 * Math.PI, ((territores[1] / SPACE) - .25) * Math.PI * 2, false);
    g.lineTo(canvas.width / 2, canvas.width + r);
    g.fill();

    // current player

    g.drawImage(playerImgs[currentPlayer], 0, 0, 100, 100, ((canvas.width / 2 - r - SIZE) / 2) | 0, canvas.width + (((canvas.height - canvas.width - SIZE) / 2) | 0), SIZE, SIZE);
    g.drawImage(menuImg, 0, 0, 100, 100, ((canvas.width * 3 / 2 + r - SIZE) / 2) | 0, canvas.width + (((canvas.height - canvas.width - SIZE) / 2) | 0), SIZE, SIZE);
}

var Point = (function(){
    var Point = function(x, y){
        this.x = x;
        this.y = y;
    }

    Point.prototype.eq = function(other) {
        return this.x === other.x && this.y === other.y;
    };

    return Point;
})();

var Line = (function(Point){
    var Line = function(a, b){
        if (a instanceof Point)
            this.a = a;
        else
            this.a = new Point(a.x, a.y);

        if (b instanceof Point)
            this.b = b;
        else
            this.b = new Point(b.x, b.y);

        this.drawable = true;
    }

    return Line;
})(Point);

var Matrix = (function(){

    var Matrix = function(width, height, init){
        this.width = width;
        this.height = height;

        var init = extend(init, {
            enabled: true,
            def: true
        });

        if (init.enabled){
            for (var i = 0; i < width; ++i){
                this[i] = [];
                for (var j = 0; j < height; ++j){
                    this[i][j] = init.fn ? init.fn(i, j) : init.def;
                }
            }
        }
    }

    Matrix.prototype = new Array();

    Matrix.prototype.and = function(other, x, y) {
        if (!x)
            x = 0;
        if (!y)
            y = 0;

        for (var i = 0; i < this.width && x + i < other.width; ++i){
            for (var j = 0; j < this.height && y + j < other.height ; ++j){
                this[i][j] = this[i][j] && other[x + i][y + j];
            }
        }
    };

    Matrix.prototype.clone = function() {
        var r = new Matrix(this.width, this.height, {enabled: false});

        for (var i = 0; i < this.width; ++i){
            r[i] = [];
            for (var j = 0; j < this.height; ++j){
                r[i][j] = this[i][j];
            }
        }

        return r;
    };

    Matrix.prototype.get = function(point) {
        return this[point.x][point.y];
    };

    return Matrix;
})();

var Shape = (function(){
    var Shape = function(player, points){
        this.points = points;
        this.player = player;
    }

    Shape.prototype.draw = function(g) {
        g.beginPath();
        g.fillStyle = playerColors[this.player];
        g.moveTo((this.points[0].x + .5) * SIZE, (this.points[0].y + .5) * SIZE);

        for (var i = 1; i < this.points.length; ++i)
            g.lineTo((this.points[i].x + .5) * SIZE, (this.points[i].y + .5) * SIZE);

        g.fill();
    };

    return Shape;
})();

var Map = (function(Matrix, Line, Shape){

    var Map = function(width, height, initalize){
        this.width = width;
        this.height = height;

        this.lines = [];
        this.shapes = [];

        this.dots = new Matrix(width, height);
        this.active_dots = null;

        this.a = null;
        this.b = null;
        this.bb = null;
    }

    Map.prototype.set_a = function(a) {
        this.a = a;

        if (a === null){
            this.active_dots = null;
            return;
        }

        this.active_dots = this.dots.clone();
        this.active_dots.and(selected_map, this.width - a.x, this.height - a.y);
        this.lines_shadow(this.active_dots, this.a);
    };

    Map.prototype.set_b = function(b) {
        this.b = b;

        var line = new Line(this.a, this.b);
        this.getTriangles(line);
        this.lines.push(line);
        this.a = null;
        this.b = null;
        this.active_dots = null;

        if (mode === 1){
            AI.on_line_add(line);
        }

        if (playerStay){
            playerStay = false;
            if(currentPlayer === 1 && mode === 1 && territores[0] + territores[1] < SPACE){
                setTimeout(function(){AI.step()}, 500);
            }
        }else{
            currentPlayer = currentPlayer === 0 ? 1 : 0;
            if(currentPlayer === 1 && mode === 1 && territores[0] + territores[1] < SPACE){
                setTimeout(function(){AI.step()}, 300);
            }
        }
    };

    Map.prototype.set_bb = function(bb){
        this.bb = bb;
    };

    function ford(a, b, c){
        var m = (b.y - a.y) * (c.x - a.x) - (c.y - a.y) * (b.x - a.x);

        if (m < 0)
            return 1;
        else if (m > 0)
            return -1;
        else 
            return 0;
    }

    Map.prototype.lines_shadow = function(m, a) {

        for (var x = 0; x < this.width; ++x){
            for (var y = 0; y < this.height; ++y){
                if (!m[x][y])
                    continue;

                var p = {
                    x: x,
                    y: y,
                };

                for (var i in this.lines){
                    if (this.lines[i].a.x === x && this.lines[i].a.y === y
                        || this.lines[i].b.x === x && this.lines[i].b.y === y)
                        continue;

                    if (this.lines[i].a.x === a.x && this.lines[i].a.y === a.y){
                        m[this.lines[i].b.x][this.lines[i].b.y] = false;
                        continue;
                    }
                    if (this.lines[i].b.x === a.x && this.lines[i].b.y === a.y){
                        m[this.lines[i].a.x][this.lines[i].a.y] = false;
                        continue;
                    }

                    if (   ford(this.lines[i].a, this.lines[i].b, p) 
                         * ford(this.lines[i].a, this.lines[i].b, a) <= 0
                        && ford(a, p, this.lines[i].a) 
                         * ford(a, p, this.lines[i].b) < 0
                       )
                    {
                        m[x][y] = false;
                    }
                }
            }
        }
    };

    Map.prototype.getTriangles = function(line){
        var m = new Matrix(this.width, this.height, {def: null});

        var _this = this;
        var handleTriangle = function(p, l1, l2){
            var a = Math.sqrt((p.x - line.a.x) * (p.x - line.a.x) + (p.y - line.a.y) * (p.y - line.a.y));
            var b = Math.sqrt((p.x - line.b.x) * (p.x - line.b.x) + (p.y - line.b.y) * (p.y - line.b.y));
            var c = Math.sqrt((line.b.x - line.a.x) * (line.b.x - line.a.x) + (line.b.y - line.a.y) * (line.b.y - line.a.y));
            var s = (a + b + c) / 2;

            var t = Math.sqrt(s * (s - a) * (s - b) * (s - c));

            if (t > .49999999 && t < .50000001){
                var shape = new Shape(currentPlayer, [p, line.a, line.b]);
                _this.shapes.push(shape);

                line.drawable = false;
                l1.drawable = false;
                l2.drawable = false;

                territores[currentPlayer] += 1;

                playerStay = true;
                return true;
            }

            return false;
        };

        for (var i in this.lines){
            if (this.lines[i].a.eq(line.a) || this.lines[i].a.eq(line.b)){
                if (m[this.lines[i].b.x][this.lines[i].b.y]){
                    handleTriangle(this.lines[i].b, this.lines[i], m[this.lines[i].b.x][this.lines[i].b.y]);
                }else{
                    m[this.lines[i].b.x][this.lines[i].b.y] = this.lines[i];
                }
            }else if (this.lines[i].b.eq(line.a) || this.lines[i].b.eq(line.b)){
                if (m[this.lines[i].a.x][this.lines[i].a.y]){
                    handleTriangle(this.lines[i].a, this.lines[i], m[this.lines[i].a.x][this.lines[i].a.y]);
                }else{
                    m[this.lines[i].a.x][this.lines[i].a.y] = this.lines[i];
                }
            }
        }

        if (territores[0] + territores[1] === SPACE){
            game_over();
        }
    };

    Map.prototype.draw = function(g) {

        //dots

        g.fillStyle = "rgba(255, 255, 255, .8)";            
        for (var i = 0; i < this.width; ++i){
            for (var j = 0; j < this.height; ++j){
                if (this.active_dots)
                    g.fillStyle = this.active_dots[i][j] ? "rgba(255, 255, 255, .8)":
                                                           "rgba(255, 255, 255, .2)";
                
                g.beginPath();
                g.arc((i + .5) * SIZE, (j + .5) * SIZE, SIZE / 6, 0, 2 * Math.PI, false);
                g.fill();
            }
        }

        // active point

        if(this.a){
            g.fillStyle = "#85c9ff";
            g.beginPath();
            g.arc((map.a.x + .5) * SIZE, (map.a.y + .5) * SIZE, SIZE / 4, 0, 2 * Math.PI, false);
            g.fill();

            if (this.bb){
                g.strokeStyle = "rgb(255, 255, 255)";
                g.lineWidth = 2;
                g.beginPath();
                    g.moveTo((this.a.x + .5) * SIZE, (this.a.y + .5) * SIZE);
                    g.lineTo(this.bb.x, this.bb.y);
                g.stroke();
            }
        }

        // shapes

        for (var i in this.shapes){
            this.shapes[i].draw(g);
        }

        // lines

        g.strokeStyle = "rgba(255, 255, 255, .9)";
        g.lineWidth = 4;
        for (var i in this.lines){
            if (!this.lines[i].drawable)
                continue;
            g.beginPath();
            g.moveTo((this.lines[i].a.x + .5) * SIZE, (this.lines[i].a.y + .5) * SIZE);
            g.lineTo((this.lines[i].b.x + .5) * SIZE, (this.lines[i].b.y + .5) * SIZE);
            g.stroke();
        }
    };

    return Map;
})(Matrix, Line, Shape);

var game_over = function(){ 
    var records = JSON.parse(localStorage["records"] || "[]");
    var now = new Date();
    records.push({
        p1: territores[0] / SPACE,
        size: MAPSIZE,
        mode: mode,
        date: "" + now.getFullYear().toString().substr(2, 2) + "-" + now.getMonth() + "-" + now.getDate()
            + " " + now.getHours() + ":" + now.getMinutes()
    });

    records.sort(function(a, b){
        if (a.p1 > b.p1)
            return -1;
        if (a.p1 < b.p1)
            return 1;
        return 0;
    });

    localStorage["records"] = JSON.stringify(records);

    document.getElementById("p1").innerHTML = (territores[0] / SPACE * 100) | 0;
    document.getElementById("p2").innerHTML = 100 - ((territores[0] / SPACE * 100) | 0);

    GUI.show_over_menu();
}

var extend = (function(undefined){
    var extend = function(a, b){
        if (!a)
            a = {};

        for (i in b){
            if (a[i] === undefined){
                if (typeof b[i] === 'object'){
                    a[i] = {};
                    extend(a[i], b[i]);
                }else{
                    a[i] = b[i];
                }
            }
        }

        return a;
    }

    return extend;
})();