var game = false;
var squares = [];
var points = 0;
var colors = ["orange", "blue", "purple", "green"];
var deck = [];
var mycolor = "orange";
var time = 600;
var row = 0;
var multiply = 1;
var inrow = {
	5: 1.5,
	10: 2,
	15: 2.5,
	20: 3,
	25: 3.5,
	30: 4
}
var combo = 0;
var intervals = [];

function startGame() {
	game = false;
	squares = [];
	points = 0;
	deck = [];
	row = 0;
	multiply = 1;
	combo = 0;
	intervals = [];

	/*$("#game").html("");

	for(i=1;i<=6;i++) {
		var sq = $("<div>");
		sq.addClass("square");
		var col = $("<div>");
		col.addClass("color");
		col.appendTo(sq);
		sq.appendTo("#game");
	}
	var mu = $("<div>");
	mu.addClass("showmultiply");
	mu.appendTo($("#game .square").get(1));*/

	$("#game .green").removeClass("green");
	$("#game .blue").removeClass("blue");
	$("#game .purple").removeClass("purple");
	$("#game .orange").removeClass("orange");

	$(".showmultiply").text("");

	$("#game .square .color").each(function() {
		$(this).parents(".square").find(".tap").unbind(mouseevent);
		squares.push(new Square($(this)));
	});

	setTimeout(function() {
		showNumber(3, 1000, "numbers");
	}, 1000);
	setTimeout(function() {
		showNumber(2, 1000, "numbers");
	}, 2000);
	setTimeout(function() {
		showNumber(1, 1000, "numbers");
	}, 3000);
	setTimeout(function() {
		showNumber("Go!", 500, "gametext");
	}, 4000);

	setTimeout(function() {
		$.each(squares, function(key, val) {
			squares[key].timer = setInterval(function() {
				squares[key].setColor();
			}, time);
			intervals.push(squares[key].timer);
			squares[key].update = (new Date()).getTime();
		});
		game = true;
		setTimeout(function() {
			stopGame();
		}, 30000);
	}, 4500);
}

function stopGame() {
	game = false;
	/*$.each(intervals, function(key, val) {
		clearInterval(val);
	});*/
	$.each(squares, function(key, val) {
		clearInterval(squares[key].timer);
		delete squares[key];
	});

	var text = $("<div>");
	text.addClass("gametext");
	text.text("End");
	text.appendTo("#game");
	text.css({scale: 0.5, opacity: 0})
	text.transition({scale: 1, opacity: 1}, 1200, function() {
		text.remove();
	});

	$("#end #points").text(parseInt(points).toString());
	$("#end #combo").text(combo.toString());
	$("#end #beat").text("");

	var oldpoints = parseInt(localStorage.getItem("tap-points"));
	var oldhigh = parseInt(localStorage.getItem("tap-high"));
	var played = parseInt(localStorage.getItem("tap-played"));
	played++;
	localStorage.setItem("tap-played", played.toString());
	var newpoints = parseInt(oldpoints+points);
	localStorage.setItem("tap-points", newpoints.toString());

	if(points > oldhigh) {
		localStorage.setItem("tap-high", parseInt(points).toString());
		$("#end #beat").text("You just beat your High Score!");
	}

	setTimeout(function() {
		$("#game").hide();
		$("#end").show();
	}, 1300);
}

function showNumber(num, time, clas) {
	var number = $("<div>");
	number.addClass(clas);
	number.text(num);
	number.appendTo("#game");
	number.transition({scale: 0.5, opacity: 0}, time, function() {
		number.remove();
	});
}

function showPoint(x, y, text, color) {
	var point = $("<div>");
	point.addClass("showpoint");
	point.text(text);
	point.appendTo("#game");
	point.css({left: x, top: y, color: color});
	point.transition({scale: 0.7, opacity: 0}, 800, function() {
		point.remove();
	});
}


function Square(element) {
	this.element = element;
	this.currentColor = "";
	this.update = (new Date()).getTime();
	this.act = true;

	var that = this;

	this.setColor();

	this.element.parents(".square").find(".tap").on(mouseevent, function(e) {
		if(that.currentColor == "" || !game || !that.act) {
			return false;
		}

		var msec = (new Date()).getTime() - that.update;

		if(that.currentColor == mycolor) {
			showPoint(e.pageX || e.originalEvent.touches[0].pageX, e.pageY || e.originalEvent.touches[0].pageY, "+ "+multiply*msec, "white");
			points += multiply*msec;
			row++;
			if(row > combo) {
				combo = row;
			}
			checkMultiply();
		}
		else {
			showPoint(e.pageX || e.originalEvent.touches[0].pageX, e.pageY || e.originalEvent.touches[0].pageY, "- "+msec, "red");
			points -= msec;
			if(points < 0) {
				points = 0;
			}
			row = 0;
			checkMultiply();
		}

		clearInterval(that.timer);

		that.act = false;

		$(this).parents(".square").find(".color").transition({scale: 0}, 300, function() {
			that.setColor();
			$(this).transition({scale: 1}, 300, function() {
				if(!game) {
					return false;
				}
				that.timer = setInterval(function() {
					that.setColor();
				}, time);
				that.act = true;
				intervals.push(that.timer);
			});
		});
		return false;
	});
}

Square.prototype.setColor = function() {
	if(!game) {
		clearInterval(this.timer);
	}

	if(deck.length == 0) {
		deck = colors.slice(0);
	}
	deck.shuffle();
	var color = deck.shift();
	//var color = colors[Math.floor(Math.random()*4)];
	this.element.removeClass(this.currentColor);
	this.element.addClass(color);
	this.currentColor = color;
	this.update = (new Date()).getTime();
}


function checkMultiply() {


	var mul = 1;
	$.each(inrow, function(key, val) {
		if(row >= key) {
			mul = val;
		}
	});

	if(mul == multiply) {
		return;
	}

	$(".showmultiply").text("");
	if(mul > 1) {
		$(".showmultiply").css({scale: 0.5, opacity: 0, rotate: 10});
		$(".showmultiply").text(mul+"x");
		$(".showmultiply").transition({scale: 1, opacity: 1}, 500);
	}

	multiply = mul;
}



Array.prototype.shuffle = function () {
    var i = this.length, j, temp;
    if ( i == 0 ) return;
    while ( --i ) {
        j = Math.floor( Math.random() * ( i + 1 ) );
        temp = this[i];
        this[i] = this[j];
        this[j] = temp;
    }
}