var mouseevent = "";
var server = "http://srv.vsakos.com/game/api.php";

$(document).ready(function() {
	mouseevent = ('ontouchstart' in window)?"touchstart":"mousedown";
	if(!localStorage.getItem("tap-points")) {
		localStorage.setItem("tap-points", "0");
	}
	if(!localStorage.getItem("tap-high")) {
		localStorage.setItem("tap-high", "0");
	}
	if(!localStorage.getItem("tap-played")) {
		localStorage.setItem("tap-played", "0");
	}
});

function loadStats() {
	$("#stats .content").html("");
	var points = parseInt(localStorage.getItem("tap-points"));
	var high = parseInt(localStorage.getItem("tap-high"));
	var played = parseInt(localStorage.getItem("tap-played"));

	var e = $("<div>");
	e.addClass("statswrap");
	e.text("Total Points: "+points);
	e.appendTo("#stats .content");

	var e = $("<div>");
	e.addClass("statswrap");
	e.text("Total games played: "+played);
	e.appendTo("#stats .content");

	var e = $("<div>");
	e.addClass("statswrap");
	e.text("Average: "+(played==0?"0":parseInt(points/played)));
	e.appendTo("#stats .content");

	var e = $("<div>");
	e.addClass("statswrap");
	e.text("High score: "+high);
	e.appendTo("#stats .content");

	if(!localStorage.getItem("tap-email")) {
		var e = $("<div>");
		e.addClass("statswrap");
		e.text("Average points rank: unknown");
		e.appendTo("#stats .content");

		var e = $("<div>");
		e.addClass("statswrap");
		e.text("High score rank: unknown");
		e.appendTo("#stats .content");

		var img = $("<img>");
		img.attr("src", "img/update.png");
		var b = $("<div>");
		b.addClass("reload");
		b.addClass("blue");
		img.appendTo(b);
		b.appendTo("#stats .content");
	}
	else {
		$.ajax(server+"?p=set&email="+localStorage.getItem("tap-email")+"&password="+localStorage.getItem("tap-password")+"&points="+localStorage.getItem("tap-points")+"&highscore="+localStorage.getItem("tap-high")+"&gamecount="+localStorage.getItem("tap-played"), {
			dataType: "jsonp",
			success: function() {
				$.ajax(server+"?p=rank&email="+localStorage.getItem("tap-email")+"&password="+localStorage.getItem("tap-password")+"&by=points", {
					dataType: "jsonp",
					success: function(data) {
						var e = $("<div>");
						e.addClass("statswrap");
						e.text("Average points rank: "+data.rank);
						e.appendTo("#stats .content");
					}
				});

				$.ajax(server+"?p=rank&email="+localStorage.getItem("tap-email")+"&password="+localStorage.getItem("tap-password")+"&by=highscore", {
					dataType: "jsonp",
					success: function(data) {
						var e = $("<div>");
						e.addClass("statswrap");
						e.text("High score rank: "+data.rank);
						e.appendTo("#stats .content");
					}
				});
			}
		});
	}

	
}


function loadTop() {
	$("#stats .content").html("");

	if(!localStorage.getItem("tap-email")) {
		$("#stats").hide();
		$("#register").show();
	}
	else {
		$.ajax(server+"?p=top&by=points", {
			dataType: "jsonp",
			success: function(data) {

				var e = $("<div>");
				e.addClass("toptext");
				e.text("Top 10 by average points");
				e.appendTo("#stats .content");

				$("#stats .content").append('<div class="topten first"><span>#</span><span>Name</span><span>Average</span><span>High score</span></div>');

				$.each(data, function(key, val) {
					$("#stats .content").append('<div class="topten"><span>'+val.rank+'</span><span>'+val.username+'</span><span>'+parseInt(val.points)+'</span><span>'+val.highscore+'</span></div>');
				});
			},
			error: function() {
				setTimeout(function() {
					alert("No Internet access!");
				}, 100);
			}
		});

		$.ajax(server+"?p=top&by=highscore", {
			dataType: "jsonp",
			success: function(data) {

				var e = $("<div>");
				e.addClass("toptext");
				e.text("Top 10 by high score");
				e.appendTo("#stats .content");

				$("#stats .content").append('<div class="topten first"><span>#</span><span>Name</span><span>Average</span><span>High score</span></div>');

				$.each(data, function(key, val) {
					$("#stats .content").append('<div class="topten"><span>'+val.rank+'</span><span>'+val.username+'</span><span>'+parseInt(val.points)+'</span><span>'+val.highscore+'</span></div>');
				});
			}
		});
	}
}