$(document).ready(function() {
	$("#home .square .green").on(mouseevent, function() {
		$(this).transition({scale: 0.5, opacity: 0}, 300, function() {
			$("#home").hide();
			$("#pick").show();
			$(this).css({scale: 1, opacity: 1});
		});
	});

	$("#home .square .blue").on(mouseevent, function() {
		$(this).transition({scale: 0.5, opacity: 0}, 300, function() {
			$("#home").hide();
			$("#help").show();
			$(this).css({scale: 1, opacity: 1});
		});
	});

	$("#home .square .purple").on(mouseevent, function() {
		$(this).transition({scale: 0.5, opacity: 0}, 300, function() {
			loadStats();
			$("#home").hide();
			$("#stats").show();
			$(this).css({scale: 1, opacity: 1});
		});
	});

	$("#home .square .orange").on(mouseevent, function() {
		$(this).transition({scale: 0.5, opacity: 0}, 300, function() {
			$("#home").hide();
			$("#credits").show();
			$(this).css({scale: 1, opacity: 1});
		});
	});

	$("#credits .square .orange").on(mouseevent, function() {
		$(this).transition({scale: 0.5, opacity: 0}, 300, function() {
			$("#credits").hide();
			$("#home").show();
			$(this).css({scale: 1, opacity: 1});
		});
	});

	$("#stats .back").click(function() {
		$("#stats").hide();
		$("#home").show();
	});

	$("#stats .mystat").click(function() {
		$(this).addClass("green");
		setTimeout(function() {
			$("#stats .mystat").removeClass("green");
		}, 500);
		$("#stats .content").html("");
		loadStats();
	});

	$("#stats .top").click(function() {
		$(this).addClass("green");
		setTimeout(function() {
			$("#stats .top").removeClass("green");
		}, 500);
		$("#stats .content").html("");
		loadTop();
	});
	$("#end .square .green").on(mouseevent, function() {
		$(this).transition({scale: 0.5, opacity: 0}, 300, function() {
			$("#end").hide();
			$("#pick").show();
			$(this).css({scale: 1, opacity: 1});
		});
	});

	$("#help .square .orange").on(mouseevent, function() {
		$(this).transition({scale: 0.5, opacity: 0}, 300, function() {
			$("#help").hide();
			$("#home").show();
			$(this).css({scale: 1, opacity: 1});
		});
	});


	$("#pick .square .color").on(mouseevent, function() {
		mycolor = $(this).data("color");
		startGame();
		$(this).transition({scale: 0.5, opacity: 0}, 300, function() {
			$("#pick").hide();
			$("#game").show();
			$(this).css({scale: 1, opacity: 1});
		});
	});


	$("#end .square .orange").on(mouseevent, function() {
		$(this).transition({scale: 0.5, opacity: 0}, 300, function() {
			$("#end").hide();
			$("#home").show();
			$(this).css({scale: 1, opacity: 1});
		});
	});


	$("#register .back").click(function() {
		$("#register").hide();
		$("#stats").show();
		loadStats();
	});

	$("#register .login").click(function() {
		$("#register").hide();
		$("#login").show();
	});

	$("#login .back").click(function() {
		$("#login").hide();
		$("#register").show();
	});


	$("#stats").delegate(".reload", "click", function() {
		$("#register").show();
		$("#stats").hide();
	});

	$("#login .send").click(function() {
		var email = $("#login #email").val();
		var pass = $("#login #pass").val();

		if(!email || !pass) {
			setTimeout(function() {
				alert("You have to fill all fields!");
			}, 100);
		}
		else {
			$.ajax(server+"?p=login&email="+email+"&password="+pass, {
				dataType: "jsonp",
				success: function(data) {
					if(data.message == "ok") {
						localStorage.setItem("tap-email", email);
						localStorage.setItem("tap-password", pass);
						$("#login").hide();
						$("#stats").show();
						loadStats();
					}
					else if(data.message == "fail") {
						setTimeout(function() {
							alert("Wrong login details!");
						}, 100);
					}
				},
				error: function() {
					setTimeout(function() {
						alert("No internet access!");
					}, 100);
				}
			});
		}
	});

	$("#register .send").click(function() {
		var email = $("#register #email").val();
		var pass = $("#register #pass").val();
		var pass1 = $("#register #pass1").val();
		var name = $("#register #name").val();

		var re = /[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}/gi;

		if(!email || !pass || !pass1 || !name) {
			setTimeout(function() {
				alert("You have to fill all fields!");
			}, 100);
		}
		else if(!re.test(email)) {
			setTimeout(function() {
				alert("This is not a valid email address!");
			}, 100);
		}
		else if(pass1 != pass) {
			setTimeout(function() {
				alert("Password doesn't match!");
			}, 100);
		}
		else if(pass.length < 6) {
			setTimeout(function() {
				alert("Password should be at least 6 characters long!");
			}, 100);
		}
		else {
			$.ajax(server+"?p=register&email="+email+"&password="+pass+"&username="+name, {
				dataType: "jsonp",
				success: function(data) {
					if(data.message == "ok") {
						localStorage.setItem("tap-email", email);
						localStorage.setItem("tap-password", pass);
						$("#register").hide();
						$("#stats").show();
						loadStats();
					}
					else if(data.message == "email_used") {
						setTimeout(function() {
							alert("This email is used!");
						}, 100);
					}
					else if(data.message == "username_used") {
						setTimeout(function() {
							alert("This name is used!");
						}, 100);
					}
				},
				error: function() {
					setTimeout(function() {
						alert("No internet access!");
					}, 100);
				}
			});
		}
	});

});