'use strict';
window.addEventListener('load', function onLoad() {
  window.removeEventListener('load', onLoad);
  init();
  mensaje("Game start!");
});

var Util = new util();
var pregunta = document.getElementById('pregunta-view');
var respuesta1 = document.getElementById('respuestas-r1'); 
var respuesta2 = document.getElementById('respuestas-r2');
var respuesta3 = document.getElementById('respuestas-r3');
var respuesta4 = document.getElementById('respuestas-r4');
var boton = document.getElementById('boton-view');
var marcadorNivel = document.getElementById('marcador-nivel');
var marcadorSegundos = document.getElementById('marcador-segundos');
var marcadorPregunta = document.getElementById('marcador-pregunta');
var progreso = document.getElementById('progreso-view');

var preguntas1 = {};
var preguntas2 = {};
var preguntas3 = {};

function mensaje(s) {
   var m = document.getElementById('banner-view');
   m.innerHTML = s;
   m.className = "bannerVisible";
   setTimeout("escondeMensaje()",2000);
}

function escondeMensaje() {
   var m = document.getElementById('banner-view');
   m.innnerHTML = "";
   m.className = "banner";
}

function disableRespuestas() {
    //respuesta1.className = "disableRespuesta";
    //respuesta2.className = "disableRespuesta";
    //respuesta3.className = "disableRespuesta";
    //respuesta4.className = "disableRespuesta";
    respuesta1.onclick = "";
    respuesta2.onclick = "";
    respuesta3.onclick = "";
    respuesta4.onclick = "";
}

function enableRespuestas() {
    respuesta1.className = "respuesta";
    respuesta2.className = "respuesta";
    respuesta3.className = "respuesta";
    respuesta4.className = "respuesta";
    respuesta1.onclick = onClickRespuesta1;
    respuesta2.onclick = onClickRespuesta2;
    respuesta3.onclick = onClickRespuesta3;
    respuesta4.onclick = onClickRespuesta4;
}

function onClickRespuesta1() {
  	if (Util.preguntaActual.respuestaVerdadera == 1) {
  		respuestaCorrecta(1);
  	}
  	else {
  		respuestaErronea(1);
  	}    
}

function onClickRespuesta2() {
  	if (Util.preguntaActual.respuestaVerdadera == 2) {
  		respuestaCorrecta(2);
  	}
  	else {
  		respuestaErronea(2);
  	}    
}

function onClickRespuesta3() {
  	if (Util.preguntaActual.respuestaVerdadera == 3) {
  		respuestaCorrecta(3);
  	}
  	else {
  		respuestaErronea(3);
  	}    
}

function onClickRespuesta4() {
  	if (Util.preguntaActual.respuestaVerdadera == 4) {
  		respuestaCorrecta(4);
  	}
  	else {
  		respuestaErronea(4);
  	}    
}

function respuestaCorrecta(n) {
  mensaje("Correct Answer");
  endTimer();
  if (n==1) {
    respuesta1.className = "respuestaCorrecta";
  }
  if (n==2) {
    respuesta2.className = "respuestaCorrecta";
  }
  if (n==3) {
    respuesta3.className = "respuestaCorrecta";
  }
  if (n==4) {
    respuesta4.className = "respuestaCorrecta";
  }
  
  Util.segundosNivel += (Util.tiempoTotal - Util.contador ) -1;  
  pintarMarcador()  
  subePregunta();
  enableBoton();
  disableRespuestas();
    
}


function respuestaErronea(n) {
  mensaje("Incorrect Answer");
  endTimer();
  
  if (n==1) {
    respuesta1.className = "respuestaErronea";
  }
  if (n==2) {
    respuesta2.className = "respuestaErronea";
  }
  if (n==3) {
    respuesta3.className = "respuestaErronea";
  }
  if (n==4) {
    respuesta4.className = "respuestaErronea";
  }
  
  if (Util.preguntaActual.respuestaVerdadera == 1) {
    respuesta1.className = "respuestaCorrecta";
  }
  if (Util.preguntaActual.respuestaVerdadera == 2) {
    respuesta2.className = "respuestaCorrecta";
  }
  if (Util.preguntaActual.respuestaVerdadera == 3) {
    respuesta3.className = "respuestaCorrecta";
  }
  if (Util.preguntaActual.respuestaVerdadera == 4) {
    respuesta4.className = "respuestaCorrecta";
  }
  
  Util.segundosNivel += Util.tiempoTotal;  
  pintarMarcador()  
  subePregunta();
  enableBoton();
  disableRespuestas();    
}

function subePregunta() {

    	Util.pregunta ++;
    	
    	if (Util.pregunta > 10) { // 10 preguntas por nivel
    		Util.pregunta = 1;
    		if (Util.segundosNivel < Util.numeroSegundosPasarNivel) {
	    		
	    		Util.segundosTotales += Util.segundosNivel;
	        Util.nivel ++;
        	Util.pregunta = 1;
	    		if (Util.nivel > Util.totalNiveles) { // FIN APP, LO HA CONSEGUIDO

            disableBoton();			    	

            alert("Perfect, you passed all the levels. More levels will come in the future. Total secs: " + Util.segundosTotales);
            Util.nivel = 1;
			    	
	    			
	    		} else {
            alert("Perfect, you passed this level in " + Util.segundosNivel +  " secs. Total you spend " + Util.segundosTotales + " secs.");
	    		}
	    		Util.segundosNivel = 0;
	    		pintarMarcador();
    		}
    		else {
    			pintarMarcador();
	        Util.pregunta = 1;
          alert("Oh, you have to start this level again, it took you " + Util.segundosNivel + " secs.");
    			Util.segundosNivel = 0;
    			pintarMarcador();
    		}
    			
    	}
    	

}

function onClickBoton() {
    juega();
    disableBoton();
}

function disableBoton() {
    boton.className = "disableBoton";
    boton.onclick = "";
}  

function enableBoton() {
    boton.className = "boton";
    boton.onclick = onClickBoton;
}  

function getPreguntas1() {
    return {
      getObj: function () {return preguntas1;}
      , add: function (key, data) {
          preguntas1[key] = data;
          return this; // enabling chaining
        }
      , get: function (key) {
          return preguntas1[key];
      }
    }
}  

function getPreguntas2() {
    return {
      getObj: function () {return preguntas2;}
      , add: function (key, data) {
          preguntas2[key] = data;
          return this; // enabling chaining
        }
      , get: function (key) {
          return preguntas2[key];
      }
    }
}  

function getPreguntas3() {
    return {
      getObj: function () {return preguntas3;}
      , add: function (key, data) {
          preguntas3[key] = data;
          return this; // enabling chaining
        }
      , get: function (key) {
          return preguntas3[key];
      }
    }
}  


function juega() {

  	Util.preguntaActual = getPregunta(Util.nivel, Util.pregunta);
    
    if (Util.preguntaActual == null) {
        if (Util.nivel >  Util.totalNiveles) {
          alert("Game Passed!!! No more levels");
          Util.nivel = 1;
          Util.pregunta = 1;
        }
    }

    pintarMarcador();
    
    pregunta.innerHTML = Util.preguntaActual.pregunta;
    respuesta1.innerHTML = Util.preguntaActual.respuesta1; 
    respuesta2.innerHTML = Util.preguntaActual.respuesta2; 
    respuesta3.innerHTML = Util.preguntaActual.respuesta3; 
    respuesta4.innerHTML = Util.preguntaActual.respuesta4;
    enableRespuestas();

    initTimer();


}

function cargarJuego() {
    // cargar datos
    cargaPreguntas();
}

function getPregunta(nivel, numero) {

  	if (Util.nivel == 1) {
  		return getPreguntas1().get(numero);
  	}
  	if (Util.nivel == 2) {
  		return getPreguntas2().get(numero);
  	}
  	if (Util.nivel == 3) {
  		return getPreguntas3().get(numero);
  	}
    return null;
}
 
  
function cargaPreguntas() {
    // n1
    var pregunta = new Pregunta("What conventionally are the Roman numerals for the year 2011", "MMXXI", "MMXI", "MMXII", "MMVI", 2);
    getPreguntas1().add(1, pregunta );
    pregunta = new Pregunta("What degrees temperature is the same in Centigrade/Celsius as it is in Fahrenheit", "40", "25", "43", "-1", 1);
    getPreguntas1().add(2, pregunta );
    pregunta = new Pregunta("Who was the first professional cricketer to be knighted", "Jack Sparrow", "Severiano Ballesteros", "Jack Hobbs", "Adam Gilchrist", 3);
    getPreguntas1().add(3, pregunta );
    pregunta = new Pregunta("What French term is used in English when referring to a thought or experience that a person believes he/she has already seen before", "Deja vu", "Already seen", "Voila", "Le Amour", 1);
    getPreguntas1().add(4, pregunta );
    pregunta = new Pregunta("Which US president had the nickname 'King of Camelot'", "John F Kennedy", "John Adams", "James Monroe", "Jimmy Carter", 1);
    getPreguntas1().add(5, pregunta );
    pregunta = new Pregunta("How many zeros are represented by the metric multiple prefix 'tera'", "Three", "Nine", "Twelve", "Six", 3);
    getPreguntas1().add(6, pregunta );
    pregunta = new Pregunta("The nuclear disaster site at Chernobyl, to which tourist visits begin/began in 2011, is in which country", "URSS", "Afghanistan", "Albania", "Ukraine", 1);
    getPreguntas1().add(7, pregunta );
    pregunta = new Pregunta("The move called 'en passant' features in what board game", "Trivia", "Checkers", "Chess", "Risk", 3);
    getPreguntas1().add(8, pregunta );
    pregunta = new Pregunta("South-West is how many degrees on a compass", "90", "225", "180", "305", 2);
    getPreguntas1().add(9, pregunta );
    pregunta = new Pregunta("Which bird, which lays the largest egg in proportion to its body size of all birds, is an apteryx", "Sparrow", "Kiwi", "Pigeon", "Gull", 2);
    getPreguntas1().add(10, pregunta );
    // n2
    pregunta = new Pregunta("Name the Google phone and software system which, according to some news reports in 2010, ended Nokia's 10 years' of market dominance", "Ios", "Symbian", "Android", "Web Os", 3);
    getPreguntas2().add(1, pregunta );
    pregunta = new Pregunta("Naxos, Santorini, and Mykanos are among what group of Greek islands", "Cyclades", "Baleares", "Fiji", "Veridian", 1);
    getPreguntas2().add(2, pregunta );
    pregunta = new Pregunta("What was secret police of East Germany", "Stasi", "KGB", "German Police", "Suspicious Cops", 1);
    getPreguntas2().add(3, pregunta );
    pregunta = new Pregunta("How many vertices does a cube have", "Nine", "Twelve", "Eight", "Five", 3);
    getPreguntas2().add(4, pregunta );
    pregunta = new Pregunta("Which fruit is used in the flavouring of the cognac-based liqueur Grand Marnier", "Melon", "Banana", "Lemon", "Orange", 2);
    getPreguntas2().add(5, pregunta );
    pregunta = new Pregunta("What colour is the cross on the national flag of Finland", "Yellow", "Blue", "Red", "White", 2);
    getPreguntas2().add(6, pregunta );
    pregunta = new Pregunta("What type of creature is a Meadow Brown", "Butterfly", "Elephant", "Lion", "Dog", 1);
    getPreguntas2().add(7, pregunta );
    pregunta = new Pregunta("Medoc is a wine region in which country", "France", "Spain", "Germany", "Italy", 1);
    getPreguntas2().add(8, pregunta );
    pregunta = new Pregunta("Peter Auty sang Walking In The Air in what film", "Sharks", "The Snowman", "Revenge", "The Fighter", 2);
    getPreguntas2().add(9, pregunta );
    pregunta = new Pregunta("Name Microsoft's hands-free gaming system launched in June 2010, a made-up word alluding to joining", "Kinect", "Move", "Wiimote", "Connect", 1);
    getPreguntas2().add(10, pregunta );
    // n3
    pregunta = new Pregunta("What is this sequence: 643667767068", "A telephone number", "The longest tennis match in history", "A big sum of money", "0/23784", 2);
    getPreguntas3().add(1, pregunta );
    pregunta = new Pregunta("British Airways announced a merger with which other airline in 2010", "Iberia", "SAS", "France Airlines", "Spanair", 1);
    getPreguntas3().add(2, pregunta );
    pregunta = new Pregunta("Whose 2010 memoir was called Decision Points", "Joseph Blatter", "Horst Kohler", "Nicolas Sarkozi", "George W Bush", 2);
    getPreguntas3().add(3, pregunta );
    pregunta = new Pregunta("Which heavy metal rock band had a UK No1 hit in 1981 with their live album 'No Sleep 'Til Hammersmith'", "Motorhead", "AC/DC", "Manowar", "Metallica", 1);
    getPreguntas3().add(4, pregunta );
    pregunta = new Pregunta("What is the basic monetary unit of Australia", "Dollar", "Euro", "Sol", "Australian Dollar", 4);
    getPreguntas3().add(5, pregunta );
    pregunta = new Pregunta("Valletta is the capital of which European country", "Malta", "Spain", "Italy", "Germany", 1);
    getPreguntas3().add(6, pregunta );
    pregunta = new Pregunta("In the game of Scrabble, how many points is a 'V' tile worth", "One", "Four", "Ten", "Twelve", 2);
    getPreguntas3().add(7, pregunta );
    pregunta = new Pregunta("Who did Marilyn Monroe marry in January 1954", "Joe Dimaggio", "John Smith", "Burt Lancaster", "John wayne", 1);
    getPreguntas3().add(8, pregunta );
    pregunta = new Pregunta("In 1974, what was the title of Stephen King's first published novel", "Insomnia", "Desperation", "Rose Madder", "Carrie", 4);
    getPreguntas3().add(9, pregunta );
    pregunta = new Pregunta("In which country were the 1948 Winter Olympics held", "Switzerland", "Spain", "Germany", "Australia", 1);
    getPreguntas3().add(10, pregunta );

}
    
function initTimer() {
    Util.contador = Util.tiempoTotal;
    Util.interval = setInterval("timer()", 1000);
}    

function endTimer() {
    clearInterval(Util.interval);
}

function timer() {
    progreso.innerHTML = Util.contador;
    Util.contador --;
    if (Util.contador < 0) {
      endTimer();
      mensaje("Time is Up");
      setTimeout("respuestaErronea()",3000);
      
    }
}
    
function init() {
    disableRespuestas();
    cargarJuego();
    enableBoton();
    pintarMarcador();
}  

function pintarMarcador() {
    marcadorNivel.innerHTML = "Level: " + Util.nivel + "/" + Util.totalNiveles;
    marcadorPregunta.innerHTML = "Question: " + Util.pregunta + "/10";
    marcadorSegundos.innerHTML = "Secs: " + Util.segundosNivel + "/" + Util.numeroSegundosPasarNivel;    
}


// class

function Pregunta(pregunta, respuesta1, respuesta2, respuesta3, respuesta4, respuestaVerdadera)  {

  this.pregunta = pregunta;
  this.respuesta1 = respuesta1;
  this.respuesta2 = respuesta2;
  this.respuesta3 = respuesta3;
  this.respuesta4 = respuesta4;
  this.respuestaVerdadera = respuestaVerdadera;

}

function util() {

  this.nivel = 1;
  this.totalNiveles = 3;
  this.pregunta = 1;
  this.segundosNivel = 0;
  this.segundosTotales = 0;
  this.numeroSegundosPasarNivel = 85;
  this.preguntaActual = null;
  this.contador = 0;
  this.interval = null;
  this.tiempoTotal = 15;
}