/**
 *  AlarmManager.js : Maneja las alarmas
 */

//Funciones auxiliares

//Devuelve el máx id asignado para un cultivo de ese tipo en la lista de alarmas
function NextId(tipo_cultivo, Callback){
	var request = navigator.mozAlarms.getAll();
	request.onsuccess = function() {
		var maximo = -1;
		this.result.forEach ( function(alarm){
			datos = alarm.data.split(",");
			if (datos[2] == tipo_cultivo){
				if (maximo < datos[0])
					maximo = datos[0];
			}
		});
		Callback(maximo);
	}
	request.onerror = function (){
		alert("Ha ocurrido un ERROR: "+this.error.name);
	}
}

//Devuelve los milisegundos en los que se debe producir la alarma, teniendo en cuenta 
//las fases lunares
function InfluenciaLuna(milliseconds, dir_crecimiento){

	var MoonAge = moon_age(milliseconds);

	var inc_days = 0;
	if (dir_crecimiento == "arriba"){ //Recomendable cosecha en luna llena o creciente => pondremos luna llena y desde 1/4 creciente hacia luna llena
		if (MoonAge > 15)
			inc_days = 30 - MoonAge + 7;
		if (MoonAge < 7)
			inc_days = 7 - MoonAge;
	}
	else if (dir_crecimiento == "abajo"){ //Recomendable cosecha => en luna nueva o desde 1/4 menguante hacia nueva
		if (MoonAge < 22 && MoonAge != 0)
			inc_days = 22 - MoonAge;
	}
	return milliseconds + inc_days*86400000; //convert days to milliseconds
}

//Añade alarma
function ProgramAlarm(data, fecha_alarma){
	var request = navigator.mozAlarms.add(fecha_alarma, "honorTimezone", data);

	request.onsuccess = function (){};

	request.onerror = function() {
		alert("Ha ocurrido un error al intentar programar la alarma de RIEGO: "+this.error.name);
	}
}

//Calcula la fecha para el riego
function FechaRiego(plazo){		

	var time = new Date().getTime();
	plazo = parseInt(plazo); 
	time = time +plazo*86400000; //OK riego -> en días
	//time = time +plazo*60000;  //PRUEBAS -> Me devuelve alarma dentro de information[3]*min

	var fecha_alarma = new Date(time);//fecha.getTime() nos da la fecha actual en ms
	return fecha_alarma;
}

//Calcula la fecha para la cosecha
function FechaCosecha(plazo){
	var time = new Date().getTime();
	plazo = parseInt(plazo); 
	time = time +plazo*604800000; //OK rangoCosecha -> en semanas (conversión semanas en ms)
	//time = time +plazo*3600000; //PRUEBAS -> Consideramos rangoCosecha en horas

	return time;
}

//Fecha de cosecha del "cultivo"+"id" correspondiente en la lista de alarmas
function BuscaFecha(id, cultivo, Callback){  
	var request = navigator.mozAlarms.getAll();
	var retorno;
	request.onsuccess = function() {
		var datos;
		this.result.forEach ( function(alarm){
			datos = alarm.data.split(",");
			if (datos[0] == id && datos[2] ==cultivo){
				retorno = alarm.date;
				Callback(retorno);
				return false;
			}
		});
	}
	request.onerror = function (){
		alert("Ha ocurrido un ERROR: "+this.error.name);
	}
}




function CrearListaAlarmasAux(cultivo, id, tipo_alarma, fecha, id_alarm, enganche_ul){
	var new_li = document.createElement("li");
	var new_a = document.createElement("a");
	new_a.setAttribute("href", "#");
	new_li.appendChild(new_a);

	var new_p = document.createElement("p");
	new_p.appendChild(document.createTextNode(cultivo+" "+id+": alarma de "+tipo_alarma));
	new_p.setAttribute("class", "new_list_li");
	new_p.setAttribute("title", id_alarm);

	var new_p2 = document.createElement("p");
	new_p2.appendChild(document.createTextNode(fecha));
	new_a.appendChild(new_p);
	new_a.appendChild(new_p2);

	enganche_ul.appendChild(new_li);

	new_a.addEventListener("click",  function (){
		if (localStorage.getItem("delete_alarm") == "true"){ //Si borrar alarma
			navigator.mozAlarms.remove(new_a.firstChild.title);
			localStorage.setItem("estado", "cultivos");
			localStorage.setItem("delete_alarm", "false");
			$("#lista-alarmas").hide();
			$("#cancelar-alarmas").hide();
			$("#lista-cultivos").show();
			window.location.assign("aviso_alarma.html");

		}
	});


}

//Lista de alarmas
function CrearListaAlarmas(){
	var lista_alarmas = document.querySelector("#lista-alarmas");

	var new_section = document.createElement("section");
	new_section.setAttribute("data-type", "list");
	lista_alarmas.appendChild(new_section);

	//hijo header
	var new_header = document.createElement("header");
	var new_p =document.createElement("p");
	new_p.appendChild(document.createTextNode("Alarmas programadas"));
	new_p.setAttribute("class", "new_header");
	new_header.appendChild(new_p);

	if (localStorage.getItem("delete_alarm") == "true"){
		var new_p_del = document.createElement("p");
		new_p_del.appendChild(document.createTextNode("Pulse en la alarma para borrarla:"));
		new_p_del.setAttribute("class", "subtitulo-alarma");
		new_header.appendChild(new_p_del);
	}

	new_section.appendChild(new_header);
	//hijo ul
	var new_ul = document.createElement("ul");
	new_section.appendChild(new_ul);

	var request = navigator.mozAlarms.getAll();

	request.onsuccess = function(){
		var dato;
		this.result.forEach(function (alarm) {
			dato = alarm.data.split(",");
			CrearListaAlarmasAux(dato[2], dato[0], dato[1], alarm.date,alarm.id, new_ul);
		});
	};
	request.onerror = function() {
		alert("An error occurred "+this.error.name);
	};
}



//Para Ver alarmas y Borrar alarma
function ShowAlarm(boleano){
	localStorage.setItem("alarma", "0");
	if (boleano == true){
		localStorage.setItem("delete_alarm", "true");
		localStorage.setItem("estado", "alarmas-delete");
	}
	else localStorage.setItem("estado", "alarmas");

	$("#lista-cultivos").hide();
	$("#lista-alarmas").show();
	$("#cancelar-alarmas").show();
	CrearListaAlarmas();
}

//Borra todas las alarmas
function DeleteAllAlarm(){
	var request = navigator.mozAlarms.getAll();
	request.onsuccess = function() {
		this.result.forEach ( function(alarm){
			navigator.mozAlarms.remove(alarm.id);
		});
	}
	request.onerror = function (){
		alert("Ha ocurrido un ERROR: "+this.error.name);
	}
}


//Programa primera alarma de riego y alarma de cosecha
function ProgramarRiegoCosecha(){

	var information = localStorage.getItem("information").split(";"); 
	NextId(information[0], function(id){ //id máximo en la lista de alarmas para ese cultivo

		//incrementamos el id
		id = parseInt(id);
		id = id +1;//

		//Add alarms
		//Alarma COSECHA	
		var time_mili = FechaCosecha(information[1]); 
		var fecha_alarma = new Date(time_mili);
		var data = id+",cosecha,"+information[0]+","+information[1];

		if (localStorage.getItem("influencia_luna") == "no"){ 
			ProgramAlarm(data, fecha_alarma);
		}
		else{//cuando será óptima la cosecha en función de la luna
			var new_time_mili = InfluenciaLuna(time_mili, information[5]);
			fecha_alarma = new Date(new_time_mili);
			ProgramAlarm(data, fecha_alarma);
		}
		//Alarma RIEGO
		fecha_alarma = FechaRiego(information[3]); 
		//[1]riego/cosecha (tipo alarma), [2](tipo cultivo) , [3]riego
		data = id+",riego,"+information[0]+","+information[3]; 
		ProgramAlarm(data, fecha_alarma);
	});
}

//Programa sucesivas alarmas de riego mientras fecha_cosecha > fecha_riego
function ProgramarRiego(information){
	var information_aux = information.split(","); 
	var fecha_alarma = FechaRiego(information_aux[3]);
	BuscaFecha(information_aux[0], information_aux[2], function(fecha_cosecha){ 
		if ( fecha_cosecha > fecha_alarma){
			ProgramAlarm(information, fecha_alarma);
		}
	});
}


//Ejecuta las acciones cuando la alarma se activa
window.navigator.mozSetMessageHandler("alarm", function(mozAlarm){	

	var information = mozAlarm.data.split(",");

	if (information[1] == "riego"){
		ProgramarRiego(mozAlarm.data);

		var notification = navigator.mozNotification.createNotification("Tu huerto",information[2]+" "+information[0]+": Alarma de "+information[1]);
		notification.show();

		notification.onclick = function(){
			localStorage.setItem("information-alarm", "riego");
			//Lanzamos la app a primer plano	
			var request = window.navigator.mozApps.getSelf();
			request.onsuccess = function() {
				if (request.result)
					request.result.launch();
			}
			request.onerror = function() {
				alert("Error with the alarm");
			}
			window.location.assign("alarma.html");
		};

		notification.onclose = function(){
		}
	} //if
	else if (information[1] == "cosecha"){

		var experiencia = localStorage.getItem("experiencia");
		experiencia = parseInt(experiencia);
		experiencia = experiencia + 1;  //+ 1 tomate de experiencia

		localStorage.setItem("experiencia", experiencia);

		var notification = navigator.mozNotification.createNotification("Tu huerto",information[2]+" "+information[0]+": Alarma de "+information[1]);
		notification.show();
		notification.onclick = function(){
			localStorage.setItem("information-alarm", "cosecha");
			//Lanzamos la app a primer plano	
			var request = window.navigator.mozApps.getSelf();
			request.onsuccess = function() {
				if (request.result)
					request.result.launch();
			}
			request.onerror = function() {
				alert("Error with the alarm");
			}
			window.location.assign("alarma.html");
		};
	}	

});//mozSetMessageHandler