/**
 *  content.js : Llamadas a ManagerAlarm.js, selección de cultivos en función de los 
 *  parámetros de configuración (clima, experiencia) y en función de otros parámetros como 
 *  la fecha actual o las fases lunares
 *  
 */



$(document).ready(function(){ 

	localStorage.setItem("delete_alarm", "false");
	var menu_header = document.querySelector("#menu-button");
	var img_footer = document.querySelector("#img-subheader");
	var lista = document.querySelector("#lista-cultivos");
	var latlon = localStorage.getItem("latlon").split(",");


	var btn_info = document.querySelector("#info-button");
	//Header btn
	if (btn_info){
		btn_info.addEventListener("click", function(){
			window.open("info.html", "info");
		});
	}

	//Menú header btn
	if (menu_header){
		menu_header.addEventListener("click",  function (){
			window.location.assign("action_menu.html");
		});
	}


	//Cancelar btn
	var cancelar_alarmas = document.querySelector("#cancelar-alarmas");
	if (cancelar_alarmas){
		cancelar_alarmas.addEventListener("click", function(){
			$("#lista-alarmas").hide();
			$("#cancelar-alarmas").hide();
			$("#lista-cultivos").show();
			localStorage.setItem("estado", "cultivos");
			localStorage.setItem("delete_alarm", "false");

		});
	}



	if (localStorage.getItem("alarma") == "2"){ //Siembra cultivo => alarmas de riego y cosecha iniciales
		localStorage.setItem("alarma", "0"); 
		ProgramarRiegoCosecha();
	}


	if (localStorage.getItem("alarma") == "3") //Menú: Ver mis alarmas
		ShowAlarm(false);
	else if (localStorage.getItem("alarma") == "4") //Menú: Borrar alarma
		ShowAlarm(true);
	else if (localStorage.getItem("alarma")=="5"){ //Menú: Borrar todas las alarmas
		localStorage.setItem("alarma", "0");
		localStorage.setItem("estado","cultivos");
		DeleteAllAlarm();
		$("#lista-alarmas").hide();
		$("#cancelar-alarmas").hide();
		$("#lista-cultivos").show();
		window.location.assign("aviso_alarmas_del.html")
	}
	else if (localStorage.getItem("estado") == "cultivos"){
		$("#lista-alarmas").hide();
		$("#cancelar-alarmas").hide();
		$("#lista-cultivos").show();
	}
	else if (localStorage.getItem("estado") == "alarmas")
		ShowAlarm(false);
	else if (localStorage.getItem("estado")  == "alarmas-delete")
		ShowAlarm(true);





//	FUNCIONES: 

	//Selecciona cultivos en función del mes actual si el huerto está en el exterior
	function BuscarMes(exp, bool_ext, Callback){
		var fecha = new Date();
		var mes = fecha.getMonth()+1;
		var arrayData = new Array();

		$.indexedDB("Huerto").objectStore(exp).each(function(elemento){
			if (bool_ext == true){
				var rangoSiembra = elemento.value.rangoSiembra;
				rangoSiembra = rangoSiembra.split(",");
				if (mes >= rangoSiembra[0] && mes <= rangoSiembra[rangoSiembra.length-1]) //En la BD aparecen ordenados de menor num de mes a mayor
					arrayData.push(elemento.value); 
			}
			else arrayData.push(elemento.value); //si es interior, no seleccionamos por mes
		}).done(function(){
			Callback(arrayData);
		});

	}


	//Devuelve un booleano en función de si el cultivo soporta o no el clima
	function BuscarClima(value_clima){
		if (value_clima == 2)
			return Latlon_a_Clima2();
		if (value_clima == 3)
			return Latlon_a_Clima3();
		if (value_clima == 4)
			return Latlon_a_Clima4;

		return false;
	}


	function Latlon_a_Clima2(){ //Clima = 2 (Clima Templado, C)
		if (localStorage.getItem("altitud") >= 2000)
			return false;  //Si está a más de 2000m de altura, no es clima templado
		if (latlon[1] < -2.7667)
			return true;
		if (latlon[0] < 38.98)
			return false; //zona sureste
		if (latlon[0] > 40.9415 && latlon[0] < 42.033 && latlon[1] > -1.605)
			return false;  //franja del Ebro
		return true;
	}

	function Latlon_a_Clima3(){ //Clima = 3  (Clima Cfa y Cfb)
		if (latlon[0] < 40.15)  //Está muy al sur
			return false; 
		if (latlon[1] < -4.1474)
			return true;
		if (latlon[1] < -2.1333){
			if (latlon[0] > 41.05)
				return true;
			else 
				return false;
		}
		if (latlon[1] < -1.605)
			return true;
		if (latlon[0] > 40.9415 && latlon[0] < 42.033)
			return false; //franja del Ebro
		return true;
	}

	function Latlon_a_Clima4(){  //Clima = 4 (litoral y sur de España)
		if (latlon[0] < 39.4698)
			return true; //sur
		if (latlon[0] > 43.2817)
			return true; //litoral cantábrico
		if (latlon[1] < -8.4188)
			return true; //litoral atlántico
		if (latlon[0] > 39.4698 && latlon[0] < 41.1167 && latlon[1] > -0.6)
			return true; //litoral mediterráneo sur
		if (latlon[0] > 41.1167 && latlon[0] < 41.8538 && latlon[1] > 1.1167)
			return true; //litoral mediterráneo norte
		return false;
	}




	function CrearLista(cultivo, enganche_ul){
		var new_li = document.createElement("li");
		var new_a = document.createElement("a");
		new_a.setAttribute("href", "#");
		new_li.appendChild(new_a);

		var new_p = document.createElement("p");
		new_p.appendChild(document.createTextNode(cultivo.tipo));
		new_p.setAttribute("class", "new_list_li");
		new_p.setAttribute("title", cultivo.tipo+";"+cultivo.rangoCosecha+";"+cultivo.infoSiembra+";"+cultivo.riego+";"+cultivo.aviso+";"+cultivo.dir_crecimiento);
		new_a.appendChild(new_p);

		enganche_ul.appendChild(new_li);

		new_a.addEventListener("click",  function (){
			localStorage.setItem("information", new_a.firstChild.title);
			window.location.assign("siembra.html");
		});
	}

	function CrearListaVacia(enganche_ul){
		var new_p = document.createElement("p");
		new_p.appendChild(document.createTextNode("No existen cultivos seleccionables teniendo en cuenta sus parámetros de configuración"));
		enganche_ul.appendChild(new_p);
	}

	var experiencia_store = localStorage.getItem("experiencia");
	experiencia_store = parseInt(experiencia_store);
	var experiencia;

	if (experiencia_store < 3){
		experiencia = "cultivos_baja";
	}
	else{ //experiencia == media
		experiencia = "cultivos_media";

	}
	//Logo para marcar experiencia
	img_footer.setAttribute("src","/images/experiencia/experiencia"+experiencia_store+"_little.png");
	img_footer.setAttribute("width", "100%");
	img_footer.setAttribute("height", "100%");



	//Buscar en función del mes:
	var ext;
	if (localStorage.getItem("intext") == "exterior")
		ext = true;
	else
		ext = false;

	BuscarMes(experiencia,ext, function(arrayCultivos){
		if (arrayCultivos.length > 0){
			if (ext == true){
				for (i=0; i<arrayCultivos.length; i++){
					if (arrayCultivos[i].clima != 1){
						if (!BuscarClima(arrayCultivos[i].clima)){  
							arrayCultivos.splice(i,1);
							i--;//consecuencia del .splice
						}
					}
				}
			}
		}


		//Lista de CULTIVOS
			var new_section = document.createElement("section");
			new_section.setAttribute("data-type", "list");
			lista.appendChild(new_section);
			//hijo header
			var new_header = document.createElement("header");
			var new_p =document.createElement("p");
			new_p.appendChild(document.createTextNode("Cultivos disponibles"));
			new_p.setAttribute("class", "new_header");
			new_header.appendChild(new_p);

			new_section.appendChild(new_header);
			//hijo ul
			var new_ul = document.createElement("ul");
			new_section.appendChild(new_ul);
			if (arrayCultivos.length > 0){
				for (i=0; i<arrayCultivos.length; i++){
					CrearLista(arrayCultivos[i], new_ul);
				}
			}
			else {
				CrearListaVacia(new_ul);
			}			
	}); //BuscarMes 



}); 