/**
 * database.js
 */


//rangoCosecha (semanas)
//rangoRiego (días)

if (window.indexedDB){

	const DatosCultivos_baja = [  //Experiencia Baja
	                              {tipo: "cebolla", clima: 1, rangoSiembra: "3,4", rangoCosecha: 8, infoSiembra: "La separación entre las plantas será de unos 15 cms y algo más del doble entre hileras", riego: 1, aviso: 5, dir_crecimiento:"abajo"},
	                              {tipo: "perejil", clima: 1, rangoSiembra: "1,2,3,4,5,6,7,8,9,10,11,12", rangoCosecha: 3, infoSiembra: "La separación entre las plantas será de unos 30 cms aproximadamente", riego: 1, aviso: 0, dir_crecimiento:"arriba"},
	                              {tipo: "haba", clima: 2, rangoSiembra: "10,11", rangoCosecha: 16, infoSiembra: "La separación aproximada entre semillas será de 15 cms y entre hileras distarán unos 60 cms", riego: 4, aviso: 0, dir_crecimiento:"arriba"},
	                              {tipo: "zanahoria", clima: 2, rangoSiembra: "1,2,3,10,11,12" , rangoCosecha: 12, infoSiembra:"Se colocan las semillas muy esparcidas, disponiéndose de una profundidad mínima de 25 cm.",riego:1, aviso:-1, dir_crecimiento:"abajo"},
	                              {tipo: "acelga", clima: 2, rangoSiembra:"1,2,3,4,5,6,10,11,12", rangoCosecha: 8, infoSiembra:"La separación entre filas ha de ser de unos 45 cm, dejando unos 10 cm entre semillas.", riego: 3, aviso:-3, dir_crecimiento:"arriba"}
	                              ];

	const DatosCultivos_media = [ //Experiencia Media
	                              {tipo: "lechuga", clima: 3, rangoSiembra:"1,2,3,4,5,6,12", rangoCosecha: 8, infoSiembra: "La separación entre semillas adyacentes será de unos 20 cm y algunos cm más entre hileras", riego: 1, aviso: 5, dir_crecimiento:"arriba"},
	                              {tipo: "guisante", clima: 3, rangoSiembra: "2,3,4", rangoCosecha: 8, infoSiembra: "Surcos de unos 5 cm de profundidad con distancia entre semillas de unos 10 cm, distando las hileras unos 50 cm", riego: 3, aviso: 0, dir_crecimiento:"arriba"},
	                              {tipo: "patata", clima: 4, rangoSiembra: "4,5", rangoCosecha: 8, infoSiembra: "Se hace un agujero de unos 10 cm, dejando una separación entre semillas de unos 40 cm", riego: 7, aviso: 8, dir_crecimiento:"abajo"},
	                              {tipo: "pimiento", clima:4 , rangoSiembra: "2,3,4,5,6,7,8,9", rangoCosecha:12 ,infoSiembra:"La distancia entre filas ha de ser de unos 70 cm. El espacio entre semillas será de unos 40 cm.",riego:4 ,aviso: 10,dir_crecimiento:"arriba"},
	                              {tipo:"coliflor", clima:2, rangoSiembra:"1,2,3,4,10,11,12", rangoCosecha:12, infoSiembra:"La distancia entre plantas será de unos 45 cm y entre filas de 70 cm aproximadamente", riego: 1, aviso:0, dir_crecimiento:"arriba"},
	                              {tipo: "espinaca", clima: 3, rangoSiembra:"1,2,,9,10,11,12", rangoCosecha:8,infoSiembra:"Preferentemente se pondrán las semillas a 2 cm de profundidad, en filas separadas 30 cm.", riego:4, aviso: 2, dir_crecimiento:"arriba"}
	                              ];






	function almacen(objetoAlmacen, Datos){
		//Creamos índices para buscar los cultivos según el campo que queramos
		objetoAlmacen.createIndex("clima", "clima", {unique: false}); //según el clima
		objetoAlmacen.createIndex("rangoSiembra", "rangoSiembra", {unique: false}); //según rangoSiembra

		//Almacenamos los valores
		for (var i in Datos){
			objetoAlmacen.add(Datos[i]);
		}
	}

	//Create/open database
	var request = indexedDB.open("Huerto");
	var db;

	request.onerror = function(){
		alert("Error creando/abriendo la base de datos indexedDB");
	}

	request.onsuccess = function(){	}

	request.onupgradeneeded = function (event) { 
		db = event.target.result;
		try{
			//Como name va a ser único, lo usamos como key path
			var objStore_baja = db.createObjectStore("cultivos_baja", {keyPath: "tipo"});
			var objStore_media = db.createObjectStore("cultivos_media", {keyPath: "tipo"});

			almacen(objStore_baja, DatosCultivos_baja);
			almacen(objStore_media, DatosCultivos_media);



		}catch(e){
			alert("Exception creada por objStore");
		}
		db.close();
	}

}
else window.alert("El navegador no soporta indexedDB");