/**
           _ _                         _   
   ___ _ _| | |_ _ _ ___ ___ _ _ _ ___| |_ 
  |  _| | | |  _| | |  _| .'| | | | -_| . |
  |___|___|_|_| |___|_| |__,|_____|___|___|
                                         
	Author: Ramón García <rgarcia@culturaweb.com>
	Website: www.culturaweb.com
	Version: 1.0
	
  Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
  associated documentation files (the "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the
  following conditions:

    The above copyright notice and this permission notice shall be included in all copies or substantial
    portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
  LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
  NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
  SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

**/

var game = (function() {

	// Defaults
	var initialSpeed = 200,
			decreaseSpeed = 1,
			multiplier = 100,
			levelUp = 5,
			board = null,
			ctx = null,
			timer =	null,
			controlsHeight = 60,
			body = new Array()
			food = new Rectangle(80, 80, 20, 20),
			iBody = new Image(),
			iFood = new Image(),
			aEat = new Audio(),
			aDie = new Audio();
			lastKey = null,
			lastMove = null;
			
			
	
	// State variables.
	var PAUSE =	false,
			GAMEOVER = true,
			ALREADYPLAYED = false,
			DIR = 'right',
			LEVEL =	1,		
			SCORE =	0;
	
	// Medias.
	iBody.src = 'images/body.png';
	iFood.src = 'images/fruit.png';
	aEat.src = 	'media/chomp.aac';
	aDie.src = 	'media/dies.aac';

	

	/**
	 * vibrate
	 * 
	 * Enable vibration X seconds if device supports vibrate API.
	 */
	
	function vibrate(seconds) {
		if ('vibrate' in navigator) {
			navigator.vibrate(seconds);
			return true;
		}
		return false;
	}
	
	

	/**
	 * random
	 * 
	 * Return a random number to place new fruits inside the canvas.
	 */
	
	function random(max) {
		return parseInt(Math.random()*max);
	}
	
	

	/**
	 * Rectangle Class
	 * 
	 * Object Class to store rectangle info: coordinates, width and height.
	 */
	
	function Rectangle (x, y, width, height) {
		this.x = (x == null) ? 0 : x;
		this.y = (y == null) ? 0 : y;
		this.width = (width == null) ? 0 : width;
		this.height = (height == null) ? this.width : height;
		
		// Check if two rectangles intersects
		this.intersects = function(rect) {
			if (rect != null) {
				return (
					this.x < rect.x + (rect.width / 2) &&
					this.x + (this.width / 2) > rect.x &&
					this.y < rect.y + (rect.height / 2) &&
					this.y + (this.height / 2) > rect.y
				);
			}
		}
	}
	
	
	/* -------------------------------------------------------------------------------- */
	

	/**
	 * getPoints
	 *
	 * Get points obtained by player.
	 */
	
	var getPoints = function() {
		return SCORE*multiplier;
	}
	
	
	
	/**
	 * getLevel
	 *
	 * Get level reached by user.
	 */
	var getLevel = function() {
		return LEVEL;
	}
	
	
		
	/**
	 * changeBoardWidthAndHeight
	 * 
	 * Change canvas width and height. Called on window.onresize
	 */
		
	var changeBoardWidthAndHeight = function() {
		// First, get wrap border width 
		var expression = getComputedStyle(document.getElementById('board'), null).getPropertyValue('border-left-width'),
				border = parseInt(expression.replace("px", ""), 0);
		
		// Calculate final width and height
		board.height = window.innerHeight - border*2 - controlsHeight;
		board.width = window.innerWidth - border*2;
	}
	
	
	
	/**
	 * paint
	 * 
	 * 
	 */
	
	var paint = function(ctx) {
		ctx.clearRect(0, 0, board.width, board.height);
		for (i = 0; i < body.length; i++) {
			ctx.drawImage(iBody, body[i].x, body[i].y);
		}

		ctx.drawImage(iFood, food.x, food.y);
		ctx.fillStyle = '#000';
		ctx.font = '12px Arial';
		ctx.fillText('Score: ' + (SCORE*multiplier), 5, 15);
		ctx.fillText('Level: ' + LEVEL, 5, 30);
	
		if (PAUSE) {
			/*
			ctx.textAlign = 'center';
			ctx.font = '30px Arial';
			if (GAMEOVER) {
				ctx.fillText('GAME OVER', board.width/2, board.height / 2);
				ctx.font = '15px Arial';
				ctx.fillText('Click play to continue', board.width/2, (board.height / 2) + 30);
		
			}
			else {
				ctx.fillText('PAUSE', board.width/2, board.height / 2);
			}
			ctx.textAlign = 'left';
			*/
			//audio.pause(); ///
			document.getElementById('playpause').style.display = 'none';
			document.getElementById('menu').style.display = 'block';
			document.getElementById('continuegame').style.display = 'block';	
			document.getElementById('song').pause();	
		}
	}
	
	
	
	// Get last move code
	var lastMoveCode = function(e) {
		lastKey = e.keyCode;
		if (lastKey == 37 && DIR != 'right') DIR = 'left';
		if (lastKey == 38 && DIR != 'down') DIR = 'up';
		if (lastKey == 39 && DIR != 'left') DIR = 'right';
		if (lastKey == 40 && DIR != 'down') DIR = 'down';
	};
	
	
	
	/**
	 * init
	 * 
	 * Initialize game.
	 */
	 
	var init = function() {
		board = document.getElementById('board');
		changeBoardWidthAndHeight();
		ctx = board.getContext('2d');
		timer = setInterval(run, initialSpeed);

	};
	
	
	
	/**
	 * reset
	 * 
	 * Reset game: set score and level to 0, 
	 */
	
	var reset = function() {
		SCORE = 0;
		DIR = 'right';
		LEVEL = 0;
		body.length = 0;
		GAMEOVER = false;
		
		// Put snake on initial position
		body.push(new Rectangle(40, 40, 10, 10));
		body.push(new Rectangle(30, 40, 10, 10));
		body.push(new Rectangle(20, 40, 10, 10));
		body.push(new Rectangle(10, 40, 10, 10));
		
		// Put fruit on random position
		food.x = random(board.width / 10-1) * 10;
		food.y = random(board.height / 10-1) * 10;
	};
	
	
	
	/**
	 * run
	 * 
	 * Starts game and paint all elements on the canvas. 
	 */
	
	var run = function() {
		game();
		paint(ctx);
	};
	
	
	
	/**
	 * game
	 * 
	 * Starts game and paint all elements on the canvas. 
	 */
	 
	var game = function() {
		if (!PAUSE) {
		
			if (GAMEOVER) reset();
		
			// Move body backwards
			for (var i=body.length - 1; i>0; i--) {
				body[i].x = body[i-1].x;
				body[i].y = body[i-1].y;
			}
			
			// Direction change keyboard
			if (lastMove == 'left' && DIR != 'right') DIR = 'left';
			if (lastMove == 'up' && DIR != 'down') DIR = 'up';
			if (lastMove == 'right' && DIR != 'left') DIR = 'right';
			if (lastMove == 'down' && DIR != 'up') DIR = 'down';
			
			console.log(lastMove);
			
			// Head's move
			if (DIR == 'up') body[0].y -= 10;
			if (DIR == 'right') body[0].x += 10;
			if (DIR == 'down') body[0].y += 10;
			if (DIR == 'left') body[0].x -= 10;
			
			// Check if snake is out of screen
			if (body[0].x > board.width - body[0].width) body[0].x=0;
			if (body[0].y > board.height - body[0].height) body[0].y=0;
			if (body[0].x < 0) body[0].x = board.width - body[0].width;
			if (body[0].y < 0) body[0].y = board.height - body[0].height;
			
			// Food intersects with snake
			if (body[0].intersects(food)) {
			
				SCORE++;
				if (SCORE % levelUp == 0) {
					LEVEL++;
				}
			
				// Remove timeOut and set a new one
				// It'll increase speed at each collected fruit
				speed = (SCORE >= 70) ? 30 : initialSpeed - decreaseSpeed*SCORE;
				clearTimeout(timer);
				timer = setInterval(run, speed);
			
				body.push(new Rectangle(body[body.length-1].x, body[body.length-1].y, 10, 10));
				food.x = random(board.width / 10-1) * 10;
				food.y = random(board.height / 10-1) * 10;
				aEat.play();
			}

			// Check if the snake intersect it's body
			for (i = 2; i < body.length; i++) {
				if (body[0].intersects(body[i])) {
					alreadyPlayed = true;
					GAMEOVER = true;
					PAUSE = true;
					aDie.play();
				}
			}
	/*				alreadyPlayed = true;
					GAMEOVER = true;
					PAUSE = true;
					aDie.play();*/
		}
		
		// Pause/Unpause
		if (lastKey == 13) {
			console.log("Run");
			PAUSE = !PAUSE;
			lastKey = null;
			document.getElementById('menu').style.display = 'none';
			document.getElementById('continuegame').style.display = 'none';
			document.getElementById('playpause').style.display = 'block';
			document.getElementById('song').play();

			
		}
				
	};
	
	
	// Return API
	return {
		
		init: init,
		resize: changeBoardWidthAndHeight,
		level: getLevel
	};
	
	
})();
	
	
/* -------------------------------------------------------------------------------- */


/*
var el = document.getElementById("board");

swipedetect(el, function(swipedir) {
	console.log("Run");
	DIR = swipedir;
	return DIR;
});
*/


/* -------------------------------------------------------------------------------- */

/*screen.mozLockOrientation("portrait-primary");*/
// When page load, initialize game.
window.addEventListener('load', game.init, false);


// On resize browser, change canvas width and height
window.addEventListener('resize', game.resize, false);

// On keydown, change lastKey and dir.
/*
document.addEventListener('keydown', function(e) {
	lastKey = e.keyCode;
}, false);
*/

var left = document.getElementById('left');
var right = document.getElementById('right');
var up = document.getElementById('up');
var down = document.getElementById('down');
var playpause = document.getElementById('playpause');
var continuegame = document.getElementById('continuegame');


left.addEventListener('click', function(e) { lastMove = 'left'; });
right.addEventListener('click', function(e) { lastMove = 'right'; });
up.addEventListener('click', function(e) { lastMove = 'up'; });
down.addEventListener('click', function(e) { lastMove = 'down'; });
playpause.addEventListener('click', function(e) { lastKey = 13; });
continuegame.addEventListener('click', function(e) { lastKey = 13; });
/*document.addEventListener('keydown', function(e) {
	lastKey = e.keyCode;
}, false);*/