(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);throw new Error("Cannot find module '"+o+"'")}var f=n[o]={exports:{}};t[o][0].call(f.exports,function(e){var n=t[o][1][e];return s(n?n:e)},f,f.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
var _ = require("underscore"),
    lookups = {

  isBasic: {
    "+": true,
    "-": true,
    "/": true,
    "*": true,
    "in": true,
  },

  // maps the operator literal's name to the keyboard button's label.
  labels: {
    "square": "x^2",
    "^1/x": "y√x"
  },

  // also, (not yet) used in output.toString(). Symbols should be understood by the parser, if you've added them
  prettyOutput: {
    "sqrt": "√",
    "*": "×",
    "/": "÷",
    "in": " in ",
  },

  inputValue: {
    "in": " in ",
    "sqrt": "√(",
    "square": "^2",
    "^1/x": "^(1/",
  },

  inverse: {
    "^": "^1/x",
    "sqrt": "square"
  },

  operatorType: {
    square: "infixOp",
    "^1/x": "infixOp",
  },

  // also, (not yet) used in output.toString().
  // Dummy, for easier URL encoding.
  urlOuput: {},

  prefixOperators: [],

  infixOperators: [],

  postfixOperators: [],

};

_.defaults(lookups.labels, lookups.prettyOutput);

module.exports = lookups;

},{"underscore":51}],2:[function(require,module,exports){
"use strict";

var _ = require("underscore"),
  app = require('./turo-application'),
  Model = require("./model"),
  editing = require("./editing-controller");

function Controller () {
  this._editorController = new editing.Controller(this);
}

_.extend(Controller.prototype, {

  newStatement: function () {
    return this.model.putStatement();
  },

  getStatement: function (id) {
    return this.model.getStatementWithId(id);
  },

  getEditorController: function () {
    return this._editorController;
  },

  initModel: function () {
    var self = this;  
    var m = this._newModel();
    this.turo = m.turo;
    this.model = m.include('app');
    return;
    
  },

  _newModel: function () {
    return new Model();
  },
});


module.exports = Controller;

},{"./editing-controller":3,"./model":8,"./turo-application":10,"underscore":51}],3:[function(require,module,exports){
var _ = require("underscore");

/************************************************************
 * Stateless helpers.
 * 
 ************************************************************/

var states = {
  APPEND_ONLY: 0,
  ENTER_PRESSED: 1,
};

var expressionEditor = require('./expression-src-editor'),
    editor = new expressionEditor.ExpressionEditor();


/************************************************************
 * Constructor and properties
 * 
 ************************************************************/

function Controller(calculator) {
  this.calculator = calculator;
  this.state = states.APPEND_ONLY;
  
  // defined in beginEditing.
  this._history = undefined;
}

Object.defineProperties(Controller.prototype, {
  $keyboard: {
    get: function () {
      return this._$keyboard;
    },

    set: function ($keyboard) {
      if (this._$keyboard) {
        // unregister for events.
      }
      this._$keyboard = $keyboard;
      if ($keyboard) {
        // register for events
      }
    }
  },
});

_.extend(Controller.prototype, {

  bindControls: function($editor, $keyboard) {
    var self = this;
    this.$editor = $editor;
  },

/************************************************************
 * From UI
 * 
 ************************************************************/

  clearPressed: function(e) { 
    this.updateStatement("", "");
  },

  enterButtonPressed: function(e) {
    // We should probably just use model properly here.
    var self = this,
        string;

    if (self.state === states.ENTER_PRESSED) {
      return;
    }
    // we only do something when we have a result.
    self.state = states.ENTER_PRESSED;

    if (self.lastResult) {
      string = self.lastResult.valueToString();

      // Get the answer, and assign it to "Ans".
      // But on't, whatever you do, cascade the result.
      // There is likely a memory leak here, where expressions will be
      // cached against Ans.
      self.$keyboard.answer = self.calculator.model._evaluateString(string, 'Ans');
      self.$keyboard.hasAnswer = true;

      self.updateStatement(string, string);      
    }

    self._history.length = 0;
  },



  writerPressed: function(e) {
    // I'm not sure where the cursor is going to go,
    // i.e. where the character/token should end up.
    //this.$keyboard.style.background = 'red';
    var self = this;
    var key = e.key;
    var string = self.turoStringBeingEdited;

    // XXX this is because we special case prefixOp to be available when it's not.
    e.type = e.type || 'prefixOp';

    // the one we are about to invalidate, we push onto the history stack.
    self._history.push(string);

    // TODO editor needs to be able to get the cursorPosition
    var lineToCursor = string; // self.$editor.lineToCursor;
    var offset = lineToCursor.length;
    var isa = function isa(oneOf) {
      return _.indexOf(oneOf, e.type) >= 0;
    };

    if (states.ENTER_PRESSED === self.state) {
      // check classList of $button.
      var action;
      if (isa(["digits", "variable"])) {
        action = "REPLACE";
      } else if (!isa(self.enterAppendSet) && !isa(['prefixOp', 'parensOpen'])) {
        action = "REPLACE";
      }

      switch (action) {
      case "REPLACE":
        string = key;
        self._history.length = 0;
        break;
      default:
        string = editor.append(string, this.latestValidTree, e);
        break;
      }
      this.turoStringCursorPosition = string.length;
      lineToCursor = string;
    } else if (states.APPEND_ONLY === self.state) {
      var cursorPosition = this.turoStringCursorPosition || 0,
          prevLength = string.length || 0;

      string = editor.insert(string, cursorPosition, this.latestValidTree, e);
      cursorPosition += string.length - prevLength;
      lineToCursor = string.substring(0, cursorPosition);
      this.turoStringCursorPosition = cursorPosition;

      // TODO editor needs to be able to set the cursorPosition
      //self.$editor.cursorPosition += cursorPosition;
      
    }

    self.state = states.APPEND_ONLY;

    // update statement uses self.state.
    self.updateStatement(string, lineToCursor);
    
  },

  deletePressed: function() {
    var self = this,
        string = self.turoStringBeingEdited;

    if (self.state === states.ENTER_PRESSED) {
      string = "";
      self._history.length = 0;
    } else if (self._history.length) {
      string = self._history.pop();
    } else {
      string = string.substring(0, string.length - 1);  
    }

    //self.$editor.deletePrecedent();

    self.state = states.APPEND_ONLY;
    self.updateStatement(string);
  },

  cycleUnitScheme: (function () {
    return function () {
      var turo = this.calculator.model.turo,
          prefs = turo.prefs(),
          index = prefs.unitSchemeIndex || 0,
          unitSchemes = turo.units.unitSchemes,
          schemeNames = unitSchemes.getUnitSchemes();

      if (index >= schemeNames.length) {
        prefs.unitScheme = null;
        prefs.useUnitRefactor = false;
        index = 0;
      } else {
        prefs.unitScheme = schemeNames[index];
        index ++;
      }


      prefs.simpleUnits = false;
      this.refreshAnswerUi();

      prefs.unitSchemeIndex = index;
    };
  }()),

/************************************************************
 * 
 ************************************************************/

  refreshAnswerUi: function () {
    var self = this,
        string;

      // Get the answer, and assign it to "Ans".
      // But on't, whatever you do, cascade the result.
      // There is likely a memory leak here, where expressions will be
      // cached against Ans.
    self.$keyboard.answer = self.calculator.model._evaluateString('Ans');
    if (self.lastResult) {
      this.$editor.statement = self.lastResult;
    }
  },

  beginEditing: function(statement) {
    if (!statement) {
      this.commitEdit();
    }
    this.statement = statement;

    this.$editor.statement = statement;
    this.$keyboard.active = !!statement;

    if (statement) {
      var src = statement.result.expressionToString(),
          lineToCursor = src === '0' ? "" : src;
      this.identifier = statement.result.identifier;
      this.updateStatement(src, lineToCursor);
      this.turoStringBeingEdited = lineToCursor;
      this.turoStringCursorPosition = lineToCursor.length;
    }

    this._history = [];
  },

  updateStatement: function(fullLine, lineToCursor) {
    var expression = fullLine,
        predictor = this.calculator.model.getTokenPredictor();

    this.turoStringBeingEdited = expression;

    if (lineToCursor === undefined) {
      lineToCursor = expression;
    }

    // TODO make sure we get to hear about this identifier changing
    var result = this.calculator.model.evaluateString(expression, this.identifier, this.statement),
        value = result.value();

    var layout;
    var hasUnits;
    
    if (states.ENTER_PRESSED === this.state) {
      var emptySet = predictor.createKeyboard("");
      var appendSet = predictor.createKeyboard(lineToCursor);
      
      
      this.enterAppendSet = _.keys(appendSet);

      layout = _.extend({}, emptySet, appendSet);
    } else {
      layout = predictor.createKeyboard(lineToCursor);
    }

    if (value) {
      hasUnits = (!!value.unit);
    }

    this.updateStatementUi(layout, result, hasUnits);

    if (!result.expressionErrors()) {
      this.lastResult = result;
    }

    if (!result.parseError) {
      this.latestValidTree = result;
    } else {
      delete this.latestValidTree;
    }
  },

  updateStatementUi: function (layout, result, hasUnits) {
    // For the web version, there is a dependence: 
    // hasUnits doesn't get rendered until layout is set.
    if (hasUnits !== undefined) {
      this.$keyboard.hasUnits = hasUnits;
    }
    this.$keyboard.layout = layout;
    this.$editor.statement = result;
  },

  commitEdit: function() {
    if (!this.statement) {
      return;
    }

    this.calculator.model.putStatement(this.turoStringBeingEdited, this.identifier, this.statement.index);

    this.finishEditing();
  },

  finishEditing: function() {
    // can we remove events?
    this.statement = null;
  }
});


module.exports = {
  Controller: Controller
};

},{"./expression-src-editor":6,"underscore":51}],4:[function(require,module,exports){
"use strict";

var _ = require('underscore'),
  EventEmitter = require('events').EventEmitter,
  application = require('../app/turo-application'),

  buttons = require('./button-lookups');

/***************************************************************/
var stringTimes = function (string, times) {
  var s = "";
  for (var i=0; i<times; i++) {
    s += string;
  }
  return s;
};
/***************************************************************/

var EditorController = function EditorController($native) {
  if ($native) {
    this.onLoad($native);
    this.onResume();
  }
  this._numberDisplayPrefs = {
    useUnitRefactor: true,
    index: 0,
  };
};

EditorController.prototype = new EventEmitter();

_.extend(EditorController.prototype, {
    onLoad: function ($native) {
      this.$native = $native;

      
      this.editor = application.editor;
    },

    onResume: function () {
      this.editor.$editor = this;
    },

    onUnload: function () {
      this.editor = null;
    },

    deletePrecedent: function () {

    },

    beginEditingIdentifier: function () {
      // unused, but for toggling between input fields.
    },

    beginEditingExpression: function () {
      // unused, but for toggling between input fields.
    },

    cycleUnitScheme: function () {
      this.editor.cycleUnitScheme();
    },


  }
);

Object.defineProperties(EditorController.prototype, {
  lineToCursor: {
    get: function () {

    }
  },
  cursorPosition: {
    set: function (cursorPosition) {
      console.log("EditorController.cursorPosition");
      //this.$native.setCursorPosition(cursorPosition);
    }
  },
  statement: {
    set: function (statement) {
      // t is a transferable object, defined in idl.
      var t = {
        id: statement.id,
      };
      var prefs = application.model.turo.prefs();
      
      t.expressionToString = statement.src || statement.expressionToString(buttons.prettyOutput, { operatorPadding: true });
      if (!statement.expressionErrors()) {
        t.resultToString = statement.valueToHtml({
          precisionType: "sf", 
          precisionDigits: 12, 
          useUnitRefactor: true,
          unitScheme: prefs.unitScheme,
          exponent: true, 
          prettyPrint: true
        });
      }

      t.autoSuffix = stringTimes(")", statement.addedParens);
      
      t.identifierToString = statement.identifierToString() || '';
      
      var identifierErrors = statement.identifierErrors();
      if (identifierErrors) {
        t.identifierErrorToString = 'UMM';
      }

      t.unitScheme = prefs.unitScheme || 'Default';

      // TODO this should be a method call.
      this.$native.statement = t;
    }
  },
});

module.exports = EditorController;
},{"../app/turo-application":10,"./button-lookups":1,"events":22,"underscore":51}],5:[function(require,module,exports){
var _ = require('underscore'),
    Touchy = require('touchy'),
    trx = require('tiny-rx');

var hasClass = function(className){
  
  if (arguments.length === 1) {
    return function(e){
      return e.button.className.indexOf(className) >= 0;
    };  
  }
  
  var args = _.toArray(arguments);
  return function(e){
    return _.intersection(e.button.classList, args).length > 0;
  };
};

var getParent = function($element, attr, value) {
  while ($element && $element[attr] !== value){
    $element = $element.parentNode;
  }
  return $element;
};

var getParentWithTest = function ($element, test) {
  while ($element && !test($element)) {
    $element = $element.parentNode; 
  }
  return $element;
};

var keyboardTouchy = new Touchy('x-turo-keyboard');
var keyboardTaps = keyboardTouchy.taps.map(function(e){
  e.button = getParent(e.target, 'nodeName', 'BUTTON');
  if(e.button){
    return e;
  }
}).truethy();

var enter = keyboardTaps.filter(hasClass('enterButton'));

var editorTouchy = new Touchy('x-turo-editor');
var editorTaps = editorTouchy.taps.map(function (e) {
  e.button = getParentWithTest(e.target, function ($e) {
    // XXX this feels like a disgusting hack to me.
    // I'm almost wishing I had done this as a tag 'x-turo-tappable'.
    return $e.nodeName.indexOf('X-TURO-') === 0;
  });
  if(e.button){
    return e;
  }
}).truethy();

module.exports = {
  bindKeyboardEvents: keyboardTouchy.bindEvents,
  bindEditorEvents: editorTouchy.bindEvents,
  taps: keyboardTaps,
  swiper: keyboardTouchy.swiper,
  writer: keyboardTaps.filter(hasClass('writer')),
  goHome: keyboardTaps.filter(hasClass('goHome')),
  delete: keyboardTaps.filter(hasClass('delete')),
  clear: keyboardTaps.filter(hasClass('clear')),
  variables: keyboardTaps.filter(hasClass('variables')),
  variableButtons: keyboardTaps.filter(hasClass('variable')),
  operatorButtons: keyboardTaps.filter(hasClass('infixOp', 'prefixOp', 'postfixOp')),
  unitPer: keyboardTaps.filter(hasClass('unitPer')),
  unitScheme: keyboardTaps.filter(hasClass('unitScheme')),
  unitIn: keyboardTaps.filter(hasClass('unitIn')),
  dimension: keyboardTaps.filter(hasClass('dimension')),
  inverse: keyboardTaps.filter(hasClass('inverse')),
  enter: enter,
  enterButton: enter,
  currentResult: editorTaps.filter(hasClass('result')),
  unitSchemeSelector: editorTaps.filter(hasClass('unit-scheme')),
};

},{"tiny-rx":25,"touchy":27,"underscore":51}],6:[function(require,module,exports){
var _ = require('underscore');

/************************************************************
  Private utility functions.
/************************************************************/
function clone (src) {
  return src.clone();
}

function _considerParens(expressionString, cursorPosition) {
  return expressionString[cursorPosition] === ')' || 
         false; // expressionString[cursorPosition] === '(';
}

function chip(string, cursorPosition) {
  return string.substring(0, cursorPosition) + '|' + string.substring(cursorPosition);
}

function debug(string, cursorPosition, msg, nodeType, node) {
  if (string) {
    console.log(chip(string, cursorPosition ) + ' ' + nodeType + ": " + msg);
  } else {
    console.log(cursorPosition + ' ' + nodeType + ': ' + msg);
  }
}


/************************************************************
  Token finder by cursor.
/************************************************************/

function CursorPositionTokenFinder() {
  // ctor
}

// Methods
_.extend(CursorPositionTokenFinder.prototype, {

  _visitCloneChild: function (node, property, position, ctx) {
    return node[property].accept(this, position, ctx);
  },

  _drillDownUnits: function (node, position, ctx) {
    ctx.valueNode = node;
    return this._drillDown(node, 'unitNode', position, ctx);
  },

  _drillDown: function (node, property, position, ctx) {
    var child = node[property];
    if (child && position >= child.offsetFirst && 
        position <= child.offsetLast) {
      return this._visitCloneChild(node, property, position, ctx);
    }
  },

  _afterOperator: function (node, property, position, ctx) {
    if (node._offsetLiteralFirst <= position &&
        position < node[property].offsetFirst) {
      ctx._isAfterOperator = true;
      return this._nonTerminal(node, position, ctx);
    }
  },

  _terminalInBrackets: function (node, position, ctx) {
    if (node.inBrackets) {
      if (node.offsetFirst === position || 
          node.offsetLast === position) {
        ctx._onBrackets = true;
        return this._matchFound(node, position, ctx);
      }
    }
  },

  _nonTerminalInBrackets: function (node, position, ctx) {
    if (node.inBrackets) {
      if (node.offsetFirst === position || 
          node.offsetLast === position) {
        ctx._onBrackets = true;
        return this._matchFound(node, position, ctx);
      }
    }
  },  

  _drillDownLeft: function (node, property, position, ctx) {
    var child = node[property];
    if (!child) {
      return;
    }
    if (child.offsetFirst <= position && position < node._offsetLiteralFirst) {
      return this._visitCloneChild(node, property, position, ctx);
    }
    return this._drillDown(node, property, position, ctx);
  },

  _drillDownRight: function (node, property, position, ctx) {
    var child = node[property];
    if (!child) {
      return;
    }
    if (child.offsetFirst <= position && position < node.offsetLast) {
      return this._visitCloneChild(node, property, position, ctx);
    }
    return this._drillDown(node, property, position, ctx);
  },

  _matchFound: function (node, cursorPosition, ctx) {
    throw new Error('Unimplemented');
  },

  _nonTerminal: function (node, position, ctx) {
    return this._matchFound(node, position, ctx);
  },

  visitUnaryOperation: function(node, position, ctx) {
    return this._drillDown(node, 'value', position, ctx) || 
           this._nonTerminal(node, position, ctx);
  },

  visitBinaryOperator: function(node, position, ctx) {
    debug(ctx.string, position, 'Finding', 'BinaryOperator', node);
    return this._nonTerminalInBrackets(node, position, ctx) ||
           this._drillDownLeft(node, 'left', position, ctx) || 
           this._afterOperator(node, position, 'right', ctx) ||
           this._drillDownRight(node, 'right', position, ctx) || 
           this._nonTerminal(node, position, ctx);
  },

  visitUnitPower: function (node, position, ctx) {
    return this._nonTerminalInBrackets(node, position, ctx) ||
           this._drillDownLeft(node, 'unitNode', position, ctx) || 
           this._afterOperator(node, position, 'exponent', ctx) ||
           this._drillDownRight(node, 'exponent', position, ctx) || 
           this._nonTerminal(node, position, ctx);
  },

  visitUnitMultOp: function (node, position, ctx) {
    return this._drillDownLeft(node, 'left', position, ctx) || 
           this._drillDownRight(node, 'right', position, ctx) || 
           this._nonTerminal(node, position, ctx);
  },

  visitInteger: function(node, position, ctx) {
    return this._drillDownUnits(node, position, ctx) ||
           this._matchFound(node, position, ctx);
  },

  visitIdentifier: function(node, position, ctx) {
    return this._matchFound(node, position, ctx);
  },

  visitUnitLiteral: function (node, position, ctx) {
    return this._matchFound(node, position, ctx);
  },
});

/************************************************************
  CondemnedTokenFinder
/************************************************************/

function CondemnedTokenFinder() {
  // ctor
}
CondemnedTokenFinder.prototype = new CursorPositionTokenFinder();

// Methods
_.extend(CondemnedTokenFinder.prototype, {
  _matchFound: function (node, cursorPosition, ctx) {
    var newString;
    if (ctx.editor) {
      newString = node.accept(ctx.editor, cursorPosition, ctx) || ctx.string;
    } else {
      newString = ctx.string;
    }
    return newString;
  }
});

/************************************************************
  InsertionTokenFinder
/************************************************************/

function InsertionTokenFinder() {
  // ctor
}
InsertionTokenFinder.prototype = new CursorPositionTokenFinder();

// Methods
_.extend(InsertionTokenFinder.prototype, {
  _matchFound: function (node, position, ctx) {
    var newString;
    if (ctx.editor) {
      newString = node.accept(ctx.editor, position, ctx) || ctx.string;
    } else {
      newString = ctx.string;
    }
    return newString;
  }
});


/************************************************************
  TokenDeleter
/************************************************************/

function TokenDeleter () {
  // ctor
}

var padding = function (string, pos) {
      // check we;re not removing a bracket from between two words
      if (pos > 0 && pos < string.length - 2) {
        return (/\w{2}/).exec(string[pos - 1] + string[pos + 1]) ? " " : "";
      }
      return "";
    };

// Methods
_.extend(TokenDeleter.prototype, {

  // deals with the very specific case of: (|1.2) -> 1.2 and (1.2)| -> 1.2
  _deleteMatchingParens: function (node, position, string) {
    
    var removeParens = function remove (open, close) {
      return string.substring(0, open) +  // up until the (
        // not the open parens
        padding(string, open) + 
        string.substring(open + 1, close) + // between the '(' and the ')'
        // not the close parens
        padding(string, close) +
        string.substring(close + 1); 
    };
    
    if (node.inBrackets) {
      if (node.offsetFirst === position || node.offsetLast === position) {
        return removeParens(node.offsetFirst, node.offsetLast);
      }
    }
  },

  _deleteNonMatchingParens: function (node, position, string) {
    if (node.inBrackets) {
      if (node.offsetFirst === position || node.offsetLast === position) {
        return string.substring(0, position) + padding(string, position) + string.substring(position + 1);
      }
    }
  },

  visitUnaryOperation: function(node, position, ctx) { 
    var string = ctx.string;
    var insertionPoint, excisionPoint;
    if (node.isPrefix) {
      insertionPoint = node.offsetFirst;
      excisionPoint = node.value.offsetFirst;
    } else {
      insertionPoint = node.value.offsetLast + 1;
      excisionPoint = node.offsetLast + 1;
    }
    return string.substring(0, insertionPoint) + string.substring(excisionPoint);
  },

  visitBinaryOperator: function(node, position, ctx) { 
    var string = ctx.string;

    var newString = this._deleteNonMatchingParens(node, position, string);
    if (!newString) {
      newString = string.substring(0, node._offsetLiteralFirst) + string.substring(node._offsetLiteralLast + 1);
    }

    return newString;
  },

  visitInteger: function(node, position, ctx) { 
    var string = ctx.string;
    if (node.valueNode) {
      return node.valueNode.accept(this, position, ctx);
    }
    debug(string, position, 'Deleting', 'Integer', node);
    var newString = this._deleteMatchingParens(node, position, string);
    if (!newString) {
      newString = string.substring(0, position) + string.substring(position + 1);
    }

    return newString;
  },

  visitIdentifier: function(node, position, ctx) { 
    var string = ctx.string;
    debug(string, position, 'Deleting', 'Identifier', node);
    var newString = this._deleteMatchingParens(node, position, string);
    if (!newString) {
      var start = node._offsetLiteralFirst;
      var end = node._offsetLiteralLast + 1;
      newString = string.substring(0, start) + string.substring(end);
    }
    return newString;
  },

  visitUnitLiteral: function (node, position, ctx) { 
    var string = ctx.string;
    debug(string, position, 'Deleting', 'UnitLiteral', node);
    var start = node.offsetFirst;
    var end = node.offsetLast + 1;
    while (string[start - 1] === ' ') {
      start --;
    }
    return  string.substring(0, start) + string.substring(end);
  },

  visitUnitPower: function(node, position, ctx) { 
    var string = ctx.string;
    debug(string, position, 'Deleting', 'UnitPower', node);
    return string.substring(0, node.unitNode.offsetLast + 1) + string.substring(node.exponent.offsetLast + 1);
  },

  visitUnitMultOp: function(node, position, ctx) { 
    var string = ctx.string;
    debug(string, position, 'Deleting', 'UnitMultOp: ' + node.literal + '.', node);
    if (node.literal === '/') {
      return string.substring(0, node.left.offsetLast + 1) + ' ' + string.substring(node.right.offsetFirst);
    }
    return string.substring(0, node.left.offsetFirst) + string.substring(node.right.offsetFirst);
  },

});

/************************************************************
  Token Inserter
  Currently deliberately a very small subset of circumstances.
/************************************************************/

function TokenInserter () {
  // ctor
}

// Methods
_.extend(TokenInserter.prototype, {

  

  visitUnaryOperation: function(node, position, ctx) {
    var token = ctx.token,
        string = ctx.string;
    var insertionPoint = node.value.offsetFirst;
    // TODO this needs some polish: '(2' + '1/x' should be sqrt(1/2
    // It's not clear if this is where the problem is.
    return string.substring(0, insertionPoint) + token.key + string.substring(insertionPoint);
  },


  _insertAtTerminalCloseParensMaybe: function (node, position, token, string) {
    var cut1, cut2;
    if (!node.inBrackets) {
      return;
    }

    // here: we only care about things after the end of the operator token. 
    if (position === node.offsetLast) {
      // (1+x)| + sin( -> sin(1+x)
      cut1 = node.offsetFirst;
      // we don't want bracket proliferation, so remove the existing one.
      var containsBrackets = (token.key.indexOf('(') >= 0);
      cut2 = containsBrackets ? cut1 + 1 : cut1;
      
    } else if (node.offsetFirst < position) { // in the brackets not on the brackets.
      cut1 = cut2 = node._offsetLiteralFirst;
    }


    if (cut1 !== undefined) {
      return string.substring(0, cut1) + token.key + string.substring(cut2);
    }
  },

  _insertAtCloseParensMaybe: function (node, position, token, string) {
    var cut1, cut2;

    // here: we only care about things after the end of the operator token. 
    if (node.inBrackets && position === node.offsetLast) {
      // (1+x)| + sin( -> sin(1+x)
      cut1 = node.offsetFirst;
      // we don't want bracket proliferation, so remove the existing one.
      var containsBrackets = (token.key.indexOf('(') >= 0);
      cut2 = containsBrackets ? cut1 + 1 : cut1;
      return string.substring(0, cut1) + token.key + string.substring(cut2);
    }
  },

  visitBinaryOperator: function(node, position, ctx) {
    var token = ctx.token,
        string = ctx.string,
        cut1, cut2;
    var _debug = false; // (chip(string, position + 1) === '(1+|2)');
    function d(string) {
      if (_debug) {
        console.log('not ok ' + string);
      }
    }

    // here: we only care about things after the end of the operator token. 
    var retValue = this._insertAtCloseParensMaybe(node, position, token, string);
    if (retValue) {
      d('_insertAtCloseParensMaybe');
      return retValue;
    } else if (node.inBrackets && position < node.offsetFirst) {
      // |(1+2) -> sin
      d('Before first bracket');
      cut1 = node.offsetFirst;
    } else if (node.left.offsetFirst <= position && position < node._offsetLiteralFirst) {
      d('The beginning of the left to just before the operator');
      // (|1+2) -> (sin(1+2)
      cut1 = node.left.offsetFirst;
    } else if (node._offsetLiteralFirst <= position) {
      d('After the beginning of the operator');
      cut1 = node.right.offsetFirst;
    } else if (position < node._offsetLiteralFirst) { // i.e. before the operator symbol literal.
      d('Before the operator?');
      cut1 = node.left.offsetFirst;
    } else {
      d('Default?');
      cut1 = node.offsetFirst;
    }

    if (cut2 === undefined) {
      cut2 = cut1;
    }

    return string.substring(0, cut1) + token.key + string.substring(cut2);
  },

  visitInteger: function(node, position, ctx) {
    var token = ctx.token,
        string = ctx.string;

    // This is just for unitPower calls. 2 m^3. If we are '2', valueNode is undefined, '3' points to '2'.
    if (node.valueNode) {
      return node.valueNode.accept(this, position, ctx);
    }
  
    var insertionPoint;

    if (token.type === 'prefixOp' || token.type === 'parensOpen') {
      var retValue = this._insertAtTerminalCloseParensMaybe(node, position, token, string);
      if (retValue) {
        return retValue;
      } else if (position < node.offsetFirst) {
        insertionPoint = position;
      } else if (position <= node.offsetLast) {
        insertionPoint = node.offsetFirst;
      } else {
        insertionPoint = node.offsetFirst; // we be at the end of the input.
      }
    } else if (token.type === 'exponent' || token.type === 'point') {
      // TODO implement checking if there exists 
      // '.' or 'e', and move it to here if it can.
    }

    // TODO is the integer node in brackets?

    var newString = string.substring(0, insertionPoint) + token.key + string.substring(insertionPoint);
    return newString;
  },

  visitIdentifier: function(node, position, ctx) {
    var token = ctx.token,
        string = ctx.string;
    var insertionPoint;

    if (position <= node.offsetFirst) {
      insertionPoint = position;
    } else if (position <= node.offsetLast) {
      insertionPoint = node.offsetFirst;
    } else {
      return "BAD_IDENTIIER: " + chip(string, position);
    }

    // TODO is the integer node in brackets?

    return string.substring(0, insertionPoint) + token.key + string.substring(insertionPoint);
  },

  visitUnitLiteral: function (node, position, ctx) {
    return ctx.valueNode.accept(this, position, ctx);
  },

  visitUnitPower: function(node, position, ctx) {
    return ctx.valueNode.accept(this, position, ctx);
  },

  visitUnitMultOp: function(node, position, ctx) {
    return ctx.valueNode.accept(this, position, ctx);
  },

});


/************************************************************
  ExpressionEditor
/************************************************************/

function ExpressionEditor() {
}

var _prototype = ExpressionEditor.prototype;

// stateless
var condemnedTokenFinder = new CondemnedTokenFinder(),
    tokenDeleter = new TokenDeleter(),
    luckyTokenFinder = new InsertionTokenFinder(),
    tokenInserter = new TokenInserter();

// Properties
Object.defineProperties(_prototype, {

});


// Methods
_.extend(_prototype, {
  append: function (expressionString, node, token) {
    return this.insert(expressionString, expressionString.length, node, token);
  },

  insert: function (expressionString, cursorPosition, node, token) {
    // input assumptions: 
    // - expressionToString is the current expression.
    // - node is the ast node of the current complete expression. If absent, the expressionString is not parseable.
    // - token in a struct which should be the same as passed from editor-controller.

    // output assumptions: 
    // - return should be a string.
    // - it does not have to be completely parsable (e.g. '1+').
    var beginString = expressionString.substring(0, cursorPosition),
        endString = expressionString.substring(cursorPosition);

    if (!node || !expressionString) { // expressionString === ''
      return beginString + token.key + endString;
    }
    switch (token.type) {
      case 'unit':
        if (expressionString[cursorPosition - 1] !== '/') {
          beginString += ' ';
        }
        break;
      case 'prefixOp':
      case 'parensOpen':
        return this._insert(expressionString, node, token, cursorPosition);
      default:
        
    }
    return beginString + token.key + endString;
  },

  _insert: function (expressionString, node, token, ogCursorPosition) {
    var cursorPosition = ogCursorPosition, 
      ast = node.expression();

    while (cursorPosition === ' ') {
      cursorPosition --;
    }
    // explicitly consider character before and at the cursor position.
    // _considerParens should be used at insert point to detect '(' as last typed and if prefixOp or openParens

    // insert in binary node should explicitly deal with left, right, in between, and in brackets

    var ctx = {
      path: [],
      string: expressionString, // only for DEBUG
      considerBrackets: _considerParens(expressionString, cursorPosition - 1),
      editor: tokenInserter,
      token: token,
    };

    if (cursorPosition >= expressionString.length) {
      cursorPosition = expressionString.length;
    }

    var astNode, insertPoint, excisionPoint;
     
    if (false && ctx.considerBrackets) {
      // if the user has just typed a close parens
      // we can find out the ASTNode that those parens belonged to.
      expressionString = ast.accept(luckyTokenFinder, cursorPosition - 1, ctx);
      
      // // we're going to insert at the beginning of the astNode.
      // insertPoint = astNode.offsetFirst;
      
      // // skipping the existing open parens '(' if the token will supply its own.
      // excisionPoint = insertPoint;
      // if (token.key.indexOf('(') >= 0) {       
      //   excisionPoint = insertPoint + 1;
      // }

      // expressionString = expressionString.substring(0, insertPoint) + token.key + expressionString.substring(excisionPoint);
    } else {
      // the user has typed something, but not a close parens
      // BUT we have the AST, so we know that it resulted in a successful expression.
      // The last successful token the user pressed is contained in this node:

      expressionString = ast.accept(luckyTokenFinder, cursorPosition - 1, ctx);

      // it could be any number of things:
      // A Terminal: if the cursor is in the middle of an integer, it would be cool to remove an existing dot or exponent.
      // An operator node, some where in the middle of the operator literal (or padding) itself.
      // A unit, unitPer or unitPow
      // node.inBrackets may be true, and this will affect node.offsetFirst. 
    }

    return expressionString;
  },

  _delete: function (expressionString, node, cursorPosition) {
    // expressionString: manadatory.
    // node - the result of evaluating expressionString. At this point, it is known that expressionString is parsable.
    // cursorPosition is the last known position of the cursor
    var ast = node.expression();

    var ctx = {
      path: [],
      string: expressionString, // only for DEBUG
      considerBrackets: _considerParens(expressionString, cursorPosition - 1),
      editor: tokenDeleter,
    };

    if (cursorPosition >= expressionString.length) {
      cursorPosition = expressionString.length;
    }
    if (cursorPosition > 0) {
      return ast.accept(condemnedTokenFinder, cursorPosition - 1, ctx);
    } else {
      return expressionString;
    }
  },

});

module.exports = {
  ExpressionEditor: ExpressionEditor
};
},{"underscore":51}],7:[function(require,module,exports){
"use strict";

var _ = require('underscore'),
  EventEmitter = require('events').EventEmitter;

var KeyboardController = function KeyboardController($native) {
  if ($native) {
    this.onLoad($native);
    this.onResume();
  }
};

KeyboardController.prototype = new EventEmitter();

_.extend(KeyboardController.prototype, {
    onLoad: function ($native) {
      this.$native = $native;

      var application = require('./turo-application');
      this.editor = application.editor;
      var variables = application.model.turo.variables;

      var variableNames = _.chain(variables.definitions).keys().filter(function (k) {
        return variables.getVariableDefinition(k).isConstant;
      }).value();
      this.$native.variables = variableNames;
    },

    onResume: function () {
      this.editor.$keyboard = this;
    },

    onUnload: function () {
      this.editor = null;
    },

    writerPressed: function (e) {
      this.editor.writerPressed(e);
    },

    clearPressed: function (e) {
      this.editor.clearPressed(e);
    },

    enterButtonPressed: function (e) {
      this.editor.enterButtonPressed(e);
    },

    deletePressed: function (e) {
      this.editor.deletePressed(e);
    }
    
  });

Object.defineProperties(KeyboardController.prototype, {
  layout: {
    set: function (_layout) {
      this.$native.layout = _layout;
    }
  },
  hasUnits: {
    set: function (_hasUnits) {
      this.$native.hasUnits = _hasUnits;
    }
  },
  answer: {
    set: function (ans) {
      this.$native.answer = {
        resultToString: ans.valueToString(),
        resultToHtml: ans.valueToHtml({
          precisionType: "sf", 
          precisionDigits: 6,
          useUnitRefactor: true,
          exponent: true, 
          prettyPrint: true
        }),
      };
    }
  }
});

module.exports = KeyboardController;
},{"./turo-application":10,"events":22,"underscore":51}],8:[function(require,module,exports){
"use strict";

var _ = require("underscore"),
  EventEmitter = require('events').EventEmitter,
  turo = require("turo"),
  Turo = turo.Turo,
  output = require("./to-html");

/*
 * TODO Refactor This is way too much UI in the model.
 */
var monkeyPatch_valueToHtml = function (prefs) {
  this._calculateValue(prefs);
  return output.toString(this.value(), undefined, prefs);
};

var monkeyPatch_expressionToHtml = function (literals) {
  if (this.parseError) {
    return this.src;
  }
  var string = output.toString(this.expression(), literals);
  console.log('expression = ' + string);
  return string;
};


var Statement = function(result){
  this.result = result;
};

_(Statement.prototype).extend(EventEmitter.prototype, {

  toString: function () {
    return this.result.toSource();
  },

  toHtml: function(){
    return this.result.toHtml();
  },

  expressionToString: function (literals) {
    if (!this.result || !this.result.ast || this.result.ast.statementType) {
      return this.src;
    }
    return this.result.expressionToString(literals);
  },

  expressionErrors: function () {
    return this.result.expressionErrors();
  },

  expressionToHtml: function (prefs) {
    if (prefs) {
      prefs = _.defaults(prefs, this.result.turo.prefs());
    } else {
      prefs = this.result.turo.prefs();
    }
    return output.toString(this.result.expression(), undefined, prefs);
  },

  // TODO Refactor This is way too much UI in the model.
  valueToHtml: function (prefs) {
    if (prefs) {
      prefs = _.defaults(prefs, this.result.turo.prefs());
    } else {
      prefs = this.result.turo.prefs();
    }
    return output.toString(this.result.value(), undefined, prefs);
  },

  valueToString: function () {
    return this.result.valueToString();
  },

  identifierToString: function () {
    return this.result.identifierToString();
  },

  identifierErrors: function () {
    return this.result.identifierErrors();
  },
});

var Model = function(_turo, statements, id2Indexes) {
  this.turo = _turo || new Turo({
    formatComma: ",",
    precisionType: "sf",
    precisionDigits: 10
  });
  this.statements = statements || [];
  this.indexes = id2Indexes || this._rebuildIndexes();
  this.identifiers = {};
  this.selected = null;

  this._nextId = 0;

  _(this).bindAll('removeStatement');
};

_.extend(Model.prototype,
  EventEmitter.prototype,
  {
    putStatement: function (string, name, i) {
      var id;
      if (i !== undefined && this.statements[i]) {
        // Use the existing identifier if one is specified.
        id = this.statements[i].id;

        // now look for opportunities to rename and delete.

        var oldIdentifier = this.statements[i].result.identifier(),
        newIdentifier = name;

        if (oldIdentifier) {
          // Do this now, before eval because turo knows what the old variable was up.
          if (!newIdentifier) {
            this.turo.removeVariable(oldIdentifier);
          } else if (newIdentifier !== oldIdentifier) {
            this.renameVariable(oldIdentifier, newIdentifier);
          }
        }
      }
      if (id === undefined) {
        id = this._nextId++;
      }

      var result = this._evaluateString(string, name, id);
      var statement = this._commitStatement(result, i);
      statement.src = result.src;

      this.emit('onChange', statement);

      return statement;
    },

    reset: function () {
      _.each(this.statements, function (statement) {
        statement.removeAllListeners();
      });
      this.removeAllListeners();
    },

    include: function (name) {
      this.turo.include(name);
      return this;
    },

    _evaluateString: function (string, name, id) {
      var src = (name) ? (name + " = " + string) : string,
          result;

      result = this.turo.evaluate(src, undefined, id);
      // not sure if we want this to be the expression or the variable definition.
      result.src = src;
      result.valueToHtml = monkeyPatch_valueToHtml;
      result.expressionToHtml = monkeyPatch_expressionToHtml;
      return result;
    },

    getSelectedStatement: function(string){
      return this._getStatement(this.selected);
    },

    /**
    * Reinsert statement back into the model.
    *
    * The statement choses where in the statements list
    * it will end up.
    *
    * The caller can overide the position in the model by
    * using a numerical index, i.
    *
    * If nothing sensible can done, append to the list.
    *
    */
    _commitStatement: function (result, i) {

      //assert typeof i === 'number';
      //assert typeof statement.id == 'number';

      var numStatements = this.statements.length;
      if (typeof i !== "number") {
        var existing = this.indexes[result.id];
        if (existing !== undefined) {
          i = this.indexes[existing];
        } else {
          i = numStatements;
        }
      }

      var statement;
      if (i === undefined || i > numStatements) {
        i = numStatements;
      } else if (i < 0) {
        i = 0;
      }

      if (i === numStatements) {
        statement = new Statement(result);
        this.statements.push(statement);
      } else {
        statement = this.statements[i];
        statement.result = result;
      }

      this.indexes[result.id] = i;
      statement.index = i;
      statement.id = result.id;

      // Process consequents here.

      this._processCascade(result);

      return statement;
    },

    _processCascade: function (result) {
      var consequents = result.consequents(),
      self = this;
      _(consequents).each(function (r) {
        var index = self.indexes[r.id],
        s = self.statements[index];
        s.index = index;
        r.index = index;
        s.result = r;
        // the list items listen on this one
        s.emit("onModelChanged");
      });
    },

    evaluateString: function (string, name, index) {
      var statement, id;
      if (index !== undefined) {
        if (typeof index === 'number') {
          statement = this.statements[index];
        } else if (index.result) {
          statement = index;
        }
        id = statement.id;
      }


      var result = this._evaluateString(string, undefined, id);

      if (statement) {
        result.index = statement.index;
        result.id = statement.id;

      }

      var declared;
      if (name) {
        result._identifier = name;

        // Make sure the parser agrees this is a valid identifier.
        // This will make using the native soft keyboard more acceptable.
        try {
          this.turo.parser.parse(name, "IdentifierLiteral");
        } catch (e) {
          result._identifierErrors = [e];
          return result;
        }

        declared = this.turo.variables.getVariableDefinition(name);
        if (declared && declared.id !== id) {
          result._identifierErrors = [new turo.Error("DUPLICATE_VARIABLE_DEFINITION")];
        }

      }
      return result;
    },

    renameVariable: function (oldName, newName) {
      this.turo.renameVariable(oldName, newName);
    },

    getStatements: function () {
      return this.statements;
    },

    getStatementWithId: function (id) {
      var index = this.indexes[id];
      if (index !== undefined) {
        return this._getStatement(index);
      }
    },

    getTokenPredictor: function () {
      return this.turo.getTokenPredictor();
    },

    _getStatement: function (i) {
      return this.statements[i];
    },

    swapStatements: function (i, j) {
      var im = this.indexes,
      s = this.statements,
      tmp;

      // the indexes track the id => index mapping.
      im[s[i].id] = j;
      im[s[j].id] = i;

      // actually do the swap
      tmp = s[i];
      s[i] = s[j];
      s[j] = tmp;

      // update the indexes
      s[i].index = i;
      s[j].index = j;

      this.emit('onChange');
    },

    removeStatement: function(index) {
      // TODO do we have to make sure this is an int?
      index = parseInt(index);

      var i, max = this.statements.length - 1,
      removed = this.statements[index],
      im = this.indexes;

      if (!removed) {
        return;
      }

      var result = removed.result;

      // and remove ourselves from any statements we're listening to,
      // and from the variables object.
      result.dispose();

      // now re-evaluate the consequents cascade.
      this._processCascade(result);


      // Delete the statement from the list.
      this.statements.splice(index, 1);

      // Now to maintain the map of ids -> indexes
      delete im[removed.id];

      for (i = index; i < max; i++) {
        var statement = this.statements[i];
        im[statement.id] = statement.index = i;
      }

      // If we'd selected this statement,
      // then we should not be selecting anything.
      if (this.selected === index) {
        this.selected = null;
      }

      // we should tell it that it's not part of the list anymore
      delete removed.index;

      // Tell all the things.
      this.emit('onStatementRemoved', index);
      this.emit('onChange');
    },

    _rebuildIndexes: function () {
      var s = this.statements,
      im = this.indexes = {},
      i = 0, max = s.length;

      for (; i < max; i++) {
        im[s[i]] = i;
        s[i].index = i;
      }

      return im;
    },

    pinStatement: function (i) {

    },

    unpinStatement: function (i) {

    },


  });

module.exports = Model;

},{"./to-html":9,"events":22,"turo":43,"underscore":51}],9:[function(require,module,exports){
"use strict";
var _ = require("underscore"),
    turo = require("turo"),
    toSource = turo.toSource;

function _formatNumber (string, comma, point) {
  var parts = string.split(".");
  parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, comma);
  return parts.join(point);
}

var display = _.defaults({
  bracketStart: function (node, tokens, context) {
    if (node.inBrackets || this.alwaysDisplayParens) {
      this.pushTokens(tokens, '<span class="bracket">(</span>');
    }
  },

  bracketEnd: function (node, tokens, context) {
    // TODO check if this close token didn't really exist.
    if (node.inBrackets || this.alwaysDisplayParens) {
      tokens.push('<span class="bracket">)</span>');
    }
  },

  /********
   * Colors and styles.
   */

  identifier: function (string, isConstant) {
    return '<span class="identifier">' + string + '</span>';
  },

  operator: function (string, context) {
    string = this._literal(string, context);
    return '<span class="operator">' + string + '</span>';
  },

  number: function (string, context) {
    var tokens = [], prefs = context.prefs;
    tokens.push('<span class="number">');
    if (prefs.formatComma) {
      string = _formatNumber(string, prefs.formatComma, prefs.formatDot || ".");
    }

    tokens.push(string);
    tokens.push('</span>');
    return tokens.join("");
  },

  powerStart: function (tokens, context) {
    // cursor should be able to navigate layout spans.
    tokens.push('<span class="superscript">');
  },

  powerEnd: function (tokens, context) {
    tokens.push('</span>');
  },

  unitStart: function (unit, tokens, context) {
    tokens.push(" ");
  },

  unitEnd: function (unit, tokens, context) {},

}, toSource.stringDisplay);

module.exports = {
  toString: toSource.createToString(display),
  display: display,
  displayImpliedParentheses: function (bool) {
    display.alwaysDisplayParens = !!bool;
  },
};

},{"turo":43,"underscore":51}],10:[function(require,module,exports){
var application = {};

Object.defineProperties(application, {
});

function lazyGetter (property, fn) {
	var propertyName = '_' + property;
	Object.defineProperty(application, property, {
		get: function () {
			var instance = application[propertyName];
			if (!instance) {
				application[propertyName] = instance = fn.apply(application, arguments);
			}
			return instance;
		}
	});
}

lazyGetter('model', function () {
	return application.calculator.model;
});

lazyGetter('calculator', function () {
	var Calculator = require('./calculator-controller');
	return new Calculator();
});

lazyGetter('editor', function () {
	return application.calculator.getEditorController();
});


module.exports = application;
},{"./calculator-controller":2}],11:[function(require,module,exports){
var fs = require('fs');

xtag.register('x-turo-button', {
  lifecycle: {
    created: function(){
      this.innerHTML = '<button>' + this.innerHTML + '</button>';
    }
  },
//  events: {
//    'tap': function(){
//      xtag.fireEvent(this);
//    }
//  }
});

},{"fs":21}],12:[function(require,module,exports){
'use strict';
var fs = require('fs'),
    _ = require('underscore');

var massageTuroIntoViewModel = function(turo){
  // TODO this should be done in turo. It is.
  // This is a bug in turo. 
  var vm = {units: {}};
  var unitSchemes = turo.units.unitSchemes;
  _(unitSchemes.getUnitSchemes()).each(function(schemeName){
    console.log('Unit scheme ' + schemeName);
    vm.units[schemeName] = {};

    _(unitSchemes.getDimensions(schemeName)).each(function(dimensionName){
      vm.units[schemeName][dimensionName] = unitSchemes.getUnitNames(schemeName, dimensionName);
    });
  });
  return vm;
};

xtag.register('x-turo-calculator', {
  lifecycle: {
    created: function(){
      var application = require('../app/turo-application'),
          calculator = application.calculator,
          editor = application.editor,
          data = this.xtag.data;
      data.controller = calculator;

      data.editor = editor;

      data.controller.initModel();

      xtag.innerHTML(this, "<!--TODO: Remember to add back in for Release 2\n<div class=\"hidden navbar index-top\">\n    <button class=\"list navbar-button\">&#9776;</button>\n    <button class=\"addStatement navbar-button\">+</button>\n</div>-->\n<x-turo-editor></x-turo-editor>\n<x-turo-keyboard></x-turo-keyboard>\n");

      

      data.$statementList = this.querySelector('x-turo-list');
      data.$editor = this.querySelector('x-turo-editor');
      data.$keyboard = this.querySelector('x-turo-keyboard');
      data.$listButton = this.querySelector('button.list');
      data.$addStatementButton = this.querySelector('button.addStatement');

      var self = this;

      // resizing.
      // XXX this should probably be in a main somewhere.
      // Also: it should work from the width of self, not width of body.
      function onResize () {
        // Magic numbers.
        var pagesized=window.innerWidth/18;//Proportionate font size to page
        pagesized=Math.max(pagesized,6);//Set size to be no less than 6 px
        pagesized=Math.min(pagesized,30);//& No greater than 30 px

        self.style.fontSize=pagesized + "px";//Set body default font size
      }
      onResize();
      window.onresize = onResize;

      // TODO: Remember to add back in for Release 2
      // xtag.addEvent(data.$statementList, "onSelectStatement", function (e) {
      //   var id = e.target.uid;
      //   self.statement = data.controller.getStatement(id);
      // });
      
      self.newStatement();

      
      self.statement = data.controller.getStatement(0);
      data.$editor.setAttribute('enabled', true);
      data.$keyboard.buttons = massageTuroIntoViewModel(data.controller.model.turo);
      data.$keyboard.setAttribute('enabled', true);
    }
  },

  events: {
    'tap:delegate(button.list)': function (e) {
      var $calculator = e.currentTarget;
      $calculator.statement = undefined;
    },

    'tap:delegate(button.addStatement)': function (e) {
      var $calculator = e.currentTarget;
      $calculator.newStatement();
    },
  },

  accessors: {
    statement: {
      set: function (statement) {
        var isEditing = !!statement,
        data = this.xtag.data;

        // TODO: Remember to add back in for Release 2
        // data.$statementList.visible = !isEditing;
        // data.$addStatementButton.active = !isEditing;
        // data.$listButton.active = isEditing;

        data.editor.beginEditing(statement);
      }
    }
  },

  methods: {
    newStatement: function () {
      var data = this.xtag.data;
      var statement = data.controller.newStatement();
      data.editor.commitEdit();
      this.statement = statement;
    },
  }
});

},{"../app/turo-application":10,"fs":21,"underscore":51}],13:[function(require,module,exports){
// We could put a bunch of logic in here: e.g. a little DFA tracking unitScheme behaviour.
// NOT going to do that, because if/when we decide to kirinize, then that logic should be pushed 
// out of the UI, or re-implemented in a native language.
xtag.register('x-turo-current-answer', {
  lifecycle: {
    created: function(){
      this.innerHTML = '';
    }
  },

  accessors: {
    html: {
      set: function (string) {
        this.innerHTML = string || '';
      },
    },
  },
});
},{}],14:[function(require,module,exports){
var fs = require('fs');
var _ = require('underscore');
var expressionTemplate = _.template("<div class=\"token <%=type%>\"><%=value%></div>\n");

xtag.register('x-turo-cursor', {
  methods: {
  }
});

},{"fs":21,"underscore":51}],15:[function(require,module,exports){
var fs = require('fs');
var _ = require('underscore');

xtag.register('x-turo-editor', {
  lifecycle: {
    created: function() {
      xtag.innerHTML(this, "<x-turo-editor-statement></x-turo-editor-statement>\n");
      var Controller = require('../app/editor-display-controller');
      var controller = this.xtag.controller = new Controller(this);

      setTimeout(function () {
        var events = require('../app/events');
        events.bindEditorEvents();

        events.currentResult.subscribe(function (e) {
          
        });

        events.unitSchemeSelector.subscribe(function (e) {
          controller.cycleUnitScheme();
        });
      }, 1);

    }
  },

  accessors: {
    statement: {
      set: function(statement){
        if (statement) {
          this.$statement.value = statement;
        }
        this.setAttribute('enabled', !!statement);
      }
    },

    $statement: {
      get: function () {
        return this.querySelector('x-turo-editor-statement');
      }
    },
  }
});

},{"../app/editor-display-controller":4,"../app/events":5,"fs":21,"underscore":51}],16:[function(require,module,exports){
// this method is being used for keeping track of the order of html tokens
var identifyHtmlTokens = function(string){
  var i = 0;
  return string.replace(/<x-turo-token/gi, function(){
    return '<x-turo-token number="'+ i++ +'" ';
  });
};

// Taken from http://snipplr.com/view/2107/
//create function, it expects 2 values.
var insertAfter = function(newElement,targetElement) {
  //target is what you want it to go after. Look for this elements parent.
  var parent = targetElement.parentNode;

  //if the parents lastchild is the targetElement...
  if(parent.lastchild === targetElement) {
    //add the newElement after the target element.
    parent.appendChild(newElement);
  } else {
    // else the target has siblings, insert the new element between the target and it's next sibling.
    parent.insertBefore(newElement, targetElement.nextSibling);
  }
};

var fs = require('fs');
var _ = require('underscore');
var expressionTemplate = _.template("<div class=\"token <%=type%>\"><%=value%></div>\n");

var expression = {
  lifecycle: {
    created: function(){
      this.html = '';
    }
  },

  methods: {
    render: function(html){
      xtag.innerHTML(this, html);
    }
  },

  accessors: {
    $tokens: {
      get: function(){
        return this.querySelectorAll('x-turo-expression');
      }
    },

    lineToCursor: {
      get: function(){
        var previousSibling = this.$cursor.previousSibling;
        var lineToCursor = '';
        while(previousSibling){
          lineToCursor+= previousSibling.textContent;
          previousSibling = previousSibling.previousSibling;
        }
        return lineToCursor;
      }
    },

    $cursor: {
      get: function(){
        return this.querySelector('x-turo-cursor');
      }
    },

    value: {
      get: function(){
        return this.getAttribute('value');
      }
    },

    html: {
      set: function(html){
        this.render(html);

        var text = this.textContent || this.innerText || "0";
        this.setAttribute('value', this.textContent);
      },
      get: function(){
        return this.innerHTML;
      }
    },

    editable: {
      set: function (bool) {
        if (bool) {
          this.removeAttribute('disabled');
        } else {
          this.setAttribute('disabled', true);
        }
      }
    },

    cursorPosition: {
      get: function () {
        return this.xtag.data.cursorPosition;
      },
      set: function(number){
        if(typeof number !== 'number'){
          throw new Error('Argument has to be a number');
        }
        this.xtag.data.cursorPosition = number;
      }
    }
  }
};

xtag.register('x-turo-expression', expression);
xtag.register('x-turo-editor-expression', _(expression).extend({
  methods: {
    deletePrecedent: function(){
      if(this.$cursor.previousSibling){
        this.$cursor.previousSibling.remove();
        this.cursorPosition--;
      }
      this.setAttribute('value', this.textContent.replace(' ', ''));
    },

    render: function(html){

      var template = _("<%=expression%><x-turo-cursor></x-turo-cursor><span class=\"autoParens\"></span>\n").template();
      xtag.innerHTML(this, template({expression: html}));

      if(this.textContent === '0'){
        this.innerHTML = '';
      }

      this.resizeFontSize();
      //return this.renderCursor(); //TODO: Reimplement cursor rendering when we have a moveable cursor
    },

    resizeFontSize: function(){
      // Responsive fontSize
      if(this.style.fontSize.length > 0){
        this.style.fontSize = '';
      }
      var fontSize = this.xtag.data.fontSize;
      if (!fontSize) {
        fontSize = this.offsetHeight;
        this.xtag.data.fontSize = fontSize;
      }
      
      var desired = this.parentElement.offsetWidth * 0.9,
          actual = this.offsetWidth;

      if (actual > desired) {
        fontSize = fontSize * (desired / actual);
      }
      this.style.fontSize = fontSize + 'px';
      return fontSize;
    },

    renderCursor: function(position){
      var $cursor = this.querySelector('x-turo-cursor') || document.createElement('x-turo-cursor');
      this.appendChild($cursor);
    }  
  }
}));

},{"fs":21,"underscore":51}],17:[function(require,module,exports){
var mouseEvent = 'click';
if(typeof window.ontouchstart !== 'undefined'){
  mouseEvent = 'click';
}

var fs = require('fs'),
    _ = require('underscore'),
    KeyboardController = require('../app/keyboard-controller'),
    events = require('../app/events.js');


xtag.register("x-turo-keyboard", {
  lifecycle: {
    created: function(){
      var $keyboard = this,
          controller = new KeyboardController();
      xtag.innerHTML(this, "<div class=\"keyboard-top-row p-l--l p-r--l p-t--l p-b--l row b-b m-b\">\n    <div class=\"c1in5 full-height multi\">\n        <button class=\"small parensDisabled\">( )</button>\n        <button class=\"small writer parensOpen\" value=\"(\">( <span class=\"greyed-out\">)</span></button>\n        <button class=\"small writer parensClose\" value=\")\"><span class=\"greyed-out\">(</span> )</button>\n    </div>\n    <div class=\"c2in5 full-height\"><button class=\"writer variable ans\">Answer</button></div>\n    <div class=\"c1in5 full-height\"><button class=\"delete\"><span class=\"icon-erase\"></span></button></div>\n    <div class=\"c1in5 full-height\"><button class=\"enterButton\">=</button></div>\n</div>\n\n<div id=\"slider\" class=\"keyboard-main swipe\">\n    <div class=\"swipe-wrap\">\n        <div style=\"height:100%;\" class=\"p-r--l p-l--l p-t on home-keyboard tab active-tab swipe-item\">\n            <!--\n        Class significance:\n          variables: for the keyboard event registration, i.e. events in javascript, registered in x-turo-keyboard.js\n          variable: for the parser to enable/disable the button, i.e. display, controlled by x-turo-keyboard.styl\n\n          writer: keyboard events. writerPressed appears in the editing controller.\n          digits: parser enables/disables, i.e. display.\n      -->\n            <div class=\"row h25\">\n                <div class=\"c1in5 full-height\"><button class=\"writer digits\" value=\"7\">7</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer digits\" value=\"8\">8</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer digits\" value=\"9\">9</button></div>\n                \n                <div class=\"c1in5 full-height\"><button class=\"writer unitPer multiplyDivide\" value=\"/\">&#8725;</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer has-units unitIn\" value=\" in \"><em>in</em></button></div>\n            </div>\n            <div class=\"row h25\">\n                <div class=\"c1in5 full-height\"><button class=\"writer digits\" value=\"4\">4</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer digits\" value=\"5\">5</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer digits\" value=\"6\">6</button></div>\n\n                <div class=\"c1in5 full-height\"><button class=\"writer multiplyDivide\" value=\"×\">×</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer prefixOp\" value=\"√(\">√</button></div>\n            </div>\n            <div class=\"row h25\">\n                <div class=\"c1in5 full-height\"><button class=\"writer digits\" value=\"1\">1</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer digits\" value=\"2\">2</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer digits\" value=\"3\">3</button></div>\n\n                <div class=\"c1in5 full-height\"><button class=\"writer plusMinus\" value=\"-\">&minus;</button></div>\n                <div class=\"c1in5 full-height multi\">\n                    <button class=\"small unitPower-power-disabled\">x<span class='superscript'>y</span></button>\n                    <button class=\"small writer infixOp\" value=\"^\">x<span class='superscript'>y</span></button>\n                    <button class=\"small writer unitPower\" value=\"^\">m<span class=\"superscript\">y</span></button>\n                </div>\n            </div>\n            <div class=\"row h25\">\n                <div class=\"c1in5 full-height\"><button class=\"writer digits\" value=\"0\">0</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer point\" value=\".\">.</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer variable exponent\" value=\"e\">e</button></div>\n\n                <div class=\"c1in5 full-height\"><button class=\"writer plusMinus\" value=\"+\">+</button></div>\n                <div class=\"c1in5 full-height\"><button class=\"writer prefixOp\" value=\"1/\"><span class='superscript1'>1</span>&frasl;<span class='subscript1'>x</span></button></div>\n                <!-- \n                <div class=\"c1in5 full-height\"><button class=\"writer postfixOp\" value=\"^2\">x<span class='superscript'>2</span></button></div>\n                -->\n            </div>\n        </div>\n        <div class=\"tab p--l p-t swipe-item auxillary-keyboard\">\n            <div class='operators-keyboard'>\n            </div>\n            <div class='variables-keyboard'>\n            </div>\n            \n        </div>\n        <div class=\"units-keyboard tab p--l no-padding-right swipe-item\">\n        </div>\n    </div>\n    <ul id='position'>\n        <li class='on'></li>\n        <li></li>\n        <li></li>\n    </ul>\n</div>\n");
      this.xtag.buttonEvents = {};
      this.inverse = false;

      // I don't really have a sense of where to store data on these components
      // this., this.xtag., this.xtag.data? 
      // what are the consequence of each of these, or is it much simpler than 
      // I imagine?

      window.s = events.swiper;

      var goHome = function (e){
        events.swiper.slideTo(0);
      };

      var template = _("<div class=\"operator-list\">\n  <div class=\"row p-tb\">\n    <div class=\"c1in4 full-height\">\n      <button class=\"writer home prefixOp forwardOp\" value=\"sin(\">sin</button>\n      <button class=\"writer home prefixOp inverseOp\" value=\"asin(\">asin</button>\n    </div>\n    <div class=\"c1in4 full-height\">\n      <button class=\"writer home prefixOp forwardOp\" value=\"cos(\">cos</button>\n      <button class=\"writer home prefixOp inverseOp\" value=\"acos(\">acos</button>\n    </div>\n    <div class=\"c1in4 full-height\">\n      <button class=\"writer home prefixOp forwardOp\" value=\"tan(\">tan</button>\n      <button class=\"writer home prefixOp inverseOp\" value=\"atan(\">atan</button>\n    </div>\n    <div class=\"c1in4 full-height\">\n      <button class=\"writer home infixOp forwardOp\" value=\"^2\">x<span class=\"superscript\">2</span></button>\n      <button class=\"writer home prefixOp inverseOp\" value=\"√(\">√x</button>\n    </div>\n  </div>\n  <div class=\"row p-tb\">\n    <div class=\"c1in4 full-height\">\n      <button class=\"writer home prefixOp forwardOp\" value=\"sinh(\">sinh</button>\n      <button class=\"writer home prefixOp inverseOp\" value=\"asinh(\">asinh</button>\n    </div>\n    <div class=\"c1in4 full-height\">\n      <button class=\"writer home prefixOp forwardOp\" value=\"cosh(\">cosh</button>\n      <button class=\"writer home prefixOp inverseOp\" value=\"acosh(\">acosh</button>\n    </div>\n    <div class=\"c1in4 full-height\">\n      <button class=\"writer home prefixOp forwardOp\" value=\"tanh(\">tanh</button>\n      <button class=\"writer home prefixOp inverseOp\" value=\"atanh(\">atanh</button>\n    </div>\n    <div class=\"c1in4 full-height\">\n      <button class=\"writer home infixOp forwardOp\" value=\"^\">x<span class=\"superscript\">y</span></button>\n      <button class=\"writer home infixOp inverseOp\" value=\"√\"><span class=\"superscript\">x</span>√y</button>\n    </div>\n  </div>\n  <div class=\"row p-tb\">\n    <div class=\"c1in4 full-height\">\n      <button class=\"writer home prefixOp forwardOp\" value=\"ln(\">log<span class=\"subscript\">e</span></button>\n      <button class=\"writer home prefixOp inverseOp\" value=\"e^\">e<span class=\"superscript\">y</span></button>\n    </div>\n    <div class=\"c1in4 full-height\">\n      <button class=\"writer home prefixOp forwardOp\" value=\"log(\">log<span class=\"subscript\">10</span></button>\n      <button class=\"writer home prefixOp inverseOp\" value=\"10^\">10<span class=\"superscript\">y</span></button>\n    </div>\n\n    <div class=\"c2in4 full-height\">\n        <button class=\"nav inverse prefixOp infixOp postfixOp\">&#x21E7;</button>\n    </div>\n\n  </div>\n</div>\n").template();
      var buffer = template();
      xtag.innerHTML(xtag.query(this, '.operators-keyboard')[0], buffer);

      template = _("<div class='variable-list'>\n</div>").template();
      buffer = template();
      xtag.innerHTML(xtag.query(this, '.variables-keyboard')[0], buffer);

      controller.onLoad(this);
      controller.onResume();

      setTimeout(function(){
        events.bindKeyboardEvents();

        events.swiper.swiped.subscribe(function(index){
          xtag.removeClass(xtag.query($keyboard, '#position li.on')[0], 'on');
          xtag.addClass(xtag.query($keyboard, '#position li')[index], 'on');
        });
        
        events.goHome.subscribe(goHome);

        events.clear.subscribe(function (e) {
          goHome();
          var l = $keyboard.layout,
              operatorsFn = l.infixOp || l.prefixOp || l.postfixOp;
          if (operatorsFn) {
            $keyboard.operators = operatorsFn();
          }
        });

        events.dimension.subscribe(function (e) {
          $keyboard._displayUnits(e.button);
        });

        events.inverse.subscribe(function (e) {
          $keyboard.inverse = !$keyboard.inverse;
        });

        events.unitScheme.subscribe(function(e){
          var selectedUnitScheme = xtag.query($keyboard, '.' + e.button.value + '.unit-tab');
          if(!_(selectedUnitScheme).isEmpty()){
            xtag.removeClass(xtag.query($keyboard, '.unit-tab.active')[0], 'active');
            xtag.removeClass(xtag.query($keyboard, '.unitScheme.active')[0], 'active');
            xtag.addClass(e.button, 'active');
            xtag.addClass(selectedUnitScheme[0], 'active');
          }
        });

        events.unitIn.subscribe(function (e) {
          events.swiper.slideTo(2);
        });

        // These pass straight through to the editing-controller as "writerPressed" and clearPressed events.
        //$keyboard._registerButtons($keyboard, ["writer", "clear", "delete", "enterButton"]);
        var self = this;
        function findTokenType ($button) {
          var tokenMap = $keyboard.xtag.data.layout;
          var classList = xtag.toArray($button.classList), 
              type;
          for (var i = 0, max=classList.length; !type && i<max; i++) {
            type = classList[i];
            if (!tokenMap[type]) {
              type = null;
            }
          }
          return type;
        }

        function callButtonPress (method) {
          return function (e) {
            controller[method]({
              type: findTokenType(e.button),
              key: e.button.value || e.button.textContent.replace(/\s/gi, ''),
              classList: xtag.toArray(e.button.classList),
            });
            goHome();
          };
        }
        _.each(["writer", "clear", "delete", "enterButton"], function (key) {
          events[key].subscribe(callButtonPress(key + 'Pressed'));
        });

      }, 1);
    },
    inserted: function(){
    }
  },

  methods: {

    buildButtons: function(){
      var l = this.layout,
        operatorsFn = l.infixOp || l.prefixOp || l.postfixOp;
      this.operators = operatorsFn();
    },
  },

  accessors: {
    buttons: {
      set: function(vm){
        var template = _("<div class=\"row full-height\">\n\n  <div class=\"btn-group unit-schemes c2in5 p-r--l\">\n    <% var activeClass = ' active'; _(units).each(function(us, key){ %> \n    <div class=\"<%=key%>\"><button class=\"unit nav unitScheme<%=activeClass%>\" value=\"<%=key%>\"><%= key %></button></div>\n    <% activeClass='';}); %>\n  </div>\n  <div class=\"unit-list c3in5 full-height\">\n    <% var activeClass = ' active'; _(units).each(function(unitScheme, key){%>\n\n      <div class=\"<%= key%> unit-tab<%=activeClass%> scroll p-r--l\">\n        <div>\n          <% _(unitScheme).each(function(unitClass, className){ %>\n            <div class=\"unit-group\">\n              <header class=\"unit-group-header\">\n                <h3 class=\"unit-group-header-inner\"><%= className %></h3>\n              </header>\n              <div class=\"row full-height\">\n                <% \n                for(var i = 0; i < unitClass.length; i++){\n                  var unit =  unitClass[i];\n                  var buttonClass = \"c1in3\";\n                  var textClass = \"\";\n                  if(unit.length > 4){\n                      var buttonClass = \"c2in3\";\n                      i++;\n                  } else if(unit.length > 2){\n                      textClass = \"small\"\n                  }\n                %>\n                <div class=\"<%=buttonClass%>\"><button class=\"unit writer\" value=\"<%= unit %>\"><span class=\"<%=textClass%>\"><%= unit %></span></button></div>\n                <% if(i !==0 && (i+1) % 3 == 0 && unitClass.length > (i+1)){%></div><div class=\"row full-height p-b\"><%}%>\n                <% }; %>\n              </div>\n            </div>\n          <% }); activeClass = ''; %>\n        </div>\n    </div>\n    <%});%>\n  </div>\n</div>\n").template();
        xtag.innerHTML(xtag.query(this, '.units-keyboard')[0], template(vm));
      }
    },

    answer: {
      set: (function () {
        var self = this, 
            string = "<% if(ans){ %>\n    <div class=\"ans-display\"><%=ans%></div>\n<% }else{ %>\nAnswer\n<% } %>\n",
            template = _(string).template();
        return function (answer) {
            var $ans = xtag.query(this, 'button.ans')[0];
            xtag.innerHTML($ans, template({ ans: answer.resultToHtml }));
            $ans.setAttribute('value', answer.resultToString);
            this.hasAnswer = !!answer.resultToString;
          };
      })()
    },

    active: {
      set: function (bool) {
        if (bool) {
          this.setAttribute('enabled', true);
        } else {
          this.removeAttribute('enabled');
        }
      }
    },

    variables: {
      set: function(variables){
        var $container = xtag.query(this, '.variable-list')[0];
        var numButtons = 0, buttonsPerRow = 4,
            html = [];
        _(variables).each(function(variable){
          if (numButtons % buttonsPerRow === 0) {// row p-tb
            html.push("<div class='row p-tb'>");
          }
          numButtons++;
          html.push('<div class="c1in4 full-height"><button class="writer variable" value="');
          html.push(variable);
          html.push('">');
          html.push(variable);
          html.push('</button></div>');
          if (numButtons % buttonsPerRow === 0) {
            html.push("</div>");
          }
        });
        if (numButtons === 0 || numButtons % buttonsPerRow !== 0) {
          html.push("</div>");
        }
        xtag.innerHTML($container, html.join(""));
      }
    },

    $container: {
      get: function(){
        return this.querySelector('.keyboard-main');
      }
    },

    operators: {
      set: function(operators){
      }
    },

    // used in operators. mostly inverses.
    // TODO use a better UX for buttons with inverses and multiple related things.
    inverse: {
      get: function () {
        return this.xtag.data.extraKeyboardVisible;
      },

      set: function (bool) {
        this.xtag.data.extraKeyboardVisible = bool;
        if (bool) {
          xtag.addClass(this.$container, "inverse");
          xtag.removeClass(this.$container, "not-inverse");
        } else {
          xtag.addClass(this.$container, "not-inverse");
          xtag.removeClass(this.$container, "inverse");
        }
      }
    },

    layout: {
      set: function (tokenMap) {
        this.xtag.data.layout = tokenMap;
        var layout = _.keys(tokenMap);
        // Horrible hack to get the ans button showing only if we have an answer.
        if (this.hasAnswer) {
          layout.push("ans");
        }
        if (this.hasUnits) {
          layout.push("has-units");
        }
        this.className = layout.join(' ');
      },
      get: function() {
        return this.xtag.data.layout;
      }
    },

    hasAnswer: {
      set: function (bool) {
        this.xtag.data.hasAns = bool;
      },

      get: function () {
        return this.xtag.data.hasAns || false;
      }
    },

    hasUnits: {
      set: function (bool) {
        this.xtag.data.hasUnits = bool;
      },

      get: function () {
        return this.xtag.data.hasUnits || false;
      }
    }
  }
});


},{"../app/events.js":5,"../app/keyboard-controller":7,"fs":21,"underscore":51}],18:[function(require,module,exports){
var _ = require('underscore');

xtag.register('x-turo-list', {
  methods: {
    addStatement: function(statement){
      var $statement = document.createElement('x-turo-statement');
      $statement.editable = false;

      this.insertBefore($statement, null);

      $statement.value = statement;
      statement.on("onModelChanged", function () {
        $statement.value = statement;
      });
      return $statement;
    },

    empty: function(){
      this.innerHTML = '';
    },
  },

  events: {
    'tap:delegate(x-turo-statement)': function(){
      xtag.fireEvent(this, 'onSelectStatement');
    }
  },

  accessors: {
    visible: {
      set: function (bool) {
        this.setAttribute('enabled', bool);
      }
    },

    statements: {
      set: function (statements) {
        var self = this;
        self.empty();
        _.each(statements, function (statement) {
          self.addStatement(statement);
        });
      }
    }
  }
});

},{"underscore":51}],19:[function(require,module,exports){
var fs = require('fs'),
    _ = require('underscore');

var baseStatement = {
  lifecycle: {
    created: function(){
      xtag.innerHTML(this, "<div class=\"row\">\n    <div class=\"identifier left\"></div>\n    <x-turo-current-answer class=\"result right\"></x-turo-current-answer>\n</div>\n<div class=\"row relative\">\n    <x-turo-expression class=\"expression\"></x-turo-expression><span class=\"autoParens\"></span>\n</div>\n");
    }
  },

/* 
{ 
  id: statement.id, 
  expressionToString: statement.expressionToString(buttons.prettyOutput),
  autoSuffix: stringTimes(")", statement.addedParens),
  identifierToString: statement.
  expressionErrorToString:
  identifierErrorToString:
  resultToString: statement.valueToHtml(),
}
*/

  accessors: {
    value: {
      /* 
      { 
        id: statement.id, 
        expressionToString: statement.expressionToString(buttons.prettyOutput),
        autoSuffix: stringTimes(")", statement.addedParens),
        identifierToString: statement.
        expressionErrorToString:
        identifierErrorToString:
        resultToString: statement.valueToHtml(),
      }
      */
      set: function (t){
        this.setAttribute("data-id", t.id);

        var string = t.expressionToString;
        this.$expression.html = string;
        this.$expression.cursorPosition = string.length - 1;

        if (!t.expressionErrorToString) {
          xtag.removeClass(this.$result, 'statementError');
          var resultString = t.resultToString;
          if(resultString === '0'){
            // HTML, so will never be just 0.
            xtag.addClass(this.$result, 'hide');
          }else{
            xtag.removeClass(this.$result, 'hide');
          }
          this.$result.html = resultString;


        } else {
          // TODO: Decide how to handle errors
          // otherwise, leave the result unchanged.
        }

        this.$unitSchemeSelector.innerHTML = t.unitScheme;

        var $autoParens = this.$autoParens;

        if ($autoParens) {
          // are we an editor?
          // XXX should this work in non-editing mode?
          $autoParens.innerHTML = t.autoSuffix || '';
        }

        if (t.identifierErrorToString) {
          this.$identifier.classList.add("identifierError");
        } else {
          this.$identifier.classList.remove("identifierError");
          this.$identifier.value = t.identifierToString;
        }
      }
    },

    expression: {
      get: function () {
        return this.$expression.value;
      },

      set: function(val){
        this.$expression.html = val;
      }
    },

    $expression: {
      get: function () {
        return this.querySelector('.expression');
      }
    },

    $result: {
      get: function(){
        return this.querySelector('x-turo-current-answer.result');
      }
    },

    $identifier: {
      get: function(){
        return this.querySelector('.identifier');
      }
    },

    $autoParens: {
      get: function(){
        return this.querySelector('.autoParens');
      }
    },

    $unitSchemeSelector: {
      get: function(){
        return this.querySelector('x-turo-unit-scheme');
      }
    },

    uid: {
      set: function (id) {
        this.setAttribute("data-id", id);
      },

      get: function () {
        return this.getAttribute("data-id");
      }
    },

    identifier: {
      set: function (identifier) {
        this.querySelector('.identifier').value = identifier;
      },

      get: function () {
        return this.querySelector('.identifier').value;
      }
    }
  }
};

xtag.register('x-turo-statement', _(baseStatement).extend({
  events: {
    'tap:delegate(.btn-delete)': function(){
      xtag.fireEvent(this, 'deletePressed');
    }
  }
}));

xtag.register('x-turo-editor-statement', _(baseStatement).extend({
  lifecycle: {
    created: function(){
      xtag.innerHTML(this, "<div class=\"row relative\">\n    <x-turo-editor-expression class=\"expression p-l\"></x-turo-editor-expression>\n</div>\n<div class=\"row\">\n    <input style=\"display: none;\" class=\"identifier left\" placeholder=\"name...\">\n    <x-turo-current-answer class=\"result left p-l--l\"></x-turo-current-answer>\n    <x-turo-unit-scheme class=\"unit-scheme right p-l--l\"></x-turo-unit-scheme>\n</div>\n");
    }
  },

}));

},{"fs":21,"underscore":51}],20:[function(require,module,exports){
xtag.register('x-turo-token', {});

},{}],21:[function(require,module,exports){

},{}],22:[function(require,module,exports){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

function EventEmitter() {
  this._events = this._events || {};
  this._maxListeners = this._maxListeners || undefined;
}
module.exports = EventEmitter;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.prototype._events = undefined;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
EventEmitter.defaultMaxListeners = 10;

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function(n) {
  if (!isNumber(n) || n < 0 || isNaN(n))
    throw TypeError('n must be a positive number');
  this._maxListeners = n;
  return this;
};

EventEmitter.prototype.emit = function(type) {
  var er, handler, len, args, i, listeners;

  if (!this._events)
    this._events = {};

  // If there is no 'error' event listener then throw.
  if (type === 'error') {
    if (!this._events.error ||
        (isObject(this._events.error) && !this._events.error.length)) {
      er = arguments[1];
      if (er instanceof Error) {
        throw er; // Unhandled 'error' event
      } else {
        throw TypeError('Uncaught, unspecified "error" event.');
      }
      return false;
    }
  }

  handler = this._events[type];

  if (isUndefined(handler))
    return false;

  if (isFunction(handler)) {
    switch (arguments.length) {
      // fast cases
      case 1:
        handler.call(this);
        break;
      case 2:
        handler.call(this, arguments[1]);
        break;
      case 3:
        handler.call(this, arguments[1], arguments[2]);
        break;
      // slower
      default:
        len = arguments.length;
        args = new Array(len - 1);
        for (i = 1; i < len; i++)
          args[i - 1] = arguments[i];
        handler.apply(this, args);
    }
  } else if (isObject(handler)) {
    len = arguments.length;
    args = new Array(len - 1);
    for (i = 1; i < len; i++)
      args[i - 1] = arguments[i];

    listeners = handler.slice();
    len = listeners.length;
    for (i = 0; i < len; i++)
      listeners[i].apply(this, args);
  }

  return true;
};

EventEmitter.prototype.addListener = function(type, listener) {
  var m;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events)
    this._events = {};

  // To avoid recursion in the case that type === "newListener"! Before
  // adding it to the listeners, first emit "newListener".
  if (this._events.newListener)
    this.emit('newListener', type,
              isFunction(listener.listener) ?
              listener.listener : listener);

  if (!this._events[type])
    // Optimize the case of one listener. Don't need the extra array object.
    this._events[type] = listener;
  else if (isObject(this._events[type]))
    // If we've already got an array, just append.
    this._events[type].push(listener);
  else
    // Adding the second element, need to change to array.
    this._events[type] = [this._events[type], listener];

  // Check for listener leak
  if (isObject(this._events[type]) && !this._events[type].warned) {
    var m;
    if (!isUndefined(this._maxListeners)) {
      m = this._maxListeners;
    } else {
      m = EventEmitter.defaultMaxListeners;
    }

    if (m && m > 0 && this._events[type].length > m) {
      this._events[type].warned = true;
      console.error('(node) warning: possible EventEmitter memory ' +
                    'leak detected. %d listeners added. ' +
                    'Use emitter.setMaxListeners() to increase limit.',
                    this._events[type].length);
      if (typeof console.trace === 'function') {
        // not supported in IE 10
        console.trace();
      }
    }
  }

  return this;
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.once = function(type, listener) {
  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  var fired = false;

  function g() {
    this.removeListener(type, g);

    if (!fired) {
      fired = true;
      listener.apply(this, arguments);
    }
  }

  g.listener = listener;
  this.on(type, g);

  return this;
};

// emits a 'removeListener' event iff the listener was removed
EventEmitter.prototype.removeListener = function(type, listener) {
  var list, position, length, i;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events || !this._events[type])
    return this;

  list = this._events[type];
  length = list.length;
  position = -1;

  if (list === listener ||
      (isFunction(list.listener) && list.listener === listener)) {
    delete this._events[type];
    if (this._events.removeListener)
      this.emit('removeListener', type, listener);

  } else if (isObject(list)) {
    for (i = length; i-- > 0;) {
      if (list[i] === listener ||
          (list[i].listener && list[i].listener === listener)) {
        position = i;
        break;
      }
    }

    if (position < 0)
      return this;

    if (list.length === 1) {
      list.length = 0;
      delete this._events[type];
    } else {
      list.splice(position, 1);
    }

    if (this._events.removeListener)
      this.emit('removeListener', type, listener);
  }

  return this;
};

EventEmitter.prototype.removeAllListeners = function(type) {
  var key, listeners;

  if (!this._events)
    return this;

  // not listening for removeListener, no need to emit
  if (!this._events.removeListener) {
    if (arguments.length === 0)
      this._events = {};
    else if (this._events[type])
      delete this._events[type];
    return this;
  }

  // emit removeListener for all listeners on all events
  if (arguments.length === 0) {
    for (key in this._events) {
      if (key === 'removeListener') continue;
      this.removeAllListeners(key);
    }
    this.removeAllListeners('removeListener');
    this._events = {};
    return this;
  }

  listeners = this._events[type];

  if (isFunction(listeners)) {
    this.removeListener(type, listeners);
  } else {
    // LIFO order
    while (listeners.length)
      this.removeListener(type, listeners[listeners.length - 1]);
  }
  delete this._events[type];

  return this;
};

EventEmitter.prototype.listeners = function(type) {
  var ret;
  if (!this._events || !this._events[type])
    ret = [];
  else if (isFunction(this._events[type]))
    ret = [this._events[type]];
  else
    ret = this._events[type].slice();
  return ret;
};

EventEmitter.listenerCount = function(emitter, type) {
  var ret;
  if (!emitter._events || !emitter._events[type])
    ret = 0;
  else if (isFunction(emitter._events[type]))
    ret = 1;
  else
    ret = emitter._events[type].length;
  return ret;
};

function isFunction(arg) {
  return typeof arg === 'function';
}

function isNumber(arg) {
  return typeof arg === 'number';
}

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}

function isUndefined(arg) {
  return arg === void 0;
}

},{}],23:[function(require,module,exports){
// shim for using process in browser

var process = module.exports = {};

process.nextTick = (function () {
    var canSetImmediate = typeof window !== 'undefined'
    && window.setImmediate;
    var canPost = typeof window !== 'undefined'
    && window.postMessage && window.addEventListener
    ;

    if (canSetImmediate) {
        return function (f) { return window.setImmediate(f) };
    }

    if (canPost) {
        var queue = [];
        window.addEventListener('message', function (ev) {
            var source = ev.source;
            if ((source === window || source === null) && ev.data === 'process-tick') {
                ev.stopPropagation();
                if (queue.length > 0) {
                    var fn = queue.shift();
                    fn();
                }
            }
        }, true);

        return function nextTick(fn) {
            queue.push(fn);
            window.postMessage('process-tick', '*');
        };
    }

    return function nextTick(fn) {
        setTimeout(fn, 0);
    };
})();

process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];

process.binding = function (name) {
    throw new Error('process.binding is not supported');
}

// TODO(shtylman)
process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};

},{}],24:[function(require,module,exports){
var process=require("__browserify_process");// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// resolves . and .. elements in a path array with directory names there
// must be no slashes, empty elements, or device names (c:\) in the array
// (so also no leading and trailing slashes - it does not distinguish
// relative and absolute paths)
function normalizeArray(parts, allowAboveRoot) {
  // if the path tries to go above the root, `up` ends up > 0
  var up = 0;
  for (var i = parts.length - 1; i >= 0; i--) {
    var last = parts[i];
    if (last === '.') {
      parts.splice(i, 1);
    } else if (last === '..') {
      parts.splice(i, 1);
      up++;
    } else if (up) {
      parts.splice(i, 1);
      up--;
    }
  }

  // if the path is allowed to go above the root, restore leading ..s
  if (allowAboveRoot) {
    for (; up--; up) {
      parts.unshift('..');
    }
  }

  return parts;
}

// Split a filename into [root, dir, basename, ext], unix version
// 'root' is just a slash, or nothing.
var splitPathRe =
    /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
var splitPath = function(filename) {
  return splitPathRe.exec(filename).slice(1);
};

// path.resolve([from ...], to)
// posix version
exports.resolve = function() {
  var resolvedPath = '',
      resolvedAbsolute = false;

  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
    var path = (i >= 0) ? arguments[i] : process.cwd();

    // Skip empty and invalid entries
    if (typeof path !== 'string') {
      throw new TypeError('Arguments to path.resolve must be strings');
    } else if (!path) {
      continue;
    }

    resolvedPath = path + '/' + resolvedPath;
    resolvedAbsolute = path.charAt(0) === '/';
  }

  // At this point the path should be resolved to a full absolute path, but
  // handle relative paths to be safe (might happen when process.cwd() fails)

  // Normalize the path
  resolvedPath = normalizeArray(filter(resolvedPath.split('/'), function(p) {
    return !!p;
  }), !resolvedAbsolute).join('/');

  return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
};

// path.normalize(path)
// posix version
exports.normalize = function(path) {
  var isAbsolute = exports.isAbsolute(path),
      trailingSlash = substr(path, -1) === '/';

  // Normalize the path
  path = normalizeArray(filter(path.split('/'), function(p) {
    return !!p;
  }), !isAbsolute).join('/');

  if (!path && !isAbsolute) {
    path = '.';
  }
  if (path && trailingSlash) {
    path += '/';
  }

  return (isAbsolute ? '/' : '') + path;
};

// posix version
exports.isAbsolute = function(path) {
  return path.charAt(0) === '/';
};

// posix version
exports.join = function() {
  var paths = Array.prototype.slice.call(arguments, 0);
  return exports.normalize(filter(paths, function(p, index) {
    if (typeof p !== 'string') {
      throw new TypeError('Arguments to path.join must be strings');
    }
    return p;
  }).join('/'));
};


// path.relative(from, to)
// posix version
exports.relative = function(from, to) {
  from = exports.resolve(from).substr(1);
  to = exports.resolve(to).substr(1);

  function trim(arr) {
    var start = 0;
    for (; start < arr.length; start++) {
      if (arr[start] !== '') break;
    }

    var end = arr.length - 1;
    for (; end >= 0; end--) {
      if (arr[end] !== '') break;
    }

    if (start > end) return [];
    return arr.slice(start, end - start + 1);
  }

  var fromParts = trim(from.split('/'));
  var toParts = trim(to.split('/'));

  var length = Math.min(fromParts.length, toParts.length);
  var samePartsLength = length;
  for (var i = 0; i < length; i++) {
    if (fromParts[i] !== toParts[i]) {
      samePartsLength = i;
      break;
    }
  }

  var outputParts = [];
  for (var i = samePartsLength; i < fromParts.length; i++) {
    outputParts.push('..');
  }

  outputParts = outputParts.concat(toParts.slice(samePartsLength));

  return outputParts.join('/');
};

exports.sep = '/';
exports.delimiter = ':';

exports.dirname = function(path) {
  var result = splitPath(path),
      root = result[0],
      dir = result[1];

  if (!root && !dir) {
    // No dirname whatsoever
    return '.';
  }

  if (dir) {
    // It has a dirname, strip trailing slash
    dir = dir.substr(0, dir.length - 1);
  }

  return root + dir;
};


exports.basename = function(path, ext) {
  var f = splitPath(path)[2];
  // TODO: make this comparison case-insensitive on windows?
  if (ext && f.substr(-1 * ext.length) === ext) {
    f = f.substr(0, f.length - ext.length);
  }
  return f;
};


exports.extname = function(path) {
  return splitPath(path)[3];
};

function filter (xs, f) {
    if (xs.filter) return xs.filter(f);
    var res = [];
    for (var i = 0; i < xs.length; i++) {
        if (f(xs[i], i, xs)) res.push(xs[i]);
    }
    return res;
}

// String.prototype.substr - negative index don't work in IE8
var substr = 'ab'.substr(-1) === 'b'
    ? function (str, start, len) { return str.substr(start, len) }
    : function (str, start, len) {
        if (start < 0) start = str.length + start;
        return str.substr(start, len);
    }
;

},{"__browserify_process":23}],25:[function(require,module,exports){

/*
 * Tiny Rx Documentation
 *
 */
var EventStream, Observable, Property, addEventListener, applyExtraction, applyFilter, applyMapping, assertDomNode, assertFunction, assertNotNull, assertString, clone, fromDomEvent, inArray, isArray, isDomNode, isFunction, isNumber, isObject, isString, needlesInHaystack, trx,
  __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Observable = (function() {

  /*
   * Observable is the base primitive that all others inherit from
   */

  /*
   * The Observables constructor simply does some initalisation
   * and forwards the arguments to the init method of extended classes
   */
  function Observable() {
    this.createProperty = __bind(this.createProperty, this);
    this.createHistory = __bind(this.createHistory, this);
    this.truethy = __bind(this.truethy, this);
    this.filter = __bind(this.filter, this);
    this.later = __bind(this.later, this);
    this.extract = __bind(this.extract, this);
    this.map = __bind(this.map, this);
    this.publish = __bind(this.publish, this);
    this.once = __bind(this.once, this);
    this.subscribe = __bind(this.subscribe, this);
    this._subscribers = [];
    this._oneOffSubscribers = [];
    this._init.apply(this, arguments);
  }


  /*
   * Subscribe 
   * @param {function} subscriber - The callback that gets executed
   * whenever an event occurs
   */

  Observable.prototype.subscribe = function(subscriber) {
    this._subscribers.push(subscriber);
    return this;
  };

  Observable.prototype.once = function(subscriber) {
    this._oneOffSubscribers.push(subscriber);
    return this;
  };

  Observable.prototype.publish = function(e) {
    var index, s, so, _i, _j, _len, _len1, _ref, _ref1;
    _ref = this._subscribers;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      s = _ref[_i];
      s(e);
    }
    _ref1 = this._oneOffSubscribers;
    for (index = _j = 0, _len1 = _ref1.length; _j < _len1; index = ++_j) {
      so = _ref1[index];
      if (so) {
        so(e);
      }
      this._oneOffSubscribers.splice(index, 1);
    }
    return this;
  };

  Observable.prototype.map = function(mapping) {
    var self;
    self = this;
    return new EventStream(function(cb) {
      return applyMapping(self.subscribe, cb, mapping);
    });
  };

  Observable.prototype.extract = function(extraction) {
    var self;
    self = this;
    return new EventStream(function(cb) {
      return applyExtraction(self.subscribe, cb, extraction);
    });
  };

  Observable.prototype.later = function(delay, value, cancelingEvent) {
    var callback, self, timeoutId;
    self = this;
    callback = function() {
      return self.publish(value);
    };
    timeoutId = setTimeout(callback, delay);
    if (isFunction(cancelingEvent)) {
      return cancelingEvent(function() {
        return clearTimeout(timeoutId);
      });
    }
  };

  Observable.prototype.filter = function(condition, value) {
    var self;
    self = this;
    return new EventStream(function(cb) {
      return applyFilter(self.subscribe, cb, condition, value);
    });
  };

  Observable.prototype.truethy = function() {
    var self;
    self = this;
    return new EventStream(function(cb) {
      return self.subscribe(function(e) {
        if (e) {
          return cb(e);
        }
      });
    });
  };

  Observable.prototype.createHistory = function(steps) {
    if (steps == null) {
      steps = 100;
    }
    return this.createProperty(function(historyAsArray, e) {
      if (historyAsArray.length >= steps) {
        historyAsArray.shift();
      }
      historyAsArray.push(e);
      return historyAsArray;
    }, []);
  };

  Observable.prototype.createProperty = function(aggregator, initialValue) {
    return new Property(this.subscribe, aggregator, initialValue);
  };

  return Observable;

})();

Property = (function(_super) {
  __extends(Property, _super);

  function Property() {
    this.value = __bind(this.value, this);
    this.reset = __bind(this.reset, this);
    return Property.__super__.constructor.apply(this, arguments);
  }

  Property.prototype._init = function(subscribe, aggregator, initialValue) {
    var self;
    if (initialValue == null) {
      initialValue = 0;
    }
    self = this;
    this._initialValue = initialValue;
    this._value = clone(initialValue);
    if (isFunction(subscribe) && isFunction(aggregator)) {
      return subscribe(function(e) {
        self._value = aggregator(self._value, e);
        return self.publish(self._value);
      });
    }
  };

  Property.prototype.reset = function() {
    return this._value = clone(this._initialValue);
  };

  Property.prototype.value = function(set) {
    if (set !== void 0) {
      this._value = set;
      this.publish(this._value);
    }
    return this._value;
  };

  return Property;

})(Observable);

EventStream = (function(_super) {
  __extends(EventStream, _super);

  function EventStream() {
    this.merge = __bind(this.merge, this);
    this.addDomEvent = __bind(this.addDomEvent, this);
    this.addEvent = __bind(this.addEvent, this);
    return EventStream.__super__.constructor.apply(this, arguments);
  }

  EventStream.prototype._init = function(eventCallback) {
    if (isFunction(eventCallback)) {
      return eventCallback(this.publish);
    }
  };

  EventStream.prototype.addEvent = function(eventCallback) {
    return eventCallback(this.publish);
  };

  EventStream.prototype.addDomEvent = function(eventNames, domNodes) {
    var domNode, eventName, sNode, selected, self, _i, _len, _results;
    assertNotNull(arguments);
    if (!isArray(domNodes)) {
      domNodes = [domNodes];
    }
    if (!isArray(eventNames)) {
      eventNames = [eventNames];
    }
    self = this;
    _results = [];
    for (_i = 0, _len = domNodes.length; _i < _len; _i++) {
      domNode = domNodes[_i];
      if (isString(domNode)) {
        selected = document.querySelectorAll(domNode);
      } else {
        selected = [domNode];
      }
      _results.push((function() {
        var _j, _len1, _results1;
        _results1 = [];
        for (_j = 0, _len1 = selected.length; _j < _len1; _j++) {
          sNode = selected[_j];
          _results1.push((function() {
            var _k, _len2, _results2;
            _results2 = [];
            for (_k = 0, _len2 = eventNames.length; _k < _len2; _k++) {
              eventName = eventNames[_k];
              _results2.push(addEventListener(sNode, eventName, function(e) {
                return self.publish(e);
              }));
            }
            return _results2;
          })());
        }
        return _results1;
      })());
    }
    return _results;
  };

  EventStream.prototype.merge = function(stream) {
    var self;
    self = this;
    return new EventStream(function(cb) {
      self.subscribe(function(e) {
        return cb(e);
      });
      return stream.subscribe(function(e) {
        return cb(e);
      });
    });
  };

  return EventStream;

})(Observable);

applyMapping = function(subscriber, cb, mapping) {
  assertNotNull(subscriber, cb, mapping);
  if (isFunction(mapping)) {
    return subscriber(function(e) {
      return cb(mapping(e));
    });
  } else if (isString(mapping) || isNumber(mapping)) {
    return subscriber(function(e) {
      return cb(mapping);
    });
  }
};

clone = function(obj) {
  return JSON.parse(JSON.stringify(obj));
};

applyFilter = function(subscriber, cb, condition, value) {
  assertNotNull(subscriber, cb, condition);
  if (isString(condition)) {
    if (!value) {
      return subscribe(function(e) {
        if (e.hasOwnProperty(condition)) {
          return cb(e);
        }
      });
    } else if (value !== void 0 && value !== null) {
      return subscriber(function(e) {
        if (e[condition] === value) {
          return cb(e);
        }
      });
    } else if (isArray(value)) {
      return subscriber(function(e) {
        if (inArray(e[condition], value)) {
          return cb(e);
        }
      });
    }
  } else if (isFunction(condition)) {
    return subscriber(function(e) {
      if (condition(e)) {
        return cb(e);
      }
    });
  } else if (isObject(condition)) {
    return subscriber(function(e) {
      if (needlesInHaystack(condition, e)) {
        return cb(e);
      }
    });
  }
};

applyExtraction = function(subscriber, cb, extraction) {
  if (isFunction(extraction)) {
    return subscriber(function(e) {
      return cb(extraction(e));
    });
  } else if (isString(extraction)) {
    return subscriber(function(e) {
      return cb(e[extraction]);
    });
  }
};

inArray = function(needle, haystack) {
  var i, inHaystack, _i, _len;
  assertNotNull(needle);
  assertArray(haystack);
  inHaystack = false;
  for (_i = 0, _len = haystack.length; _i < _len; _i++) {
    i = haystack[_i];
    if (i === needle) {
      inHaystack = true;
      break;
    }
  }
  return inHaystack;
};

needlesInHaystack = function(obj, haystack) {
  var isEqual, k, sk, subHaystack, sv, v;
  isEqual = true;
  for (k in obj) {
    v = obj[k];
    if (isObject(v)) {
      subHaystack = obj[k];
      for (sk in v) {
        sv = v[sk];
        if (sv !== haystack[k][sk]) {
          isEqual = false;
          break;
        }
      }
    } else {
      if (v !== haystack[k]) {
        isEqual = false;
        break;
      }
    }
  }
  return isEqual;
};

assertFunction = function(func) {
  if (!isFunction(func)) {
    throw new Error('variable must be function -> ' + func);
  }
};

assertString = function(obj) {
  if (!isString(obj)) {
    throw new Error('variable must be String -> ' + obj);
  }
};

assertDomNode = function(domNode) {
  if (!isDomNode(domNode)) {
    throw new Error('variable must be html element ->' + domNode);
  }
};

assertNotNull = function(args) {
  var a, _i, _len, _results;
  if (!isArray(args)) {
    args = [args];
  }
  _results = [];
  for (_i = 0, _len = args.length; _i < _len; _i++) {
    a = args[_i];
    if (a === null) {
      throw new Error('variable can not be null');
    } else {
      _results.push(void 0);
    }
  }
  return _results;
};

isObject = function(obj) {
  return !!obj && (obj.constructor === Object);
};

isNumber = function(obj) {
  return typeof obj === 'number' || obj instanceof Number;
};

isDomNode = function(domNode) {
  return domNode.hasOwnProperty('nodeType');
};

isString = function(obj) {
  return typeof obj === 'string' || obj instanceof String;
};

isArray = function(obj) {
  return Object.prototype.toString.call(obj) === '[object Array]';
};

isFunction = function(obj) {
  return obj instanceof Function;
};

addEventListener = function(obj, evt, fnc) {
  if (obj.addEventListener) {
    obj.addEventListener(evt, fnc, false);
    true;
  } else if (obj.attachEvent) {
    obj.attachEvent('on' + evt, fnc);
  } else {
    evt = 'on' + evt;
    if (typeof obj[evt] === 'function') {
      fnc = (function(f1, f2) {
        return function() {
          f1.apply(this["arguments"]);
          return f2.apply(this["arguments"]);
        };
      })(obj[evt], fnc);
    }
    obj[evt] = fnc;
    true;
  }
  return false;
};

fromDomEvent = function(eventNames, domNodes) {
  assertNotNull(arguments);
  if (!isArray(domNodes)) {
    domNodes = [domNodes];
  }
  if (!isArray(eventNames)) {
    eventNames = [eventNames];
  }
  return new EventStream(function(signal) {
    var domNode, eventName, sNode, selected, _i, _len, _results;
    _results = [];
    for (_i = 0, _len = domNodes.length; _i < _len; _i++) {
      domNode = domNodes[_i];
      if (isString(domNode)) {
        selected = document.querySelectorAll(domNode);
      } else {
        selected = [domNode];
      }
      _results.push((function() {
        var _j, _len1, _results1;
        _results1 = [];
        for (_j = 0, _len1 = selected.length; _j < _len1; _j++) {
          sNode = selected[_j];
          _results1.push((function() {
            var _k, _len2, _results2;
            _results2 = [];
            for (_k = 0, _len2 = eventNames.length; _k < _len2; _k++) {
              eventName = eventNames[_k];
              _results2.push(addEventListener(sNode, eventName, function(e) {
                return signal(e);
              }));
            }
            return _results2;
          })());
        }
        return _results1;
      })());
    }
    return _results;
  });
};

trx = {
  _EventStream: EventStream,
  _Property: Property,
  createStream: function(eventCallback) {
    return new EventStream(eventCallback);
  },
  fromDomEvent: fromDomEvent,
  createProperty: function(subscribe, aggregator, initialValue) {
    return new Property(subscribe, aggregator, initialValue);
  }
};

if (typeof module !== "undefined" && module !== null) {
  module.exports = trx;
} else {
  window.trx = trx;
}

},{}],26:[function(require,module,exports){
(function() {
  var Swiper, trx,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  trx = require('tiny-rx');

  module.exports = Swiper = (function() {
    function Swiper() {
      this.letGo = __bind(this.letGo, this);
      this.slideTo = __bind(this.slideTo, this);
      this.setPositionRelative = __bind(this.setPositionRelative, this);
      this.move = __bind(this.move, this);
    }

    Swiper.prototype.init = function(containerSelector, wrapSelector, itemSelector, defaultSpeed) {
      var i, self, slide, swipeDimensions, _i, _j, _len, _len1, _ref, _ref1;
      if (containerSelector == null) {
        containerSelector = '.swipe';
      }
      if (wrapSelector == null) {
        wrapSelector = '.swipe-wrap';
      }
      if (itemSelector == null) {
        itemSelector = '.swipe-item';
      }
      this.defaultSpeed = defaultSpeed != null ? defaultSpeed : 400;
      self = this;
      this.manualPosition = 0;
      this.transitionInProgress = false;
      this.swipe = document.querySelector(containerSelector);
      this.swipeWrap = document.querySelector(wrapSelector);
      this.swiped = trx.createStream();
      this.slides = [];
      _ref = document.querySelectorAll(itemSelector);
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        slide = _ref[_i];
        this.slides.push(slide);
      }
      if (!this.swipe || !this.swipeWrap || this.slides.length < 2) {
        throw new Error('swipe swipeWrap or swipeItems are not valid elements');
      }
      swipeDimensions = this.swipe.getBoundingClientRect();
      this.slideWidth = swipeDimensions.width;
      this.swipeWrap.style.width = (this.slides.length * this.slideWidth) + 'px';
      _ref1 = this.slides;
      for (i = _j = 0, _len1 = _ref1.length; _j < _len1; i = ++_j) {
        slide = _ref1[i];
        slide.style.width = this.slideWidth + 'px';
      }
      this.currentPosition = 0;
      this._index = 0;
      this.slide(void 0, 0);
      this.swipe.style.visibility = 'visible';
      this.positionContinuously();
      this.transitionEnd = trx.fromDomEvent('webkitTransitionEnd', this.swipe);
      return this.transitionEnd.subscribe(function() {
        self.transitionInProgress = false;
        return self.positionContinuously();
      });
    };

    Swiper.prototype.prev = function() {
      this.setPositionRelative(-1);
      if (this._index <= 0) {
        return this.move(this.slides.length - 1);
      } else {
        return this.move(this._index - 1);
      }
    };

    Swiper.prototype.next = function() {
      this.setPositionRelative(1);
      if (this._index >= this.slides.length - 1) {
        return this.move(0);
      } else {
        return this.move(this._index + 1);
      }
    };

    Swiper.prototype.slide = function(index, speed) {
      var self;
      self = this;
      return self.move(index, speed);
    };

    Swiper.prototype.move = function(index, speed) {
      var i, slide, _i, _len, _ref, _results;
      if (index == null) {
        index = this._index;
      }
      this._index = index;
      _ref = this.slides;
      _results = [];
      for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
        slide = _ref[i];
        _results.push(this.translate(i, i * this.slideWidth - (index * this.slideWidth), speed));
      }
      return _results;
    };

    Swiper.prototype.positionContinuously = function() {
      var first, firstSlide, last, lastSlide;
      last = this.slides.length - 1;
      first = 0;
      if (this._index === last) {
        firstSlide = this.slides.shift();
        this.slides.push(firstSlide);
        return this.move(this._index - 1, 0);
      } else if (this._index === first) {
        lastSlide = this.slides.pop();
        this.slides.unshift(lastSlide);
        return this.move(this._index + 1, 0);
      }
    };

    Swiper.prototype.moveRel = function(dist) {
      var i, slide, _i, _len, _ref, _results;
      if (this.transitionInProgress) {
        this.transitionEnd.publish();
      }
      this.manualPosition += dist;
      _ref = this.slides;
      _results = [];
      for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
        slide = _ref[i];
        _results.push(this.translate(i, i * this.slideWidth - (this._index * this.slideWidth) - this.manualPosition, 0));
      }
      return _results;
    };

    Swiper.prototype.setPositionRelative = function(moveRel) {
      var lastSlide, target;
      target = this.currentPosition + moveRel;
      lastSlide = this.slides.length - 1;
      if (target > lastSlide) {
        target = target - lastSlide - 1;
      } else if (target < 0) {
        target = lastSlide - target - 1;
      }
      this.currentPosition = target;
      return this.swiped.publish(this.currentPosition);
    };

    Swiper.prototype.slideTo = function(num) {
      var lastSlide, moveBy, moveTo, self;
      if (typeof num !== 'number') {
        return;
      }
      self = this;
      moveBy = num - this.currentPosition;
      if (moveBy === 0) {
        return;
      }
      moveTo = this._index + moveBy;
      lastSlide = this.slides.length - 1;
      if (moveTo > lastSlide) {
        moveTo = moveTo - lastSlide - 1;
      } else if (moveTo < 0) {
        moveTo = moveTo + lastSlide + 1;
      }
      this.setPositionRelative(moveBy);
      return this.move(moveTo);
    };

    Swiper.prototype.letGo = function() {
      if (this.manualPosition > this.slideWidth / 7) {
        this.next();
      } else if (this.manualPosition < -this.slideWidth / 3) {
        this.prev();
      } else {
        this.move();
      }
      return this.manualPosition = 0;
    };

    Swiper.prototype.translate = function(index, dist, speed) {
      var slide, style;
      if (speed == null) {
        speed = this.defaultSpeed;
      }
      if (speed > 0) {
        this.transitionInProgress = true;
      }
      slide = this.slides[index];
      style = slide && slide.style;
      if (!style) {
        return false;
      }
      style.webkitTransitionDuration = style.MozTransitionDuration = style.msTransitionDuration = style.OTransitionDuration = style.transitionDuration = speed + 'ms';
      style.webkitTransform = 'translate(' + dist + 'px,0)' + 'translateZ(0)';
      return style.msTransform = style.MozTransform = style.OTransform = 'translateX(' + dist + 'px)';
    };

    return Swiper;

  })();

}).call(this);

},{"tiny-rx":25}],27:[function(require,module,exports){
(function() {
  var Swipe, Touchy, eddEventListener, swiper, trx, u,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  eddEventListener = function(obj, evt, fnc) {
    if (obj.addEventListener) {
      obj.addEventListener(evt, fnc, false);
      true;
    } else if (obj.attachEvent) {
      obj.attachEvent('on' + evt, fnc);
    } else {
      evt = 'on' + evt;
      if (typeof obj[evt] === 'function') {
        fnc = (function(f1, f2) {
          return function() {
            f1.apply(this["arguments"]);
            return f2.apply(this["arguments"]);
          };
        })(obj[evt], fnc);
      }
      obj[evt] = fnc;
      true;
    }
    return false;
  };

  trx = require('tiny-rx');

  Swipe = require('./swipe');

  u = require('./util');

  swiper = void 0;

  Touchy = (function() {
    function Touchy(mainElement, swipeContainer, scrollingClass) {
      var $debug, easeOutScroll, easeOutSwipe, gesture, gestureHistory, scrollAnimation, self, timeoutId, touchHistory;
      this.mainElement = mainElement != null ? mainElement : '.touchy';
      this.swipeContainer = swipeContainer != null ? swipeContainer : '.swipe';
      this.scrollingClass = scrollingClass != null ? scrollingClass : 'scroll';
      this.bindEvents = __bind(this.bindEvents, this);
      this.touches = trx.createStream();
      self = this;
      document.ontouchmove = function(e) {
        return e.preventDefault();
      };
      scrollAnimation = void 0;
      timeoutId = void 0;
      this.swiper = new Swipe();
      touchHistory = this.touches.map(function(e) {
        return {
          target: e.target,
          type: e.type,
          x: e.changedTouches[0].clientX,
          y: e.changedTouches[0].clientY
        };
      }).createHistory(6).filter(function(events) {
        return events.length > 2;
      });
      gestureHistory = this.touches.map(function(e) {
        return {
          type: e.type,
          x: e.changedTouches[0].clientX,
          y: e.changedTouches[0].clientY
        };
      }).createHistory();
      gesture = void 0;
      gestureHistory.filter(function(events) {
        return events.length > 1;
      }).subscribe(function(events) {
        var first, last, moveX, moveY;
        first = u.get(events, 0);
        last = u.get(events, -1);
        if (first.type === 'touchstart') {
          moveX = last.x - first.x;
          moveY = last.y - first.y;
          if (Math.abs(moveX) < 6 && Math.abs(moveY) < 6) {
            gesture = 'tap';
          } else if (Math.abs(moveX) > Math.abs(moveY)) {
            gesture = 'swipe';
            gestureHistory.reset();
          } else {
            gesture = 'scroll';
            gestureHistory.reset();
          }
          return void 0;
        }
      });
      $debug = document.querySelector('.debug');
      this.taps = this.touches.filter(function(e) {
        return gesture === 'tap' && e.type === 'touchend';
      });
      this.touches.filter('type', 'touchend').subscribe(function(e) {
        gestureHistory.reset();
        return gesture = void 0;
      });
      this.swipes = touchHistory.filter(function() {
        return gesture === 'swipe';
      });
      this.scrolls = touchHistory.filter(function() {
        return gesture === 'scroll';
      });
      easeOutScroll = this.scrolls.filter(function(events) {
        var $target, distance;
        if (u.get(events, -1).type === 'touchmove') {
          distance = u.get(events, -2).y - u.get(events, -1).y;
          $target = u.get(events, -1).target;
          if ($target.className.indexOf(self.scrollingClass) < 0) {
            $target = u.getParent($target, 'className', self.scrollingClass);
          }
          if ($target) {
            $target.scrollTop += distance;
          }
          scrollAnimation = void 0;
        } else if (u.get(events, -1).type === 'touchend') {
          gesture = void 0;
          return true;
        }
        return false;
      });
      easeOutSwipe = this.swipes.filter(function(events) {
        var $target, distance, last;
        last = u.get(events, -1);
        if (last.type === 'touchmove') {
          distance = u.get(events, -2).x - u.get(events, -1).x;
          $target = u.get(events, -2).target;
          self.swiper.moveRel(distance);
        } else if (last.type === 'touchend' && events.length > 3) {
          gesture = void 0;
          return true;
        }
        return false;
      });
      easeOutScroll.subscribe(function(events) {
        var distance, el, targetPosition;
        el = u.get(events, -1).target;
        distance = u.get(events, 0).y - u.get(events, -1).y;
        targetPosition = (distance * (Math.abs(distance) * 2)) + u.get(events, -2).target.scrollTop;
        scrollAnimation = function() {
          var dist;
          dist = targetPosition - el.scrollTop;
          if (Math.abs(dist) < .5) {
            scrollAnimation = void 0;
          }
          el.scrollTop += dist / 10;
          if (typeof scrollAnimation === 'function') {
            return requestAnimationFrame(scrollAnimation);
          }
        };
        return requestAnimationFrame(scrollAnimation);
      });
      easeOutSwipe.subscribe(function(e) {
        return self.swiper.letGo();
      });
    }

    Touchy.prototype.bindEvents = function() {
      this.swiper.init(this.swipeContainer);
      return this.touches.addDomEvent(['touchstart', 'touchmove', 'touchend'], this.mainElement);
    };

    return Touchy;

  })();

  module.exports = Touchy;

  if (window) {
    window.Touchy = Touchy;
  }

}).call(this);

},{"./swipe":26,"./util":28,"tiny-rx":25}],28:[function(require,module,exports){
(function() {
  module.exports = {
    mouseToScreen: function(xmouse, ymouse) {
      var box;
      box = $.canvas.getClientRects()[0];
      return [xmouse - box.left, ymouse - box.top];
    },
    isKey: function(keyCode, keyName) {
      return keyName.charCodeAt() === keyCode;
    },
    get: function(arr, index) {
      if (index < 0) {
        return arr[arr.length + index];
      } else {
        return arr[index];
      }
    },
    getParent: function($element, attr, value) {
      var $target;
      $target = $element.parentNode;
      while ($target && $target[attr].indexOf(value) < 0) {
        if ($target.nodeName === 'HTML') {
          $target = void 0;
          break;
        }
        $target = $target.parentNode;
      }
      return $target;
    }
  };

  if (!window.requestAnimationFrame) {
    window.requestAnimationFrame = function(callback) {
      var currTime, id, lastTime, timeToCall;
      currTime = new Date().getTime();
      timeToCall = Math.max(0, 16 - (currTime - lastTime));
      id = window.setTimeout;
      (function() {
        return callback(currTime + timeToCall, timeToCall);
      });
      lastTime = currTime + timeToCall;
      return id;
    };
  }

  if (!window.cancelAnimationFrame) {
    window.cancelAnimationFrame = function(id) {
      return clearTimeout(id);
    };
  }

}).call(this);

},{}],29:[function(require,module,exports){
var _ = require("underscore");


////////////////////////////////////////////////////////////////////////////////////////////
function extend (self, extension) {
  if (!extension) {
    return;
  }
  _.extend(self, extension);
}

function acceptVisitor (node, visitor, method, args, fallbacks) {
  if (method) {
    args[0] = node;
    return method.apply(visitor, args);
  } else if (fallbacks) {
    var i=0, max;
    if (fallbacks.accept) {
      i = 4;
      for (max=arguments.length; i<max; i++) {
        arguments[i].accept.apply(arguments[i], args);
      }
    } else if (_.isArray(fallbacks)) {
      for (max=fallbacks.length; i<max; i++) {
        fallbacks[i].accept.apply(fallbacks[i], args);
      }
    }
  }
}

function defineOffsetProperties (_prototype, offsetFirstChild, offsetLastChild) {
  offsetFirstChild = offsetFirstChild || '$NOT_IMPLEMENTED';
  offsetLastChild = offsetLastChild || offsetFirstChild;
  Object.defineProperties(_prototype, {
    offsetFirst: {
      enumerable: true,
      get: function () {
        if (this._offsetFirst === undefined && this[offsetFirstChild]) {
          this._offsetFirst = this[offsetFirstChild].offsetFirst;
        }
        return this._offsetFirst;
      },
    },
    offsetLast: {
      enumerable: true,
      get: function () {
        if (this._offsetLast === undefined) {
          // HACK. This should be done when parsing, and explicitly in visitors. Not here.
          var rightmost = this.unitNode || this[offsetLastChild];
          if (rightmost) {
            this._offsetLast = rightmost.offsetLast;
          }
        }
        return this._offsetLast;
      }
    }
  });
}

function defineRecursiveProperty (_prototype, propertyName, childProperty) { // childProperty…

  var privateProperty = '_' + propertyName,
      args = _.toArray(arguments).splice(2);

  Object.defineProperty(_prototype, propertyName, {
    set: function (value) {
      var self = this;
      self[privateProperty] = value;
      _.each(args, function (childName) {
        var child = self[childName];
        if (child) {
          child[propertyName] = value;
        }
      });
    },

    get: function () {
      return this[privateProperty];
    }
  }); 
}

function defineClone (Ctor) {
  Ctor.prototype.clone = function () {
    var theOriginal = this,
        theClone = new Ctor();

    _.extend(theClone, theOriginal);
    return theClone;
  };
}

function TuroError (errorMessage, node) {
  this.message = errorMessage;
  this.node = node;
}

function addError(error, node, context) {
  context.errors.push(new TuroError(error, node));
  node.error = error;
}


////////////////////////////////////////////////////////////////////////////////////////////

function ASTNode (extension) {
  extend(this, extension);
}

defineOffsetProperties(ASTNode.prototype);
defineClone(ASTNode);
////////////////////////////////////////////////////////////////////////////////////////////


function BinaryNode (left, right, literal) {
  //extend(this, extension);
  this.left = left;
  this.right = right;
  this.literal = literal;
}
BinaryNode.prototype = new ASTNode({
  accept: function (visitor) {
    return acceptVisitor(this, visitor, visitor.visitBinaryOperator, arguments, this.left, this.right);
  }
});
BinaryNode.prototype.constructor = BinaryNode;

defineOffsetProperties(BinaryNode.prototype, 'left', 'right');
defineClone(BinaryNode);

////////////////////////////////////////////////////////////////////////////////////////////


function UnaryOperationNode (value, literal, isPrefix) {
  this.value = value;
  this.isPrefix = isPrefix;
  this.literal = literal;
}

UnaryOperationNode.prototype = new ASTNode({
  accept: function (visitor) {
    return acceptVisitor(this, visitor, visitor.visitUnaryOperation, arguments, this.value);
  }
});

defineOffsetProperties(UnaryOperationNode.prototype, 'value');
defineClone(UnaryOperationNode);
////////////////////////////////////////////////////////////////////////////////////////////

function UnitLiteralNode (unit, literal) {
  this.unit = unit;
  this.literal = literal;
}

UnitLiteralNode.prototype = new ASTNode({
  accept: function (visitor) {
    return acceptVisitor(this, visitor, visitor.visitUnitLiteral, arguments);
  }
});

defineOffsetProperties(UnitLiteralNode.prototype);
defineRecursiveProperty(UnitLiteralNode.prototype, 'valueNode');
defineClone(UnitLiteralNode);
////////////////////////////////////////////////////////////////////////////////////////////

function UnitPowerNode (unitNode, numberNode) {
  this.unit = unitNode.unit.pow(numberNode.value);
  this.unitNode = unitNode;
  this.exponent = numberNode;
  this._offsetLast = this.exponent.offsetLast; // HACK. I don't know where _offsetLast is being set.
}

UnitPowerNode.prototype = new ASTNode({
  accept: function (visitor) {
    return acceptVisitor(this, visitor, visitor.visitUnitPower, arguments, this.unitNode, this.exponent);
  }
});

defineOffsetProperties(UnitPowerNode.prototype, 'unitNode', 'exponent');
defineRecursiveProperty(UnitPowerNode.prototype, 'valueNode', 'unitNode', 'exponent');
defineClone(UnitPowerNode);
////////////////////////////////////////////////////////////////////////////////////////////

function UnitMultOp (literal, left, right) {
  this.left = left;
  this.right = right;
  var unit;
  switch (literal) {
    case '/':
      if (this.left) {
        unit = left.unit.per(right.unit);
      } else {
        unit = right.unit.pow(-1);
      }
      break;
    case '*':
      unit = this.left.unit.by(this.right.unit);
      literal = ' ';
      break;
  }
  this.unit = unit;
  this.literal = literal;
}

UnitMultOp.prototype = new ASTNode({
  accept: function (visitor) {
    return acceptVisitor(this, visitor, visitor.visitUnitMultOp, arguments, this.left, this.right);
  }
});

defineOffsetProperties(UnitMultOp.prototype, 'left', 'right');
defineRecursiveProperty(UnitMultOp.prototype, 'valueNode', 'left', 'right');
defineClone(UnitMultOp);
////////////////////////////////////////////////////////////////////////////////////////////

function IntegerNode (string) {
  this.valueType = "number";
  this.setValue(string);
}
IntegerNode.prototype = new ASTNode({
  setValue: function (string) {
    if (typeof string === 'number') {
      this.value = string;
      this.literal = "" + string;
    } else if (_.isArray(string)) {
      this.literal = string.join("");
      this.value = parseInt(string, 10);
    } else if (typeof string === 'string') {
      this.literal = string;
      this.value = parseFloat(string, 10);
    }
    // XXX
    this._value = this.value;
  },

  accept: function (visitor) {
    return acceptVisitor(this, visitor, visitor.visitInteger, arguments);
  }
});
IntegerNode.prototype.constructor = IntegerNode;
defineClone(IntegerNode);
defineRecursiveProperty(IntegerNode.prototype, 'valueNode');
////////////////////////////////////////////////////////////////////////////////////////////

function IdentifierNode (string) {
  if (typeof string === 'string') {
    this.literal = this.name = string;
  } else if (_.isArray(string)) {
    this.literal = this.name = string.join("");
  }
}

IdentifierNode.prototype = new ASTNode({
  accept: function (visitor) {
    return acceptVisitor(this, visitor, visitor.visitIdentifier, arguments);
  }
});
defineClone(IdentifierNode);
////////////////////////////////////////////////////////////////////////////////////////////

function StatementNode (statementType, ast) {
  this.statementType = statementType;
  this.visitorMethodName = "visit" + statementType + "Statement";
  if (ast.accept) {
  this.ast = ast;
  } else {
    _.extend(this, ast);
  }
}

StatementNode.prototype = new ASTNode({
  accept: function (visitor) {
    return acceptVisitor(this, visitor, visitor[this.visitorMethodName],
      arguments, this.ast);
  }
});
defineClone(StatementNode);
////////////////////////////////////////////////////////////////////////////////////////////

module.exports = {
  IdentifierNode: IdentifierNode,
  NumberNode: IntegerNode,
  BinaryNode: BinaryNode,
  StatementNode: StatementNode,
  UnaryOperationNode: UnaryOperationNode,
  UnitLiteralNode: UnitLiteralNode,
  UnitMultOp: UnitMultOp,
  UnitPowerNode: UnitPowerNode,

  Error: TuroError,

  addError: addError,

  number: function (i) {
    return new IntegerNode(i);
  },

  integer: function (i) {
    return new IntegerNode(i);
  },
  acceptVisitor: acceptVisitor
};
},{"underscore":50}],30:[function(require,module,exports){
"use strict";
var _ = require("underscore");

function TokenPredictor (parser, generatorMap) {
  this.generatorMap = generatorMap || {};
  this.parser = parser;
}

_.extend(TokenPredictor.prototype, {

  addListCreator: function (tokenType, fn) {
    this.generatorMap[tokenType] = fn;
  },

  tabComplete: function (string, dirtyString, offset) {
    var self = this,
        tokenProcessor = {
          collect: function (tokenType, generator) {
            var tokens = generator();
            if (!this.tokenList) {
              this.tokenList = [];
            }

            if (tokens) {
              this.tokenList.push(tokens);
            }

          },

          delivery: function (string, dirtyString) {
            var tokens, substring, prefix;
            if (!this.tokenList) {
              return [[], ""];
            }

            tokens = _.flatten(this.tokenList) || [];

            if (this.error.offset === dirtyString.length) {
              // we got to the end of cleanString.
              var re = /\b(\w+)$/m,
                  m = re.exec(dirtyString);
              substring = m ? m[1] : "";
            } else if (this.error.offset > dirtyString.length) {
              substring = "";
            } else {
              substring = dirtyString.substring(this.error.offset);
            }

            if (substring) {
              tokens = _.filter(tokens, function (t) {
                return t.indexOf(substring) === 0;
              });
            }

            if (!substring && dirtyString[dirtyString.length - 1] !== " " && tokens.length === 1) {
              // this is beginning to look like a corner case.
              prefix = " ";
            }
            if (prefix) {
             tokens = _.map(tokens, function (t) {
               return prefix + t;
             });
            }

            return [tokens, substring];
          }
        };
    return self._makePrediction(tokenProcessor, string, dirtyString, offset);
  },

  createKeyboard: function (originalString, offset) {

    if (offset === undefined) {
      offset = originalString.length;
    }

    var self = this,
        tokenProcessor = {
          collect: function (expectedTokenType, tokenValue) {

            this.keyboard[expectedTokenType] = tokenValue;

            switch (expectedTokenType) {
              case "unitPer":
                // special case units, because we match on multiple in a row.
                this.keyboard.unit = self.generatorMap.unit || true;
                break;
            }
          },

          delivery: function () {
            if (self.parser.lastDigitOffset === offset) {
              // special case digits, because they're always matched by \d+
              this.keyboard.digits = true;
            }
            return this.keyboard;
          }
        };

    tokenProcessor.keyboard = {};
    this.parser.lastDigitOffset = undefined;
    return this._makePrediction(tokenProcessor, originalString, originalString, offset);
  },

  _makePrediction: function (tokenProcessor, string, dirtyString, offset) {
    if (typeof offset === 'number') {
      string = string.substring(0, offset);
    }
    var stringLength = string.length;
    string += "§bad_token";

    var self = this,
        error = this._getParseError(string);

    if (!error) {
      // unbelievable
      console.log("WEIRD - no predictions definitely bad string");
      return tokenProcessor.delivery();
    }

    var expected = error.expected;

    tokenProcessor.error = error;



    _.each(expected, function (tokenType) {

      var generator = self.generatorMap[tokenType];
      if (generator) {
        tokenProcessor.collect(tokenType, generator);
      }
    });




    return tokenProcessor.delivery(string, dirtyString);
  },

  _getParseError: function (string) {
    try {
      this.parser.parse(string, "Statement");
    } catch (e) {
      if (e.expected) {
        return e;
      }
      console.error("Strange error making predictions", e);
    }
  }
});






function create (turo) {
  return new TokenPredictor(turo.parser, {
    variable: _.bind(turo.variables.getVariableNames, turo.variables),
    unit: _.bind(turo.units.getUnitNames, turo.units),
    number: function () {
      // NOP
    },
    operator: _.bind(turo.operators.getInfixOperatorNames, turo.operators),
    "variable definition": function () {
      // NOP
    },
    startNumber: function () {
      return true;
    }
  });
}

module.exports = {
  TokenPredictor: TokenPredictor,
  create: create

};
},{"underscore":50}],31:[function(require,module,exports){
"use string";
var _ = require("underscore"),
    operators = require("./operators-symbol-table").defaultOperators,
    operatorLabeller = require("./operation-labeller"),
    ast = require("./ast");

function EvaluatorVisitor () {
}

function unitConversion(node, result) {
  var targetUnit = node.unit;
  if (node.unitSource && targetUnit) {
    result = node.unitSource.convert(result, targetUnit);
  }
  return result;
}

_.extend(EvaluatorVisitor.prototype, {

  visitIncludeStatement: function (node, context) {
    // NOP, we do this in the parser.
  },

  visitStatementList: function (node, context) {
    var turo = context.turo;
    if (!turo) {
      throw "No turo object";
    }

    _.each(node.ast, function(st) {
      node.accept(this, context, turo);
    });
  },

  visitBinaryOperator: function (node, context) {
    var operation = node.operation,
        targetUnit = node.unit,
        result;

    result = operation.evaluate(node.left, node.right,
                              node, context);
    return unitConversion(node, result);
  },

  visitUnaryOperation: function (node, context) {
    var operation = node.operation,
        targetUnit = node.unit,
        result;

    result = operation.evaluate(node.value, context);
    return unitConversion(node, result);
  },


  visitInteger: function (node, context) {
    node.value = node._value;
    return node.value;
  },

  visitIdentifier: function (node, context) {
    var value = context.variables.evaluateVariable(node.name, context);
    if (value === undefined) {
      ast.addError("NO_SUCH_VARIABLE", node, context);
      return;
    } else {
      delete node.error;
      return unitConversion(node, value);
    }
  },

  visitVariableDefinition: function (node, context) {
    var value = node.value;
    if (value !== undefined) {
      return value;
    }
    node.value = value = node.ast.accept(this, context);
    return value;
  },

  visitUnit: function (node, context) {
    return node;
  }
});

function Evaluator (visitor, variables, turo, errors) {
  this.variables = variables;
  this.visitor = visitor;
  this.turo = turo;
  this.prefs = turo && turo.prefs ? turo.prefs() : {};
  this.errors = errors || [];
  this.cacheVariableValue = true;
}

_.extend(Evaluator.prototype, {
  evaluate: function (node) {
    if (node.accept) {
      return node.accept(this.visitor, this);
    }
  }
});

module.exports = {
  visitor: new EvaluatorVisitor(), // new ast can be plugged in as and when by extending this
  variables: null,
  evaluate: function (node, variables, turo, errors) {
    // we need to do this because we can't detect if the variables
    // have changed units or types.
    errors = errors || [];
    var len = errors.length,
        evaluator = new Evaluator(this.visitor, variables, turo, errors);
    operatorLabeller.label(node, operators, variables || this.variables, errors, evaluator);

    if (errors.length !== len) {
      node.errors = errors;
      return;
    }

    // now we have units and operations, we can evaluate.
    var value = evaluator.evaluate(node);

    if (errors.length !== len) {
      node.errors = errors;
    }

    return value;
  },

  EvaluatorVisitor: EvaluatorVisitor
};
},{"./ast":29,"./operation-labeller":33,"./operators-symbol-table":35,"underscore":50}],32:[function(require,module,exports){
var process=require("__browserify_process");var path = require("path"),
    fs = require("fs");

module.exports = {
  resolve: function (filename) {
    // TODO decide how to do this without being a dick,
    // i.e. can we allow extensibility easily.
    // e.g. a path split by path.delimiter in repl.

    var paths = this._getPath(),
        i = 0,
        max = paths.length,
        dir, result;
        filename = filename + ".turo";
    for (;i<max; i++) {
      dir = paths[i];
      result = this._resolveQuietly(path.join(dir, filename));
      if (result) {
        return result;
      }
    }
    console.error("Can't find " + filename + " anywhere in " + paths.join(", "));
  },

  _getPath: function () {
    // TODO: calculate this from a command line argument.
    return [
      "../includes/",
      process.cwd()
    ];
  },

  _resolveQuietly: function (modulePath) {
    try {
      return require.resolve(modulePath);
    } catch (e) {
      //console.error(e.toString());
    }
  },

  loadSource: function (filepath, evaluate) {
    evaluate(fs.readFileSync(filepath).toString());
  }
};
},{"__browserify_process":23,"fs":21,"path":24}],33:[function(require,module,exports){
"use strict";
var _ = require("underscore"),
    ast = require("./ast");

function resolveUnits (node, sourceUnit) {
  var unitLiteral = node.unitLiteral,
      // i.e. the unit the user typed.
      targetUnit = sourceUnit;

  if (sourceUnit && unitLiteral) {
    if (unitLiteral.matchesDimensions(sourceUnit)) {
      // do an implicit 'in' unit conversion.
      targetUnit = unitLiteral;
      node.unitSource = sourceUnit;
    } else {
      targetUnit = unitLiteral.by(sourceUnit);
    }
  } else {
    targetUnit = unitLiteral || sourceUnit;
  }

  node.unit = targetUnit;
}

function OperationLabellerVisitor () {
}

_.extend(OperationLabellerVisitor.prototype, {

  visitBinaryOperator: function (node, context) {

    var len = context.errors.length;

    var lType = node.left.accept(this, context),
        rType = node.right.accept(this, context),
        operator;

    if (len !== context.errors.length) {
      return;
    }

    operator = context.operators.findOperator(node.literal, lType, rType);

    if (operator) {
      node.operation = operator;
      var calculatedUnit = operator.calculateUnit(node.left, node.right, context, node);

      if (calculatedUnit === undefined) {
        ast.addError("DIMENSION_MISMATCH", node, context);
        return;
      }

      resolveUnits(node, calculatedUnit);

      return operator.returnValueType;
    } else {
      ast.addError("TYPE_MISMATCH", node, context);
      return;
    }
  },

  visitUnaryOperation: function (node, context) {
    var operandType = node.value.accept(this, context),
        operator;


    operator = context.operators.findUnaryOperator(node.literal, operandType, node.isPrefix);

    if (operator) {
      node.operation = operator;
      var calculatedUnit = operator.calculateUnit(node.value, context);

      // undefined, and not null. null is dimensionless. Don't ask.
      if (calculatedUnit === undefined) {
        ast.addError("OPERATOR_UNIT_MISMATCH", node, context);
        return;
      }

      resolveUnits(node, calculatedUnit);

      return operator.returnValueType;
    } else {
      ast.addError("TYPE_MISMATCH", node, context);
    }

  },

  visitInteger: function (node, context) {
    resolveUnits(node);
    return node.valueType;
  },

  visitIdentifier: function (node, context) {
    if (!context.variables) {
      // not throw, because our earlier tests
      // won't pass. TODO
      return;
    }
    var statement = context.variables.getVariableDefinition(node.name);
    if (!statement) {
      ast.addError("NO_SUCH_VARIABLE", node, context);
      return;
    }
    var retValueType = statement.accept(this, context);

    resolveUnits(node, statement.unit);

    node.isConstant = statement.isConstant;
    return retValueType;
  },

  visitVariableDefinition: function (node, context) {

    // This is OK to do here, because a) it's only done infrequently
    // we could lazily calculate, but valueType is an intermediate value,
    // but changes in the variables used in this definition may change a
    // this variable.
    node.valueType = node.ast.accept(this, context);

    resolveUnits(node, node.ast.unit);

    return node.valueType;
  },

  visitUnit: function (unit, context) {
    return "unit";
  },

  visitUnitPower: function (unit, context) {
    return "unit";
  },

  visitUnitLiteral: function (unit, context) {
    return "unit";
  },

  visitUnitMultOp: function (unit, context) {
    return "unit";
  },

});

function Labeller (visitor, operators, variables, errors, evaluator) {
  this.operators = operators;
  this.variables = variables;
  this.visitor = visitor;
  this.errors = errors || [];
  this.evaluator = evaluator;
  this.prefs = evaluator.prefs;
}

_.extend(Labeller.prototype, {
  label: function (node) {
    if (node.accept) {
      return node.accept(this.visitor, this);
    }
  },

  evaluate: function (node) {
    if (this.evaluator) {
      return this.evaluator.evaluate(node);
    }
  }
});

module.exports = {
  visitor: new OperationLabellerVisitor(), // new ast can be plugged in as and when by extending this
  label: function (node, operators, variables, errors, evaluator) {
    return new Labeller(this.visitor, operators, variables, errors, evaluator).label(node);
  },

  OperationLabellerVisitor: OperationLabellerVisitor
};
},{"./ast":29,"underscore":50}],34:[function(require,module,exports){

var _ = require("underscore"),
    ast = require("./ast"),
    number = "number";

var additionUnits = function(lNode, rNode) {
    var singleUnit;
    if (lNode.unit && rNode.unit) {
        // if both left and right are units.
        // do the dimension check.
        if (lNode.unit.matchesDimensions(rNode.unit)) {
            return lNode.unit;
        }
    } else if (!(lNode.unit || rNode.unit)) {
        // if neither nodes have units, then return "dimensionless";
        return null;
    } else {
        // we have one unitted number, and one not.
        singleUnit = lNode.unit || rNode.unit;

        if (singleUnit.isDimensionless()) {
            // if the one that is united is dimensionless, then
            // return dimensionless.

            return null;
        }
    }

    // return error.
    return undefined;
};

var convertToUnit = function(value, srcUnit, destUnit) {
    if (destUnit && srcUnit) {
        return srcUnit.convert(value, destUnit);
    } else {
        return value;
    }

};

var addOp = function(lNode, rNode, result, ctx) {
        var lValue = convertToUnit(ctx.evaluate(lNode), lNode.unit, result.unit),
            rValue = convertToUnit(ctx.evaluate(rNode), rNode.unit, result.unit);
        return (lValue + rValue);
    },
    subtractOp = function(lNode, rNode, result, ctx) {
        var lValue = convertToUnit(ctx.evaluate(lNode), lNode.unit, result.unit),
            rValue = convertToUnit(ctx.evaluate(rNode), rNode.unit, result.unit);

        return (lValue - rValue);
    },
    multOp = function(lNode, rNode, result, ctx) {
        // XXX Ugly hack which means we don't need to use bignumber
        var value = ctx.evaluate(lNode) * ctx.evaluate(rNode);
        if (result._unitMultiplier) {
            value = result._unitMultiplier.value(value);
        }
        return value;
    },
    divideOp = function(lNode, rNode, result, ctx) {
        var bottom = ctx.evaluate(rNode), value;
        if (bottom === 0) {
            ast.addError("DIVIDE_BY_ZERO", rNode, ctx);
            return NaN;
        } else {
            value = ctx.evaluate(lNode) / bottom;
            if (result._unitMultiplier) {
                value = result._unitMultiplier.value(value);
            }
            return value;
        }
    };

/////////////////////////////////////////////////////////////////////////////////////////////

function trigUnits (node, context) {
  if (node.unit) {
    if (node.unit.isDimensionless() || node.unit.getDimension().shortName !== "Angle") {
      // treat this like a multiplication. cos 5 m
      return node.unit;
    } else {
      node.unit._isAngle = true;
    }
  } else {
    // TODO schedule a conversion between this and radians.
    // we need to get units, and _turoPrefs from somewhere.
  }
  return null;
}

function invTrigUnits (node, context) {

  if (node.unit && !node.isDimensionless()) {
    return undefined;
  }

  var turo = context.evaluator.turo,
      prefs = context.prefs,
      units = turo.units,
      unit = units.unitSchemes.getUnitNames(prefs.unitScheme, "Angle")[0];
  return units.getUnit(unit);
}

function toRadians (value, unit, units, prefs) {
  var radians = units.getUnit("radians"),
      valueRadians = value;
  if (unit && unit._isAngle) {
    valueRadians = unit.convert(value, radians);
  } else {
    unit = units.unitSchemes.getUnitNames(prefs.unitScheme, "Angle")[0];
    valueRadians = units.getUnit(unit).convert(value, radians);
  }
  return valueRadians;
}

function fromRadians (valueRadians, units, prefs) {
  var radians = units.getUnit("radians"),
      unit = units.unitSchemes.getUnitNames(prefs.unitScheme, "Angle")[0],
      value = radians.convert(valueRadians, units.getUnit(unit));

  return value;
}

/////////////////////////////////////////////////////////////////////////////////////////////

function noUnits (node, context) {
  // check that the operand is dimensionless
  if (!node.unit || node.unit.isDimensionless()) {
    // the result will be dimensionless.
    return null;
  }

  // otherwise, it's a dimension error
  return undefined;
}

/////////////////////////////////////////////////////////////////////////////////////////////

function defaultOperators (ops) {

/////////////////////////////////////////////////////////////////////////////////////////////
  ops.addInfixOperator(
    "+",
    number,
    number,
    number,
    additionUnits,
    addOp
  );

  ops.addInfixOperator(
    "-",
    number,
    number,
    number,
    additionUnits,
    subtractOp
  );

  ops.addInfixOperator(
    "*",
    number,
    number,
    number,
    function (lNode, rNode, context, result) {
      if (lNode.unit && rNode.unit) {
          var unitNode = lNode.unit.by(rNode.unit).simplify();
          result._unitMultiplier = unitNode.multiplier;
          return unitNode.unit;
      } else if (lNode.unit) {
          return lNode.unit;
      } else if (rNode.unit) {
          return rNode.unit;
      } else {
          return null;
      }
    },
    multOp
  );

  ops.addInfixOperator(
    "/",
    number,
    number,
    number,
    function(lNode, rNode, context, result) {
      if (lNode.unit && rNode.unit) {
          var unitNode = lNode.unit.per(rNode.unit).simplify();
          result._unitMultiplier = unitNode.multiplier;
          return unitNode.unit;
      } else if (lNode.unit /*&& !rNode.unit */) {
          return lNode.unit;
      } else if (/*!lNode.unit &&*/ rNode.unit) {
          // XXX this is beginning to feel very hacky.
          // TODO make an explicit ast.ParensNode.
          // We leave this as is because not respecting brackets at all 
          // is worse than doing it right thing only /most/ of the time.
          return rNode.inBrackets ? rNode.unit.pow(-1) : rNode.unit;
      } else {
          return null;
      }
    },
    divideOp
  );

  ops.addPrefixOperator("-", number, number, function (node, context) {
      return node.unit || null;
  }, function (node, ctx) {
      return -(ctx.evaluate(node));
  });

  ops.addInfixOperator(
    "in",
    number,
    "unit",
    number,
    function(lNode, rNode) {
      if (lNode.unit && rNode.unit.matchesDimensions(lNode.unit)) {
          return rNode.unit;
      }
      return undefined; // operation-labeller will eport errors as DIMENSION MISMATCH
    },
    function(lNode, rNode, result, ctx) {
      var value = ctx.evaluate(lNode);
      if (lNode.unit) {
          return lNode.unit.convert(value, rNode.unit);
      }
      return value;
    }
  );
  /////////////////////////////////////////////////////////////////////////////////////////////

  ops.addInfixOperator(
    "^",
    number,
    number,
    number,
    function(lNode, rNode, ctx) {
      if (!rNode.unit || rNode.unit.isDimensionless()) {
        if (lNode.unit) {
          return lNode.unit.pow(ctx.evaluate(rNode));
        } else if (!lNode.unit || lNode.unit.isDimensionless()) {
          return null;
        }
      }
      // DIMENSION MISMATCH
    },
    function(lNode, rNode, result, ctx) {
      // TODO Javascript numbers used here.
      // TODO check if lNode is -ve
      var value = Math.pow(ctx.evaluate(lNode), ctx.evaluate(rNode));

      if (_.isNaN(value)) {
        ast.addError("NEGATIVE_NUMBER_EXPONENTIATION", lNode, ctx);
      }

      return value;
    }
  );


  ops.addPrefixOperator(
    "sqrt",
    number,
    number,
    function (node, context) {
      return nthRootUnit(2, node) || null;
    },
    function(node, ctx) {
      // TODO Javascript numbers used here.
      // TODO check if lNode is -ve
      return nthRootEval(2, node, ctx);
    }
  );

  // this is a smell: 
  // writing utility functions to check for null.
  function isDimensionless (node) {
    return (!node.unit || node.unit.isDimensionless());
  }

  function nthRootUnit (num, node) {
    if (!isDimensionless(node)) {
      var d = node.unit.getDimension().dimensions;
      var canDo = true;
      _.chain(d).values().each(function (d) {
        canDo = canDo && ((d % num) === 0);
      });
      var simple = node.unit.simplify();
      // Simplify if needed. e.g. sqrt(9 ha) === 300 m
      // During eval, below: convert from input unit to unitSquared
      // before square rooting.
      node.unitSquared = simple.unit;
      return canDo ? simple.unit.pow(1/num) : undefined;
    }
  }

  function nthRootEval (numRoot, node, ctx) {
    var value = ctx.evaluate(node);

    if (node.unitSquared) {
      value = node.unit.convert(value, node.unitSquared);
    }

    value = Math.pow(value, 1 / numRoot);

    if (_.isNaN(value)) {
      if (numRoot === 2) {
        ast.addError("NEGATIVE_NUMBER_SQRT", node, ctx);
      } else {
        ast.addError("NEGATIVE_NUMBER_NTH_ROOT", node, ctx);
      }
    }

    return value;
  }

  ops.addInfixOperator(
    "nth_root",
    number,
    number,
    number,
    function(lNode, rNode, ctx) {
      
      if (!isDimensionless(lNode)) {
        ast.addError('UNITS_LHS_NTH_ROOT', lNode, ctx);
        return;
      }

      if (isDimensionless(rNode)) {
        // remain dimensionless.
        return null;
      }
  
      var rootValue = ctx.evaluate(lNode);
      
      return nthRootUnit(rootValue, rNode);
      // DIMENSION MISMATCH
    },
    function(lNode, rNode, result, ctx) {
      // TODO Javascript numbers used here.
      return nthRootEval(ctx.evaluate(lNode), rNode, ctx);
    }
  );

  /////////////////////////////////////////////////////////////////////////////////////////////

  ops.addPrefixOperator(
    "sin",
    number,
    number,
    trigUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      // TODO check if lNode is -ve
      var value = ctx.evaluate(lNode);
      value = Math.sin(toRadians(value, lNode.unit, ctx.turo.units, ctx.turo.prefs()));
      return value;
    }
  );

  ops.addPrefixOperator(
    "asin",
    number,
    number,
    invTrigUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      // TODO check if -1 <= lNode <= 1
      var value = ctx.evaluate(lNode);
      value = Math.asin(value);
      return fromRadians(value, ctx.turo.units, ctx.turo.prefs());
    }
  );

  ops.addPrefixOperator(
    "cos",
    number,
    number,
    trigUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      var value = ctx.evaluate(lNode);
      value = Math.cos(toRadians(value, lNode.unit, ctx.turo.units, ctx.turo.prefs()));
      return value;
    }
  );

  ops.addPrefixOperator(
    "acos",
    number,
    number,
    invTrigUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      // TODO check if -1 <= lNode <= 1
      var value = ctx.evaluate(lNode);
      value = Math.acos(value);
      return fromRadians(value, ctx.turo.units, ctx.turo.prefs());
    }
  );

  ops.addPrefixOperator(
    "tan",
    number,
    number,
    trigUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      // TODO check if lNode is -ve
      var value = ctx.evaluate(lNode);
      value = Math.tan(toRadians(value, lNode.unit, ctx.turo.units, ctx.turo.prefs()));
      return value;
    }
  );


  ops.addPrefixOperator(
    "atan",
    number,
    number,
    invTrigUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      var value = ctx.evaluate(lNode);
      value = Math.atan(value);
      return fromRadians(value, ctx.turo.units, ctx.turo.prefs());
    }
  );

  /////////////////////////////////////////////////////////////////////////////////////////////

  ops.addPrefixOperator(
    "log",
    number,
    number,
    noUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      var value = ctx.evaluate(lNode);
      return Math.log(value) / Math.LN10;
    }
  );

  ops.addPrefixOperator(
    "ln",
    number,
    number,
    noUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      var value = ctx.evaluate(lNode);
      return Math.log(value);
    }
  );

/////////////////////////////////////////////////////////////////////////////////////////////
// TODO: Define hyperpolic functions in turo.
/////////////////////////////////////////////////////////////////////////////////////////////
// Non-inverse from
// Inverses from http://keisan.casio.com/exec/system/1223040677

  ops.addPrefixOperator(
    "sinh",
    number,
    number,
    noUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      var x = ctx.evaluate(lNode);
      if (Math.sinh) {
        return Math.sinh(x);
      } else {
        return (Math.exp(x) - Math.exp(-x)) / 2;
      }
    }
  );


  ops.addPrefixOperator(
    "asinh",
    number,
    number,
    noUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      var x = ctx.evaluate(lNode);
      if (Math.asinh) {
        return Math.asinh(x);
      } else {
        // ln(x + sqrt(x^2 + 1)) + 1
        return Math.ln(x + Math.sqrt(x*x + 1));
      }
    }
  );

  ops.addPrefixOperator(
    "cosh",
    number,
    number,
    noUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      var x = ctx.evaluate(lNode);
      if (Math.cosh) {
        return Math.cosh(x);
      } else {
        return (Math.exp(x) + Math.exp(-x)) / 2;
      }
    }
  );


  ops.addPrefixOperator(
    "acosh",
    number,
    number,
    noUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      var x = ctx.evaluate(lNode);
      if (x < 1) {
        ast.addError("COMPLICATED", lNode, ctx);
      }
      if (Math.acosh) {
        return Math.acosh(x);
      } else {
        // ln(x + sqrt(x^2 - 1))
        return Math.ln(x + Math.sqrt(x*x - 1));
      }
    }
  );

  ops.addPrefixOperator(
    "tanh",
    number,
    number,
    noUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      var x = ctx.evaluate(lNode);
      if (Math.tanh) {
        return Math.tanh(x);
      } else {
        return (Math.exp(x) - Math.exp(-x)) / (Math.exp(x) + Math.exp(-x));
      }
    }
  );


  ops.addPrefixOperator(
    "atanh",
    number,
    number,
    noUnits,
    function(lNode, ctx) {
      // TODO Javascript numbers used here.
      var x = ctx.evaluate(lNode);
      if (Math.abs(x) >= 1) {
        ast.addError("COMPLICATED", lNode, ctx);
      }
      if (Math.atanh) {
        return Math.atanh(x);
      } else {
        // 1 / 2 * ln((1 + x) / (1 - x))
        return Math.ln((1 + x) / (1 - x)) / 2;
      }
    }
  );

  /////////////////////////////////////////////////////////////////////////////////////////////

  return ops;
}

module.exports = defaultOperators;
},{"./ast":29,"underscore":50}],35:[function(require,module,exports){
var _ = require("underscore"),
    ast = require("./ast");

function Operator(options) {
    if (options) {
        _.extend(this, options);
    }
}
_.extend(Operator.prototype, {
    evaluate: function(x, y, result, ctx) {
        return this.evaluatorFunction(x, y, result, ctx);
    },
    calculateUnit: function(l, r, ctx, node) {
        if (this.unitCalculator) {
            return this.unitCalculator(l, r, ctx, node);
        } else {
            return null;
        }
    }
});

function makeKey(lValueType, literal, rValueType) {
    return lValueType + literal + rValueType;
}

var UNARY_OPERATION = "++N/A++";

function Operators(table, prefs) {
    this.table = table || {};
    this._turoPrefs = prefs || {};
    this._infixOperatorNames = {};
    this._prefixOperatorNames = {};
    this._postfixOperatorNames = {};
}

_.extend(Operators.prototype, {

    _cacheGetOperatorNames: function (operatorType) {
      var key = "__cache_" + operatorType;
      if (!this[key]) {
        this[key] = _.keys(this["_" + operatorType + "OperatorNames"]);
      }
      return this[key];
    },

    _putNameCache: function (operatorType, operatorName) {
      this["_" + operatorType + "OperatorNames"][operatorName] = true;
      delete this["__cache_" + operatorType];
    },

    getInfixOperatorNames: function() {
      return this._cacheGetOperatorNames("infix");
    },

    getPrefixOperatorNames: function() {
        return this._cacheGetOperatorNames("prefix");
    },

    getPostfixOperatorNames: function() {
        return this._cacheGetOperatorNames("postfix");
    },

    hasInfixOperator: function (literal) {
      return this._infixOperatorNames[literal];
    },

    hasPrefixOperator: function (literal) {
      return this._prefixOperatorNames[literal];
    },

    hasPostfixOperator: function (literal) {
      return this._postfixOperatorNames[literal];
    },

    addInfixOperator: function(literal, lValueType, rValueType, retValueType, unitCalculator, evaluatorFunction) {
        this._addOperator(literal, lValueType, rValueType, retValueType, unitCalculator, evaluatorFunction);

        // XXX we can do this here, because 'in' is specifically mentioned in the parser.
        if (literal !== 'in') {
            this._putNameCache("infix", literal);
        }
        // TODO get autocomplete to work with the type system.
    },

    addPrefixOperator: function(literal, rValueType, retValueType, unitCalculator, evaluatorFunction) {
        this._addOperator(literal, UNARY_OPERATION, rValueType, retValueType, unitCalculator, evaluatorFunction);
        this._putNameCache("prefix", literal);
    },

    addPosfixOperator: function(literal, lValueType, retValueType, unitCalculator, evaluatorFunction) {
        this._addOperator(literal, lValueType, UNARY_OPERATION, retValueType, unitCalculator, evaluatorFunction);
        this._putNameCache("postfix", literal);
    },

    _addOperator: function(literal, lValueType, rValueType, retValueType, unitCalculator, evaluatorFunction) {
        var op = new Operator({
            literal: literal,
            lValueType: lValueType,
            rValueType: rValueType,
            returnValueType: retValueType,
            unitCalculator: unitCalculator,
            evaluatorFunction: evaluatorFunction
        });

        this.table[makeKey(lValueType, literal, rValueType)] = op;
    },

    findOperator: function(literal, lNode, rNode) {
        return this.table[makeKey(lNode, literal, rNode)];
    },

    findUnaryOperator: function (literal, nodeType, isPrefix) {
        var key = isPrefix ?
                makeKey(UNARY_OPERATION, literal, nodeType) :
                makeKey(nodeType, literal, UNARY_OPERATION);
        return this.table[key];
    }
});

function createDefaultOperators (prefs) {
    var init = require("./operators-default-table");

    return init(new Operators(undefined, prefs || {}));

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////



module.exports = {
    Operators: Operators,
    defaultOperators: createDefaultOperators(),
    createDefaultOperators: createDefaultOperators
};
},{"./ast":29,"./operators-default-table":34,"underscore":50}],36:[function(require,module,exports){
module.exports = (function(){
  /*
   * Generated by PEG.js 0.7.0.
   *
   * http://pegjs.majda.cz/
   */
  
  function quote(s) {
    /*
     * ECMA-262, 5th ed., 7.8.4: All characters may appear literally in a
     * string literal except for the closing quote character, backslash,
     * carriage return, line separator, paragraph separator, and line feed.
     * Any character may appear in the form of an escape sequence.
     *
     * For portability, we also escape escape all control and non-ASCII
     * characters. Note that "\0" and "\v" escape sequences are not used
     * because JSHint does not like the first and IE the second.
     */
     return '"' + s
      .replace(/\\/g, '\\\\')  // backslash
      .replace(/"/g, '\\"')    // closing quote character
      .replace(/\x08/g, '\\b') // backspace
      .replace(/\t/g, '\\t')   // horizontal tab
      .replace(/\n/g, '\\n')   // line feed
      .replace(/\f/g, '\\f')   // form feed
      .replace(/\r/g, '\\r')   // carriage return
      .replace(/[\x00-\x07\x0B\x0E-\x1F\x80-\uFFFF]/g, escape)
      + '"';
  }
  
  var result = {
    /*
     * Parses the input with a generated parser. If the parsing is successfull,
     * returns a value explicitly or implicitly specified by the grammar from
     * which the parser was generated (see |PEG.buildParser|). If the parsing is
     * unsuccessful, throws |PEG.parser.SyntaxError| describing the error.
     */
    parse: function(input, startRule) {
      var parseFunctions = {
        "StatementList": parse_StatementList,
        "StatementSeperator": parse_StatementSeperator,
        "Statement": parse_Statement,
        "UnitDefinitionStatement": parse_UnitDefinitionStatement,
        "UnitDefinition": parse_UnitDefinition,
        "UnitDefinitionLeft": parse_UnitDefinitionLeft,
        "UnitIdentifiers": parse_UnitIdentifiers,
        "UnitSchemes": parse_UnitSchemes,
        "OptionalDimensionIdentifier": parse_OptionalDimensionIdentifier,
        "DimensionIdentifier": parse_DimensionIdentifier,
        "NewUnitIdentifier": parse_NewUnitIdentifier,
        "UnitScheme": parse_UnitScheme,
        "UnitExpression": parse_UnitExpression,
        "UnitMultiplicativeOperator": parse_UnitMultiplicativeOperator,
        "UnitPer": parse_UnitPer,
        "UnitPerLiteral": parse_UnitPerLiteral,
        "UnitMultiplier": parse_UnitMultiplier,
        "RaiseToPowerOperator": parse_RaiseToPowerOperator,
        "RaiseToPowerOperatorLiteral": parse_RaiseToPowerOperatorLiteral,
        "UnitIdentifier": parse_UnitIdentifier,
        "IncludeStatement": parse_IncludeStatement,
        "TestStatement": parse_TestStatement,
        "TestRHS": parse_TestRHS,
        "TestStart": parse_TestStart,
        "AssertExpression": parse_AssertExpression,
        "StringLiteral": parse_StringLiteral,
        "ConstDefinition": parse_ConstDefinition,
        "VariableDefinition": parse_VariableDefinition,
        "EqualitySymbol": parse_EqualitySymbol,
        "NumericalExpression": parse_NumericalExpression,
        "UnitConversion": parse_UnitConversion,
        "UnitConversionNode": parse_UnitConversionNode,
        "AdditiveExpression": parse_AdditiveExpression,
        "AdditiveOperator": parse_AdditiveOperator,
        "AdditiveOperatorLiteral": parse_AdditiveOperatorLiteral,
        "MultiplicativeExpression": parse_MultiplicativeExpression,
        "MultiplicativeOperator": parse_MultiplicativeOperator,
        "MultiplicativeOperatorLiteral": parse_MultiplicativeOperatorLiteral,
        "MultiplactionOperand": parse_MultiplactionOperand,
        "NamedBinaryOperation": parse_NamedBinaryOperation,
        "NamedBinaryOperator": parse_NamedBinaryOperator,
        "NamedBinaryOperatorLiteral": parse_NamedBinaryOperatorLiteral,
        "SpecialNamedBinaryOperator": parse_SpecialNamedBinaryOperator,
        "NamedPrefixUnaryOperation": parse_NamedPrefixUnaryOperation,
        "NamedPrefixOperator": parse_NamedPrefixOperator,
        "SymbolTablePrefixOperator": parse_SymbolTablePrefixOperator,
        "NamedPostfixUnaryOperation": parse_NamedPostfixUnaryOperation,
        "NamedPostfixOperator": parse_NamedPostfixOperator,
        "SymbolTablePostfixOperator": parse_SymbolTablePostfixOperator,
        "ValueOrParensWithUnit": parse_ValueOrParensWithUnit,
        "ValueOrParens": parse_ValueOrParens,
        "ParensOpen": parse_ParensOpen,
        "ParensClose": parse_ParensClose,
        "Terminal": parse_Terminal,
        "Identifier": parse_Identifier,
        "IdentifierLiteral": parse_IdentifierLiteral,
        "Number": parse_Number,
        "NumberLiteral": parse_NumberLiteral,
        "NumberLiteralString": parse_NumberLiteralString,
        "NumberLiteralFromParts": parse_NumberLiteralFromParts,
        "NumberWholePart": parse_NumberWholePart,
        "Digits": parse_Digits,
        "NumberDecimalPart": parse_NumberDecimalPart,
        "DecimalPoint": parse_DecimalPoint,
        "ExponentLiteral": parse_ExponentLiteral,
        "ExponentSign": parse_ExponentSign,
        "IntegerNode": parse_IntegerNode,
        "IntegerLiteral": parse_IntegerLiteral,
        "IntegerString": parse_IntegerString,
        "KeywordLiteral": parse_KeywordLiteral,
        "_": parse__,
        "Comment": parse_Comment,
        "__": parse___
      };
      
      if (startRule !== undefined) {
        if (parseFunctions[startRule] === undefined) {
          throw new Error("Invalid rule name: " + quote(startRule) + ".");
        }
      } else {
        startRule = "AdditiveExpression";
      }
      
      var pos = 0;
      var reportFailures = 0;
      var rightmostFailuresPos = 0;
      var rightmostFailuresExpected = [];
      
      function padLeft(input, padding, length) {
        var result = input;
        
        var padLength = length - input.length;
        for (var i = 0; i < padLength; i++) {
          result = padding + result;
        }
        
        return result;
      }
      
      function escape(ch) {
        var charCode = ch.charCodeAt(0);
        var escapeChar;
        var length;
        
        if (charCode <= 0xFF) {
          escapeChar = 'x';
          length = 2;
        } else {
          escapeChar = 'u';
          length = 4;
        }
        
        return '\\' + escapeChar + padLeft(charCode.toString(16).toUpperCase(), '0', length);
      }
      
      function matchFailed(failure) {
        if (pos < rightmostFailuresPos) {
          return;
        }
        
        if (pos > rightmostFailuresPos) {
          rightmostFailuresPos = pos;
          rightmostFailuresExpected = [];
        }
        
        rightmostFailuresExpected.push(failure);
      }
      
      function parse_StatementList() {
        var result0, result1, result2, result3;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse__();
        if (result0 !== null) {
          result1 = [];
          pos2 = pos;
          result2 = parse_Statement();
          result2 = result2 !== null ? result2 : "";
          if (result2 !== null) {
            result3 = parse_StatementSeperator();
            if (result3 !== null) {
              result2 = [result2, result3];
            } else {
              result2 = null;
              pos = pos2;
            }
          } else {
            result2 = null;
            pos = pos2;
          }
          while (result2 !== null) {
            result1.push(result2);
            pos2 = pos;
            result2 = parse_Statement();
            result2 = result2 !== null ? result2 : "";
            if (result2 !== null) {
              result3 = parse_StatementSeperator();
              if (result3 !== null) {
                result2 = [result2, result3];
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, list) {
          var statements = [];
          for (var i=0, max = list.length; i<max; i+=2) {
            if (list[i][0]) {
              statements.push(list[i][0]);
            }
          }
          return new ast.StatementNode("StatementList", statements);
        })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_StatementSeperator() {
        var result0, result1, result2;
        var pos0;
        
        pos0 = pos;
        result0 = parse__();
        if (result0 !== null) {
          if (input.charCodeAt(pos) === 59) {
            result1 = ";";
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\";\"");
            }
          }
          if (result1 !== null) {
            result2 = parse__();
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos0;
            }
          } else {
            result0 = null;
            pos = pos0;
          }
        } else {
          result0 = null;
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Statement() {
        var result0;
        
        result0 = parse_UnitDefinitionStatement();
        if (result0 === null) {
          result0 = parse_TestStatement();
          if (result0 === null) {
            result0 = parse_IncludeStatement();
            if (result0 === null) {
              result0 = parse_ConstDefinition();
              if (result0 === null) {
                result0 = parse_VariableDefinition();
                if (result0 === null) {
                  result0 = parse_NumericalExpression();
                }
              }
            }
          }
        }
        return result0;
      }
      
      function parse_UnitDefinitionStatement() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 4) === "unit") {
          result0 = "unit";
          pos += 4;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"unit\"");
          }
        }
        if (result0 !== null) {
          result1 = parse___();
          if (result1 !== null) {
            result2 = parse_UnitDefinition();
            if (result2 !== null) {
              result3 = parse__();
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, unit) {
          return new ast.StatementNode("UnitDefinition", unit);
        })(pos0, result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_UnitDefinition() {
        var result0, result1, result2, result3, result4, result5, result6, result7, result8;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_UnitIdentifier();
        if (result0 !== null) {
          result1 = parse__();
          if (result1 !== null) {
            result2 = parse_UnitSchemes();
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, unitNode, schemes) {
              units.addUnitSchemes(unitNode.unit, schemes);
              return unitNode.unit;
            })(pos0, result0[0], result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        if (result0 === null) {
          pos0 = pos;
          pos1 = pos;
          result0 = parse_UnitDefinitionLeft();
          if (result0 !== null) {
            result1 = parse__();
            if (result1 !== null) {
              if (input.charCodeAt(pos) === 58) {
                result2 = ":";
                pos++;
              } else {
                result2 = null;
                if (reportFailures === 0) {
                  matchFailed("\":\"");
                }
              }
              if (result2 !== null) {
                result3 = parse__();
                if (result3 !== null) {
                  result4 = parse_OptionalDimensionIdentifier();
                  result4 = result4 !== null ? result4 : "";
                  if (result4 !== null) {
                    result5 = parse__();
                    if (result5 !== null) {
                      result6 = parse_NumberLiteral();
                      if (result6 !== null) {
                        result7 = parse__();
                        if (result7 !== null) {
                          result8 = parse_UnitExpression();
                          if (result8 !== null) {
                            result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8];
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
          if (result0 !== null) {
            result0 = (function(offset, id, dimension, num, unitNode) {
                return units.addUnit(id.id, num || 1.0, unitNode.unit, id.schemes, dimension);
              })(pos0, result0[0], result0[4], result0[6], result0[8]);
          }
          if (result0 === null) {
            pos = pos0;
          }
          if (result0 === null) {
            pos0 = pos;
            pos1 = pos;
            result0 = parse_UnitDefinitionLeft();
            if (result0 !== null) {
              result1 = parse__();
              if (result1 !== null) {
                if (input.charCodeAt(pos) === 58) {
                  result2 = ":";
                  pos++;
                } else {
                  result2 = null;
                  if (reportFailures === 0) {
                    matchFailed("\":\"");
                  }
                }
                if (result2 !== null) {
                  result3 = parse__();
                  if (result3 !== null) {
                    result4 = parse_DimensionIdentifier();
                    if (result4 !== null) {
                      result0 = [result0, result1, result2, result3, result4];
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
            if (result0 !== null) {
              result0 = (function(offset, id, dimension) {
                  return units.addUnit(id.id, dimension, undefined, id.schemes);
                })(pos0, result0[0], result0[4]);
            }
            if (result0 === null) {
              pos = pos0;
            }
            if (result0 === null) {
              pos0 = pos;
              pos1 = pos;
              result0 = parse_NumberLiteral();
              if (result0 !== null) {
                result1 = parse__();
                if (result1 !== null) {
                  result2 = parse_UnitDefinitionLeft();
                  if (result2 !== null) {
                    result3 = parse__();
                    if (result3 !== null) {
                      if (input.charCodeAt(pos) === 58) {
                        result4 = ":";
                        pos++;
                      } else {
                        result4 = null;
                        if (reportFailures === 0) {
                          matchFailed("\":\"");
                        }
                      }
                      if (result4 !== null) {
                        result5 = parse__();
                        if (result5 !== null) {
                          result6 = parse_OptionalDimensionIdentifier();
                          result6 = result6 !== null ? result6 : "";
                          if (result6 !== null) {
                            result7 = parse__();
                            if (result7 !== null) {
                              result8 = parse_UnitExpression();
                              if (result8 !== null) {
                                result0 = [result0, result1, result2, result3, result4, result5, result6, result7, result8];
                              } else {
                                result0 = null;
                                pos = pos1;
                              }
                            } else {
                              result0 = null;
                              pos = pos1;
                            }
                          } else {
                            result0 = null;
                            pos = pos1;
                          }
                        } else {
                          result0 = null;
                          pos = pos1;
                        }
                      } else {
                        result0 = null;
                        pos = pos1;
                      }
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
              if (result0 !== null) {
                result0 = (function(offset, num, id, dimension, unitNode) {
                    return units.addUnit(id.id, unitNode.unit, num, id.schemes, dimension);
                  })(pos0, result0[0], result0[2], result0[6], result0[8]);
              }
              if (result0 === null) {
                pos = pos0;
              }
            }
          }
        }
        return result0;
      }
      
      function parse_UnitDefinitionLeft() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_UnitIdentifiers();
        if (result0 !== null) {
          result1 = parse__();
          if (result1 !== null) {
            result2 = parse_UnitSchemes();
            result2 = result2 !== null ? result2 : "";
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, ids, schemes) {
            return {
              id: ids[0],
              alternatives: ids[1],
              schemes: schemes
            }
          })(pos0, result0[0], result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_UnitIdentifiers() {
        var result0, result1, result2, result3;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_NewUnitIdentifier();
        if (result0 !== null) {
          result1 = [];
          pos2 = pos;
          result2 = parse___();
          if (result2 !== null) {
            result3 = parse_NewUnitIdentifier();
            if (result3 !== null) {
              result2 = [result2, result3];
            } else {
              result2 = null;
              pos = pos2;
            }
          } else {
            result2 = null;
            pos = pos2;
          }
          while (result2 !== null) {
            result1.push(result2);
            pos2 = pos;
            result2 = parse___();
            if (result2 !== null) {
              result3 = parse_NewUnitIdentifier();
              if (result3 !== null) {
                result2 = [result2, result3];
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, unitName, alternatives) {
          var alts = [];
          for (var i=0, max=alternatives.length; i<max; i++) {
            alts.push(alternatives[i][1]);
          }
        
          return [unitName, alts];
        })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_UnitSchemes() {
        var result0, result1, result2, result3;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ParensOpen();
        if (result0 !== null) {
          result1 = [];
          pos2 = pos;
          result2 = parse__();
          if (result2 !== null) {
            result3 = parse_UnitScheme();
            if (result3 !== null) {
              result2 = [result2, result3];
            } else {
              result2 = null;
              pos = pos2;
            }
          } else {
            result2 = null;
            pos = pos2;
          }
          while (result2 !== null) {
            result1.push(result2);
            pos2 = pos;
            result2 = parse__();
            if (result2 !== null) {
              result3 = parse_UnitScheme();
              if (result3 !== null) {
                result2 = [result2, result3];
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
          }
          if (result1 !== null) {
            result2 = parse__();
            if (result2 !== null) {
              result3 = parse_ParensClose();
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, schemeLiterals) {
          if (!schemeLiterals.length) {
            return;
          }
          var schemes = [];
          for (var i=0, max=schemeLiterals.length; i<max; i++) {
            schemes.push(schemeLiterals[i][1]);
          }
        
          return schemes;
        })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_OptionalDimensionIdentifier() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_DimensionIdentifier();
        if (result0 !== null) {
          result1 = parse__();
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 44) {
              result2 = ",";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\",\"");
              }
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, dimension) {
          return dimension;
        })(pos0, result0[0]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_DimensionIdentifier() {
        var result0;
        
        reportFailures++;
        result0 = parse_IdentifierLiteral();
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("dimensionName");
        }
        return result0;
      }
      
      function parse_NewUnitIdentifier() {
        var result0;
        
        reportFailures++;
        result0 = parse_IdentifierLiteral();
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("newUnitName");
        }
        return result0;
      }
      
      function parse_UnitScheme() {
        var result0;
        
        reportFailures++;
        result0 = parse_IdentifierLiteral();
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("unitScheme");
        }
        return result0;
      }
      
      function parse_UnitExpression() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        pos2 = pos;
        result0 = parse_UnitPer();
        if (result0 !== null) {
          result1 = parse__();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos2;
          }
        } else {
          result0 = null;
          pos = pos2;
        }
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          result1 = parse_UnitMultiplier();
          if (result1 !== null) {
            result2 = [];
            pos2 = pos;
            result3 = parse_UnitMultiplicativeOperator();
            if (result3 !== null) {
              result4 = parse_UnitMultiplier();
              if (result4 !== null) {
                result3 = [result3, result4];
              } else {
                result3 = null;
                pos = pos2;
              }
            } else {
              result3 = null;
              pos = pos2;
            }
            while (result3 !== null) {
              result2.push(result3);
              pos2 = pos;
              result3 = parse_UnitMultiplicativeOperator();
              if (result3 !== null) {
                result4 = parse_UnitMultiplier();
                if (result4 !== null) {
                  result3 = [result3, result4];
                } else {
                  result3 = null;
                  pos = pos2;
                }
              } else {
                result3 = null;
                pos = pos2;
              }
            }
            if (result2 !== null) {
              result3 = parse__();
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, optionalPer, head, tail) {
            var unitNode = head,
                op;
            for (var i=0; i<tail.length; i++) {
              op = tail[i][0];
              unitNode = new ast.UnitMultOp(infixAliases[op.opName] || op.opName, unitNode, tail[i][1]);
              decorateNonTerminal(unitNode, op.offset, op.literal);
            }
            
            op = optionalPer[0];
            if (op) {
              unitNode = new ast.UnitMultOp('/', null, unitNode);
              unitNode._offsetFirst = offset;
              decorateNonTerminal(unitNode, op.offset, op.literal);
            }
            return unitNode;
        })(pos0, result0[0], result0[1], result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_UnitMultiplicativeOperator() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse__();
        if (result0 !== null) {
          result1 = parse_UnitPer();
          if (result1 !== null) {
            result2 = parse__();
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, op) { return op; })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        if (result0 === null) {
          pos0 = pos;
          result0 = parse___();
          if (result0 !== null) {
            result0 = (function(offset, space) { 
                return {
                  offset: offset,
                  literal: space,
                  opName: '*',
                };
              })(pos0, result0);
          }
          if (result0 === null) {
            pos = pos0;
          }
        }
        return result0;
      }
      
      function parse_UnitPer() {
        var result0;
        var pos0;
        
        reportFailures++;
        pos0 = pos;
        result0 = parse_UnitPerLiteral();
        if (result0 !== null) {
          result0 = (function(offset, literal) {
            return {
              offset: offset,
              literal: literal,
              opName: '/'
            };
          })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("unitPer");
        }
        return result0;
      }
      
      function parse_UnitPerLiteral() {
        var result0;
        
        if (input.substr(pos, 3) === "per") {
          result0 = "per";
          pos += 3;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"per\"");
          }
        }
        if (result0 === null) {
          if (input.charCodeAt(pos) === 47) {
            result0 = "/";
            pos++;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"/\"");
            }
          }
        }
        return result0;
      }
      
      function parse_UnitMultiplier() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_UnitIdentifier();
        if (result0 !== null) {
          result1 = parse__();
          if (result1 !== null) {
            result2 = parse_RaiseToPowerOperator();
            if (result2 !== null) {
              result3 = parse__();
              if (result3 !== null) {
                result4 = parse_IntegerNode();
                if (result4 !== null) {
                  result0 = [result0, result1, result2, result3, result4];
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, unitNode, op, num) { 
              var node = new ast.UnitPowerNode(unitNode, num); 
              return decorateNonTerminal(node, op.offset, op.literal);
            })(pos0, result0[0], result0[2], result0[4]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        if (result0 === null) {
          pos0 = pos;
          result0 = parse_UnitIdentifier();
          if (result0 !== null) {
            result0 = (function(offset, unitNode) {
                return unitNode;
              })(pos0, result0);
          }
          if (result0 === null) {
            pos = pos0;
          }
        }
        return result0;
      }
      
      function parse_RaiseToPowerOperator() {
        var result0;
        var pos0;
        
        reportFailures++;
        pos0 = pos;
        result0 = parse_RaiseToPowerOperatorLiteral();
        if (result0 !== null) {
          result0 = (function(offset, literal) {
            return {
              literal: literal,
              offset: offset,
            }
          })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("unitPower");
        }
        return result0;
      }
      
      function parse_RaiseToPowerOperatorLiteral() {
        var result0;
        var pos0;
        
        if (input.charCodeAt(pos) === 94) {
          result0 = "^";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"^\"");
          }
        }
        if (result0 === null) {
          pos0 = pos;
          if (input.substr(pos, 2) === "**") {
            result0 = "**";
            pos += 2;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"**\"");
            }
          }
          if (result0 !== null) {
            result0 = (function(offset) { return "^"; })(pos0);
          }
          if (result0 === null) {
            pos = pos0;
          }
        }
        return result0;
      }
      
      function parse_UnitIdentifier() {
        var result0, result1;
        var pos0, pos1;
        
        reportFailures++;
        pos0 = pos;
        pos1 = pos;
        result0 = parse_IdentifierLiteral();
        if (result0 !== null) {
          result1 = (function(offset, unitName) { return !!units.getUnit(unitName); })(pos, result0) ? "" : null;
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, unitName) {
          var node = new ast.UnitLiteralNode(units.getUnit(unitName), unitName);
          return decorateTerminal(node, offset, unitName);
        })(pos0, result0[0]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("unit");
        }
        return result0;
      }
      
      function parse_IncludeStatement() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 7) === "include") {
          result0 = "include";
          pos += 7;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"include\"");
          }
        }
        if (result0 !== null) {
          result1 = parse__();
          if (result1 !== null) {
            result2 = parse_StringLiteral();
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, filename) {
          turo.include(filename);
          return new ast.StatementNode("Include", filename);
        })(pos0, result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_TestStatement() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse__();
        if (result0 !== null) {
          if (input.substr(pos, 4) === "test") {
            result1 = "test";
            pos += 4;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\"test\"");
            }
          }
          if (result1 !== null) {
            result2 = parse___();
            if (result2 !== null) {
              result3 = parse_TestRHS();
              if (result3 !== null) {
                result4 = parse__();
                if (result4 !== null) {
                  result0 = [result0, result1, result2, result3, result4];
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, rhs) {
          return rhs;
        })(pos0, result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_TestRHS() {
        var result0;
        
        result0 = parse_TestStart();
        if (result0 === null) {
          result0 = parse_AssertExpression();
        }
        return result0;
      }
      
      function parse_TestStart() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_StringLiteral();
        if (result0 !== null) {
          result0 = (function(offset, testName) {
          if (testWriter) {
            testWriter.writeTestStart(testName);
          }
          return testName;
        })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_AssertExpression() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_NumericalExpression();
        if (result0 !== null) {
          result1 = parse__();
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 61) {
              result2 = "=";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"=\"");
              }
            }
            if (result2 !== null) {
              result3 = parse__();
              if (result3 !== null) {
                result4 = parse_NumericalExpression();
                if (result4 === null) {
                  result4 = parse_StringLiteral();
                }
                if (result4 !== null) {
                  result0 = [result0, result1, result2, result3, result4];
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, lhs, rhs) {
          if (testWriter) {
            testWriter.writeTestLine(lhs, rhs);
          }
          return lhs;
        })(pos0, result0[0], result0[4]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_StringLiteral() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.charCodeAt(pos) === 34) {
          result0 = "\"";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"\\\"\"");
          }
        }
        if (result0 !== null) {
          result1 = [];
          if (/^[^"]/.test(input.charAt(pos))) {
            result2 = input.charAt(pos);
            pos++;
          } else {
            result2 = null;
            if (reportFailures === 0) {
              matchFailed("[^\"]");
            }
          }
          while (result2 !== null) {
            result1.push(result2);
            if (/^[^"]/.test(input.charAt(pos))) {
              result2 = input.charAt(pos);
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("[^\"]");
              }
            }
          }
          if (result1 !== null) {
            if (input.charCodeAt(pos) === 34) {
              result2 = "\"";
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("\"\\\"\"");
              }
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, string) {
          return string.join("");
        })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ConstDefinition() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        if (input.substr(pos, 5) === "const") {
          result0 = "const";
          pos += 5;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"const\"");
          }
        }
        if (result0 !== null) {
          result1 = parse___();
          if (result1 !== null) {
            result2 = parse_VariableDefinition();
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, variable) {
          variable.isConstant = true;
          return variable;
        })(pos0, result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_VariableDefinition() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_IdentifierLiteral();
        if (result0 !== null) {
          result1 = parse__();
          if (result1 !== null) {
            result2 = parse_EqualitySymbol();
            if (result2 !== null) {
              result3 = parse__();
              if (result3 !== null) {
                result4 = parse_NumericalExpression();
                if (result4 !== null) {
                  result0 = [result0, result1, result2, result3, result4];
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, identifier, definition) {
          return variables.add(identifier, definition);
        })(pos0, result0[0], result0[4]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_EqualitySymbol() {
        var result0, result1;
        var pos0;
        
        pos0 = pos;
        if (input.charCodeAt(pos) === 58) {
          result0 = ":";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\":\"");
          }
        }
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          if (input.charCodeAt(pos) === 61) {
            result1 = "=";
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("\"=\"");
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos0;
          }
        } else {
          result0 = null;
          pos = pos0;
        }
        return result0;
      }
      
      function parse_NumericalExpression() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_AdditiveExpression();
        if (result0 !== null) {
          result1 = parse_UnitConversion();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, node, unitConversion) {
            if (unitConversion) {
              unitConversion.left = node;
              node.valueNode = unitConversion;
              node = unitConversion;
            }
            return node;
          })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_UnitConversion() {
        var result0, result1, result2, result3;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse__();
        if (result0 !== null) {
          result1 = parse_UnitConversionNode();
          if (result1 !== null) {
            result2 = parse__();
            if (result2 !== null) {
              result3 = parse_UnitExpression();
              if (result3 !== null) {
                result0 = [result0, result1, result2, result3];
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, op, unitNode) {
          var node = new ast.BinaryNode(undefined, unitNode, "in");
          // node.left is populated when we have a left hand node, currently in NumericalExpression.
          decorateNonTerminal(node, op.offset, 'in');
          return node;
        })(pos0, result0[1], result0[3]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_UnitConversionNode() {
        var result0;
        var pos0;
        
        reportFailures++;
        pos0 = pos;
        if (input.substr(pos, 2) === "in") {
          result0 = "in";
          pos += 2;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"in\"");
          }
        }
        if (result0 !== null) {
          result0 = (function(offset) {
            return {
              offset: offset,
            };
          })(pos0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("unitIn");
        }
        return result0;
      }
      
      function parse_AdditiveExpression() {
        var result0, result1, result2, result3, result4, result5;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_MultiplicativeExpression();
        if (result0 !== null) {
          result1 = [];
          pos2 = pos;
          result2 = parse__();
          if (result2 !== null) {
            result3 = parse_AdditiveOperator();
            if (result3 !== null) {
              result4 = parse__();
              if (result4 !== null) {
                result5 = parse_MultiplicativeExpression();
                if (result5 !== null) {
                  result2 = [result2, result3, result4, result5];
                } else {
                  result2 = null;
                  pos = pos2;
                }
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
          } else {
            result2 = null;
            pos = pos2;
          }
          while (result2 !== null) {
            result1.push(result2);
            pos2 = pos;
            result2 = parse__();
            if (result2 !== null) {
              result3 = parse_AdditiveOperator();
              if (result3 !== null) {
                result4 = parse__();
                if (result4 !== null) {
                  result5 = parse_MultiplicativeExpression();
                  if (result5 !== null) {
                    result2 = [result2, result3, result4, result5];
                  } else {
                    result2 = null;
                    pos = pos2;
                  }
                } else {
                  result2 = null;
                  pos = pos2;
                }
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
          }
          if (result1 !== null) {
            result2 = parse__();
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, head, tail) {
              return unpackLeftBinaryOperations(head, tail);
            })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_AdditiveOperator() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_AdditiveOperatorLiteral();
        if (result0 !== null) {
          result0 = (function(offset, literal) {
            return {
              literal: literal,
              offset: offset
            };
          })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_AdditiveOperatorLiteral() {
        var result0;
        
        reportFailures++;
        if (input.charCodeAt(pos) === 43) {
          result0 = "+";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"+\"");
          }
        }
        if (result0 === null) {
          if (input.charCodeAt(pos) === 45) {
            result0 = "-";
            pos++;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"-\"");
            }
          }
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("plusMinus");
        }
        return result0;
      }
      
      function parse_MultiplicativeExpression() {
        var result0, result1, result2, result3, result4, result5;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_MultiplactionOperand();
        if (result0 !== null) {
          result1 = [];
          pos2 = pos;
          result2 = parse__();
          if (result2 !== null) {
            result3 = parse_MultiplicativeOperator();
            if (result3 !== null) {
              result4 = parse__();
              if (result4 !== null) {
                result5 = parse_MultiplactionOperand();
                if (result5 !== null) {
                  result2 = [result2, result3, result4, result5];
                } else {
                  result2 = null;
                  pos = pos2;
                }
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
          } else {
            result2 = null;
            pos = pos2;
          }
          while (result2 !== null) {
            result1.push(result2);
            pos2 = pos;
            result2 = parse__();
            if (result2 !== null) {
              result3 = parse_MultiplicativeOperator();
              if (result3 !== null) {
                result4 = parse__();
                if (result4 !== null) {
                  result5 = parse_MultiplactionOperand();
                  if (result5 !== null) {
                    result2 = [result2, result3, result4, result5];
                  } else {
                    result2 = null;
                    pos = pos2;
                  }
                } else {
                  result2 = null;
                  pos = pos2;
                }
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, head, tail) {
              return unpackLeftBinaryOperations(head, tail);
            })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_MultiplicativeOperator() {
        var result0;
        var pos0;
        
        reportFailures++;
        pos0 = pos;
        result0 = parse_MultiplicativeOperatorLiteral();
        if (result0 !== null) {
          result0 = (function(offset, literal) {
            return {
              literal: literal, 
              offset: offset
            };
          })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("multiplyDivide");
        }
        return result0;
      }
      
      function parse_MultiplicativeOperatorLiteral() {
        var result0;
        
        if (input.charCodeAt(pos) === 42) {
          result0 = "*";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"*\"");
          }
        }
        if (result0 === null) {
          if (input.charCodeAt(pos) === 215) {
            result0 = "\xD7";
            pos++;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\xD7\"");
            }
          }
          if (result0 === null) {
            if (input.charCodeAt(pos) === 47) {
              result0 = "/";
              pos++;
            } else {
              result0 = null;
              if (reportFailures === 0) {
                matchFailed("\"/\"");
              }
            }
            if (result0 === null) {
              if (input.charCodeAt(pos) === 247) {
                result0 = "\xF7";
                pos++;
              } else {
                result0 = null;
                if (reportFailures === 0) {
                  matchFailed("\"\\xF7\"");
                }
              }
            }
          }
        }
        return result0;
      }
      
      function parse_MultiplactionOperand() {
        var result0, result1, result2;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        result0 = [];
        pos2 = pos;
        result1 = parse_AdditiveOperator();
        if (result1 !== null) {
          result2 = parse__();
          if (result2 !== null) {
            result1 = [result1, result2];
          } else {
            result1 = null;
            pos = pos2;
          }
        } else {
          result1 = null;
          pos = pos2;
        }
        while (result1 !== null) {
          result0.push(result1);
          pos2 = pos;
          result1 = parse_AdditiveOperator();
          if (result1 !== null) {
            result2 = parse__();
            if (result2 !== null) {
              result1 = [result1, result2];
            } else {
              result1 = null;
              pos = pos2;
            }
          } else {
            result1 = null;
            pos = pos2;
          }
        }
        if (result0 !== null) {
          result1 = parse_NamedBinaryOperation();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, prefixes, operand) {
            var minus = false, i=0, max=prefixes.length;
            for (; i < max; i++) {
              if (prefixes[i][0].literal == "-") {
                minus = !minus;
              }
            }
        
            return (minus) ?
                    new ast.UnaryOperationNode(operand, "-", true)
                  : operand;
           })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_NamedBinaryOperation() {
        var result0, result1, result2, result3, result4, result5;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_NamedPostfixUnaryOperation();
        if (result0 !== null) {
          result1 = [];
          pos2 = pos;
          result2 = parse__();
          if (result2 !== null) {
            result3 = parse_NamedBinaryOperator();
            if (result3 !== null) {
              result4 = parse__();
              if (result4 !== null) {
                result5 = parse_NamedPostfixUnaryOperation();
                if (result5 !== null) {
                  result2 = [result2, result3, result4, result5];
                } else {
                  result2 = null;
                  pos = pos2;
                }
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
          } else {
            result2 = null;
            pos = pos2;
          }
          while (result2 !== null) {
            result1.push(result2);
            pos2 = pos;
            result2 = parse__();
            if (result2 !== null) {
              result3 = parse_NamedBinaryOperator();
              if (result3 !== null) {
                result4 = parse__();
                if (result4 !== null) {
                  result5 = parse_NamedPostfixUnaryOperation();
                  if (result5 !== null) {
                    result2 = [result2, result3, result4, result5];
                  } else {
                    result2 = null;
                    pos = pos2;
                  }
                } else {
                  result2 = null;
                  pos = pos2;
                }
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, head, tail) {
            return unpackRightBinaryOperations(head, tail);
          })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_NamedBinaryOperator() {
        var result0;
        var pos0;
        
        reportFailures++;
        pos0 = pos;
        result0 = parse_NamedBinaryOperatorLiteral();
        if (result0 !== null) {
          result0 = (function(offset, literal) {
            return {
              literal: literal,
              offset: offset,
            }
          })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("infixOp");
        }
        return result0;
      }
      
      function parse_NamedBinaryOperatorLiteral() {
        var result0, result1;
        var pos0, pos1;
        
        result0 = parse_SpecialNamedBinaryOperator();
        if (result0 === null) {
          pos0 = pos;
          pos1 = pos;
          result0 = parse_IdentifierLiteral();
          if (result0 !== null) {
            result1 = (function(offset, operator) {
                  return (operators && operators.hasInfixOperator(operator));
                })(pos, result0) ? "" : null;
            if (result1 !== null) {
              result0 = [result0, result1];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
          if (result0 !== null) {
            result0 = (function(offset, operator) {
                return operator;
              })(pos0, result0[0]);
          }
          if (result0 === null) {
            pos = pos0;
          }
        }
        return result0;
      }
      
      function parse_SpecialNamedBinaryOperator() {
        var result0;
        
        if (input.charCodeAt(pos) === 94) {
          result0 = "^";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"^\"");
          }
        }
        if (result0 === null) {
          if (input.charCodeAt(pos) === 8730) {
            result0 = "\u221A";
            pos++;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\u221A\"");
            }
          }
        }
        return result0;
      }
      
      function parse_NamedPrefixUnaryOperation() {
        var result0, result1, result2;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        result0 = [];
        pos2 = pos;
        result1 = parse_NamedPrefixOperator();
        if (result1 !== null) {
          result2 = parse__();
          if (result2 !== null) {
            result1 = [result1, result2];
          } else {
            result1 = null;
            pos = pos2;
          }
        } else {
          result1 = null;
          pos = pos2;
        }
        while (result1 !== null) {
          result0.push(result1);
          pos2 = pos;
          result1 = parse_NamedPrefixOperator();
          if (result1 !== null) {
            result2 = parse__();
            if (result2 !== null) {
              result1 = [result1, result2];
            } else {
              result1 = null;
              pos = pos2;
            }
          } else {
            result1 = null;
            pos = pos2;
          }
        }
        if (result0 !== null) {
          result1 = parse_ValueOrParensWithUnit();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, prefixes, value) {
            value = unpackUnaryOperations(value, prefixes.reverse(), true);
            //UnaryOperationNode
            return value;
          })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_NamedPrefixOperator() {
        var result0;
        var pos0;
        
        reportFailures++;
        pos0 = pos;
        result0 = parse_SymbolTablePrefixOperator();
        if (result0 !== null) {
          result0 = (function(offset, literal) {
              return {
                literal: literal,
                offset: offset
              };
            })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("prefixOp");
        }
        return result0;
      }
      
      function parse_SymbolTablePrefixOperator() {
        var result0, result1;
        var pos0, pos1;
        
        if (input.substr(pos, 4) === "sqrt") {
          result0 = "sqrt";
          pos += 4;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"sqrt\"");
          }
        }
        if (result0 === null) {
          if (input.charCodeAt(pos) === 8730) {
            result0 = "\u221A";
            pos++;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"\\u221A\"");
            }
          }
          if (result0 === null) {
            if (input.charCodeAt(pos) === 45) {
              result0 = "-";
              pos++;
            } else {
              result0 = null;
              if (reportFailures === 0) {
                matchFailed("\"-\"");
              }
            }
            if (result0 === null) {
              pos0 = pos;
              pos1 = pos;
              result0 = parse_IdentifierLiteral();
              if (result0 !== null) {
                result1 = (function(offset, literal) {
                      return (operators && operators.hasPrefixOperator(literal));
                    })(pos, result0) ? "" : null;
                if (result1 !== null) {
                  result0 = [result0, result1];
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
              if (result0 !== null) {
                result0 = (function(offset, literal) {
                    return literal;
                  })(pos0, result0[0]);
              }
              if (result0 === null) {
                pos = pos0;
              }
            }
          }
        }
        return result0;
      }
      
      function parse_NamedPostfixUnaryOperation() {
        var result0, result1, result2, result3;
        var pos0, pos1, pos2;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_NamedPrefixUnaryOperation();
        if (result0 !== null) {
          result1 = [];
          pos2 = pos;
          result2 = parse_NamedPostfixOperator();
          if (result2 !== null) {
            result3 = parse__();
            if (result3 !== null) {
              result2 = [result2, result3];
            } else {
              result2 = null;
              pos = pos2;
            }
          } else {
            result2 = null;
            pos = pos2;
          }
          while (result2 !== null) {
            result1.push(result2);
            pos2 = pos;
            result2 = parse_NamedPostfixOperator();
            if (result2 !== null) {
              result3 = parse__();
              if (result3 !== null) {
                result2 = [result2, result3];
              } else {
                result2 = null;
                pos = pos2;
              }
            } else {
              result2 = null;
              pos = pos2;
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, value, postfixes) {
            value = unpackUnaryOperations(value, postfixes, false);
            //UnaryOperationNode
            return value;
          })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_NamedPostfixOperator() {
        var result0;
        var pos0;
        
        reportFailures++;
        pos0 = pos;
        result0 = parse_SymbolTablePostfixOperator();
        if (result0 !== null) {
          result0 = (function(offset, literal) {
              return {
                literal: literal,
                offset: offset
              };
            })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("postfixOp");
        }
        return result0;
      }
      
      function parse_SymbolTablePostfixOperator() {
        var result0, result1;
        var pos0;
        
        reportFailures++;
        if (input.charCodeAt(pos) === 33) {
          result0 = "!";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"!\"");
          }
        }
        if (result0 === null) {
          pos0 = pos;
          result0 = parse_IdentifierLiteral();
          if (result0 !== null) {
            result1 = (function(offset, literal) {
                  return (operators && operators.hasPostfixOperator(literal));
                })(pos, result0) ? "" : null;
            if (result1 !== null) {
              result0 = [result0, result1];
            } else {
              result0 = null;
              pos = pos0;
            }
          } else {
            result0 = null;
            pos = pos0;
          }
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("postfixOp");
        }
        return result0;
      }
      
      function parse_ValueOrParensWithUnit() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse__();
        if (result0 !== null) {
          result1 = parse_ValueOrParens();
          if (result1 !== null) {
            result2 = parse_UnitExpression();
            result2 = result2 !== null ? result2 : "";
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, node, unitNode) {
            if (unitNode) {
              node.unitLiteral = unitNode.unit;
              node.unitNode = unitNode;
              unitNode.valueNode = node;
              delete node._offsetLast;
            }
            return node;
          })(pos0, result0[1], result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ValueOrParens() {
        var result0, result1, result2, result3, result4, result5;
        var pos0, pos1;
        
        pos0 = pos;
        result0 = parse_Terminal();
        if (result0 !== null) {
          result0 = (function(offset, t) {
              return decorateTerminal(t, offset, t.literal || t.name);
            })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        if (result0 === null) {
          pos0 = pos;
          pos1 = pos;
          result0 = parse_ParensOpen();
          if (result0 !== null) {
            result1 = parse__();
            if (result1 !== null) {
              result2 = parse_NumericalExpression();
              if (result2 !== null) {
                result3 = parse__();
                if (result3 !== null) {
                  result4 = parse_ParensClose();
                  if (result4 !== null) {
                    result5 = parse__();
                    if (result5 !== null) {
                      result0 = [result0, result1, result2, result3, result4, result5];
                    } else {
                      result0 = null;
                      pos = pos1;
                    }
                  } else {
                    result0 = null;
                    pos = pos1;
                  }
                } else {
                  result0 = null;
                  pos = pos1;
                }
              } else {
                result0 = null;
                pos = pos1;
              }
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
          if (result0 !== null) {
            result0 = (function(offset, expression, pc) { 
                expression.inBrackets = true;
                expression._og_offsetFirst = expression.offsetFirst;
                expression._og_offsetLast = expression.offsetLast;
                expression._offsetFirst = offset;
                expression._offsetLast = pc.offset;
                expression.isMissingParensClose = (pc.offset >= inputLength);
                return expression; 
              })(pos0, result0[2], result0[4]);
          }
          if (result0 === null) {
            pos = pos0;
          }
        }
        return result0;
      }
      
      function parse_ParensOpen() {
        var result0;
        
        reportFailures++;
        if (input.charCodeAt(pos) === 40) {
          result0 = "(";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"(\"");
          }
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("parensOpen");
        }
        return result0;
      }
      
      function parse_ParensClose() {
        var result0;
        var pos0;
        
        reportFailures++;
        pos0 = pos;
        if (input.charCodeAt(pos) === 41) {
          result0 = ")";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\")\"");
          }
        }
        if (result0 !== null) {
          result0 = (function(offset) {
            return {offset: offset};
          })(pos0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("parensClose");
        }
        return result0;
      }
      
      function parse_Terminal() {
        var result0;
        
        result0 = parse_Number();
        if (result0 === null) {
          result0 = parse_Identifier();
        }
        return result0;
      }
      
      function parse_Identifier() {
        var result0, result1, result2;
        var pos0, pos1;
        
        reportFailures++;
        pos0 = pos;
        pos1 = pos;
        result0 = parse_IdentifierLiteral();
        if (result0 !== null) {
          result1 = (function(offset, identifier) { return !variables || !!variables.getVariableDefinition(identifier); })(pos, result0) ? "" : null;
          if (result1 !== null) {
            result2 = parse__();
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, identifier) { return new ast.IdentifierNode(identifier); })(pos0, result0[0]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("variable");
        }
        return result0;
      }
      
      function parse_IdentifierLiteral() {
        var result0, result1, result2, result3;
        var pos0, pos1, pos2, pos3;
        
        reportFailures++;
        pos0 = pos;
        pos1 = pos;
        pos2 = pos;
        reportFailures++;
        pos3 = pos;
        result0 = parse_KeywordLiteral();
        if (result0 !== null) {
          result1 = parse___();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos3;
          }
        } else {
          result0 = null;
          pos = pos3;
        }
        reportFailures--;
        if (result0 === null) {
          result0 = "";
        } else {
          result0 = null;
          pos = pos2;
        }
        if (result0 !== null) {
          if (/^[a-zA-Z_]/.test(input.charAt(pos))) {
            result1 = input.charAt(pos);
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("[a-zA-Z_]");
            }
          }
          if (result1 !== null) {
            result2 = [];
            if (/^[a-zA-Z_0-9]/.test(input.charAt(pos))) {
              result3 = input.charAt(pos);
              pos++;
            } else {
              result3 = null;
              if (reportFailures === 0) {
                matchFailed("[a-zA-Z_0-9]");
              }
            }
            while (result3 !== null) {
              result2.push(result3);
              if (/^[a-zA-Z_0-9]/.test(input.charAt(pos))) {
                result3 = input.charAt(pos);
                pos++;
              } else {
                result3 = null;
                if (reportFailures === 0) {
                  matchFailed("[a-zA-Z_0-9]");
                }
              }
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, head, tail) { return head + tail.join(""); })(pos0, result0[1], result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("identifier");
        }
        return result0;
      }
      
      function parse_Number() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_NumberLiteralString();
        if (result0 !== null) {
          result1 = parse__();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, number) { return new ast.NumberNode(number); })(pos0, result0[0]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_NumberLiteral() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_NumberLiteralString();
        if (result0 !== null) {
          result0 = (function(offset, parts) {
          parts = typeof parts === 'string' ? parts : parts.join("");
          return parseFloat(parts , 10);
        })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_NumberLiteralString() {
        var result0, result1, result2;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_AdditiveOperatorLiteral();
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          result1 = parse_NumberLiteralFromParts();
          if (result1 !== null) {
            result2 = parse_ExponentLiteral();
            result2 = result2 !== null ? result2 : "";
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos1;
            }
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, sign, parts, exp) {
          parts = typeof parts === 'string' ? parts : parts.join("");
          return sign + parts + exp;
        })(pos0, result0[0], result0[1], result0[2]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_NumberLiteralFromParts() {
        var result0, result1;
        var pos0;
        
        pos0 = pos;
        result0 = parse_NumberWholePart();
        if (result0 !== null) {
          result1 = parse_NumberDecimalPart();
          result1 = result1 !== null ? result1 : "";
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos0;
          }
        } else {
          result0 = null;
          pos = pos0;
        }
        if (result0 === null) {
          result0 = parse_NumberDecimalPart();
        }
        return result0;
      }
      
      function parse_NumberWholePart() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_Digits();
        if (result0 !== null) {
          result0 = (function(offset, digits) {
          return digits;
        })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_Digits() {
        var result0, result1;
        var pos0;
        
        reportFailures++;
        pos0 = pos;
        if (/^[0-9]/.test(input.charAt(pos))) {
          result1 = input.charAt(pos);
          pos++;
        } else {
          result1 = null;
          if (reportFailures === 0) {
            matchFailed("[0-9]");
          }
        }
        if (result1 !== null) {
          result0 = [];
          while (result1 !== null) {
            result0.push(result1);
            if (/^[0-9]/.test(input.charAt(pos))) {
              result1 = input.charAt(pos);
              pos++;
            } else {
              result1 = null;
              if (reportFailures === 0) {
                matchFailed("[0-9]");
              }
            }
          }
        } else {
          result0 = null;
        }
        if (result0 !== null) {
          result0 = (function(offset, digits) {
          // this is helpful for knowing if we have EOF e.g. keyboard, autocomplete
          self.lastDigitOffset = offset + digits.length;
          return digits.join("");
        })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("digits");
        }
        return result0;
      }
      
      function parse_NumberDecimalPart() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_DecimalPoint();
        if (result0 !== null) {
          result1 = parse_Digits();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, digits) {
          return "." + digits;
        })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_DecimalPoint() {
        var result0;
        
        reportFailures++;
        if (input.charCodeAt(pos) === 46) {
          result0 = ".";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\".\"");
          }
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("point");
        }
        return result0;
      }
      
      function parse_ExponentLiteral() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_ExponentSign();
        if (result0 !== null) {
          result1 = parse_IntegerString();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, integer) {
          return "e" + integer;
        })(pos0, result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_ExponentSign() {
        var result0;
        
        reportFailures++;
        if (input.charCodeAt(pos) === 101) {
          result0 = "e";
          pos++;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"e\"");
          }
        }
        if (result0 === null) {
          if (input.charCodeAt(pos) === 69) {
            result0 = "E";
            pos++;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"E\"");
            }
          }
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("exponent");
        }
        return result0;
      }
      
      function parse_IntegerNode() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_IntegerString();
        if (result0 !== null) {
          result0 = (function(offset, number) { 
          var node = new ast.NumberNode(number);
          return decorateTerminal(node, offset, number);
        })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_IntegerLiteral() {
        var result0;
        var pos0;
        
        pos0 = pos;
        result0 = parse_IntegerString();
        if (result0 !== null) {
          result0 = (function(offset, string) {
          return parseInt(string, 10);
        })(pos0, result0);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_IntegerString() {
        var result0, result1;
        var pos0, pos1;
        
        pos0 = pos;
        pos1 = pos;
        result0 = parse_AdditiveOperatorLiteral();
        result0 = result0 !== null ? result0 : "";
        if (result0 !== null) {
          result1 = parse_NumberWholePart();
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos1;
          }
        } else {
          result0 = null;
          pos = pos1;
        }
        if (result0 !== null) {
          result0 = (function(offset, sign, digits) {
          return sign + digits;
        })(pos0, result0[0], result0[1]);
        }
        if (result0 === null) {
          pos = pos0;
        }
        return result0;
      }
      
      function parse_KeywordLiteral() {
        var result0;
        
        if (input.substr(pos, 4) === "unit") {
          result0 = "unit";
          pos += 4;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"unit\"");
          }
        }
        if (result0 === null) {
          if (input.substr(pos, 3) === "per") {
            result0 = "per";
            pos += 3;
          } else {
            result0 = null;
            if (reportFailures === 0) {
              matchFailed("\"per\"");
            }
          }
          if (result0 === null) {
            if (input.substr(pos, 5) === "const") {
              result0 = "const";
              pos += 5;
            } else {
              result0 = null;
              if (reportFailures === 0) {
                matchFailed("\"const\"");
              }
            }
            if (result0 === null) {
              if (input.substr(pos, 4) === "test") {
                result0 = "test";
                pos += 4;
              } else {
                result0 = null;
                if (reportFailures === 0) {
                  matchFailed("\"test\"");
                }
              }
              if (result0 === null) {
                if (input.substr(pos, 7) === "include") {
                  result0 = "include";
                  pos += 7;
                } else {
                  result0 = null;
                  if (reportFailures === 0) {
                    matchFailed("\"include\"");
                  }
                }
                if (result0 === null) {
                  if (input.substr(pos, 5) === "units") {
                    result0 = "units";
                    pos += 5;
                  } else {
                    result0 = null;
                    if (reportFailures === 0) {
                      matchFailed("\"units\"");
                    }
                  }
                  if (result0 === null) {
                    if (input.substr(pos, 3) === "let") {
                      result0 = "let";
                      pos += 3;
                    } else {
                      result0 = null;
                      if (reportFailures === 0) {
                        matchFailed("\"let\"");
                      }
                    }
                  }
                }
              }
            }
          }
        }
        return result0;
      }
      
      function parse__() {
        var result0, result1, result2, result3, result4;
        var pos0, pos1;
        
        reportFailures++;
        pos0 = pos;
        result0 = [];
        if (/^[ \t\r\n]/.test(input.charAt(pos))) {
          result1 = input.charAt(pos);
          pos++;
        } else {
          result1 = null;
          if (reportFailures === 0) {
            matchFailed("[ \\t\\r\\n]");
          }
        }
        while (result1 !== null) {
          result0.push(result1);
          if (/^[ \t\r\n]/.test(input.charAt(pos))) {
            result1 = input.charAt(pos);
            pos++;
          } else {
            result1 = null;
            if (reportFailures === 0) {
              matchFailed("[ \\t\\r\\n]");
            }
          }
        }
        if (result0 !== null) {
          result1 = [];
          pos1 = pos;
          result2 = parse_Comment();
          if (result2 !== null) {
            result3 = [];
            if (/^[ \t\r\n]/.test(input.charAt(pos))) {
              result4 = input.charAt(pos);
              pos++;
            } else {
              result4 = null;
              if (reportFailures === 0) {
                matchFailed("[ \\t\\r\\n]");
              }
            }
            while (result4 !== null) {
              result3.push(result4);
              if (/^[ \t\r\n]/.test(input.charAt(pos))) {
                result4 = input.charAt(pos);
                pos++;
              } else {
                result4 = null;
                if (reportFailures === 0) {
                  matchFailed("[ \\t\\r\\n]");
                }
              }
            }
            if (result3 !== null) {
              result2 = [result2, result3];
            } else {
              result2 = null;
              pos = pos1;
            }
          } else {
            result2 = null;
            pos = pos1;
          }
          while (result2 !== null) {
            result1.push(result2);
            pos1 = pos;
            result2 = parse_Comment();
            if (result2 !== null) {
              result3 = [];
              if (/^[ \t\r\n]/.test(input.charAt(pos))) {
                result4 = input.charAt(pos);
                pos++;
              } else {
                result4 = null;
                if (reportFailures === 0) {
                  matchFailed("[ \\t\\r\\n]");
                }
              }
              while (result4 !== null) {
                result3.push(result4);
                if (/^[ \t\r\n]/.test(input.charAt(pos))) {
                  result4 = input.charAt(pos);
                  pos++;
                } else {
                  result4 = null;
                  if (reportFailures === 0) {
                    matchFailed("[ \\t\\r\\n]");
                  }
                }
              }
              if (result3 !== null) {
                result2 = [result2, result3];
              } else {
                result2 = null;
                pos = pos1;
              }
            } else {
              result2 = null;
              pos = pos1;
            }
          }
          if (result1 !== null) {
            result0 = [result0, result1];
          } else {
            result0 = null;
            pos = pos0;
          }
        } else {
          result0 = null;
          pos = pos0;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("some whitespace");
        }
        return result0;
      }
      
      function parse_Comment() {
        var result0, result1, result2, result3;
        var pos0;
        
        pos0 = pos;
        if (input.substr(pos, 2) === "//") {
          result0 = "//";
          pos += 2;
        } else {
          result0 = null;
          if (reportFailures === 0) {
            matchFailed("\"//\"");
          }
        }
        if (result0 !== null) {
          result1 = [];
          if (/^[^\n]/.test(input.charAt(pos))) {
            result2 = input.charAt(pos);
            pos++;
          } else {
            result2 = null;
            if (reportFailures === 0) {
              matchFailed("[^\\n]");
            }
          }
          while (result2 !== null) {
            result1.push(result2);
            if (/^[^\n]/.test(input.charAt(pos))) {
              result2 = input.charAt(pos);
              pos++;
            } else {
              result2 = null;
              if (reportFailures === 0) {
                matchFailed("[^\\n]");
              }
            }
          }
          if (result1 !== null) {
            if (/^[\r\n]/.test(input.charAt(pos))) {
              result3 = input.charAt(pos);
              pos++;
            } else {
              result3 = null;
              if (reportFailures === 0) {
                matchFailed("[\\r\\n]");
              }
            }
            if (result3 !== null) {
              result2 = [];
              while (result3 !== null) {
                result2.push(result3);
                if (/^[\r\n]/.test(input.charAt(pos))) {
                  result3 = input.charAt(pos);
                  pos++;
                } else {
                  result3 = null;
                  if (reportFailures === 0) {
                    matchFailed("[\\r\\n]");
                  }
                }
              }
            } else {
              result2 = null;
            }
            if (result2 !== null) {
              result0 = [result0, result1, result2];
            } else {
              result0 = null;
              pos = pos0;
            }
          } else {
            result0 = null;
            pos = pos0;
          }
        } else {
          result0 = null;
          pos = pos0;
        }
        return result0;
      }
      
      function parse___() {
        var result0, result1;
        
        reportFailures++;
        if (/^[ \t\r\n]/.test(input.charAt(pos))) {
          result1 = input.charAt(pos);
          pos++;
        } else {
          result1 = null;
          if (reportFailures === 0) {
            matchFailed("[ \\t\\r\\n]");
          }
        }
        if (result1 !== null) {
          result0 = [];
          while (result1 !== null) {
            result0.push(result1);
            if (/^[ \t\r\n]/.test(input.charAt(pos))) {
              result1 = input.charAt(pos);
              pos++;
            } else {
              result1 = null;
              if (reportFailures === 0) {
                matchFailed("[ \\t\\r\\n]");
              }
            }
          }
        } else {
          result0 = null;
        }
        reportFailures--;
        if (reportFailures === 0 && result0 === null) {
          matchFailed("whitespace");
        }
        return result0;
      }
      
      
      function cleanupExpected(expected) {
        expected.sort();
        
        var lastExpected = null;
        var cleanExpected = [];
        for (var i = 0; i < expected.length; i++) {
          if (expected[i] !== lastExpected) {
            cleanExpected.push(expected[i]);
            lastExpected = expected[i];
          }
        }
        return cleanExpected;
      }
      
      function computeErrorPosition() {
        /*
         * The first idea was to use |String.split| to break the input up to the
         * error position along newlines and derive the line and column from
         * there. However IE's |split| implementation is so broken that it was
         * enough to prevent it.
         */
        
        var line = 1;
        var column = 1;
        var seenCR = false;
        
        for (var i = 0; i < Math.max(pos, rightmostFailuresPos); i++) {
          var ch = input.charAt(i);
          if (ch === "\n") {
            if (!seenCR) { line++; }
            column = 1;
            seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            line++;
            column = 1;
            seenCR = true;
          } else {
            column++;
            seenCR = false;
          }
        }
        
        return { line: line, column: column };
      }
      
      
        var ast = require("../lib/ast");
      
        var infixAliases = {
          '**': '^',
          '×': '*',
          '÷': '/',
          'per': '/',
          ' ': '*',
          '√': 'nth_root',
        };
      
        var unaryAliases = {
          '√': 'sqrt',
        };
      
        function unpackLeftBinaryOperations(head, tail) {
          // head:MultiplicativeExpression
          // tail:(_ AdditiveOperator _ MultiplicativeExpression)* _
          var result = head, op;
          for (var i=0, max=tail.length; i < max; i++) {
            op = tail[i][1];
            result = new ast.BinaryNode(result, tail[i][3], infixAliases[op.literal] || op.literal);
      
            decorateNonTerminal(result, op.offset, op.literal);
          }
          return result;
        }
      
        function unpackRightBinaryOperations(head, tail) {
          if (!tail || tail.length === 0) {
            return head;
          }
      
          // head:MultiplicativeExpression
          // tail:(_ AdditiveOperator _ MultiplicativeExpression)* _
          var left, result, op;
      
          // 1 op 2 op 3
          // 2^3^4 2^(3^4)
      
          for (var i = tail.length - 1; i>=0; i--) {
            if (!result) {
              result = tail[i][3];
              op = tail[i][1];
            } else {
              left = tail[i][3];
              result = new ast.BinaryNode(left, result, infixAliases[op.literal] || op.literal);
              decorateNonTerminal(result, op.offset, op.literal);
              op = tail[i][1];
            }
          }
          result = new ast.BinaryNode(head, result, infixAliases[op.literal] || op.literal);
          return decorateNonTerminal(result, op.offset, op.literal);
        }
      
        function unpackUnaryOperations(current, operators, isPrefix) {
          // (NamedPostfixOperator _)*
          var op;
          for (var i=0, max=operators.length; i<max; i++) {
            op = operators[i][0];
            current = new ast.UnaryOperationNode(current, unaryAliases[op.literal] || op.literal, isPrefix);
      
            current._offsetLiteralFirst = op.offset;
            current._offsetLiteralLast = op.offset + op.literal.length - 1;
      
            if (isPrefix) {
              current._offsetFirst = current._offsetLiteralFirst;
              delete current._offsetLast;
            } else {
              delete current._offsetFirst;
              current._offsetLast = current._offsetLiteralLast;
            }
      
          }
          return current;
        }
      
        function decorateTerminal (node, offset, string) {
          var last = offset + string.length - 1;
          node._offsetFirst = offset;
          node._offsetLast = last; 
          node._offsetLiteralFirst = offset;
          node._offsetLiteralLast = last;
          return node;
        }
      
        function decorateNonTerminal(node, offset, string) {
          var last = offset + string.length - 1;
          node._offsetLiteralFirst = offset;
          node._offsetLiteralLast = last;
          return node;
        }
      
        var self = this,
            turo = this.turo || {};
            emitter = this.emitter,
            units = turo.units ||
                    this.units, // for backwards compat.
            variables = turo.variables ||
                        this.variables, // for backwards compat.
            operators = turo.operators || this.operators,
            testWriter = turo.writer ||
                        this.testWriter, // for backwards compat.
            inputLength = this.inputLength || input.length;
      
        
      
        this.reservedWords = ["unit", "per", "const", "test", "include", "units", "let"];
      
      
      var result = parseFunctions[startRule]();
      
      /*
       * The parser is now in one of the following three states:
       *
       * 1. The parser successfully parsed the whole input.
       *
       *    - |result !== null|
       *    - |pos === input.length|
       *    - |rightmostFailuresExpected| may or may not contain something
       *
       * 2. The parser successfully parsed only a part of the input.
       *
       *    - |result !== null|
       *    - |pos < input.length|
       *    - |rightmostFailuresExpected| may or may not contain something
       *
       * 3. The parser did not successfully parse any part of the input.
       *
       *   - |result === null|
       *   - |pos === 0|
       *   - |rightmostFailuresExpected| contains at least one failure
       *
       * All code following this comment (including called functions) must
       * handle these states.
       */
      if (result === null || pos !== input.length) {
        var offset = Math.max(pos, rightmostFailuresPos);
        var found = offset < input.length ? input.charAt(offset) : null;
        var errorPosition = computeErrorPosition();
        
        throw new this.SyntaxError(
          cleanupExpected(rightmostFailuresExpected),
          found,
          offset,
          errorPosition.line,
          errorPosition.column
        );
      }
      
      return result;
    },
    
    /* Returns the parser source code. */
    toSource: function() { return this._source; }
  };
  
  /* Thrown when a parser encounters a syntax error. */
  
  result.SyntaxError = function(expected, found, offset, line, column) {
    function buildMessage(expected, found) {
      var expectedHumanized, foundHumanized;
      
      switch (expected.length) {
        case 0:
          expectedHumanized = "end of input";
          break;
        case 1:
          expectedHumanized = expected[0];
          break;
        default:
          expectedHumanized = expected.slice(0, expected.length - 1).join(", ")
            + " or "
            + expected[expected.length - 1];
      }
      
      foundHumanized = found ? quote(found) : "end of input";
      
      return "Expected " + expectedHumanized + " but " + foundHumanized + " found.";
    }
    
    this.name = "SyntaxError";
    this.expected = expected;
    this.found = found;
    this.message = buildMessage(expected, found);
    this.offset = offset;
    this.line = line;
    this.column = column;
  };
  
  result.SyntaxError.prototype = Error.prototype;
  
  return result;
})();
},{"../lib/ast":29}],37:[function(require,module,exports){
module.exports = require("./parser-generated.js");

},{"./parser-generated.js":36}],38:[function(require,module,exports){
(function(){

  /**
   * Decimal adjustment of a number.
   *
   * @param {String}  type  The type of adjustment.
   * @param {Number}  value The number.
   * @param {Integer} exp   The exponent (the 10 logarithm of the adjustment base).
   * @returns {Number}      The adjusted value.
   */
  function decimalAdjust(type, value, exp) {
    // If the exp is undefined or zero...
    if (typeof exp === 'undefined' || +exp === 0) {
      return Math[type](value);
    }
    value = +value;
    exp = +exp;
    // If the value is not a number or the exp is not an integer...
    if (isNaN(value) || !(typeof exp === 'number' && exp % 1 === 0)) {
      return NaN;
    }
    // Shift
    value = value.toString().split('e');
    value = Math[type](+(value[0] + 'e' + (value[1] ? (+value[1] - exp) : -exp)));
    // Shift back
    value = value.toString().split('e');
    return +(value[0] + 'e' + (value[1] ? (+value[1] + exp) : exp));
  }

  // Decimal round
  if (!Math.round10) {
    Math.round10 = function(value, exp) {
      return decimalAdjust('round', value, exp);
    };
  }
  // Decimal floor
  if (!Math.floor10) {
    Math.floor10 = function(value, exp) {
      return decimalAdjust('floor', value, exp);
    };
  }
  // Decimal ceil
  if (!Math.ceil10) {
    Math.ceil10 = function(value, exp) {
      return decimalAdjust('ceil', value, exp);
    };
  }

})();
},{}],39:[function(require,module,exports){

var _ = require("underscore");

var PATTERN = /[()]/g;

function PreProcessor () {
  // NOP
}

PreProcessor.prototype.preprocess = function (inputString) {

  var stack = [];

  var isOpener = function (match) {
    return match === "(";
  };

  var closer = function (closer) {
    return ")";
  };

  var replacer = function (match) {

    if (isOpener(match)) {
      stack.push(closer(match));
    } else if (stack.length > 0) {
      if (match === _.last(stack)) {
        stack.pop();
      } else {
        // what?
      }
    } else {
      return "";
    }
    return match;
  };
  return inputString.replace(PATTERN, replacer) + stack.join("");
};

module.exports = {
  PreProcessor: PreProcessor,
  createEmpty: function () {
    return new this.PreProcessor();
  }
};
},{"underscore":50}],40:[function(require,module,exports){

var _ = require("underscore");

var PATTERN = /([^\w\s]?)\b([a-z_]\w*)\b([^\w\s]?)/gi;

var makeObject = (function () {
  function alwaysTrue () {
    return true;
  }

  return function makeObject (list, fn) {
    var result = {};
    if (!_.isFunction(fn)) {
      fn = alwaysTrue;
    }

    _.each(list, function (key) {
      result[key] = fn(key);
    });

    return result;
  };
})();

function PreProcessor (words) {
  if (_.isArray(words)) {
    this.reservedWords = makeObject(words);
  } else if (_.isObject(words)) {
    this.reservedWords = words;
  } else {
    this.reservedWords = {};
  }
}

var spaces = (function () {
  var cache = [];
  return function (i) {
    var j, s = cache[i];
    if (typeof s === "string") {
      return s;
    }
    s = "";
    for (j=0; j<i; j++) {
      s = s + " ";
    }
    cache[i] = s;
    return s;
  };
})();

var buildFunction = function (reservedWords) {
  return function (match, p1, word, p2) {
    if (reservedWords[word]) {
      return match;
    } else {
      return spaces(match.length);
    }
  };
};

PreProcessor.prototype.preprocess = function (inputString) {
  var replacer = buildFunction(this.reservedWords);
  return inputString.replace(PATTERN, replacer);
};

function createPreProcessor(variables, operators, units) {

  var p = new PreProcessor();

  p.rebuild = function () {
    this.reservedWords = makeObject(_.flatten([
        // TODO get this from the parser.
        ["unit", "per", "test", "const", "include"],
        operators.getInfixOperatorNames(),
        variables.getVariableNames(),
        units.getUnitNames()
      ]));
    return this;
  };

  return p.rebuild();

}

module.exports = {
  PreProcessor: PreProcessor,
  createEmpty: function (reservedWords) {
    return new this.PreProcessor(reservedWords);
  },
  createWithContext: createPreProcessor
};
},{"underscore":50}],41:[function(require,module,exports){
"use strict";

var _ = require("underscore"),
    DepGraph = require("dependency-graph").DepGraph,
    usageFinder = require("./variable-usage-finder");

function Reevaluator () {

}

_.extend(Reevaluator.prototype, {

  getStatements: function (node, variables) {
    var self = this,
        graph = new DepGraph(),
        seen = {};

    if (variables) {
      usageFinder.find(node, variables);
    }

    self._collectDependentStatements(node, graph, seen);

    return _(graph.overallOrder()).map(function (key) {
      return seen[key];
    });

  },

  _collectDependentStatements: function (node, graph, seen) {
    var self = this,
        statementKey = node.statementKey;

    if (!statementKey) {
      return false;
    }

    seen = seen || {};
    if (seen[statementKey]) {
      return true;
    }

    seen[statementKey] = node;
    delete node.value;

    graph.addNode(statementKey);

    if (!node.dependentExpressions) {
      return true;
    }

    _.each(node.dependentExpressions, function (child) {
      if (self._collectDependentStatements(child, graph, seen)) {
        graph.addDependency(child.statementKey, statementKey);
      }
    });

    return true;
  }

});


module.exports = {
  Reevaluator: Reevaluator
};
},{"./variable-usage-finder":46,"dependency-graph":49,"underscore":50}],42:[function(require,module,exports){
"use strict";
var _ = require("underscore");

var STRING_DISPLAY = {
    alwaysDisplayParens: false,

    newTokens: function () {
      return [];
    },

    returnString: function (node, tokens, padded) {
      if (tokens) {
        return tokens.join(padded || "");
      } else {
        console.error("No source for " + node);
        console.dir(node);
      }
    },

    pushTokens: function (tokens, string) {
      // TODO get rid of all this hacky stuff, because we should have no padding.
      var finalToken = tokens[tokens.length - 1];
      if (typeof finalToken !== 'undefined' && finalToken.indexOf("(") >= 0) {
        finalToken += string;
        tokens[tokens.length - 1] = finalToken;
      } else {
        tokens.push(string);
      }
    },

    bracketStart: function (node, tokens, context) {
      if (node.inBrackets || this.alwaysDisplayParens) {
        this.pushTokens(tokens, "(");
      }
    },

    bracketEnd: function (node, tokens, context) {
      if ((node.inBrackets && !node.isMissingParensClose) || this.alwaysDisplayParens) {
        tokens[tokens.length - 1] = tokens[tokens.length - 1] + ")";
      }
    },

    /********
     * Colors and styles.
     */


    _literal: function (literal, context) {
    if (context && context.literals) {
      return context.literals[literal] || literal;
    }
    return literal;
    },

    identifier: function (string, isConstant) {
      return string;
    },

    operator: function (string, context) {
      return this._literal(string, context);
    },

    number: function (string, context) {
      return string;
    },

    unitColor: function (string) {
      return string;
    },

    powerStart: function (tokens, context) {
      tokens.push(this._literal("^", context));
    },

    powerEnd: function (tokens, context) {
      // NOP
    },

    unitStart: function (unit, tokens, context) {},

    unitEnd: function (unit, tokens, context) {},

};







/***************
 * The actual visitor
 */


function ToSourceVisitor (display) {
  this.display = display;
}

_.extend(ToSourceVisitor.prototype, {

  bracketEnd: function (node, tokens, context) {
    if (!node.isMissingParensClose) {
      this.display.bracketEnd(node, tokens);
    }
  },

  bracketStart: function (node, tokens, context) {
    this.display.bracketStart(node, tokens, context);
  },

  printUnit: function (node, tokens, context) {
    var unit = node.unitLiteral;

    if (unit) {
      this.visitUnit(unit, tokens, context);
    }
  },

  visitBinaryOperator: function (node, tokens, context) {
    var literal = node.literal, string, space;
    this.bracketStart(node, tokens);
    node.left.accept(this, tokens, context);
    if (literal === "^") {
      // XXX horible hack.
      // I expect this should all go into a templating language.
      this.display.powerStart(tokens, context);
      node.right.accept(this, tokens, context);
      this.display.powerEnd(tokens, context);
    } else {
      if (context.prefs.operatorPadding) {
        // Pretty print this with padding between operators.
        // Currently, all the binary operators, except for power 
        // should have this, but we may need to have something more complicated
        // in the future.
        tokens.push(' ');
        tokens.push(this.display.operator(literal, context));
        tokens.push(' ');
      } else {
        tokens.push(this.display.operator(literal, context));  
      }
      
      node.right.accept(this, tokens, context);
    }
    this.bracketEnd(node, tokens);
    this.printUnit(node, tokens, context);

    return tokens;
  },

  visitUnaryOperation: function (node, tokens, context) {
    this.bracketStart(node, tokens);
    if (node.isPrefix) {
      tokens.push(this.display.operator(node.literal, context));
      if (!node.value.inBrackets && !this.display.alwaysDisplayParens) {
        tokens.push(' ');
      }
      node.value.accept(this, tokens, context);
    } else {
      node.value.accept(this, tokens, context);
      tokens.push(this.display.operator(node.literal, context));
    }
    
    this.bracketEnd(node, tokens);
    
    this.printUnit(node, tokens, context);
  },

  visitInteger: function (node, tokens, context) {
    var display = this.display;
    this.bracketStart(node, tokens);

    if (node.exponent && context.prefs.prettyPrint) {
      display.pushTokens(tokens, display.number(node.literal, context));
      display.pushTokens(tokens, display.operator('*', context));
      display.pushTokens(tokens, display.number('10', context));
      display.powerStart(tokens, context);
      tokens.push(display.number("" + node.exponent, context));
      display.powerEnd(tokens, context);
    } else {
      display.pushTokens(tokens, display.number(node.literal, context));  
    }

    
    this.bracketEnd(node, tokens);
    this.printUnit(node, tokens, context);

    return tokens;
  },

  visitIdentifier: function (node, tokens, context) {
    this.bracketStart(node, tokens);
    this.display.pushTokens(tokens, this.display.identifier(node.name, node.isConstant));
    this.printUnit(node, tokens, context);
    this.bracketEnd(node, tokens);
    return tokens;
  },

  visitVariableDefinition: function (node, tokens, context) {

    tokens.push(this.display.identifier(node.identifier, node.isConstant));
    tokens.push(this.display.operator("=", context));
    if (node.ast) {
      node.ast.accept(this, tokens, context);
    } else if (node.definition) {
      tokens.push(node.definition);
    }

    return tokens;
  },

  visitUnitDefinitionStatement: function (node, tokens, context) {
    tokens.push("unit");
    node.ast.accept(this, tokens, context);
    return tokens;
  },

  visitResult: function (node, tokens, context) {
    if (node && node.value) {
      node.value().accept(this, tokens, context);
    } else {
      this.display.pushTokens(tokens, this.display.number(node.result + "", context));
      if (node.ast.unit) {
        node.ast.unit.accept(this, tokens, context);
      }
    }
    return tokens;
  },

  visitResultObject: function (node, tokens, context) {
    if (typeof node.result === 'undefined') {
      return; // can't do anything with this.
    }

    if (node.ast.accept) {
      node.ast.accept(this, tokens, context);
    }

    if (typeof node.result !== 'undefined') {
      tokens.push(this.display.operator("=", context));
      // node.value should be a node.
      this.visitResult(node, tokens);
    }

    return tokens;
  },

  visitUnit: function (unit, tokens, context) {
    this.display.unitStart(unit, tokens, context);
    if (unit.name) {
      tokens.push(unit.name);
    } else {
      var simpleUnits = unit.simpleUnits,
          display = this.display,
          units = _.sortBy(_.keys(simpleUnits),
                  // TODO sort by alpha and sign of power, not just power
                  function (k) { return -simpleUnits[k]; }),
          unitTokens = [],
          wasNegative = false,
          string = "",
          first = true;


      _.each(units, function (u) {
        var pow = simpleUnits[u],
            negative = pow < 0,
            singleUnitTokens = [];

        if (negative) {
          pow *= -1;
          if (!wasNegative) {
            singleUnitTokens.push("/");
            wasNegative = false;
          }
        } else if (first) {
          first = false;
        } else {
          singleUnitTokens.push(" ");
        }

        if (pow) {
          singleUnitTokens.push(display.unitColor(u));
          if (pow !== 1) {
            display.powerStart(singleUnitTokens, context);
            singleUnitTokens.push(display.number("" + pow, context));
            display.powerEnd(singleUnitTokens, context);
          }
        }
        unitTokens.push(singleUnitTokens.join(""));
      });
      tokens.push(unitTokens.join(""));
    }
    this.display.unitEnd(unit, tokens, context);
    return tokens;
  },

  visitIncludeStatement: function (node, tokens, context) {
    tokens.push("include");
    tokens.push("\"" + node.ast + "\"");
  },

  visitUnitPower: function (node, context) {
    return node.unit.accept(this, context);
  },

  visitUnitLiteral: function (node, context) {
    return node.unit.accept(this, context);
  },

  visitUnitMultOp: function (node, context) {
    return node.unit.accept(this, context);
  },
});

//////////////////////////////////////////////////////////////////////////////////

var createToString = function (display) {
  var visitor = new ToSourceVisitor(display || STRING_DISPLAY);
  return function toString (node, literals, prefs) {
    var tokens = this.display.newTokens(),
        context = {},
        padding;
    if (_.isString(literals)) {
      context.literals = {};
      padding = literals;
    } else {
      context.literals = literals || {};
      padding = "";
    }

    context.prefs = prefs || {};

    if (node) {
      node.accept(visitor, tokens, context);
      return display.returnString(node, tokens, padding);
    }
  };
};

var hack_STRING_DISPLAY = _.clone(STRING_DISPLAY);

module.exports = {

  stringDisplay: STRING_DISPLAY,

  createToString: createToString,

  toString: createToString(hack_STRING_DISPLAY),

  display: hack_STRING_DISPLAY,

  displayImpliedParentheses: function (bool) {
    this.display.alwaysDisplayParens = !!bool;
  },
};
},{"underscore":50}],43:[function(require,module,exports){
var _ = require("underscore");

var parser = require("../lib/parser"),
    evaluator = require("./evaluator"),
    Units = require("./units-table").UnitsTable,
    Variables = require("./variables-symbol-table").Context,
    operatorsTable = require("./operators-symbol-table"),
    output = require("./to-source"),
    Reevaluator = require("./statement-reevaluator").Reevaluator,
    reevaluator = new Reevaluator(),
    AST = require("./ast");

require("./precision-hacks");
var MAX_SF = 14;

var DEFAULT_PREFS = {
  unitScheme: undefined,
  useUnitRefactor: false,
  precisionType: undefined, // sf or dp
  precisionDigits: 4,
  formatComma: undefined,
  formatDot: "."
};


function Result (parent, ast, result) {
  this.turo = parent.turo || parent; // we may pass in a turo there is no parent result
  this.ast = ast;
  if (ast) {
    this.id = ast.id;
  }

  this.result = result;
  if (result !== undefined) {
    this._createValueNode(result, ast.unit);
  }
}

_.extend(Result.prototype, {

  toSource: function () {
    // TODO remove the space. It requires work in to-source, and lots of tests.
    return output.toString(this.ast, " ");
  },
  toString: function (prefs) {
    this._calculateValue(prefs);
    // TODO remove the space. It requires work in to-source, and lots of tests.
    return output.toString(this, " ");
  },
  expression: function () {
    if (this.ast.identifier && this.ast.ast) {
      return this.ast.ast;
    }
    return this.ast;
  },
  expressionToString: function (literals, prefs) {
    if (!this.ast) {
      return this.parsedLine;
    }
    return output.toString(this.expression(), literals, prefs);
  },
  expressionErrors: function () {
    this._calculateValue();
    return this.parseError || this.ast.errors;
  },
  identifier: function () {
    if (!this._identifier && this.ast) {
      return this.ast.identifier;
    } else {
      return this._identifier;
    }
  },
  identifierToString: function () {
    var id = this.identifier();
    return id ? id : "";
  },
  identifierErrors: function () {
    return this._identifierErrors;
  },
  value: function () {
    this._calculateValue();
    return this._valueNode;
  },
  valueToString: function () {
    this._calculateValue();
    return output.toString(this._valueNode, " ");
  },

  _treatOutputNumber: (function () {

    function precision10 (value) {
      var exponent, largest, smallest;
      value = value.toString().split('e');
      exponent = (value[1] ? +value[1] : 0);

      value = value[0].toString().split('.');

      //value = [ "integer part", "float part"]
      largest = exponent + (+value[0] ? value[0].length : 0);
      smallest = exponent - (value[1] ? value[1].length : 0);
      return [largest, smallest];
    }

    function toPrecision10 (value, desiredPrecision) {
      var precision = precision10(value),
          roundTo;
      if ((precision[0] - precision[1]) < desiredPrecision) {
        // NOP
      } else {
        roundTo = -desiredPrecision + precision[0];
        value = Math.round10(value, roundTo);
        value = parseFloat(value.toString(), 10);
      }

      if (precision[0] > desiredPrecision || -precision[0] > desiredPrecision) {
        return value.toExponential();
      }
      return value + "";
    }
    return function _treatOutputNumber (valueNode, num, prefs) {
      var dp = prefs.precisionDigits,
          sf = Math.min(dp, MAX_SF),
          literal;
      switch (prefs.precisionType) {
        case "dp":
          literal = num.toFixed(dp);
          break;
        case "sf":
          literal = toPrecision10(num, sf);
          break;
        default:
          literal = toPrecision10(num, MAX_SF);
          num = +literal;
      }

      valueNode.value = num;
      valueNode.literal = literal;
      return literal;
    };
  })(),

  _calculateValue: function (prefs) {

    var valueNode = this._valueNode,
        result, unit;

    if (!valueNode && !this.parseError) {
      result = evaluator.evaluate(this.ast, this.turo.variables, this.turo, this.ast.errors);
      unit = this.ast.unit;
      if (result !== undefined) {
        this._valueNode = this._createValueNode(result, unit);
        // Write Once to this.result.
        this._valueNode.value = result;
        this.result = result;
      }
    }

    // if valueNode is new, or we wish to re-render with new prefs.
    if (!valueNode || prefs) {

      valueNode = this._valueNode;
      if (!valueNode) {
        // Not happy about this for error reporting.
        return;
      }

      if (prefs) {
        prefs = _.defaults(prefs, this.turo.prefs());
      } else {
        prefs = this.turo.prefs();
      }

      var node;

      result = this.result;
      

      unit = valueNode.unit;
      if (unit && prefs.useUnitRefactor) {
        node = unit.refactoredNode(result, prefs.unitScheme, prefs.simpleUnits);
        result = node.value;
        unit = node.unit;
      }

      
      valueNode.literal = result;
      valueNode.unitLiteral = unit;

      // TODO _treatOutputNumber should be more about discovering characteristics about the number which 
      // will help display. It should not be concerned with creating a single literal string.
      // e.g. integer, mantissa, exponent. it should also be notated with accuracy (from prefs).
      if (typeof result === 'number') {
        valueNode.literal = this._treatOutputNumber(valueNode, result, prefs);
      }

      
    }



    return this.result;
  },

  _createValueNode: function (numString, unit) {
    var node = AST.number(numString);
    node.unit = node.unitLiteral = unit;
    return node;
  },

  consequents: function () {
    var self = this;
    if (!this.ast || this.ast.statementType) {
      return [this];
    }
    var list = reevaluator.getStatements(this.ast, this.turo.variables);
    return _.map(list, function (ast) {
      return new Result(self, ast, evaluator.evaluate(ast, self.turo.variables, self.turo));
    });
  },
  accept: function (visitor) {
    return AST.acceptVisitor(this, visitor, visitor.visitResultObject, arguments, this.result);
  },

  // TODO test this.
  dispose: function () {
    var node = this.ast,
        statementKey = node.statementKey,
        involvedVariables = node.involvedVariables;

    if (node.identifier) {
      this.turo.variables.remove(node.identifier);
    }

    if (involvedVariables) {
      // Delete exisiting variable involvement.
      _.each(involvedVariables, function (i, variableName) {
        var definition = involvedVariables[variableName];
        if (definition.unregisterInterest) {
          definition.unregisterInterest(statementKey, node);
        }
      });
    }
  },

});

function Turo (prefs) {
  // NOP
  this.prefs(prefs || {});
  this.reset();
}
_.extend(Turo.prototype, {

  reset: function () {
    this.variables = new Variables();
    this.units = new Units();
    this.operators = operatorsTable.createDefaultOperators(this._prefs);
    this.parser = parser;
    delete this._includedFiles;
    this.wordCleaner = require("./preprocessor-word-cleaner").createWithContext(this.variables, this.operators, this.units);
    this.parenBalancer = require("./preprocessor-paren-balancer").createEmpty();
  },

  prefs: function (prefs) {
    if (!prefs) {
      return this._prefs;
    }
    this._prefs = _.defaults(prefs, DEFAULT_PREFS);
    return this._prefs;
  },

  include: (function () {

      var path = require("path"),
          fs = "fs";
      try {
        fs = require(fs);
      } catch (e) {
        fs = undefined;
      }

      var sourceLoader;
      if (!fs || _.isEmpty(fs)) {
        sourceLoader = require("./web-fs");
      } else {
        sourceLoader = require("./node-fs");
      }

      return function include (turoFilename) {

        var self = this,
            filename = sourceLoader.resolve(turoFilename),
            includedFiles = self._includedFiles = self._includedFiles || {},
            beingIncludeFiles = self._beingIncludeFiles = self._beingIncludeFiles || {};

        if (!filename) {
          return;
        }

        var debug = false;
        if (includedFiles[filename] && !debug) {
          return;
        }

        if (beingIncludeFiles[filename]) {
          throw new Error("CYCLE DETECTED", filename);
        }

        beingIncludeFiles[filename] = true;

        sourceLoader.loadSource(filename, function (lines) {
          var result = self.evaluate(lines, "StatementList");
          result._calculateValue();

          if (result.parseError) {
            console.error("Detected problem with " + filename, result.parseError);
            throw result.parseError;
          }

          // TODO emit event that we've parsed a line.
          delete beingIncludeFiles[filename];
          includedFiles[filename] = true;
        });



      };

  }()),

  _cleanWords: function (string) {
    var self = this,
        re, applied = false,
        expressions = [
                      /^(\s*\w+\s*:?=)(.*)$/mg,
                      /^(\s*const\s+\w+\s*:?=)(.*)$/mg,
                      /^(\s*unit\s*[-\d\.]*\s*\w+\s*:.*)$/mg,
                      /^(\s*test\s+"[^"]*")(.*)$/mg,
                      /^(\s*include\s+"[^"]*")(.*)$/mg
                    ],

        cleaner = function (match, prefix, suffix) {
            applied = true;
            if (typeof suffix === 'string') {
              suffix = self.wordCleaner.preprocess(suffix);
              return prefix + suffix;
            } else {
              return prefix;
            }
          },
          i, max = expressions.length;

    for (i=0; i < max; i++) {
      re = expressions[i];
      string = string.replace(re, cleaner);
      if (applied) {
        break;
      }
    }
    if (!applied) {
      string = self.wordCleaner.preprocess(string);
    }
    return string;
  },

  cleanString: function (string) {
    if (this.lenientParser) {
      string = this._cleanWords(string);
    }

    return this.parenBalancer.preprocess(string);
  },

  evaluate: function (string, parseRule, id)  {
    var originalInput, result;
    if (string === undefined) {
      string = "0";
    }
    originalInput = string;
    if (!parseRule) {
      string = this.cleanString(string);
    }
    parser.turo = this;
    parser.inputLength = originalInput.length;
    
    var self = this,
        ast;

    try {
      ast = parser.parse(string, parseRule || "Statement");

      ast.id = id;
      result = new Result(this, ast);
      ast.parsedLine = string;
      ast.lineLiteral = originalInput;

      if (this.lenientParser) {
        self.wordCleaner.rebuild();
      }
    } catch (e) {
      result = new Result(this);
      result.parseError = e;
    }

    result.id = id;
    result.addedParens = (string.length - originalInput.length);
    result.parsedLine = string;
    return result;
  },

  renameVariable: function (oldName, newName, results) {
    var definition = this.variables.getVariableDefinition(oldName),
        usageFinder = require("./variable-usage-finder");

    if (!definition) {
      return true;
    }

    if (this.variables.getVariableDefinition(newName)) {
      // there is already a variable called new name
      return false;
    }

    var nodes;

    if (definition.dependentExpressions) {
      nodes = _.values(definition.dependentExpressions);
    } else if (results) {
      nodes = _.map(results, function (r) {
        return r.expression();
      });
    }
    var identifierNodes = usageFinder.collect(nodes)[oldName];

    _.each(identifierNodes, function (node) {
      node.name = newName;
    });

    this.variables.renameVariable(oldName, newName);

    return true;
  },

  removeVariable: function (identifier) {
    // TODO mark the consequents as being in error.
    this.variables.remove(identifier);
  },

  setWriter: function (writer) {
    this.writer = writer;
  },

  getTokenPredictor: function () {
    var self = this,
        ac = require("./autocomplete");

    if (!self._tokenPredictor) {
      self._tokenPredictor = new ac.TokenPredictor(this.parser, {
        digits: true,
        point: true,
        exponent: true,
        plusMinus: true,
        multiplyDivide: true,
        parensOpen: true,
        parensClose: true,

        variable: function () {
          return self.variables;
        },
        unit: function () {
          return self.units.unitSchemes;
        },
        unitPer: true,
        unitPower: true,
        unitIn: true,
        infixOp: function () {
          return self.operators;
        },
        postfixOp: function () {
          return self.operators;
        },
        prefixOp: function () {
          return self.operators;
        }
      });
    }

    return self._tokenPredictor;
  }

});


module.exports = _.extend(new Turo(), {
  Turo: Turo,
  Error: AST.Error,
  toSource: output,
});

},{"../lib/parser":37,"./ast":29,"./autocomplete":30,"./evaluator":31,"./node-fs":32,"./operators-symbol-table":35,"./precision-hacks":38,"./preprocessor-paren-balancer":39,"./preprocessor-word-cleaner":40,"./statement-reevaluator":41,"./to-source":42,"./units-table":45,"./variable-usage-finder":46,"./variables-symbol-table":47,"./web-fs":48,"path":24,"underscore":50}],44:[function(require,module,exports){
"use strict";

var _ = require("underscore");

function UnitSchemeHelper () {
  this._table = {};
  this._noScheme = {};

  this._dimensionTable = {};
}

_.extend(UnitSchemeHelper.prototype, {

  addUnit: function (unit, additionalSchemes) {
    var self = this,
        unitSchemes = additionalSchemes || unit.getUnitSchemes();

    // e.g.
    // include "fundamental"
    // unit m (Scientific)

    var dimension = unit.getDimension(),
        dimensionName = dimension.shortName;

    if (dimensionName) {
      this._dimensionTable[dimensionName] = dimension;
    } else {
      var allDimensions = _.values(this._dimensionTable);
      for (var i=0, max=allDimensions.length; i<max; i++) {
        var d = allDimensions[i];
        if (d.isEqual(dimension)) {
          unit._dimension = d;
          break;
        }
      }
    }

    if (unitSchemes && unitSchemes.length) {
      _.each(unitSchemes, function (unitScheme) {
        var table = self._table[unitScheme] ||
                    (self._table[unitScheme] = {});
        self._addUnitToScheme(table, unit);
      });
    } else {
      self._addUnitToScheme(self._noScheme, unit);
    }

  },

  _addUnitToScheme: function (table, unit) {
    var dimension = unit.getDimension(),
        dimensionName = dimension.shortName,
        units;

    if (dimensionName) {
      units = table[dimensionName] ||
              (table[dimensionName] = []);
      units.push(unit);
    } else {
      console.log("WARN: " + unit.name + " isn't included in the keyboard: it has no named dimension");
    }

    delete this._keyboardCache;
  },

  getUnitSchemes: function () {

    if (!this._keyboardCache) {
      this._keyboardCache = {};
    }
    if (!this._keyboardCache.unitSchemes) {
      this._keyboardCache.unitSchemes = _.keys(this._table);
    }
    return this._keyboardCache.unitSchemes;
  },

  getDimensions: function (unitScheme) {
    var self = this;
    if (!this._keyboardCache) {
      this._keyboardCache = {};
    }
    var table = this._keyboardCache.unitSchemeDimensions;
    if (!table) {
      this._keyboardCache.unitSchemeDimensions = table = {};
    }
    if (!table[unitScheme]) {
      var dimensionNames = _.union(_.keys(this._table[unitScheme]), _.keys(this._noScheme));
      dimensionNames = _.sortBy(dimensionNames, function (dimensionName) {
        return self._dimensionTable[dimensionName].cardinality();
      });
      table[unitScheme] = dimensionNames;
    }
    return table[unitScheme];
  },

  getUnitNames: function (unitScheme, dimension) {
    if (!unitScheme) {
      return _.pluck(this._noScheme[dimension], "name");
    }

    if (!this._keyboardCache) {
      this._keyboardCache = {};
    }

    var table = this._keyboardCache.schemeDimensionUnitNames;
    if (!table) {
      this._keyboardCache.schemeDimensionUnitNames = table = {};
    }

    if (!table[unitScheme]) {
      table[unitScheme] = {};
    }

    table = table[unitScheme];
    if (!table[dimension]) {
      var units = (this._table[unitScheme] && this._table[unitScheme][dimension]);

      units = units || this._noScheme[dimension] || [];

      table[dimension] = _.pluck(units, "name");
    }

    return table[dimension];
  },

  findClosestUnit: function (srcUnit, unitScheme, dimensionName) {


    var abs = function (n) {
      return n > 0 ? n : -n;
    };

    this.getUnitNames(unitScheme, dimensionName);

    var closestUnit = srcUnit,
        closestDistanceToOne = 9999999,
        table = this._table[unitScheme][dimensionName],
        srcUnitName = srcUnit.name;

    _.each(table, function (unit) {
      var conv = unit._simpleUnitConverter(srcUnitName),
          distToOne = closestDistanceToOne;
      if (conv) {
        distToOne = abs(conv.value() - 1);
        if (distToOne < closestDistanceToOne) {
          closestDistanceToOne = distToOne;
          closestUnit = unit;
        }
      }
    });

    return closestUnit;
  }

});


module.exports = {
  UnitSchemeHelper: UnitSchemeHelper
};
},{"underscore":50}],45:[function(require,module,exports){
"use strict";
var _ = require("underscore");

/**
 * A series of objects that will build up to units
 */

function Dimension (initial) {
  if (typeof initial === "string") {
    this.dimensions = {};
    this.dimensions[initial] = 1;
    this.shortName = initial;
    this._isSimple = true;
  } else {
    this.dimensions = initial || {};
    this._isSimple = false;
  }
}

_.extend(Dimension.prototype, {
  isEqual: function (that) {
    if (!that.dimensions) {
      return;
    }

    return this._minimalContains(that) && that._minimalContains(this);
  },

  _minimalContains: function (that) {
    var i = 0,
        keys = _.keys(that.dimensions),
        max = keys.length,
        key, l, r;

    for (; i<max; i++) {
      key = keys[i];
      l = this.dimensions[key];
      r = that.dimensions[key];
      /* jshint bitwise: false */
      if ((l && !r) || (!l && r)) {
        /* jshint bitwise: true */
        return false;
      }
      if (l !== r) {
        return false;
      }
    }
    return true;
  },

  isSimple: function () {
    return this._isSimple;
    //return _.foldl(_.values(this.dimensions), function (l,r) { return l + r; }, 0) === 1;
  },

  contains: function (that) {
    var i = 0,
        keys = _.keys(that.dimensions),
        max = keys.length,
        key, thatCardinality, thisCardinality;

    for (; i<max; i++) {
      key = keys[i];
      thatCardinality = that.dimensions[key];
      thisCardinality = this.dimensions[key] || 0;
      if (thisCardinality > 0 && thatCardinality > 0) {
        if (thatCardinality > thisCardinality) {
          return false;
        }
      } else if (thisCardinality < 0 && thatCardinality < 0) {
        if (thatCardinality < thisCardinality) {
          return false;
        }
      } else {
        return false;
      }
    }
    return true;
  },

  cardinality: function () {
    return this.isSimple() ? 1 : _.chain(this.dimensions).values().reduce(function (p, q) {
      return p + (q > 0 ? q : -q);
    }, 0).value();
  }
});

// TODO should this include source and destination Unit objects?
function Multiple (top, bottom) {
  this.top = top || 1;
  this.bottom = bottom || 1;
}

_.extend(Multiple.prototype, {
  set: function (t, b) {
    this.top = t || 1;
    this.bottom = b || 1;
  },

  times: function (that) {
    return new Multiple(this.top * that.top, this.bottom * that.bottom);
  },

  _times: function (that) {
    this.top *= that.top;
    this.bottom *= that.bottom;
    return this;
  },

  divide: function (that) {
    return new Multiple(this.top * that.bottom, this.bottom * that.top);
  },

  _divide: function (that) {
    this.top *= that.bottom;
    this.bottom *= that.top;
    return this;
  },

  value: function (x) {
    x = x || 1;
    return x * this.top / this.bottom;
  },

  toString: function () {
    return "[" + this.top + ", " + this.bottom + "]";
  }
});

_.extend(Multiple, {
  container: function (name) {
    var container = {};
    if (_.isString(name)) {
      container[name] = new Multiple();
    }
    return container;
  },

  one: function () {
    return new Multiple(1, 1);
  },

  quantity: function (value) {
    var one = new Multiple();
    one.top = value;
    return one;
  }
});

/**
 * Some untility methods to build Unit
 */

/**
 * Takes:
 * * a list of unitnames,
 * * map of { unitname: dimensionality }
 * * a plan object: {top: [ list of single units ]}
 *
 * e.g. { m: 2, cm: -1 }, empty_plan
 * returns:
 * {
 *    top   : [ m. m ],
 *    bottom: [ cm ]
 * }
 */
function planConversions(map, plan) {
  plan = plan || {
    top: [],
    bottom: []
  };
 _.each(map, function (i, unitName) {
   var dimensionality = map[unitName],
       pI;
   if (dimensionality < 0) {
     for (pI = dimensionality; pI < 0; pI++) {
       plan.bottom.push(unitName);
     }
   } else if (dimensionality > 0) {
     for (pI = 0; pI < dimensionality; pI++) {
       plan.top.push(unitName);
     }
   }
   return plan;
 });
 return plan;
}

/**
 * A combination of simple units, into a single object. e.g. miles per hour. This should be able to
 * provide a conversion to other units of the equivalent dimensionality.
 */
function CompoundUnit (table, constituentUnits, dimension) {
  if (_.isString(constituentUnits)) {
    this.name = constituentUnits;
  } else {
    this.simpleUnits = constituentUnits;
  }
  if (dimension) {
    this._dimension = dimension;
  }
  this.unitsTable = table;
}

_.extend(CompoundUnit.prototype, {
  getDimension: function () {
    if (this._dimension) {
      return this._dimension;
    }
    var self = this,
        dimension = {};

    _.each(self.simpleUnits, function (i, key) {
      var scalar = self.simpleUnits[key],
          unit = self.unitsTable.getUnit(key),
          myDimension = unit.getDimension().dimensions;

      _.each(myDimension, function (j, dimName) {
        var currentValue = dimension[dimName] || 0;
        currentValue += scalar * myDimension[dimName];
        dimension[dimName] = currentValue;
      });
    });
    this._removeZeroDimensions(dimension);
    this._isDimensionless = !!_.isEmpty(dimension);
    this._dimension = new Dimension(dimension);
    return this._dimension;
  },

  // schemes should be mutable.
  // addUnitScheme("imperial")
  // if scheme is currently _mixed, then it should be replaced
  getUnitSchemes: function () {

    if (this._unitSchemes_user) {
      return this._unitSchemes_user;
    }

    if (this._unitSchemes) {
      return this._unitSchemes;
    }


    this._unitSchemes = (function (self) {
      var unitsTable = self.unitsTable,
          myUnitSchemes = [];

      if (self.baseUnit) {
        return self.baseUnit.getUnitSchemes();
      }
      _.each(self.simpleUnits, function (i, key) {
        var unit = unitsTable.getUnit(key),
            unitSchemes;

        if (myUnitSchemes) {
          myUnitSchemes = unit.getUnitSchemes();
        } else {
          // this should allow the same unit with different
          // schemes, e.g. metric and si.
          unitSchemes = unit.getUnitSchemes();

          // units without schemes shouldn't make a difference
          // e.g. km / h => metric
          // case "_mixed":
          // case []: no scheme, e.g. hour
          // case [unitname]
          if (unitSchemes === "_mixed" || myUnitSchemes === "_mixed") {
            myUnitSchemes = "_mixed";
          } else if (_.isEmpty(unitSchemes) || _.isEmpty(myUnitSchemes)) {
            myUnitSchemes = _.isEmpty(unitSchemes) ? myUnitSchemes : unitSchemes;
          } else {
            myUnitSchemes = _.intersection(myUnitSchemes, unitSchemes);
            if (_.isEmpty(myUnitSchemes)) {
              myUnitSchemes = "_mixed";
            }
          }
        }
      });

      var userSchemes = self._unitSchemes_user;
      if (userSchemes) {
        if (myUnitSchemes === "_mixed") {
          myUnitSchemes = userSchemes;
        } else {
          myUnitSchemes = _.union(myUnitSchemes, userSchemes);
        }
      }
      return myUnitSchemes;
    })(this);

    return this._unitSchemes;
  },

  addUnitScheme: function (label) {
    var userSchemes = this._unitSchemes_user;
    if (!userSchemes) {
      userSchemes = this._unitSchemes_user = [ label ];
    } else {
      userSchemes.push(label);
    }
    // we'll blow away the cache this._unitSchemes later.
    // there's no point blowing away just us,
    // because we don't know what else is going to happen.
  },

  isDimensionless: function () {
    if (typeof this._isDimensionless === 'undefined') {
      this.getDimension();
    }
    return this._isDimensionless;
  },

  getSimpleUnits: function () {
    if (this.simpleUnits) {
      return this.simpleUnits;
    } else if (this.name) {
      if (this._simpleUnits) {
        return this._simpleUnits;
      }
      var compound = {};
      compound[this.name] = 1;
      this._simpleUnits = compound;
      return compound;
    }
  },

  matchesDimensions: function (destinationUnit) {
    return this.getDimension().isEqual(destinationUnit.getDimension());
  },

  cardinality: function () {
    if (this._cardinality) {
      return this._cardinality;
    }
    if (this.name) {
      this._cardinality = 1;
    } else if (this.simpleUnits) {
      var u = this.simpleUnits;
      this._cardinality = _.reduce(u, function (memo, i, key) {
        var value = u[key];
        value = value > 0 ? value : -value;
        return memo + value;
      }, 0);
    }
    return this._cardinality;
  },

  refactoredNode: function (quantity, unitScheme, useSimpleUnitsOnly) {
    var candidates = this._reductions(unitScheme, useSimpleUnitsOnly),
        // this is a rubbish algorithhm for choosing which candidate to move to.
        newUnit = candidates[0];

    if (candidates.length === 0) {
      throw new Error("Cannot factor unit into anything sensible");
    }

    if (typeof quantity === 'number') {
      quantity = new Multiple(quantity, 1);
    } else if (!quantity) {
      quantity = Multiple.one();
    }

    var multiplier = this._convert(quantity, newUnit);

    return {
      multiplier: multiplier,
      value: multiplier.value(),
      unit: newUnit
    };
  },

  _reductions: (function () {


    // From a list of units, filter the ones that will be useful to us
    // to factor the reducingUnit.
    function findCompoundUnits (allUnits, reducingUnit, unitScheme) {
      var list = [],
          unitDimension = reducingUnit.getDimension();
      _.each(allUnits, function (i, unitName) {
          var unit = allUnits[unitName],
              dimension = unit.getDimension();
          // only compound ones needed
          if (dimension.cardinality() <= 1) {
            return;
          }
          if (unitDimension.contains(dimension)) {
            // we're only interested in units that can reduce the reducingUnit

            // TODO: consider unit schemes.
            if (!unitScheme || _.indexOf(unit.getUnitSchemes(), unitScheme) >= 0) {
              list.push(unit);
            }

          }
      });

      list = _.sortBy(list, function (unit) {
        return unit.cardinality();
      });

      return list;
    }

    // complete is a unit that is refactored.
    // result is a the result object.
    // Add complete iff it has a lower cardinality (i.e. expresses the dimension in the fewest possible units)
    // that the current best.
    function considerBest (result, complete) {
      var best = result.bestCardinality,
          cardinality = complete.cardinality();

      if (best < cardinality) {
        return;
      } else if (best === cardinality) {
        var i = 0, max = result.matches.length;
        for (; i < max; i++) {
          // check we haven't got a duplicate
          if (result.matches[i].isEqual(complete)) {
            return;
          }
        }
        result.matches.push(complete);
      } else {
        result.bestCardinality = cardinality;
        result.matches = [complete];
      }
    }

    // Translate this compound unit in to the target unitScheme,
    // unit - which is guaranteed to contain only simple named units.
    // unitScheme - the unitScheme passed to the refactoredNode method.
    function translateToUnitScheme (unit, unitScheme) {
      var unitTable = unit.unitsTable,
          unitSchemes = unitTable.unitSchemes,
          simpleUnits = unit.getSimpleUnits(),
          newSimpleUnits = {};
      _.each(simpleUnits, function (i, key) {
        var partUnit = unitTable.getUnit(key),
            dimensionName = partUnit.getDimension().shortName,
            newPartUnit;

        if (!dimensionName) {
          throw new Error("Trying to translate " + partUnit.name + " into " + unitScheme + " but it's not simple");
        }

        newPartUnit = unitSchemes.findClosestUnit(partUnit, unitScheme, dimensionName);

        newSimpleUnits[newPartUnit.name] = simpleUnits[key];

      });

      return new CompoundUnit(unitTable, newSimpleUnits);
    }

    var out = require("./to-source");

    /*
     * reducingUnit - the remaining unit needed to be factored.
     * currentBigUnits - the list of unconsidered named compound units.
     * accumulator - a candidate result unit. i.e. reducingUnit * accumulator = paritally factored initial reducingUnit
     * test - the named compound unit we have just tested to see if it is contained in the reducing unit.
     * result - the list of complete accumulator units.
     */
    function findReductions (reducingUnit, currentBigUnits, unitScheme, accumulator, test, result) {
      result = result || {
        bestCardinality: 9999999,
        matches: []
      };

      accumulator = accumulator || new CompoundUnit(reducingUnit.unitsTable, {});

      // we should assume that reducing unit is simple;

      if (test) {
        // if test completely matches reducing unit, then our job is done.
        if (test.matchesDimensions(reducingUnit)) {
          // We have constructed an accumulator out of named compound units only.
          considerBest(result, accumulator.by(test));
          return result;
        }

        if (!reducingUnit.getDimension().contains(test.getDimension())) {
          // We can't reduce the unit with the test unit, so
          // remove it from the pool.
          currentBigUnits = _.reject(currentBigUnits, function (un) {
            return un === test;
          });
        } else {
          // We can reduce the unit with the test unit, so replace the
          // accumulator with a new one.
          accumulator = accumulator.by(test);

          // this is how many units we've accumulated already (the 1 is test)
          var currentCardinality = accumulator.cardinality();

          // If we gave up now, our cardinality would be be
          // increased by the total dimension cardinality of what's left.
          // maximumCardinality = currentCardinality + (reducingUnit.getDimension().cardinality() - test.getDimension().cardinality());

          // optimisation, though it's unlikely to do anything in all but
          // the most complicated units.
          if (currentCardinality > result.bestCardinality) {
            return result;
          }

          // TODO how can this be made less heavy weight?
          reducingUnit = reducingUnit.per(test)._simplifiedNode().unit;

          // maximumCardinality is not very useful, but we can calculate it here as:
          // maximumCardinality = currentCardinality + reducingUnit.getDimension().cardinality();
        }
      }


      // We've run out of named compound units to test.
      // We only have named simple units left.
      if (currentBigUnits.length === 0) {
        // Translate the remaining simple units into unit scheme
        // appropriate units.
        if (unitScheme) {
          reducingUnit = translateToUnitScheme(reducingUnit, unitScheme);
        }
        considerBest(result, accumulator.by(reducingUnit));
        return result;
      }


      _.each(currentBigUnits, function (next) {
        // recurse if we haven't seen this before, except if we've just looked at it.
        if (test === next || !accumulator.simpleUnits[next.name]) {
          findReductions(reducingUnit, currentBigUnits, unitScheme, accumulator, next, result);
        }

      });

      return result;
    }


    return function _reductions (unitScheme, simpleUnitsOnly) {
      var simplified = this.simplify(),
          list,
          reduced;

      if (simpleUnitsOnly) {
        list = [];
      } else {
        list = findCompoundUnits(this.unitsTable.units, simplified.unit, unitScheme);
      }

      if (list.length) {
        reduced = findReductions(simplified.unit, list, unitScheme);
        return reduced.matches.length ? reduced.matches : [this];
      } else {
        if (unitScheme) {
          return [translateToUnitScheme(simplified.unit, unitScheme)];
        } else {
          return [this];
        }
      }
    };
  })(),

  _convertSimpleUnit: function (quantity, destinationUnit) {
    if (this.multiples && destinationUnit.name) {
      var mult = this._simpleUnitConverter(destinationUnit.name);
      return quantity._times(mult);
    } else {
      throw new Error("Cannot convert from " + this.name + " to " + destinationUnit.name);
    }
  },

  _simpleUnitConverter: function (destinationUnitName) {
    return this.multiples[destinationUnitName];
  },

  convert: function (quantity, destinationUnit) {
    return this._convert(Multiple.quantity(quantity), destinationUnit).value();
  },

  _convert: function (quantity, destinationUnit) {
    var self = this,
        mult;
    if (_.isString(destinationUnit)) {
      destinationUnit = this.unitsTable.getUnit(destinationUnit);
    }
    if (!this.matchesDimensions(destinationUnit)) {
      throw new Error("CANNOT CONVERT - DIMENSION MISMATCH");
    }

    if (this === destinationUnit) {
      return quantity;
    }

    // TODO javascript numbers

    // check if this is a named unit.
    if (this.multiples && destinationUnit.multiples) {
      mult = this._simpleUnitConverter(destinationUnit.name);
      // Bug fix: litre => gallon. (litre and gallon are defined in terms of different units)
      // Better fix: calculate new ratio, then add & cross fertilize multiples so we don't have to go the long way round
      // next time.
      if (mult) {
        return quantity._times(mult);
      }
    }

    // first we need to get a map of { dimensionName: { unitName: dimensionInt }}
    // this will help us make a list of conversions, on a dimension by dimension basis.
    var srcNode = this._convertToDimensionDimensionalityMap(),
        dstNode = destinationUnit._convertToDimensionDimensionalityMap();

    var srcDimensionalityMap = srcNode.map,
        dstDimensionalityMap = dstNode.map;

    // 1 kg / month * year in kg
    // 1 kg / month in kg/year
    function balancePlans (srcPlan, destPlan) {
      if (srcPlan.top.length && srcPlan.bottom.length) {
        destPlan.top.push(srcPlan.bottom);
        srcPlan.bottom = [];
      }
      if (destPlan.top.length && destPlan.bottom.length) {
        srcPlan.top.push(destPlan.bottom);
        destPlan.bottom = [];
      }
    }

    // for each dimension, make a list of pairs of simple units to convert between.
    // top and bottoms are used to reduced the error that we'll be introducing from crappy
    // arithmetic.
    // km/h/s => m/s^2
    // src: { top: [km], bottom: [h, s] },
    // dst: { top: [m],  bottom: [s, s] },
    var srcPlan = {top: [], bottom: []},
        dstPlan = {top: [], bottom: []};

    _.each(srcDimensionalityMap, function (i, dimensionName) {
      var srcUnitMap = srcDimensionalityMap[dimensionName],
          dstUnitMap = dstDimensionalityMap[dimensionName];


      var _srcPlan = {top: [], bottom: []},
          _dstPlan = {top: [], bottom: []};


      planConversions(srcUnitMap, _srcPlan);
      planConversions(dstUnitMap, _dstPlan);

      balancePlans(_srcPlan, _dstPlan);

      // XXX horrible conversion between a single pair of conversion plans and multiple ones
      srcPlan.top.push(_srcPlan.top);
      srcPlan.bottom.push(_srcPlan.bottom);
      dstPlan.top.push(_dstPlan.top);
      dstPlan.bottom.push(_dstPlan.bottom);
    });


    function simpleConversion (product, srcList, dstList) {
      // we're going to make the assumption that all units in the same dimension are
      // in the same direction (i.e. all +ve or all -ve);
      // The by product of this assumption is that we can assume that srcList and destList
      // are same length;
      srcList = _.flatten(srcList);
      dstList = _.flatten(dstList);
      if (srcList.length !== dstList.length) {
        throw new Error("UNEXPECTED_UNIT_CONVERSION_PROBLEMS");
      }
      // TODO javascript numbers used here.
      for (var j=0, max=srcList.length; j<max; j++) {
        if (srcList[j] !== dstList[j]) {
          var srcUnit = self.unitsTable.getUnit(srcList[j]),
              dstUnit = self.unitsTable.getUnit(dstList[j]);
          product = srcUnit._convertSimpleUnit(product, dstUnit);
        }
      }
      return product;
    }

    var product = simpleConversion(quantity, srcPlan.top, dstPlan.top).
                  divide(simpleConversion(Multiple.one(), srcPlan.bottom, dstPlan.bottom));

    // TODO this is a javascript number.
    var result = product.
            _times(srcNode.multiplier).
            _divide(dstNode.multiplier);
    return result;
  },

  /**
   * Unpacks a unit into its simplest constituent parts, and buckets them into
   * dimensions.
   *
   * Part of the conversion is to lookup unit statements such as
   *  unit kph : 1000 km/h
   *
   * The `1000` is collected in the return value's (aka the node's) `multiple`
   * property.
   *
   * return {
   *  map: { length: {mi: 1}, time: { s: -1, h: -1 } }
   *  multiplier: Multiple
   *  simplified: {}
   * }
   *
   * Simple example of map:
   *
   *   m^3 s^2 => { length: { m: 3 }, time: { s: 2 }};
   *
   * Will recursively discover dimensions from compound units:
   *
   *   mph/s => { length: {mi: 1}, time: { s: -1, h: -1 } }
   *
   *
   * `simplified`: gives the maximal expansion of units, with the union
   * of single dimension units in this unit, and the expansion of base units.
   *
   *    mph/s => { mi: 1, h: -1, h: -1 }
   */
  _convertToDimensionDimensionalityMap: function (node, dimensionMultiplier) {
    var currentMap, multiplier;

    node = node || {
      map: {},
      // TODO javascript number is used.
      multiplier: new Multiple(),
      simplified: {},
      namedCompoundUnits: []
    };

    currentMap = node.map;
    dimensionMultiplier = dimensionMultiplier || 1;
    multiplier = node.multiplier;

    var self = this,
        dimensionObj = self.getDimension(),
        dimensions = dimensionObj.dimensions,
        simpleUnits;

    if (dimensionObj.isSimple() && self.name) {
      // not sure if we need to check self.name;
      var dimension = dimensionObj.shortName;

      var currentUnitMap = currentMap[dimension] || (currentMap[dimension] = {}),
          currentValue = currentUnitMap[self.name] || 0,
          // We are using a javascript number here.
          // TODO check assumption we never actually do the calculation here.
          // TODO consider complex number dimensions / javascript number
          newValue = currentValue + dimensions[dimension] * dimensionMultiplier;

      currentUnitMap[self.name] = newValue;
      node.simplified[self.name] = newValue;
      return node;
    }

    if (self.baseUnit) {
      node.namedCompoundUnits.push(self.name);
      node.multiplier = node.multiplier._times(self.baseMultiple);
      return self.baseUnit._convertToDimensionDimensionalityMap(node, dimensionMultiplier);
    }

    simpleUnits = self.getSimpleUnits();


    _.each(self.simpleUnits, function (i, unitName) {
      var dimensionality = simpleUnits[unitName],
          subUnit = self.unitsTable.getUnit(unitName);

      subUnit._convertToDimensionDimensionalityMap(node, dimensionality * dimensionMultiplier);
    });
    return node;
  },

  isEqual: function (other) {
    return _.isEqual(this.getSimpleUnits(), other.getSimpleUnits());
  },

  // TODO rename to simplified
  // This will take an arbitrarily complicate unit and return a
  // minimal compount unit composed soley
  // of simple units.
  // Units of the same dimension are canceled out and normalized
  // e.g. kg / month * year => kg
  // Where units are mixed, the one used most is used.
  // m * m * km => m^3
  // Compound units are replace with their base units
  // kph / s => km/h s => km/s^2
  // N h / cm^2 => kg m/s^2 * h / cm^2 => kg / s cm^2
  // A multiple is also provided to translate the old unit into the new unit.
  simplify: function () {

    // TODO guard that this is not a simple unit.
    var node = this._simplifiedNode();
    node.value = node.multiplier.value();
    return node;
  },

  _simplifiedNode: function () {
    var self = this,
        multiplier = Multiple.one(),
        unit,
        myUnits;

    var dimensionalityNode = self._convertToDimensionDimensionalityMap(),
        dim2Unit = dimensionalityNode.map;


    // TODO options:
    // "scheme": "metric", "imperial", "si", "user"
    //  tons / (km km m) =>
    //    imperial: tons mi^-3
    //    metric: tonnes km^-3
    //    si: kg m^-3
    //    user: tons km^-3
    // compound: true, // should try and use compound named units.
    //  tons / (km km m) =>
    //    imperial: tons lt-1
    //
    if (!_.isEmpty(dimensionalityNode.namedCompoundUnits)) {
      myUnits = dimensionalityNode.simplified;
    } else {
      // we'll fill this in as we make changes.
      // myUnits = _.clone(this.getSimpleUnits());
    }

    // for each dimension...
    _.each(dim2Unit, function (i, dimension) {
      var unitMap = dim2Unit[dimension],

          // we make a list of things that need to be converted
          plan = planConversions(unitMap),
          // year^2 / month => { top: ["year", "year"], bottom: ["month"] }
          remainingList, direction;


      var increment = function increment (key, num) {
        function inc (map) {
          if (map[key]) {
            if (!(map[key] += num)) {
              delete map[key];
            }
          } else {
            map[key] = num;
          }
        }

        inc(myUnits);
        inc(unitMap);
      };

      // check if we need to cancel anything out.
      // i.e. if we have both a top and a bottom part of the plan.
      if (!_.isEmpty(plan.top) && !_.isEmpty(plan.bottom)) {
        var removalList;
        if (plan.top.length >= plan.bottom.length) {
          removalList = plan.bottom;
          remainingList = plan.top;
          direction = +1;
        } else {
          removalList = plan.top;
          remainingList = plan.bottom;
          direction = -1;
        }

        // the list with the smallest number of dimensions should be eradicated.
        // { top: [ year, year ], bottom: [ month ]}
        // removalList = [ month ]

        // myUnits will end up as the units we return.
        myUnits = myUnits || dimensionalityNode.simplified;


        // Now we have: the list of units we need to elminate.
        // we can pair off with units on the other side.
        _.each(removalList, function (removable) {

          var cancelable = remainingList.shift();

          // { year: 2, month: -1 } => { year: 1 }
          increment(removable, direction);
          increment(cancelable, -direction);

          //console.error("\t" + cancelable +  " / " + removable);

          // now calculate the multipler
          cancelable = self.unitsTable.getUnit(cancelable);
          removable = self.unitsTable.getUnit(removable);

          // cancelable = year
          // removable = month
          if (direction > 0) {
            multiplier = cancelable._convertSimpleUnit(multiplier, removable);
          } else {
            multiplier = removable._convertSimpleUnit(multiplier, cancelable);
          }
          //console.error("\t = " + multiplier);
        });
        removalList.length = 0;
      }


      function magnitude(u){
        var value = unitMap[u],
            abs = value >= 0 ? value : -value;
        return abs;
      }
      function pickTheNicestOne (u) {
        var value = magnitude(u) * 1024;
        return value + 0;
      }

      if (_.size(unitMap) > 1) {


        var top, topUnit;
        
          // we have the situation where one dimension is represented
          // by multiple units (e.g. m cm), which could be weird.
        top = _.chain(unitMap).keys().max(magnitude).value();
        topUnit = self.unitsTable.getUnit(top);
        
        // it would be really nice if we could make this a cleverer
        // which unit we use to represent each dimension.
        
        // I don't understand this snippet, 
        // and that alarms me a little. See uses for direction.
        // direction = magnitude(top);
        // direction = direction >=0 ? 1 : -1;
        direction = 1;

        // use one if we've got one, but we have one if you need it.
        myUnits = myUnits || dimensionalityNode.simplified;

        _.each(unitMap, function (index, unit) {
          if (unit === top) {
            return;
          }

          var other = self.unitsTable.getUnit(unit),
              unitMag = magnitude(unit);


          // convert each one into the most common
          // 1 m^2 cm^3 => cm^5
          var conversion = other._convert(Multiple.one(), topUnit);

          var i = 0;
          for (; i < unitMag; i++) {
            // TODO a javascript number
            multiplier = multiplier._times(conversion);
          }

          increment(unit, -direction * unitMag);
          increment(top, direction * unitMag);
        });
      }
    });

    // TODO re-factor the new simplified unit, with the baseUnits that
    // we removed above.

    unit = self;
    if (myUnits) {
      unit = new CompoundUnit(this.unitsTable, myUnits);
      // multiplier = self.convert(multiplier, unit);
    } else {
      // No modifications were need:
      // * there were no named compound units
      // * there were no units of the same dimension that needed canceling out.
    }

    // Mutliply by the multiplier from converting named compound units to their base units.
    multiplier = multiplier._times(dimensionalityNode.multiplier);
    return {
      multiplier: multiplier,
      unit: unit
    };
  },

  _removeZeroDimensions: function (object) {
    _.each(object, function (i, key) {
      if (!object[key]) {
        delete object[key];
      }
    });
  },

  by: function (other) {
    // other is a compound unit
    var newCompound = _.clone(other.getSimpleUnits());
    var mySimpleUnits = this.getSimpleUnits();
    _.each(this.getSimpleUnits(), function (i, unitName) {
      newCompound[unitName] = (newCompound[unitName] || 0) + mySimpleUnits[unitName];
    });
    this._removeZeroDimensions(newCompound);
    return new CompoundUnit(this.unitsTable, newCompound);
  },

  per: function (other) {
    var newCompound = _.clone(other.getSimpleUnits());
    _.each(newCompound, function (i, unitName) {
      newCompound[unitName] = -newCompound[unitName];
    });
    var mySimpleUnits = this.getSimpleUnits();
    _.each(mySimpleUnits, function (i, unitName) {
      newCompound[unitName] = (newCompound[unitName] || 0) + mySimpleUnits[unitName];
    });
    this._removeZeroDimensions(newCompound);
    return new CompoundUnit(this.unitsTable, newCompound);
  },

  pow: function (power) {
    if (typeof power !== 'number') {
      throw new Error("UNIT_WITH_NON_NUMERICAL_POWER");
    }
    var newCompound = power ? _.clone(this.getSimpleUnits()) : {};
    _.each(newCompound, function (i, unitName) {
      newCompound[unitName] *= power;
    });
    return new CompoundUnit(this.unitsTable, newCompound);
  },

  accept: function (visitor) {
    return require("./ast").acceptVisitor(this, visitor, visitor.visitUnit, arguments);
  }

});




var UnitSchemeHelper = require("./unit-schemes").UnitSchemeHelper;





/*********************************************
  Units table.
*********************************************/
function isStringOrUnit(obj) {
  return (typeof obj === 'string') ||
         (typeof obj === 'object' &&  obj.unitsTable);
}

function UnitsTable (initial) {
  this.units = initial || {};
  this.unitSchemes = new UnitSchemeHelper();
}
_.extend(UnitsTable.prototype, {

  addUnit: function (name, relativeTo_x, relativeTo_units, unitSchemes, dimensionName) {
    var unit;
    if (_.isString(relativeTo_x) && typeof relativeTo_units === 'undefined') {
      unit = this._addUnitWithDimension(name, relativeTo_x);
    } else if (typeof relativeTo_x === 'number' && typeof isStringOrUnit(relativeTo_units)) {
      unit = this._addUnitRelativeToAnotherUnit(name, relativeTo_x, 1, relativeTo_units);
    } else if (isStringOrUnit(relativeTo_x) && typeof relativeTo_units === 'number') {
      unit = this._addUnitRelativeToAnotherUnit(name, 1, relativeTo_units, relativeTo_x);
    } else if (isStringOrUnit(relativeTo_x) && typeof relativeTo_units === 'undefined') {
      unit = this._addUnitFromExistingUnit(name, relativeTo_x);
    } else {
      throw new Error("UNKNOWN UNIT SYNTAX");
    }

    if (unitSchemes && unitSchemes.length) {
      unit._unitSchemes_user = unitSchemes;
    }

    if (dimensionName) {
      unit.getDimension().shortName = dimensionName;
    }

    this.unitSchemes.addUnit(unit);

    return unit;

  },

  addUnitSchemes: function (unit, schemes) {
    _.each(schemes, function (scheme) {
      unit.addUnitScheme(scheme);
    });
    this.unitSchemes.addUnit(unit, schemes);

  },

  _addUnitWithDimension: function (name, dimension) {
    this.units[name] = new CompoundUnit(this, name, new Dimension(dimension));
    return this.units[name];
  },

  _addUnitRelativeToAnotherUnit: function (name, t, b, other) {
    var self = this;
    if (typeof other === 'string') {
      other = this.getUnit(other);
    }

    var unit = new CompoundUnit(this, name, other.getDimension());

    if (other.name) {
      var src = unit.multiples || (unit.multiples = Multiple.container(name)),
          dst = other.multiples || (other.multiples = Multiple.container(other.name));

      _.each(dst, function (i, k) {
        var target = dst[k];
        src[k] = new Multiple(target.top * t, target.bottom * b);

        // this.multiples[name] || (this.multiples[name] = new Multiple());
        var existingUnit = self.getUnit(k),
            multiple = existingUnit.multiples[name] || (existingUnit.multiples[name] = new Multiple());

        multiple.set(b * target.bottom, t * target.top);

      });
    }

    if (other.baseUnit) {
      unit.baseUnit = other.baseUnit;
      unit.baseMultiple = new Multiple(other.baseMultiple.top * t, other.baseMultiple.bottom * b);
    } else if (!unit.getDimension().isSimple()) {
      unit.baseUnit = other;
      unit.baseMultiple = new Multiple(t, b);
    }

    // Given no other details, we should be able to use this to work out our unit scheme.
    unit._unitSchemes = other.getUnitSchemes();


    this.units[name] = unit;
    return unit;
  },

  _addUnitFromExistingUnit: function (name, unit) {
    unit.name = name;
    this.units[name] = unit;
    return unit;
  },

  createUnitScheme: function (unitSchemeName, units) {
    var self = this;
    _.each(units, function (unit) {
      if (typeof unit === "string") {
        unit = self.units[unit];
      }
      if (unit && unit.addUnitScheme) {
        unit.addUnitScheme(unitSchemeName);
      }
    });

    _.each(self.units, function (i, key) {
      var unit = self.units[key];
      delete unit._unitSchemes;
    });
    // we'll generate it on demand,
    // but destroy the cache if we change anything.
  },

  getUnit: function (name) {
    return this.units[name];
  },

  getUnitNames: function () {
    return _.keys(this.units);
  },

  getDimension: function (name) {
    // TODO this should return the Dimension object.
    return this.getUnit(name).getDimension();
  },

  convert: function (num, src, dest) {
    // TODO this should check for getUnit being falsey.
    var srcUnit = _.isString(src) ? this.getUnit(src) : src,
        dstUnit = _.isString(dest) ? this.getUnit(dest) : dest;
    if (srcUnit && dstUnit) {
      return srcUnit.convert(num, dstUnit);
    }
    console.error("Cannot find " + src + " unit");
    throw new Error("Cannot find " + src + " unit");
  },


});

module.exports = {
  UnitsTable: UnitsTable,
  CompoundUnit: CompoundUnit,

  Dimension: Dimension,
  Multiple: Multiple
};
},{"./ast":29,"./to-source":42,"./unit-schemes":44,"underscore":50}],46:[function(require,module,exports){
"use strict";
var _ = require("underscore"),
    output = require("./to-source");

function VariableUsageVisitor () {
}

_.extend(VariableUsageVisitor.prototype, {

  visitIdentifier: function (node, context, variableMap) {
    var list = variableMap[node.name];
    if (list) {
      list.push(node);
    } else {
      variableMap[node.name] = [node];
    }

  },

  visitVariableDefinition: function (node, context, variableMap) {
    context.variableName = node.identifier;
    return node.ast.accept(this, context, variableMap);
  }
});

function Collector (visitor) {
  this.visitor = visitor;
}

_.extend(Collector.prototype, {
  collect: function (node, variableMap) {
    variableMap = variableMap || {};
    if (node.accept) {
      node.accept(this.visitor, this, variableMap);
    }
    return variableMap;
  },

  /**
   * Add this statement node to all the variable objects in the symbol table
   * that are used to calculate this statement.
   * When any of those variables change value, turo knows to re-evaluate this one.
   */
  distribute: function (node, variableMap, variables) {
    var myVariable = this.variableName,
        myStatement,
        statementKey = myVariable || node.id || "_ " + output.toString(node, " ", false),
        identifiers = _.keys(variableMap);


    // TODO use the same string prefix when cleaning the context.
    if (myVariable) {
      myStatement = variables.getVariableDefinition(myVariable);
    }


    var oldStatementKey = node.statementKey || myVariable;
    if (oldStatementKey && node.involvedVariables) {
      // Delete exisiting statement involvement.
      _.each(node.involvedVariables, function (variableName) {
        var definition = variables.getVariableDefinition(variableName);
        if (definition) {
          // if the definition still exists (rename, or deletion)
          definition.unregisterInterest(statementKey, node);
        }

      });
    }

    node.statementKey = "_" + statementKey;
    node.involvedVariables = identifiers;

    // now, register this expression or variable definition's interest in
    // the variables we have used.
    _.each(identifiers, function (variableName) {
      var definition = variables.getVariableDefinition(variableName);
      definition.registerInterest(statementKey, node);

      // we don't really need the variableMap's
      variableMap[variableName] = true;
    });

    if (myStatement) {
      return myStatement.dependentVariables;
    } else {
      return;
    }

  }
});

var visitor = new VariableUsageVisitor();
module.exports = {
  visitor: visitor, // new ast can be plugged in as and when by extending this,
  collector: new Collector(visitor),
  find: function (node, variables) {
    delete this.collector.variableName;
    return this.collector.distribute(node, this.collector.collect(node), variables);
  },

  collect: function (nodes) {
    var collector = this.collector,
        variableMap = {};

    _.each(nodes, function (node) {
      collector.collect(node, variableMap);
    });
    return variableMap;
  },

  VariableUsageVisitor: VariableUsageVisitor
};
},{"./to-source":42,"underscore":50}],47:[function(require,module,exports){
"use strict";

var _ = require("underscore"),
    acceptVisitor = require("./ast").acceptVisitor;


/**
 * VariableDefinition
 */
function VariableDefinition (identifier, definition, value) {
  if (typeof identifier === 'string') {
    _.extend(this, {
      identifier: identifier,
      // any of these change and we should re calculate.
      involvedVariables: {},
      // if we change, then all of these should be recalculated.
      dependentExpressions: {}
    });
  } else {
    _.extend(this, _.pick(identifier, [
      "identifier",
      "involvedVariables",
      "dependentExpressions"
      ]
    ));
  }


  if (typeof definition === 'string') {
    this.definition = definition;
  } else {
    this.ast = definition;
  }
  this.value = value;
}

VariableDefinition.prototype = {

  setDefinition: function (definition) {
    if (typeof definition === 'string') {
      if (this.definition !== definition) {
        this.definition = definition;
        delete this.ast;
      }
    } else {
      this.ast = definition;
      delete this.definition;
    }
    delete this.unit;
    delete this.valueType;
  },

  setValue: function (newValue) {
    if (this.value + "" === this.definition) {
      this.setDefinition(newValue + "");
    }
    this.value = newValue;
  },

  parse: function (parser) {
    if (!this.ast) {
      this.ast = parser.parse(this.definition);
    }
  },

  evaluate: function (variables, evaluator) {
    // if (typeof this.value !== 'undefined') {
    //   return this.value;
    // }

    // there is a chance that we could be looking at a circularity here.
    if (this._evaluating) {
      throw "Circular definition detected, involving '" + this.identifier + "'";
    }

    this._evaluating = true;
    // this needs to change
    var value = evaluator.evaluate(this.ast, variables);
    if (evaluator.cacheVariableValue) {
      this.lastKnownValue = value;
    }
    this._evaluating = false;
    return value;
  },

  accept: function (visitor) {
    return acceptVisitor(this, visitor, visitor.visitVariableDefinition, arguments, this.ast);
  },

  registerInterest: function (nodeKey, node) {
    this.dependentExpressions[nodeKey] = node;
  },

  unregisterInterest: function (nodeKey, node) {
    delete this.dependentExpressions[nodeKey];
  }

};


/**
 * Variables
 */
function Variables (parser, definitions) {
  this.parser = parser || require("./parser");
  this.definitions = definitions || {};
}

Variables.prototype = {

  add: function (identifier, definitionNode) {
    // this is all because JSHint doesn't like return assignments.
    var definition = this.definitions[identifier];
    definition = new VariableDefinition(definition || identifier, definitionNode);
    this.definitions[identifier] = definition;

    return definition;
  },

  remove: function (identifier) {
    delete this.definitions[identifier];
  },

  clear: function () {
    this.definitions = {};
  },

  getVariableDefinition: function (identifier) {
    return this.definitions[identifier];
  },

  getVariableNames: function () {
    return _.keys(this.definitions);
  },

  evaluateVariable: function (identifier, evaluator) {
    if (!identifier) {
      return this.evaluateAll();
    }

    var definition = this.definitions[identifier];

    if (definition) {
      if (!definition.ast) {
        definition.parse(this.parser);
      }
      return definition.evaluate(this, evaluator);
    }
  },

  evaluateAll: function (evaluator) {
    var self = this,
        results = {};

    _.each(this.definitions, function (i, key) {
      results[key] = self.evaluateVariable(key, evaluator);
    });
    return results;
  },

  renameVariable: function (oldName, newName) {
    var definition = this.definitions[oldName];
    delete this.definitions[oldName];
    this.definitions[newName] = definition;
    definition.identifier = newName;
  },

  accept: function (visitor) {
    return acceptVisitor(this, visitor, visitor.visitVariablesAll, arguments, _.values(this.definitions));
  }
};

module.exports = {
  Variables: Variables,
  VariableDefinition: VariableDefinition,

  // TODO: rename these classes usages elsewhere.
  Context: Variables,
  Statement: VariableDefinition

};
},{"./ast":29,"./parser":37,"underscore":50}],48:[function(require,module,exports){
"use strict";

var _ = require("underscore"),
    fs = require("fs");

var files = {
  // we have to be explicit here, to let brfs pick up the files.
  app: "include \"metric\";\ninclude \"imperial\";\n\ninclude \"design\";\ninclude \"science\";\n\n",
  fundamental: "// Keep all dimensions to a minimal set.\n// Put other units in other files with other unit schemes.\n// Length.\nunit m metre (SI) : Length;\n\n// Mass\nunit kg kilogram (SI) : Mass;\n\n// Time\nunit s second seconds : Time;\n// TODO in order to be included with all unit schemes,\n // but we'd like to filter these in some of them\nunit min minute minutes : 60 s;\nunit h hour : 60 min;\nunit day days : 24 h;\nunit wk week weeks : 7 day;\nunit year years : 365 day;\n\n// TODO Pressure, Force,\n\n// Angle\nunit deg : Angle;\n// unit 2 * pi radians (SI) : 360 deg;\nunit 0.017453292519943295769236907684886127134428718885417254560971 radians (SI) : Angle, deg;\n\n// Constants\nconst pi = 3.141592653589793238462643383279502884197169399375105820974944;\nconst e = 2.7182818284590452353602874713526624977572470936999595;\n\n// speed of light\n// const c = 299792458 m/s;\n\n// earth's gravity\nconst g = 9.80665 m/s^2;",
  metric: "include \"fundamental\";\n\nunit m (Metric);\n\nunit km (Metric) : 1000 m;\n\nunit 100 cm (Metric) : m;\nunit 10 mm : cm;\n\nunit kg (Metric);\nunit 1000 g (Metric) : kg;\nunit tonne (Metric) : 1000 kg;\nunit 1000 mg : g;\n\nunit kph : Speed, 1 km/h;\n\nunit litre liter : Volume, 1000 cm^3;\nunit 1000 ml : litre;\n\nunit ha hectare hectares (Metric) : Area, 10000 m^2;",
  imperial: "include \"fundamental\";\n\n// Length\nunit yd yard yards (Imperial) : 0.9144 m;\nunit 3 ft foot feet : yd;\nunit 12 inch inches : ft;\nunit mile miles : 5280 ft;\n\n// Mass\nunit lb (Imperial) : 0.45359237 kg;\nunit st stone : 14 lb;\nunit hdwt hundredweight : 112 lb;\nunit ton : 2240 lb;\nunit 16 oz ounce : lb;\n\n// Area\nunit acre (Imperial) : Area, 43560 ft^2;\n\n// Volume\nunit gallon (Imperial) : Volume, 0.00454609 m^3;\nunit 8 pint pints : gallon;\nunit 20 fl_oz floz : pint;\n\n// Speed\nunit mph (Imperial) : Speed, 1 mile/h;\n\ninclude \"science\";\n\nunit cal (Imperial) : 4.184 J;\nunit kcal : 1000 cal;\n",
  design: "// design.turo\n\ninclude \"imperial\";\n\n// it would be great if we tag operators and variables:\n// http://bjango.com/articles/soulver/\n\n\n// from http://static.zealous-studios.co.uk/projects/web_tests/PPI%20tests.html\nunit 72 pt (Design) : inch;\nunit pc picas : 12pt;\n\n// This is not the dimension of a physical pixel.\nunit px (Design) : 0.75 pt;\n\nconst phi = (1 + sqrt 5) / 2;",
  science: "unit N newtons (Science) : Force, 1 kg m/s^2;\n\nunit Pa pascals (Science) : Pressure, 1 N/m^2;\n\nunit J joules (Science) : Energy, 1 N m;\n\nunit W Watt (Science) : Power, 1 J/s;\nunit MW megawatt : 1e6 W;\nunit kW kilowatt : 1e3 W;\n\nunit A amp (Science) : Current;\nunit C coloumb (Science) : Charge, 1 A s;\n",
  maritime: "include \"fundamental\";\n\n// Nautical mile\n// https://en.wikipedia.org/wiki/Nautical_mile\nunit nmi NM (Maritime) : 1852m;\n\n// https://en.wikipedia.org/wiki/Fathom\n// Strictly, 2 yd, but the above link defines it exactly in m.\n// Let's not include \"imperial\" here.\nunit fathom (Maritime) : 1.8288 m;\nunit knots kts (Maritime) : 1 nmi/h;\n",
};

module.exports = {
  resolve: function (filename) {
    return filename;
  },

  loadSource: function (filename, evaluate) {
    evaluate(files[filename]);
  }
};

},{"fs":21,"underscore":50}],49:[function(require,module,exports){
/**
 * A simple dependency graph
 */
var _ = require('underscore');

/**
 * Helper for creating a Depth-First-Search on
 * a set of edges.
 *
 * Detects cycles and throws an Error if one is detected
 *
 * @param edges The set of edges to DFS through
 * @param leavesOnly Whether to only return "leaf" nodes (ones who have no edges)
 * @param result An array in which the results will be populated
 */
function createDFS(edges, leavesOnly, result) {
  var chain = {};
  var visited = {};
  return function DFS(name) {
    visited[name] = true;
    chain[name] = true;
    edges[name].forEach(function (edgeName) {
      if (!visited[edgeName]) {
        DFS(edgeName);
      } else if (chain[edgeName]) {
        throw new Error('Dependency Cycle Found: ' + edgeName);
      }
    });
    chain[name] = false;
    if ((!leavesOnly || edges[name].length === 0) && result.indexOf(name) === -1) {
      result.push(name);
    }
  };
}

/**
 * Simple Dependency Graph
 */
var DepGraph = exports.DepGraph = function DepGraph() {
  this.nodes = {};
  this.outgoingEdges = {}; // Node name -> [Dependency Node name]
  this.incomingEdges = {}; // Node name -> [Dependant Node name]
};
DepGraph.prototype = {
  addNode:function (name) {
    this.nodes[name] = name;
    this.outgoingEdges[name] = [];
    this.incomingEdges[name] = [];
  },
  removeNode:function (name) {
    delete this.nodes[name];
    delete this.outgoingEdges[name];
    delete this.incomingEdges[name];
    _.each(this.incomingEdges, function (edges) {
      var idx = edges.indexOf(name);
      if (idx >= 0) {
        edges.splice(idx, 1);
      }
    });
  },
  hasNode:function (name) {
    return !!this.nodes[name];
  },
  addDependency:function (from, to) {
    if (this.hasNode(from) && this.hasNode(to)) {
      if (this.outgoingEdges[from].indexOf(to) === -1) {
        this.outgoingEdges[from].push(to);
      }
      if (this.incomingEdges[to].indexOf(from) === -1) {
        this.incomingEdges[to].push(from);
      }
      return true;
    } else {
      throw new Error('One of the nodes does not exist: ' + from + ', ' + to);
    }
  },
  removeDependency:function (from, to) {
    var idx = this.outgoingEdges[from].indexOf(to);
    if (idx >= 0) {
      this.outgoingEdges[from].splice(idx, 1);
    }
    idx = this.incomingEdges[to].indexOf(from);
    if (idx >= 0) {
      this.incomingEdges[to].splice(idx, 1);
    }
  },
  dependenciesOf:function (name, leavesOnly) {
    if (this.nodes[name]) {
      var result = [];
      var DFS = createDFS(this.outgoingEdges, leavesOnly, result);
      DFS(name);
      var idx = result.indexOf(name);
      if (idx >= 0) {
        result.splice(idx, 1);
      }
      return result;
    }
    else {
      throw new Error('Node does not exist: ' + name);
    }
  },
  dependantsOf:function (name, leavesOnly) {
    if (this.nodes[name]) {
      var result = [];
      var DFS = createDFS(this.incomingEdges, leavesOnly, result);
      DFS(name);
      var idx = result.indexOf(name);
      if (idx >= 0) {
        result.splice(idx, 1);
      }
      return result;
    } else {
      throw new Error('Node does not exist: ' + name);
    }
  },
  overallOrder:function (leavesOnly) {
    var self = this;
    var result = [];
    var DFS = createDFS(this.outgoingEdges, leavesOnly, result);
    _.each(_.filter(_.keys(this.nodes), function (node) {
      return self.incomingEdges[node].length === 0;
    }), function (n) {
      DFS(n);
    });
    if (_.size(this.nodes) > 0 && result.length === 0) {
      // Special case when there are no nodes with no dependants
      throw new Error('Dependency Cycle Found');
    }
    return result;
  }
};
},{"underscore":50}],50:[function(require,module,exports){
//     Underscore.js 1.4.4
//     http://underscorejs.org
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud Inc.
//     Underscore may be freely distributed under the MIT license.

(function() {

  // Baseline setup
  // --------------

  // Establish the root object, `window` in the browser, or `global` on the server.
  var root = this;

  // Save the previous value of the `_` variable.
  var previousUnderscore = root._;

  // Establish the object that gets returned to break out of a loop iteration.
  var breaker = {};

  // Save bytes in the minified (but not gzipped) version:
  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;

  // Create quick reference variables for speed access to core prototypes.
  var push             = ArrayProto.push,
      slice            = ArrayProto.slice,
      concat           = ArrayProto.concat,
      toString         = ObjProto.toString,
      hasOwnProperty   = ObjProto.hasOwnProperty;

  // All **ECMAScript 5** native function implementations that we hope to use
  // are declared here.
  var
    nativeForEach      = ArrayProto.forEach,
    nativeMap          = ArrayProto.map,
    nativeReduce       = ArrayProto.reduce,
    nativeReduceRight  = ArrayProto.reduceRight,
    nativeFilter       = ArrayProto.filter,
    nativeEvery        = ArrayProto.every,
    nativeSome         = ArrayProto.some,
    nativeIndexOf      = ArrayProto.indexOf,
    nativeLastIndexOf  = ArrayProto.lastIndexOf,
    nativeIsArray      = Array.isArray,
    nativeKeys         = Object.keys,
    nativeBind         = FuncProto.bind;

  // Create a safe reference to the Underscore object for use below.
  var _ = function(obj) {
    if (obj instanceof _) return obj;
    if (!(this instanceof _)) return new _(obj);
    this._wrapped = obj;
  };

  // Export the Underscore object for **Node.js**, with
  // backwards-compatibility for the old `require()` API. If we're in
  // the browser, add `_` as a global object via a string identifier,
  // for Closure Compiler "advanced" mode.
  if (typeof exports !== 'undefined') {
    if (typeof module !== 'undefined' && module.exports) {
      exports = module.exports = _;
    }
    exports._ = _;
  } else {
    root._ = _;
  }

  // Current version.
  _.VERSION = '1.4.4';

  // Collection Functions
  // --------------------

  // The cornerstone, an `each` implementation, aka `forEach`.
  // Handles objects with the built-in `forEach`, arrays, and raw objects.
  // Delegates to **ECMAScript 5**'s native `forEach` if available.
  var each = _.each = _.forEach = function(obj, iterator, context) {
    if (obj == null) return;
    if (nativeForEach && obj.forEach === nativeForEach) {
      obj.forEach(iterator, context);
    } else if (obj.length === +obj.length) {
      for (var i = 0, l = obj.length; i < l; i++) {
        if (iterator.call(context, obj[i], i, obj) === breaker) return;
      }
    } else {
      for (var key in obj) {
        if (_.has(obj, key)) {
          if (iterator.call(context, obj[key], key, obj) === breaker) return;
        }
      }
    }
  };

  // Return the results of applying the iterator to each element.
  // Delegates to **ECMAScript 5**'s native `map` if available.
  _.map = _.collect = function(obj, iterator, context) {
    var results = [];
    if (obj == null) return results;
    if (nativeMap && obj.map === nativeMap) return obj.map(iterator, context);
    each(obj, function(value, index, list) {
      results[results.length] = iterator.call(context, value, index, list);
    });
    return results;
  };

  var reduceError = 'Reduce of empty array with no initial value';

  // **Reduce** builds up a single result from a list of values, aka `inject`,
  // or `foldl`. Delegates to **ECMAScript 5**'s native `reduce` if available.
  _.reduce = _.foldl = _.inject = function(obj, iterator, memo, context) {
    var initial = arguments.length > 2;
    if (obj == null) obj = [];
    if (nativeReduce && obj.reduce === nativeReduce) {
      if (context) iterator = _.bind(iterator, context);
      return initial ? obj.reduce(iterator, memo) : obj.reduce(iterator);
    }
    each(obj, function(value, index, list) {
      if (!initial) {
        memo = value;
        initial = true;
      } else {
        memo = iterator.call(context, memo, value, index, list);
      }
    });
    if (!initial) throw new TypeError(reduceError);
    return memo;
  };

  // The right-associative version of reduce, also known as `foldr`.
  // Delegates to **ECMAScript 5**'s native `reduceRight` if available.
  _.reduceRight = _.foldr = function(obj, iterator, memo, context) {
    var initial = arguments.length > 2;
    if (obj == null) obj = [];
    if (nativeReduceRight && obj.reduceRight === nativeReduceRight) {
      if (context) iterator = _.bind(iterator, context);
      return initial ? obj.reduceRight(iterator, memo) : obj.reduceRight(iterator);
    }
    var length = obj.length;
    if (length !== +length) {
      var keys = _.keys(obj);
      length = keys.length;
    }
    each(obj, function(value, index, list) {
      index = keys ? keys[--length] : --length;
      if (!initial) {
        memo = obj[index];
        initial = true;
      } else {
        memo = iterator.call(context, memo, obj[index], index, list);
      }
    });
    if (!initial) throw new TypeError(reduceError);
    return memo;
  };

  // Return the first value which passes a truth test. Aliased as `detect`.
  _.find = _.detect = function(obj, iterator, context) {
    var result;
    any(obj, function(value, index, list) {
      if (iterator.call(context, value, index, list)) {
        result = value;
        return true;
      }
    });
    return result;
  };

  // Return all the elements that pass a truth test.
  // Delegates to **ECMAScript 5**'s native `filter` if available.
  // Aliased as `select`.
  _.filter = _.select = function(obj, iterator, context) {
    var results = [];
    if (obj == null) return results;
    if (nativeFilter && obj.filter === nativeFilter) return obj.filter(iterator, context);
    each(obj, function(value, index, list) {
      if (iterator.call(context, value, index, list)) results[results.length] = value;
    });
    return results;
  };

  // Return all the elements for which a truth test fails.
  _.reject = function(obj, iterator, context) {
    return _.filter(obj, function(value, index, list) {
      return !iterator.call(context, value, index, list);
    }, context);
  };

  // Determine whether all of the elements match a truth test.
  // Delegates to **ECMAScript 5**'s native `every` if available.
  // Aliased as `all`.
  _.every = _.all = function(obj, iterator, context) {
    iterator || (iterator = _.identity);
    var result = true;
    if (obj == null) return result;
    if (nativeEvery && obj.every === nativeEvery) return obj.every(iterator, context);
    each(obj, function(value, index, list) {
      if (!(result = result && iterator.call(context, value, index, list))) return breaker;
    });
    return !!result;
  };

  // Determine if at least one element in the object matches a truth test.
  // Delegates to **ECMAScript 5**'s native `some` if available.
  // Aliased as `any`.
  var any = _.some = _.any = function(obj, iterator, context) {
    iterator || (iterator = _.identity);
    var result = false;
    if (obj == null) return result;
    if (nativeSome && obj.some === nativeSome) return obj.some(iterator, context);
    each(obj, function(value, index, list) {
      if (result || (result = iterator.call(context, value, index, list))) return breaker;
    });
    return !!result;
  };

  // Determine if the array or object contains a given value (using `===`).
  // Aliased as `include`.
  _.contains = _.include = function(obj, target) {
    if (obj == null) return false;
    if (nativeIndexOf && obj.indexOf === nativeIndexOf) return obj.indexOf(target) != -1;
    return any(obj, function(value) {
      return value === target;
    });
  };

  // Invoke a method (with arguments) on every item in a collection.
  _.invoke = function(obj, method) {
    var args = slice.call(arguments, 2);
    var isFunc = _.isFunction(method);
    return _.map(obj, function(value) {
      return (isFunc ? method : value[method]).apply(value, args);
    });
  };

  // Convenience version of a common use case of `map`: fetching a property.
  _.pluck = function(obj, key) {
    return _.map(obj, function(value){ return value[key]; });
  };

  // Convenience version of a common use case of `filter`: selecting only objects
  // containing specific `key:value` pairs.
  _.where = function(obj, attrs, first) {
    if (_.isEmpty(attrs)) return first ? null : [];
    return _[first ? 'find' : 'filter'](obj, function(value) {
      for (var key in attrs) {
        if (attrs[key] !== value[key]) return false;
      }
      return true;
    });
  };

  // Convenience version of a common use case of `find`: getting the first object
  // containing specific `key:value` pairs.
  _.findWhere = function(obj, attrs) {
    return _.where(obj, attrs, true);
  };

  // Return the maximum element or (element-based computation).
  // Can't optimize arrays of integers longer than 65,535 elements.
  // See: https://bugs.webkit.org/show_bug.cgi?id=80797
  _.max = function(obj, iterator, context) {
    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
      return Math.max.apply(Math, obj);
    }
    if (!iterator && _.isEmpty(obj)) return -Infinity;
    var result = {computed : -Infinity, value: -Infinity};
    each(obj, function(value, index, list) {
      var computed = iterator ? iterator.call(context, value, index, list) : value;
      computed >= result.computed && (result = {value : value, computed : computed});
    });
    return result.value;
  };

  // Return the minimum element (or element-based computation).
  _.min = function(obj, iterator, context) {
    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
      return Math.min.apply(Math, obj);
    }
    if (!iterator && _.isEmpty(obj)) return Infinity;
    var result = {computed : Infinity, value: Infinity};
    each(obj, function(value, index, list) {
      var computed = iterator ? iterator.call(context, value, index, list) : value;
      computed < result.computed && (result = {value : value, computed : computed});
    });
    return result.value;
  };

  // Shuffle an array.
  _.shuffle = function(obj) {
    var rand;
    var index = 0;
    var shuffled = [];
    each(obj, function(value) {
      rand = _.random(index++);
      shuffled[index - 1] = shuffled[rand];
      shuffled[rand] = value;
    });
    return shuffled;
  };

  // An internal function to generate lookup iterators.
  var lookupIterator = function(value) {
    return _.isFunction(value) ? value : function(obj){ return obj[value]; };
  };

  // Sort the object's values by a criterion produced by an iterator.
  _.sortBy = function(obj, value, context) {
    var iterator = lookupIterator(value);
    return _.pluck(_.map(obj, function(value, index, list) {
      return {
        value : value,
        index : index,
        criteria : iterator.call(context, value, index, list)
      };
    }).sort(function(left, right) {
      var a = left.criteria;
      var b = right.criteria;
      if (a !== b) {
        if (a > b || a === void 0) return 1;
        if (a < b || b === void 0) return -1;
      }
      return left.index < right.index ? -1 : 1;
    }), 'value');
  };

  // An internal function used for aggregate "group by" operations.
  var group = function(obj, value, context, behavior) {
    var result = {};
    var iterator = lookupIterator(value || _.identity);
    each(obj, function(value, index) {
      var key = iterator.call(context, value, index, obj);
      behavior(result, key, value);
    });
    return result;
  };

  // Groups the object's values by a criterion. Pass either a string attribute
  // to group by, or a function that returns the criterion.
  _.groupBy = function(obj, value, context) {
    return group(obj, value, context, function(result, key, value) {
      (_.has(result, key) ? result[key] : (result[key] = [])).push(value);
    });
  };

  // Counts instances of an object that group by a certain criterion. Pass
  // either a string attribute to count by, or a function that returns the
  // criterion.
  _.countBy = function(obj, value, context) {
    return group(obj, value, context, function(result, key) {
      if (!_.has(result, key)) result[key] = 0;
      result[key]++;
    });
  };

  // Use a comparator function to figure out the smallest index at which
  // an object should be inserted so as to maintain order. Uses binary search.
  _.sortedIndex = function(array, obj, iterator, context) {
    iterator = iterator == null ? _.identity : lookupIterator(iterator);
    var value = iterator.call(context, obj);
    var low = 0, high = array.length;
    while (low < high) {
      var mid = (low + high) >>> 1;
      iterator.call(context, array[mid]) < value ? low = mid + 1 : high = mid;
    }
    return low;
  };

  // Safely convert anything iterable into a real, live array.
  _.toArray = function(obj) {
    if (!obj) return [];
    if (_.isArray(obj)) return slice.call(obj);
    if (obj.length === +obj.length) return _.map(obj, _.identity);
    return _.values(obj);
  };

  // Return the number of elements in an object.
  _.size = function(obj) {
    if (obj == null) return 0;
    return (obj.length === +obj.length) ? obj.length : _.keys(obj).length;
  };

  // Array Functions
  // ---------------

  // Get the first element of an array. Passing **n** will return the first N
  // values in the array. Aliased as `head` and `take`. The **guard** check
  // allows it to work with `_.map`.
  _.first = _.head = _.take = function(array, n, guard) {
    if (array == null) return void 0;
    return (n != null) && !guard ? slice.call(array, 0, n) : array[0];
  };

  // Returns everything but the last entry of the array. Especially useful on
  // the arguments object. Passing **n** will return all the values in
  // the array, excluding the last N. The **guard** check allows it to work with
  // `_.map`.
  _.initial = function(array, n, guard) {
    return slice.call(array, 0, array.length - ((n == null) || guard ? 1 : n));
  };

  // Get the last element of an array. Passing **n** will return the last N
  // values in the array. The **guard** check allows it to work with `_.map`.
  _.last = function(array, n, guard) {
    if (array == null) return void 0;
    if ((n != null) && !guard) {
      return slice.call(array, Math.max(array.length - n, 0));
    } else {
      return array[array.length - 1];
    }
  };

  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.
  // Especially useful on the arguments object. Passing an **n** will return
  // the rest N values in the array. The **guard**
  // check allows it to work with `_.map`.
  _.rest = _.tail = _.drop = function(array, n, guard) {
    return slice.call(array, (n == null) || guard ? 1 : n);
  };

  // Trim out all falsy values from an array.
  _.compact = function(array) {
    return _.filter(array, _.identity);
  };

  // Internal implementation of a recursive `flatten` function.
  var flatten = function(input, shallow, output) {
    each(input, function(value) {
      if (_.isArray(value)) {
        shallow ? push.apply(output, value) : flatten(value, shallow, output);
      } else {
        output.push(value);
      }
    });
    return output;
  };

  // Return a completely flattened version of an array.
  _.flatten = function(array, shallow) {
    return flatten(array, shallow, []);
  };

  // Return a version of the array that does not contain the specified value(s).
  _.without = function(array) {
    return _.difference(array, slice.call(arguments, 1));
  };

  // Produce a duplicate-free version of the array. If the array has already
  // been sorted, you have the option of using a faster algorithm.
  // Aliased as `unique`.
  _.uniq = _.unique = function(array, isSorted, iterator, context) {
    if (_.isFunction(isSorted)) {
      context = iterator;
      iterator = isSorted;
      isSorted = false;
    }
    var initial = iterator ? _.map(array, iterator, context) : array;
    var results = [];
    var seen = [];
    each(initial, function(value, index) {
      if (isSorted ? (!index || seen[seen.length - 1] !== value) : !_.contains(seen, value)) {
        seen.push(value);
        results.push(array[index]);
      }
    });
    return results;
  };

  // Produce an array that contains the union: each distinct element from all of
  // the passed-in arrays.
  _.union = function() {
    return _.uniq(concat.apply(ArrayProto, arguments));
  };

  // Produce an array that contains every item shared between all the
  // passed-in arrays.
  _.intersection = function(array) {
    var rest = slice.call(arguments, 1);
    return _.filter(_.uniq(array), function(item) {
      return _.every(rest, function(other) {
        return _.indexOf(other, item) >= 0;
      });
    });
  };

  // Take the difference between one array and a number of other arrays.
  // Only the elements present in just the first array will remain.
  _.difference = function(array) {
    var rest = concat.apply(ArrayProto, slice.call(arguments, 1));
    return _.filter(array, function(value){ return !_.contains(rest, value); });
  };

  // Zip together multiple lists into a single array -- elements that share
  // an index go together.
  _.zip = function() {
    var args = slice.call(arguments);
    var length = _.max(_.pluck(args, 'length'));
    var results = new Array(length);
    for (var i = 0; i < length; i++) {
      results[i] = _.pluck(args, "" + i);
    }
    return results;
  };

  // Converts lists into objects. Pass either a single array of `[key, value]`
  // pairs, or two parallel arrays of the same length -- one of keys, and one of
  // the corresponding values.
  _.object = function(list, values) {
    if (list == null) return {};
    var result = {};
    for (var i = 0, l = list.length; i < l; i++) {
      if (values) {
        result[list[i]] = values[i];
      } else {
        result[list[i][0]] = list[i][1];
      }
    }
    return result;
  };

  // If the browser doesn't supply us with indexOf (I'm looking at you, **MSIE**),
  // we need this function. Return the position of the first occurrence of an
  // item in an array, or -1 if the item is not included in the array.
  // Delegates to **ECMAScript 5**'s native `indexOf` if available.
  // If the array is large and already in sort order, pass `true`
  // for **isSorted** to use binary search.
  _.indexOf = function(array, item, isSorted) {
    if (array == null) return -1;
    var i = 0, l = array.length;
    if (isSorted) {
      if (typeof isSorted == 'number') {
        i = (isSorted < 0 ? Math.max(0, l + isSorted) : isSorted);
      } else {
        i = _.sortedIndex(array, item);
        return array[i] === item ? i : -1;
      }
    }
    if (nativeIndexOf && array.indexOf === nativeIndexOf) return array.indexOf(item, isSorted);
    for (; i < l; i++) if (array[i] === item) return i;
    return -1;
  };

  // Delegates to **ECMAScript 5**'s native `lastIndexOf` if available.
  _.lastIndexOf = function(array, item, from) {
    if (array == null) return -1;
    var hasIndex = from != null;
    if (nativeLastIndexOf && array.lastIndexOf === nativeLastIndexOf) {
      return hasIndex ? array.lastIndexOf(item, from) : array.lastIndexOf(item);
    }
    var i = (hasIndex ? from : array.length);
    while (i--) if (array[i] === item) return i;
    return -1;
  };

  // Generate an integer Array containing an arithmetic progression. A port of
  // the native Python `range()` function. See
  // [the Python documentation](http://docs.python.org/library/functions.html#range).
  _.range = function(start, stop, step) {
    if (arguments.length <= 1) {
      stop = start || 0;
      start = 0;
    }
    step = arguments[2] || 1;

    var len = Math.max(Math.ceil((stop - start) / step), 0);
    var idx = 0;
    var range = new Array(len);

    while(idx < len) {
      range[idx++] = start;
      start += step;
    }

    return range;
  };

  // Function (ahem) Functions
  // ------------------

  // Create a function bound to a given object (assigning `this`, and arguments,
  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if
  // available.
  _.bind = function(func, context) {
    if (func.bind === nativeBind && nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));
    var args = slice.call(arguments, 2);
    return function() {
      return func.apply(context, args.concat(slice.call(arguments)));
    };
  };

  // Partially apply a function by creating a version that has had some of its
  // arguments pre-filled, without changing its dynamic `this` context.
  _.partial = function(func) {
    var args = slice.call(arguments, 1);
    return function() {
      return func.apply(this, args.concat(slice.call(arguments)));
    };
  };

  // Bind all of an object's methods to that object. Useful for ensuring that
  // all callbacks defined on an object belong to it.
  _.bindAll = function(obj) {
    var funcs = slice.call(arguments, 1);
    if (funcs.length === 0) funcs = _.functions(obj);
    each(funcs, function(f) { obj[f] = _.bind(obj[f], obj); });
    return obj;
  };

  // Memoize an expensive function by storing its results.
  _.memoize = function(func, hasher) {
    var memo = {};
    hasher || (hasher = _.identity);
    return function() {
      var key = hasher.apply(this, arguments);
      return _.has(memo, key) ? memo[key] : (memo[key] = func.apply(this, arguments));
    };
  };

  // Delays a function for the given number of milliseconds, and then calls
  // it with the arguments supplied.
  _.delay = function(func, wait) {
    var args = slice.call(arguments, 2);
    return setTimeout(function(){ return func.apply(null, args); }, wait);
  };

  // Defers a function, scheduling it to run after the current call stack has
  // cleared.
  _.defer = function(func) {
    return _.delay.apply(_, [func, 1].concat(slice.call(arguments, 1)));
  };

  // Returns a function, that, when invoked, will only be triggered at most once
  // during a given window of time.
  _.throttle = function(func, wait) {
    var context, args, timeout, result;
    var previous = 0;
    var later = function() {
      previous = new Date;
      timeout = null;
      result = func.apply(context, args);
    };
    return function() {
      var now = new Date;
      var remaining = wait - (now - previous);
      context = this;
      args = arguments;
      if (remaining <= 0) {
        clearTimeout(timeout);
        timeout = null;
        previous = now;
        result = func.apply(context, args);
      } else if (!timeout) {
        timeout = setTimeout(later, remaining);
      }
      return result;
    };
  };

  // Returns a function, that, as long as it continues to be invoked, will not
  // be triggered. The function will be called after it stops being called for
  // N milliseconds. If `immediate` is passed, trigger the function on the
  // leading edge, instead of the trailing.
  _.debounce = function(func, wait, immediate) {
    var timeout, result;
    return function() {
      var context = this, args = arguments;
      var later = function() {
        timeout = null;
        if (!immediate) result = func.apply(context, args);
      };
      var callNow = immediate && !timeout;
      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
      if (callNow) result = func.apply(context, args);
      return result;
    };
  };

  // Returns a function that will be executed at most one time, no matter how
  // often you call it. Useful for lazy initialization.
  _.once = function(func) {
    var ran = false, memo;
    return function() {
      if (ran) return memo;
      ran = true;
      memo = func.apply(this, arguments);
      func = null;
      return memo;
    };
  };

  // Returns the first function passed as an argument to the second,
  // allowing you to adjust arguments, run code before and after, and
  // conditionally execute the original function.
  _.wrap = function(func, wrapper) {
    return function() {
      var args = [func];
      push.apply(args, arguments);
      return wrapper.apply(this, args);
    };
  };

  // Returns a function that is the composition of a list of functions, each
  // consuming the return value of the function that follows.
  _.compose = function() {
    var funcs = arguments;
    return function() {
      var args = arguments;
      for (var i = funcs.length - 1; i >= 0; i--) {
        args = [funcs[i].apply(this, args)];
      }
      return args[0];
    };
  };

  // Returns a function that will only be executed after being called N times.
  _.after = function(times, func) {
    if (times <= 0) return func();
    return function() {
      if (--times < 1) {
        return func.apply(this, arguments);
      }
    };
  };

  // Object Functions
  // ----------------

  // Retrieve the names of an object's properties.
  // Delegates to **ECMAScript 5**'s native `Object.keys`
  _.keys = nativeKeys || function(obj) {
    if (obj !== Object(obj)) throw new TypeError('Invalid object');
    var keys = [];
    for (var key in obj) if (_.has(obj, key)) keys[keys.length] = key;
    return keys;
  };

  // Retrieve the values of an object's properties.
  _.values = function(obj) {
    var values = [];
    for (var key in obj) if (_.has(obj, key)) values.push(obj[key]);
    return values;
  };

  // Convert an object into a list of `[key, value]` pairs.
  _.pairs = function(obj) {
    var pairs = [];
    for (var key in obj) if (_.has(obj, key)) pairs.push([key, obj[key]]);
    return pairs;
  };

  // Invert the keys and values of an object. The values must be serializable.
  _.invert = function(obj) {
    var result = {};
    for (var key in obj) if (_.has(obj, key)) result[obj[key]] = key;
    return result;
  };

  // Return a sorted list of the function names available on the object.
  // Aliased as `methods`
  _.functions = _.methods = function(obj) {
    var names = [];
    for (var key in obj) {
      if (_.isFunction(obj[key])) names.push(key);
    }
    return names.sort();
  };

  // Extend a given object with all the properties in passed-in object(s).
  _.extend = function(obj) {
    each(slice.call(arguments, 1), function(source) {
      if (source) {
        for (var prop in source) {
          obj[prop] = source[prop];
        }
      }
    });
    return obj;
  };

  // Return a copy of the object only containing the whitelisted properties.
  _.pick = function(obj) {
    var copy = {};
    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
    each(keys, function(key) {
      if (key in obj) copy[key] = obj[key];
    });
    return copy;
  };

   // Return a copy of the object without the blacklisted properties.
  _.omit = function(obj) {
    var copy = {};
    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
    for (var key in obj) {
      if (!_.contains(keys, key)) copy[key] = obj[key];
    }
    return copy;
  };

  // Fill in a given object with default properties.
  _.defaults = function(obj) {
    each(slice.call(arguments, 1), function(source) {
      if (source) {
        for (var prop in source) {
          if (obj[prop] == null) obj[prop] = source[prop];
        }
      }
    });
    return obj;
  };

  // Create a (shallow-cloned) duplicate of an object.
  _.clone = function(obj) {
    if (!_.isObject(obj)) return obj;
    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);
  };

  // Invokes interceptor with the obj, and then returns obj.
  // The primary purpose of this method is to "tap into" a method chain, in
  // order to perform operations on intermediate results within the chain.
  _.tap = function(obj, interceptor) {
    interceptor(obj);
    return obj;
  };

  // Internal recursive comparison function for `isEqual`.
  var eq = function(a, b, aStack, bStack) {
    // Identical objects are equal. `0 === -0`, but they aren't identical.
    // See the Harmony `egal` proposal: http://wiki.ecmascript.org/doku.php?id=harmony:egal.
    if (a === b) return a !== 0 || 1 / a == 1 / b;
    // A strict comparison is necessary because `null == undefined`.
    if (a == null || b == null) return a === b;
    // Unwrap any wrapped objects.
    if (a instanceof _) a = a._wrapped;
    if (b instanceof _) b = b._wrapped;
    // Compare `[[Class]]` names.
    var className = toString.call(a);
    if (className != toString.call(b)) return false;
    switch (className) {
      // Strings, numbers, dates, and booleans are compared by value.
      case '[object String]':
        // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
        // equivalent to `new String("5")`.
        return a == String(b);
      case '[object Number]':
        // `NaN`s are equivalent, but non-reflexive. An `egal` comparison is performed for
        // other numeric values.
        return a != +a ? b != +b : (a == 0 ? 1 / a == 1 / b : a == +b);
      case '[object Date]':
      case '[object Boolean]':
        // Coerce dates and booleans to numeric primitive values. Dates are compared by their
        // millisecond representations. Note that invalid dates with millisecond representations
        // of `NaN` are not equivalent.
        return +a == +b;
      // RegExps are compared by their source patterns and flags.
      case '[object RegExp]':
        return a.source == b.source &&
               a.global == b.global &&
               a.multiline == b.multiline &&
               a.ignoreCase == b.ignoreCase;
    }
    if (typeof a != 'object' || typeof b != 'object') return false;
    // Assume equality for cyclic structures. The algorithm for detecting cyclic
    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
    var length = aStack.length;
    while (length--) {
      // Linear search. Performance is inversely proportional to the number of
      // unique nested structures.
      if (aStack[length] == a) return bStack[length] == b;
    }
    // Add the first object to the stack of traversed objects.
    aStack.push(a);
    bStack.push(b);
    var size = 0, result = true;
    // Recursively compare objects and arrays.
    if (className == '[object Array]') {
      // Compare array lengths to determine if a deep comparison is necessary.
      size = a.length;
      result = size == b.length;
      if (result) {
        // Deep compare the contents, ignoring non-numeric properties.
        while (size--) {
          if (!(result = eq(a[size], b[size], aStack, bStack))) break;
        }
      }
    } else {
      // Objects with different constructors are not equivalent, but `Object`s
      // from different frames are.
      var aCtor = a.constructor, bCtor = b.constructor;
      if (aCtor !== bCtor && !(_.isFunction(aCtor) && (aCtor instanceof aCtor) &&
                               _.isFunction(bCtor) && (bCtor instanceof bCtor))) {
        return false;
      }
      // Deep compare objects.
      for (var key in a) {
        if (_.has(a, key)) {
          // Count the expected number of properties.
          size++;
          // Deep compare each member.
          if (!(result = _.has(b, key) && eq(a[key], b[key], aStack, bStack))) break;
        }
      }
      // Ensure that both objects contain the same number of properties.
      if (result) {
        for (key in b) {
          if (_.has(b, key) && !(size--)) break;
        }
        result = !size;
      }
    }
    // Remove the first object from the stack of traversed objects.
    aStack.pop();
    bStack.pop();
    return result;
  };

  // Perform a deep comparison to check if two objects are equal.
  _.isEqual = function(a, b) {
    return eq(a, b, [], []);
  };

  // Is a given array, string, or object empty?
  // An "empty" object has no enumerable own-properties.
  _.isEmpty = function(obj) {
    if (obj == null) return true;
    if (_.isArray(obj) || _.isString(obj)) return obj.length === 0;
    for (var key in obj) if (_.has(obj, key)) return false;
    return true;
  };

  // Is a given value a DOM element?
  _.isElement = function(obj) {
    return !!(obj && obj.nodeType === 1);
  };

  // Is a given value an array?
  // Delegates to ECMA5's native Array.isArray
  _.isArray = nativeIsArray || function(obj) {
    return toString.call(obj) == '[object Array]';
  };

  // Is a given variable an object?
  _.isObject = function(obj) {
    return obj === Object(obj);
  };

  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp.
  each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp'], function(name) {
    _['is' + name] = function(obj) {
      return toString.call(obj) == '[object ' + name + ']';
    };
  });

  // Define a fallback version of the method in browsers (ahem, IE), where
  // there isn't any inspectable "Arguments" type.
  if (!_.isArguments(arguments)) {
    _.isArguments = function(obj) {
      return !!(obj && _.has(obj, 'callee'));
    };
  }

  // Optimize `isFunction` if appropriate.
  if (typeof (/./) !== 'function') {
    _.isFunction = function(obj) {
      return typeof obj === 'function';
    };
  }

  // Is a given object a finite number?
  _.isFinite = function(obj) {
    return isFinite(obj) && !isNaN(parseFloat(obj));
  };

  // Is the given value `NaN`? (NaN is the only number which does not equal itself).
  _.isNaN = function(obj) {
    return _.isNumber(obj) && obj != +obj;
  };

  // Is a given value a boolean?
  _.isBoolean = function(obj) {
    return obj === true || obj === false || toString.call(obj) == '[object Boolean]';
  };

  // Is a given value equal to null?
  _.isNull = function(obj) {
    return obj === null;
  };

  // Is a given variable undefined?
  _.isUndefined = function(obj) {
    return obj === void 0;
  };

  // Shortcut function for checking if an object has a given property directly
  // on itself (in other words, not on a prototype).
  _.has = function(obj, key) {
    return hasOwnProperty.call(obj, key);
  };

  // Utility Functions
  // -----------------

  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its
  // previous owner. Returns a reference to the Underscore object.
  _.noConflict = function() {
    root._ = previousUnderscore;
    return this;
  };

  // Keep the identity function around for default iterators.
  _.identity = function(value) {
    return value;
  };

  // Run a function **n** times.
  _.times = function(n, iterator, context) {
    var accum = Array(n);
    for (var i = 0; i < n; i++) accum[i] = iterator.call(context, i);
    return accum;
  };

  // Return a random integer between min and max (inclusive).
  _.random = function(min, max) {
    if (max == null) {
      max = min;
      min = 0;
    }
    return min + Math.floor(Math.random() * (max - min + 1));
  };

  // List of HTML entities for escaping.
  var entityMap = {
    escape: {
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#x27;',
      '/': '&#x2F;'
    }
  };
  entityMap.unescape = _.invert(entityMap.escape);

  // Regexes containing the keys and values listed immediately above.
  var entityRegexes = {
    escape:   new RegExp('[' + _.keys(entityMap.escape).join('') + ']', 'g'),
    unescape: new RegExp('(' + _.keys(entityMap.unescape).join('|') + ')', 'g')
  };

  // Functions for escaping and unescaping strings to/from HTML interpolation.
  _.each(['escape', 'unescape'], function(method) {
    _[method] = function(string) {
      if (string == null) return '';
      return ('' + string).replace(entityRegexes[method], function(match) {
        return entityMap[method][match];
      });
    };
  });

  // If the value of the named property is a function then invoke it;
  // otherwise, return it.
  _.result = function(object, property) {
    if (object == null) return null;
    var value = object[property];
    return _.isFunction(value) ? value.call(object) : value;
  };

  // Add your own custom functions to the Underscore object.
  _.mixin = function(obj) {
    each(_.functions(obj), function(name){
      var func = _[name] = obj[name];
      _.prototype[name] = function() {
        var args = [this._wrapped];
        push.apply(args, arguments);
        return result.call(this, func.apply(_, args));
      };
    });
  };

  // Generate a unique integer id (unique within the entire client session).
  // Useful for temporary DOM ids.
  var idCounter = 0;
  _.uniqueId = function(prefix) {
    var id = ++idCounter + '';
    return prefix ? prefix + id : id;
  };

  // By default, Underscore uses ERB-style template delimiters, change the
  // following template settings to use alternative delimiters.
  _.templateSettings = {
    evaluate    : /<%([\s\S]+?)%>/g,
    interpolate : /<%=([\s\S]+?)%>/g,
    escape      : /<%-([\s\S]+?)%>/g
  };

  // When customizing `templateSettings`, if you don't want to define an
  // interpolation, evaluation or escaping regex, we need one that is
  // guaranteed not to match.
  var noMatch = /(.)^/;

  // Certain characters need to be escaped so that they can be put into a
  // string literal.
  var escapes = {
    "'":      "'",
    '\\':     '\\',
    '\r':     'r',
    '\n':     'n',
    '\t':     't',
    '\u2028': 'u2028',
    '\u2029': 'u2029'
  };

  var escaper = /\\|'|\r|\n|\t|\u2028|\u2029/g;

  // JavaScript micro-templating, similar to John Resig's implementation.
  // Underscore templating handles arbitrary delimiters, preserves whitespace,
  // and correctly escapes quotes within interpolated code.
  _.template = function(text, data, settings) {
    var render;
    settings = _.defaults({}, settings, _.templateSettings);

    // Combine delimiters into one regular expression via alternation.
    var matcher = new RegExp([
      (settings.escape || noMatch).source,
      (settings.interpolate || noMatch).source,
      (settings.evaluate || noMatch).source
    ].join('|') + '|$', 'g');

    // Compile the template source, escaping string literals appropriately.
    var index = 0;
    var source = "__p+='";
    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {
      source += text.slice(index, offset)
        .replace(escaper, function(match) { return '\\' + escapes[match]; });

      if (escape) {
        source += "'+\n((__t=(" + escape + "))==null?'':_.escape(__t))+\n'";
      }
      if (interpolate) {
        source += "'+\n((__t=(" + interpolate + "))==null?'':__t)+\n'";
      }
      if (evaluate) {
        source += "';\n" + evaluate + "\n__p+='";
      }
      index = offset + match.length;
      return match;
    });
    source += "';\n";

    // If a variable is not specified, place data values in local scope.
    if (!settings.variable) source = 'with(obj||{}){\n' + source + '}\n';

    source = "var __t,__p='',__j=Array.prototype.join," +
      "print=function(){__p+=__j.call(arguments,'');};\n" +
      source + "return __p;\n";

    try {
      render = new Function(settings.variable || 'obj', '_', source);
    } catch (e) {
      e.source = source;
      throw e;
    }

    if (data) return render(data, _);
    var template = function(data) {
      return render.call(this, data, _);
    };

    // Provide the compiled function source as a convenience for precompilation.
    template.source = 'function(' + (settings.variable || 'obj') + '){\n' + source + '}';

    return template;
  };

  // Add a "chain" function, which will delegate to the wrapper.
  _.chain = function(obj) {
    return _(obj).chain();
  };

  // OOP
  // ---------------
  // If Underscore is called as a function, it returns a wrapped object that
  // can be used OO-style. This wrapper holds altered versions of all the
  // underscore functions. Wrapped objects may be chained.

  // Helper function to continue chaining intermediate results.
  var result = function(obj) {
    return this._chain ? _(obj).chain() : obj;
  };

  // Add all of the Underscore functions to the wrapper object.
  _.mixin(_);

  // Add all mutator Array functions to the wrapper.
  each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {
    var method = ArrayProto[name];
    _.prototype[name] = function() {
      var obj = this._wrapped;
      method.apply(obj, arguments);
      if ((name == 'shift' || name == 'splice') && obj.length === 0) delete obj[0];
      return result.call(this, obj);
    };
  });

  // Add all accessor Array functions to the wrapper.
  each(['concat', 'join', 'slice'], function(name) {
    var method = ArrayProto[name];
    _.prototype[name] = function() {
      return result.call(this, method.apply(this._wrapped, arguments));
    };
  });

  _.extend(_.prototype, {

    // Start chaining a wrapped Underscore object.
    chain: function() {
      this._chain = true;
      return this;
    },

    // Extracts the result from a wrapped and chained object.
    value: function() {
      return this._wrapped;
    }

  });

}).call(this);

},{}],51:[function(require,module,exports){
//     Underscore.js 1.5.2
//     http://underscorejs.org
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.

(function() {

  // Baseline setup
  // --------------

  // Establish the root object, `window` in the browser, or `exports` on the server.
  var root = this;

  // Save the previous value of the `_` variable.
  var previousUnderscore = root._;

  // Establish the object that gets returned to break out of a loop iteration.
  var breaker = {};

  // Save bytes in the minified (but not gzipped) version:
  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;

  // Create quick reference variables for speed access to core prototypes.
  var
    push             = ArrayProto.push,
    slice            = ArrayProto.slice,
    concat           = ArrayProto.concat,
    toString         = ObjProto.toString,
    hasOwnProperty   = ObjProto.hasOwnProperty;

  // All **ECMAScript 5** native function implementations that we hope to use
  // are declared here.
  var
    nativeForEach      = ArrayProto.forEach,
    nativeMap          = ArrayProto.map,
    nativeReduce       = ArrayProto.reduce,
    nativeReduceRight  = ArrayProto.reduceRight,
    nativeFilter       = ArrayProto.filter,
    nativeEvery        = ArrayProto.every,
    nativeSome         = ArrayProto.some,
    nativeIndexOf      = ArrayProto.indexOf,
    nativeLastIndexOf  = ArrayProto.lastIndexOf,
    nativeIsArray      = Array.isArray,
    nativeKeys         = Object.keys,
    nativeBind         = FuncProto.bind;

  // Create a safe reference to the Underscore object for use below.
  var _ = function(obj) {
    if (obj instanceof _) return obj;
    if (!(this instanceof _)) return new _(obj);
    this._wrapped = obj;
  };

  // Export the Underscore object for **Node.js**, with
  // backwards-compatibility for the old `require()` API. If we're in
  // the browser, add `_` as a global object via a string identifier,
  // for Closure Compiler "advanced" mode.
  if (typeof exports !== 'undefined') {
    if (typeof module !== 'undefined' && module.exports) {
      exports = module.exports = _;
    }
    exports._ = _;
  } else {
    root._ = _;
  }

  // Current version.
  _.VERSION = '1.5.2';

  // Collection Functions
  // --------------------

  // The cornerstone, an `each` implementation, aka `forEach`.
  // Handles objects with the built-in `forEach`, arrays, and raw objects.
  // Delegates to **ECMAScript 5**'s native `forEach` if available.
  var each = _.each = _.forEach = function(obj, iterator, context) {
    if (obj == null) return;
    if (nativeForEach && obj.forEach === nativeForEach) {
      obj.forEach(iterator, context);
    } else if (obj.length === +obj.length) {
      for (var i = 0, length = obj.length; i < length; i++) {
        if (iterator.call(context, obj[i], i, obj) === breaker) return;
      }
    } else {
      var keys = _.keys(obj);
      for (var i = 0, length = keys.length; i < length; i++) {
        if (iterator.call(context, obj[keys[i]], keys[i], obj) === breaker) return;
      }
    }
  };

  // Return the results of applying the iterator to each element.
  // Delegates to **ECMAScript 5**'s native `map` if available.
  _.map = _.collect = function(obj, iterator, context) {
    var results = [];
    if (obj == null) return results;
    if (nativeMap && obj.map === nativeMap) return obj.map(iterator, context);
    each(obj, function(value, index, list) {
      results.push(iterator.call(context, value, index, list));
    });
    return results;
  };

  var reduceError = 'Reduce of empty array with no initial value';

  // **Reduce** builds up a single result from a list of values, aka `inject`,
  // or `foldl`. Delegates to **ECMAScript 5**'s native `reduce` if available.
  _.reduce = _.foldl = _.inject = function(obj, iterator, memo, context) {
    var initial = arguments.length > 2;
    if (obj == null) obj = [];
    if (nativeReduce && obj.reduce === nativeReduce) {
      if (context) iterator = _.bind(iterator, context);
      return initial ? obj.reduce(iterator, memo) : obj.reduce(iterator);
    }
    each(obj, function(value, index, list) {
      if (!initial) {
        memo = value;
        initial = true;
      } else {
        memo = iterator.call(context, memo, value, index, list);
      }
    });
    if (!initial) throw new TypeError(reduceError);
    return memo;
  };

  // The right-associative version of reduce, also known as `foldr`.
  // Delegates to **ECMAScript 5**'s native `reduceRight` if available.
  _.reduceRight = _.foldr = function(obj, iterator, memo, context) {
    var initial = arguments.length > 2;
    if (obj == null) obj = [];
    if (nativeReduceRight && obj.reduceRight === nativeReduceRight) {
      if (context) iterator = _.bind(iterator, context);
      return initial ? obj.reduceRight(iterator, memo) : obj.reduceRight(iterator);
    }
    var length = obj.length;
    if (length !== +length) {
      var keys = _.keys(obj);
      length = keys.length;
    }
    each(obj, function(value, index, list) {
      index = keys ? keys[--length] : --length;
      if (!initial) {
        memo = obj[index];
        initial = true;
      } else {
        memo = iterator.call(context, memo, obj[index], index, list);
      }
    });
    if (!initial) throw new TypeError(reduceError);
    return memo;
  };

  // Return the first value which passes a truth test. Aliased as `detect`.
  _.find = _.detect = function(obj, iterator, context) {
    var result;
    any(obj, function(value, index, list) {
      if (iterator.call(context, value, index, list)) {
        result = value;
        return true;
      }
    });
    return result;
  };

  // Return all the elements that pass a truth test.
  // Delegates to **ECMAScript 5**'s native `filter` if available.
  // Aliased as `select`.
  _.filter = _.select = function(obj, iterator, context) {
    var results = [];
    if (obj == null) return results;
    if (nativeFilter && obj.filter === nativeFilter) return obj.filter(iterator, context);
    each(obj, function(value, index, list) {
      if (iterator.call(context, value, index, list)) results.push(value);
    });
    return results;
  };

  // Return all the elements for which a truth test fails.
  _.reject = function(obj, iterator, context) {
    return _.filter(obj, function(value, index, list) {
      return !iterator.call(context, value, index, list);
    }, context);
  };

  // Determine whether all of the elements match a truth test.
  // Delegates to **ECMAScript 5**'s native `every` if available.
  // Aliased as `all`.
  _.every = _.all = function(obj, iterator, context) {
    iterator || (iterator = _.identity);
    var result = true;
    if (obj == null) return result;
    if (nativeEvery && obj.every === nativeEvery) return obj.every(iterator, context);
    each(obj, function(value, index, list) {
      if (!(result = result && iterator.call(context, value, index, list))) return breaker;
    });
    return !!result;
  };

  // Determine if at least one element in the object matches a truth test.
  // Delegates to **ECMAScript 5**'s native `some` if available.
  // Aliased as `any`.
  var any = _.some = _.any = function(obj, iterator, context) {
    iterator || (iterator = _.identity);
    var result = false;
    if (obj == null) return result;
    if (nativeSome && obj.some === nativeSome) return obj.some(iterator, context);
    each(obj, function(value, index, list) {
      if (result || (result = iterator.call(context, value, index, list))) return breaker;
    });
    return !!result;
  };

  // Determine if the array or object contains a given value (using `===`).
  // Aliased as `include`.
  _.contains = _.include = function(obj, target) {
    if (obj == null) return false;
    if (nativeIndexOf && obj.indexOf === nativeIndexOf) return obj.indexOf(target) != -1;
    return any(obj, function(value) {
      return value === target;
    });
  };

  // Invoke a method (with arguments) on every item in a collection.
  _.invoke = function(obj, method) {
    var args = slice.call(arguments, 2);
    var isFunc = _.isFunction(method);
    return _.map(obj, function(value) {
      return (isFunc ? method : value[method]).apply(value, args);
    });
  };

  // Convenience version of a common use case of `map`: fetching a property.
  _.pluck = function(obj, key) {
    return _.map(obj, function(value){ return value[key]; });
  };

  // Convenience version of a common use case of `filter`: selecting only objects
  // containing specific `key:value` pairs.
  _.where = function(obj, attrs, first) {
    if (_.isEmpty(attrs)) return first ? void 0 : [];
    return _[first ? 'find' : 'filter'](obj, function(value) {
      for (var key in attrs) {
        if (attrs[key] !== value[key]) return false;
      }
      return true;
    });
  };

  // Convenience version of a common use case of `find`: getting the first object
  // containing specific `key:value` pairs.
  _.findWhere = function(obj, attrs) {
    return _.where(obj, attrs, true);
  };

  // Return the maximum element or (element-based computation).
  // Can't optimize arrays of integers longer than 65,535 elements.
  // See [WebKit Bug 80797](https://bugs.webkit.org/show_bug.cgi?id=80797)
  _.max = function(obj, iterator, context) {
    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
      return Math.max.apply(Math, obj);
    }
    if (!iterator && _.isEmpty(obj)) return -Infinity;
    var result = {computed : -Infinity, value: -Infinity};
    each(obj, function(value, index, list) {
      var computed = iterator ? iterator.call(context, value, index, list) : value;
      computed > result.computed && (result = {value : value, computed : computed});
    });
    return result.value;
  };

  // Return the minimum element (or element-based computation).
  _.min = function(obj, iterator, context) {
    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
      return Math.min.apply(Math, obj);
    }
    if (!iterator && _.isEmpty(obj)) return Infinity;
    var result = {computed : Infinity, value: Infinity};
    each(obj, function(value, index, list) {
      var computed = iterator ? iterator.call(context, value, index, list) : value;
      computed < result.computed && (result = {value : value, computed : computed});
    });
    return result.value;
  };

  // Shuffle an array, using the modern version of the 
  // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
  _.shuffle = function(obj) {
    var rand;
    var index = 0;
    var shuffled = [];
    each(obj, function(value) {
      rand = _.random(index++);
      shuffled[index - 1] = shuffled[rand];
      shuffled[rand] = value;
    });
    return shuffled;
  };

  // Sample **n** random values from an array.
  // If **n** is not specified, returns a single random element from the array.
  // The internal `guard` argument allows it to work with `map`.
  _.sample = function(obj, n, guard) {
    if (arguments.length < 2 || guard) {
      return obj[_.random(obj.length - 1)];
    }
    return _.shuffle(obj).slice(0, Math.max(0, n));
  };

  // An internal function to generate lookup iterators.
  var lookupIterator = function(value) {
    return _.isFunction(value) ? value : function(obj){ return obj[value]; };
  };

  // Sort the object's values by a criterion produced by an iterator.
  _.sortBy = function(obj, value, context) {
    var iterator = lookupIterator(value);
    return _.pluck(_.map(obj, function(value, index, list) {
      return {
        value: value,
        index: index,
        criteria: iterator.call(context, value, index, list)
      };
    }).sort(function(left, right) {
      var a = left.criteria;
      var b = right.criteria;
      if (a !== b) {
        if (a > b || a === void 0) return 1;
        if (a < b || b === void 0) return -1;
      }
      return left.index - right.index;
    }), 'value');
  };

  // An internal function used for aggregate "group by" operations.
  var group = function(behavior) {
    return function(obj, value, context) {
      var result = {};
      var iterator = value == null ? _.identity : lookupIterator(value);
      each(obj, function(value, index) {
        var key = iterator.call(context, value, index, obj);
        behavior(result, key, value);
      });
      return result;
    };
  };

  // Groups the object's values by a criterion. Pass either a string attribute
  // to group by, or a function that returns the criterion.
  _.groupBy = group(function(result, key, value) {
    (_.has(result, key) ? result[key] : (result[key] = [])).push(value);
  });

  // Indexes the object's values by a criterion, similar to `groupBy`, but for
  // when you know that your index values will be unique.
  _.indexBy = group(function(result, key, value) {
    result[key] = value;
  });

  // Counts instances of an object that group by a certain criterion. Pass
  // either a string attribute to count by, or a function that returns the
  // criterion.
  _.countBy = group(function(result, key) {
    _.has(result, key) ? result[key]++ : result[key] = 1;
  });

  // Use a comparator function to figure out the smallest index at which
  // an object should be inserted so as to maintain order. Uses binary search.
  _.sortedIndex = function(array, obj, iterator, context) {
    iterator = iterator == null ? _.identity : lookupIterator(iterator);
    var value = iterator.call(context, obj);
    var low = 0, high = array.length;
    while (low < high) {
      var mid = (low + high) >>> 1;
      iterator.call(context, array[mid]) < value ? low = mid + 1 : high = mid;
    }
    return low;
  };

  // Safely create a real, live array from anything iterable.
  _.toArray = function(obj) {
    if (!obj) return [];
    if (_.isArray(obj)) return slice.call(obj);
    if (obj.length === +obj.length) return _.map(obj, _.identity);
    return _.values(obj);
  };

  // Return the number of elements in an object.
  _.size = function(obj) {
    if (obj == null) return 0;
    return (obj.length === +obj.length) ? obj.length : _.keys(obj).length;
  };

  // Array Functions
  // ---------------

  // Get the first element of an array. Passing **n** will return the first N
  // values in the array. Aliased as `head` and `take`. The **guard** check
  // allows it to work with `_.map`.
  _.first = _.head = _.take = function(array, n, guard) {
    if (array == null) return void 0;
    return (n == null) || guard ? array[0] : slice.call(array, 0, n);
  };

  // Returns everything but the last entry of the array. Especially useful on
  // the arguments object. Passing **n** will return all the values in
  // the array, excluding the last N. The **guard** check allows it to work with
  // `_.map`.
  _.initial = function(array, n, guard) {
    return slice.call(array, 0, array.length - ((n == null) || guard ? 1 : n));
  };

  // Get the last element of an array. Passing **n** will return the last N
  // values in the array. The **guard** check allows it to work with `_.map`.
  _.last = function(array, n, guard) {
    if (array == null) return void 0;
    if ((n == null) || guard) {
      return array[array.length - 1];
    } else {
      return slice.call(array, Math.max(array.length - n, 0));
    }
  };

  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.
  // Especially useful on the arguments object. Passing an **n** will return
  // the rest N values in the array. The **guard**
  // check allows it to work with `_.map`.
  _.rest = _.tail = _.drop = function(array, n, guard) {
    return slice.call(array, (n == null) || guard ? 1 : n);
  };

  // Trim out all falsy values from an array.
  _.compact = function(array) {
    return _.filter(array, _.identity);
  };

  // Internal implementation of a recursive `flatten` function.
  var flatten = function(input, shallow, output) {
    if (shallow && _.every(input, _.isArray)) {
      return concat.apply(output, input);
    }
    each(input, function(value) {
      if (_.isArray(value) || _.isArguments(value)) {
        shallow ? push.apply(output, value) : flatten(value, shallow, output);
      } else {
        output.push(value);
      }
    });
    return output;
  };

  // Flatten out an array, either recursively (by default), or just one level.
  _.flatten = function(array, shallow) {
    return flatten(array, shallow, []);
  };

  // Return a version of the array that does not contain the specified value(s).
  _.without = function(array) {
    return _.difference(array, slice.call(arguments, 1));
  };

  // Produce a duplicate-free version of the array. If the array has already
  // been sorted, you have the option of using a faster algorithm.
  // Aliased as `unique`.
  _.uniq = _.unique = function(array, isSorted, iterator, context) {
    if (_.isFunction(isSorted)) {
      context = iterator;
      iterator = isSorted;
      isSorted = false;
    }
    var initial = iterator ? _.map(array, iterator, context) : array;
    var results = [];
    var seen = [];
    each(initial, function(value, index) {
      if (isSorted ? (!index || seen[seen.length - 1] !== value) : !_.contains(seen, value)) {
        seen.push(value);
        results.push(array[index]);
      }
    });
    return results;
  };

  // Produce an array that contains the union: each distinct element from all of
  // the passed-in arrays.
  _.union = function() {
    return _.uniq(_.flatten(arguments, true));
  };

  // Produce an array that contains every item shared between all the
  // passed-in arrays.
  _.intersection = function(array) {
    var rest = slice.call(arguments, 1);
    return _.filter(_.uniq(array), function(item) {
      return _.every(rest, function(other) {
        return _.indexOf(other, item) >= 0;
      });
    });
  };

  // Take the difference between one array and a number of other arrays.
  // Only the elements present in just the first array will remain.
  _.difference = function(array) {
    var rest = concat.apply(ArrayProto, slice.call(arguments, 1));
    return _.filter(array, function(value){ return !_.contains(rest, value); });
  };

  // Zip together multiple lists into a single array -- elements that share
  // an index go together.
  _.zip = function() {
    var length = _.max(_.pluck(arguments, "length").concat(0));
    var results = new Array(length);
    for (var i = 0; i < length; i++) {
      results[i] = _.pluck(arguments, '' + i);
    }
    return results;
  };

  // Converts lists into objects. Pass either a single array of `[key, value]`
  // pairs, or two parallel arrays of the same length -- one of keys, and one of
  // the corresponding values.
  _.object = function(list, values) {
    if (list == null) return {};
    var result = {};
    for (var i = 0, length = list.length; i < length; i++) {
      if (values) {
        result[list[i]] = values[i];
      } else {
        result[list[i][0]] = list[i][1];
      }
    }
    return result;
  };

  // If the browser doesn't supply us with indexOf (I'm looking at you, **MSIE**),
  // we need this function. Return the position of the first occurrence of an
  // item in an array, or -1 if the item is not included in the array.
  // Delegates to **ECMAScript 5**'s native `indexOf` if available.
  // If the array is large and already in sort order, pass `true`
  // for **isSorted** to use binary search.
  _.indexOf = function(array, item, isSorted) {
    if (array == null) return -1;
    var i = 0, length = array.length;
    if (isSorted) {
      if (typeof isSorted == 'number') {
        i = (isSorted < 0 ? Math.max(0, length + isSorted) : isSorted);
      } else {
        i = _.sortedIndex(array, item);
        return array[i] === item ? i : -1;
      }
    }
    if (nativeIndexOf && array.indexOf === nativeIndexOf) return array.indexOf(item, isSorted);
    for (; i < length; i++) if (array[i] === item) return i;
    return -1;
  };

  // Delegates to **ECMAScript 5**'s native `lastIndexOf` if available.
  _.lastIndexOf = function(array, item, from) {
    if (array == null) return -1;
    var hasIndex = from != null;
    if (nativeLastIndexOf && array.lastIndexOf === nativeLastIndexOf) {
      return hasIndex ? array.lastIndexOf(item, from) : array.lastIndexOf(item);
    }
    var i = (hasIndex ? from : array.length);
    while (i--) if (array[i] === item) return i;
    return -1;
  };

  // Generate an integer Array containing an arithmetic progression. A port of
  // the native Python `range()` function. See
  // [the Python documentation](http://docs.python.org/library/functions.html#range).
  _.range = function(start, stop, step) {
    if (arguments.length <= 1) {
      stop = start || 0;
      start = 0;
    }
    step = arguments[2] || 1;

    var length = Math.max(Math.ceil((stop - start) / step), 0);
    var idx = 0;
    var range = new Array(length);

    while(idx < length) {
      range[idx++] = start;
      start += step;
    }

    return range;
  };

  // Function (ahem) Functions
  // ------------------

  // Reusable constructor function for prototype setting.
  var ctor = function(){};

  // Create a function bound to a given object (assigning `this`, and arguments,
  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if
  // available.
  _.bind = function(func, context) {
    var args, bound;
    if (nativeBind && func.bind === nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));
    if (!_.isFunction(func)) throw new TypeError;
    args = slice.call(arguments, 2);
    return bound = function() {
      if (!(this instanceof bound)) return func.apply(context, args.concat(slice.call(arguments)));
      ctor.prototype = func.prototype;
      var self = new ctor;
      ctor.prototype = null;
      var result = func.apply(self, args.concat(slice.call(arguments)));
      if (Object(result) === result) return result;
      return self;
    };
  };

  // Partially apply a function by creating a version that has had some of its
  // arguments pre-filled, without changing its dynamic `this` context.
  _.partial = function(func) {
    var args = slice.call(arguments, 1);
    return function() {
      return func.apply(this, args.concat(slice.call(arguments)));
    };
  };

  // Bind all of an object's methods to that object. Useful for ensuring that
  // all callbacks defined on an object belong to it.
  _.bindAll = function(obj) {
    var funcs = slice.call(arguments, 1);
    if (funcs.length === 0) throw new Error("bindAll must be passed function names");
    each(funcs, function(f) { obj[f] = _.bind(obj[f], obj); });
    return obj;
  };

  // Memoize an expensive function by storing its results.
  _.memoize = function(func, hasher) {
    var memo = {};
    hasher || (hasher = _.identity);
    return function() {
      var key = hasher.apply(this, arguments);
      return _.has(memo, key) ? memo[key] : (memo[key] = func.apply(this, arguments));
    };
  };

  // Delays a function for the given number of milliseconds, and then calls
  // it with the arguments supplied.
  _.delay = function(func, wait) {
    var args = slice.call(arguments, 2);
    return setTimeout(function(){ return func.apply(null, args); }, wait);
  };

  // Defers a function, scheduling it to run after the current call stack has
  // cleared.
  _.defer = function(func) {
    return _.delay.apply(_, [func, 1].concat(slice.call(arguments, 1)));
  };

  // Returns a function, that, when invoked, will only be triggered at most once
  // during a given window of time. Normally, the throttled function will run
  // as much as it can, without ever going more than once per `wait` duration;
  // but if you'd like to disable the execution on the leading edge, pass
  // `{leading: false}`. To disable execution on the trailing edge, ditto.
  _.throttle = function(func, wait, options) {
    var context, args, result;
    var timeout = null;
    var previous = 0;
    options || (options = {});
    var later = function() {
      previous = options.leading === false ? 0 : new Date;
      timeout = null;
      result = func.apply(context, args);
    };
    return function() {
      var now = new Date;
      if (!previous && options.leading === false) previous = now;
      var remaining = wait - (now - previous);
      context = this;
      args = arguments;
      if (remaining <= 0) {
        clearTimeout(timeout);
        timeout = null;
        previous = now;
        result = func.apply(context, args);
      } else if (!timeout && options.trailing !== false) {
        timeout = setTimeout(later, remaining);
      }
      return result;
    };
  };

  // Returns a function, that, as long as it continues to be invoked, will not
  // be triggered. The function will be called after it stops being called for
  // N milliseconds. If `immediate` is passed, trigger the function on the
  // leading edge, instead of the trailing.
  _.debounce = function(func, wait, immediate) {
    var timeout, args, context, timestamp, result;
    return function() {
      context = this;
      args = arguments;
      timestamp = new Date();
      var later = function() {
        var last = (new Date()) - timestamp;
        if (last < wait) {
          timeout = setTimeout(later, wait - last);
        } else {
          timeout = null;
          if (!immediate) result = func.apply(context, args);
        }
      };
      var callNow = immediate && !timeout;
      if (!timeout) {
        timeout = setTimeout(later, wait);
      }
      if (callNow) result = func.apply(context, args);
      return result;
    };
  };

  // Returns a function that will be executed at most one time, no matter how
  // often you call it. Useful for lazy initialization.
  _.once = function(func) {
    var ran = false, memo;
    return function() {
      if (ran) return memo;
      ran = true;
      memo = func.apply(this, arguments);
      func = null;
      return memo;
    };
  };

  // Returns the first function passed as an argument to the second,
  // allowing you to adjust arguments, run code before and after, and
  // conditionally execute the original function.
  _.wrap = function(func, wrapper) {
    return function() {
      var args = [func];
      push.apply(args, arguments);
      return wrapper.apply(this, args);
    };
  };

  // Returns a function that is the composition of a list of functions, each
  // consuming the return value of the function that follows.
  _.compose = function() {
    var funcs = arguments;
    return function() {
      var args = arguments;
      for (var i = funcs.length - 1; i >= 0; i--) {
        args = [funcs[i].apply(this, args)];
      }
      return args[0];
    };
  };

  // Returns a function that will only be executed after being called N times.
  _.after = function(times, func) {
    return function() {
      if (--times < 1) {
        return func.apply(this, arguments);
      }
    };
  };

  // Object Functions
  // ----------------

  // Retrieve the names of an object's properties.
  // Delegates to **ECMAScript 5**'s native `Object.keys`
  _.keys = nativeKeys || function(obj) {
    if (obj !== Object(obj)) throw new TypeError('Invalid object');
    var keys = [];
    for (var key in obj) if (_.has(obj, key)) keys.push(key);
    return keys;
  };

  // Retrieve the values of an object's properties.
  _.values = function(obj) {
    var keys = _.keys(obj);
    var length = keys.length;
    var values = new Array(length);
    for (var i = 0; i < length; i++) {
      values[i] = obj[keys[i]];
    }
    return values;
  };

  // Convert an object into a list of `[key, value]` pairs.
  _.pairs = function(obj) {
    var keys = _.keys(obj);
    var length = keys.length;
    var pairs = new Array(length);
    for (var i = 0; i < length; i++) {
      pairs[i] = [keys[i], obj[keys[i]]];
    }
    return pairs;
  };

  // Invert the keys and values of an object. The values must be serializable.
  _.invert = function(obj) {
    var result = {};
    var keys = _.keys(obj);
    for (var i = 0, length = keys.length; i < length; i++) {
      result[obj[keys[i]]] = keys[i];
    }
    return result;
  };

  // Return a sorted list of the function names available on the object.
  // Aliased as `methods`
  _.functions = _.methods = function(obj) {
    var names = [];
    for (var key in obj) {
      if (_.isFunction(obj[key])) names.push(key);
    }
    return names.sort();
  };

  // Extend a given object with all the properties in passed-in object(s).
  _.extend = function(obj) {
    each(slice.call(arguments, 1), function(source) {
      if (source) {
        for (var prop in source) {
          obj[prop] = source[prop];
        }
      }
    });
    return obj;
  };

  // Return a copy of the object only containing the whitelisted properties.
  _.pick = function(obj) {
    var copy = {};
    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
    each(keys, function(key) {
      if (key in obj) copy[key] = obj[key];
    });
    return copy;
  };

   // Return a copy of the object without the blacklisted properties.
  _.omit = function(obj) {
    var copy = {};
    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
    for (var key in obj) {
      if (!_.contains(keys, key)) copy[key] = obj[key];
    }
    return copy;
  };

  // Fill in a given object with default properties.
  _.defaults = function(obj) {
    each(slice.call(arguments, 1), function(source) {
      if (source) {
        for (var prop in source) {
          if (obj[prop] === void 0) obj[prop] = source[prop];
        }
      }
    });
    return obj;
  };

  // Create a (shallow-cloned) duplicate of an object.
  _.clone = function(obj) {
    if (!_.isObject(obj)) return obj;
    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);
  };

  // Invokes interceptor with the obj, and then returns obj.
  // The primary purpose of this method is to "tap into" a method chain, in
  // order to perform operations on intermediate results within the chain.
  _.tap = function(obj, interceptor) {
    interceptor(obj);
    return obj;
  };

  // Internal recursive comparison function for `isEqual`.
  var eq = function(a, b, aStack, bStack) {
    // Identical objects are equal. `0 === -0`, but they aren't identical.
    // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).
    if (a === b) return a !== 0 || 1 / a == 1 / b;
    // A strict comparison is necessary because `null == undefined`.
    if (a == null || b == null) return a === b;
    // Unwrap any wrapped objects.
    if (a instanceof _) a = a._wrapped;
    if (b instanceof _) b = b._wrapped;
    // Compare `[[Class]]` names.
    var className = toString.call(a);
    if (className != toString.call(b)) return false;
    switch (className) {
      // Strings, numbers, dates, and booleans are compared by value.
      case '[object String]':
        // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
        // equivalent to `new String("5")`.
        return a == String(b);
      case '[object Number]':
        // `NaN`s are equivalent, but non-reflexive. An `egal` comparison is performed for
        // other numeric values.
        return a != +a ? b != +b : (a == 0 ? 1 / a == 1 / b : a == +b);
      case '[object Date]':
      case '[object Boolean]':
        // Coerce dates and booleans to numeric primitive values. Dates are compared by their
        // millisecond representations. Note that invalid dates with millisecond representations
        // of `NaN` are not equivalent.
        return +a == +b;
      // RegExps are compared by their source patterns and flags.
      case '[object RegExp]':
        return a.source == b.source &&
               a.global == b.global &&
               a.multiline == b.multiline &&
               a.ignoreCase == b.ignoreCase;
    }
    if (typeof a != 'object' || typeof b != 'object') return false;
    // Assume equality for cyclic structures. The algorithm for detecting cyclic
    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
    var length = aStack.length;
    while (length--) {
      // Linear search. Performance is inversely proportional to the number of
      // unique nested structures.
      if (aStack[length] == a) return bStack[length] == b;
    }
    // Objects with different constructors are not equivalent, but `Object`s
    // from different frames are.
    var aCtor = a.constructor, bCtor = b.constructor;
    if (aCtor !== bCtor && !(_.isFunction(aCtor) && (aCtor instanceof aCtor) &&
                             _.isFunction(bCtor) && (bCtor instanceof bCtor))) {
      return false;
    }
    // Add the first object to the stack of traversed objects.
    aStack.push(a);
    bStack.push(b);
    var size = 0, result = true;
    // Recursively compare objects and arrays.
    if (className == '[object Array]') {
      // Compare array lengths to determine if a deep comparison is necessary.
      size = a.length;
      result = size == b.length;
      if (result) {
        // Deep compare the contents, ignoring non-numeric properties.
        while (size--) {
          if (!(result = eq(a[size], b[size], aStack, bStack))) break;
        }
      }
    } else {
      // Deep compare objects.
      for (var key in a) {
        if (_.has(a, key)) {
          // Count the expected number of properties.
          size++;
          // Deep compare each member.
          if (!(result = _.has(b, key) && eq(a[key], b[key], aStack, bStack))) break;
        }
      }
      // Ensure that both objects contain the same number of properties.
      if (result) {
        for (key in b) {
          if (_.has(b, key) && !(size--)) break;
        }
        result = !size;
      }
    }
    // Remove the first object from the stack of traversed objects.
    aStack.pop();
    bStack.pop();
    return result;
  };

  // Perform a deep comparison to check if two objects are equal.
  _.isEqual = function(a, b) {
    return eq(a, b, [], []);
  };

  // Is a given array, string, or object empty?
  // An "empty" object has no enumerable own-properties.
  _.isEmpty = function(obj) {
    if (obj == null) return true;
    if (_.isArray(obj) || _.isString(obj)) return obj.length === 0;
    for (var key in obj) if (_.has(obj, key)) return false;
    return true;
  };

  // Is a given value a DOM element?
  _.isElement = function(obj) {
    return !!(obj && obj.nodeType === 1);
  };

  // Is a given value an array?
  // Delegates to ECMA5's native Array.isArray
  _.isArray = nativeIsArray || function(obj) {
    return toString.call(obj) == '[object Array]';
  };

  // Is a given variable an object?
  _.isObject = function(obj) {
    return obj === Object(obj);
  };

  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp.
  each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp'], function(name) {
    _['is' + name] = function(obj) {
      return toString.call(obj) == '[object ' + name + ']';
    };
  });

  // Define a fallback version of the method in browsers (ahem, IE), where
  // there isn't any inspectable "Arguments" type.
  if (!_.isArguments(arguments)) {
    _.isArguments = function(obj) {
      return !!(obj && _.has(obj, 'callee'));
    };
  }

  // Optimize `isFunction` if appropriate.
  if (typeof (/./) !== 'function') {
    _.isFunction = function(obj) {
      return typeof obj === 'function';
    };
  }

  // Is a given object a finite number?
  _.isFinite = function(obj) {
    return isFinite(obj) && !isNaN(parseFloat(obj));
  };

  // Is the given value `NaN`? (NaN is the only number which does not equal itself).
  _.isNaN = function(obj) {
    return _.isNumber(obj) && obj != +obj;
  };

  // Is a given value a boolean?
  _.isBoolean = function(obj) {
    return obj === true || obj === false || toString.call(obj) == '[object Boolean]';
  };

  // Is a given value equal to null?
  _.isNull = function(obj) {
    return obj === null;
  };

  // Is a given variable undefined?
  _.isUndefined = function(obj) {
    return obj === void 0;
  };

  // Shortcut function for checking if an object has a given property directly
  // on itself (in other words, not on a prototype).
  _.has = function(obj, key) {
    return hasOwnProperty.call(obj, key);
  };

  // Utility Functions
  // -----------------

  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its
  // previous owner. Returns a reference to the Underscore object.
  _.noConflict = function() {
    root._ = previousUnderscore;
    return this;
  };

  // Keep the identity function around for default iterators.
  _.identity = function(value) {
    return value;
  };

  // Run a function **n** times.
  _.times = function(n, iterator, context) {
    var accum = Array(Math.max(0, n));
    for (var i = 0; i < n; i++) accum[i] = iterator.call(context, i);
    return accum;
  };

  // Return a random integer between min and max (inclusive).
  _.random = function(min, max) {
    if (max == null) {
      max = min;
      min = 0;
    }
    return min + Math.floor(Math.random() * (max - min + 1));
  };

  // List of HTML entities for escaping.
  var entityMap = {
    escape: {
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#x27;'
    }
  };
  entityMap.unescape = _.invert(entityMap.escape);

  // Regexes containing the keys and values listed immediately above.
  var entityRegexes = {
    escape:   new RegExp('[' + _.keys(entityMap.escape).join('') + ']', 'g'),
    unescape: new RegExp('(' + _.keys(entityMap.unescape).join('|') + ')', 'g')
  };

  // Functions for escaping and unescaping strings to/from HTML interpolation.
  _.each(['escape', 'unescape'], function(method) {
    _[method] = function(string) {
      if (string == null) return '';
      return ('' + string).replace(entityRegexes[method], function(match) {
        return entityMap[method][match];
      });
    };
  });

  // If the value of the named `property` is a function then invoke it with the
  // `object` as context; otherwise, return it.
  _.result = function(object, property) {
    if (object == null) return void 0;
    var value = object[property];
    return _.isFunction(value) ? value.call(object) : value;
  };

  // Add your own custom functions to the Underscore object.
  _.mixin = function(obj) {
    each(_.functions(obj), function(name) {
      var func = _[name] = obj[name];
      _.prototype[name] = function() {
        var args = [this._wrapped];
        push.apply(args, arguments);
        return result.call(this, func.apply(_, args));
      };
    });
  };

  // Generate a unique integer id (unique within the entire client session).
  // Useful for temporary DOM ids.
  var idCounter = 0;
  _.uniqueId = function(prefix) {
    var id = ++idCounter + '';
    return prefix ? prefix + id : id;
  };

  // By default, Underscore uses ERB-style template delimiters, change the
  // following template settings to use alternative delimiters.
  _.templateSettings = {
    evaluate    : /<%([\s\S]+?)%>/g,
    interpolate : /<%=([\s\S]+?)%>/g,
    escape      : /<%-([\s\S]+?)%>/g
  };

  // When customizing `templateSettings`, if you don't want to define an
  // interpolation, evaluation or escaping regex, we need one that is
  // guaranteed not to match.
  var noMatch = /(.)^/;

  // Certain characters need to be escaped so that they can be put into a
  // string literal.
  var escapes = {
    "'":      "'",
    '\\':     '\\',
    '\r':     'r',
    '\n':     'n',
    '\t':     't',
    '\u2028': 'u2028',
    '\u2029': 'u2029'
  };

  var escaper = /\\|'|\r|\n|\t|\u2028|\u2029/g;

  // JavaScript micro-templating, similar to John Resig's implementation.
  // Underscore templating handles arbitrary delimiters, preserves whitespace,
  // and correctly escapes quotes within interpolated code.
  _.template = function(text, data, settings) {
    var render;
    settings = _.defaults({}, settings, _.templateSettings);

    // Combine delimiters into one regular expression via alternation.
    var matcher = new RegExp([
      (settings.escape || noMatch).source,
      (settings.interpolate || noMatch).source,
      (settings.evaluate || noMatch).source
    ].join('|') + '|$', 'g');

    // Compile the template source, escaping string literals appropriately.
    var index = 0;
    var source = "__p+='";
    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {
      source += text.slice(index, offset)
        .replace(escaper, function(match) { return '\\' + escapes[match]; });

      if (escape) {
        source += "'+\n((__t=(" + escape + "))==null?'':_.escape(__t))+\n'";
      }
      if (interpolate) {
        source += "'+\n((__t=(" + interpolate + "))==null?'':__t)+\n'";
      }
      if (evaluate) {
        source += "';\n" + evaluate + "\n__p+='";
      }
      index = offset + match.length;
      return match;
    });
    source += "';\n";

    // If a variable is not specified, place data values in local scope.
    if (!settings.variable) source = 'with(obj||{}){\n' + source + '}\n';

    source = "var __t,__p='',__j=Array.prototype.join," +
      "print=function(){__p+=__j.call(arguments,'');};\n" +
      source + "return __p;\n";

    try {
      render = new Function(settings.variable || 'obj', '_', source);
    } catch (e) {
      e.source = source;
      throw e;
    }

    if (data) return render(data, _);
    var template = function(data) {
      return render.call(this, data, _);
    };

    // Provide the compiled function source as a convenience for precompilation.
    template.source = 'function(' + (settings.variable || 'obj') + '){\n' + source + '}';

    return template;
  };

  // Add a "chain" function, which will delegate to the wrapper.
  _.chain = function(obj) {
    return _(obj).chain();
  };

  // OOP
  // ---------------
  // If Underscore is called as a function, it returns a wrapped object that
  // can be used OO-style. This wrapper holds altered versions of all the
  // underscore functions. Wrapped objects may be chained.

  // Helper function to continue chaining intermediate results.
  var result = function(obj) {
    return this._chain ? _(obj).chain() : obj;
  };

  // Add all of the Underscore functions to the wrapper object.
  _.mixin(_);

  // Add all mutator Array functions to the wrapper.
  each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {
    var method = ArrayProto[name];
    _.prototype[name] = function() {
      var obj = this._wrapped;
      method.apply(obj, arguments);
      if ((name == 'shift' || name == 'splice') && obj.length === 0) delete obj[0];
      return result.call(this, obj);
    };
  });

  // Add all accessor Array functions to the wrapper.
  each(['concat', 'join', 'slice'], function(name) {
    var method = ArrayProto[name];
    _.prototype[name] = function() {
      return result.call(this, method.apply(this._wrapped, arguments));
    };
  });

  _.extend(_.prototype, {

    // Start chaining a wrapped Underscore object.
    chain: function() {
      this._chain = true;
      return this;
    },

    // Extracts the result from a wrapped and chained object.
    value: function() {
      return this._wrapped;
    }

  });

}).call(this);

},{}]},{},[11,12,13,14,15,16,17,18,19,20])