//////////////////////////////
///////    MODELS     ////////
//////////////////////////////

window.People = Backbone.Model.extend({
	urlRoot: "http://memefight.net/_tvseriestweet/people" + "?callback=?", 	// JSONP
	idAttribute: "user_screen"
});
window.PeopleCollection = Backbone.Collection.extend({
	model: People,
	url: "http://memefight.net/_tvseriestweet/people" + "?callback=?" 	// JSONP
});
window.Trend = Backbone.Model.extend({
	urlRoot: "http://memefight.net/_tvseriestweet/trend" + "?callback=?" 	// JSONP
});
window.Feed = Backbone.Model.extend({
	urlRoot: "http://memefight.net/_tvseriestweet/tweets" + "?callback=?", 	// JSONP
});
window.FeedCollection = Backbone.Collection.extend({
	model: Feed,
  initialize: function (options) { this.page = (options && options.page) ? options.page : 1; },
	url: function () { return "http://memefight.net/_tvseriestweet/tweets/" + this.page + "?callback=?"; } 	// ADD JSONP SUPPORT
});
window.FeedBestCollection = Backbone.Collection.extend({
	model: Feed,
  initialize: function (options) { this.page = (options && options.page) ? options.page : 1; },
	url: function () { return "http://memefight.net/_tvseriestweet/tweets/best/" + this.page + "?callback=?"; } 	// ADD JSONP SUPPORT
});
window.FeedTopCollection = Backbone.Collection.extend({
	model: Feed,
  initialize: function (options) { this.giorni = (options && options.giorni) ? options.giorni : ''; },
	url: function () { return "http://memefight.net/_tvseriestweet/top" + ((this.giorni!='') ? '/'+this.giorni : '' ) + "?callback=?"; } 	// ADD JSONP SUPPORT
});
window.FeedPeopleCollection = Backbone.Collection.extend({
	model: Feed,
  initialize: function (options) { 
    if (options && options.politico) { this.politico = options.politico; }
    this.page = (options && options.page) ? options.page : 1; 
  },
	url: function () { return "http://memefight.net/_tvseriestweet/tweets/user/" + this.politico + "/" + this.page + "?callback=?"; } 	// ADD JSONP SUPPORT
});


//////////////////////////////
///////    VIEWS      ////////
//////////////////////////////

window.InfoView = Backbone.View.extend({
  initialize:  function () { this.render(); },
  render:      function () { $(this.el).html(this.template()); return this; },
  afterRender: function () { this.delegateEvents(); }
});

window.FeedListView = Backbone.View.extend({
  initialize: function (options) {
    this.options = options || {};
    this.isLoading = false;
    this.render();
  },
  render: function () {
    var self = this;
    var feed = self.model.models;
    
    if (self.model.page==1) {
      $(this.el).html('<ul class="table-view custom-table-cell-streched" id="elenco_feed"></ul>');
    }
    var peopleBlocked = (window.localStorage.getItem('peopleBlocked')) ? JSON.parse(window.localStorage.getItem('peopleBlocked')) : new Array;
    
    var frag = document.createDocumentFragment();
    for (var i = 0; i < feed.length; i++) {
      // SALTO QUELLI CHE NON MI INTERESSANO
      if (_.indexOf(peopleBlocked, feed[i].attributes.user_screen)!=-1) {
        continue;
      }
      var politico = (this.options.peopleList) ? _.findWhere(this.options.peopleList.models, {id:feed[i].attributes.user_screen}) : "";
      var item = new FeedListItemView({model: feed[i], politico: politico});
  		//$('#elenco_feed', self.el).append(item.render().el);
      frag.appendChild(item.render().el);
    }
 		$('#elenco_feed', self.el).append(frag);

    $("#content").off("scroll");
    $("#content").on("scroll" , function () {
      if( !self.isLoading && $("#content").scrollTop() > 0.4 * $("#content ul").height() ) {
        self.model.page += 1; // Load next page
        self.loadPage();
      }
    });
    return this;
  },
  loadPage: function () {
    var self = this;
    self.isLoading = true;
    self.model.fetch({cache: true, expires: 60*5 /* 5 minuti */,
      success: function(){
        self.render();
        self.isLoading = false;
    }});
  },
  afterRender: function () { this.delegateEvents(); }
});

window.FeedTopListView = Backbone.View.extend({
  initialize: function (options) {
    this.options = options || {};
    this.render();
  },
  render: function () {
    var self = this;
    var feed = self.model.models;
    
    $(this.el).html('<div class="segmented-control">    \
        <a href="#top"    class="control-item ' + ((!self.options.giorni)?'active':'') + '">All time</a>    \
        <a href="#top/30" class="control-item ' + (( self.options.giorni)?'active':'') + '">Last month</a>    \
      </div>    \
      <ul class="table-view custom-table-cell-streched" id="elenco_feed"></ul>');

    var peopleBlocked = (window.localStorage.getItem('peopleBlocked')) ? JSON.parse(window.localStorage.getItem('peopleBlocked')) : new Array;
    
    var frag = document.createDocumentFragment();
    for (var i = 0; i < feed.length; i++) {
      // SALTO QUELLI CHE NON MI INTERESSANO
      if (_.indexOf(peopleBlocked, feed[i].attributes.user_screen)!=-1) {
        continue;
      }
      var politico = (this.options.peopleList) ? _.findWhere(this.options.peopleList.models, {id:feed[i].attributes.user_screen}) : "";
      var item = new FeedListItemView({model: feed[i], politico: politico});
  		//$('#elenco_feed', self.el).append(item.render().el);
      frag.appendChild(item.render().el);
    }
 		$('#elenco_feed', self.el).append(frag);
    return this;
  },
  afterRender: function () { this.delegateEvents(); }
});

window.FeedBestListView = Backbone.View.extend({
  initialize: function (options) {
    this.options = options || {};
    this.isLoading = false;
    this.render();
  },
  render: function () {
    var self = this;
    var feed = self.model.models;
    
    if (self.model.page==1) {
      $(this.el).html('<ul class="table-view custom-table-cell-streched" id="elenco_feed"></ul>');
    }
    var peopleBlocked = (window.localStorage.getItem('peopleBlocked')) ? JSON.parse(window.localStorage.getItem('peopleBlocked')) : new Array;
    
    var frag = document.createDocumentFragment();
    for (var i = 0; i < feed.length; i++) {
      // SALTO QUELLI CHE NON MI INTERESSANO
      if (_.indexOf(peopleBlocked, feed[i].attributes.user_screen)!=-1) {
        continue;
      }
      var politico = (this.options.peopleList) ? _.findWhere(this.options.peopleList.models, {id:feed[i].attributes.user_screen}) : "";
      var item = new FeedListItemView({model: feed[i], politico: politico});
  		//$('#elenco_feed', self.el).append(item.render().el);
      frag.appendChild(item.render().el);
    }
 		$('#elenco_feed', self.el).append(frag);

    $("#content").off("scroll");
    $("#content").on("scroll" , function () {
      if( !self.isLoading && $("#content").scrollTop() > 0.4 * $("#content ul").height() ) {
        self.model.page += 1; // Load next page
        self.loadPage();
      }
    });
    return this;
  },
  loadPage: function () {
    var self = this;
    self.isLoading = true;
    self.model.fetch({cache: true, expires: 60*5 /* 5 minuti */,
      success: function(){
        self.render();
        self.isLoading = false;
    }});
  },
  afterRender: function () { this.delegateEvents(); }
});

window.FeedPeopleListView = Backbone.View.extend({
  events: {
    "toggle .toggle"   : "segui"
  },
  initialize: function (options) {
    this.options = options || {};
    this.isLoading = false;
    this.render();
  },
  render: function () {
    var self = this;
    var feed = self.model.models;
    
    if (self.model.page==1) {
      var peopleBlocked = (window.localStorage.getItem('peopleBlocked')) ? JSON.parse(window.localStorage.getItem('peopleBlocked')) : new Array;
      var active = (_.indexOf(peopleBlocked, this.options.politico.attributes.user_screen)==-1) ? 'active' : ''; 
      $(this.el).html('<div class="spazio"><div class="pull-right toggle '+((active) ? 'active' : '' )+'"><div class="toggle-handle"></div></div><h3>'+this.options.politico.attributes.user+'</h3><div>'+this.options.politico.attributes.info+'</div></div><ul class="table-view custom-table-cell-streched" id="elenco_feed"></ul>');
    }
    var frag = document.createDocumentFragment();
    for (var i = 0; i < feed.length; i++) {
      var item = new FeedListItemView({model: feed[i], politico: this.options.politico});
  		//$('#elenco_feed', self.el).append(item.render().el);
      frag.appendChild(item.render().el);
    }
 		$('#elenco_feed', self.el).append(frag);

    $("#content").off("scroll");
    $("#content").on("scroll" , function () {
      if( !self.isLoading && $("#content").scrollTop() > 0.4 * $("#content ul").height() ) {
        self.model.page += 1; // Load next page
        self.loadPage();
      }
    });
    return this;
  },
  loadPage: function () {
    var self = this;
    self.isLoading = true;
    self.model.fetch({cache: true, expires: 60*5,
      success: function(){
        self.render();
        self.isLoading = false;
    }});
  },
  afterRender: function () { this.delegateEvents(); },
  segui:       function (e) { 
    var peopleBlocked = (window.localStorage.getItem('peopleBlocked')) ? JSON.parse(window.localStorage.getItem('peopleBlocked')) : new Array;
    if ($(e.target).hasClass("active")) {
      // ABILITO, QUINDI LO TOLGO DAI BLOCCATI
      peopleBlocked = _.without(peopleBlocked, this.options.politico.attributes.user_screen);
    } else {
      // DISABILITO, QUINDI LO AGGIUNGO AI BLOCCATI
      peopleBlocked = _.union(peopleBlocked, [this.options.politico.attributes.user_screen]);
    }
    window.localStorage.setItem('peopleBlocked', JSON.stringify(peopleBlocked));
    this.render();
  }
});

window.FeedListItemView = Backbone.View.extend({
  tagName:     "li",
  className:   "table-view-cell media",
  events: {
    "click .tweet_text"   : "share",
    "click .tweet_user"   : "link_people",
    "click .media-object" : "link_people"
  },
  initialize: function (options) {
    this.options = options || {};
    /*INUTILE CHIAMARE IL RENDER QUI, CHI LO USA LO RICHIAMA DIRETTAMENTE*/ //this.render();
  },
  render:      function () { 
 		// PULISCO IL TWEET
    this.model.attributes.tweet_pulito = this.model.attributes.tweet;
    /*
    // HASHTAG
    var regex = /(^|\s)#(\w*[a-zA-Z_]+\w*)/g;
    this.model.attributes.tweet_pulito = this.model.attributes.tweet_pulito.replace(regex, '$1<span class="tweet_mention">#$2</span>');
    // USERS
    var regex = /(^|\s)@(\w*[a-zA-Z_]+\w*)/g;
    this.model.attributes.tweet_pulito = this.model.attributes.tweet_pulito.replace(regex, '$1<span class="tweet_mention">@$2</span>');
    */
    // LINKS (REMOVE FROM TEXT, INSERT AS BUTTON)
    var regex = /\b([a-zA-Z]+:\/\/[\w_.\-]+\.[a-zA-Z]{2,6}[\/\w\-~.?=&%#+$*!]*)\b/i;
    this.model.attributes.tweet_pulito = this.model.attributes.tweet_pulito.replace(regex, "");
    this.model.attributes.link = '';
    var link = this.model.attributes.tweet.match(regex, "");
    if (link != null && this.model.attributes.media == "") {
      this.model.attributes.link = ' <button class="btn btn-outlined btn-negative" onclick="window.open(\''+link[0]+'\', \'_system\');">Link <span class="icon icon-pages"></span></button>';
    }
    // SALTO I TWEET VUOTI ( FATTI SOLO DI LINK ) E SENZA IMMAGINI
    if (this.model.attributes.tweet_pulito == "" && this.model.attributes.media == "") {
      $(this.el).removeClass("table-view-cell");
    } else {
      this.model.attributes.user  = (this.options.politico) ? this.options.politico.attributes.user  : this.model.attributes.user_screen;
      this.model.attributes.thumb = (this.options.politico) ? this.options.politico.attributes.thumb : "";
      $(this.el).html(this.template(this.model.toJSON())); 
    }
    return this; 
  },
  afterRender: function () { this.delegateEvents(); },
  share: function () {
    // AGGIORNO I LIKE
    $.get("http://memefight.net/_tvseriestweet/tweets/like/"+this.model.attributes.id);
    
    var link = 'https://twitter.com/'+this.model.attributes.user_screen+'/status/'+this.model.attributes.id;
    // ESCAPE PER LE VIRGOLETTE
    var tweet_to_share = this.model.attributes.user_screen + ": " + this.model.attributes.tweet.replace(/"/g, "\"") + ' - #TvSeriesTweet';
    // GENERO IL PULSANTE SHARE
    if (window.plugins && window.plugins.socialsharing) {
      window.plugins.socialsharing.share(tweet_to_share, 'Tweet da '+this.model.attributes.user_screen, '', link);
    }
  },
  link_people: function () {
    utils.gotoAnimate('#content', '#people/'+this.model.attributes.user_screen);
  }
});

window.PeopleListView = Backbone.View.extend({
  initialize: function (options) {
      this.options = options || {};
      this.page = 1;
      this.page_length = 10;
      this.render();
  },
  render: function () {
    var self = this;
    var feed = self.model.models;
    
    if (!isNaN(self.options.id)) {
      var item_model = _.findWhere(feed, {id:parseInt(self.options.id)});
      var item = new FeedItemView({model: item_model});
      //console.log(item.model.toJSON());
      $(this.el).html(item.render().el);
    } else {
      if (self.page==1) {
        $(this.el).html('<ul class="table-view custom-table-cell-toggle" id="elenco_feed"></ul>');
      }
      var offset_start = (self.page - 1) * self.page_length;
      var offset_stop  = self.page       * self.page_length;

      var frag = document.createDocumentFragment();
      for (var i = offset_start; i < offset_stop && i < feed.length; i++) {
        var item = new PeopleListItemView({model: feed[i]});
    		//$('#elenco_feed', self.el).append(item.render().el);
        frag.appendChild(item.render().el);
      }
   		$('#elenco_feed', self.el).append(frag);
    }
    $("#content").off("scroll");
    $("#content").on("scroll" , function () {
      if($("#content").scrollTop() > 0.4 * $("#content ul").height() ) {
        self.page += 1; // Load next page
        self.render();
      }
    });
    return this;
  },
  afterRender: function () { this.delegateEvents(); }
});

window.PeopleListItemView = Backbone.View.extend({
    tagName:     "li",
    className:   "table-view-cell",
    events: {
      "toggle .toggle"   : "segui"
    },
    initialize:  function () { /*INUTILE CHIAMARE IL RENDER QUI, CHI LO USA LO RICHIAMA DIRETTAMENTE*/ /*this.render();*/ },
    render:      function () { 
      var peopleBlocked = (window.localStorage.getItem('peopleBlocked')) ? JSON.parse(window.localStorage.getItem('peopleBlocked')) : new Array;
      this.model.attributes.active = (_.indexOf(peopleBlocked, this.model.attributes.user_screen)==-1) ? 'active' : ''; 
      $(this.el).html(this.template(this.model.toJSON())); return this; 
    },
    afterRender: function () { this.delegateEvents(); },
    segui:       function (e) { 
      var peopleBlocked = (window.localStorage.getItem('peopleBlocked')) ? JSON.parse(window.localStorage.getItem('peopleBlocked')) : new Array;
      if ($(e.target).hasClass("active")) {
        // ABILITO, QUINDI LO TOLGO DAI BLOCCATI
        peopleBlocked = _.without(peopleBlocked, this.model.attributes.user_screen);
      } else {
        // DISABILITO, QUINDI LO AGGIUNGO AI BLOCCATI
        peopleBlocked = _.union(peopleBlocked, [this.model.attributes.user_screen]);
      }
      window.localStorage.setItem('peopleBlocked', JSON.stringify(peopleBlocked));
      this.render();
    }
});

window.TrendView = Backbone.View.extend({
    initialize: function (options) {
        this.options = options || {};
        this.render();
    },
    render: function () {
      var self = this;
      
      $(this.el).html('<ul class="table-view" id="elenco_hashtag"></ul><br><ul class="table-view" id="elenco_trending"></ul>');
      $('#elenco_hashtag', self.el).append('<li class="table-view-divider">Popular Hashtags</li>');
      for (var i = 0; i < this.model.attributes.hashtag.length; i++) {
    		$('#elenco_hashtag', self.el).append('<li class="table-view-cell">'+this.model.attributes.hashtag[i]+'</li>');
      }
   		$('#elenco_trending', self.el).append('<li class="table-view-divider">Most used words</li>');
      for (var i = 0; i < this.model.attributes.trending.length; i++) {
    		$('#elenco_trending', self.el).append('<li class="table-view-cell">'+this.model.attributes.trending[i]+'</li>');
      }
      return this;
    },
    afterRender: function () { this.delegateEvents(); }
});


//////////////////////////////
///////    ROUTER     ////////
//////////////////////////////

var AppRouter = Backbone.Router.extend({
	routes: {
	    ""                  : "home",
	    "likes"             : "likes",
	    "people"            : "people",
	    "people/:user_screen" : "people",
	    "top"               : "top",
	    "top/:giorni"       : "top",
	    "trend"             : "trend",
	    "info"              : "info"
	},
	initialize: function () {
    this.headerView = new HeaderView();
    $('#header').html(this.headerView.el);
    
    // ISTANZIO IL MODELLO DEI POLITICI
    if (!this.peopleList)   { this.peopleList   = new PeopleCollection(); }
    if (!this.feedList)     { this.feedList     = new FeedCollection(); }
    if (!this.feedBestList) { this.feedBestList = new FeedBestCollection(); }
    if (!this.feedTopList)  { this.feedTopList  = new FeedTopCollection(); }
    if (!this.trendList)    { this.trendList    = new Trend(); }
	},
  home: function () {
    var self = this;
    
    $("#content").html('<div class="text-center"><img src="images/loading.gif" class="loading" /></div>');

    // RINFRESCO I POLITICI
    self.peopleList.fetch({cache: true, expires: 60*60*12 /* 12 ore */, error: utils.fetchErrorHandler,
      success: function(){  
        self.feedList.page = 1;
        self.feedList.fetch({cache: true, expires: 60*5 /* 5 minuti */, error: utils.fetchErrorHandler,
          success: function(){
            $("#content").html(new FeedListView({model: self.feedList, peopleList: self.peopleList}).el);
        }});
      }
    });

    self.headerView.selectMenuItem('home');
  },
  likes: function () {
    var self = this;
    
    $("#content").html('<div class="text-center"><img src="images/loading.gif" class="loading" /></div>');

    // RINFRESCO I POLITICI
    self.peopleList.fetch({cache: true, expires: 60*60*12 /* 12 ore */ });

    self.feedBestList.page = 1;
    self.feedBestList.fetch({cache: true, expires: 60*60*3 /* 3 ore */, error: utils.fetchErrorHandler,
      success: function(){
        $("#content").html(new FeedBestListView({model: self.feedBestList, peopleList: self.peopleList}).el);
    }});
    self.headerView.selectMenuItem('likes');
  },
  people: function (user_screen) {
    var self = this;

    $("#content").html('<div class="text-center"><img src="images/loading.gif" class="loading" /></div>');

    if (user_screen != undefined) {
      // ELENCO TWEET SINGOLO UTENTE

      // RINFRESCO I POLITICI
      self.peopleList.fetch({cache: true, expires: 60*60*12 /* 12 ore */ });
      
      var feedPeople     = new FeedPeopleCollection({politico:user_screen});
      feedPeople.fetch({cache: true, expires: 60*10 /* 10 minuti */,
        success: function(){
          var politico = (self.peopleList) ? _.findWhere(self.peopleList.models, {id:user_screen}) : "";
          $("#content").html(new FeedPeopleListView({model: feedPeople, politico:politico}).el);
      }});
      self.headerView.selectMenuItem('people');
    } else {
      self.peopleList.fetch({cache: true, expires: 60*60*12 /* 12 ore */,
        success: function(){
          $("#content").html(new PeopleListView({model: self.peopleList}).el);
      }});
      self.headerView.selectMenuItem('people');
    }
  },
  top: function (giorni) {
    var self = this;
    
    $("#content").html('<div class="text-center"><img src="images/loading.gif" class="loading" /></div>');

    if (giorni != undefined) {
      if (!self.feedTopListGiorni)  { self.feedTopListGiorni  = new FeedTopCollection({giorni:giorni}); }
      self.feedTopListGiorni.fetch({cache: true, expires: 60*60*24 /* 24 ore */, error: utils.fetchErrorHandler,
        success: function(){
          $("#content").html(new FeedTopListView({model: self.feedTopListGiorni, peopleList: self.peopleList, giorni:giorni}).el);
      }});
    } else {
      self.feedTopList.fetch({cache: true, expires: 60*60*24 /* 24 ore */, error: utils.fetchErrorHandler,
        success: function(){
          $("#content").html(new FeedTopListView({model: self.feedTopList, peopleList: self.peopleList}).el);
      }});
    }
    self.headerView.selectMenuItem('top');
  },
  trend: function () {
    var self = this;
    
    $("#content").html('<div class="text-center"><img src="images/loading.gif" class="loading" /></div>');

    self.trendList.fetch({cache: true, expires: 60*60*24 /* 24 ore */, error: utils.fetchErrorHandler,
      success: function(){
        $("#content").html(new TrendView({model: self.trendList}).el);
    }});
    self.headerView.selectMenuItem('trend');
  },
  info: function () {
    if (!this.infoView) { this.infoView = new InfoView(); }
    $('#content').html(this.infoView.el);
    this.headerView.selectMenuItem('info');
  }
});



function startEverything () {
  utils.loadTemplate(['HeaderView', 'FeedListItemView', 'PeopleListItemView', 'InfoView'], function() {
    app = new AppRouter();
    Backbone.history.start();
    
    // INIZIALIZZO BARRA FOOTER
    if (Backbone.history.fragment == "") { $('.tab-item_home').addClass('active'); }
    
    // GESTIONE TIMEOUT FETCH: 10 secondi
    $.ajaxSetup({timeout:1000*10});
    
    // GESTIONE SWIPE
    $('#content').hammer({
      swipe_velocity: 0.2,
      drag: false, hold: false, tap: false, transform: false
    }).on("swiperight", function(event) {
      event.gesture.stopDetect();
      if (Backbone.history.fragment == "")            { utils.gotoAnimate("#content", "#info"); }
      else if (Backbone.history.fragment == "info")   { utils.gotoAnimate("#content", "#trend"); }
      else if (Backbone.history.fragment == "trend")  { utils.gotoAnimate("#content", "#top"); }
      else if (Backbone.history.fragment == "top")    { utils.gotoAnimate("#content", "#people"); }
      else if (Backbone.history.fragment == "people") { utils.gotoAnimate("#content", "#likes"); }
      else if (Backbone.history.fragment == "likes")  { utils.gotoAnimate("#content", "#"); }
      else { /* POLITICO */ window.history.back(); }
    }).on("swipeleft", function(event) {
      event.gesture.stopDetect();
      if (Backbone.history.fragment == "")            { utils.gotoAnimate("#content", "#likes"); }
      else if (Backbone.history.fragment == "info")   { utils.gotoAnimate("#content", "#"); }
      else if (Backbone.history.fragment == "people") { utils.gotoAnimate("#content", "#top"); }
      else if (Backbone.history.fragment == "top")    { utils.gotoAnimate("#content", "#trend"); }
      else if (Backbone.history.fragment == "trend")  { utils.gotoAnimate("#content", "#info"); }
      else if (Backbone.history.fragment == "likes")  { utils.gotoAnimate("#content", "#people"); }
      else { /* POLITICO */ window.history.back(); }
    });
    
    app.on("all",function(route, router) {
      // RIPORTO LO SCROLL VERTICALE A ZERO - ELIMINO ANIMAZIONI
      //$('#content').animate({ scrollTop: 0 }, 'fast');
      $('#content').scrollTop(0);
    });
  });
}

function init() {
  //document.addEventListener("deviceready", startEverything, false); 
  $(function() { startEverything(); });
}

window.onload = init;