var PhonegapAudio = function () {
	this.id = null;
	this.preload = "auto";
	this.volume = 1;
	this.currentTime = 0;
	this.paused = true;
	
	this.src = "";
	this._onCompleted = null;
	
	this.my_media = null;
	this._rootPath = "";
	
	this.play = function () {
		var instance = this;
		if (!this.my_media) {
			this._rootPath = getPhoneGapPath();
			if (isBB()) {
				this.my_media = new Audio(this._rootPath + this.src);
				// TODO end event, and loop feature for BB
			} else {
				this.my_media = new Media(this._rootPath + this.src, function() {
					
				}, function (error) {
					alert('code: '    + error.code    + '\n' + 
							'message: ' + error.message + '\n');
				}, function (status) {
					if( status == Media.MEDIA_STOPPED && typeof instance._onCompleted != "undefined") {
						instance._onCompleted(); // replay
						return;
					}
					if (status == Media.MEDIA_STOPPED || status == Media.MEDIA_PAUSED ) {
						instance.paused = true;
					}
				});
			}
		}
		this.my_media.play();
		this.paused = false;
	};
	
	this.pause = function () {
		this._onCompleted = null;
		if (this.my_media) {
			console.log("pausing background music");
			this.my_media.pause();
		}
		this.paused = true;
	};
	
	this.stop = function () {
		this._onCompleted = null;
		if (this.my_media) {
			console.log("stopping background music");
			this.my_media.stop();
		}
		this.paused = true;
	};
	
	this.canPlayType = function (_type) {
		return true;
	};
	
	this.addEventListener = function (eventName, fn, b) {
		if (eventName == "ended") {
			this._onCompleted = fn;
		}
	};
};

Crafty.audio.audioElement = function () {
	if (isAndroid() || isIOS() || isBB()) {
		return new PhonegapAudio();
	} else { // TODO iOS
	    //IE does not support Audio Object
	    return typeof Audio !== 'undefined' ? new Audio("") : document.createElement('audio');
	}
};

var audioRootPath = null;
function getPhoneGapPath(){
	if (!audioRootPath) {
		if (isAndroid()) {
			audioRootPath = '/android_asset/www/';
		} else if (isIOS()) {
			var path = window.location.pathname;
			path = path.substr(0, path.length -10);
			audioRootPath = 'file://' + path;
		} else if (isBB()) {
			audioRootPath = "file://" + blackberry.io.home + "/../app/native/";
		} else { // windows?
			audioRootPath = '';
		}
	}
	return audioRootPath;
}

function isAndroid() {
	return navigator.userAgent.toLowerCase().indexOf("android") >= 0;
}

function isIOS() {
	var agent = navigator.userAgent.toLowerCase();
	return agent.indexOf("iphone") >= 0 ||
			agent.indexOf("ipod") >= 0 ||
			agent.indexOf("ipad") >= 0;
}

function isBB() {
	var agent = navigator.userAgent.toLowerCase();
	return agent.indexOf("bb10") >= 0 ||
			agent.indexOf("blackberry") >= 0 ||
			agent.indexOf("rim") >= 0;
}