﻿//
//クラスをここに宣言
//

var Ship = Class.create(Sprite, {
    initialize: function (x, y) {
        Sprite.call(this, STANDARD_WIDTH, STANDARD_HEIGHT);

        this.image = game.assets[UFO0_IMAGE];

        this.x = x;
        this.y = y;

        this.frame = 0;


    },

    onenterframe: function () {
        
        // padの処理とは別れてしまうが、ここで移動処理を行う。
        // padと一緒にやると、キーをずっと押すとスピードが上がることがあるから。
        var input = game.input;
        switch (true) {
            case input.left:
                this.x -= 6; break;
            case input.right:
                this.x += 6; break;
            case input.up:
                this.y -= 6; break;
            case input.down:
                this.y += 6; break;
        }
        // 移動処理２ 加速度
        if (accX || accY) { // 0 false "" '' undefined null はじかれる
            this.x -= accX;
            this.y += accY;
        }
        /*
        if (input.left) this.x -= 6;
        else if (input.right) this.x += 6;
        else if (input.up) this.y -= 6;
        else if (input.down) this.y += 6;
        */
        if (this.x < Math.abs(stage.x)) {
            this.x = Math.abs(stage.x);
        } else if (this.x > Math.abs(stage.x) + SCREEN_WIDTH - this.width) {
            this.x = Math.abs(stage.x) + SCREEN_WIDTH - this.width;
        }
        if (this.y < 0) {
            this.y = 0;
        } else if (this.y > SCREEN_HEIGHT - this.height) {
            this.y = SCREEN_HEIGHT - this.height;
        }

        if (this.age % 8 === 0) {
            if (this.frame == 4) {
                this.frame = 0;
            } else {
                this.frame++;
            }
        }

        //無敵時間中か    
        if (isInv && this.age % game.fps === 0) {
            isInv = false;
        }
    }
});

var Explode = Class.create(Sprite, {
    initialize: function (x, y) { //初期化する
        Sprite.call(this, 16, 16); //Spriteオブジェクトを初期化
        this.image = game.assets[EFFECT0_IMAGE];
        this.x = x;
        this.y = y;
        this.frame = 0;
        stage.addChild(this);
    },

    onenterframe: function () {
        this.scaleX *= 1.1;
        this.scaleY *= 1.1;
        if (this.age % 4 === 0) {
            if (this.frame < 4) {
                this.frame++;
            } else {
                stage.removeChild(this);
            }
        }
    }
});

var Item = Class.create(Sprite, {
    initialize: function (x, y) {
        Sprite.call(this, 16, 16);
        this.image = game.assets[ITEM_IMAGE];
        this.x = x;
        this.y = y;
    },
    onenterframe: function () {
        var move = new enchant.Event("move");
        this.dispatchEvent(move);
        if (this.intersect(ship)) {
            var e = new enchant.Event("hit");
            this.dispatchEvent(e);
        }

        if (this.x < 0) {
            this.parentNode.removeChild(this);
        }
    }
})

var Grape = Class.create(Item, {
    initialize: function () { //初期化する
        Item.call(this); //Spriteオブジェクトを初期化
        this.frame = 0;
        this.x = Math.abs(stage.x) + SCREEN_WIDTH;
        this.y = Math.random() * SCREEN_HEIGHT;
    },

    onhit: function () {
        var label = new FadeLabel("+10");
        label.moveTo(this.x - Math.abs(stage.x), this.y);
        scene.addChild(label);
        scoreLabel.score += 10;
        this.parentNode.removeChild(this);
    },

    onmove: function () {
        this.x -= 2;
    }
});

var Heart = Class.create(Item, {
    initialize: function () {
        Item.call(this); //Spriteオブジェクトを初期化
        this.frame = 1;
        this.x = Math.abs(stage.x) + SCREEN_WIDTH;
        this.y = Math.random() * SCREEN_HEIGHT;
    },
    onhit: function () {
        var label = new FadeLabel("LIFEUP!");
        label.moveTo(this.x - Math.abs(stage.x), this.y);
        scene.addChild(label);
        lifeLabel.life += 1;
        this.parentNode.removeChild(this);
    },
    onmove: function () {
        this.x -= 2;
    }

});

var Bom = Class.create(Item, {
    initialize: function () {
        Item.call(this); //Spriteオブジェクトを初期化
        this.image = game.assets[BOM_IMAGE];
        this.frame = 0;
        this.x = ship.x;
        this.y = 0;
    },
    onhit: function () {

        lifeCheck();
        this.parentNode.removeChild(this);
    },
    onmove: function () {
        this.y += 4;
        this.x += movespeed;
        if (this.age % 2 === 0) {
            if (this.frame == 0) {
                this.frame = 1;
            } else if (this.frame == 1) {
                this.frame = 0;
            }
        }
    }
});