﻿// enchant.js　使用の準備
enchant();

//
//メインの処理
//
window.onload = function () {
    game = new Game(SCREEN_WIDTH, SCREEN_HEIGHT);
    game.fps = 32;
    console.log(game.fps);
    game.preload(ASSETS);
    game.onload = function () {
        //sceneを作る。
        startscene = game.rootScene;
        startscene.backgroundColor = "black";

        var title = new Sprite(320, 90);
        title.image = game.assets[TITLE_IMAGE];
        startscene.addChild(title);
        var btnstart = new Button("スタート", "blue");
        btnstart.width = 100;
        btnstart.ontouchstart = function () {
            game.pushScene(scene);
        };
        btnstart.moveTo(SCREEN_WIDTH / 2 - btnstart.width / 2, 100);
        startscene.addChild(btnstart);
        
        endscene = new Scene();

        var gameover = new Sprite(320, 90);

        gameover.image = game.assets[GAMEOVER_IMAGE];
        endscene.addChild(gameover);

        var btnretry = new Button("リトライ", "blue");
        btnretry.width = 100;
        btnretry.ontouchstart = function () {
            game.pushScene(scene);
            stageInit();
        };
        btnretry.moveTo(SCREEN_WIDTH / 2 - btnretry.width / 2, 100);
        endscene.addChild(btnretry);

        scene = new Scene();
        // シーンの色を変更
        scene.backgroundColor = "black";

        // いろいろな初期化。

        //背景。
        background = new Sprite(1520, 320);
        background.image = game.assets[BACKGROUND_IMAGE];
        background.moveTo(0, 0);
        background.on("enterframe", function () {

            this.x -= 0.3;
            if (this.x <= -(1520 - SCREEN_WIDTH)) {
                background.moveTo(0, 0);
            }

        });
        scene.addChild(background);

        //ステージ。
        //ここの中にPlayerとかMapとかが入る。
        stage = new Group();
        stage.x = -SCREEN_WIDTH + 1;
        scene.addChild(stage);

        //map用ステージ。
        map0stage = new Group();
        stage.addChild(map0stage);
        //mapその１
        map0 = new Map(16, 16);
        map0.image = game.assets[STAGE_IMAGE];
        map0stage.x = 0;
        map0stage.addChild(map0);

        map1stage = new Group();
        stage.addChild(map1stage);

        //mapその２
        map1 = new Map(16, 16);
        map1.image = game.assets[STAGE_IMAGE];
        map1stage.x = SCREEN_WIDTH;
        map1stage.addChild(map1);

        //宇宙船
        ship = new Ship(SCREEN_WIDTH + 30, BLOCK_HEIGHT * 9);
        stage.addChild(ship);

        //UI
        //ライフ表示
        lifeLabel = new LifeLabel(SCREEN_WIDTH - (16 * 8), 0, 3);
        lifeLabel.life = 3;
        scene.addChild(lifeLabel);
  
        //スコア表示
        scoreLabel = new ScoreLabel(0, 0);
        scoreLabel.score = 0;
        scene.addChild(scoreLabel);

        map0.loadData(setupStage(0)); //別にしなくてもいい。
        map1.loadData(setupStage(3));

        stageInit();

        //シーンのイベント
        stage.on("enterframe", function () {

            // ダメージによる無敵状態ではないか
            if (isInv == false) {
                mapHitTest(0);
                mapHitTest(1);
            }
            if (this.age % STAR_INTERVAL === 0) itemCreate();

            //レベルアップ
            if (levelcount === LEVEL_UP) {
                levelcount = 0;
                if (level < 4) {
                    level++;
                    movespeed++;
                    levelUpLabel();
                }
                
            } else {
                levelcount++;
            }
            //マップを動かす
            
            stage.x -= movespeed;
            ship.x += movespeed;
            mapCreate();
        });




    };

    //ゲームを開始
    game.start();
};

