jQuery(document).ready(TaxiFareFinder);

    $(document).ready(function() {
		$('.no-show').hide();
	$('#bookfrom,#bookfrom1').click(function(){	
		$which = "from";
 		$('#swapa').insertBefore('#swapb');	
		$('#swapal').html('Pickup :');
		$('#swapbl').html('Drop : <span class="blue_color">( Full Address )</span>');
		$('.no-show').show();
		$('#adate').html('Arrival Date :');
		$('#ftime').html('Landing Time :');
		$('#whichform').val('Pickup');
		$('#titlebar').html('Airport Pick-Up <span class="blue_color"> ( Flying In )</span>');
	});
	$('#bookto,#bookto1').click(function() {
		$which = "to";
 		$('#swapb').insertBefore('#swapa');
		$('#swapbl').html('Pickup :');
		$('#swapal').html('Drop : <span class="blue_color">( Full Address )</span>');
		$('#whichForm').val('Dropoff');
		$('.no-show').hide();
		$('#adate').html('Travel Date :');
		$('#ftime').html('Travel Time :');
		$('#titlebar').html('Airport Drop-Off <span class="blue_color"> ( Flying Out )</span>');
	});
		
        $('.vehicle-type').click(function() {
            veh=$(this).attr('value');
			vehicle=$(this).attr('name');
			$vehicletype=$(this).attr('id');
			$('#totalone').attr('value',$vehicletype);
			
			if($vehicletype == "Saloon")
			{
var options = [
	{text: "One Passenger", value: 1},
	{text: "Two Passengers", value: 2},
	{text: "Three Passengers", value: 3},
	{text: "Four Passengers", value: 4}
];
var luggage_options = [
	{text: "One Suitcase", value: 1},
	{text: "Two Suitcases", value: 2}
];				
			}
			else if($vehicletype == "Estate")
			{
	var options = [
	{text: "One Passenger", value: 1},
	{text: "Two Passengers", value: 2},
	{text: "Three Passengers", value: 3},
	{text: "Four Passengers", value: 4}
];	
var luggage_options = [
	{text: "One Suitcase", value: 1},
	{text: "Two Suitcases", value: 2},
	{text: "Three Suitcases", value: 3},
	{text: "Four Suitcases", value: 4}
];				
			}
			else if($vehicletype == "MPV")
			{
	var options = [
	{text: "One Passenger", value: 1},
	{text: "Two Passengers", value: 2},
	{text: "Three Passengers", value: 3},
	{text: "Four Passengers", value: 4},
	{text: "Five Passenger", value: 5},
	{text: "Six Passengers", value: 6},
	{text: "Seven Passengers", value: 7},
	{text: "Eight Passengers", value: 8}
];
var luggage_options = [
	{text: "One Suitcase", value: 1},
	{text: "Two Suitcases", value: 2},
	{text: "Three Suitcases", value: 3},
	{text: "Four Suitcases", value: 4},
	{text: "Five Suitcases", value: 5},
	{text: "Six Suitcases", value: 6},
	{text: "Seven Suitcases", value: 7},
	{text: "Eight Suitcases", value: 8}
];				
			}
			else if($vehicletype == "Executive")
			{
	var options = [
	{text: "One Passenger", value: 1},
	{text: "Two Passengers", value: 2},
	{text: "Three Passengers", value: 3},
	{text: "Four Passengers", value: 4}
];
var luggage_options = [
	{text: "One Suitcase", value: 1},
	{text: "Two Suitcases", value: 2}
];				
			};
		$.fn.replaceOptions = function(options) {
    var self, $option;

    this.empty();
    self = this;

    $.each(options, function(index, option) {
      $option = $("<option></option>")
        .attr("value", option.value)
        .text(option.text);
      self.append($option);
    });
  };
$('#passengers').replaceOptions(options);
$('#cases').replaceOptions(luggage_options);	
			
        });


		
    });

/**
 * This class is the driver class of a taxi fare estimator. It creates:
 * 1) Input fields where the user enters their taxi route origin and 
 *    destination.
 * 2) A button the user clicks to show their estimated taxi fare. 
 * 3) A map (via Google Maps API) that shows the taxi route from origin to
 *    destination.
 * 4) An output field that shows the estimated taxi fare and route distance (or 
 *    an error message if a valid route origin or destination has not been
 *    provided).
 * 5) A fare calculator that computes an estimate of the taxi route fare based
 *    on the route distance.
 *
 * This class makes use of the jQuery library and Google Maps API. 
 */
function TaxiFareFinder() {
    
    // Origin input field.
    var originInput;
    
    // Destination input field.
    var destinationInput;

    // Button shown to user.
    var showFareButton;
    
    // Map of route.
    var mapOutput;
    
    // Fare output field.
    var fareOutput;
    
    // Estimates the taxi fare for travelling a certain route.
    var fareCalculator;
   
    // Initialize the input/output fields with the loaded configurable values.
    jQuery.ajax({
        type: 'GET',
        url: 'xml/strings.xml',
        dataType: 'xml',
        success: initialize
    });

    
    /**
     * Initializes the taxi route origin and destination input fields, the "show
     * fare" button, the map and message output fields, and the fare calculator 
     * object.
     *
     * @param xml XML received via AJAX GET request.
     */     
    function initialize(xml) {        
        originInput = new InputField(
            jQuery('#origin-input'), 
            jQuery(xml).find('#origin_input_placeholder').text()
        );

        destinationInput = new InputField(
            jQuery('#destination-input'), 
            jQuery(xml).find('#destination_input_placeholder').text()
        );       
              
        showFareButton = jQuery('#show-fare-button').text(jQuery(xml)
                .find('#show_fare_button_value').text());
        
        fareOutput = new OutputField(
            jQuery('#fare-output'),
            {
                hidden: 'js-hidden',
                error: 'error',
                totalFare: 'total-fare'
            }
        );
        
        
                
        fareCalculator = new FareCalculator(
            originInput,
            destinationInput,
            showFareButton,
            fareOutput,
            {
                baseRate: new Decimal(parseFloat(jQuery(xml)
                        .find('#fare_base_rate').text()), 2),
                distanceUnit: new Decimal(parseFloat(jQuery(xml)
                        .find('#fare_distance_unit').text()), 3),
                ratePerDistanceUnit: new Decimal(parseFloat(jQuery(xml)
                        .find('#fare_rate_per_distance_unit').text()), 2),
						
            }
			
        );
    }  
}


/**
 * This class represents an input field. This field displays placeholder text 
 * when empty.
 *
 * This class makes use of the jQuery library. 
 *
 * @param {jQuery} element The input field element.
 * @param {String} placeholder This input field's placeholder text.
 */
function InputField(element, placeholder) {

    // This input field's last recorded value.
    var oldValue = new String();

    showPlaceholder();
    
    element.focus(updateOnFocus).blur(updateOnBlur); 
   
      
    /**
     * Returns the input field element.
     * 
     * @return {jQuery} The input field element.
     */   
    this.getElement = function() {
        return element;
    }


    /**
     * Returns this input field's placeholder text.
     * 
     * @return {String} This input field's placeholder text.
     */     
    this.getPlaceholder = function() {
        return placeholder;
    }

    
    /**
     * Returns this input field's last recorded value.
     * 
     * @return {String} This input field's last recorded value.
     */     
    this.getOldValue = function() {
        return oldValue;
    }
    
    
    /**
     * Sets this input field's last recorded value to a new value.
     * 
     * @param {String} newValue The new value to set this field's last recorded
     *         value to.
     */             
    this.setOldValue = function(newValue) {
        oldValue = newValue;
    }
    
    
    /**
     * Shows this input field's placeholder text.
     */
    function showPlaceholder() {
        element.val(placeholder).addClass('placeholder');
    }


    /**
     * Hides this input field's placeholder text.
     */    
    function hidePlaceholder() {
        element.val('').removeClass('placeholder');
    } 
    
    
    /**
     * Checks if the field's placeholder text is showing, and hides it if it 
     * is.
     */           
    function updateOnFocus() {
        if(element.val() == placeholder && element.hasClass('placeholder')) {
            hidePlaceholder();
        } 
    }


    /**
     * Checks if this input field's value is empty, and shows its placeholder 
     * text if it is.
     */    
    function updateOnBlur() {
        if(element.val() == '') {
            showPlaceholder();
            oldValue = '';            
        } 
    }   
}



function MapDisplay(
    element,     
    originInput, 
    destinationInput, 
    showFareButton,
    fareOutput,
    center,
    mapProperties,
    errorMessage,
    errorClass
) {      
    
    // Geocoder for coding addresses.
    var geocoder = new google.maps.Geocoder();

    // DirectionsService used to find directions between origin and destination.
    var directionsService = new google.maps.DirectionsService();
    
    // Array of (uncoded) addresses provided by user.
    var addresses = new Array();
    
    // Array of coded addresses ready to be shown on map.
    var codedAddresses = new Array();

 
    
    showFareButton.bind('click', updateContent);
    

}



function OutputField(element, stylingClasses) {
    
    // Hide element and remove class that first hid it (to avoid flickering). 
    element.hide();
    element.removeClass(stylingClasses.hidden);

    // Total fare.
    var totalFare;
    
    // Total taxi route distance.
    var totalDistance;
    
    // Message to display.
    var message;
    
    // Styling class to apply to the message output element. 
    var messageClass;
    
    
    /**
     * Shows the total taxi fare and total taxi route distance.
     * 
     * @param {String} newTotalFare Total taxi fare to display.
     * @param {String} newTotalDistance Total taxi route distance to display.
     */
    this.showFare = function(newTotalFare, newTotalDistance) {
        totalFare = newTotalFare;
        totalDistance = newTotalDistance;
        
        showOutputField(makeFareMessage);
    }


    /** 
     * Reveals the output field showing a message to the user.
     *
     * @param {String} newMessage The message to show the user.
     * @param {String} newMessageClass the class to add to the output field
     *         element.
     */
    this.showMessage = function(newMessage, newMessageClass){
        message = newMessage;
        messageClass = newMessageClass;
        
        showOutputField(makeMessage);
    }
    
    
    /**
     * Makes message to show the user by adding the message content and class to
     * the output element.
     */
    function makeMessage() {
        element.html(message);
        element.addClass(messageClass);
    }

    
    /**
     * Makes message that shows the total taxi fare estimate and total taxi
     * route distance.
     */
    function makeFareMessage() {
    
        // Document fragment to which all text/HTML is appended.
		
        var fragment = document.createDocumentFragment();
    	
        // Display element containing the total taxi fare amount.
        var totalFareOutput = jQuery('<strong>').text("Total Fare = " + totalFare)
                .addClass(stylingClasses.totalFare);
		$('#total').val(totalFare);
        // Display element containing the total taxi route distance.
        var totalDistanceOutput = jQuery('<p>').text(totalDistance );
		
		
        
        fragment.appendChild(totalFareOutput[0]);
        fragment.appendChild(totalDistanceOutput[0]);
        document.getElementById('disappear').style.display="none";
        element.empty();
        element[0].appendChild(fragment);
        
        // Remove "error" message styling class if output element has it.
        if(element.hasClass(stylingClasses.error)) {
            element.removeClass(stylingClasses.error);
        }
    }
    
    /**
     * Reveals the output field to the user.
     *
     * @param {function} action The function to carry out upon fading out the
     *         output field so that it is completed by the time the output field
     *         fades in again (e.g. the given function could change the output
     *         field text while it is not yet visible to the user).
     */
    function showOutputField(action) {
        element.fadeOut(action);
        element.fadeIn();
    }    
}


/**
 * This class represents a taxi fare calculator. It receives the taxi route
 * origin and destination from two input fields when the "show fare" button is 
 * pressed. It calculates the total taxi route distance and outputs the fare 
 * estimate based on that distance.
 *
 * This class makes use of the jQuery library and Google Maps API.
 * 
 * @param {InputField} originInput The input field where the taxi route origin 
 *         is entered.
 * @param {InputField} destinationInput The input field where the taxi route 
 *         destination is entered. 
 * @param {jQuery} showFareButton The button that, when clicked, displays both 
 *         the the estimated taxi fare and the taxi route from the origin to the
 *         destination.
 * @param {jQuery} fareOutput The output field that shows the taxi fare 
 *         estimate.
 * @param {Number} fare An associative array of values used to calculate the 
 *         taxi fare. Includes:
 *         1) baseRate: The base fare for the first unit of distance traveled by
 *                    taxi.
 *         2) distanceUnit: The unit of distance (e.g. a certain number of 
 *                    meters) to which the rate per distance unit applies.
 *         3) RatePerDistanceUnit: The fare rate charged per distance unit
 *                    travelled by taxi.
 */
function FareCalculator(
    originInput,
    destinationInput,
    showFareButton,
    fareOutput,
    fare
) {    
    
    // DirectionsService used to find directions between origin and destination.
    var directionsService = new google.maps.DirectionsService();
    
    // Total taxi route distance.
    var totalDistance;
    
    // Total taxi route distance minus first distance unit (has different fare).
    var distanceOverBase;
    
    // Fare per unit of distance.
    var distanceFare;
    
    // Total fare.
    var totalFare;
    
    showFareButton.bind('click', updateContent);
    
    
    /**
     * Updates the fare output field content and shows the field to the user.
     */
    function updateContent() {

        // Request to get directions between origin and destination.
        var request = {
            origin: originInput.getElement().val(),
            destination: destinationInput.getElement().val(),
            travelMode: google.maps.DirectionsTravelMode.DRIVING       
        };
        
        // Calculate total fare and show it along with the total route distance.
        directionsService.route(request, function(response, status) {
            if (status == google.maps.DirectionsStatus.OK) {
                totalDistance = new Decimal(
                    response.routes[0].legs[0].distance.value / 1609.344, 
                    3
                );
                
                distanceOverBase = new Decimal(
                    totalDistance - fare.distanceUnit, 
                    3
                );                
               
                distanceFare = new Decimal(
                    fare.ratePerDistanceUnit * 
                            Math.ceil(distanceOverBase / fare.distanceUnit), 
                    2
                );
 
                totalFare = new Decimal(fare.baseRate + distanceFare*veh, 2);

                fareOutput.showFare(
                    totalFare.toCurrency('£'), 
                    totalDistance.toDistance(' miles')
                );
            }
        });
    }
}


/**
 * This class represents a decimal number with a specified number of decimal 
 * places.
 *
 * @param {Number} amount The value to convert to a Decimal object.
 * @param {Number} decimalPlaces The number of decimal places this Decimal 
 *         object should have.
 */
var Decimal = function(amount, decimalPlaces) {
    this.amount = amount;
    this.decimalPlaces = decimalPlaces;
}
    

/**
 * Returns primitive value of Decimal object with given decimal accuracy.
 */ 
Decimal.prototype.valueOf = function() {
    var scale = 1;
        
    for(var i = 0; i < this.decimalPlaces; i++) {
        scale *= 10;
    }

    return Math.floor(this.amount * scale) / scale;
}


/**
 * Converts Decimal value to currency format.
 *
 * @param {String} unitPrefix The unit prefix to add to the returned currency
 *         amount string. 
 * @return {String} The given value as an amount of currency (i.e. as a decimal 
 *         with the given currency unit prefix).
 */
Decimal.prototype.toCurrency = function(unitPrefix) {
    return unitPrefix + Number(this).toFixed(2);
}


/**
 * Converts Decimal value to distance format.
 *
 * @param {String} unitSuffix The unit suffix to add to the returned distance 
 *         amount string. 
 * @return {String} The given amount as a distance (i.e. as a decimal with the
 *         given distance unit suffix).
 */
Decimal.prototype.toDistance = function(unitSuffix) {
    return Number(this).toFixed(3) + unitSuffix;
}