(function() {
    'use strict';
    
    // Global audio list object
    var audio_list = {};
    
    // See what audio format can be played
    function getAudioType() {
        var audio = new Audio();
        if (audio.canPlayType) {
            // CanPlayType returns maybe, probably, or an empty string.
            if (audio.canPlayType('audio/mpeg;') !== '') {
                return('mp3');
            } else if (audio.canPlayType('audio/ogg; codecs="vorbis"') !== '') {
                return("ogg");
            }
        }
        return false;
    }
    
    // Stop all audio playing
    function doStop() {
        for (var audio in audio_list) {
            audio_list[audio].pause();
        }
    }
    
    // Play the note associated with a particular button
    function playNote(event) {
        // Stop other notes playing first
        doStop();
        
        var id = event.target.id;
        var audio = audio_list[id];
        if (audio.currentTime) {
            audio.currentTime = 0;
        }
        audio.play();
    }
    
    var audiotype = getAudioType();
    if (!audiotype) {
        document.getElementById('container').innerHTML = '<p>Sorry, this doesn\'t work on your device.</p>';
    } else {
        //var onpress = ('createTouch' in document) ? 'ontouchstart' : 'onmousedown';
        var note_list = document.querySelectorAll('.note');
        for (var i = 0, len = note_list.length; i < len; i++) {
            var id = note_list[i].id;
            audio_list[id] = new Audio();
            audio_list[id].src = 'audio/' + id + '.' + audiotype;
            audio_list[id].load();
            
            // Repeat the note - this is more reliable than the loop property
            audio_list[id].addEventListener('ended', function() {
                this.currentTime = 0;
                this.play();
            }, false);
            
            note_list[i].onclick = playNote;
        }
        
        document.getElementById('stop').onclick = doStop;
    }
    
})();

