var units = {
	"Length": {
		"Inches to Centimetres": 2.54,
		"Centimetres to Inches": 0.39,
		"Inches to Millimetres": 25.40,
		"Millimetres to Inches": 0.04,
		"Feet to Metres": 0.31,
		"Metres to Feet": 3.28,
		"Yards to Metres": 0.91,
		"Metres to Yards": 1.09,
		"Miles to Kilometres": 1.61,
		"Kilometres to Miles": 0.62
	},
	"Area": {
		"Square Inches to Square Centimetres": 6.451,
		"Square Centimetres to Square Inches": 0.15,
		"Square Feet to Square Metres": 0.09,
		"Square Metres to Square Feet": 10.76,
		"Square Yards to Square Metres": 0.84,
		"Square Metres to Square Yards": 1.20,
		"Square Miles to Square Kilometres": 2.59,
		"Square Kilometres to Square Miles": 0.39,
		"Acres to Hectares": 0.40,
		"Hectares to Acres": 2.47
	},
	"Volume": {
		"Cubic Inches to Cubic Centimetres": 16.39,
		"Cubic Centimetres to Cubic Inches": 0.06,
		"Cubic Feet to Cubic Metres": 0.03,
		"Cubic Metres to Cubic Feet": 35.32,
		"Cubic Yards to Cubic Metres": 0.76,
		"Cubic Metres to Cubic Yards": 1.31,
		"Cubic Inches to Litres": 0.02,
		"Litres to Cubic Inches": 61.03,
		"Gallons to Litres": 4.55,
		"Litres to Gallons": 0.22,
		"US Gallons to Litres": 3.79,
		"Litres to US Gallons": 0.26,
		"Fluid Ounces to Cubic Millilitres": 3.77,
		"Cubic Millilitres to Fluid Ounces": 0.03
	},
	"Weight": {
		"Ounces to Grams": 28.35,
		"Grams to Ounces": 0.04,
		"Pounds to Kilograms": 0.45,
		"Kilograms to Pounds": 2.21,
		"Long Tons to Tonnes": 1.02,
		"Tonnes to Long Tons": 0.98,
		"Short Tons to Tonnes": 0.91,
		"Tonnes to Short Tons": 1.10
	}
}

$(document).ready(function() {
	$.each(units, function(key, val) {
		$("#group").append('<option>'+key+'</option>');
	});

	$("#group").change(function() {
		var group = $(this).val();
		$("#unit").html('<option disabled selected>Select units</option>');
		$.each(units[group], function(key, val) {
			$("#unit").append('<option>'+key+'</option>');
		});
		$("#unit").show();
	});

	$("#unit").change(function() {
		$("input").show();
	});

	$("input").keyup(function() {
		var unit = $("#unit").val();
		var group = $("#group").val();
		var num = $(this).val();

		if(num == 0 || num == "") {
			$("#out").hide();
		}
		else {
			$("#out").text(num*units[group][unit]);
			$("#out").show();
		}
	});
});