/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Typeface  of The Monotype Corporation plc. Data  of The Monotype Corporation
 * plc/Type Solutions Inc. 1990-91-92 All rights reserved. Portions  1992
 * Microsoft Corp. All rights reserved.
 * 
 * Trademark:
 * Monotype Old English  Trademark of The Monotype Corporation plc registered in
 * the US Pat & TM Off. and elsewhere.
 * 
 * Description:
 * There are two main kinds of what people tend to call Gothic letters: the German
 * Frakturs and the English Blackletter. The Frakturs have an x that looks like an
 * r with a mysterious disease, and the Blackletters have fiddly bits in the middle
 * like those you see in this Old English Text. Little is known about the history
 * of Old English Text, provided here by Monotype Typography, but it has been
 * beautifully made. It looks remarkably like the famous Cloister Black designed by
 * Morris Fuller Benton in 1904.
 * 
 * 
 * Manufacturer:
 * Monotype Typography
 * 
 * Vendor URL:
 * http://www.monotype.com/html/mtname/ms_welcome.html
 * 
 * License information:
 * http://www.monotype.com
 */
Cufon.registerFont({"w":183,"face":{"font-family":"Old English Text MT","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"3 4 9 2 4 5 8 3 8 6","ascent":"288","descent":"-72","cap-height":"3","bbox":"-2 -267.042 358 78.011","underline-thickness":"17.9297","underline-position":"-27.0703","unicode-range":"U+0020-U+007E"},"glyphs":{" ":{"w":91},"!":{"d":"47,-66v-5,-61,-10,-103,-28,-141r32,-33r31,33v-15,30,-24,76,-28,141r-7,0xm51,0r-27,-27r27,-27r27,27","w":101},"\"":{"d":"71,-243v1,44,-4,78,-17,117r-8,0v-15,-39,-19,-72,-18,-117r43,0xm155,-243v1,44,-4,78,-17,117r-8,0v-15,-39,-19,-72,-18,-117r43,0","w":198},"#":{"d":"14,-176r56,0r14,-69r29,0r-15,69r67,0r15,-69r29,0r-15,69r32,0r0,29r-38,0r-12,58r50,0r0,29r-55,0r-15,68r-29,0r15,-68r-67,0r-14,68r-30,0r15,-68r-32,0r0,-29r38,0r12,-58r-50,0r0,-29xm93,-147r-12,57r67,0r12,-57r-67,0","w":240},"$":{"d":"10,-165v0,-47,30,-74,76,-78r0,-15r19,0r0,15v16,3,33,8,51,16r-14,32r-37,-11r0,67r45,-24v16,17,23,38,23,62v0,52,-32,73,-68,101r0,31r-19,0r0,-35r-76,-21r20,-32r56,15r0,-78r-42,21v-21,-23,-34,-32,-34,-66xm86,-211r-39,-11v-24,42,-1,80,29,98r10,-5r0,-82xm129,-30v29,-27,20,-93,-14,-106r-10,5r0,95"},"%":{"d":"106,12r-23,0r160,-256r23,0xm93,-243v52,10,68,82,25,115v-6,5,-14,10,-25,16v-42,-10,-68,-62,-37,-101v10,-12,21,-23,37,-30xm110,-135v27,-34,1,-77,-33,-84v-29,33,-3,77,33,84xm261,-132v50,12,68,81,25,115v-6,5,-14,11,-25,17v-41,-11,-68,-62,-37,-102v10,-13,21,-23,37,-30xm278,-24v27,-33,2,-77,-33,-83v-29,33,-3,77,33,83","w":353},"&":{"d":"216,0v-41,-2,-52,-22,-70,-54r-78,54r-53,-81r85,-55v-12,-25,-30,-46,-38,-75v1,-12,13,-17,22,-21r81,-34v16,7,32,26,30,49v-4,40,-22,41,-55,64r37,67r53,-37v16,11,21,18,41,16v0,24,-44,38,-65,10r-25,18v13,39,49,52,86,42v-3,21,-26,38,-51,37xm131,-241v-19,1,-30,19,-18,40r23,41v17,-10,28,-17,29,-39v1,-18,-18,-42,-34,-42xm99,-31r43,-30r-38,-68r-48,31","w":285},"'":{"d":"71,-243v1,44,-4,78,-17,117r-8,0v-15,-39,-19,-72,-18,-117r43,0","w":100},"(":{"d":"113,-259v-79,52,-81,263,0,318r-4,6v-76,-41,-127,-168,-66,-261v16,-24,38,-48,67,-69","w":119},")":{"d":"7,59v80,-56,80,-265,0,-318r3,-6v78,47,127,162,69,259v-17,29,-40,53,-68,71","w":119},"*":{"d":"96,-189v3,27,8,39,17,55r-21,22r-21,-22v8,-13,13,-31,17,-55v-18,8,-35,20,-46,33r-28,-13r15,-28v17,6,36,4,57,0v-19,-17,-24,-23,-46,-33r4,-30r31,6v2,22,7,32,17,53v11,-21,16,-38,17,-53r30,-6r5,30v-21,8,-30,18,-46,33v21,4,41,6,57,0r15,28r-29,13v-7,-9,-22,-20,-45,-33"},"+":{"d":"23,-134r81,0r0,-81r32,0r0,81r81,0r0,32r-81,0r0,81r-32,0r0,-81r-81,0r0,-32","w":240},",":{"d":"24,25v24,-13,22,-40,0,-53r26,-26r26,25v-6,28,-23,49,-48,61","w":101},"-":{"d":"59,-104r61,0r0,23r-61,0r0,-23","w":142},".":{"d":"50,0r-26,-27r26,-27r27,27","w":101},"\/":{"d":"32,12r-23,0r160,-256r23,0","w":201},"0":{"d":"98,0v-76,-13,-115,-117,-66,-189v15,-24,34,-41,58,-54v72,17,110,116,64,187v-14,22,-32,41,-56,56xm125,-34v39,-42,24,-125,-17,-153v-15,-10,-31,-19,-49,-24v-55,63,-6,172,66,177"},"1":{"d":"73,-175v3,-30,-17,-44,-33,-25r-5,-6r44,-37v20,8,30,20,31,46r2,156v2,4,7,8,14,13v8,-4,17,-23,24,-10r-46,38r-43,-28r12,-16r0,-131"},"2":{"d":"146,0v-49,-21,-90,-16,-135,-1v5,-79,117,-89,119,-176v0,-17,-6,-31,-19,-42r-73,56r-25,-25r73,-55r85,51v16,100,-98,98,-139,161v41,-22,102,-20,144,-3"},"3":{"d":"118,-199v0,-22,-13,-24,-27,-14r-48,35r-23,-24r57,-41r83,36v6,40,-20,62,-47,75v47,5,80,58,43,95v-14,14,-41,26,-79,37r-70,-54r25,-26r78,61v42,-36,11,-126,-60,-106v1,-4,-3,-13,3,-12v39,0,65,-23,65,-62"},"4":{"d":"105,-243v45,6,25,85,29,134r36,0r7,31r-43,0r0,37v11,5,23,12,31,0r5,6r-42,35r-42,-26v12,-9,12,-30,11,-52r-83,0r-7,-34xm97,-109v-4,-32,10,-81,-10,-98r-72,98r82,0"},"5":{"d":"118,-21v48,-39,13,-113,-39,-121r-52,35r21,-133r109,0r-13,34r-93,0r-14,82r75,-50v53,18,80,89,38,138v-14,18,-38,30,-71,36r-67,-40r25,-28"},"6":{"d":"93,0v-88,-15,-108,-144,-43,-203v15,-14,29,-29,45,-40r66,31r-25,31r-65,-30v-19,27,-29,59,-26,100r79,-53v44,12,65,69,35,110v-14,20,-36,37,-66,54xm46,-102v10,36,40,63,81,69v37,-38,7,-92,-36,-99"},"7":{"d":"145,-206v-52,2,-112,-10,-124,32r-9,0r33,-66r132,0r0,9v-51,57,-81,118,-87,214r-49,17v12,-103,45,-135,104,-206"},"8":{"d":"18,-156v0,-41,25,-55,57,-87v48,-3,90,12,90,48v0,24,-17,36,-37,50v25,8,44,27,44,54v0,51,-31,57,-77,91v-46,3,-82,-21,-83,-60v0,-26,20,-44,36,-57v-17,-5,-30,-20,-30,-39xm118,-148v16,-8,32,-32,14,-47v-19,-16,-34,-13,-79,-15v-21,22,-9,56,25,56v9,0,22,3,40,6xm37,-79v0,48,119,61,119,8v0,-39,-62,-35,-98,-44v-10,10,-20,20,-21,36"},"9":{"d":"89,-243v89,11,109,144,45,202v-14,13,-28,28,-45,41r-65,-30r25,-32r65,30v19,-28,28,-60,25,-101r-80,54v-47,-15,-66,-73,-31,-115v15,-19,36,-35,61,-49xm57,-211v-24,22,-23,71,7,87v6,4,15,8,28,13r45,-30v-9,-37,-35,-61,-80,-70"},":":{"d":"50,0r-26,-27r26,-27r27,27xm50,-134r-26,-27r26,-27r27,27","w":101},";":{"d":"24,25v24,-13,22,-40,0,-53r26,-26r26,25v-6,28,-23,49,-48,61xm50,-134r-26,-27r26,-27r27,27","w":101},"<":{"d":"217,-22r-194,-81r0,-30r194,-81r0,35r-150,61r150,61r0,35","w":240},"=":{"d":"23,-176r194,0r0,32r-194,0r0,-32xm23,-93r194,0r0,33r-194,0r0,-33","w":240},">":{"d":"23,-214r194,81r0,30r-194,81r0,-35r150,-61r-150,-61r0,-35","w":240},"?":{"d":"67,-175v0,-29,-38,-39,-56,-15r-5,-3r26,-47v41,-2,73,18,73,53v0,49,-59,61,-52,121r-7,0v-7,-41,21,-72,21,-109xm49,0r-27,-27r27,-27r27,27","w":119},"@":{"d":"156,-165v21,-10,42,-2,43,23r6,-21r43,-1v-11,45,-30,90,-37,138v0,7,6,13,13,13v43,-8,77,-56,77,-109v1,-63,-48,-113,-113,-111v-93,3,-153,69,-155,163v-2,80,59,138,137,138v69,0,125,-44,144,-97r11,0v-24,62,-76,105,-155,107v-88,1,-158,-66,-156,-155v2,-100,69,-167,170,-167v76,0,127,46,127,119v0,67,-38,124,-106,125v-32,0,-43,-27,-31,-56v-21,30,-26,49,-61,56v-60,-14,-15,-115,9,-137v11,-10,22,-22,34,-28xm139,-32v32,-13,60,-77,48,-120v-2,-3,-6,-5,-9,-5v-28,13,-45,70,-49,109v0,8,4,16,10,16","w":331},"A":{"d":"38,-37v-19,0,-7,23,-3,29v0,4,-5,9,-9,8v-26,-14,2,-49,12,-62r25,-35v-28,-22,-45,-37,-46,-76v-2,-91,122,-120,186,-64v13,-14,23,-20,41,-29r4,8v-24,10,-31,24,-30,60r3,132v-1,29,9,43,28,23r5,6r-44,37v-20,-10,-26,-21,-26,-52r-68,52v-38,-25,-64,-37,-78,-37xm75,-173v-9,-27,37,-54,70,-35r13,-18v-55,-26,-129,2,-129,60v0,24,13,45,39,64r58,-81v-22,-14,-38,-5,-51,10xm180,-207v-8,-9,-5,-6,-15,-14r-77,105r94,0xm69,-91r-16,22r89,39r42,-31r-1,-30r-114,0","w":262,"k":{"y":12,"W":14,"V":7,"T":14}},"B":{"d":"83,-233v-20,-1,-65,-20,-63,17r-7,0v0,-31,18,-50,46,-50v31,0,77,20,107,0r4,7v-42,21,-61,32,-63,83v-1,56,9,112,-27,139v55,-15,53,-58,53,-125v0,-86,30,-77,103,-104v24,5,41,21,41,45v0,32,-22,43,-48,65v38,4,55,11,54,52r0,60v-42,5,-77,20,-106,44v-31,-27,-122,-35,-139,7v1,9,15,27,-2,28v-7,0,-13,-8,-12,-16v-1,-33,50,-48,50,-79v0,-25,-36,-23,-36,0v-4,1,-7,0,-6,-5v0,-22,18,-36,42,-34v7,-38,-42,-49,-54,-21r-7,-3v2,-26,26,-41,58,-35v1,-54,17,-58,53,-83v-16,5,-30,8,-41,8xm195,-142v45,-18,71,-87,11,-107v-29,13,-37,16,-37,56v0,44,10,99,-17,120v-7,6,-21,16,-41,28v28,-5,53,-3,77,4r0,-146r7,0r0,45xm195,-116v20,7,33,6,53,0v-1,-20,-10,-27,-27,-34v-18,14,-29,9,-26,34xm248,-109v-20,6,-34,7,-53,0r0,32v19,-7,33,-6,53,0r0,-32xm248,-69v-21,-8,-34,-8,-53,0r0,31v5,2,11,5,15,8v12,-6,25,-11,38,-15r0,-24","w":303},"C":{"d":"143,0v-97,3,-156,-111,-99,-191v12,-17,31,-34,58,-50r4,5v-53,29,-77,110,-31,163v29,-14,10,-80,15,-125r75,-63v33,12,43,16,81,16r3,7r-29,28v-20,-2,-42,-10,-67,-22r2,201v46,1,68,-14,96,-37r6,6v-26,37,-57,60,-114,62xm125,-135v0,42,-24,43,-46,68v17,18,38,31,68,35r-1,-201r-21,18r0,80","w":262},"D":{"d":"7,-88v6,-24,31,-34,59,-26v-4,-56,13,-75,53,-98v-55,5,-114,11,-112,-49r8,0v5,15,16,16,37,17v77,1,178,-23,208,37v24,49,18,75,22,170v-23,14,-40,26,-52,37v-78,-23,-148,-22,-205,14r-5,-7v53,-33,107,-49,107,-138v0,-35,-3,-62,13,-81v-70,9,-17,111,-54,155v-10,13,-33,32,-71,57r-5,-7v28,-21,44,-29,47,-60v2,-25,-33,-40,-45,-15xm149,-212v-33,43,12,131,-38,168v23,-4,31,-4,49,-4r0,-164r-11,0xm169,-145v19,18,52,16,72,0v-4,-50,-22,-66,-72,-67r0,67xm243,-135v-22,15,-54,16,-74,0r0,48v22,-16,54,-15,77,-1xm246,-77v-21,-17,-56,-17,-77,0r0,30v36,2,42,6,77,15r0,-45","w":303},"E":{"d":"142,0v-87,4,-152,-87,-112,-171v16,-31,38,-52,72,-70r3,6v-53,28,-78,107,-32,162v27,-15,9,-80,14,-124r77,-66v27,13,48,23,83,17r5,5r-61,62r47,0r-19,33r-67,0r0,114v45,4,74,-16,100,-41r4,7v-26,40,-58,64,-114,66xm123,-133v-1,41,-21,40,-46,66v19,21,34,30,67,35r0,-200r-21,18r0,81xm212,-212v-28,-5,-38,-7,-60,-19r0,79","w":262},"F":{"d":"220,-263v29,18,58,31,70,0r8,0v1,45,-42,56,-80,39r0,47r55,0r-10,26r-45,0v-2,65,14,139,-42,159r-108,39v-23,-9,-37,-13,-41,-13v-7,1,-13,6,-14,15r-7,-2v0,-25,12,-40,34,-42v14,-1,48,17,62,19v21,-7,16,-23,17,-57r0,-118v-39,-1,-61,3,-74,27r-7,-3v11,-37,35,-51,81,-50r0,-37v50,1,82,-18,101,-49xm123,19v39,-16,59,-32,59,-90r0,-145v-8,4,-17,7,-27,9r-1,170v-3,31,-13,36,-31,56","w":305,"k":{"A":17,".":63,",":63}},"G":{"d":"151,-263v38,18,60,30,104,20r3,6r-64,47v42,1,78,29,78,71v0,73,-79,115,-149,119v-82,4,-136,-77,-95,-151v23,-39,85,-79,123,-112xm124,-232v-8,21,0,59,-3,86r82,-62v-26,-6,-52,-14,-79,-24xm69,-55v31,-24,9,-96,15,-145v-39,30,-49,104,-15,145xm242,-110v-8,-36,-49,-58,-90,-43r0,42v23,20,65,20,90,1xm144,-150v-9,4,-17,9,-23,14v0,27,4,55,-17,62r-30,25v19,20,36,31,70,34r0,-135xm243,-101v-28,16,-65,17,-91,0r0,39v29,-16,53,-16,82,-1v6,-13,9,-25,9,-38xm152,-15v41,-2,58,-18,78,-42v-30,-12,-51,-11,-78,3r0,39","w":285},"H":{"d":"81,-33v32,-22,50,-31,50,-85v0,-52,-8,-106,29,-125v12,-6,29,-15,56,-23r3,7v-47,10,-56,41,-52,100r69,-55v40,23,51,49,51,116v0,69,-62,75,-81,118v2,14,28,-5,27,13v-6,22,-39,11,-36,-10v5,-36,53,-60,54,-102v-58,-26,-100,4,-135,37v33,-5,81,15,96,-16r7,4r-39,55v-28,-11,-47,-17,-78,-19v-37,-1,-79,15,-57,47v1,5,-4,10,-8,10v-7,-1,-14,-8,-13,-17v2,-33,50,-45,49,-80v-1,-20,-24,-15,-29,2r-8,0v3,-24,13,-35,37,-38v5,-38,-42,-51,-55,-22r-6,-2v4,-29,25,-39,57,-35v-5,-41,13,-63,39,-83v-34,22,-82,-24,-90,24r-9,0v5,-30,21,-48,51,-51v32,6,67,19,99,-3r4,7v-39,18,-56,26,-58,79v-2,58,11,117,-24,147xm167,-149r0,8v29,12,60,13,84,-1v-5,-22,-18,-31,-38,-43xm251,-133v-27,12,-54,12,-84,1r0,44v28,-12,57,-12,84,0r0,-45","w":303},"I":{"d":"95,-56v27,-44,-19,-109,-57,-68r-5,-4v12,-21,27,-33,57,-32v1,-47,12,-59,37,-89v-28,30,-87,-12,-98,32r-6,-1v2,-48,51,-51,94,-40v15,-1,22,-3,34,-8r4,5v-49,29,-22,114,-22,176v0,27,-15,38,-41,43v22,17,23,25,45,27v16,2,28,-14,28,-31v-2,-70,-56,-213,42,-220r3,6v-67,14,-15,122,-15,176v0,49,-26,78,-66,83v-28,2,-104,-43,-113,4r-7,-3v9,-31,23,-46,60,-48v13,-1,21,-3,26,-8","w":221},"J":{"d":"5,39v4,-42,51,-43,84,-31v18,0,31,-14,31,-32v-2,-34,-35,-74,-73,-62r-3,-6v21,-14,43,-13,62,0v-2,-32,-29,-58,-59,-41r-4,-6v18,-16,42,-20,66,-5v3,-52,26,-62,62,-88v-41,19,-78,-1,-113,-7v-17,-3,-41,16,-28,27v10,-6,28,-2,27,12v0,9,-8,16,-17,16v-13,-1,-23,-13,-23,-29v0,-27,30,-52,60,-51v42,1,122,34,155,-2r6,5v-40,39,-41,76,-39,154v2,74,-21,97,-64,128v-19,14,-38,20,-53,20v-23,0,-58,-28,-70,1xm110,20v86,-14,34,-149,65,-220v6,-13,16,-27,31,-42v-46,24,-66,47,-68,114v-1,57,14,125,-28,148","w":243},"K":{"d":"10,-210v4,-54,56,-63,103,-47v11,4,29,-14,40,-5v-32,37,-27,108,-32,171v-15,32,-47,46,-70,69v42,-24,97,-27,94,-91v-3,-63,2,-111,30,-153r6,4v-18,31,-24,49,-28,89r67,-54r41,48r-70,50v34,13,57,66,76,92v12,17,23,-25,31,-5r-43,42v-21,-15,-18,-20,-38,-52r-45,52v-44,-22,-103,-22,-147,0r-5,-8v29,-26,50,-36,56,-69v3,-18,-23,-31,-34,-14r-6,-3v4,-25,37,-26,54,-12v8,-34,-27,-67,-54,-44r-6,-2v7,-25,40,-28,59,-13v-2,-50,11,-49,44,-87v-33,34,-101,-6,-117,43xm197,-199r-44,36r0,51r73,-53xm120,-47v35,2,46,5,69,16r24,-28v-18,-26,-28,-42,-60,-46v-1,30,-13,44,-33,58","w":303},"L":{"d":"18,-213r-8,3v-10,-32,15,-58,43,-56v27,2,64,24,88,0r5,6v-58,27,-11,121,-35,180v-6,14,-16,30,-30,48v36,-28,62,-51,62,-104v0,-63,-13,-137,66,-130r4,6v-23,4,-41,12,-41,37v1,42,15,91,-6,122v-8,13,-26,32,-54,56v47,-16,91,-10,122,15v8,-4,17,-21,23,-9r-45,39v-45,-37,-125,-32,-176,0r-4,-5v30,-25,46,-32,53,-64v0,-19,-18,-35,-37,-25r-5,-5v9,-10,29,-15,42,-6v4,-28,-26,-44,-47,-27r-6,-4v8,-16,27,-20,49,-17v-4,-41,5,-63,27,-85v-34,21,-94,-26,-90,25","w":262,"k":{"y":14,"W":29,"V":26,"T":19}},"M":{"d":"182,-266v20,11,28,17,29,44r69,-44r42,31v7,-5,16,-23,22,-10v-36,34,-13,119,-18,181v-2,28,9,41,27,24r5,7r-43,33v-20,-12,-25,-20,-26,-53r0,-168r-29,-23r-12,7r0,88r21,0r-21,26r0,74v7,-4,14,-16,19,-5r-65,54v-17,-19,-21,-27,-40,-36r0,-7v23,-6,9,-52,13,-80r-53,0v1,66,8,143,-57,141v-20,-1,-54,-14,-52,14v-15,0,-9,-20,-4,-30v10,-28,73,-4,69,-53v5,-39,-35,-78,-61,-46r-7,-2v9,-23,19,-34,51,-34v-3,-86,56,-99,121,-133xm153,-243v-40,11,-30,64,-31,113r15,-19r38,0v-2,-37,10,-85,-22,-94xm240,-232r-29,20r0,63r29,0r0,-83xm66,-14v31,3,48,-4,48,-38v0,-57,-4,-124,7,-173v-41,23,-21,101,-25,160v-2,33,-6,41,-30,51xm211,-123v1,33,-8,108,29,80r0,-80r-29,0","w":363},"N":{"d":"40,-165v14,-20,49,-21,68,-4r0,-39r123,-58v84,9,123,104,70,173v-3,5,-18,25,-46,62v21,-9,47,-11,68,-6v10,-3,8,-8,17,-23r8,3r-30,57v-41,-15,-75,-8,-91,23r-7,-4v12,-32,51,-89,60,-116v-28,-22,-75,-27,-106,-5v8,79,-18,134,-88,123v-26,-4,-61,-21,-83,-2r-5,-4v18,-38,56,-35,97,-25v12,0,24,-12,24,-27v0,-29,-36,-50,-59,-28r-5,-5v11,-18,37,-23,57,-11v-3,-32,-43,-49,-68,-30r-4,-6v16,-19,48,-23,68,-5v3,-35,-36,-54,-64,-37xm288,-176v-14,-38,-63,-68,-114,-51r0,55v32,23,84,23,114,-4xm119,-4v40,-5,48,-21,47,-69r0,-152r-21,11r0,151v0,35,-6,44,-26,59xm291,-168v-33,25,-80,28,-117,6r0,50v34,-20,81,-15,109,7v7,-18,11,-39,8,-63","w":363},"O":{"d":"183,-15v-88,45,-192,-22,-167,-130v2,-11,7,-25,13,-39v42,-22,88,-52,127,-79v91,3,162,70,123,158v-14,32,-63,73,-96,90xm143,-228v-8,0,-16,-1,-24,-1r-2,128v-10,17,-28,31,-41,45v20,17,35,25,67,27r0,-199xm150,-181v22,26,72,28,94,0v-23,-29,-51,-40,-94,-46r0,46xm70,-62v26,-24,8,-97,13,-144v-47,27,-57,102,-13,144xm248,-173v-24,26,-73,28,-98,2r0,63v24,-30,78,-27,101,2v7,-25,7,-47,-3,-67xm248,-99v-30,-32,-76,-28,-98,4r0,66v55,-4,78,-31,98,-70","w":303},"P":{"d":"24,-238v26,-35,109,-29,104,29r21,-14r0,-37r8,0r0,32r49,-32v45,34,74,34,74,100r0,112r-54,48v-23,-10,-42,-16,-69,-18r0,69r-65,0r0,-72v-38,3,-54,10,-78,28r-6,-7v28,-30,41,-44,84,-52v1,-53,-28,-71,-68,-84v-1,-14,17,-12,22,-19r46,-30v8,-47,-28,-70,-63,-47xm157,-162v25,20,63,20,88,0v-1,-46,-31,-52,-65,-72r-23,15r0,57xm149,-214r-21,14r0,243r21,0r0,-257xm92,-175r-39,25v17,8,27,14,39,27r0,-52xm245,-153v-24,19,-63,19,-88,1r0,54v25,-18,63,-18,88,0r0,-55xm245,-88v-25,-21,-63,-20,-88,0r0,36v37,1,57,10,88,24r0,-60","w":303,"k":{".":19,",":19}},"Q":{"d":"291,-150v0,47,-27,69,-55,98r46,33v6,-3,12,-13,16,-4r-37,32r-54,-39v-85,71,-218,6,-191,-115v2,-11,7,-25,13,-39v42,-22,88,-52,127,-79v77,8,135,38,135,113xm119,-125v-2,46,-12,35,-43,68v19,18,34,26,67,28r0,-199v-8,0,-16,-1,-24,-1r0,104xm150,-181v22,26,72,28,94,0v-23,-29,-51,-40,-94,-46r0,46xm70,-62v26,-24,8,-97,13,-144v-47,27,-57,102,-13,144xm248,-173v-24,26,-73,28,-98,2r0,63v24,-30,78,-27,101,2v7,-25,7,-47,-3,-67xm248,-99v-30,-32,-76,-28,-98,4r0,66v55,-4,78,-31,98,-70","w":303},"R":{"d":"17,-237v25,-36,107,-33,104,25r71,-49r61,77r-56,38v39,22,56,59,68,108v2,3,5,6,10,10v8,-5,17,-22,24,-8r-43,36v-35,-14,-29,-90,-67,-111v-10,-6,-29,-17,-39,-4r0,72v11,4,22,9,34,15v8,-5,16,-23,24,-10r-46,38v-43,-27,-111,-33,-150,0r-5,-4v22,-27,39,-41,78,-47v3,-55,-30,-73,-68,-88r0,-7v19,-8,49,-28,68,-41v8,-49,-31,-68,-62,-46xm169,-235r-19,12r0,98r69,-46xm142,-217r-21,15r0,152v7,1,14,3,21,5r0,-172xm85,-178r-39,27v19,8,23,13,39,28r0,-55","w":303,"k":{"y":14,"Y":10,"W":26,"V":24,"T":19}},"S":{"d":"11,-129v0,-22,14,-35,35,-42v5,-44,31,-59,67,-92r80,27v3,-7,11,-27,17,-15v-11,26,-28,49,-41,74v60,-5,120,10,120,66v0,61,-48,79,-106,111v-14,-6,-30,-12,-48,-18v-34,16,-61,24,-82,24v-26,1,-47,-12,-47,-33v0,-32,46,-42,87,-34r13,-24v-44,3,-95,-1,-95,-44xm69,-200v8,38,39,29,90,24r18,-32v-29,-13,-42,-21,-71,-23v-20,-1,-37,13,-37,31xm46,-163v-28,27,1,49,42,47v10,0,22,-1,37,-2r14,-25v-36,4,-84,9,-93,-20xm262,-94v0,-50,-56,-59,-113,-50r-14,25v56,-7,94,-12,104,30v-5,31,-25,34,-60,51r35,11v25,-16,48,-33,48,-67xm207,-78v0,-31,-79,-1,-92,-7r-14,25v31,7,32,9,67,19v26,-12,39,-25,39,-37xm22,-18v0,13,16,16,32,16v18,0,41,-6,69,-19v-30,-9,-54,-14,-73,-14v-14,0,-28,4,-28,17","w":303},"T":{"d":"238,-242v21,-2,22,-6,34,-21r6,5v-5,37,-33,53,-78,47r0,178v37,-12,54,-26,72,-58r6,3v-17,54,-53,88,-120,88v-71,0,-124,-37,-124,-109v0,-58,31,-89,72,-117v-47,-5,-79,11,-87,50r-7,-4v12,-49,40,-76,96,-78v19,-1,111,17,130,16xm107,-48v17,-16,18,-13,19,-44r0,-132r-10,-1v-53,38,-71,134,-9,177xm114,-43v26,11,45,17,78,12r0,-182v-11,-2,-21,-3,-30,-5r-1,129v-10,19,-22,24,-47,46","w":285,"k":{"y":5,"r":7,"A":7,";":12,":":12,".":19,"-":7,",":19}},"U":{"d":"57,-266v30,0,77,30,101,0r8,0r0,98v22,13,47,14,66,0r0,-51r-20,-14v-9,6,-17,29,-26,16r43,-47r37,27v8,-5,16,-26,25,-15v-40,34,-16,113,-22,178v-2,29,6,50,24,34r3,11r-37,29v-21,-13,-25,-18,-27,-49v-32,30,-56,47,-107,49v-79,5,-128,-86,-91,-158v17,-33,45,-58,82,-79v-45,14,-109,-17,-98,52r-7,0v-11,-40,10,-81,46,-81xm93,-42v17,13,37,17,65,14r0,-221v-29,23,-14,89,-17,139v-3,43,-19,43,-48,68xm139,-239v-69,23,-114,128,-53,191v36,-24,5,-108,26,-155v5,-9,14,-21,27,-36xm232,-158v-20,12,-43,10,-66,0r0,41v25,-12,42,-12,66,0r0,-41xm166,-29v28,-6,43,-16,66,-31r0,-49v-24,-12,-46,-12,-66,1r0,79","w":303},"V":{"d":"148,0v-24,-18,-58,-16,-83,0r-5,-5v14,-28,21,-39,24,-68v3,-28,-32,-57,-51,-33r-6,-5v7,-25,40,-30,59,-12v-2,-52,-13,-102,-51,-113v-16,2,-17,13,-21,30r-7,-2v2,-33,10,-58,41,-58v33,0,48,27,62,58r109,-58v68,112,8,189,-71,266xm112,-200v4,13,7,25,8,37v36,12,61,10,95,-4v-3,-30,-12,-51,-26,-74xm116,-103v29,-10,57,-10,86,5v8,-22,12,-43,13,-61v-28,14,-60,16,-94,4v0,20,0,31,-5,52xm73,-14v27,-20,54,-32,93,-22v15,-21,23,-32,33,-55v-27,-12,-57,-14,-86,-3v-9,33,-22,54,-40,80","w":262,"k":{"a":5,".":55,"-":17,",":53}},"W":{"d":"242,0v-23,-29,-64,-17,-95,0v-20,-27,-69,-19,-93,0r-5,-4v19,-32,28,-58,28,-78v0,-25,-25,-51,-47,-33r-5,-4v11,-25,41,-25,57,-7v-3,-54,-7,-102,-45,-114v-13,1,-15,11,-18,27r-7,-2v2,-28,13,-51,40,-51v31,0,46,26,57,57r85,-57v11,14,23,33,32,57r85,-57v51,52,45,148,-3,199v-17,18,-37,41,-66,67xm111,-201v3,11,5,22,6,35v23,17,57,17,80,0v-5,-35,-12,-47,-28,-74xm235,-166v23,15,54,14,76,0v-3,-31,-13,-49,-26,-73r-57,37v5,14,5,16,7,36xm197,-157v-23,16,-56,15,-80,1v0,19,-2,34,-9,56v27,-12,59,-11,81,6v7,-22,11,-41,8,-63xm223,-103v26,-10,57,-6,76,9v8,-25,15,-43,12,-62v-24,14,-52,11,-76,0v-1,25,-4,32,-12,53xm160,-20v36,-18,65,-35,108,-20v11,-14,20,-29,28,-45v-19,-17,-51,-19,-78,-8v-17,29,-31,46,-58,73xm66,-18v33,-16,55,-30,97,-23v9,-14,17,-29,23,-44v-21,-20,-55,-17,-81,-4v-11,29,-22,45,-39,71","w":363,"k":{"a":12,";":7,":":7,".":55,"-":14,",":53}},"X":{"d":"6,-224v7,-33,51,-57,81,-33v22,17,36,65,51,94r48,-103v15,11,32,20,52,29r-15,28r-46,-20r-34,78r77,0r-11,26r-53,0v18,30,28,79,55,97v9,-1,20,-24,27,-10r-43,38v-44,-19,-48,-76,-73,-114r-53,114v-16,-11,-35,-20,-56,-28r14,-31r52,20r39,-86r-76,0r12,-26r51,0r-37,-76v-15,-19,-47,-14,-57,8","w":243},"Y":{"d":"176,33v0,-8,13,-24,-4,-25v-34,7,-67,40,-105,41v-30,0,-57,-24,-56,-53v1,-33,26,-51,64,-51v1,-40,-17,-65,-54,-67r0,-7v24,-3,40,2,54,13v3,-37,-20,-63,-55,-58v6,-23,40,-12,55,-1v5,-48,-14,-92,-54,-70r-3,-6v28,-30,88,-16,93,26v27,-20,44,-34,79,-34v47,0,77,44,77,98v0,100,-83,114,-189,114v-29,0,-59,12,-59,41v0,71,98,3,140,4v24,0,47,10,47,33v0,10,-6,18,-16,18v-7,0,-15,-7,-14,-16xm224,-187v-9,-39,-42,-64,-85,-45r0,48v21,23,65,22,85,-3xm130,-227v-7,4,-13,8,-19,13r0,159r19,0r0,-172xm226,-178v-23,21,-62,26,-87,5r0,53v23,-21,65,-21,87,0v4,-23,4,-33,0,-58xm224,-111v-23,-22,-62,-21,-85,0r0,56v48,-2,73,-18,85,-56","w":285,"k":{"u":10,"o":5,"i":10,"e":12,"a":12,";":7,":":7,".":41,"-":17,",":46}},"Z":{"d":"63,-266v44,25,106,27,150,0r5,4v-29,40,-32,48,-64,102r54,0r-6,13r-56,0v-4,6,-8,13,-12,19r58,0r-6,13r-61,0v-30,39,-37,44,-87,92v54,-23,109,-34,156,-8v8,-6,15,-29,24,-18r-40,49v-48,-27,-117,-25,-167,0r-4,-6v36,-41,41,-51,75,-109r-54,0r7,-13r56,0r13,-19r-60,0r6,-13r63,0v23,-32,51,-56,79,-84v-40,23,-103,33,-146,9r-22,26r-6,-5","w":221},"[":{"d":"93,52r0,9r-72,0r0,-321r72,0r0,9r-39,0r0,303r39,0","w":101},"\\":{"d":"169,12r-160,-256r23,0r160,256r-23,0","w":201},"]":{"d":"8,52r39,0r0,-303r-39,0r0,-9r73,0r0,321r-73,0r0,-9","w":101},"^":{"d":"26,-117r73,-126r14,0r71,126r-28,0r-52,-90r-51,90r-27,0","w":209},"_":{"d":"-2,27r184,0r0,18r-184,0r0,-18","w":180},"`":{"d":"68,-201r-47,-65r41,0r16,65r-10,0","w":119},"a":{"d":"74,-187v16,8,53,28,64,7r6,3v-23,26,-10,73,-14,118v-2,26,7,35,22,21r4,6r-39,32v-16,-13,-22,-18,-23,-42r-54,42v-50,-37,-27,-86,6,-122r-21,-45v0,-6,10,-5,13,-4v14,0,25,-5,36,-16xm94,-146r-61,-19r22,46r39,18r0,-45xm94,-94r-43,-20v-17,34,-12,65,16,85r27,-22r0,-43","w":161},"b":{"d":"10,-247v16,7,18,8,28,17v21,-15,21,-18,44,-22r2,5v-33,11,-19,62,-22,103r55,-43v44,19,22,97,27,155v-25,10,-39,17,-57,32v-23,-19,-37,-24,-73,-32v23,-30,12,-112,12,-165v0,-27,-4,-35,-19,-46xm62,-48r46,18v-2,-38,4,-86,-3,-118v-2,-3,-6,-8,-12,-12r-31,24r0,88","w":161},"c":{"d":"15,-22v20,-27,8,-89,11,-135v15,-7,29,-16,43,-30r46,26r-19,27r-34,-20r0,112r34,16r19,-13r2,7r-44,32v-22,-11,-32,-17,-58,-22","w":119},"d":{"d":"12,-28v19,-25,7,-86,10,-130v16,-4,27,-9,34,-15r-47,-31r0,-43r119,82v5,-9,7,-12,17,-16v-10,38,-3,100,-5,150v-29,11,-38,14,-57,31v-24,-16,-40,-24,-71,-28xm104,-140r-36,-25v-3,3,-7,5,-10,7r0,109r46,20r0,-111","w":161},"e":{"d":"24,-158v31,-12,30,-11,65,-29r49,57r-79,56r0,32r41,16r28,-19r4,5r-57,40v-24,-12,-32,-15,-61,-22v19,-25,7,-90,10,-136xm62,-167r-3,1r0,80r47,-33","w":142},"f":{"d":"10,-27v0,-10,12,-14,12,-30r0,-103r-16,0r0,-19r16,0r0,-43v18,-12,31,-22,40,-30r34,9r-6,29r-32,-8r0,43r27,0r0,19r-27,0r0,118r20,15v6,-3,13,-16,18,-6r-41,33v-14,-13,-30,-22,-45,-27","w":101},"g":{"d":"125,50v-31,-11,-60,-10,-97,0r-2,-6r41,-49r-41,-29r0,-128v23,-5,44,-13,63,-25r55,25r33,-16r0,39r-32,-6r0,80v-10,45,50,58,22,91v-5,5,-19,13,-42,24xm110,-145r-49,-17r0,115r27,19r22,-26r0,-91xm152,23v-25,-25,-36,-32,-42,-65r-53,60v37,-7,62,-4,88,10"},"h":{"d":"9,-248v15,5,19,8,30,18v13,-13,23,-18,43,-22r2,4v-30,13,-20,62,-22,104r54,-43v43,16,25,83,28,137v2,39,-9,47,-32,65v-17,14,-40,25,-68,35r-3,-7v50,-25,72,-23,67,-99v-3,-36,13,-90,-16,-104r-30,24r0,98r13,13r-31,25r-32,-25r14,-14r0,-160v0,-29,-2,-34,-19,-44","w":161},"i":{"d":"59,-248r22,0r-24,38r-7,0xm50,0v-38,-20,-16,-95,-22,-148r-13,-14r31,-25r31,25r-14,14r0,96v-1,24,10,29,23,16r4,5","w":101},"j":{"d":"68,-248r23,0r-24,37r-8,0xm90,-156v-47,46,18,150,-44,190v-7,4,-16,10,-28,16r-3,-7v17,-11,31,-27,31,-51v0,-44,-23,-101,-1,-138v-4,-5,-9,-10,-15,-14v-6,3,-13,13,-17,4r41,-31v13,15,19,19,36,31","w":101},"k":{"d":"14,-247v14,6,19,7,29,17v15,-13,25,-18,46,-22r0,5v-33,13,-20,66,-23,110r52,-50r36,39r-41,36v30,11,27,60,42,84v1,2,14,-14,15,-2r-41,30v-10,-12,-13,-20,-16,-40r-49,40v-14,-14,-26,-20,-46,-27v27,-27,9,-115,13,-172v2,-27,-3,-34,-19,-43xm98,-158r-32,30r0,47r58,-49xm66,-72r0,31r21,14r25,-21v-3,-20,-11,-34,-25,-42","w":176},"l":{"d":"27,-195v2,-29,-3,-35,-19,-47v8,-10,24,8,32,15v16,-15,24,-23,48,-25r0,5v-18,10,-25,21,-25,49r0,156v9,5,19,21,28,9r4,6r-35,27v-20,-16,-22,-20,-45,-27v24,-32,8,-112,12,-168","w":101},"m":{"d":"120,-187v18,16,27,19,29,45r49,-45r29,27v8,-4,16,-23,23,-12v-32,16,-16,75,-19,119v-1,22,6,31,21,17r4,5r-39,31v-39,-22,-16,-91,-22,-144r-18,-15r-28,26r0,95r13,14r-31,24r-31,-24r13,-14v-6,-42,15,-104,-17,-121r-28,23r0,98r13,14r-31,24r-31,-24r14,-14r0,-94v0,-21,-7,-34,-23,-19r-4,-5r38,-31v17,13,25,14,24,43","w":262},"n":{"d":"45,-187v17,13,25,14,24,40r51,-40r29,27v7,-5,15,-23,22,-12v-32,20,-19,76,-19,122v0,17,7,27,21,14r4,5r-38,31v-39,-20,-18,-91,-23,-144r-19,-16r-28,22r0,100r12,13r-31,25r-31,-25r14,-13r0,-90v0,-23,-4,-38,-21,-25r-4,-5"},"o":{"d":"13,-27v16,-24,7,-86,9,-130v21,-7,41,-17,56,-30v17,11,37,19,62,25r0,132v-29,11,-39,14,-56,30v-28,-15,-38,-24,-71,-27xm58,-47r46,19r0,-112v-23,-10,-26,-13,-46,-17r0,110","w":161},"p":{"d":"28,-134v1,-18,-7,-33,-19,-20r-4,-6r36,-27v16,12,23,16,23,41r46,-41v22,19,36,19,36,51r0,99v-15,7,-33,19,-52,37v-7,-4,-17,-9,-30,-15v0,32,2,49,21,60r-3,5v-21,-9,-31,-11,-41,-26v-8,6,-20,21,-26,12v15,-12,13,-35,13,-62v-8,-1,-16,-3,-23,-1r0,-15v8,-2,16,-3,23,-4r0,-88xm64,-137r0,91v25,6,28,4,46,13r-1,-108v-4,-5,-18,-15,-21,-18","w":161},"q":{"d":"72,-187v27,17,37,29,72,29r2,5v-13,6,-12,9,-12,31v0,52,-13,128,13,158v-7,9,-18,-6,-26,-12v-11,15,-20,20,-41,26r-2,-4v26,-14,19,-48,20,-86r-49,40v-22,-16,-33,-19,-32,-54r0,-104v23,-8,41,-17,55,-29xm52,-158r2,115v1,2,8,7,18,15r26,-20r0,-87","w":161},"r":{"d":"47,-187v14,13,22,14,23,34r40,-34r27,31r-27,24r-22,-28r-18,16r0,102r21,15v7,-4,17,-22,22,-9r-45,36v-17,-15,-25,-21,-46,-27v19,-18,12,-67,13,-108v1,-21,-10,-30,-21,-15r-5,-6","w":142,"k":{".":19,"-":19,",":19}},"s":{"d":"90,0v-23,-18,-58,-18,-79,0v-15,-11,16,-27,21,-39r23,-30r-38,-21r0,-66v24,-7,35,-14,48,-31v23,8,33,14,55,16v10,0,20,-6,20,-14v-6,-8,-18,-27,0,-30v22,7,8,35,-3,50r-33,43r40,21r0,74v-26,3,-37,12,-54,27xm52,-110r24,12r38,-51v-25,8,-41,3,-62,-11r0,50xm40,-37v24,-9,45,-6,68,8r0,-51r-26,-14","w":162},"t":{"d":"12,-27v21,-25,9,-87,12,-133r-16,0r0,-8r49,-61r5,0r-2,49r35,0r0,20r-35,0r0,118r20,15v5,-3,11,-13,15,-4r-38,31v-13,-13,-28,-22,-45,-27","w":101},"u":{"d":"33,-137v0,-16,-8,-22,-18,-11r-5,-5r39,-34r32,26r-13,12v5,41,-15,101,16,120r32,-23r0,-96r-13,-13r31,-26r32,26r-15,13v4,39,-11,100,11,120v2,0,11,-9,14,-1r-37,29v-17,-14,-23,-16,-23,-43v-18,12,-37,26,-56,43v-41,-20,-27,-82,-27,-137"},"v":{"d":"23,-141v-4,-24,-32,-45,-10,-72v6,-7,17,-15,32,-23r4,4v-21,15,-25,28,-6,46v12,11,15,20,16,42r54,-43v45,22,24,95,29,156v-24,6,-39,16,-59,31v-22,-17,-38,-26,-71,-28v18,-19,9,-72,11,-113xm59,-135r0,85r46,21v-6,-44,16,-111,-17,-130","w":161,"k":{".":14,",":14}},"w":{"d":"118,-187v15,10,27,21,29,42r53,-42v45,22,23,96,28,156v-25,8,-38,16,-57,31v-37,-22,-58,-29,-87,0v-20,-18,-37,-25,-68,-28r0,-5v26,-10,11,-65,15,-98v4,-33,-21,-31,-20,-57v1,-29,17,-35,41,-49r4,5v-47,30,13,46,11,86xm67,-137r0,90r44,18v-6,-44,16,-111,-17,-130xm147,-136r0,88r45,19r-2,-116v-2,-3,-7,-8,-15,-14","w":243,"k":{".":14,",":14}},"x":{"d":"47,-187v29,15,33,28,52,62r30,-62r36,18r-14,30r-31,-14r-17,36v15,29,29,69,50,86v8,6,16,-9,20,1r-34,30v-30,-16,-35,-34,-56,-76r-36,76r-37,-19r15,-31r31,16r24,-49v-15,-32,-27,-62,-53,-75v-4,-1,-14,11,-18,2"},"y":{"d":"35,-129v2,-23,-9,-37,-21,-22r-5,-6r37,-30v18,12,25,15,24,42r54,-42v42,38,29,100,-10,129v-18,14,-77,45,-96,68v-8,18,10,34,30,33v21,4,22,-16,35,-20v5,0,8,2,8,7v-10,30,-84,26,-82,-12v0,-24,26,-33,26,-63r0,-84xm70,-37v40,-24,64,-79,27,-121r-27,21r0,100","w":161,"k":{".":29,",":29}},"z":{"d":"69,-53v0,-26,-32,-38,-56,-22r-4,-3r60,-53r-35,-32v-9,3,-20,21,-27,10r51,-34v15,9,24,33,44,29r2,3r-52,48v53,-7,73,61,32,86v-12,13,-62,24,-62,47v0,13,14,18,27,13v4,-1,4,3,5,5v-11,16,-41,-1,-39,-19v3,-35,55,-40,54,-78","w":119},"{":{"d":"29,-91v71,-9,-6,-109,49,-139v15,-8,25,-14,49,-14r0,8v-20,3,-34,14,-35,33v0,15,10,44,9,60v-4,34,-24,48,-58,57v33,11,54,23,58,58v-5,35,-23,90,26,93r0,8v-39,3,-73,-21,-73,-56v0,-33,25,-96,-25,-97r0,-11","w":142},"|":{"d":"85,-251r33,0r0,300r-33,0r0,-300","w":203},"}":{"d":"114,-80v-82,14,34,151,-98,153r0,-8v47,-4,30,-56,26,-93v4,-33,22,-50,57,-57v-33,-11,-53,-24,-58,-58v6,-33,23,-90,-25,-93v-1,-5,0,-10,6,-8v33,-1,67,23,67,56v0,33,-25,95,25,97r0,11","w":142},"~":{"d":"175,-117v17,0,29,-13,30,-31r12,0v-1,35,-19,58,-50,60v-38,3,-119,-70,-132,0r-12,0v1,-36,17,-60,48,-61v37,-1,66,32,104,32","w":240},"\u00a0":{"w":91}}});
