//Create a collection to hold conversion information for different units of measure 
var conversion = {
	"Length" : {
		"Centimeter (cm)" : "1",
		"Feet" : "0.0328084",
		"Inches (in)" : "0.393701",
		"Kilometers (km)" : "0.00001",
		"Meter (m)" : "0.01",
		"Mile" : "6.2137e-6",
		"Millimeter (mm)" : "10",
		"Yards" : "0.0109361"
	},
	"Mass" : {
		"Gram (g)" : "1",
		"Kilogram (kg)" : "0.001",
		"Milligram (mg)" : "1000",
		"Ounces" : "0.035274",
		"Pounds (lbs)" : "0.00220462",
		"Tonnes" : "0.000001"
	},
	"Speed" : {
		"Feet/sec" : "1",
		"Feet/hour" : "3599.9928",
		"Km/hour" : "1.09728",
		"Km/sec" : "0.000305",
		"Knot" : "0.592484",
		"Miles/hour" : "0.681818",
		"Miles/sec" : "0.000189"
	},
	"Temperature" : {
		"Celsius" : "formula",
		"Kelvin" : "formula",
		"Fahrenheit" : "formula"
	},
	"Time" : {
		"Century" : "1",
		"Days" : "36524.2",
		"Decades" : "10",
		"Hours" : "876581",
		"Milliseconds (ms)" : "3.156e+12",
		"Minutes" : "52560000",
		"Months" : "1200",
		"Nanoseconds (ns)" : "3.156e+18",
		"Seconds" : "3153600000",
		"Weeks" : "5217.75",
		"Years" : "100"
	},
	"Volume" : {
		"Cups" : "1",
		"Gallons" : "0.0625",
		"Liters (l)" : "0.236588",
		"Milliliters (ml)" : "236.588237",
		"Ounces" : "8",
		"Table spoon" : "16",
		"Tea spoon" : "48"
	}
};

var conversionDesc = [ "Length", "Mass", "Speed", "Temperature", "Time", "Volume" ]; //Category list
				
//Function used to convert between any two units of measure
function convert(category, from, to, val)
{
	var result = val;
	
	//Temperature conversion requires special formulas 
	if (category == "Temperature")
	{
		if (from == "Celsius")
		{
			if (to == "Fahrenheit")
				result = (val * 1.8) + 32;
			else if (to == "Kelvin")
				result = (val * 1 + 273.15);
		}
		else if (from == "Fahrenheit")
		{
			if (to == "Celsius")
				result = (val - 32) * 5/9;
			else if (to == "Kelvin")
				result = (val - 32) * 5/9 + 273.15;
		}
		else if (from == "Kelvin")
		{
			if (to == "Celsius")
				result = val - 273.15;
			else if (to == "Fahrenheit")
				result = (val - 273) * 1.8 + 32;
		} 
	}
	else
	{ //All other conversions
		result = (val / conversion[category][from]) * conversion[category][to];
	}
	
	if (isNaN(parseFloat(result))) 
		return "Ensure that all fields are specified as numeric."; 
	
	return parseFloat(parseFloat(result).toFixed(5)); //Return results rounded to 5 decimals with trailing zeros removed
}

//Function used to retrieve a list of measuring units associated with a category
function unitsFor(category)
{
	var unitList = conversion[category];
	return unitList;
}