var Discover = {
	processRadiusBeersChange: function(a) {
		Filter.toggle('beerToggle');
		Discover.beers(a);
	},
	processRadiusBarsChange: function(a) {
		Filter.toggle('barToggle');
		Discover.bars(a);
	},
	trending: function(a) {
	
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			ajaxStatement = $.ajax({
				url: host + "/beer/trending?access_token="+token,
				type: "GET",
				dataType: "json",
			    error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						Template.trendingBeer("micro-trending", "macro-trending", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});	
		}
		
	},
	venue_search_bars: function(a) {

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			Loading.on();

			var args = $(a).serialize();

			ajaxStatement = $.ajax({
				url: host+ "/location/coords?access_token="+token,
				type: "GET",
				data: args,
				dataType: "json",
			    error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						if (data.response.length == 0) {

							Loading.off();

							$("#notice-error").html('');

							var object = {};

							object["message"] = "No results were found for that entry. Please make sure you are entering a city, state or address and try again.";

							/*var source   = $("#error-template").html();
							var template = Handlebars.compile(source);*/

							var template = Handlebars.templates['error-template.tmpl'];
							var html = template(object);

							$("#notice-error").html(html);

							Util.openPop();

							Util.closePopTimeout(3000);
						}
						else {

							var position = {};

							position.coords = {};

							position.coords.latitude = data.response[0].lat;
							position.coords.longitude = data.response[0].lon;

							if (data.response[0].address.city) {
								var shortStreet = data.response[0].address.city + ", " + data.response[0].address.state;
							}
							else {
								var shortStreet = data.response[0].address.state;
							}
							
							if (data.response[0].display_name) {
								$("#discoverBarsObj").html("Near: " + shortStreet);
							}
							else {
								$("#discoverBarsObj").html("Near: A Secret Place!");
							}

							console.log(position);

							Discover.bars(position, true);
						}	
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}

		return false;
	},		
	bars_geolocate: function() {

		if (geo) {
			
			geo.getCurrentPosition(Discover.bars, Geolocate.error, opts);
		}
		else
		{
			Error.show("You browser doesn't support Geolcation");
		}

	},
	beers_geolocate: function() {

		if (geo) {
			
			geo.getCurrentPosition(Discover.beers, Geolocate.error, opts);
		}
		else
		{
			Error.show("You browser doesn't support Geolcation");
		}
	},	
	friends_geolcate: function() {

		if (geo) {
			
			geo.getCurrentPosition(Discover.friends, Geolocate.error, opts);
		}
		else
		{
			Error.show("You browser doesn't support Geolcation");
		}
	},	
	breweries_geolocate: function() {

		if (geo) {
			
			geo.getCurrentPosition(Discover.breweries, Geolocate.error, opts);
		}
		else
		{
			Error.show("You browser doesn't support Geolcation");
		}
	},
	see_more_bars: function() {

		$("#see_more_pop").hide();
		$("#pop_loader").show();

		var len = $(".discover_bars").length;

		var position = {};

		position.coords = {}

		position.coords.latitude = currentLat;
		position.coords.longitude = currentLng;

		Discover.bars(position, false, len);

	},	
	bars: function(position, a, b) {
		
		clearAjax();
		
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{		

			$(".location_bar").show();

			var offset = 0;

			if (b) {
				offset = b;
			}

			var dis = myStorage.view("distanceBars");
			var rad = 5;
			
			if (!dis) {
				rad = 5;
			}	
			else {
				rad = dis;
			}

			if (a) {
				var url =  host + "/venue/trending?access_token="+token+"&lat="+position.coords.latitude+"&lng="+ position.coords.longitude+"&radius="+rad+"&offset="+b;
			}
			else {
				
				currentLat = position.coords.latitude;
				currentLng = position.coords.longitude;

				Geocode.reverse(currentLat, currentLng);

				var url =  host + "/venue/trending?access_token="+token+"&lat="+currentLat+"&lng="+currentLng+"&radius="+rad+"&offset="+b;
			}
				
		 	ajaxStatment = $.ajax({
				url: url,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Loading.off();
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Loading.off();

					if (data.meta.code == 200)
					{
						Template.discoverBars("discoverBarsHolder",data.response, b, a);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	},
	breweries: function(position) {

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			currentLat = position.coords.latitude;
			currentLng = position.coords.longitude;

			Geocode.reverse(currentLat, currentLng);

			var h = window.screen.height - 110;

			$("#brewery_mapbox").height(h);

			if (!mapBreweries) {

				mapBreweries = new L.Map('brewery_mapbox', {touchZoom: true});
				mapGroupB = new L.LayerGroup();

				var cloudmadeUrl = 'http://{s}.tile.cloudmade.com/0d9643c7b8f44ff88ce75136e55971a0/65578/256/{z}/{x}/{y}.png',
				cloudmadeAttribution = 'Map data &copy; 2011 OpenStreetMap contributors, Imagery &copy; 2011 CloudMade',
				cloudmade = new L.TileLayer(cloudmadeUrl, {maxZoom: 18, attribution: cloudmadeAttribution, detectRetina: true});
				mapBreweries.setView(new L.LatLng(currentLat, currentLng), 13).addLayer(cloudmade);

				mapBreweries.invalidateSize();

				mapBreweries.removeLayer(mapGroupB);

			}
			else {

				mapBreweries.setView(new L.LatLng(currentLat, currentLng), 13);

				mapBreweries.invalidateSize();

				mapBreweries.removeLayer(mapGroupB);
			}


			if (circleLayer) {
				mapBreweries.removeLayer(circleLayer);
			}
			
			var circleLocation = new L.LatLng(currentLat, currentLng),
			    circleOptions = {
			        color: 'blue',
			        fillColor: 'blue',
			        fillOpacity: 1
			    };

			circleLayer = new L.CircleMarker(circleLocation, 75 , circleOptions);

			mapBreweries.addLayer(circleLayer);

			var dis = myStorage.view("distanceBreweries");
			var rad = 5;

			if (!dis) {
				rad = 5;
			}
			else {
				rad = dis;
			}

			ajaxStatement = $.ajax({
				url: host + "/venue/breweries?access_token="+token+"&lat="+currentLat+"&lng="+currentLng+"&radius="+rad,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						if (data.response.count == 0) {
							$("#notice-error").html('');

							var obj = {};
							obj["message"] = "It appears there are not breweries around your current location.";
							obj["action_btn"] = "Please try again later!";
							console.log(obj);

							/*var source   = $("#warning-template").html();
							var template = Handlebars.compile(source);*/

							var template = Handlebars.templates['warning-template.tmpl'];
							var html = template(obj);

							$("#notice-error").html(html);

							Util.openPop();

							Util.closePopTimeout(3000);

							mapBreweries.invalidateSize();
						}
						else {
							
							var isMarker = {};
							
	
							$.each(data.response.brewery.items, function(i, items) {
								
								var lat_api = items.location.lat;
								var lng_api = items.location.lng;
								
								var LeafIcon = L.Icon.extend({
									iconUrl: items.brewery_label,
									shadowUrl: '',
									iconSize: new L.Point(35, 35),
									shadowSize: new L.Point(35,35),
									iconAnchor: new L.Point(35,35),
									popupAnchor: new L.Point(-25, -25)
								});

								var greenIcon = new LeafIcon();

								var marker = new L.Marker(new L.LatLng(lat_api, lng_api) ,{icon: greenIcon});

			
								mapGroupB.addLayer(marker);

								var address;

								if (items.location.brewery_address != "") {
									address = items.location.brewery_address;
								}
								else {
									address = "";
								}

								marker.bindPopup("<a href='javascript:void(0)' rel='action-btn' onclick='Discover.view_brewery("+items.brewery_id+");'><img src='" + items.brewery_label + "' height='44' width='44' style='float:left; margin-right: 5px;' /><p><strong>"+items.brewery_name + "</strong></p> <p>" +address+"</p><p><strong>"+items.location.brewery_city + ", " + items.location.brewery_state+"</strong></p></a><div id='mapbrewery_"+items.brewery_id+"' style='display: none;'>"+JSON.stringify(items)+"</div>").openPopup();


								/*marker.on('click', function(e) {
								    Discover.locate(items);
								});*/
								
							});

							$(".timeago").cuteTime({ refresh: 50000 });

							mapBreweries.addLayer(mapGroupB);

							mapBreweries.invalidateSize();
						}
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}

	},
	friends: function(position) {
		
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			currentLat = position.coords.latitude;
			currentLng = position.coords.longitude;

			Geocode.reverse(currentLat, currentLng);

			var h = window.screen.height - 110;

			$("#mapbox").height(h);

			if (!map) {
							
				map = new L.Map('mapbox', {touchZoom: true});
				mapGroup = new L.LayerGroup();

				var cloudmadeUrl = 'http://{s}.tile.cloudmade.com/0d9643c7b8f44ff88ce75136e55971a0/65578/256/{z}/{x}/{y}.png',
				cloudmadeAttribution = 'Map data &copy; 2011 OpenStreetMap contributors, Imagery &copy; 2011 CloudMade';
				
				var cloudmade = new L.TileLayer(cloudmadeUrl, {maxZoom: 18, attribution: cloudmadeAttribution, detectRetina: true});
				map.setView(new L.LatLng(currentLat, currentLng), 13).addLayer(cloudmade);

				map.invalidateSize();
				
				map.removeLayer(mapGroup);
				
			}
			else {
				
				map.setView(new L.LatLng(currentLat, currentLng), 13);
				
				map.invalidateSize();
				
				map.removeLayer(mapGroup);
			}
			
			if (circleLayer) {
				map.removeLayer(circleLayer);
			}
			
			var circleLocation = new L.LatLng(currentLat, currentLng),
			    circleOptions = {
			        color: 'blue',
			        fillColor: 'blue',
			        fillOpacity: 1
			    };

			circleLayer = new L.CircleMarker(circleLocation, 75 , circleOptions);
			
			map.addLayer(circleLayer);

			var dis = myStorage.view("distanceFriends");
			var rad = 5;
			
			if (!dis) {
				rad = 5;
			}	
			else {
				rad = dis;
			}
				
		 	ajaxStatement = $.ajax({
				url: host + "/friends/around?access_token="+token+"&lat="+currentLat+"&lng="+currentLng+"&radius="+rad,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						if (data.response.count == 0) {
							$("#notice-error").html('');

							var obj = {};
							obj["message"] = "It appears that none of your friends are nearby.";
							obj["action_btn"] = "Please try again later!";
							console.log(obj);

							/*var source   = $("#warning-template").html();
							var template = Handlebars.compile(source);*/

							var template = Handlebars.templates['warning-template.tmpl'];
							var html = template(obj);

							$("#notice-error").html(html);

							Util.openPop();

							Util.closePopTimeout(3000);
							
							map.invalidateSize();
						}
						else {
							
							var isMarker = {};
							
							console.log(isMarker);
							
							$.each(data.response.items, function(i, items) {
								
								var e = false;
								
								var lat_api = items.venue.location.lat;
								var lng_api = items.venue.location.lng;
								
								var LeafIcon = L.Icon.extend({
									iconUrl: items.user.user_avatar,
									shadowUrl: '',
									iconSize: new L.Point(35, 35),
									shadowSize: new L.Point(35,35),
									iconAnchor: new L.Point(35,35),
									popupAnchor: new L.Point(-25, -25)
								});

								var greenIcon = new LeafIcon();
								
								var marker = new L.Marker(new L.LatLng(lat_api, lng_api) ,{icon: greenIcon});
								
								mapGroup.addLayer(marker);

								marker.bindPopup("<a href='javascript:void(0)' rel='action-btn' onclick='Discover.view_venue("+items.venue.venue_id+");'><img src='" + items.venue.venue_icon.md + "' height='44' width='44' style='float:left; margin-right: 5px;' /><p><strong>"+items.user.first_name + " " + items.user.last_name + "</strong> was last seen at <strong>" + items.venue.venue_name + "</strong> " + Discover.sweetTime(items.created_at) + "</p></a><div id='mapvenue_"+items.venue.venue_id+"' style='display: none;'>"+JSON.stringify(items)+"</div>").openPopup();


								marker.on('click', function(e) {
								    Discover.locate(items);
								});
													
							});

							$(".timeago").cuteTime({ refresh: 50000 });

							map.addLayer(mapGroup);

							map.invalidateSize();
						}
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	},
	getRandom: function(min, max) {
	    return Math.random() * (parseFloat(max) - parseFloat(min)) + parseFloat(min);
	},
	view_brewery: function(a) {
		Page.change("#!/breweryArea/"+a+"/full", "push");
	},
	view_venue: function(a) {
		Page.change("#!/venueArea/"+a+"/null/map", "push");
		//Feed.venue(a, null, "map");
	},	
	sweetTime: function (a) {
	    var b = new Date();
	    var c = new Date(a);

	    var d = b - c;
	    var e = 1000,
	        minute = e * 60,
	        hour = minute * 60,
	        day = hour * 24,
	        week = day * 7;
	    if (isNaN(d) || d < 0) {
	        return ""
	    }
	    if (d < e * 7) {
	        return "right now"
	    }
	    if (d < minute) {
	        return Math.floor(d / e) + " seconds ago"
	    }
	    if (d < minute * 2) {
	        return "about 1 minute ago"
	    }
	    if (d < hour) {
	        return Math.floor(d / minute) + " minutes ago"
	    }
	    if (d < hour * 2) {
	        return "about 1 hour ago"
	    }
	    if (d < day) {
	        return Math.floor(d / hour) + " hours ago"
	    }
	    if (d > day && d < day * 2) {
	        return "yesterday"
	    }
	    if (d < day * 365) {
	        return Math.floor(d / day) + " days ago"
	    } else {
	        return "over a year ago"
	    }
	},
	locate: function(item) {
		$(".timeago").cuteTime({ refresh: 50000 });
		
		if (item.user.contact.twitter) {
			//alert(item.user.contact.twitter);
		}	
			
	},
	beers: function(position) {
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			currentLat = position.coords.latitude;
			currentLng = position.coords.longitude;

			Geocode.reverse(currentLat, currentLng);

			var dis = myStorage.view("distanceBeer");
			var rad = 5;
			
			if (!dis) {
				rad = 5;
			}	
			else {
				rad = dis;
			}
		
			$(".location_bar").show();
			
			ajaxStatement = $.ajax({
				url: host + "/beer/trending?type=local&access_token="+token+"&lat="+currentLat+"&lng="+currentLng+"&radius="+rad,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Loading.off();
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Loading.off();
					if (data.meta.code == 200)
					{
						Template.discoverBeers("discoverBeersContent", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	}
}
