var Feed = {
	check_in: function() {
		
		if (checkinProc && checkinProc.readyState != 4) {
			console.log("already running");
			return false;
		}	

		$("#check-in-btn").hide();
		$("#check-in-loader").show();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			var args = $("#confirm_form").serialize();
		
		 	checkinProc = $.ajax({
				url: host + "/checkin/add?access_token="+token,
				type: "POST",
				data: args,
				timeout: 0,
				dataType: "json",
			    error: function(xhr,ajaxOptions, thrownError)
				{	
					$("#check-in-btn").show();
					$("#check-in-loader").hide();
					
					if (xhr.responseText == "") {
						
						$("#notice-error").html('');

						var object = {};

						object["message"] = "Oh no! Something appeared to go wrong. Please try again or contact support.";

						/*var source   = $("#error-template").html();
						var template = Handlebars.compile(source);*/

						var template = Handlebars.templates['error-template.tmpl'];
						var html = template(object);

						$("#notice-error").html(html);

						Util.openPop();

						Util.closePopTimeout(3000);
						
					}
					else {
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					}
				},
				success: function(data)
				{
					$("#check-in-btn").show();
					$("#check-in-loader").hide();
					
					if (data.meta.code == 200)
					{
						$("#isRecommend").val("false");
						if (data.response.media.is_photo && myBlob != "") {
								
							var fileURI = myBlob;
							var form = new FormData();
			                form.append("file", fileURI);
			                form.append("checkin_id", data.response.checkin_id);
			                form.append("photo_key", data.response.media.photo_key);
			                form.append("user_id", data.response.user.uid);

			                var url_to = host + "/photo/add/"+data.response.checkin_id+"?access_token="+token;

			                var xhrForm = new XMLHttpRequest();
			                xhrForm.open("POST", url_to);
			                xhrForm.send(form);

			                uploadProgress = setInterval("pBar.increase();",1000);

			                xhrForm.onreadystatechange = function () {
			                    if (xhrForm.readyState === 4) {
			                    	var jsonRes = JSON.parse(xhrForm.responseText);

			                    	if (jsonRes.meta && jsonRes.meta.code == 200) {
			                    		myBlob = "";

			                    		var obj = {
			                    			responseCode: 200,
			                    			response: jsonRes
			                    		};

			                    		Photo.uploadGood(obj);
			                    	}
			                    	else {
			                    		Photo.uploadBad(jsonRes);
			                    	}
			                    }
			                };
						}
						
						$("#cheersArea").html('');
						
						Page.change("#!/cheersArea", "push");
						//location.href = "#!/cheersArea";
						
						Template.cheers("cheersArea", data.response);
						
						if (!data.response.badge_valid) {
							Error.handle("It looks like you're device isn't near the location you chose. You're check-in will go through but no badges will be awarded.", "", "");
						}

						var bid = data.response.beer.bid;
						
						var id = $(".beer_recent:first").attr("id");
						
						var match = "recent_"+bid;
					
						var counter = 0;

						if ($("#recent_"+bid).length != 0) {
							$("div.beer_recent").each(function() {
								if ($(this).attr("id") == "recent_"+bid) {
									counter++;
								}
							});

							if (parseInt(counter) >= 2) {
								init.Recent();
							}
							else {

								$("div.beer_recent").each(function() {
									if ($(this).attr("id") == "recent_"+bid) {
										$(this).remove();
									}
								});

								var template = Handlebars.templates['single-beer-template.tmpl'];
								var html = template(data.response);

								html = '<div class="list_box beer_recent" id="recent_'+bid+'">'+html+'</div>';

								$("#drinkAreaContentArea").prepend(html);
							}
						}
						else {
							var template = Handlebars.templates['single-beer-template.tmpl'];
							var html = template(data.response);

							html = '<div class="list_box beer_recent" id="recent_'+bid+'">'+html+'</div>';

							$(".beer_recent:last").remove();

							$("#drinkAreaContentArea").prepend(html);
						}
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
			
		}
	},
	notifications: function(a, b) {
		
		clearAjax();
		
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			if (a) {
	
			}
			else {
				var yourNotes = myStorage.view("yourNotes");

				if (!yourNotes) {

				}
				else {
					Template.notifications("notificationsAreaContent", yourNotes);
				}
			}

			$("#pendingNoticesIcon").remove();

			ajaxStatement = $.ajax({
				url: host + "/notifications?access_token="+token+"&limit=12",
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Spinner.off();
					
					if (data.meta.code == 200)
					{
						var version = $.os.version;
						
						if (parseFloat(version) >= 4.0 && parseFloat(version) < 4.1) {
							$("#notify-popup").hide();
						}

						myStorage.save("yourNotes", data.response);
						Template.notifications("notificationsAreaContent", data.response, b);

					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	},
	distinct_beer: function(a,b,c,d) {

		if (c || d) {
			
		}
		
		$(".tab_pub").focus();
		
		var offset = 0;

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			if (a) {
				$("#badgeUserName").val(a);
			}
			else {
				a = $("#badgeUserName").val();
			}

			if ($("#distinctAreaContent div.loading_inner").length != 0) {
				$("#currentFilter").val('');
			}

			if (b) {
				$("#see_more_distinct").hide();
				$("#distinct_loader").show();
				a = $("#badgeUserName").val();
				offset = $(".distinct-beer-list").length;
				myScroll.disable();
			}
			else {

				$("#see_more_distinct").hide();

				$("#distinctAreaContent").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');

				$("#badgeUserName").val(a);

				offset = 0;
			}

			var txt = "";

			var sort = $("#currentFilter").val();

			if (sort != "") {
				txt = "&sort="+sort;
			}
			else {
				if (c) {
					txt = "&sort="+c;
				}
			}

			var search = "";

			if (d) {
				search = "&"+$("#distinctFormSearch").serialize();
			}

			ajaxStatement = $.ajax({
				url: host + "/user/beers/"+a+"?access_token="+token+"&limit=15&offset="+offset+txt+search,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					if (b) {
						refreshScroll.enable();
					}
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (b) {
						$("#see_more_distinct").show();
						$("#distinct_loader").hide();
					}

					if (data.meta.code == 200)
					{
						if (data.response.count == 0) {
							$("#see_more_distinct").hide();
						}

						console.log(myHistory);

						try {
							if (myHistory.slice(-1)[0] == "yourArea") {
								$("#prefixBeers").html("Your ");
							}
							else {
								$("#prefixBeers").html('');
							}
						}
						catch (err) {
							$("#prefixBeers").html('');
						}

						Template.distinct_beer("distinctAreaContent", data.response, b);
					}
					else
					{
						if (b) {
							refreshScroll.enable();
						}

						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	},
	badge_single: function(a,b) {

		var j = $("#badgeDetails_"+b).html();

		console.log($("#badgeDetails_"+b).length);

		if ($("#badgeDetails_"+b).length != 0)
		{
			var fix = JSON.parse(j);

			if (parseInt(a) == 0)
			{
				Template.badge_single("badgeSingle", fix, "unearned");

				clearAjax();

				var token = Validate.token();

				if (!token)
				{
					Error.token();
				}
				else
				{
					ajaxStatement = $.ajax({
						url: host + "/badges/status/"+b+"?access_token="+token,
						type: "GET",
						dataType: "json",
						error: function(xhr,ajaxOptions, thrownError)
						{
							Error.ajax_error(xhr, ajaxOptions, thrownError);
						},
						success: function(data)
						{
							if (data.meta.code == 200)
							{
								Template.badge_single("badgeSingle", data.response.badge, "unearned");
							}
							else
							{
								Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
							}
						}
					});
				}
			}
			else
			{
				Template.badge_single("badgeSingle", fix, "earned");

				clearAjax();

				var token = Validate.token();

				if (!token)
				{
					Error.token();
				}
				else
				{
					ajaxStatement = $.ajax({
						url: host + "/badges/view/"+a+"?access_token="+token,
						type: "GET",
						dataType: "json",
						error: function(xhr,ajaxOptions, thrownError)
						{
							Error.ajax_error(xhr, ajaxOptions, thrownError);
						},
						success: function(data)
						{
							if (data.meta.code == 200)
							{
								Template.badge_single("badgeSingle", data.response.badge, "earned");
							}
							else
							{
								Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
							}
						}
					});
				}
			}
		}
		else {

			Loading.on();

			clearAjax();

			var token = Validate.token();

			if (!token)
			{
				Error.token();
			}
			else
			{
				ajaxStatement = $.ajax({
					url: host + "/badges/view/"+a+"?access_token="+token,
					type: "GET",
					dataType: "json",
					error: function(xhr,ajaxOptions, thrownError)
					{
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					},
					success: function(data)
					{
						Loading.off();

						if (data.meta.code == 200)
						{
							Template.badge_single("badgeSingle", data.response.badge, "earned");
						}
						else
						{
							Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
						}
					}
				});
			}
		}
	},
	user_badges: function(a,b,c,d) {
		
		clearAjax();
		
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			$("#userBadgeAreaContent").html('');

			if (c == "tab") {
				a = $("#badgeUserName").val();
			
				$("#userBadges li a").removeClass("active");
				$(d).addClass('active');
				
				$("#userBadgeAreaContent").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
			}
			else {
				$("#badgeUserName").val(a);
				$("#user_badge_area_loader").show();
			}
		
			
			ajaxStatement = $.ajax({
				url: host + "/user/badges/"+a+"?access_token="+token+"&type=all&sort="+b,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#user_badge_area_loader").hide();
					
					if (data.meta.code == 200)
					{	
						Template.user_badge("userBadgeAreaContent", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	},
	social_scanning: function(a, b) {
		
		$("#user_search_results_notice").hide();
		$("#social-scanning").hide();
		$("#invite-friends").hide();
	
		if (Social.scan_check(a)) {
			
			$("#friendSearchSocialContent").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
			
			var token = Validate.token();

			if (!token)
			{
				Error.token();
			}
			else
			{
				if (!token)
				{
					Error.token();
				}
				else
				{
					ajaxStatement = $.ajax({
						url: host + "/search/social/"+a+"?access_token="+token,
						type: "GET",
						dataType: "json",
						error: function(xhr,ajaxOptions, thrownError)
						{
							Error.ajax_error(xhr, ajaxOptions, thrownError);
						},
						success: function(data)
						{
							if (data.meta.code == 200)
							{		
								if (data.response.friends.count == 0) {

									Page.change("#!/friendSearchArea", "push")
									//location.href = "#!/friendSearchArea";

									Error.handle("<strong>No friends were found social scan on "+a+".</strong>Perhaps you want to invite them, or try another social network to scan?", "", "");

									$("#user_search_results_notice").show();
									$("#friendSearchAreaResultsContent").html('');
									$("#social-scanning").show();
									$("#invite-friends").show();
								}
								else {
									Template.user_search("friendSearchSocialContent", data.response.friends);
								}
							}
							else
							{
								Page.change("#!/friendSearchArea", "push");
								Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
							}
						}
					});
				}
			}
		}
		else {
			Social.start_connect(a);
		}
	},
	user_search: function(a) {
	
		$("#user_search_results_notice").hide();
		$("#social-scanning").hide();
		$("#invite-friends").hide();
		
		Page.change("#!/friendSearchAreaResults", "push")

		//location.href = "#!/friendSearchAreaResults";
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			var d = $(a).serialize();

			ajaxStatement = $.ajax({
				url: host + "/search/friends?access_token="+token,
				type: "GET",
				data: d,
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						
						$(".userSearchTerm").val('');
						
						$("#friendSearchAreaResultsContent").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>')
						
					
						if (data.response.users.count == 0) {
							$("#user_search_results_notice").html("<strong>No friends were found.</strong>Try again and remember to search by full name and user name. You can also scan your social networks below.");
							$("#user_search_results_notice").show();
							$("#friendSearchAreaResultsContent").html('');
							$("#social-scanning").show();
							$("#invite-friends").show();
							
						}
						else {
							Template.user_search("friendSearchAreaResultsContent", data.response.users);
						}
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
		return false;
	},
	brewery_search_more: function() {

		var offset = $(".brewery-search").length;

		$("#brewery_search_loader").show();
		$("#see_more_brewery_search").hide();

		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			var d = $("#searchMoreForm").serialize();
			
			var u = host + "/search/brewery?access_token="+token+"&"+d+"&offset="+offset;

			ajaxStatement = $.ajax({
				url: u,
				type: "GET",
				data: d,
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#brewery_search_loader").hide();
					$("#see_more_brewery_search").show();

					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#brewery_search_loader").hide();
					$("#see_more_brewery_search").show();

					if (data.meta.code == 200)
					{
						if (data.response.brewery.count == 0 && data.response.brewery.count == 0) {
							$("#see_more_brewery_search").hide();
						}

						Template.brewery_search_append("brewery-search-content", data.response);
						
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
		return false;

	},
	beer_search_more: function() {

		var offset = $(".beer-search").length;

		$("#beer_search_loader").show();
		$("#see_more_search").hide();

		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			var d = $("#searchMoreForm").serialize();
			
			var u = host + "/search/beer?access_token="+token+"&limit=15&offset="+offset;

			ajaxStatement = $.ajax({
				url: u,
				type: "GET",
				data: d,
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#beer_search_loader").hide();
					$("#see_more_search").show();

					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#beer_search_loader").hide();
					$("#see_more_search").show();

					if (data.meta.code == 200)
					{
						if (data.response.beers.count == 0 && data.response.beers.count == 0) {
							$("#see_more_search").hide();
						}

						Template.beer_search_append("searchAreaContent", data.response);
						
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
		return false;

	},
	beer_search: function(a) {

		$(".tab_pub").focus();
		
		Toggle.tabs($("#beer-search-tab-first"), 'search-tab-toggle', 'beer-search', 'beer-search-results-tab');
		
		$("#beer-search").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
		
		var fromPage = $("#container div.active_page");

		var fromID = $(fromPage).attr("id");

		if (fromID == "drinkArea") {

			var v = $("#drinkArea .beerSearchTermSearch").val();

			$("#searchArea .beerSearchTermSearch").val(v);

		}

		Page.change("#!/searchArea", "push");
		//location.href = "#!/searchArea";

		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			var d = $(a).serialize();

			var u = host + "/search/beer?access_token="+token+"&limit=15";

			ajaxStatement = $.ajax({
				url: u,
				type: "GET",
				data: d,
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						Template.beer_search("searchAreaContent", data.response, a);
						
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
		return false;
		
		
	},
		wishlist: function(a,b,you) {

		console.log(a + " " + b + " " + you);

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			$("#activeUser").val(a);
			$("#activeUserYou").val(you);

			var endURL = "";

			if (b == "append") {

				var o = $("#wishListAreaContentArea div.user_wishlist_item").length;

				endURL = host + "/user/wishlist/"+a+"?access_token="+token+"&offset="+o+"&limit=15";

				$("#see_more_wish_list").hide();
				$("#see_more_wish_list_loader").show();

			}
			else {

				$("#wishListButtons").html('');

				$("#wishListAreaContentArea").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');

				endURL = host + "/user/wishlist/"+a+"?access_token="+token+"&limit=15";
			}

			ajaxStatement = $.ajax({
				url: endURL,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#see_more_wish_list").hide();
					$("#see_more_wish_list_loader").show();

					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#see_more_wish_list_loader").hide();

					if (data.meta.code == 200)
					{
						if (data.response.beers.count == 0) {
							$("#see_more_wish_list").hide();
						}
						else {
							$("#see_more_wish_list").show();
						}

						var path = "wishListAreaContentArea";

						console.log(data.response.beers);

						if (b == "append") {
							Template.user_wishlist(path, data.response.beers, a, "append", you);
						}	
						else {
							console.log("full");
							Template.user_wishlist(path, data.response.beers, a, "full", you);
						}
						
					}
					else
					{
						$("#wishlist_stream_profile").hide();
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}

	},
	recommend: function(a) {
		
		//window.scroll(0,0);
		//myScroll.scrollTo(0,0,0);

		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{	
			$("#more_suggestions").hide();
			
			if (a) {
				$("#more_suggestions_loader").show();
				$("#more_suggestions").hide();
			}			
				
			ajaxStatement = $.ajax({
				url:  host + "/beer/recommend/?access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#more_suggestions_loader").hide();
					$("#more_suggestions").show();
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#more_suggestions_loader").hide();
					$("#more_suggestions").show();
					
					if (data.meta.code == 200)
					{
						if (a && data.response.beers.count == 0) {
							$("#more_suggestions").hide();
						}

						Template.recommend("suggestAreaContent", data.response.beers, a);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
			
		}
	},
	user_friends: function(a,b) {

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var endURL = "";


			if (b == "append") {

				$("#see_more_user_friends").hide();
				$("#see_more_user_friends_loader").show();

				var o = $("#userFriendListContentArea div.list_box").length;


				endURL = host + "/user/friends/"+a+"?access_token="+token+"&limit=12&offset="+o;
			}
			else {

				$("#userFriendsButtons").html('');

				$("#userFriendListContentArea").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');

				endURL = host + "/user/friends/"+a+"?access_token="+token+"&limit=12";
			}


			ajaxStatement = $.ajax({
				url: endURL,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#see_more_user_friends").show();
					$("#see_more_user_friends_loader").hide();

					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					
					$("#see_more_user_friends_loader").hide();

					if (data.meta.code == 200)
					{
						Notifications.set(data.notifications);

						friends = data.response;

						if (friends.count == 0) {
							$("#see_more_user_friends").show();
						}

						var path = "userFriendListContentArea";

						Template.user_friends(path, friends, a, b);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});

		}
	},
	friend_requests: function(a,b,c) {

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			if (a)
			{
				$("#more_friends").hide();
				$("#more_friends_list_loader").show();

				var offset = $("#currentFriendsArea div.list_box").length;

				ajaxStatement = $.ajax({
					url: host + "/user/friends?access_token="+token+"&offset="+offset,
					type: "GET",
					dataType: "json",
					error: function(xhr,ajaxOptions, thrownError)
					{
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					},
					success: function(data)
					{
						$("#more_friends_list_loader").hide();
						$("#more_friends").show();

						if (data.meta.code == 200)
						{
							friends_more = data.response;
							Template.see_more_friends(friends_more);
						}
						else
						{
							Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
						}
					}
				});
			}
			else
			{
				var d = myStorage.view("myFriends");
				var pending = {};
				var friends = {};

				
				ajaxStatement = $.ajax({
					url: host + "/user/friends?access_token="+token+"&limit=15",
					type: "GET",
					dataType: "json",
					error: function(xhr,ajaxOptions, thrownError)
					{
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					},
					success: function(data)
					{
						if (data.meta.code == 200)
						{
							friends = data.response;

							myStorage.save("myFriends", data.response);

							Template.just_friends("friendlistAreaContent", friends);

						}
						else
						{
							Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
						}
					}
				});


				ajaxStatement = $.ajax({
					url: host + "/user/pending?access_token="+token,
					type: "GET",
					dataType: "json",
					error: function(xhr,ajaxOptions, thrownError)
					{
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					},
					success: function(data)
					{
						if (data.meta.code == 200)
						{
							pending = data.response;

							if (pending.count == 0) {
								$("#request_number").html("");
								$("#request_number").addClass("hide");
							}
							else {
								$("#request_number").html("("+pending.count+")");
								$("#request_number").removeClass("hide");
							}

							Template.pending_friends("friendlistAreaContent", null, pending, c);
						}
						else
						{
							Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
						}
					}
				});
			
				
			}
		}
	},
	resubmit: function(a,b) {
		
		$(".addLocationBtn").hide();
		
		console.log(globalBID);
		
		clearAjax();
		
		$("#venue-search").hide();
		
		var l = JSON.parse($("#venuedetail_"+a).html());
		var j = JSON.parse($("#checkinbid_"+globalBID).html());
		
		var beerObj = {};
		
		beerObj["beer"] = j.beer;
		beerObj["brewery"] = j.brewery;
		beerObj["rating"] = j.rating;
		beerObj["venue"] = l;
		beerObj["is_loc"] = b;
		
		Template.resubmit(beerObj);
	},
	foursquare_venues: function(position) {
		
		//geo.clearWatch(watchId);
		Geolocate.save(position);

		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			currentLat = position.coords.latitude;
			currentLng = position.coords.longitude;
			
			var d = new Date();
			var n = d.getTime();
			
			lastUpdated = n;

			if (currentLat == "" || currentLat == "") {
				Error.handle("We couldn't seem to locate you. Please try again or visit http://untp.it/gps for tips on how to fix this issue.", "Error", 500);
			}
			else {

				ajaxStatement = $.ajax({
					url: host + "/venue/around?lat="+position.coords.latitude+"&lng="+position.coords.longitude+"&access_token="+token,
					type: "GET",
					dataType: "json",
				    error: function(xhr,ajaxOptions, thrownError)
					{
						Loading.off();
						
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					},
					success: function(data)
					{
						Loading.off();
						
						if (data.meta.code == 200)
						{
							Template.venue_location("locationAreaContent", data.response);
						}
						else
						{
							Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
						}
					}
				});

			}
			
			
			
		}
		
		
	},
	foursquare_venue_search: function(lat, lng, term) {

		$(".tab_pub").focus();

		var fromPage = $("#container div.active_page");

		var fromID = $(fromPage).attr("id");

		if (fromID == "locationArea") {

			var v = $("#locationArea .locationSearchTerm").val();

			$("#searchlocationArea .locationSearchTerm").val(v);
		}
		
		Page.change("#!/searchlocationArea", "push");

		//location.href = "#!/searchlocationArea";
		
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			ajaxStatement = $.ajax({
				url: host + "/venue/around?"+term+"&lat="+lat+"&lng="+lng+"&access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						Template.venue_location("searchlocationAreaContent", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	
	},
	around_me: function(position) {
		
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			if ($("#aroundAreaContent_content div.loading_inner").length != 0) {
				$("#aroundAreaContent_content").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
			}
			
			Geocode.reverse(position.coords.latitude, position.coords.longitude);
			
			ajaxStatement = $.ajax({
				url: host + "/thepub/local?limit=15&lat="+position.coords.latitude+"&lng="+position.coords.longitude+"&access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						Template.friend("aroundAreaContent_content", data);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	},
	media_single: function(a,b) {
		
		if (b == "single") {
			var j = $("#singlePhoto_"+a).html();

			if (j != "")
			{
				var fix = JSON.parse(j);

				Template.photo_single("photosSingleArea", fix);
			}
		}
		else if (b == "user") {
			var j = $("#photocheckinuser_"+a).html();

			if (j != "")
			{
				var fix = JSON.parse(j);

				Template.photo_single("photosSingleArea", fix);
			}
		}
		else if (b == "beer") {
			var j = $("#photocheckinbeer_"+a).html();

			if (j != "")
			{
				var fix = JSON.parse(j);

				Template.photo_single("photosSingleArea", fix);
			}
		}
		else if (b == "venue") {
			var j = $("#photocheckinvenue_"+a).html();

			if (j != "")
			{
				var fix = JSON.parse(j);

				Template.photo_single("photosSingleArea", fix);
			}
		}
		else {
			var j = $("#photocheckinbrewery_"+a).html();

			if (j != "")
			{
				var fix = JSON.parse(j);

				Template.photo_single("photosSingleArea", fix);
			}
		}
		
	},
	media: function(a,b,c) {
		
		clearAjax();
				
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			var get_url;
			
			if (c) {
				
			}
			else {
				$("#photosGalleryArea").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
			}
			
			$("#see_more_photos").hide();
			$("#more_photo_loader").show();
			
			if (a == "user")
			{
				if (c) 
				{
					get_url = host + "/user/photos/"+b+"?access_token="+token+"&limit=12&max_id="+c;
				}
				else
				{
					get_url = host + "/user/photos/"+b+"?access_token="+token+"&limit=12";
				}
			}
			else if (a == "beer")
			{
				if (c) {
					get_url = host + "/beer/photos/"+b+"?access_token="+token+"&max_id="+c+"&limit=12";
				}
				else
				{
					get_url = host + "/beer/photos/"+b+"?access_token="+token+"&limit=12";
				}
			}
			else if (a == "venue")
			{
				if (c) {
					get_url = host + "/venue/photos/"+b+"?access_token="+token+"&max_id="+c+"&limit=12";
				}
				else
				{
					get_url = host + "/venue/photos/"+b+"?access_token="+token+"&limit=12";
				}
			}
			else
			{
				if (c) {
					get_url = host + "/brewery/photos/"+b+"?access_token="+token+"&max_id="+c+"&limit=12";
				}
				else
				{
					get_url = host + "/brewery/photos/"+b+"?access_token="+token+"&limit=12";
				}
			}

			ajaxStatement = $.ajax({
				url: get_url,
				type: "GET",
				dataType: "json",
			    error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
					$("#more_photo_loader").hide();
				},
				success: function(data)
				{
					$("#more_photo_loader").hide();
					
					if (data.meta.code == 200)
					{
						if (data.response.count != 0) {
							$("#see_more_photos").show();
						}

						Template.photo_gallery("photosGalleryArea", data.response, a, b, c);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
			
		}
		
		
	},
	more_public: function(a) {
		
		clearAjax();
				
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			$("#see_more_pub").hide()
			$("#see_more_pub_loader").show();

			var a = $("#publicAreaContent_content div.activity_item:last").attr("data-checkin-id");

			ajaxStatement = $.ajax({
				url: host + "/thepub?access_token="+token+"&max_id="+a,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#see_more_pub").show();
					$("#see_more_pub_loader").hide();
					
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#see_more_pub").show();
					$("#see_more_pub_loader").hide();

					if (data.meta.code == 200)
					{
						Template.pub("publicAreaContent_content", data.response, true);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
		
	},
	pub: function(a) {
		
		$(".location_bar").hide();
		
		clearAjax();
				
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			var publicFeed = myStorage.view("publicFeed");
			
			if (a) {
				
			}
			else {
				var publicFeed = myStorage.view("publicFeed");

				if (!publicFeed) {
				
				}
				else {
					Template.friend("publicAreaContent_content", publicFeed);
				}
			}
			
			ajaxStatement = $.ajax({
				url: host + "/thepub?access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Spinner.off();
					
					if (data.meta.code == 200)
					{
						myStorage.save("publicFeed",  data);
						Template.pub("publicAreaContent_content", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	},
	more_friends: function(b) {

		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			$(b).hide();
			$("#more_friends_loader").show();
			
			var a = $("#friendsAreaContent_content div.activity_item:last").attr("data-checkin-id");

			ajaxStatement = $.ajax({
				url: host + "/checkin/recent?access_token="+token+"&max_id="+a,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#more_friends_loader").hide();
					$(b).show();
					
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#more_friends_loader").hide();
					
					
					if (data.meta.code == 200)
					{
						if (data.response.checkins.count == 0) {
							$(b).hide();
						}
						else {
							$(b).show();
						}
						
						Template.friend("friendsAreaContent_content", data, "append");
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	},
	find_beer: function(position) {
		
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			currentLat = position.coords.latitude;
			currentLng = position.coords.longitude;
			
			Geocode.reverse(currentLat, currentLng);
			
			var dis = myStorage.view("distanceBeer");
			var rad = 5;
			
			if (!dis) {
				rad = 5;
			}	
			else {
				rad = dis;
			}
			
			$("#findBeerAreaContent").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
			
			ajaxStatement = $.ajax({
				url: host + "/beer/find/"+findBeer+"?access_token="+token+"&lat="+currentLat+"&lng="+currentLng+"&radius="+rad,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						
						Template.find_beer("findBeerAreaContent", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	},
	venue_full: function(a) {

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			ajaxStatement = $.ajax({
				url: host + "/venue/info/"+a+"?access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						Template.venue_full("venueArea", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}

	},
	venue: function(a,b,c) {
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			if (c == "discoverBeer") {
				
				var j = $("#discoverBeer_"+b).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.venue("venueArea", fix, true);
				}
				
			}
			else if (c == "venueStats") {
				
				var j = $("#venueStats_"+a).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
					
					Template.venue("venueArea", fix, true);
				}
				
			}
			else if (c == "map") {
				
				var j = $("#mapvenue_"+a).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
					
					Template.venue("venueArea", fix, true);
				}
				
			}
			else if (c == "discoverVenues") {
				
				var j = $("#discoverVenue_"+a).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
					
					console.log(fix);
					
					Template.venue("venueArea", fix, true);
				}
				
			}
			else if (c == "badgedetail") {

				var j = $("#venuebadge_"+a).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.venue("venueArea", fix, true);
				}

			}
			else {
				var j = $("#checkindetail_"+b).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.venue("venueArea", fix, true);
				}
			}
			
			ajaxStatement = $.ajax({
				url: host + "/venue/info/"+a+"?access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						Template.venue("venueDetailsArea", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});	
		}
	},
	friends: function(refresh, start) {

		$(".location_bar").hide();

		/*if (start) {
			$("#friendsArea ul li a").removeClass("active");
			$("#friendsArea ul li a:first").addClass("active");
			$("header").removeClass("hide").addClass("show");
			var source   = $("#activity-header").html();
			$(".activity-tab").hide();
			$("#friendsAreaContent_content").show();
			$("#header-buttons").html(source);
			Page.change("#!/friendsArea", "show");
		}*/

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var friendFeed = myStorage.view("friendFeed");

			if (!friendFeed) {

				ajaxStatement = $.ajax({
					url: host + "/checkin/recent?limit=15&access_token="+token,
					type: "GET",
					dataType: "json",
					error: function(xhr,ajaxOptions, thrownError)
					{
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					},
					success: function(data)
					{
						console.log("data done stored");

						if (data.meta.code == 200)
						{
							Notifications.set(data.notifications);

							Spinner.off();

						
							myStorage.save("friendFeed",  data);
							Template.friend("friendsAreaContent_content", data);

							//Garbage.remove('activity_stream');
						}
						else
						{
							Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
						}
					}
				});
			}
			else
			{

				if (start) {
					Template.friend("friendsAreaContent_content", friendFeed);
				}

				if (refresh) {
					ajaxStatement = $.ajax({
						url: host + "/checkin/recent?limit=15&access_token="+token,
						type: "GET",
						dataType: "json",
						error: function(xhr,ajaxOptions, thrownError)
						{
							Error.ajax_error(xhr, ajaxOptions, thrownError);
						},
						success: function(data)
						{
							if (data.meta.code == 200)
							{
								Notifications.set(data.notifications);

								if (data.notifications.unread_count.friends >= 1) {
									$(".activity-header a.friends").prepend('<span class="pending">!</span>');
								}
								else {
									$(".activity-header span.pending").remove();
								}

								myStorage.save("friendFeed",  data);
								Template.friend("friendsAreaContent_content", data);

								//Garbage.remove('activity_stream');
							}
							else
							{
								Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
							}
						}
					});
				}
				else
				{
					Template.friend("friendsAreaContent_content", friendFeed);
					Feed.friends(true);
				}
			}
		}

	},
	your_profile: function(a) {

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			Spinner.on();

			if (a) {

			}
			else {

				if ($("#yourArea").html() == "") {

					var yourProfile = myStorage.view("yourProfile");

					if (!yourProfile) {

					}
					else {
						Template.your_full_profile("yourAreaContent", yourProfile);
					}
				}
			}

			ajaxStatement = $.ajax({
				url: host + "/user/info?access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Spinner.off();

					if (data.meta.code == 200)
					{
						Pending.friends();
						Notifications.set(data.notifications);
						myStorage.save("yourProfile", data.response);

						if (a) {
							Template.your_full_profile("yourAreaContent", data.response);
						}
						else {
							Template.your_profile("yourProfileDetails", data.response);
						}
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	},
	profile: function(user, checkin_id, loc) {
		
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{

			$("#activeUser").val(user);
			$("#activeUserYou").val("false");

			if (loc == "pending")
			{
				var j = $("#pendingFriend_"+checkin_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.profile("profileArea", fix, true);
				}
			}
			else if (loc == "friends") {
				var j = $("#currentFriend_"+checkin_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.profile("profileArea", fix, true);
				}
			}
			else if (loc == "toast") {
				var j = $("#toastprofile_"+checkin_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
					
					Template.profile("profileArea", fix, true);
				}
			}
			else if (loc == "comment") {
				var j = $("#commentprofile_"+checkin_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
					
					Template.profile("profileArea", fix, true);
				}
			}
			else if (loc == "friend_list") {
				var j = $("#userfrienddetaiL_"+checkin_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.profile("profileArea", fix, true);
				}
			}
			else {			
				if (checkin_id) {
					var j = $("#checkindetail_"+checkin_id).html();

					if (j != "")
					{
						var fix = JSON.parse(j);

						Template.profile("profileArea", fix, true);
					}
				}
				else {
					$("#profileArea").html('');
				}
			}
			
	
			ajaxStatement = $.ajax({
				url: host + "/user/info/"+user+"?access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Spinner.off();
					
					if (data.meta.code == 200)
					{
						Notifications.set(data.notifications);
						
						Template.profile("profileDetailsArea", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	},
	more_user_activity: function(user) {
	
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			$("#user_activity_loader").show();
			$("#see_more_user_activity").hide();
			
			var offset = $("#activity_stream_profile_content div.activity_item:last").attr("data-checkin-id");
			
			ajaxStatement = $.ajax({
				url: host + "/user/checkins/"+user+"?access_token="+token+"&max_id="+offset,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#user_activity_loader").hide();
					$("#see_more_user_activity").show();
					
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#user_activity_loader").hide();
					$("#see_more_user_activity").show();
					
					if (data.meta.code == 200)
					{
						if (data.response.checkins.count == 0) {
							$("#see_more_user_activity").hide();
						}
						
						Template.profile_activity(data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	
		
	},
	stats_new_beers: function(a) {

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var age = $("#ageParam").val();

			var urlToGo = host + "/user/stats/new_beers?access_token="+token+"&age="+age;

			if (a) {

				$("#see_more_new_beers").hide();
				$("#see_more_new_beers_loader").show();

				var offset = $("#statsAreaNewBeersContent div.list_box").length;

				urlToGo = host + "/user/stats/new_beers?access_token="+token+"&age="+age+"&offset="+parseInt(offset);
			}

			$(".ageCount").html(age);

			ajaxStatement = $.ajax({
				url: urlToGo,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					if (a) {
						$("#see_more_new_beers").show();
						$("#see_more_new_beers_loader").hide();
					}

					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#see_more_new_beers_loader").hide();

					if (data.meta.code == 200)
					{
						if (data.response.beers.count == 0) {
							$("#see_more_new_beers").hide();
						}
						else {
							$("#see_more_new_beers").show();
						}

						Template.stats_new_beers("statsAreaNewBeersContent", data.response, a);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	},
	stats_new_venues: function(a) {

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var age = $("#ageParam").val();

			var urlToGo = host + "/user/stats/new_venues?access_token="+token+"&age="+age;

			if (a) {

				$("#see_more_new_venues").hide();
				$("#see_more_new_venues_loader").show();

				var offset = $("#statsAreaNewVenuesContent div.list_box").length;

				urlToGo = host + "/user/stats/new_venues?access_token="+token+"&age="+age+"&offset="+parseInt(offset);
			}

			$(".ageCount").html(age);

			ajaxStatement = $.ajax({
				url: urlToGo,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					if (a) {
						$("#see_more_new_venues").show();
						$("#see_more_new_venues_loader").hide();
					}

					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#see_more_new_venues_loader").hide();

					if (data.meta.code == 200)
					{
						if (data.response.venues.count == 0) {
							$("#see_more_new_venues").hide();
						}
						else {
							$("#see_more_new_venues").show();
						}
						
						Template.stats_new_venues("statsAreaNewVenuesContent", data.response, a);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	},
	stats_beer_styles: function(a, append) {

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var j = $("#beerstylesinfo_"+a).html();

			if (j != "")
			{
				var fix = JSON.parse(j);

				$(".styleName").html(fix.beer_style);
			}

			var age = $("#ageParam").val();

			var urlToGo = host + "/user/stats/top_beers_by_style?access_token="+token+"&age="+age+"&type_id="+a;

			if (append) {

				$("#see_more_new_styles").hide();
				$("#see_more_new_styles_loader").show();

				var offset = $("#statsAreaBeerStyleContent  div.list_box").length;

				urlToGo = host + "/user/stats/top_beers_by_style?access_token="+token+"&age="+age+"&offset="+parseInt(offset)+"&type_id="+a;
			}

			$(".ageCount").html(age);

			ajaxStatement = $.ajax({
				url: urlToGo,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					if (a) {
						$("#see_more_new_styles").show();
						$("#see_more_new_styles_loader").hide();
					}

					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#see_more_new_styles_loader").hide();

					if (data.meta.code == 200)
					{
						if (data.response.beers.count == 0) {
							$("#see_more_new_styles").hide();
						}
						else {
							$("#see_more_new_styles").show();
						}
						
						Template.stats_beer_styles("statsAreaBeerStyleContent", data.response, a, append);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	},
	stats: function(a) {

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			Util.closePop();

			var statsURL = host + "/user/stats/?access_token="+token;

			if (a) {

				myStorage.save("statsRangeSettings", a);

				statsURL = host + "/user/stats/?access_token="+token+"&age="+a;

				$("#ageStats").html(a);

				$(".ageCount").html(a);

				$("#ageParam").val(a);
			}
			else {

				myStorage.save("statsRangeSettings", 30);

				$("#ageStats").html(30);

				$("#ageParam").val(30);
			}

			ajaxStatement = $.ajax({
				url: statsURL,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						Template.stats("statsAreaContent", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}

	},
	full_activity: function(user) {

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			ajaxStatement = $.ajax({
				url: host + "/user/checkins/"+user+"?access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#activity_loader").hide();
					$("#see_more_activity").show();

					if (data.meta.code == 200)
					{
						if (data.response.checkins.count == 0) {
							$("#see_more_activity").hide();
						}

						Template.profile_activity("listCheckinsAreaContentArea", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}


	},
	more_activity: function(user) {

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			$("#see_more_activity").hide();
			$("#activity_loader").show()

			var offset = $("#listCheckinsAreaContentArea div.activity_item:last").attr("data-checkin-id");

			ajaxStatement = $.ajax({
				url: host + "/user/checkins/"+user+"?access_token="+token+"&max_id="+offset,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#activity_loader").hide();
					$("#see_more_activity").show();
					

					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#activity_loader").hide();
					$("#see_more_activity").show();

					if (data.meta.code == 200)
					{
						if (data.response.checkins.count == 0) {
							$("#see_more_activity").hide();
						}

						Template.profile_activity("listCheckinsAreaContentArea", data.response, "append");
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}


	},
	beer_activity: function(bid) {
	
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			$("#beer_activity_loader").show();
			$("#see_more_beer_activity").hide();
			
			var offset = $("#beer_stream_profile_content div.activity_item:last").attr("data-checkin-id");
			
			ajaxStatement = $.ajax({
				url: host + "/beer/checkins/"+bid+"?access_token="+token+"&max_id="+offset,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#beer_activity_loader").hide();
					$("#see_more_beer_activity").show();
					
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#beer_activity_loader").hide();
					$("#see_more_beer_activity").show();
					
					if (data.meta.code == 200)
					{
						if (data.response.checkins.count == 0) {
							$("#beer_activity_loader").hide();
						}
						
						Template.beer_activity(data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	
		
	},
	venue_activity: function(vid) {
	
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			$("#venue_activity_loader").show();
			$("#see_more_venue_activity").hide();
			
			var offset = $("#venue_stream_profile_content div.activity_item:last").attr("data-checkin-id");
			
			ajaxStatement = $.ajax({
				url: host + "/venue/checkins/"+vid+"?access_token="+token+"&max_id="+offset,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#venue_activity_loader").hide();
					$("#see_more_venue_activity").show();
					
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#venue_activity_loader").hide();
					$("#see_more_venue_activity").show();
					
					if (data.meta.code == 200)
					{
						if (data.response.checkins.count == 0) {
							$("#see_more_venue_activity").hide();
						}
						
						Template.venue_activity(data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	
		
	},
	your_activity: function(vid) {
	
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			$("#your_activity_loader").show();
			$("#see_more_your_activity").hide();
			
			var offset = $("#your_activity_stream_profile_content div.activity_item:last").attr("data-checkin-id");
			
			ajaxStatement = $.ajax({
				url: host + "/user/checkins/"+vid+"?access_token="+token+"&max_id="+offset,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#your_activity_loader").hide();
					$("#see_more_your_activity").show();
					
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#your_activity_loader").hide();
					$("#see_more_your_activity").show();
					
					if (data.meta.code == 200)
					{
						if (data.response.checkins.count == 0) {
							$("#see_more_your_activity").hide();
						}
						
						Template.your_activity(data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}	
	},
	brewery_activity: function(brewery_id) {
	
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			$("#brewery_activity_loader").show();
			$("#see_more_brewery_activity").hide();
			
			var offset = $("#brewery_stream_profile div.activity_stream div.activity_item").length;
			
			ajaxStatement = $.ajax({
				url: host + "/brewery/checkins/"+brewery_id+"?access_token="+token+"&offset="+offset,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#brewery_activity_loader").hide();
					$("#see_more_brewery_activity").show();
					
					if (data.meta.code == 200)
					{
						if (data.response.checkins.count == 0) {
							$("#see_more_brewery_activity").hide();
						}
						
						Template.brewery_activity(data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	
		
	},
	more_beer: function(brewery_id) {
		
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{	
			$("#see_more_brewery_beer").hide();
			$("#brewery_beer_loader").show();
			
			var len = $("#brewery_beer_list_stream div.list_box").length;
			
			ajaxStatement = $.ajax({
				url: host + "/brewery/beer_list/"+brewery_id+"?access_token="+token+"&offset="+len+"&limit=15",
				type: "GET",
				dataType: "json",
			    error: function(xhr,ajaxOptions, thrownError)
				{
					$("#see_more_brewery_beer").show();
					$("#brewery_beer_loader").hide();
					
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Spinner.off();
					
					
					$("#see_more_brewery_beer").show();
					$("#brewery_beer_loader").hide();
					
					if (data.meta.code == 200)
					{
						/*if (data.response.beers.count == 0) {
							$("#see_more_brewery_beer").hide();
						}*/
						
						Template.brewery_list(data.response.beers);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	},
	brewery_full_pull: function(brewery_id) {
		
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			
			
			ajaxStatement = $.ajax({
				url: host + "/brewery/info/"+brewery_id+"?access_token="+token,
				type: "GET",
				dataType: "json",
			    error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Spinner.off();
					
					if (data.meta.code == 200)
					{
						if (data.notifications.unread_count.friends >= 1) {
								$("#pendingFriendsNotice").prepend('<span class="pending">!</span>');
						}
						else {
							$("#pendingFriendsNotice span.pending").remove();
						}

						Template.brewery_full("breweryDetailsArea", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	},
	brewery: function(brewery_id, a) {
		
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			
			if (a == "beertemplate") {
				var j = $("#brewerybeer_"+brewery_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.brewery("breweryArea", fix, true);
				}
			}
			else if (a == "full") {
				$("#breweryArea").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
			}
			else {
				var j = $("#brewerysearch_"+brewery_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.brewery("breweryArea", fix, true);
				}
			}

			ajaxStatement = $.ajax({
				url: host + "/brewery/info/"+brewery_id+"?access_token="+token,
				type: "GET",
				dataType: "json",
			    error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Spinner.off();
					
					if (data.meta.code == 200)
					{
						if (a == "full") {
							Template.brewery_full("breweryArea", data.response);
						}
						else {
							Template.brewery("breweryDetailsArea", data.response);
						}
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
			
	},
	your_side: function(a,b,c) {
		
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{		
			var source;
			var url;
			var type = "filter";
			
			if (c) {
				type = "full";
			}
		
			if (a == "beer") {
				url = host + "/beer/checkins/"+b+"?access_token="+token+"&type="+type;
				source = "beer_stream_profile_content";
				
				$("#see_more_beer_activity").hide();

				Toggle.tabs($(".beer-activity-tab ul li a:first"), 'beer_tabs', 'beer_stream_profile','beer-activity-tab')
			
			}
			else if (a == "venue") {
				url = host + "/venue/checkins/"+b+"?access_token="+token+"&type="+type;
				source = 'venue_stream_profile_content';

				$("#see_more_venue_activity").hide();
				
				Toggle.tabs($(".venue-activity-tab ul li a:first"), 'venue_tab_content', 'venue_stream_profile', 'venue-activity-tab');
			
			}
			else {
				url = host + "/brewery/checkins/"+b+"?access_token="+token+"&type="+type;
				source = "brewery_stream_profile_content";

				$("#see_more_brewery_activity").hide();
				
				Toggle.tabs($(".brewery-activity-tab ul li a:first"), 'brewery_tabs', 'brewery_stream_profile', 'brewery-activity-tab');
			}
			
			$("#"+source).html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
			
			var p = $("#"+source).offset();
			
			window.scroll(0,p.top);
			
			ajaxStatement = $.ajax({
				url: url,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Spinner.off();
					
					
					if (data.meta.code == 200)
					{
						Template.your_checkins(source, data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
		
	},
	beer_full: function(bid) {

		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			ajaxStatement = $.ajax({
					url: host + "/beer/info/"+bid+"?access_token="+token,
					type: "GET",
					dataType: "json",
					error: function(xhr,ajaxOptions, thrownError)
					{
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					},
					success: function(data)
					{
						if (data.meta.code == 200)
						{
							if (data.notifications.unread_count.friends >= 1) {
								$("#pendingFriendsNotice").prepend('<span class="pending">!</span>');
							}
							else {
								$("#pendingFriendsNotice span.pending").remove();
							}

							Template.beer_full("beerArea", data.response);
						}
						else
						{
							Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
						}
					}
				});
		}
	},
	beer: function(bid, checkin_id, area) {
				
		$(".beerSearch").val('');
		$(".beerSearchTermPre").val('');		
				
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
		
			if (area == "recent") {
				var j = $("#beerrecent_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
					
					Template.beer("beerArea", fix, true);
				}
			}
			else if (area == "statsbeer") {
				var j = $("#statsBeer_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
					
					Template.beer("beerArea", fix, true);
				}
			}
			else if (area == "cheers") {
				var j = $("#cheersbeer_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.beer("beerArea", fix, true);
				}
			}
			else if (area == "discoverBeers") {
				
				var j = $("#discoverBeer_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.beer("beerArea", fix, true);
				}
				
			}
			else if (area == "topbeer") {
				
				var j = $("#topbeer_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.beer("beerArea", fix, true);
				}
				
			}
			else if (area == "recommend") {
				
				var j = $("#beerrec_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.beer("beerArea", fix, true, true);
				}
				
			}
			else if (area == "wish") {
				
				var j = $("#beerwish_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.beer("beerArea", fix, true);
				}
				
			}
			else if (area == "search") {
				var j = $("#beersearch_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
										
					Template.beer("beerArea", fix, true);
				}
			}
			else if (area == "trendingBeer") {
				var j = $("#trendingBeer_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
										
					Template.beer("beerArea", fix, true);
				}
			}
			else if (area == "badgedetail") {
				var j = $("#beerbadge_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
										
					Template.beer("beerArea", fix, true);
				}
			}
			else if (area == "distinct") {
				var j = $("#beerdistinct_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
					
					Template.beer("beerArea", fix, true);
				}
			}
			else if (area == "beerfinal") {
				var j = $("#beerfinal").html();

				if (j != "")
				{
					var fix = JSON.parse(j);
					
					Template.beer("beerArea", fix, true);
				}
			}
			else if (area == "beeradd") {
				var j = $("#beeradd_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
				
					Template.beer("beerArea", fix, true);
				}
			}
			else if (area == "wish_list") {
				var j = $("#wishlistbeer_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.beer("beerArea", fix, true);
				}
			}
			else if (area == "venue") {
				var j = $("#beertopvenue_"+bid).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.beer("beerArea", fix, true); 
				}
			}
			else if (area == "full") {
				Feed.beer_full(bid);
			}
			else {
				var j = $("#checkindetail_"+checkin_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.beer("beerArea", fix, true);
				}
			}
			
			if ($("#beerDetailsArea").html() == "") {
				ajaxStatement = $.ajax({
					url: host + "/beer/info/"+bid+"?access_token="+token,
					type: "GET",
					dataType: "json",
					error: function(xhr,ajaxOptions, thrownError)
					{
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					},
					success: function(data)
					{ 
						Spinner.off();
						if (data.meta.code == 200)
						{
							Template.beer("beerDetailsArea", data.response);
						}
						else
						{
							Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
						}
					}
				});
			}
		}
	},
	confirm: function(bid, a) {
		
		clearAjax();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			if (a == "recent") {
				var j = $("#beerrecent_"+bid).html();

				var fix = JSON.parse(j);

				Template.confirm("confirmArea", fix);
			}
			else if (a == "trendingBeer") {
				
				var j = $("#trendingBeer_"+bid).html();

				var fix = JSON.parse(j);

				Template.confirm("confirmArea", fix);
				
			}
			else if (a == "topbeer") {
				
				
				var j = $("#topbeer_"+bid).html();

				var fix = JSON.parse(j);

				Template.confirm("confirmArea", fix);
			}
			else if (a == "venue") {
				
				
				var j = $("#beertopvenue_"+bid).html();

				var fix = JSON.parse(j);

				Template.confirm("confirmArea", fix);
			}
			else if (a == "checkin") {
				
				
				var j = $("#beercheckin_"+bid).html();

				var fix = JSON.parse(j);

				Template.confirm("confirmArea", fix);
			}
			else if (a == "search") {
				var j = $("#beersearch_"+bid).html();

				var fix = JSON.parse(j);

				Template.confirm("confirmArea", fix);
			}
			else {
				var j = $("#beerdetail_"+bid).html();

				var fix = JSON.parse(j);

				Template.confirm("confirmArea", fix);
			}
			
			if ($("#isRecommend").val() == "true") {
				$("#is_reco").val(1);
			}
			else {
				$("#is_reco").val(0);
			}
			
		}
	},
	checkin: function(checkin_id, source, refresh) {
		
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			if (source == "full") {
				console.log("course full");
			}
			else if (source == "notifications") {
				var j = $("#notificationsdetails_"+checkin_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.checkin("indCheckin", fix, source);
				}
			}
			else if (source == "photo") {
				
				var j = $("#photocheckin_"+checkin_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.checkin("indCheckin", fix, source);
				}
			}
			else if (source == "public") {
				
				var j = $("#publicdetails_"+checkin_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);

					Template.checkin("indCheckin", fix, source);
				}
			}
			else {
				
				var j = $("#checkindetail_"+checkin_id).html();

				if (j != "")
				{
					var fix = JSON.parse(j);
	
					Template.checkin("indCheckin", fix, source);
				}
			}
			
			if (source == "photo" || source == "full") {
				
				ajaxStatement = $.ajax({
					url: host + "/checkin/view/"+checkin_id+"?access_token="+token,
					type: "GET",
					dataType: "json",
					error: function(xhr,ajaxOptions, thrownError)
					{
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					},
					success: function(data)
					{ 
						console.log(data.response.checkin);

						Spinner.off();
						
						if (data.meta.code == 200)
						{
							if (data.notifications.unread_count.friends >= 1) {
								$("#pendingFriendsNotice").prepend('<span class="pending">!</span>');
		
							}
							else {
								$("#pendingFriendsNotice span.pending").remove();
							}

							Template.checkin("indCheckin", data.response.checkin, source);
						}
						else
						{
							Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
						}
					}
				});
				
			}
			else {
				
				ajaxStatement = $.ajax({
					url: host + "/checkin/view/"+checkin_id+"?access_token="+token,
					type: "GET",
					dataType: "json",
					error: function(xhr,ajaxOptions, thrownError)
					{
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					},
					success: function(data)
					{ 
						Spinner.off();
						if (data.meta.code == 200)
						{
							if (data.response.checkin.toasts.auth_toast) {
								$(".toast").addClass('active');
							}
							
							Template.checkin_interaction("", data.response.checkin, source);
						}
						else
						{
							Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
						}
					}
				});
			}
		}
	}
}