var Geocode = {
	reverse: function(lat,lng) {
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			console.log(lat + " " + lng);

		 	$.ajax({
				url: host + "/location/street?lat="+lat+"&lng="+lng+"&access_token="+token,
				type: "GET",
				dataType: "json",
			    error: function(html)
				{
					// error goes here
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						if (data.response.address.road) {
							if (data.response.address.city) {
								var shortStreet = data.response.address.road + " - " + data.response.address.city + ", " + data.response.address.state;
							}
							else {
								var shortStreet = data.response.address.road + " - " + data.response.address.state;
							}
						}
						else {
							if (data.response.address.city) {
								var shortStreet = data.response.address.city + ", " + data.response.address.state;
							}
							else {
								var shortStreet = data.response.address.state;
							}
						}
					
						if (data.response.display_name) {
							$(".nearObj").html("Near: " + shortStreet);
						}
						else {
							$(".nearObj").html("Near: A Secret Place!");
						}
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
			
		}
		
	}
}


var Geolocate = {
	getCurrentLat: function() {
		if (currentLat) {
			return currentLat;
		}
		else {
			return "";
		}
	},
	getCurrentLng: function() {
		
		if (currentLng) {
			return currentLng;
		}
		else {
			return "";
		}
	},
	store: function(a) {
		
		/*if (geo) {
			
			if (a) {
				callBack = a;
			}
			
			console.log("stored called");

			geo.getCurrentPosition(Geolocate.save, Geolocate.error);
		}
		else
		{
			Error.show("You browser doesn't support Geolcation");
		}*/
	},
	save: function(position) {
		currentLat = position.coords.latitude;
		currentLng = position.coords.longitude;
		
		watchCount++;

		switch (callBack) {
			case "friends":
				Discover.friends();
				break;
			case "bars":
				Discover.bars();
				break;
			case "beers":
				Discover.beers();
				break;
			case "locations":
				Geolocate.venues(globalBID, true);
				break;
			default:
				callBack = "";
		}
		
		callBack = "";
		
		if(watchCount >=2 )
		{
			currentLat = position.coords.latitude;
			currentLng = position.coords.longitude;
			//don’t need to watch anymore
			geo.clearWatch(watchId);

			Spinner.off();
			
			Geocode.reverse(currentLat, currentLng);
		}
		else {
			
		}
		
		
	},
	saveForCheckin: function() {

		if (geo) {
			watchId = geo.watchPosition(Geolocate.save, Geolocate.nonError, opts); 
			//geo.getCurrentPosition(Geolocate.save, Geolocate.nonError, opts);
		}
		else
		{
			Error.show("You browser doesn't support Geolcation");
		}
	},
	find_beer: function(a, b) {
		
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			findBeer = a;
			
			if (geo) {
					geo.getCurrentPosition(Feed.find_beer, Geolocate.error, opts);
			}
			else
			{
				Error.handle("You browser doesn't support Geolcation");
			}
		}
	},
	around_pub: function() {
		if (geo) {
			geo.getCurrentPosition(Feed.around_me, Geolocate.error, opts);
		}
		else
		{
			Error.handle("You browser doesn't support Geolcation");
		}
	},
	venue_search: function(a) {
		
		$(".location_bar").show();
		
		if (globalBID == 0 || currentLat == "" || currentLng == "") {
			Error.handle("Invalid BID");
		}
		else
		{
			$("#searchlocationAreaContent").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Finding Locations...</p></div>');
			
			var term = $(a).serialize();
			
			Feed.foursquare_venue_search(currentLat, currentLng, term);		
		}
		
		return false;		
	},
	venues: function(bid, refresh) {
		
		$(".location_bar").show();

		globalBID = bid;
		
		$("#venue-search-term").val('');
			
		if (refresh) {
			
			$("#locationAreaContent").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Finding Locations...</p></div>');
			
			Loading.on();
			
			if (geo) {
				watchId = geo.getCurrentPosition(Feed.foursquare_venues, Geolocate.error, opts);
			}
			else
			{
				Error.show("You browser doesn't support Geolcation");
			}
		}
		else
		{
			$("#locationAreaContent").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Finding Locations...</p></div>');
			
			if (geo) {
				watchId = geo.watchPosition(Feed.foursquare_venues, Geolocate.error, opts);
			}
			else
			{
				Error.show("You browser doesn't support Geolcation");
			}
		}
	},
	test: function() {
		
		Spinner.on();
		
		console.log("started");
		
		if (geo) {
			
			console.log("it's here");
			
			geo.getCurrentPosition(Geolocate.testGood, Geolocate.testBad, opts);
			
			console.log("afterwards");
		}
		else {
			
			Spinner.off();
			
			$("#notice-error").html('');

			var obj = {};
			obj["message"] = "We had a hard time obtaining your location.";
			obj["action_btn"] = "Your browser doesn't support Geolocation.";
			console.log(obj);

			/*var source   = $("#warning-template").html();
			var template = Handlebars.compile(source);*/

			var template = Handlebars.templates['warning-template.tmpl'];
			var html = template(obj);

			$("#notice-error").html(html);

			Util.openPop();
			
		}
	},
	testBad: function(error) {
		
		console.log("err");
		
		var message;
		
		switch (error.code) {

	        case 0:

	            message = "Something went wrong: " + error.message;

	            break;

	        case 1:

	            message = "You denied permission to this page to retrieve a location.";

	            break;

	        case 2:

	            message = "The browser was unable to determine a location: " + error.message;

	            break;

	        case 3:

	            message = "The browser timed out before retrieving the location.";

	            break;

	    }
		
		$("#notice-error").html('');

		var obj = {};
		obj["message"] = "We had a hard time obtaining your location.";
		obj["action_btn"] = message;
		console.log(obj);

		/*var source   = $("#warning-template").html();
		var template = Handlebars.compile(source);*/

		var template = Handlebars.templates['warning-template.tmpl'];
		var html = template(obj);

		$("#notice-error").html(html);

		Util.openPop();
	},
	testGood: function(position) {
		
		console.log("we got results");
		
		currentLat = position.coords.latitude;
		currentLng = position.coords.longitude;
		
		$("#notice-error").html('');

		var obj = {};
		obj["message"] = "Great! We found your location successfully.";
		obj["action_btn"] = "Your current location is: " + currentLat+", "+currentLng;
		console.log(obj);

		/*var source   = $("#warning-template").html();
		var template = Handlebars.compile(source);*/

		var template = Handlebars.templates['warning-template.tmpl'];
		var html = template(obj);

		$("#notice-error").html(html);

		Util.openPop();

		Spinner.off();
		
		Geocode.reverse(currentLat, currentLng);
	},
	error: function(error) {
		
		$(".nearObj").html("Unable to find location. Please try again");

		var msg;
		
		switch (error.code) {

	        case 0:

	            msg = "Something went wrong: " + error.message;

	            break;

	        case 1:

	            msg = "You denied permission to this page to retrieve a location.";

	            break;

	        case 2:

	            msg = "The browser was unable to determine a location: " + error.message;

	            break;

	        case 3:

	            msg = "The browser timed out before retrieving the location. We recommend trying to change your permissions Settings to allow Untappd to access your Location.";

	            break;

	    }
		
		$("#locationAreaContent").html('<div class="loading_inner"><br /><br /><p>Unable to find your location. Please check your settings and try again.</p></div>');

		$("#aroundAreaContent_content").html('<div class="loading_inner"><br /><br /><p>Unable to find your location. Please check your settings and try again.</p></div>');

		$("#notice-error").html('');

		var obj = {};
		obj["message"] = "We had a hard time obtaining your location.";
		obj["action_btn"] = msg;
		console.log(obj);

		/*var source   = $("#warning-template").html();
		var template = Handlebars.compile(source);*/

		var template = Handlebars.templates['warning-template.tmpl'];
		var html = template(obj);

		$("#notice-error").html(html);

		Util.openPop();
	},
	nonError: function(a) {
		console.log(a);
	}
 	
}

