/**
 * jQuery Unveil
 * A very lightweight jQuery plugin to lazy load images
 * http://luis-almeida.github.com/unveil
 *
 * Licensed under the MIT license.
 * Copyright 2012 Luís Almeida
 * https://github.com/luis-almeida
 */

(function( $ ) {
    
    $.fn.unveil = function( threshold ) {
        var $w = $( window ), 
            th = threshold || 0,
            images = this, 
            loaded, 
            inview,
            source;
        
        this.one( "unveil", function(){
            source = this.getAttribute( "data-src" );

            if (source) {
                this.setAttribute( "src", source );
                this.removeAttribute( "data-src" );    
            }
            
        } );
        
        function unveil() {
           loaded = images.trigger( "unveil" );
        }
        
        $w.scroll( unveil );
        $w.resize( unveil );
        
        unveil();
        
        return this;
    };
    
})( Zepto );