 var Photo = {
	toggle: function() {

		var obj = {};
		obj["message"] = "Where do you want to take the photo from?";

		/*var source   = $("#warning-template").html();
		var template = Handlebars.compile(source);*/

		var template = Handlebars.templates['photo-select-template.tmpl']
		var html = template(obj);

		$("#notice-error").html(html);

		Util.openPop();
	},
	start_delete: function(photo_id) {

		window.scroll(0,0);

		$("#notice-error").html('');

		var obj = {};
		obj["message"] = "Are you sure you want remove this photo? This cannot be undone.";
		obj["action_btn"] = "<a href='javascript:void(0);' onclick='Photo.delete_photo("+photo_id+");' rel='action-btn' class='yellow_btn'>Confirm</a>";

		console.log(obj);

		/*var source   = $("#warning-template").html();
		var template = Handlebars.compile(source);*/

		var template = Handlebars.templates['warning-template.tmpl'];
		var html = template(obj);

		$("#notice-error").html(html);

		Util.openPop();
	},
	delete_photo: function(photo_id) {

		Util.closePop();

		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			Loading.on();

			$("#photo-checkin-area").hide();

			$.ajax({
				url: host + "/photo/delete/"+photo_id+"?access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Loading.off();
					
					if (data.meta.code == 200)
					{
						$("#photo-checkin-area").remove();
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}

	},
	start_flag: function(photo_id) {

		$("#notice-error").html('');

		var obj = {};
		obj["photo_id"] = photo_id;
		obj["message"] = "Why are you flagging this photo?";

		console.log(obj);

		/*var source   = $("#warning-template").html();
		var template = Handlebars.compile(source);*/

		var template = Handlebars.templates['photo-flag-template.tmpl'];
		var html = template(obj);

		$("#notice-error").html(html);

		Util.openPop();
	},
	flag: function(photo_id, type_id) {

		Util.closePop();

		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			Loading.on();

			$.ajax({
				url: host + "/photo/flag/"+photo_id+"?access_token="+token+"&flag_type="+type_id,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Loading.off();
					
					if (data.meta.code == 200)
					{
						var obj = {};
						obj["message"] = "This photo has been flagged.";
						obj["action_btn"] = "Our moderator team will investigate this and take the action to get it cleaned up. Thanks for submitting!";

						/*var source   = $("#warning-template").html();
						var template = Handlebars.compile(source);*/

						var template = Handlebars.templates['warning-template.tmpl']
						var html = template(obj);

						$("#notice-error").html(html);

						Util.openPop();

						Util.closePopTimeout(3000);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}

	},
	go_android: function(buttonIndex) {
		
		Util.closePop();
		
		/*(var pictureSource = navigator.camera.PictureSourceType;
        var destinationType = navigator.camera.DestinationType;*/
		
		if (buttonIndex == 0) {

			var pick = new MozActivity({
                 name: "pick",
                 data: {
                     type: ["image/png", "image/jpg", "image/jpeg"]
                  }
             });

            pick.onsuccess = function () { 
            	myBlob = this.result.blob;
                imageURL = window.URL.createObjectURL(this.result.blob);
                Photo.getSuccess(imageURL);
            };

            pick.onerror = function () { 
                Photo.getFail("There was an issue getting your image, please try again.");
            };
		}
		else if (buttonIndex == 1) {

			var rec = new MozActivity({
                name: "record" // Possibly capture in future versions
            });

            rec.onsuccess = function () { 
                imageURL = window.URL.createObjectURL(this.result.blob);
                Photo.getSuccess(imageURL);
            };

            rec.onerror = function () { 
               Photo.getFail("There was an issue processing your image, please try again.");
            };
		}
	 	else {

		}
		
	},
	getSuccess: function(imageURL) {
		$("#photo-result").attr("src", imageURL);

		$("#addPhotoContent").html('<span class="remove_photo">Tap to Change</span><img src="'+imageURL+'" width="70" height="70" />');
		$("#is_photo").val("true");
	    $("#photo_data").val(imageURL);
		$("#addPhotoContent").attr("onclick", "Photo.remove();");
	},
	getFail: function(message) {
		
		console.log("MESSAGE FAIL: " + message);
	},
	remove: function() {
		$("#is_photo").val("false");
	    $("#photo_data").val("");
		$("#addPhotoContent").attr("onclick", "Photo.toggle();");
		$("#addPhotoContent").html('');
	},
	uploadGood: function(r) {
		
		clearTimeout(uploadProgress);
		clearInterval(uploadProgress);	
		
		console.log(r);
		
		if (parseInt(r.responseCode) == 200) {
			$(".progress_bar").hide();
			$("#progress_status").html("Awesome! Your photo has been uploaded.");
		}
		else {
			$(".progress_bar").hide();
			$("#progress_status").html("Shucks! We had a problem uploading your photo. Touch here to try again.");
			$(".photo_upload").attr("ontouchstart", "Photo.processAgain();");
		}
	},
	processAgain: function() {
		
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{		
			$(".photo_upload").attr("ontouchstart", "");
		
			$('.photo_upload').html('<p id="progress_status">We\'re Uploading Your Photo!</p><div class="progress_bar"><span class="progress_bar_inner">0%</span><div class="progress" style="width: 0%"></div></div>');

			var j = $("#photo_details").html();
		
			var json = JSON.parse(j);
		
			var fileURI = myBlob;
		
			var url_to = host + "/photo/add/"+json.checkin_id+"?access_token="+token;
		
			uploadProgress = setInterval("pBar.increase();",1000);

			var form = new FormData();
            form.append("file", fileURI);
            form.append("checkin_id", json.checkin_id);
            form.append("photo_key", json.media.photo_key);
            form.append("user_id", json.user.uid);

            var xhrForm = new XMLHttpRequest();
            xhrForm.open("POST", url_to);
            xhrForm.send(form);

            uploadProgress = setInterval("pBar.increase();",1000);

            xhrForm.onreadystatechange = function () {
                if (xhrForm.readyState === 4) {
 
                	var jsonRes = JSON.parse(xhrForm.responseText);

                	if (jsonRes.meta && jsonRes.meta.code == 200) {
                		var obj = {
                			responseCode: 200,
                			response: jsonRes
                		};

                		Photo.uploadGood(obj);
                	}
                	else {
                		Photo.uploadBad(jsonRes);
                	}
                }
            };
		}
		
	},
	uploadBad: function(r) {
		clearTimeout(uploadProgress);
		clearInterval(uploadProgress);
		
		console.log(r)
		
		$(".progress_bar").hide();
		$("#progress_status").html("Shucks! We had a problem uploading your photo. Touch here to try again.");
		$(".photo_upload").attr("ontouchstart", "Photo.processAgain();");
	}
}

var loadingStatus = {
	setPercentage: function(newProgress) {

		newProgress = Math.round(parseInt(newProgress) * 100);

		$(".progress").attr('data-progress', newProgress);

		$(".progress_bar_inner").html(newProgress+"%");

        $(".progress").attr("style", "width: "+newProgress+"%");
	},
	increment: function() {

		var progress = $(".progress").attr('data-progress');

	    if (parseInt(progress) <= 100)
	    {
			var randomnumber=Math.floor(Math.random()*15)

	        var newProgress = parseInt(progress) + parseInt(randomnumber);

			if (parseInt(newProgress) >= 98)
			{
				newProgress = 98;
				$(".progress_bar").hide();
				$("#progress_status").html("Please Wait...");
			}

			$(".progress").attr('data-progress', newProgress);

			$(".progress_bar_inner").html(newProgress+"%");

	        $(".progress").attr("style", "width: "+newProgress+"%");
	    }
	    else
	    {
			$(".progress").attr('data-progress', '0');
	    }

	}
}
