var Settings = {
	pushSetup: function(userSettings) {
		
		console.log("PUSH SETTUP HAPPENING");

		udid = device.uuid;

		if (udid != "") {
			
			$("#push-header").show();
			$(".push-details").show();
			$("#push_options").show();

			$(userSettings.user.settings.push_devices.device_udid.items).each(function(i, items) {

				if (udid == items.device_udid) {

					push_enabled = true;

					$(".push_options").show();
					$("#push_options").addClass("active");

					$("#push_enabled").addClass("active");

					$("#push_toasts").val(items.push_types.toast);
					$("#push_comments").val(items.push_types.comment);	

					if (items.push_types.toast == 1) {
						$("#li_push_toasts").addClass("active");
					}
					else {
						$("#li_push_toasts").removeClass("active");
					}

					if (items.push_types.comment == 1) {
						$("#li_push_comments").addClass("active");
					}
					else {
						$("#li_push_comments").removeClass("active");
					}

					$("#push_enabled").html("<span></span>Enable Push Notifications");
					console.log("MATCH");
					return false;
				}
			});

			if (!push_enabled) {
				$(".push_options").hide();
				$("#li_push_toasts").removeClass("active");
				$("#li_push_comments").removeClass("active");
				$("#push_toasts").val(0);
				$("#push_comments").val(0);	
				$("#push_enabled").html("<span></span>Enable Push Notifications");
			}
		}
		else {
			$("#push-header").hide();
			$("#push_enabled").hide();
			$(".push-details").hide();
		}

		
	}, 
	init: function(data) {
	
		//myStorage.save("userSettings",  data);

		if (data.user.is_private) {
			$("#account_private").attr("value", 1);
			$("#private_option").attr("class", "active");
		}
		else {
			$("#account_private").attr("value", 0);
			$("#private_option").attr("class", "");
		}
		
		if (data.user.settings.is_map) {
			$("#map_privacy").attr("value", 1);
			$("#map_option").attr("class", "active");
		}
		else {
			$("#map_privacy").attr("value", 0);
			$("#map_option").attr("class", "");
		}
		
		if (data.user.contact.facebook) {
			
			$(".social_scanning_facebook").removeClass("inactive");
			$(".social_scanning_facebook").attr("rel");
			
			$("#default_facebook_checkins").show();
			$("#default_facebook_badges").show();
			
			if (data.user.settings.badge.badges_to_facebook) {
				$("#badges_to_facebook").attr("value", 1);
				$("#default_facebook_badges").attr("class", "active");
			}
			else {
				$("#badges_to_facebook").attr("value", 0);
				$("#default_facebook_badges").attr("class", "");
			}
			
			if (data.user.settings.checkin.checkin_to_facebook) {
				$("#checkins_to_facebook").attr("value", 1);
				$("#default_facebook_checkins").attr("class", "active");
			}
			else {
				$("#checkins_to_facebook").attr("value", 0);
				$("#default_facebook_checkins").attr("class", "");
			}
			
		}
		else {
			$("#default_facebook_checkins").hide();
			$("#default_facebook_badges").hide();
			$(".social_scanning_facebook").addClass("inactive");
			$(".social_scanning_facebook").attr("rel", "action-btn");
		}
		
		if (data.user.contact.twitter) {
			
			$("#default_twitter_checkins").show();
			$("#default_twitter_badges").show();
			$(".social_scanning_twitter").removeClass("inactive");
			$(".social_scanning_twitter").removeAttr("rel");
			
			if (data.user.settings.badge.badges_to_twitter) {
				$("#badges_to_twitter").attr("value", 1);
				$("#default_twitter_badges").attr("class", "active");
			}
			else {
				$("#badges_to_twitter").attr("value", 0);
				$("#default_twitter_badges").attr("class", "");
			}
			
			if (data.user.settings.checkin.checkin_to_twitter) {
				$("#checkins_to_twitter").attr("value", 1);
				$("#default_twitter_checkins").attr("class", "active");
			}
			else {
				$("#twitter_to_facebook").attr("value", 0);
				$("#default_twitter_checkins").attr("class", "");
			}
		}
		else {
			$("#default_twitter_checkins").hide();
			$("#default_twitter_badges").hide();
			$(".social_scanning_twitter").addClass("inactive");
			$(".social_scanning_twitter").attr("rel", "action-btn");
		}
		
		
		if (data.user.contact.foursquare) {
			
			$(".social_scanning_foursquare").removeClass("inactive");
			$(".social_scanning_foursquare").removeAttr('rel');
			$("#default_4sq_checkins").show();
			
			if (data.user.settings.checkin.checkin_to_foursquare) {
				$("#checkins_to_4sq").attr("value", 1);
				$("#default_4sq_checkins").attr("class", "active");
			}
			else {
				$("#twitter_to_4sq").attr("value", 0);
				$("#default_4sq_checkins").attr("class", "");
			}
		}
		else {
			$("#default_4sq_checkins").hide();
			$(".social_scanning_foursquare").addClass("inactive");
			$(".social_scanning_foursquare").attr("rel", "action-btn");
		}
		
		if (data.user.settings.navigation.default_to_checkin) {
			$("#startup_pref").attr("value", 1);
			$("#default_startup").attr("class", "active");
		}
		else {
			$("#startup_pref").attr("value", 0);
			$("#default_startup").attr("class", "");
		}

		var template = Handlebars.templates['settings-template.tmpl']
		
		var html = template(data);

		$("#usernameProfileList").html(data.user.user_name);
		
		$("#settings-elements").html(html);
		
		//Settings.pushSetup(data);

		var template = Handlebars.templates['social-settings-template.tmpl']
		
		var html = template(data);
		
		var dis = myStorage.view("distanceFriends");
		
		if (!dis) {
			$("#friends_distance").val(5);
		}
		else {
			$("#friends_distance").val(dis);
		}
		
		var disB = myStorage.view("distanceBeer");
		
		if (!disB) {
			$("#beer_distance").val(5);
		}
		else {
			$("#beer_distance").val(disB);
		}

		var disBs = myStorage.view("distanceBars");
		
		if (!disBs) {
			$("#bars_distance").val(5);
		}
		else {
			$("#bars_distance").val(disBs);
		}

		var disBw = myStorage.view("distanceBreweries");
		
		if (!disBw) {
			$("#breweries_distance").val(5);
		}
		else {
			$("#breweries_distance").val(disBw);
		}
		
		$("#social-settings-accounts").html(html);
		
		if (data.user.contact.twitter || data.user.contact.facebook || data.user.contact.foursquare) {
			$("#checkins-header").show();
			$(".checkins-account").show();
		}
		else {
			$("#checkins-header").hide();
			$(".checkins-account").hide();
		}
		
		if (data.user.contact.twitter || data.user.contact.facebook) {
			$("#badges-header").show();
			$(".badges-account").show();
		}
		else {
			$("#badges-header").hide();
			$(".badges-account").hide();
		}
		
		Limiter.limit('bio', 'bio-counter', 140);
	},
	map_breweries: function(a) {
		
		console.log($(a).val());
		
		if ($(a).val() == "") {
			myStorage.save("distanceBreweries", 5);
		}
		else {
			myStorage.save("distanceBreweries", $(a).val());
		}
	},
	map_distance: function(a) {
		
		console.log($(a).val());
		
		if ($(a).val() == "") {
			myStorage.save("distanceFriends", 5);
		}
		else {
			myStorage.save("distanceFriends", $(a).val());
		}
	},
	beer_distance: function(a) {
		if ($(a).val() == "") {
			myStorage.save("distanceBeer", 5);
		}
		else {
			myStorage.save("distanceBeer", $(a).val());
		}
	},
	bars_distance: function(a) {
		if ($(a).val() == "") {
			myStorage.save("distanceBars", 5);
		}
		else {
			myStorage.save("distanceBars", $(a).val());
		}
	},
	change_password: function(a,b) {
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			var args = $("#change-password-form").serialize();
			
			$("#change_password_btn").hide();
			$("#change_password_loader").show();
			
			$.ajax({
				url: host + "/account/changepassword?access_token="+token,
				type: "POST",
				data: args,
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#change_password_btn").show();
					$("#change_password_loader").hide();
					
					$("#change-password-form input").val('');
					
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(html)
				{
					$("#change_password_btn").show();
					$("#change_password_loader").hide();
					
					$("#change-password-form input").val('');
					
					if (html.meta.code == 200)
					{
						if (html.response.result == "success") {
							
							var obj = {};
							obj["message"] = "Your profile has been updated.";
							
							/*var source   = $("#warning-template").html();
							var template = Handlebars.compile(source);*/

							var template = Handlebars.templates['notice-template.tmpl'];
							var html = template(obj);

							$("#notice-error").html(html);

							Util.openPop();

							Util.closePopTimeout(3000);
							
						}
						else {
							Error.handle("Oh no! There was an issue with your request, please try again", "", html.meta.code);
						}
					}
					else
					{
						Error.handle(html.meta.error_detail, html.meta.error_type, html.meta.code);
					}
				}
			});
		}
		
	},
	update_push: function(a,b) {

		var current_class = $(a).attr("class");
			
		if (current_class == "active") {
			
			push.disablePush();

			var args = b+"="+$("#"+b).val()+"&udid="+udid;

			console.log(args);

			$(a).attr("class", "loading");
				
			$.ajax({
				url: host + "/account/deletepush?access_token="+token,
				type: "POST",
				data: args,
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(html)
				{
					if (html.meta.code == 200)
					{
						if (html.response.result == "success") {
						 	$(a).attr("class", "");
						 	$(".push_options").hide();
						}
						else {
							
							$(a).attr("class", current_class);
							
							Error.handle("Oh no! There was an issue with your request, please try again", "", html.meta.code);
						}
					}
					else
					{
						$(a).attr("class", current_class);
						
						Error.handle(html.meta.error_detail, html.meta.error_type, html.meta.code);
					}
				}
			});
		}	
		else {
			
			$(a).attr("class", "loading");

			push.enablePush();
		}
	},
	update_push_settings: function(a,b) {

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var current_class = $(a).attr("class");
			
			if (current_class == "active") {
				$("#"+b).val(0);
			}
			else {
				$("#"+b).val(1);
			}
			
			var args = b+"="+$("#"+b).val()+"&udid="+udid;

			console.log(args);

			$(a).attr("class", "loading");

			$.ajax({
				url: host + "/account/updatepush?access_token="+token,
				type: "POST",
				data: args,
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(html)
				{
					if (html.meta.code == 200)
					{
						if (html.response.result == "success") {
						 	// active state
							
							if (html.response.option) {
								$(a).attr("class", "active");
							}
							else {
								$(a).attr("class", "");
							}
							
							init.Social();
						
						}
						else {
							
							$(a).attr("class", current_class);
							
							Error.handle("Oh no! There was an issue with your request, please try again", "", html.meta.code);
						}
					}
					else
					{
						$(a).attr("class", current_class);
						
						Error.handle(html.meta.error_detail, html.meta.error_type, html.meta.code);
					}
				}
			});
		}	

	},
	update_privacy: function(a,b) {
		
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var current_class = $(a).attr("class");
			
			if (current_class == "active") {
				$("#"+b).val(0);
			}
			else {
				$("#"+b).val(1);
			}
			
			var args = b+"="+$("#"+b).val();

			$(a).attr("class", "loading");

			$.ajax({
				url: host + "/account/updatesettings?access_token="+token,
				type: "POST",
				data: args,
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(html)
				{
					if (html.meta.code == 200)
					{
						if (html.response.result == "success") {
						 	// active state
							
							if (html.response.option) {
								$(a).attr("class", "active");
							}
							else {
								$(a).attr("class", "");
							}
							
							init.Social();
						
						}
						else {
							
							$(a).attr("class", current_class);
							
							Error.handle("Oh no! There was an issue with your request, please try again", "", html.meta.code);
						}
					}
					else
					{
						$(a).attr("class", current_class);
						
						Error.handle(html.meta.error_detail, html.meta.error_type, html.meta.code);
					}
				}
			});
		}	
		
	},
	update_profile: function(a) {
				
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			var args = $("#settings-form").serialize();
			
			$("#update_profile_btn").hide();
			$("#update_profile_loader").show();
			
			$.ajax({
				url: host + "/account/updateprofile?access_token="+token,
				type: "POST",
				data: args,
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#update_profile_btn").show();
					$("#update_profile_loader").hide();
					
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(html)
				{
					$("#update_profile_btn").show();
					$("#update_profile_loader").hide();
					
					if (html.meta.code == 200)
					{
						if (html.response.result == "success") {
							
							var obj = {};
							obj["message"] = "Your profile has been updated.";
							
							/*var source   = $("#warning-template").html();
							var template = Handlebars.compile(source);*/

							var template = Handlebars.templates['notice-template.tmpl'];
							var html = template(obj);

							$("#notice-error").html(html);

							Util.openPop();

							Util.closePopTimeout(3000);
							
						}
						else {
							Error.handle("Oh no! There was an issue with your request, please try again", "", html.meta.code);
						}
					}
					else
					{
						Error.handle(html.meta.error_detail, html.meta.error_type, html.meta.code);
					}
				}
			});
		}
		
	}
}