<script id="activity-template"  type="text/x-handlebars-template">
	<div class="activity_stream" id="activity_stream">
			{{#each checkins.items}}

				<div class="{{this.checkin_id}} activity_item" id="checkinid_{{this.checkin_id}}" data-checkin-id="{{this.checkin_id}}">

					<div class="details_wrapper">

						{{#if this.venue.venue_name}}
						<div class="location"><a href="#!/venueArea/{{this.venue.venue_id}}/{{this.checkin_id}}/checkin">{{this.venue.venue_name}}</a></div>
						{{/if}}

						<div class="user">
							<span class="flag"></span>
							<a href="#!/profileArea/{{this.user.user_name}}/{{this.checkin_id}}" style="background: #fff url({{this.user.user_avatar}}) top left no-repeat;" class="profile avatar_wrapper">
								<img height="40" width="40" src="{{this.user.user_avatar}}">
							</a>
						</div>

						<div class="details">

							<span class="arrow"></span>

							<a href="#!/indCheckin/{{this.checkin_id}}" class="check_in">


									<div class="time timeago">{{this.created_at}}</div>

									<p class="username"><strong>{{this.user.first_name}} {{this.user.last_name}}</strong></p>

									<div class="beer">

										<img width="34" height="34" src="{{this.beer.beer_label}}" />

										<span>
											<h2>{{this.beer.beer_name}}</h2>
											<h3>{{this.brewery.brewery_name}}</h3>
										</span>

									</div>

									{{#if media.count}}
										<div class="photo">
											{{photoSingle media}}
										</div>
									{{/if}}


									{{#if this.checkin_comment}}
									<div class="comment"><p>{{this.checkin_comment}}</p></div>

									{{/if}}


							</a>

							<div class="toast_list">
								{{#if this.toasts.count}}
								{{#toasteach this.toasts.items}}
								<a href="#!/profileArea/{this.user.user_name}}/{{this.user.uid}}/toast">{{fullName this.user}}</a>
								<div id="toastprofile_{{this.user.uid}}" style="display:none;">{{jason this}}</div>
								{{/toasteach}}
								{{/if}}
							</div>
							<div class="comment_list">

								{{#commenteach this.comments.items}}
									<div class="comment">
										<span class="avatar_wrapper small" style="background: #fff url({{this.user.user_avatar}}) top left no-repeat;">
											<img width="30" height="30" src="{{this.user.user_avatar}}">
										</span>
										<div>
											<span class="arrow"></span>
											<a href="#!/profileArea/{{this.user.user_name}}/{{checkin_id}});">{{fullName this.user}}</a>:
												{{this.comment}}
										</div>
									</div>
								{{/commenteach}}
								{{morecomments this}}
							</div>


						</div>


						 <div id="checkindetail_{{this.checkin_id}}" style="display:none">{{jason this}}</div>
					</div>
				</div>
			{{/each}}
			</div>

</script>
<script id="notifications-template"  type="text/x-handlebars-template">
	<div id="note-areas" class="list notifications note-panel">
		{{#if notifications.items}}
			{{#each notifications.items}}
				<div class="list_box">

					{{checkType this}}

						<span class="time timeago">{{this.created_at}}</span>

						<span class="avatar_wrapper" style="background: #fff url({{this.actor.user_avatar}}) top left no-repeat;">
							<img width="100%" src="{{this.actor.user_avatar}}">
						</span>

						<div>
							<h2><strong>{{fullName this.actor}}</strong> {{noteText this}}
							{{#if this.message}}
								</h2><p>{{dotDot this.message}}</p>
							{{else}}
								<strong>{{this.beer.beer_name}}</strong></h2>
							{{/if}}

						</div>
					</a>
					<div id="notificationsdetails_{{this.checkin_id}}" style="display:none">{{jason this}}</div>

				</div>
			{{/each}}
		{{else}}
			<div class="list_box">
				<a href="javsascript:void(0);" rel="action-btn" class="item">
					<img src="assets/images/no_results_icon.jpg" />
					<div>
						<h2>You don&apos;t have any notifications</h2>
						<h3>Add more friends to start commenting and toasting today!</h3>
					</div>
				</a>
			</div>
		{{/if}}
	</div>
	<div id="news-areas" class="list notifications note-panel" style="display: none;">
		{{#each news.items}}
			<div class="list_box news">
				<a class="item new" rel="link-out" href="{{this.news_link}}" class="item">
					<span class="time timeago">{{this.created_at}}</span>
					<div>
						<h2>{{this.news_title}}</h2>
						<h3>{{this.news_text}}</h3>
					</div>
				</a>
			</div>
		{{/each}}
	</div>
</script>
<script id="discoverBeers-template" type="text/x-handlebars-template">
	<div class="discover_stream">
	{{#each items}}
		<div class="list_box list_box_discover discover_beers" data-sort-popular="{{this.distinct_users}}" data-sort-style="{{this.beer.style_name}}" data-sort-distance="{{this.distance}}">
			<div class="details">
				<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/discoverBeers">
					<img width="50" height="50" src="{{this.beer.beer_label}}">
					<div>
						<h2>{{this.beer.beer_name}}</h2>
						<h3>{{this.brewery.brewery_name}}</h3>
						<p>
							<strong>Style: </strong>{{this.beer.style_name}}
						</p>
						<p>
							<strong>ABV: </strong>{{ABV this.beer.beer_abv}}
							<strong>IBU: </strong>{{IBU this.beer.beer_ibu}}
						</p>
					</div>
				</a>
				<div class="distance">
					<a href="#!/venueArea" onclick="Feed.venue({{this.venue.venue_id}}, {{this.beer.bid}}, 'discoverBeer');">Last seen <abbr class="timeago">{{this.recent_created_at}}</abbr> at {{this.venue.venue_name}} ({{parseDistance this.distance}} mi away) by {{this.distinct_users}} user(s)</a>
				</div>
				<div id="discoverBeer_{{this.beer.bid}}" style="display:none">{{jason this}}</div>
			</div>
		</div>
	{{/each}}
	</div>
</script>
<script id="discoverTrending-template" type="text/x-handlebars-template">
	<div class="discover_stream">
	{{#each items}}
		<div class="list_box list_box_discover discover_beers">
			<div class="details">
				<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/trendingBeer">
					<img width="50" height="50" src="{{this.beer.beer_label}}">
					<div>
						<h2>{{this.beer.beer_name}}</h2>
						<h3>{{this.brewery.brewery_name}}</h3>
						<p>
							<strong>Style: </strong>{{this.beer.style_name}}
						</p>
						<p>
							<strong>ABV: </strong>{{ABV this.beer.beer_abv}}
						</p>
					</div>
				</a>
				<div id="trendingBeer_{{this.beer.bid}}" style="display:none">{{jason this}}</div>
			</div>
		</div>
	{{/each}}
	</div>
</script>
<script id="discoverBars-template" type="text/x-handlebars-template">
	<div class="discover_stream">
	{{#each items}}
		<div class="list_box list_box_discover discover_bars" data-sort-popular="{{this.total_users}}" data-sort-category="{{this.venue.primary_category}}" data-sort-distance="{{this.distance}}">
			<div class="details">
				<a onclick="Feed.venue({{this.venue.venue_id}}, null, 'discoverVenues');" href="#!/venueArea">
					<img width="50" height="50" src="{{this.venue.venue_icon.lg}}">
					<div>
						<h2>{{this.venue.venue_name}}</h2>
						<h3>
							{{this.venue.primary_category}} {{venueCategory this.venue}}
						</h3>
						<p>{{venueHelper this.venue}}</p>
					</div>
				</a>
				<div class="distance">
					<a href="#">{{venueFriend this}}</a>
				</div>
				<div id="discoverVenue_{{this.venue.venue_id}}" style="display:none">{{jason this}}</div>
			</div>
		</div>
	{{/each}}
	</div>
</script>
<script id="recent-location-template" type="text/x-handlerbars-template">
	{{#if recent.items}}
	<div class="blue_bar">
		Your Recent Venues
	</div>
	{{/if}}
	<div class="list">
	{{#each recent.items}}
		<div class="list_box">
			<a href="#!/confirmArea/{{this.foursquare.foursquare_id}}/loc">
				<img width="50" height="50" src="{{this.venue_icon.md}}">
				<div>
					<h2>{{this.venue_name}}</h2>
					<h3>{{venueHelper this}}</h3>
					<p><strong>Category: </strong>{{this.primary_category}}</p>
					<p><strong>Distance: </strong>{{this.distance}} miles</p>
					<div id="venuedetail_{{this.foursquare.foursquare_id}}" style="display: none;">{{jason this}}</div>
				</div>
			</a>
		</div>

	{{/each}}
	</div>
</script>
<script id="foursquare-location-template" type="text/x-handlerbars-template">
	{{#if foursquare.items}}
	<div class="blue_bar">
		Venues Around You
	</div>
	{{/if}}
	<div class="list">
	{{#each foursquare.items}}
		<div class="list_box">
			<a href="#!/confirmArea/{{this.foursquare.foursquare_id}}/loc">
				<img width="50" height="50" src="{{this.venue_icon.md}}">
				<div>
					<h2>{{this.venue_name}}</h2>
					<h3>{{venueHelper this}}</h3>
					<p><strong>Category: </strong>{{this.primary_category}}</p>
					<p><strong>Distance: </strong>{{this.distance}} miles</p>
					<div id="venuedetail_{{this.foursquare.foursquare_id}}" style="display: none;">{{jason this}}</div>
				</div>
			</a>
		</div>

	{{/each}}
	</div>
</script>
<script id="profile-template" type="text/x-handlebars-template">
	<div class="profile" id="user_profile" data-username="{{user.user_name}}" data-relationship="{{user.relationship}}">
		<div class="profile_top">
			{{#if user.contact}}
			<div class="social">
				{{#if user.contact.twitter}}
					<a class="tw" rel="link-out" href="http://twitter.com/{{user.contact.twitter}}">Twitter</a>
				{{/if}}
				{{#if user.contact.facebook}}
					<a class="fb" rel="link-out" href="http://www.facebook.com/profile.php?id={{user.contact.facebook}}">Facebook</a>
				{{/if}}
				{{#if user.contact.foursquare}}
					<a class="foursquare" rel="link-out" href="http://foursquare.com/user/{{user.contact.foursquare}}">Twitter</a>
				{{/if}}
			</div>
			{{/if}}
			<span class="avatar_wrapper" style="background: #fff url({{this.user.user_avatar}}) top left no-repeat;">
				<img width="100%" src="{{user.user_avatar}}">
			</span>

			<div class="profile_details">
				<h1>{{user.first_name}} {{user.last_name}}</h1>
				<h2 class="location">{{user.location}}</h2>
				<p>{{user.bio}}</p>
			</div>
		</div>

	{{userFriendship user}}

	{{#if user.stats}}

		<div class="profile_stats">
			<a href="javascript:void(0);"><span>Checkins:</span>
				<p>{{Stats user.stats.total_checkins}}</p>
			</a>
			<a href="#!/distinctArea" onclick="Feed.distinct_beer('{{this.user.user_name}}');"><span>Distinct Beers:</span>
				<p>{{Stats user.stats.total_beers}}</p>
			</a>
			<a href="#!/userBadgeArea" onclick="Feed.user_badges('{{this.user.user_name}}', 'beer');"><span>Total Badges:</span>
				<p>{{Stats user.stats.total_badges}}</p>
			</a>
			<span id="hiddenUsername" style="display: none;">{{this.user.user_name}}</span>
		</div>

		{{#if user.media.items}}
			<div class="profile_photos">
				<div>
				{{#mediaeach user.media.items}}
					<a href="#!/photoSingle/{{this.checkin_id}}/user"><img width="100%" src="{{this.photo.photo_img_md}}"></a>
					<div id="photocheckinuser_{{this.checkin_id}}" style="display: none;">{{jason this}}</div>
				{{/mediaeach}}
					<a href="#!/photoGallery/user/{{user.user_name}}" class="more"><img width="100%" src="assets/images/profile_photos_more.png"></a>
				</div>

			</div>
		{{/if}}

			<div class="bottom_stream">

			<div class="three_tab_bar not_top_three" id="profile_tabs">
				<ul>
					<li><a rel="action-btn" class="active first" onclick="Profile.tabs(this, 'activity', '{{user.user_name}}'); return false;" href="javascript:void(0);">Activity</a></li>
					<li><a rel="action-btn" onclick="Profile.tabs(this, 'wish_list', '{{user.user_name}}'); return false;" href="javascript:void(0);">Wish List</a></li>
					<li><a class="last" rel="action-btn" onclick="Profile.tabs(this, 'friends', '{{user.user_name}}'); return false;" href="javascript:void(0);">Friends</a></li>
				</ul>
			</div>

			<div style="display: none;" class="profile_three_tab" id="friends_stream_profile">
				<div id="friends_stream_profile_content">
					<div class="loading_inner">
						<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
						<p>Loading...</p>
					</div>
				</div>
			</div>

			<div style="display: none;" class="profile_three_tab list" id="wishlist_stream_profile">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading...</p>
				</div>
			</div>

			<div id="activity_stream_profile" class="activity_stream profile_three_tab">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading...</p>
				</div>
			</div>
	{{else}}
		<div style="display: none;" class="profile_three_tab" id="friends_stream_profile">
		<div class="loading_inner">
			<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
			<p>Loading...</p>
		</div>
		</div>

		<div style="display: none;" class="profile_three_tab" id="wishlist_stream_profile">
		<div class="loading_inner">
			<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
			<p>Loading...</p>
		</div>
		</div>

		<div id="activity_stream_profile" class="activity_stream profile_three_tab">
		<div class="loading_inner">
			<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
			<p>Loading...</p>
		</div>
		</div>
	{{/if}}
	</div>

</div>
</script>
<script id="photo-gallery-template"  type="text/x-handlebars-template">
	<ul class="photo_gallery">
		{{#each items}}
			<li class="photo_items">
				<a href="#!/photoSingle" onclick="Feed.media_single({{this.photo_id}}, 'single');"><img src="{{this.photo.photo_img_md}}" width="90" height="90" /></a>
				<div id="singlePhoto_{{this.photo_id}}" style="display: none;">
					{{jason this}}
				</div>
			</li>
		{{/each}}
	</ul>
</script>
<script id="photo-single-template" type="text/x-handlebars-template">
	<div class="list">
		<div id="photocheckin_{{checkin_id}}"  style="display: none;">
			{{jason this}}
		</div>
		<div class="list_box photo_large">
			<a href="#!/indCheckin" onclick="Feed.checkin({{checkin_id}}, null, 'photo');"><img src="{{photo.photo_img_lg}}" width="100%"></a>
		</div>
		<div class="list_box">
		<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/photo_single">
			<img width="50" height="50" src="{{beer.beer_label}}">
			<div>
				<h2>{{beer.beer_name}}</h2>
				<h3>{{brewery.brewery_name}}</h3>
				<p><strong>Style: </strong>{{beer.beer_style}}</p>
			</div>
		</a>
	</div>
	{{#if venue.venue_id}}
		<div class="list_box">
			<a href="#!/venueArea" onclick="Feed.venue({{venue.venue_id}}, null, 'single_photo');">
				<img width="50" height="50" src="{{venue.venue_icon.md}}">
				<div>
					<h2>{{venue.venue_name}}</h2>
					<h3>{{venueHelper venue}}</h3>
					<p><strong>Category: </strong>{{venue.primary_category}} {{venueCategory venue}}</p>
				</div>
			</a>
		</div>
	{{/if}}
</script>
<script id="cheers-template" type="text/x-handlebars-template">
	{{#if badges.items}}
		<div id="badge-results" class="badge_promo stage">
			<h1>You Unlocked A Badge!</h1>
			<div>
				{{#each badges.items}}
					<img src="{{this.badge_image.lg}}" width="80%" />
					<h2>{{this.badge_name}}</h2>
					<p>{{this.badge_description}}</p>
				{{/each}}
			</div>

			<a class="yellow_btn large" href="javascript:void(0);" rel="action-btn" onclick="Cheers.toggle(1);">Continue</a>

		</div>
	{{/if}}

	{{#if promotions.items}}
		<div id="promo-results" class="badge_promo stage">
			<h1>You Unlocked A Promo!</h1>
			<div>
				{{#each promotions.items}}
					<img src="{{this.promo_image.image}}" height="{{this.promo_image.size.height}}" width="80%" />
					<h2>{{this.badge_name}}</h2>
					<p>{{this.promo_description}}</p>
					<p class='fine_print'>
		             	{{this.promo_legal}}
		            </p>
				{{/each}}
			</div>

			<a class="yellow_btn large" href="javascript:void(0);" rel="action-btn" onclick="Cheers.toggle(2);">Continue</a>

		</div>
	{{/if}}

	<div id="cheers-results" class="cheers stage">

		{{#if media.is_photo}}
			<div class="photo_upload">
	          <p id="progress_status">We're Uploading Your Photo!</p>
	          <div class="progress_bar">
	            <span class="progress_bar_inner">
	              1%
	            </span>
	            <div class="progress" data-progress="1" style="width: 1%"></div>
	          </div>
	        </div>
			<div id="photo_details" style="display: none;">{{jason this}}</div>
		{{/if}}

		<div class="confirmation">

			<div class="cheer_msg">
				<h1>CHEERS!</h1>
				<h2>YOUR CHECK-IN WAS SUCCESSFUL</h2>
			</div>

			<div class="list">

			<div class="list_box">
				<img width="50" height="50" src="{{beer.beer_label}}">
				<div>
					<h2>{{beer.beer_name}}</h2>
					<h3>{{brewery.brewery_name}}</h3>
					<p><strong>Style: </strong>{{beer.beer_style}}</p>
				</div>

				<span class="current_stats">
					This is your {{stats.beer_month}} time drinking this brew this month and {{stats.beer}} time overall.
				</span>

				{{followStatus this}}

			</div>

		{{#if venue.venue_id}}

			<div class="list_box">
				<img width="50" height="50" src="{{venue.venue_icon.md}}">
				<div>
					<h2>{{venue.venue_name}}</h2>
					<h3>{{venueHelper venue}}</h3>
					<p><strong>Category: </strong>{{venue.primary_category}} {{venueCategory venue}}</p>
				</div>

				<span class="current_stats">
					This is your {{stats.venue_month}}  time drinking this brew this month and {{stats.venue}} time overall.
				</span>
			</div>

		{{/if}}
		</div>
	</div>

	<div class="blue_bar" id="recommend-bar">
		Recommendations
	</div>

</script>
<script id="your-profile-template" type="text/x-handlebars-template">
	<div class="profile" id="your_user_profile" data-username="{{user.user_name}}" data-relationship="{{user.relationship}}">
		<div class="profile_top">
			{{#if user.contact}}
			<div class="social">
				{{#if user.contact.twitter}}
					<a class="tw" rel="link-out" href="http://twitter.com/{{user.contact.twitter}}">Twitter</a>
				{{/if}}
				{{#if user.contact.facebook}}
					<a class="fb" rel="link-out" href="http://www.facebook.com/profile.php?id={{user.contact.facebook}}">Facebook</a>
				{{/if}}
				{{#if user.contact.foursquare}}
					<a class="foursquare" rel="link-out" href="http://foursquare.com/user/{{user.contact.foursquare}}">Twitter</a>
				{{/if}}
			</div>
			{{/if}}
			<span class="avatar_wrapper" style="background: #fff url({{this.user.user_avatar}}) top left no-repeat;">
				<img width="100%" src="{{user.user_avatar}}">
			</span>

			<div class="profile_details">
				<h1>{{user.first_name}} {{user.last_name}}</h1>
				<h2 class="location">{{user.location}}</h2>
				<p>{{user.bio}}</p>
			</div>

	</div>

	{{userFriendship user}}


	{{#if user.stats}}

		<div class="profile_stats">
			<a href="javascript:void(0);"><span>Checkins:</span>
				<p>{{Stats user.stats.total_checkins}}</p>
			</a>
			<a href="#!/distinctArea" onclick="Feed.distinct_beer('{{this.user.user_name}}');"><span>Distinct Beers:</span>
				<p>{{Stats user.stats.total_beers}}</p>
			</a>
			<a href="#!/userBadgeArea" onclick="Feed.user_badges('{{this.user.user_name}}', 'beer');"><span>Total Badges:</span>
				<p>{{Stats user.stats.total_badges}}</p>
			</a>
			<span id="hiddenUsername" style="display: none;">{{this.user.user_name}}</span>
		</div>

		{{#if user.media.items}}
			<div class="profile_photos">
				<div>
				{{#mediaeach user.media.items}}
					<a href="#!/photoSingle/{{this.checkin_id}}/user"><img width="100%" src="{{this.photo.photo_img_md}}"></a>
					<div id="photocheckinuser_{{this.checkin_id}}" style="display: none;">{{jason this}}</div>
				{{/mediaeach}}
					<a href="#!/photoGallery/user/{{user.user_name}}" class="more"><img width="100%" src="assets/images/profile_photos_more.png"></a>
				</div>

			</div>
		{{/if}}


			<div class="bottom_stream">

			<div class="three_tab_bar not_top_three" id="your_profile_tabs">
				<ul>
					<li><a rel="action-btn" class="active first" onclick="Profile.your_tabs(this, 'activity', '{{user.user_name}}'); return false;" href="javascript:void(0);">Activity</a></li>
					<li><a rel="action-btn" onclick="Profile.your_tabs(this, 'wish_list', '{{user.user_name}}'); return false;" href="javascript:void(0);">Wish List</a></li>
					<li><a class="last" rel="action-btn" onclick="Profile.your_tabs(this, 'friends', '{{user.user_name}}'); return false;" href="javascript:void(0);">Friends</a></li>
				</ul>
			</div>

			<div style="display: none;" class="your_profile_three_tab" id="your_friends_stream_profile">
				<div id="your_friends_stream_profile_content">
					<div class="loading_inner">
						<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
						<p>Loading...</p>
					</div>
				</div>
			</div>

			<div style="display: none;" class="your_profile_three_tab list" id="your_wishlist_stream_profile">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading...</p>
				</div>
			</div>

			<div id="your_activity_stream_profile" class="activity_stream your_profile_three_tab">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading...</p>
				</div>
			</div>
	{{else}}
		<div style="display: none;" class="your_profile_three_tab" id="your_friends_stream_profile">
		<div class="loading_inner">
			<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
			<p>Loading...</p>
		</div>
		</div>

		<div style="display: none;" class="your_profile_three_tab" id="your_wishlist_stream_profile">
		<div class="loading_inner">
			<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
			<p>Loading...</p>
		</div>
		</div>

		<div id="your_activity_stream_profile" class="activity_stream your_profile_three_tab">
		<div class="loading_inner">
			<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
			<p>Loading...</p>
		</div>
		</div>
	{{/if}}
  </div>

</div>
</script>
<script id="confirm-template" type="text/x-handlerbars-template">
	<div class="check_in_confirm">
		<div class="list_box">
			<img width="50" height="50" src="{{beer.beer_label}}">
				<div>
					<h2>{{beer.beer_name}}</h2>
					<h3>{{breweryBeer this}}</h3>
					<p><strong>Style: </strong>{{beer.beer_style}}</p>
				</div>
		</div>

		{{#if is_loc}}
			<div class="list_box">
				<span class="remove">
					<a href="javascript:void(0);" rel="action-btn" onclick="Location.remove_location(this);">X</a>
				</span>
				<img width="50" height="50" src="{{venue.venue_icon.md}}">
					<div>
						<h2>{{venue.venue_name}}</h2>
						<h3>{{venueHelper venue}}</h3>
						<p><strong>Category: </strong>{{venue.primary_category}}</p>
					</div>
			</div>
			<a href="#!/locationArea/{{beer.bid}}" style="display: none;" class="addLocationBtn confirm yellow_btn large">Add Location</a>
			{{else}}
			<a href="#!/locationArea/{{beer.bid}}" class="addLocationBtn confirm yellow_btn large">Add Location</a>
		{{/if}}

		<div class="comment_photo">
			<span class="add_photo yellow_btn">
				<a href="javascript:void(0);" onclick="Photo.toggle();" rel="action-btn" id="addPhotoContent"></a>
			</span>

			<form id="confirm_form">

				<span id="checkin-counter" class="counter">140</span>

				<textarea name="shout" id="checkin-comment" onkeyup="Limiter.limit('checkin-comment', 'checkin-counter', 140);" onkeydown="Limiter.limit('checkin-comment', 'checkin-counter', 140);" placeholder="How was it? Leave a note..." class="comment"></textarea>

				<input type="hidden" name="bid" id="bid" value="{{beer.bid}}" />
				<input type="hidden" name="gmt_offset" id="gmt_offset" value="{{timeZoneOffset this}}" />
				<input type="hidden" name="timezone" id="timezone" value="{{timeZone this}}" />
				<input type="hidden" name="facebook" id="fb" value="off" />
				<input type="hidden" name="twitter" id="tw" value="off" />
				<input type="hidden" name="foursquare" id="4sq" value="off" />
				<input type="hidden" name="get_rec" id="get_rec" value="true" />

				<input type="hidden" name="rating" id="rating_score" value="{{rating}}"/>

				<input type="hidden" name="geolat" id="geolat" value="{{currentLocationLat this}}" />
				<input type="hidden" name="geolng" id="geolng" value="{{currentLocationLng this}}" />
				<input type="hidden" name="foursquare_id" id="foursquare_id" value="{{venue.foursquare.foursquare_id}}" />

				<input type="hidden" name="is_photo" id="is_photo" value="false" />
				<input type="hidden" name="photo_data" id="photo_data" value="" />

			</form>

		</div>


		<div class="rate_beer">What do you think? Rate this beer...

			<ul class="checkin_rating_bar">

				{{confirmRatings beer.auth_rating}}

			</ul>

		</div>

		<div class="share">
			<p>Share This:</p>
				<ul>
					{{{socialIcon "twitter" "tw"}}}
					{{{socialIcon "facebook" "fb"}}}
					{{#if is_loc}}
						{{{socialIcon "foursquare" "4sq"}}}
					{{/if}}
				</ul>
		</div>

		<a id="check-in-btn" href="javascript:void(0);" rel="action-btn" class="confirm yellow_btn large">Confirm Your Brew</a>

		<div id="check-in-loader" class="loading_inner" style="display:none;">
			<img src="assets/images/spinner.gif" width="24" height="24" />
		</div>


		<div id="checkinbid_{{beer.bid}}" style="display: none;">{{jason this}}</div>

	</div>
</script>
<script id="comment-template" type="text/x-hanlderbars-template">
	{{#each comments.items}}
		<div class="comment">
			<span class="avatar_wrapper" style="background: #fff url({{this.user.user_avatar}}) top left no-repeat;">
				<img width="30" height="30" src="{{this.user.user_avatar}}">
			</span>
			<div>
				<span class="arrow"></span>
				<a href="#!/profileArea/{{this.user.user_name}}/{{checkin_id}}">{{fullName this.user}}</a>:
					{{this.comment}}
				<span class="time">posted <abbr class="timeago">{{this.created_at}}</abbr> ago</span>
			</div>
		</div>
	{{/each}}
</script>
<script id="error-template" type="type/x-hanlderbars-template">
	<p>{{message}}</p>
	<p class="smaller">If your problems persist, please go to <a rel="link-out" href="http://help.untappd.com">http://help.untappd.com</a></p>
</script>
<script id="warning-template" type="type/x-hanlderbars-template">
	<p>{{message}}</p>

	<ul class="beer_actions">
		<li>
			{{{action_btn}}}
		</li>
		<li>
			<a href="javascript:void(0);" class="grey_btn" rel="action-btn" onclick='$("#notice_overlay").hide();'>Cancel</a>
		</li>
	</ul>
  	{{#if badges}}
		<p class="smaller">Please note that you will lose any badges associated with this check-in.</p>
	{{/if}}
</script>
<script id="social-settings-template" type="type/x-hanlderbars-template">
<div class="account social_connect">
	<ul>
		{{handleSocial "twitter"}}
		{{handleSocial "facebook"}}
		{{handleSocial "foursquare"}}
	</ul>
</div>
</script>
<script id="settings-template" type="text/x-hanlderbars-template">
	<li>
        <input placeholder='Your first name' autocorrect="false" autocomplete="false" name="first_name" type='text' value="{{user.first_name}}" />
      </li>
      <li>
        <input placeholder='Your last name' autocorrect="false" autocomplete="false" name="last_name" type='text' value="{{user.last_name}}" />
      </li>
       <li>
        <input placeholder='Your location' autocorrect="false" autocomplete="false" name="location" type='text' value="{{user.location}}" />
      </li>
      <li>
        <input placeholder='Your email address' autocorrect="false" autocomplete="false" name="email_address" type='text' value="{{user.settings.email_address}}" />
      </li>
	   <li>
		<span id="bio-counter" class="counter">140</span>
         <textarea placeholder='A little about yourself' name="bio" id="bio" onkeyup="Limiter.limit('bio', 'bio-counter', 140);" onkeydown="Limiter.limit('bio', 'bio-counter', 140);" autocorrect="false" autocomplete="false">{{user.bio}}</textarea>
      </li>
</script>
<script id="badge-list-template" type="text/x-hanlderbars-template">
{{#each items}}
	<li>
		{{handleRetired this}}
			<span></span>
			<img src="{{this.media.badge_image_sm}}" width="60" height="60" />
			<p>{{this.badge_name}}</p>
		</a>
	</li>
	<div id="badgeDetails_{{this.badge_id}}" style="display: none;">{{jason this}}</div>
{{/each}}
</script>
<script id="badge-single-template" type="text/x-hanlderbars-template">
	<div class="single_badge">
		<span>
			<img src="{{media.badge_image_lg}}" width="60%" />

			<h2>{{badge_name}}</h2>

			<p>{{{badge_description}}}</p>

		</span>

		{{#if beer}}
			<div class="list_box" style="margin-top:10px;">
				<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/badgedetail">
					<img width="50" height="50" src="{{beer.beer_label}}">
					<div>
						<h2>{{beer.beer_name}}</h2>
						<h3>{{brewery.brewery_name}}</h3>
						<p><strong>Style: </strong>{{beer.beer_style}}</p>
					</div>
					<div id="beerbadge_{{beer.bid}}" style="display: none;">{{jason this}}</div>
				</a>
			</div>

			{{#if venue.venue_id}}
				<div class="list_box">
					<a href="#!/venueArea" onclick="Feed.venue({{venue.venue_id}}, {{checkin_id}}, 'badgedetail');">
						<img width="50" height="50" src="{{venue.venue_icon.md}}">
						<div>
							<h2>{{venue.venue_name}}</h2>
							<h3>{{venueHelper venue}}</h3>
							<p><strong>Category: </strong>{{venue.primary_category}} {{venueCategory venue}}</p>
						</div>
						<div id="venuebadge_{{venue.venue_id}}" style="display: none;">{{jason this}}</div>
					</a>
				</div>
			{{/if}}
		{{else}}
			<div class="loading_inner">
				<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
				<p>Loading Details...</p>
			</div>
		{{/if}}

	</div>


</script>
<script id="badge-single-unearned-template" type="text/x-hanlderbars-template">
<div class="single_badge">
	<span>
		<img src="{{media.badge_image_lg}}" width="60%" />

		<h2>{{badge_name}}</h2>

		<p>{{{badge_description}}}</p>

		{{#if badge_status}}
			{{badgeProgress this}}
		{{else}}
			<div class="progress">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading Status...</p>
				</div>
			</div>
		{{/if}}
	</span>
</div>
</script>
<script id="checkin-template" type="text/x-hanlderbars-template">
	<div id="check_view" data-checkin="{{checkin_id}}" class="indiv_checkin">
		<div class="profile_top">
			{{#if user.contact}}
			<div class="social">
				{{#if user.contact.twitter}}
					<a class="tw" rel="link-out" href="http://twitter.com/{{user.contact.twitter}}">Twitter</a>
				{{/if}}
				{{#if user.contact.facebook}}
					<a class="fb" rel="link-out" href="http://www.facebook.com/profile.php?id={{user.contact.faceook}}">Facebook</a>
				{{/if}}

			</div>
			{{/if}}

			<a href="#!/profileArea/{{user.user_name}}/{{checkin_id}}" class="profile avatar_wrapper" style="background: #fff url({{user.user_avatar}}) top left no-repeat;">
				<img width="100%" src="{{user.user_avatar}}">
			</a>

			<div class="profile_details">
				<h1>{{fullName user}}</h1>
				<h2 class="location">{{user.location}}</h2>
			</div>

			{{ratingCheckin this}}

			{{actionButtons this}}

		</div>

		<div style="margin-bottom:10px;" class="blue_bar">
			Check-in Details
		</div>
		<div class="checkin_details">
			<div class="list_box">
				<span class="arrow"><a href="#!/confirmArea/{{beer.bid}}/checkin"></a></span>
				<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}">
					<img width="50" height="50" src="{{beer.beer_label}}">
					<div>
						<h2>{{beer.beer_name}}</h2>
						<h3>{{brewery.brewery_name}}</h3>
						<p><strong>Style: </strong>{{beer.beer_style}}</p>
					</div>
				</a>
				<div id="beercheckin_{{this.beer.bid}}" style="display: none;">{{jason this}}</div>
			</div>

			{{#if venue.venue_id}}
			<div class="list_box">
				<a href="#!/venueArea" onclick="Feed.venue({{venue.venue_id}}, {{checkin_id}}, 'checkin');">
					<img width="50" height="50" src="{{venue.venue_icon.md}}">
					<div>
						<h2>{{venue.venue_name}}</h2>
						<h3>{{venueHelper venue}}</h3>
						<p><strong>Category: </strong>{{venue.primary_category}} {{venueCategory venue}}</p>
					</div>
				</a>
			</div>
			{{/if}}

			{{#if media.count}}
				<div class="list_box photo_current">
					{{photoSingle media}}
				</div>
			{{/if}}

		</div>

		{{interactionHeader this}}

		<div class="checkin_interaction">

			<div id="checkininteractions_{{checkin_id}}">

				<div id="checkintoast_{{checkin_id}}" class="toast_list">
					{{#if toasts.count}}
						{{#toastLongEach toasts.items}}
							<a href="#!/profileArea/{{this.user.user_name}}/{{checkin_id}}">{{fullName this.user}}</a>
						{{/toastLongEach}}
					{{/if}}
				</div>
				<div id="checkincomment_{{checkin_id}}" class="comment_list">
					{{#each comments.items}}
						<div class="comment">
							<span class="avatar_wrapper small" style="background: #fff url({{this.user.user_avatar}}) top left no-repeat;">
								<img width="30" height="30" src="{{this.user.user_avatar}}">
							</span>
							<div>
								{{commentOwner this}}
								<span class="arrow"></span>
								<a href="#!/profileArea/{{this.user.user_name}}/{{checkin_id}}">{{fullName this.user}}</a>:
									{{this.comment}}
								<span class="time">posted <abbr class="timeago">{{this.created_at}}</abbr> ago</span>
							</div>
						</div>
					{{/each}}
				</div>

				{{commentBox this}}

			</div>

			{{deleteCheckin this}}

		</div>

	</div>

</script>
<script id="request-template" type="text/x-hanldebars-template">
<div class="friends">
	<div class="list">
		{{#each items}}
			<div class="list_box">
				<span class="friend-user-item">
					<a href="javascript:void(0);" rel="action-btn" onclick="Friend.approve({{this.user.uid}}, this, 'list');" class="add_btn">
						<span><strong>+</strong></span>
					</a>
					<a href="javascript:void(0);" rel="action-btn" onclick="Friend.reject({{this.user.uid}}, this, 'list');" class="remove_btn">
						<span><strong>&ndash;</strong></span>
					</a>
					<a class="item" href="#!/profileArea/{{this.user.user_name}}/{{this.user.uid}}/pending">
					<span class="avatar_wrapper" style="background: #fff url({{this.user.user_avatar}}) top left no-repeat;">
						<img width="50" height="50" src="{{this.user.user_avatar}}">
					</span>
						<div>
							<h2>{{fullName this.user}}</h2>
							<h3>{{this.user.user_name}}</h3>
							<p><strong>{{this.user.location}}</strong></p>
						</div>
					</a>
				</span>
				<div id="pendingFriend_{{this.user.uid}}" style="display: none;">{{jason this}}</div>
			</div>
		{{/each}}
	</div>
</div>
</script>
<script id="friends-template" type="text/x-hanldebars-template">
{{#each items}}
	<div class="list_box">
		<span class="friend-user-item">
			{{relationshipHelper this false}}
			<a class="item" href="#!/profileArea/{{this.user.user_name}}/{{this.user.uid}}/friends">
				<span class="avatar_wrapper" style="background: #fff url({{this.user.user_avatar}}) top left no-repeat;">
					<img width="50" height="50" src="{{this.user.user_avatar}}">
				</span>
				<div>
					<h2>{{fullName this.user}}</h2>
					<h3>{{userNameHelper this}}</h3>
					<p><strong>{{this.user.location}}</strong></p>
				</div>
			</a>
			<div id="currentFriend_{{this.user.uid}}" style="display: none;">{{jason this}}</div>
		</span>
	</div>
{{/each}}
</script>
<script id="beer-template" type="text/x-hanlderbars-template">
	<div class="beer">
		<div class="profile_top">
			<div id="beerdetail_{{beer.bid}}" class="hide">{{jason this}}</div>

			<span class="avatar_wrapper" style="background: #fff url({{beer.beer_label}}) top left no-repeat;">
				<img width="100%" src="{{beer.beer_label}}">
			</span>

			<div class="profile_details">
				<h1>{{beer.beer_name}}</h1>
				<p><strong>Style:</strong> {{beer.beer_style}}</p>
				<p><strong>ABV:</strong> {{ABV beer.beer_abv}}</p>
			</div>
		</div>

		<ul class="beer_actions">
			<li>
				<a href="#!/confirmArea/{{beer.bid}}" class="yellow_btn">Check-In</a>
			</li>
			{{#if beer.wish_list}}
				<li class="addwish" style="display: none;">
					<a href="javascript:void(0);" rel="action-btn" onclick="Wish.add({{beer.bid}});" class="yellow_btn">Wishlist</a>
				</li>
				<li class="removewish">
					<a href="javascript:void(0);" rel="action-btn" onclick="Wish.remove({{beer.bid}})" class="grey_btn">Wishlist</a>
				</li>
			{{else}}
				<li class="addwish">
					<a href="javascript:void(0);" rel="action-btn" onclick="Wish.add({{beer.bid}});" class="yellow_btn">Wishlist</a>
				</li>
				<li class="removewish" style="display:none;">
					<a href="javascript:void(0);" rel="action-btn" onclick="Wish.remove({{beer.bid}})" class="grey_btn">Wishlist</a>
				</li>
			{{/if}}
		</ul>

		{{#if beer.stats}}

			<div class="profile_stats">
				<a href="#"><span>Total:</span>
					<p>{{Stats beer.stats.total_count}}</p>
				</a>
				<a href="#"><span>Monthly:</span>
					<p>{{Stats beer.stats.monthly_count}}</p>
				</a>
				<a href="#"><span>You:</span>
					<p>{{Stats beer.stats.user_count}}</p>
				</a>
			</div>

			<!-- Ratings -->
			<div class="beer_ratings">
				<div>
					{{beerRatingsHelper this "Average"}}
				</div>
				<div>
					{{beerRatingsHelper this "Your"}}
				</div>
			</div>
			<div class="beer_brewery">
				<div class="list_box">
					<a href="#!/breweryArea" onclick="Feed.brewery({{beer.brewery.brewery_id}}, 'beertemplate');">
						<img width="50" height="50" src="{{beer.brewery.brewery_label}}">
						<div>
							<h2>{{beer.brewery.brewery_name}}</h2>
							<h3>{{breweryLocation beer}}</h3>
							<p><strong>Country: </strong>{{beer.brewery.country_name}}</p>
						</div>
					</a>
					<div id="brewerybeer_{{beer.brewery.brewery_id}}" style="display: none;">{{jason beer}}</div>
				</div>
			</div>

			{{#if beer.media.items}}
				<div class="profile_photos">
					<div>
					{{#mediaeach beer.media.items}}
						<a href="#!/photoSingle/{{this.checkin_id}}/beer"><img width="100%" src="{{this.photo.photo_img_md}}"></a>
						<div id="photocheckinbeer_{{this.checkin_id}}" style="display: none;">{{jason this}}</div>
					{{/mediaeach}}
						<a href="#!/photoGallery/beer/{{beer.bid}}" class="more"><img width="100%" src="assets/images/profile_photos_more.png"></a>
					</div>

				</div>
			{{/if}}

			<div class="bottom_stream">

				<div class="three_tab_bar not_top_three" id="profile_tabs">
					<ul>
						<li><a class="active first" onclick="Toggle.tabs(this, 'beer_tabs', 'beer_stream_profile');" rel="action-btn" href="javascript:void(0);">Activity</a></li>
						<li><a onclick="Toggle.tabs(this, 'beer_tabs', 'detail_stream_profile');" href="javascript:void(0);" rel="action-btn">Details</a></li>
						<li><a class="last" onclick="Toggle.tabs(this, 'beer_tabs', 'similar_stream_profile');" rel="action-btn" href="javascript:void(0);">Similar</a></li>
					</ul>
				</div>

			<div style="display: none;" class="beer_tabs profile_three_tab" id="similar_stream_profile">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading...</p>
				</div>
			</div>

			<div style="display: none;" class="beer_tabs profile_three_tab" id="detail_stream_profile">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading...</p>
				</div>
			</div>

			<div id="beer_stream_profile" class="beer_tabs activity_stream profile_three_tab">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading...</p>
				</div>
			</div>

		{{else}}
			<div class="loading_inner">
				<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
				<p>Loading...</p>
			</div>

			<div style="display: none;" class="profile_three_tab" id="similar_stream_profile"></div>

			<div style="display: none;" class="profile_three_tab" id="detail_stream_profile"></div>

			<div id="beer_stream_profile" class="activity_stream profile_three_tab"></div>

		{{/if}}



	  </div>

	</div>
</script>
<script id="brewery-template" type="text/x-hanlderbars-template">
	<div class="beer">
		<div class="profile_top">

			<div class="social">

				{{#if brewery.contact.twitter}}
					<a class="tw" rel="external" rel="link-out" href="http://twitter.com/{{venueTwitter brewery.contact.twitter}}">Twitter</a>
				{{/if}}
				{{#if brewery.contact.facebook}}
					<a class="fb" rel="link-out" href="{{brewery.contact.facebook}}">Facebook</a>
				{{/if}}

			</div>


			<div id="brewerydetails_{{brewery.brewery_id}}" class="hide">{{jason this}}</div>

			<span class="avatar_wrapper" style="background: #fff url({{brewery.brewery_label}}) top left no-repeat;">
				<img width="100%" src="{{brewery.brewery_label}}">
			</span>

			<div class="profile_details">
				<h1>{{brewery.brewery_name}}</h1>
				<h2 class="location">{{breweryLocation this}}</h2>
				<h2 class="url"><a href="{{brewery.contact.url}}" rel="link-out">{{brewery.contact.url}}</a></h2>
			</div>
		</div>

		{{#if brewery.stats}}

			<div class="profile_stats">
				<a href="#"><span>Total:</span>
					<p>{{Stats brewery.stats.total_count}}</p>
				</a>
				<a href="#"><span>Unqiue:</span>
					<p>{{Stats brewery.stats.unique_count}}</p>
				</a>
				<a href="#"><span>Followers:</span>
					<p>{{Stats brewery.claimed_status.follower_count}}</p>
				</a>
			</div>

			{{breweryFollow this}}

			{{#if brewery.media.items}}
				<div class="profile_photos">
					<div>
					{{#mediaeach brewery.media.items}}
						<a href="#!/photoSingle/{{this.checkin_id}}/brewery"><img width="100%" src="{{this.photo.photo_img_md}}"></a>
						<div id="photocheckinbrewery_{{this.checkin_id}}" style="display: none;">{{jason this}}</div>
					{{/mediaeach}}
						<a href="#!/photoGallery/brewery/{{brewery.brewery_id}}" class="more"><img width="100%" src="assets/images/profile_photos_more.png"></a>
					</div>

				</div>
			{{/if}}

			<div class="bottom_stream">

				<div class="three_tab_bar not_top_three" id="profile_tabs">
					<ul>
						<li><a class="active first" onclick="Toggle.tabs(this, 'brewery_tabs', 'brewery_stream_profile');" rel="action-btn" href="javascript:void(0);">Activity</a></li>
						<li><a onclick="Toggle.tabs(this, 'brewery_tabs', 'brewery_detail_stream_profile');" rel="action-btn" href="javascript:void(0);">Details</a></li>
						<li><a class="last" onclick="Toggle.tabs(this, 'brewery_tabs', 'brewery_beer_list_stream');" rel="action-btn" href="javascript:void(0);">Beer List</a></li>
					</ul>
				</div>

				<div style="display: none;" class="profile_three_tab brewery_tabs" id="brewery_beer_list_stream">
					<div class="loading_inner">
						<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
						<p>Loading...</p>
					</div>
				</div>

				<div style="display: none;" class="profile_three_tab brewery_tabs" id="brewery_detail_stream_profile">
					<div class="loading_inner">
						<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
						<p>Loading...</p>
					</div>
				</div>

				<div id="brewery_stream_profile" class="activity_stream profile_three_tab brewery_tabs">
					<div class="loading_inner">
						<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
						<p>Loading...</p>
					</div>
				</div>

				{{unFollowBrewery this}}

		{{else}}

			<div class="loading_inner">
				<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
				<p>Loading...</p>
			</div>

			<div style="display: none;" class="profile_three_tab brewery_tabs" id="brewery_beer_list_stream">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading...</p>
				</div>
			</div>

			<div style="display: none;" class="profile_three_tab brewery_tabs" id="brewery_detail_stream_profile">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading...</p>
				</div>
			</div>

			<div id="brewery_stream_profile" class="activity_stream profile_three_tab brewery_tabs">
				<div class="loading_inner">
					<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
					<p>Loading...</p>
				</div>
			</div>

		{{/if}}



	  </div>

	</div>
</script>
<script id="venue-template" type="text/x-handlerbars-template">
	<div class="profile_top">

		<div class="social">

			<a class="foursquare" rel="link-out" href="{{venue.foursquare.foursquare_url}}">Foursquare</a>

			{{#if venue.contact.twitter}}
				<a class="tw" rel="link-out" href="http://twitter.com/{{venueTwitter venue.contact.twitter}}">Twitter</a>
			{{/if}}
			{{#if venue.contact.venue_url}}
				<a class="fb" rel="link-out" href="{{venue.contact.venue_url}}">Facebook</a>
			{{/if}}

		</div>

		<div id="venuedetail_{{venue.venue_id}}" class="hide">{{jason venue}}</div>

		<span class="avatar_wrapper" style="background: #fff url({{venue.venue_icon.lg}}) top left no-repeat;">
				<img width="100%" src="{{venue.venue_icon.lg}}">
		</span>

		<div class="profile_details">
			<h1>{{venue.venue_name}}</h1>
			<p><strong>{{venue.location.venue_address}}</strong></p>
			<h2>{{venueHelper venue}}</h2>
			<p><strong>Category:</strong> {{venue.primary_category}} {{venueCategory venue}}</p>
		</div>
	</div>

	{{#if venue.stats}}

		<div class="profile_stats">
			<a href="#"><span>Total:</span>
				<p>{{Stats venue.stats.total_count}}</p>
			</a>
			<a href="#"><span>Distinct:</span>
				<p>{{Stats venue.stats.total_user_count}}</p>
			</a>
			<a href="#"><span>You:</span>
				<p>{{Stats venue.stats.user_count}}</p>
			</a>
		</div>

		{{#if venue.media.items}}
			<div class="profile_photos">
				<div>
				{{#mediaeach venue.media.items}}
					<a href="#!/photoSingle/{{this.checkin_id}}/venue"><img width="100%" src="{{this.photo.photo_img_md}}"></a>
					<div id="photocheckinvenue_{{this.checkin_id}}" style="display: none;">{{jason this}}</div>
				{{/mediaeach}}
					<a href="#!/photoGallery/venue/{{venue.venue_id}}" class="more"><img width="100%" src="assets/images/profile_photos_more.png"></a>
				</div>

			</div>
		{{/if}}

		<div class="bottom_stream">

			<div class="three_tab_bar not_top_three" id="venue_tabs">
				<ul>
					<li><a rel="action-btn" class="active first" onclick="Toggle.tabs(this, 'venue_tab_content', 'venue_stream_profile'); return false;" href="javascript:void(0);">Activity</a></li>
					<li><a rel="action-btn" onclick="Toggle.tabs(this, 'venue_tab_content', 'info_stream_profile'); return false;" href="javascript:void(0);">Details</a></li>
					<li><a class="last" rel="action-btn" onclick="Toggle.tabs(this, 'venue_tab_content', 'top_beers_stream_profile'); return false;" href="javascript:void(0);">Popular</a></li>
				</ul>
			</div>

			<div class="venue_tab_content profile_three_tab" style="display: none;" id="info_stream_profile"></div>

			<div class="venue_tab_content profile_three_tab" style="display: none;" id="top_beers_stream_profile"></div>

			<div id="venue_stream_profile" class="venue_tab_content activity_stream profile_three_tab"></div>

	  	</div>
	{{else}}

		<div class="loading_inner">
			<img src="assets/images/spinner.gif" width="24" height="24" /><br /><br />
			<p>Loading...</p>
		</div>

		<div class="venue_tab_content profile_three_tab" style="display: none;" id="info_stream_profile"></div>

		<div class="venue_tab_content profile_three_tab" style="display: none;" id="top_beers_stream_profile"></div>

		<div id="venue_stream_profile" class="venue_tab_content activity_stream profile_three_tab"></div>

	{{/if}}


</script>
<script id="country-template" type="text/x-handlebars-template">
	<option id="">Choose your country</option>
	{{#each items}}
		<option value="{{this.country_id}}">{{this.country_name}}</option>
	{{/each}}
</script>
<script id="beer-popular" type="text/x-handlebars-template">
	<div class="list">
		{{#each items}}
			<div class="list_box">
				<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/venue" class="item">
					<img width="50" height="50" src="{{this.beer.beer_label}}">
					<div>
						<h2>{{this.beer.beer_name}}</h2>
						<h3>{{this.brewery.brewery_name}}</h3>
						<p><strong>Style: </strong>{{this.beer.beer_style}}</p>
						<p>
							<strong>ABV: </strong>{{ABV this.beer.beer_abv}}
						</p>
					</div>
					<div id="beertopvenue_{{this.beer.bid}}" style="display: none;">{{jason this}}</div>
				</a>
				{{peopleHelper this}}

			</div>
		{{/each}}
	</div>
</script>
<script id="beer-wishlist" type="text/x-handlebars-template">
	{{#each items}}
		<div id="beerwishlist_{{this.beer.bid}}" class="list_box user_wishlist_item">
			{{wishListHelper this}}
			<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/wish" class="item">
				<img width="50" height="50" src="{{this.beer.beer_label}}">
				<div>
					<h2>{{this.beer.beer_name}}</h2>
					<h3>{{this.brewery.brewery_name}}</h3>
					<p><strong>Style: </strong>{{this.beer.beer_style}}</p>
				</div>
				<div id="beerwish_{{this.beer.bid}}" style="display: none;">{{jason this}}</div>
			</a>
			{{peopleHelper this "wish"}}
		</div>
	{{/each}}
</script>
<script id="beer-recommend-list" type="text/x-handlebars-template">
	{{#each items}}
		<div id="beerrecommend_{{this.beer.bid}}" class="list_box user_wishlist_item">
			{{wishListHelper this}}
			<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/recommend" class="item">
				<img width="50" height="50" src="{{this.beer.beer_label}}">
				<div>
					<h2>{{this.beer.beer_name}}</h2>
					<h3>{{this.brewery.brewery_name}}</h3>
					<p><strong>Style: </strong>{{this.beer.beer_style}}</p>
				</div>
				<div id="beerrec_{{this.beer.bid}}" style="display: none;">{{jason this}}</div>
			</a>
			{{peopleHelper this}}
		</div>
	{{/each}}
</script>
<script id="drink-up-template" type="text/x-handlebars-template">
	<div class="list drink_up">
		{{#each items}}
			<div class="list_box beer_recent" id="recent_{{this.beer.bid}}">
				<span class="arrow"><a href="#!/confirmArea/{{beer.bid}}/recent"></a></span>
				<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/recent" class="item">
					<img width="50" height="50" src="{{this.beer.beer_label}}">
						<div>
							<h2>{{this.beer.beer_name}}</h2>
							<h3>{{this.brewery.brewery_name}}</h3>
							<p><strong>Style: </strong>{{this.beer.beer_style}}</p>
						</div>
						<div id="beerrecent_{{this.beer.bid}}" style="display: none;">{{jason this}}</div>
				</a>
			</div>
		{{/each}}
	</div>
</script>
<script id="distinct-beer-template" type="text/x-handlebars-template">
	{{#each items}}
		<div class="list_box distinct-beer-list">
			<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/distinct" class="item">
				<img width="50" height="50" src="{{this.beer.beer_label}}">
					<div>
						<h2>{{this.beer.beer_name}}</h2>
						<h3>{{this.brewery.brewery_name}}</h3>
						<p><strong>Style: </strong>{{this.beer.beer_style}}</p>
						<p><strong>ABV: </strong>{{ABV this.beer.beer_abv}}</p>
						<p><strong>First Had: </strong>{{moment this.first_had}}</abbr></p>
					</div>
					<div id="beerdistinct_{{this.beer.bid}}" style="display: none;">{{jason this}}</div>
			</a>
		</div>
	{{/each}}
</script>
<script id="beersearch-template" type="text/x-handlebars-template">
	<div class="list drink_up">
		{{#if message}}
		<div class="list_box">
			<a href="http://help.untappd.com" rel="link-out" class="item">
				<img src="assets/images/no_results_icon.jpg" />
				<div style="font-size: 14px;">
					{{message}}
				</div>
			</a>
		</div>
		{{/if}}
		{{#each beers.items}}
			<div class="list_box">
				{{#if this.your_count}}
					<span class="drank"></span>
				{{/if}}
				<span class="arrow"><a href="#!/confirmArea/{{beer.bid}}/search"></a></span>
				<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/search" class="item">
					<img width="50" height="50" src="{{this.beer.beer_label}}">
						<div>
							<h2>{{this.beer.beer_name}}</h2>
							<h3>{{this.brewery.brewery_name}}</h3>
							<p><strong>Style: </strong>{{this.beer.beer_style}}</p>
						</div>
						<div id="beersearch_{{this.beer.bid}}" style="display: none;">{{jason this}}</div>
				</a>
			</div>
		{{/each}}
		{{#if homebrews.items}}
			<div class='blue-bar'>
				Homebrew Results
			</div>
		{{/if}}
		{{#each homebrews.items}}
			{{#if this.your_count}}
				<span class="drank"></span>
			{{/if}}
			<span class="arrow"><a href="#!/confirmArea/{{beer.bid}}/search"></a></span>
			<div class="list_box">
				<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/search" class="item">
					<img width="50" height="50" src="{{this.beer.beer_label}}">
						<div>
							<h2>{{this.beer.beer_name}}</h2>
							<h3>{{this.brewery.brewery_name}}</h3>
							<p><strong>Style: </strong>{{this.beer.beer_style}}</p>
						</div>
						<div id="beersearch_{{this.beer.bid}}" style="display: none;">{{jason this}}</div>
				</a>
			</div>
		{{/each}}
		<div class="list_box">
			<a href="#!/addBeerArea1" class="item">
				<img src="assets/images/no_results_icon.jpg" />
				<div>
					<h2>Don&apos;t see your beer?</h2>
					<h4>Double check your spelling! If it doesn&apos;t exist, you can add it here.</h4>
				</div>
			</a>
		</div>
	</div>
</script>
<script id="empty-list-box" type="text/x-handlebars-template">
	<div class="list_box">
		<a href="javsascript:void(0);" rel="action-btn" class="item">
			<img src="assets/images/no_results_icon.jpg" />
			<div>
				<h2>{{h2_message}}</h2>
				<h3>{{h3_message}}</h3>
			</div>
		</a>
	</div>
</script>
<script id="brewerysearch-template" type="text/x-handlebars-template">
	<div class="list drink_up">
		{{#if breweries.items}}
		{{#each breweries.items}}
			<div class="list_box">
				<a href="#!/breweryArea" onclick="Feed.brewery({{this.brewery.brewery_id}});" class="item">
					<img width="50" height="50" src="{{this.brewery.brewery_label}}">
						<div>
							<h2>{{this.brewery.brewery_name}}</h2>
							<h3>{{this.brewery.country_name}}</h3>
							<p>{{breweryLocation this.brewery}}</p>
						</div>
						<div id="brewerysearch_{{this.brewery.brewery_id}}" style="display: none;">{{jason this}}</div>
				</a>
			</div>
		{{/each}}
		{{else}}
		<div class="list_box">
			<a href="javascript:void(0);" class="item">
				<img src="assets/images/no_results_icon.jpg" />
				<div>
					<h2>No breweries found!</h2>
					<h4>Double check your spelling and try again.</h4>
				</div>
			</a>
		</div>
		{{/if}}
	</div>
</script>
<script id="brewery-type-template" type="text/x-handlebars-template">
	<option value="">Choose a Brewery Type</option>
	{{#each items}}
		<option value="{{this.brewery_type_id}}">{{this.brewery_type_name_plain}}</option>
	{{/each}}
</script>
<script id="beer-type-template" type="text/x-handlebars-template">
	<option value="">Choose a Style</option>
	{{#each items}}
		<option value="{{this.type_id}}">{{this.type_name}}</option>
	{{/each}}
</script>
<script id="addbeer-brewery-template" type="text/x-handlebars-template">
	<div class="list">
		{{#each brewery.items}}
			<div class="list_box beer_recent" id="breweryadd_{{this.brewery_id}}">
				<a href="#!/addBeerArea3" onclick='Add.step(1, {{this.brewery_id}}, "{{this.brewery_name}}");' class="item">
					<img width="50" height="50" src="{{this.brewery_label}}">
					<div>
						<h2>{{this.brewery_name}}</h2>
						<h3>{{this.country_name}}</h3>
						<h3>{{breweryLocation this}}</h3>
					</div>
				</a>
			</div>
		{{/each}}
		<div class="list_box">
			<a href="#!/addBeerArea2" class="item">
				<img src="assets/images/no_results_icon.jpg" />
				<div>
					<h2>Don&apos;t see your brewery?</h2>
					<h3>You must select a brewery to associate your new beer with. You can add a new brewery here.</h3>
				</div>
			</a>
		</div>

	</div>

</script>
<script id="addbeer-beer-template" type="text/x-handlebars-template">
	<div class="list">
		{{#each beers.items}}
			<div class="list_box">
				<div id="beeradd_{{this.beer.bid}}" style="display: none;">{{jason this}}</div>
				<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/beeradd" class="item">
					<img width="50" height="50" src="{{this.beer.beer_label}}">
					<div>
						<h2>{{this.beer.beer_name}}</h2>
						<h3>{{this.brewery.brewery_name}}</h3>
						<p><strong>Style: </strong>{{this.beer.beer_style}}</p>
					</div>
				</a>
			</div>
		{{/each}}
		{{#each homebrew.items}}
			<div class="list_box beer_recent" id="beeradd_{{this.beer.bid}}">
				<a href="#!/beerArea/{{beer.bid}}/{{checkin_id}}/beeradd" class="item">
					<img width="50" height="50" src="{{this.beer.beer_label}}">
					<div>
						<h2>{{this.beer.beer_name}}</h2>
						<h3>{{this.brewery.brewery_name}}</h3>
						<p><strong>Style: </strong>{{this.beer.beer_style}}</p>
					</div>
				</a>
			</div>
		{{/each}}
		<div class="list_box">
			<a href="#!/addBeerArea4" onclick="Add.beer_name_add();" class="item">
				<img src="assets/images/no_results_icon.jpg" />
				<div>
					<h2>Don&apos;t see your Beer?</h2>
					<h3>Looks like you&apos;ve found a true original. You can continue to add it here.</h3>
				</div>
			</a>
		</div>
	</div>
</script>

