Handlebars.registerHelper('jason', function(string) {

	var s = JSON.stringify(string);

	return s;
});

Handlebars.registerHelper('checkFriend', function(a) {
	if (a.user.relationship == "friends") {
		return "toast-friends";
	}
});

Handlebars.registerHelper('fullName', function(person) {
	return $.trim(person.first_name + " " + person.last_name);
});

Handlebars.registerHelper('actionRelationship', function(a) {
	
	var code = "";

	if (a.user.relationship == "friends" || a.user.relationship == "self") {
		code = '<div class="actions"><a class="comment" href="#!/indCheckin/'+a.checkin_id+'/comment"></a>';

		if (a.toasts.auth_toast) {
			code += '<a class="toast active" rel="action-btn" onclick="Toast.feed('+a.checkin_id+', this);"><span></span></a>';
		}
		else {
			code += '<a class="toast" rel="action-btn" onclick="Toast.feed('+a.checkin_id+', this);"><span></span></a>';
		}

		code += '</div>';
	}

	return new Handlebars.SafeString(code);

});

Handlebars.registerHelper("generateButton", function(a) {

	var code = "";

	if (a.user.relationship == "self") {

		if (a.media.count != 0) {
			code = '<div class="checkin_util three"><span><a href="javascript:void(0);" rel="action-btn" onclick="Checkin.start('+a.checkin_id+');" class="button red_btn">Delete Check-in</a></span><span><a href="javascript:void(0);" rel="action-btn" onclick="Photo.start_delete_photo('+a.media.items[0].photo_id+');" class="red_btn button">Remove Photo</a></span><span><a href="javascript:void(0);" rel="action-btn" onclick="MenuToggle.share();" class="button grey_btn">Share Check-in</a></span></div>';
		}
		else {
			code = '<div class="checkin_util three"><span><a href="javascript:void(0);" rel="action-btn" onclick="Checkin.start('+a.checkin_id+');" class="button red_btn">Delete Check-in</a></span><span><a href="javascript:void(0);" rel="action-btn" onclick="MenuToggle.share();" class="button grey_btn">Share Check-in</a></span></div>';
		}
	}
	else {
		if (a.media.count != 0) {
			code = '<div class="checkin_util one"><span><a href="javascript:void(0);" rel="action-btn" onclick="MenuToggle.photo_flag();" class="red_btn button">Flag Photo</a></span></div>';
		}
	}

	return new Handlebars.SafeString(code);
});

Handlebars.registerHelper("generateRatingFeed", function(b, a) {

	var code = "";

	if (parseFloat(b.rating_score) != 0) {

		var num = parseFloat(b.rating_score);

		var s = num.toString();

		if (s.length == 1) {
			s += "0";
		}

		var ratingCSS = s.replace(".", "");

		code = '<span class="rating '+a+' r'+ratingCSS+'"></span>';

	}

	return new Handlebars.SafeString(code);

});

Handlebars.registerHelper("generateRatingCheckin", function(b) {

	var code = "";

	if (parseFloat(b.rating_score) != 0) {

		var num = parseFloat(b.rating_score);

		var s = num.toString();

		if (s.length == 1) {
			s += "0";
		}

		var ratingCSS = s.replace(".", "");

		code = '<span class="rating small r'+ratingCSS+'"></span>';

	}

	return new Handlebars.SafeString(code);

});

Handlebars.registerHelper('parseDirections', function(venue) {

	if (venue.primary_category != "Residence") {
		var code = '<p id="directions"><a href="javascript:void(0);"rel="action-btn" onclick="Directions.start('+venue.location.lat+','+venue.location.lng+');" class="yellow_btn small">Show Directions</a></p><div id="directionsLoader" style="display: none; padding-top: 10px;" class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /></div>';

		return new Handlebars.SafeString(code);
	}

});

Handlebars.registerHelper('parseMap', function(venue) {

	if (venue.primary_category != "Residence") {

		var code = '<p><strong>Venue Map:</strong></p><p><img height="150" width="300" src="http://staticmaps.cloudmade.com/0d9643c7b8f44ff88ce75136e55971a0/staticmap?marker=size:big|label:X|opacity:0.9|'+venue.location.lat+','+venue.location.lng+'&zoom=14&size=500x300&format=jpg&styleid=65578"></p>';

		return new Handlebars.SafeString(code);
	}

});


Handlebars.registerHelper('ratingCheckin', function(items) {
	
	var code = "";
	
	if (items.checkin_comment != "" || items.rating_score != 0) {
	
		code = '<div class="checkin_comment"><span class="arrow"></span><div>';

		if (items.checkin_comment != "") {
			
			code += '<p>'+items.checkin_comment+'</p>';
		}
	}
		
	if (parseInt(items.rating_score) != 0) {
		

		var num = parseFloat(items.rating_score);

		var s = num.toString();

		if (s.length == 1) {
			s += "0";
		}

		var ratingCSS = s.replace(".", "");

		code += '<span class="rating small r'+ratingCSS+'"></span>';
	
	}
	
	if (items.checkin_comment != "" || items.rating_score != 0) {
		
		code += '</div></div>';
	}
	
	return new Handlebars.SafeString(code);
});

Handlebars.registerHelper("Stats", function(stats) {
	if (stats) {
		
		if (parseInt(stats) >= 100000) {
			var n = parseInt(stats) / 1000;
			return Math.round(n) + "K+";
		}
		
		return stats;
	}
	else {
		return 0;
	}
});

Handlebars.registerHelper("commentOwner", function(context) {
	
	if (context.comment_owner) {
		var code = '<a class="delete_comment" href="javascript:void(0);" rel="action-btn" onclick="Comment.start_delete('+context.comment_id+');"></a>';
		
		return new Handlebars.SafeString(code);
	}
	
});

Handlebars.registerHelper("supportStats", function(data) {

	if (data.user.relationship == "self") {

		if (data.user.is_supporter) {
			var code = '<li><a href="#!/statsArea">Statistics</a></li>';
			return new Handlebars.SafeString(code);
		}
	}
});

Handlebars.registerHelper("handleSeeMoreTopStyles", function(count) {

	var code = "";

	if (parseInt(count) > 3) {
		code = '<a class="yellow_btn small" href="#!/statsAreaTopStyles">See More Styles</a>';	

		return new Handlebars.SafeString(code);
	}

	
});

Handlebars.registerHelper("handleSeeMoreTopBeers", function(count) {

	var code = "";

	if (parseInt(count) > 3) {
		code = '<a class="yellow_btn small" href="#!/statsAreaTopBeers">See More Beers</a>';

		return new Handlebars.SafeString(code);	
	}

	
});

Handlebars.registerHelper("handleSeeMoreTopVenues", function(count) {

	var code = "";

	if (parseInt(count) > 3) {
		code = '<a class="yellow_btn small" href="#!/statsAreaTopVenues">See More Venues</a>';	

		return new Handlebars.SafeString(code);
	}

	
});

Handlebars.registerHelper("handleSeeMoreTopBreweries", function(count) {

	var code = "";

	if (parseInt(count) > 3) {
		code = '<a class="yellow_btn small" href="#!/statsAreaTopBreweries">See More Breweries</a>';	

		return new Handlebars.SafeString(code);
	}

	
});

Handlebars.registerHelper("friendListLinkHelper", function(data) {

	if (data.user.relationship == "self") {
		var code = '<li><a href="#!/friendlistArea">Friends</a></li>';
		
		return new Handlebars.SafeString(code);
	}
	else {
		var code = '<li><a href="#!/userFriendList/'+data.user.user_name+'/full">Friends</a></li>';
		
		return new Handlebars.SafeString(code);
	}
});

Handlebars.registerHelper("wishListLinkHelper", function(data) {
	
	if (data.user.relationship == "self") {
		var code = '<li><a href="#!/wishListArea/'+data.user.user_name+'/full/you">Wish List</a></li>';
		
		return new Handlebars.SafeString(code);
	}
	else {
		var code = '<li><a href="#!/wishListArea/'+data.user.user_name+'/full/no">Wish List</a></li>';
		
		return new Handlebars.SafeString(code);
	}
});

Handlebars.registerHelper("interactionHeader", function(data) {
	
	var code = "";
	
	if (data.user.relationship) {
		
		if (data.toasts) {
			
			if (data.toasts.count == 0 && data.comments.count == 0) {
				if (data.user.relationship == "friends" || data.user.relationship == "self") {
					code = '<div class="interactions_header blue_bar">Toasts and comments</div>';
				}
				else {
					code = '<div class="interactions_header blue_bar" style="display: none;">Toasts and comments</div>'; 
				}	
			}
			else {
				code = '<div class="interactions_header blue_bar">Toasts and comments</div>';
			}

			return new Handlebars.SafeString(code);
			
		}
		
	}
	
})

Handlebars.registerHelper("commentBox", function(data) {
	
	var code = "";
	var keyword = "friend\'s";
	
	if (data.user.relationship == "friends" || data.user.relationship == "self") {
		
		if (data.user.relationship == "self")
		{
			keyword = "own";
		}
		
		code = '<form class="comment-form"><span id="comment_counter" class="counter">140</span><textarea name="comment" id="comment_box" placeholder="Comment on your '+keyword+' check in..." class="comment_text" onkeyup="Limiter.limit(\'comment_box\', \'comment_counter\', 140);" onkeydown="Limiter.limit(\'comment_box\', \'comment_counter\', 140);"></textarea></form><a href="#" rel="action-btn" onclick="Comment.add(this, '+data.checkin_id+'); return false;" class="yellow_btn large comment_btn">POST COMMENT</a>';
		
		code += '<div id="comment_inner_spinner" class="loading_inner hide"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /></div>';
	}
	
	return new Handlebars.SafeString(code);
	
});

Handlebars.registerHelper('actionButtons', function(data) {
	
	var code = "";
	
	if (data.user.relationship == "friends" || data.user.relationship == "self") {
		
		code = '<div class="checkin_actions">';
		
		if (data.toasts.auth_toasts) {
			code += '<a href="javascript:void(0);" rel="action-btn" onclick="Toast.add(this, '+data.checkin_id+'); return false;" class="toast active yellow_btn"><span>Toast</span></a>';
		}
		else
		{
			code += '<a href="javascript:void(0);" rel="action-btn" onclick="Toast.add(this, '+data.checkin_id+'); return false;" class="toast yellow_btn"><span>Toast</span></a>';
		}
		
		code += '<a href="javascript:void(0);" rel="action-btn" onclick="Comment.focus();" class="comment yellow_btn"><span>Comment</span></a>';
		
		code += '</div>';
		
	}
	
	return new Handlebars.SafeString(code);
});

Handlebars.registerHelper("photoSingle", function(media) {
	var code = '<img width="100%" src="'+media.items[0].photo.photo_img_md+'" />';
	return new Handlebars.SafeString(code);
})


Handlebars.registerHelper("venueTwitter", function(twitter) {
	return twitter.replace("@", "");
})

Handlebars.registerHelper("peopleHelper", function(data, type) {
	
	var f = "";
	
	if (data.friends) {
		
		if (parseInt(data.friends.count) > 1) {
			
			var limit = data.friends.count;
			
			if (data.friends.count >= 3) {
				limit = 3;
			}
			
			f = "Your friends ";
			
			for(i = 0; i < limit; i++) {
				var full_name = $.trim(data.friends.items[i].user.first_name + " " + data.friends.items[i].user.last_name);
				
				if (i == (limit - 1)) {
					f += "and <strong>"+ full_name + "</strong>";
				}
				else {
					f += "<strong>"+ full_name + "</strong>, ";
				}
			
			}
			
			if (type == "wish") {
				
				if (parseInt(limit) > 1) {
					f += " have this on their wishlist.";
				}
				else {
					f += " has this on their wishlist.";
				}
				
				
			}
			else {
				f += " had this.";
			}
		}
		else 
		{
			//f = " <strong>"+ data.friends.items[0].user.first_name + " " + data.friends.items[0].user.last_name + "</strong> has this.";
		}
	}

	if (data.friends.count > 1 && f != "") {
		return new Handlebars.SafeString("<div class='friends'><a href='javascript:void(0);' rel='action-btn'>"+f+"</a></div>");
	}
	else {
		if (data.total_count) {
			if (parseInt(data.total_count) < 25) {
		
				if (parseInt(data.total_count) <= 1) {
					return new Handlebars.SafeString("<div class='friends'><a href='javascript:void(0);' rel='action-btn'>Enjoyed by <strong>" + data.total_count + "</strong> person.</a></div>");
				}
				else {
					return new Handlebars.SafeString("<div class='friends'><a href='javascript:void(0);' rel='action-btn'>Enjoyed by <strong>" + data.total_count + "</strong> people.</a></div>");
				}
			}
			else {
				return "";
			}
		}
	}

});

Handlebars.registerHelper('breweryHelperLocation', function(brewery) {
 	

	if (brewery.location) {
		if (String(brewery.location.venue_city) == "" || String(brewery.location.venue_state) == "") {
			return "";
		}
		else if (String(brewery.location.venue_city) == "null" || String(brewery.location.venue_state) == "null") {
			return "";
		}
		else {
			return brewery.location.venue_city + ", " + brewery.location.venue_state;
		}
	}	
	else {
		//console.log(brewery.location + " is unddeinfed");
	}
});

Handlebars.registerHelper("userNameHelper", function(content) {
	
	if (content.social) {
		
		if (content.social == "twitter") {
			return content.account_name;
		}
		else {
			return content.user.user_name;
		}
		
	}
	else {
		return content.user.user_name;
	}
});


Handlebars.registerHelper("breweryFollow", function(data) {
	
	var code = "";
	
	if (data.brewery.claimed_status) {
		if (data.brewery.claimed_status.is_claimed && !data.brewery.claimed_status.follow_status) {
			code = '<a class="yellow_btn large" href="javascript:void(0);" rel="action-btm" onclick="Friend.request('+data.brewery.claimed_status.uid+', this, \'follow\')">Follow This Brewery</a>';
			
			
		}
	}
	
	return new Handlebars.SafeString(code);
})

Handlebars.registerHelper("unFollowBrewery", function(data) {
	
	var code = "";
	
	if (data.brewery.claimed_status) {
		if (data.brewery.claimed_status.is_claimed && data.brewery.claimed_status.follow_status) {
			code = '<a class="grey_btn small" href="javascript:void(0);" rel="action-btn" onclick="Friend.remove('+data.brewery.claimed_status.uid+', this, \'follow\')">Unfollow This Brewery</a>';
			
			
		}
	}
	
	return new Handlebars.SafeString(code);
});

Handlebars.registerHelper("photoDelFlag", function(data) {

	if (data.user.relationship == "self") {
		code = '<a class="grey_btn small" href="javascript:void(0);" rel="action-btn" onclick="Photo.start_delete('+data.media.items[0].photo_id+');">Delete This Photo</a>';
	}
	else {
		code = '<a class="grey_btn small" href="javascript:void(0);" rel="action-btn" onclick="Photo.start_flag('+data.media.items[0].photo_id+');">Flag This Photo</a>';
	}

	return new Handlebars.SafeString(code);

});

Handlebars.registerHelper('venueHelper', function(venue) {
	
	var cat = "";
	
	if (String(venue.location.venue_address) != "" && String(venue.location.venue_address) != "null") {
		cat = venue.location.venue_address + " ";
	}
	
	if (String(venue.location.venue_city) == "" || String(venue.location.venue_state) == "") {
		return cat;
	}
	else if (String(venue.location.venue_city) == "null" || String(venue.location.venue_state) == "null") {
		return cat;
	}
	else {
		cat += venue.location.venue_city + ", " + venue.location.venue_state;
		return cat;
	}
});

Handlebars.registerHelper('venueCategory', function(venue) {
	
	for(i = 0; i < venue.categories.count; i++) {
		if (venue.categories.items[i].is_primary) {
			return "("+venue.categories.items[i].category_name+")";
		}
	}
});

Handlebars.registerHelper('venueFriend', function(venue) {
	
	var t;
	var verb= "is";
	
	if (venue.total_users != 0) {
		if (venue.total_users == 1) {
		t = "person";

		}
		else {
			t = "people";
			verb = "are";
		}
		
		
		if (venue.friends.count == 0) {
			return venue.total_users + " " + t + " " + verb + " here - " + venue.distance + " mile(s) away";
		}
		else {
			
			var s = "";
			
			
			if (venue.friends.count > 1) {
				s = "s";
			}
			return venue.total_users + " " + t + " " + verb + " here ("+venue.friends.count + " friend"+s+")  - "+venue.distance + " mile(s) away";
		}
	}
	else {
		return venue.distance + " mile(s) away";
	}
});

Handlebars.registerHelper('parseDistance', function(dist) {
	
	if (parseInt(dist) <= 0) 
	{
		return "<1";
	}
	else
	{
		return dist;
	}
});

Handlebars.registerHelper('peopleLink', function(c, a) {
	
	var link = "";
	
	if (c.user.account_type == "user") {
		link = "#!/profileArea/"+c.user.user_name+"/"+c.user.uid+"/"+a
	}
	else {
		link = "#!/breweryArea/"+c.user.brewery_details.brewery_id+"/full";
	}
	
	return new Handlebars.SafeString(link);
});


Handlebars.registerHelper('parseTime', function(time) {
	
	var a = new Date(Date.parse(time));

	var h = a.getHours();
	
	var t = (a.getMonth() + 1) + "-" + a.getDate() + "-"+ a.getFullYear();	
	
	return t;
});

Handlebars.registerHelper('breweryDescription', function(content) {
	
	if (content.brewery_description == "") {
		return "No Description Available.";
	}
	else {
		return content.brewery_description;
	}
});

Handlebars.registerHelper('beerDescription', function(content) {
	
	if (content.beer_description == "") {
		return "No Description Available.";
	}
	else {
		return content.beer_description;
	}
});


Handlebars.registerHelper('breweryDetailsLocation', function(content) {
	
	if (content.location.brewery_city != "" && content.location.brewery_state != "") {

		return content.location.brewery_city + ", " + content.location.brewery_state;
	}
	else
	{
		return "No Location Available.";
	}
});

Handlebars.registerHelper('breweryDetailsMap', function(content) {
	
	if (content.location.brewery_lat != "" && content.location.brewery_lng != "") {
		var code = '<img src="http://staticmaps.cloudmade.com/0d9643c7b8f44ff88ce75136e55971a0/staticmap?size=600x600&marker=size:big|label:X|'+content.location.brewery_lat+','+content.location.brewery_lng+'&zoom=17&styleid=65578" height="300" width="300">';
		
		return new Handlebars.SafeString(code);
	
	}
	else
	{
		return "";
	}
}); 

Handlebars.registerHelper('followStatus', function(data) {
	
	var code = "";
	
	if (data.follow_status.is_follow) {
		if (!data.follow_status.status) {
			code = '<a href="javascript:void(0);" rel="action-btn" onclick="Friend.request('+data.follow_status.uid+', this, \'follow\');" class="yellow_btn small">FOLLOW THIS BREWERY</a>';
		}
	}
	
	return new Handlebars.SafeString(code);
});

Handlebars.registerHelper('breweryLocation', function(breweryLocation) {
	
	if (breweryLocation.brewery) {
		if (breweryLocation.brewery.location.brewery_city != "" && breweryLocation.brewery.location.brewery_state != "") {

			code = "<strong>"+breweryLocation.brewery.location.brewery_city + ", " + breweryLocation.brewery.location.brewery_state+"</strong>";

			return new Handlebars.SafeString(code);
		}
		else
		{
			return "";
		}
	}
	else {
		if (breweryLocation.location.brewery_city != "" && breweryLocation.location.brewery_state != "") {

			code = "<strong>"+breweryLocation.location.brewery_city + ", " + breweryLocation.location.brewery_state+"</strong>";

			return new Handlebars.SafeString(code);
		}
		else
		{
			return "";
		}
	}
	
	
});

Handlebars.registerHelper('ABV', function(person) {
	
	if (person == "0" || person == "undefined")
	{
		return "N/A";
	}
	else 
	{
		return person + "%";
	}
});

Handlebars.registerHelper('IBU', function(person) {
	if (person == "0")
	{
		return "N/A";
	}
	else 
	{
		return person;
	}
});

Handlebars.registerHelper('mediaeach', function(content, options) {
	var ret = "";

	if(content.length > 4)
	{
		var limit = 4;
	}
	else {
		var limit = content.length;
	}

	for(var i=0, j=limit; i<j; i++) {
		ret = ret + options.fn(content[i]);
	}

	return ret;
});

Handlebars.registerHelper('beereach', function(content, options) {
	var ret = "";

	if(content.length > 15)
	{
		var limit = 15;
	}
	else {
		var limit = content.length;
	}

	for(var i=0, j=limit; i<j; i++) {
		ret = ret + options.fn(content[i]);
	}

	return ret;
});

Handlebars.registerHelper("userFriendship", function(content) {
	
	if (content.relationship) {
		
		if (content.relationship == "none") {
			return new Handlebars.SafeString('<a href="javascript:void(0);" onclick="Friend.request('+content.id+', this, \'profile\');" rel="action-btn" class="yellow_btn small">Add as Friend</a>');
		
		}
		else if (content.relationship == "friends" || content.relationship == "self") {
			return "";
		}
		else if (content.relationship == "pending_you" || content.relationship == "ignore") {
			return new Handlebars.SafeString('<a href="javascript:void(0);" onclick="Friend.approve('+content.id+', this, \'profile\');" rel="action-btn" class="yellow_btn small">Confirm as Friend</a>');
		}
		else {
			return new Handlebars.SafeString('<a href="javascript:void(0);" rel="action-btn" class="grey_btn small">Pending Acceptance</a>');
		}
	}
	
});

Handlebars.registerHelper('noteText', function(content) {
	
	if (content.notification_type == "comment") {
		if (content.checkin_owner) {
			txt = "commented on your check-in to";
		}
		else {
			txt = "also commented on the check-in to";
		}
	}
	else if (content.notification_type == "message") {
		txt = "sent you a message";
	}
	else {
		if (content.checkin_owner) {
			txt = "toasted your check-in to";
		}
		else {
			txt = "also toasted the check-in to";
		}
	}
	
	return txt;
	
});

Handlebars.registerHelper('checkType', function(content) {
	
	var code = "";

	if (content.notification_type == "message") {
		
		code = '<a class="item new" href="#!/messageArea" class="item">';
	}
	else {
		
		code = '<a class="item new" href="#!/indCheckin/'+content.checkin_id+'/notifications" class="item">';
	}
	
	return new Handlebars.SafeString(code);
});

Handlebars.registerHelper('dotDot', function(data) {
	
	if (data.length >= 125) {
		return data.substring(0, 125) + "...";
	}
	else {
		return data;
	}
	
});

Handlebars.registerHelper('timeZone', function(option) {
	var tz = Timezone.get();
	
	return tz["zone"];
});

Handlebars.registerHelper('timeZoneOffset', function(option) {
	var tz = Timezone.get();
	
	return tz["offset"];
});

Handlebars.registerHelper('currentLocationLat', function(content) {
	return Geolocate.getCurrentLat();
});

Handlebars.registerHelper('currentLocationLng', function(content) {
	return Geolocate.getCurrentLng();
});

Handlebars.registerHelper('badgeProgress', function(content) {
	
	var code = "";
	
	if (content.badge_status && content.badge_status.status == "trackable") {
		
		var max = content.badge_status.required;
		var min = content.badge_status.current;
		
		code = '<div class="progress"><ul>';
		
		var diffWidth = 100 / parseInt(max);
			
		for(i = 0; i < parseInt(max); i++) 
		{
			if (parseInt(i) < parseInt(min)) 
			{
				code += '<li style="width:'+diffWidth+'%;" class="fill"></li>';
			}
			else
			{
				code += '<li style="width:'+diffWidth+'%;"></li>';
			}
		}
		
		code += "</ul>";
		
		var plug = "";
		
		if (parseInt(max) > 1) 
		{
			plug = "s";
		}
		
		code += "You have "+min+" of "+max+" check-in"+plug+" towards this badge."

		code += "</div>";
		
	}
	else {
		code = '<div class="progress">We cannot obtain your status for this badge.</div>';
	}
	
	return new Handlebars.SafeString(code);
})

Handlebars.registerHelper('handleRetired', function(content) {
	
	var code;
	
	if (content.badge_active_status == 0) {
		code = '<a href="#!/badgeSingle" onclick="Feed.badge_single('+content.user_badge_id+', '+content.badge_id+');" class="retired">';
	}
	else {
		if (content.has_badge) {
			code = '<a href="#!/badgeSingle" onclick="Feed.badge_single('+content.user_badge_id+', '+content.badge_id+');">';
		}
		else {
			code = '<a href="#!/badgeSingle" class="inactive" onclick="Feed.badge_single('+content.user_badge_id+', '+content.badge_id+');">';
		}
	
	}
	
	return new Handlebars.SafeString(code);
});

Handlebars.registerHelper('wishListHelper', function(context, a) {
	
	var code = "";
	
	if (context.beer.wish_list) {

		code = "<a class='remove_btn' href='javascript:void(0);' rel='action-btn' onclick='Wish.remove("+context.beer.bid+", this);'><span><strong>X</strong></span></a><a class='add_btn' style='display: none; href='javascript:void(0);' rel='action-btn' onclick='Wish.add("+context.beer.bid+", this);'><span><strong>+</strong></span></a>";
	}
	else {
		
		if (a) {
			code = "<a class='add_btn' href='javascript:void(0);' rel='action-btn' onclick='Wish.add("+context.beer.bid+", this, true);'><span><strong>+</strong></span></a><a class='remove_btn' style='display: none;' href='javascript:void(0);' rel='action-btn' onclick='Wish.remove("+context.beer.bid+", this);'><span><strong>X</strong></span></a>";
		}
		else {
			code = "<a class='add_btn' href='javascript:void(0);' rel='action-btn' onclick='Wish.add("+context.beer.bid+", this);'><span><strong>+</strong></span></a><a class='remove_btn' style='display: none;' href='javascript:void(0);' rel='action-btn' onclick='Wish.remove("+context.beer.bid+", this);'><span><strong>X</strong></span></a>";
		}
		
	}
	
	return new Handlebars.SafeString(code);
});

Handlebars.registerHelper('styleHelper', function(content) {
	console.log(content);
});

Handlebars.registerHelper('breweryBeer', function(content) {
	if (content.brewery) {
		return content.brewery.brewery_name;
	}
	else {
		return content.beer.brewery.brewery_name;
	}
});

Handlebars.registerHelper('lastSeen', function(content) {
	
	var a = new Date(Date.parse(content.created_at));
	
	var t = (a.getMonth() + 1) + "-" + a.getDate() + "-"+ a.getFullYear();
	
	var l = "user";
	
	if (parseInt(content.total_users) > 1) {
		l = "users";
	}
	
	var dis = Math.round(content.distance*10)/10;
	
	if (parseInt(dis) == 0) {
		var d = 'Last seen '+t+' by '+content.total_users+" " + l + " (<1 mile away)";
	}
	else {
		var d = 'Last seen '+t+' by '+content.total_users+" " + l + " ("+dis+" miles away)";
	}
	
	return d;
});

Handlebars.registerHelper('menuDirect', function(a) {
	if (a.user.relationship == "self") {
		return "custom";
	}
	else if (a.media.count >= 1) {
		return "custom";
	}
	else {
		return "standard";
	}

});

Handlebars.registerHelper('deleteCheckin', function(content) {

	if (content.user.relationship == "self") {
		code = '<a style="display: none;" href="javascript:void(0);" rel="action-btn" id="deleteCheckin_'+content.checkin_id+'" onclick="Checkin.start('+content.checkin_id+'); return false;" class="grey_btn small">DELETE THIS CHECKIN</a>';

		return new Handlebars.SafeString(code);
	}

})

Handlebars.registerHelper('photoID', function(content) {

	return content.media.items[0].photo_id;

});

Handlebars.registerHelper('beerRatingsHelper', function(content, type) {

	if (type == "Average") {

		var fixed = Math.round( content.beer.rating_score * 10 ) / 10;

		var rating_score = fixed.toFixed(1);
		var code = "";
	}
	else {
		var rating_score = content.beer.auth_rating;
		var code = "<strong>"+type+" Rating:</strong>";
	}

	var num = parseFloat(rating_score);

	var s = num.toString();

	if (type == "Average") {
		var parts = s.split(".");

		var firstNumer = 0;
		var lastNumber = 0;

		if (parseInt(s[1]) >= 5) {
			lastNamber = 0;
			firstNumber = parseInt(s[0]) + 1;
		}
		else {
			lastNumber = 5;
			firstNumber = s[0];
		}

		if (s.length == 1) {
			s += "0";
		}

		var ratingCSS = firstNumber.toString()+""+lastNumber.toString();
	}
	else {
		var s = rating_score.toString();

		if (s.length == 1) {
			s += "0";
		}

		var ratingCSS = s.replace(".", "");
	}

	if (type == "Average") {
		code += '<span class="rating small r'+ratingCSS+'" style="height: 17px;"></span>';
	}
	else {
		code += '<span id="yourRatingBeer" class="rating large r'+ratingCSS+'"></span>';
	}
	
	if (type == "Average") {
		code += ' <span>('+content.beer.rating_score+' avg)</span>';
	}

	return new Handlebars.SafeString(code);

});

Handlebars.registerHelper('handleSocial', function(type) {
	var code;
	
	var u = myStorage.view("socialSettings");
	
	if (u) {
		
		if (type == "twitter") {
			if (u.user.contact.twitter) {
				code = '<li id="twitter_container" class="social_connect_tw connected"><a class="remove_btn" href="javascript:void(0);" onclick="Social.start(\'twitter\');" rel="action-btn"><span><strong>-</strong></span></a><span class="icon"></span>Connected: @'+u.user.contact.twitter+'</li>';
			}
			else {
				code = '<li class="social_connect_tw not_connected" onclick="Social.start_connect(\'twitter\');"><span class="icon"></span>Connect with Twitter</li>';
			}
		}
		else if (type == "facebook") {
			if (u.user.contact.facebook) {
				code = '<li id="facebook_container" class="social_connect_fb connected"><a class="remove_btn" onclick="Social.start(\'facebook\');" rel="action-btn"><span><strong>-</strong></span></a><span class="icon"></span>Connected: '+u.user.contact.facebook+'</li>';
			}
			else {
				code = '<li class="social_connect_fb not_connected" onclick="Social.start_connect(\'facebook\');"><span class="icon"></span>Connect with Facebook</li>';
			}
		}
		else {
			if (u.user.contact.foursquare) {
				code = '<li id="foursquare_container" class="social_connect_4sq connected"><a class="remove_btn" onclick="Social.start(\'foursquare\');" rel="action-btn"><span><strong>-</strong></span></a><span class="icon"></span>Connected: '+u.user.contact.foursquare+'</li>';
			}
			else {
				code = '<li class="social_connect_4sq not_connected" onclick="Social.start_connect(\'foursquare\');"><span class="icon"></span>Connect with Foursquare</li>';
			}
		}
	}
	
	return new Handlebars.SafeString(code);
	
});
	
Handlebars.registerHelper('socialIcon', function(data, fs) {
	var code;
	
	
	if (fs == "foursquare") {
		code = '<li class="foursquare onclick="Social.check_social_confirm(\'foursquare\');"><a href="javascript:void(0);"></a>';
	}
	else {
		code = '<li class="facebook onclick="Social.check_social_confirm(\'foursquare\');"><a href="javascript:void(0);"></a><li class="twitter onclick="Social.check_social_confirm(\'twitter\');"><a href="javascript:void(0);"></a>';
	}
	
	/*var u = myStorage.view("socialSettings");
	
	if (u) {
	 	var auto = myStorage.view("socialSettings");

		if (type == "twitter") {
			if (auto.user.contact.twitter) {
				if (parseInt(auto.user.settings.checkin.checkin_to_twitter) == 1) {
					code = '<li class="'+type+' active" onclick="Social.toggle(\''+toggle+'\', \''+type+'\');"><a href="javascript:void(0);"></a>';
				}
				else {
					code = '<li class="'+type+'" onclick="Social.toggle(\''+toggle+'\', \''+type+'\');"><a href="javascript:void(0);"></a>';
				}
			}
			else {
				code = '<li class="'+type+'" onclick="Social.check(\''+type+'\');"><a href="javascript:void(0);"></a>';
			}
		}
		else if (type == "facebook") {
			if (auto.user.contact.facebook) {
				if (parseInt(auto.user.settings.checkin.checkin_to_facebook) == 1) {
					code = '<li class="'+type+' active" onclick="Social.toggle(\''+toggle+'\', \''+type+'\');"><a href="javascript:void(0);"></a>';
				}
				else {
					code = '<li class="'+type+'" onclick="Social.toggle(\''+toggle+'\', \''+type+'\');"><a href="javascript:void(0);"></a>';
				}
			}
			else {
				code = '<li class="'+type+'" onclick="Social.check(\''+type+'\');"><a href="javascript:void(0);"></a>';
			}
		}
		else if (type == "foursquare") {
			if (auto.user.contact.foursquare) {
				if (parseInt(auto.user.settings.checkin.checkin_to_foursquare) == 1) {
					code = '<li class="'+type+' active" onclick="Social.toggle(\''+toggle+'\', \''+type+'\');"><a href="javascript:void(0);"></a>';
				}
				else {
					code = '<li class="'+type+'" onclick="Social.toggle(\''+toggle+'\', \''+type+'\');"><a href="javascript:void(0);"></a>';
				}
			}
			else {
				code = '<li class="'+type+'" onclick="Social.check(\''+type+'\');"><a href="javascript:void(0);"></a>';
			}
		}
		else {
			code = "";
		}
	}
	else {
		code = '<li class="'+type+' active" onclick="Navigate.check(\''+type+'\')"><a href="javascript:void(0);"></a>';
	}
	*/
	return code;
});

Handlebars.registerHelper('breweryHelper', function(content) {
	
	if (content.brewery) {
		return content.brewery.brewery_name;
	}
	else {
		return content.brewery_name;
	}
	
});


Handlebars.registerHelper('moment', function(content) {
	
	var d = new Date(Date.parse(content));
	
	var new_date = (d.getMonth() + 1) + "-" + d.getDate() + "-" + d.getFullYear();
	
	return new_date;
	
});


Handlebars.registerHelper('friendRequestsToggle', function(content) {

	if (parseInt(content.count) >= 1) {
			var code = '<div id="friends-section" class="top-tab-friends" style="display: none;"><div class="friends"><div class="list"><div class="list_item" id="current-friends-list">';
	}
	else
	{
		var code = '<div id="friends-section" class="top-tab-friends"><div class="friends"><div class="list"><div id="current-friends-list" class="list_item">';
	}
	
	return new Handlebars.SafeString(code);
	
});

Handlebars.registerHelper("relationshipHelper", function(content, off) {
	
	var code = "";

	if (content.user.relationship == "friends") {
		code = '<a href="javascript:void(0);" rel="action-btn" onclick="Friend.request_remove('+content.user.uid+', this, \'list\');" class="remove_btn"><span><strong>X</strong></span></a>';
	}
	else if (content.user.relationship == "none") {
		
		if (off) {
			
		}
		else {
			code = '<a href="javascript:void(0);" rel="action-btn" onclick="Friend.request('+content.user.uid+', this, \'list\');" class="add_btn"><span><strong>+</strong></span></a>';
		}
		
	}
	else {
		code = "";
	}

	return new Handlebars.SafeString(code);
	
});

Handlebars.registerHelper('confirmRatings', function(content) {

	var code = "";

	if (content == 0) {
		for (i = 1; i <= 5; i++)
		{
			code += '<li><a href="javascript:void(0);" rel="action-btn" id="rating_'+i+'" onclick="activateStar('+i+');" class="star">'+i+'</a></li>';
		}
	}
	else {
		for (i = 1; i <= 5; i++)
		{
			if (parseInt(content) >= i)
			{
				code += '<li><a href="javascript:void(0);" rel="action-btn" id="rating_'+i+'" onclick="activateStar('+i+');" class="star on">'+i+'</a></li>';
			}
			else
			{
				code += '<li><a href="javascript:void(0);" rel="action-btn" id="rating_'+i+'" onclick="activateStar('+i+');" class="star">'+i+'</a></li>';
			}
		}
	}
	
	return new Handlebars.SafeString(code);
});

Handlebars.registerHelper('toastLongEach', function(content, options) {
	var ret = "";

	var limit = content.length;

	for(var i=0, j=limit; i<j; i++) {
		
		if (i == (limit - 1))
		{
			ret = ret + options.fn(content[i]);
		}
		else 
		{
			ret = $.trim(ret + options.fn(content[i]) + ",");
		}
	
	}
	
	if (limit == content.length)
	{
		ret = ret + " toasted this.";
	}
	
	return ret;
});


Handlebars.registerHelper('toasteach', function(content, options) {
	var ret = "";

	if(content.length > 5)
	{
		var limit = 5;
	}
	else {
		var limit = content.length;
	}

	for(var i=0, j=limit; i<j; i++) {
		
		if (i == (limit - 1))
		{
			ret = ret + options.fn(content[i]);
		}
		else 
		{
			ret = $.trim(ret + options.fn(content[i]) + ",");
		}
	
	}
	
	if (limit == content.length)
	{
		ret = ret + " toasted this.";
	}
	else 
	{
		var diff = parseInt(content.length) - 5;
		ret = ret + " and " + diff + " others toasted this.";
	}
	

	return ret;
});

Handlebars.registerHelper('morecomments', function(content) {
	
	if (content.comments.count > 3) 
	{
		return new Handlebars.SafeString('<div class="more"><a href="#indCheckin/'+content.checkin_id+'">See All Comments</a></div>');
	}
	
});

Handlebars.registerHelper('each_upto', function(content, max, options) {
	
	var ret = "";

	if(content.length > parseInt(max))
	{
		var limit = 3;
	}
	else {
		var limit = content.length;
	}

	for(var i=0, j=limit; i<j; i++) {
		ret = ret + options.fn(content[i]);
	}

	return ret;
});

Handlebars.registerHelper('commenteach', function(content, options) {
	var ret = "";

	if(content.length > 3)
	{
		var limit = 3;
	}
	else {
		var limit = content.length;
	}

	for(var i=0, j=limit; i<j; i++) {
		ret = ret + options.fn(content[i]);
	}

	return ret;
});