var Cheers = {
	toggle: function(a) {
		$(".stage").hide();

		if (a == 1) {

			if ($("#promo-results").length == 0) {
				Cheers.toggle(2);
			}
			else {
				$(".stage").hide();
				$("#promo-results").show();
				window.scroll(0,0);
			}
		}
		else {

			$(".stage").hide();
			$("#cheers-results").show();
			window.scroll(0,0);
		}

		refreshScroll.go();	
	}

	
}

var Beer = {
	rate: function(a) {
		clearAjax();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			$("#rate-edit-btns").hide();
			$("#rate-loading").show();
			
			var d = $("#rate-beer-form").serialize();
			
			ajaxStatement = $.ajax({
				url: host + "/beer/rate/"+a+"?access_token="+token,
				type: "POST",
				data: d,
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					$("#rate-edit-btns").show();
					$("#rate-loading").hide();
					
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					$("#rate-edit-btns").show();
					$("#rate-loading").hide();
					
					if (data.meta.code == 200)
					{
						if (data.response.result == "success") {
							
							var s = data.response.new_score.toString();

							if (s.length == 1) {
								s += "0";
							}

							var ratingCSS = s.replace(".", "");

							$("#yourRatingBeer").attr("class", "");

							$("#yourRatingBeer").attr("class", "rating large r"+ratingCSS);

							Nav.goBack();
							
							var obj = {};
							obj["message"] = "Your rating has been updated!";
							obj["action_btn"] = "We hoped you liked it!";

							/*var source   = $("#warning-template").html();
							var template = Handlebars.compile(source);*/

							var template = Handlebars.templates['notice-template.tmpl']
							var html = template(obj);

							$("#notice-error").html(html);

							$("#notice_overlay").show();
							
							setTimeout(function(){  //pass it an anonymous function that calls foo
					          $("#notice_overlay").hide();
					        },2500);
						}
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	},
	go_to_rate: function(a) {
		
		clearAjax();
		
		Loading.on();
		
		var token = Validate.token();
		
		if (!token)
		{
			Error.token();
		}
		else
		{
			$.ajax({
				url: host + "/beer/simple/"+a+"?access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Loading.off();
					Nav.goBack();
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					Loading.off();
					
					if (data.meta.code == 200)
					{
						Template.propose_rate("proposeRateArea", data.response);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	}
}


var PushReg = {
	registerDevice: function(pushID) {

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var d = "Android " + $.os.version;

			console.log("UDID: " + udid);

			var args = "push_token="+encodeURIComponent(pushID)+"&push_device="+encodeURIComponent(d)+"&device_udid="+udid;

			console.log(args);

			$("#push_enabled").addClass('loading');

			$.ajax({
				url: host + "/helpers/register?access_token="+token,
				type: "POST",
				data: args,
				dataType: "json",
			    error: function(xhr, ajaxOptions, thrownError)
				{	
					$("#push_enabled").removeClass('loading');
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					console.log("done!");
					$("#push_enabled").removeClass("loading").addClass("active");	
				}
			});
		}

	}
}

var Pending = {
	friends: function() {

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			ajaxStatement = $.ajax({
				url: host + "/user/pending?access_token="+token,
				type: "GET",
				dataType: "json",
				error: function(xhr,ajaxOptions, thrownError)
				{
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						pending = data.response;

						if (pending.count == 0) {
							$("#request_number").html("");
							$("#request_number").addClass("hide");
						}
						else {
							$("#request_number").html("("+pending.count+")");
							$("#request_number").removeClass("hide");
						}

						if (pending.count >= 1) {
							$(".yourarea-header a.friends").prepend('<span class="pending">!</span>');
						}
						else {
							$("a.friends span.pending").remove();
						}

						//Template.pending_friends("friendlistAreaContent", d, pending);
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});
		}
	}

}

var Notifications = {
	gather: function() {

		var token = Validate.token();

		if (!token)
		{
			//Error.token();
		}
		else
		{	
		 	ajaxStatement = $.ajax({
				url: host + "/account/refreshnotifications?access_token="+token,
				type: "POST",
				dataType: "json",
			     error: function(html)
				{

				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						Notifications.set(data.notifications);	
					}
				}
			});
		}		
	},
	set: function(data) {
		$("#notifications-area li.toasts").html("<span>"+data.unread_count.toasts+"</span>");
		$("#notifications-area li.news").html("<span>"+data.unread_count.news+"</span>");
		$("#notifications-area li.comments").html("<span>"+data.unread_count.comments+"</span>");

		if (data.unread_count.comments != 0 && data.unread_count.news != 0 || data.unread_count.toasts != 0) {
			$("#notify-popup").removeClass("hide");
			setTimeout('$("#notify-popup").addClass("hide");', 3000);
		}
	}
}


var Checkin = {
	start: function(a) {

		$("#notice-error").html('');

		var obj = {};
		obj["message"] = "Are you sure you want remove this checkin?";
		obj["action_btn"] = "<a href='javascript:void(0);' onclick='Checkin.delete_checkin("+a+");' rel='action-btn' class='yellow_btn'>Confirm</a>";
		obj["badges"] = "yes";

		/*var source   = $("#warning-template").html();
		var template = Handlebars.compile(source);*/

		var template = Handlebars.templates['warning-template.tmpl'];
		var html = template(obj);

		$("#notice-error").html(html);

		Util.openPop();
	},
	delete_checkin: function(a) {

		Util.closePop();

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			Nav.goBack();
		
			$("."+a).hide();

		 	$.ajax({
				url: host + "/checkin/delete/"+a+"?access_token="+token,
				type: "POST",
				dataType: "json",
			     error: function(html)
				{
					$("."+a).show();
					Error.ajax_error(xhr, ajaxOptions, thrownError);
				},
				success: function(data)
				{
					if (data.meta.code == 200)
					{
						$("."+a).remove();
						init.Recent();
					}
					else
					{
						Error.handle(data.meta.error_detail, data.meta.error_type, data.meta.code)
					}
				}
			});

		}
	}
}

var Sort = {
	go: function(current_tab, parent_tab, a, b) {

		$("."+parent_tab+ " li a").removeClass("active");
		$(current_tab).addClass('active');

		$($('.'+a).get().reverse()).each(function(outer) {

	 		var sorting = this;

			var parent_sort = $(sorting).attr(b);

	        $($('.'+a).get().reverse()).each(function(inner) {

				var sort_option = $(this).attr(b);

				if (b == "data-sort-style" || b == "data-sort-category")
				{
					if(sort_option.localeCompare(parent_sort) > 0) {
						 this.parentNode.insertBefore(sorting.parentNode.removeChild(sorting), this);
					}
				}
				else if (b == "data-sort-distance") {
					if(parseFloat(sort_option) > parseFloat(parent_sort)) {
						 this.parentNode.insertBefore(sorting.parentNode.removeChild(sorting), this);
					}
				}
				else
				{
					if(parseInt(sort_option) < parseInt(parent_sort)) {
						 this.parentNode.insertBefore(sorting.parentNode.removeChild(sorting), this);
					}
				}
	        });
	    });
	}

}

function clearAjax()
{
	if (ajaxStatement)
	{
		ajaxStatement.abort();
	}

}

function checkHash(newHash) {

	var newHash = newHash.replace("#", "");

	newHashArray = newHash.split("/");

	if (newHashArray.length != 0) {
		newHash = newHashArray[0];
	}

	console.log("Check hash: " + newHash);

	$(".header-buttons").removeClass("show");

	switch (newHash) {
		case "discoverArea":
			//window.scroll(0,0);
			$("header").removeClass("hide");
			$("#tab_bar").removeClass("hide");
			break;
		case "discoverBeers":
			Sort.go($(".discover_beers_tab li a:first"), 'discover_bars_tab', 'discover_bars', 'data-sort-popular');
			$(".discover-beers-header").addClass("show");
			$("header").removeClass("hide");
			$("#tab_bar").removeClass("hide");
			//window.scroll(0,0);
			break;
		case "distinctArea":
			$("header").removeClass("hide");
			$(".distinct-header").addClass("show");
			break;
		case "statsArea":
			$("header").removeClass("hide");
			$(".statsarea-header").addClass("show");
			break;
		case "discoverFriends":
			$(".location_bar").show();
			$(".discover-friends-header").addClass("show");
			$("header").removeClass("hide");
			break;
		case "discoverBreweries":
			$(".location_bar").show();
			$(".discover-breweries-header").addClass("show");
			$("header").removeClass("hide");
			break;
		case "discoverBars":
			Sort.go($(".discover_bars_tab li a:first"), 'discover_beers_tab', 'discover_beers', 'data-sort-popular');
			$(".discover-bars-header").addClass("show");
			$("header").removeClass("hide");
			//window.scroll(0,0);
			break;
		case "friendlistArea":
			$("header div.friends-list-header").addClass("show");
			$("header").removeClass("hide");
			//window.scroll(0,0);
			break;
		case "locationArea":
			$(".location-header").addClass("show");
			$("header").removeClass("hide");
			//window.scroll(0,0);
			break;
		case "cheersArea":
			$(".cheers-header").addClass("show");
			$("header").removeClass("hide");
			//window.scroll(0,0);
			break;
		case "startArea":
			$("header").addClass("hide");
			//window.scroll(0,0);
			break;
		case "friendsArea":
			$("header").removeClass("hide");
			
			$("header div.activity-header").addClass("show");

			if ($(".activity-tab:visible").attr("id") != "aroundAreaContent") {
				$(".location_bar").hide();
			}
			else {
				$(".location_bar").show();
			}

			break;
		case "publicArea":
			$("header").removeClass("hide");
			$("#friendsArea ul li a").removeClass("active");
			$(".activity-header").addClass("show");
			break;
		case "aroundArea":
			$("header").removeClass("hide");
			$("#friendsArea ul li a").removeClass("active");
			$(".activity-header").addClass("show");
			break;
		case "yourArea":
		   	$("header").removeClass("hide");
			$("header div.yourarea-header").addClass("show");
			//window.scroll(0,0);
			break;
		case "indCheckin":
			$("header").removeClass("hide");
			$("header div.checkinind-header").addClass("show");
			//window.scroll(0,0);
			break;
		case "beerArea":
			$("header").removeClass("hide");
			$(".beer-header").addClass("show");
			break;
		case "breweryArea":
			$("header").removeClass("hide");
			$(".generic-back").addClass("show");
			break;
		case "profileArea":
			$("header").removeClass("hide");
			$(".generic-back").addClass("show");
			//window.scroll(0,0);
			break;
		case "notificationsArea":
			$("header").removeClass("hide");
			Toggle.tabs($("#note-start"), 'note-panel', 'note-areas', 'notifiication-tab');
			$(".notifications-header").addClass("show");
			//window.scroll(0,0);
			break;
		case "drinkArea":
			$("header").removeClass("hide");
			$(".beerSearchTermSearch").val('');
			Toggle.tabs($("#drink-up-first"), 'drink-up-tab', 'drinkAreaContent', 'search-tab-results');
			$(".drink-up-header").addClass("show");
			break;
		case "profileSettingsArea":
			$("header").removeClass("hide");
			Toggle.tabs($('#profile-first'), 'settings-tab', 'profile-settings', 'profile-settings-tab');
			$(".settings-top-header").addClass("show");
			break;
		case "registerArea":
			$("header").removeClass("hide");
			List.user_country()
			$(".generic-back").addClass("show");
			break;
		case "userBadgeArea":
			$(".generic-back").addClass("show");
			break;
		case "confirmArea":
			$(".confirm-header").addClass("show");
			break;
		default:
			$("header").removeClass("hide");
			$(".generic-back").addClass("show");
			//window.scroll(0,0);
			break;
	}
}

var Track = {
	page: function() {
		window.plugins.analytics.trackPageView(window.location.hash, function(){  }, function(){ console.log("TRACKING FAIL"); });
	},
	start_tracking: function(a) {
		window.plugins.analytics.startTrack(a, function(){ }, function(){console.log("TRACKING OFF")});
	}
}

var Timezone = {
	get: function(){

		var myDate = new Date();

		var t = parseInt(myDate.format('Z'));

		var timezone = myDate.format('T');

		if (parseInt(t) < 0)
		{
			var new_t = Math.abs(t);
			var hours = parseInt(new_t) / 3600;
			var gmt_string = "-"+hours;
		}
		else
		{
			var hours = parseInt(t) / 3600;
			var gmt_string = hours;
		}

		var timezoneObj = {};

		timezoneObj["offset"] = gmt_string;
		timezoneObj["zone"] = timezone;

		return timezoneObj;

	}
}

var Garbage = {
	clean: function(index) {
		localStorage.setItem(index, "");
	},
	erase: function() {
		Menu.off();
		$(".tab_btn").removeClass("active");
		Register.clear_form_login();
		Register.clean_form();
		localStorage.clear();
		$("#see_more_friends").remove();
		$("#friendsAreaContent_content").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
		$("#drinkAreaContent").html('<div id="drinkAreaContentArea" class="list drink_up"><div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div></div>');
		List.user_country();
		$("#login-form input").val('');
		$("#login-spinner").hide();
		$("#login-btn").show();
		myHistory = [];
	},
	freshStart: function() {
		Garbage.clean("friendFeed");
		$("#see_more_friends").remove();
		$("#friendsAreaContent_content").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
		$("#drinkAreaContent").html('<div id="drinkAreaContentArea" class="list drink_up"><div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div></div>');
		$("#login-form input").val('');
		$("#login-spinner").hide();
		$("#login-btn").show();
		init.setupUser();
		init.setUpGeo();
		myHistory = [];
	},
	remove_extra: function(top, index) {
		var l = $("#"+top+" div.activity_stream").length;

		if (parseInt(l) > 25)
		{
			var diff = parseInt(l) - 25;

			for(i = 0; i < parseInt(diff); i++)
			{
				$("#"+top+" div.activity_stream").last().remove();
			}
		}
		else
		{
			var diff = 25 - parseInt(l);

			for(i = 0; i < parseInt(diff); i++)
			{
				$("#"+top+" div.activity_stream").last().remove();
			}
		}
	}
};

var myStorage = {
	save: function(index, data) {
		var sData = JSON.stringify(data);
		localStorage.setItem(index, sData);
	},
	token: function(access_token){
		localStorage.setItem("access_token", access_token);
	},
	view: function(d) {
		if (localStorage.getItem(d)) {
			var sData = localStorage.getItem(d);
			return JSON.parse(sData);
		}
		else
		{
			return false;
		}
	}
};

var Validate = {
	web: function(){
		if (navigator.onLine)
		{
			return true;
		}
		else
		{
			Error.offline();
		}
	},
	token: function(){

		if (localStorage.getItem("access_token"))
		{
			return localStorage.getItem("access_token");
		}
		else
		{
			return false;
		}

	}
}

var Error = {
	offline: function() {
		alert("offline");
	},
	ajax_error: function(xhr, ajaxOptions, errorThrown) {

		Spinner.off();

		var responseText = xhr.responseText;

		var status = xhr.status;

		if (xhr.status == 0 && ajaxOptions == "timeout") {

			$("#notice-error").html('');

			var object = {};

			object["message"] = "Your request has appeared to timeout. Please try your request again.";

			/*var source   = $("#error-template").html();
			var template = Handlebars.compile(source);*/

			var template = Handlebars.templates['error-template.tmpl'];
			var html = template(object);

			$("#notice-error").html(html);

			Util.openPop();

			Util.closePopTimeout(3000);

		}
		else if ((xhr.status == 0 && ajaxOptions != "error") || !window.navigator.mozConnection) {

			$("#notice-error").html('');

			var object = {};

			object["message"] = "You don't appear to have network connection. Please check your connection and try again.";

			/*var source   = $("#error-template").html();
			var template = Handlebars.compile(source);*/

			var template = Handlebars.templates['error-template.tmpl'];
			var html = template(object);

			$("body").css("overflow","hidden");

			$("#notice-error").html(html);

			Util.openPop();

			Util.closePopTimeout(3000);
          
        } else if (xhr.status == 404 || xhr.status === 502 || xhr.status === 500 || xhr.status === 402) {
            
            if (responseText == "") {

            	$("#notice-error").html('');

				var object = {};

				object["message"] = "There has been an unknown error with your request. Please try again.";

				/*var source   = $("#error-template").html();
				var template = Handlebars.compile(source);*/

				var template = Handlebars.templates['error-template.tmpl'];
				var html = template(object);

				$("#notice-error").html(html);

				Util.openPop();

				Util.closePopTimeout(3000);

            }
            else {
        		var json = JSON.parse(responseText);
				var object = {};

				if (json.meta) {
					object["message"] = json.meta.error_detail;
				}
				else {
					object["message"] = json.error;
				}

				/*var source   = $("#error-template").html();
				var template = Handlebars.compile(source);*/

				var template = Handlebars.templates['error-template.tmpl'];
				var html = template(object);

				$("#notice-error").html(html);

				Util.openPop();

				Util.closePopTimeout(3000);
            }

        } else if (ajaxOptions === 'timeout' || ajaxOptions === 'parsererror') {
            
        	$("#notice-error").html('');

			var object = {};

			object["message"] = "Your connection request has appeared to timeout. Please check your connnection and try again.";

			/*var source   = $("#error-template").html();
			var template = Handlebars.compile(source);*/

			var template = Handlebars.templates['error-template.tmpl'];
			var html = template(object);

			$("#notice-error").html(html);
			
			Util.openPop();

			Util.closePopTimeout(3000);


        } else if (xhr.status === 0 && navigator.onLine) {
            
        	console.log("aborted");

        } 
        else {
           
        	$("#notice-error").html('');

			var object = {};

			object["message"] = "There has been an unknown error with your request. Please try again.";

			/*var source   = $("#error-template").html();
			var template = Handlebars.compile(source);*/

			var template = Handlebars.templates['error-template.tmpl'];
			var html = template(object);

			$("#notice-error").html(html);

			Util.openPop();

			Util.closePopTimeout(3000);

        }

		/*navigator.notificationEx.activityStop();

		console.log(xhr + " " + ajaxOptions + " " + errorThrown);

		Spinner.off();

		var responseText = xhr.responseText;

		if (phonegap) {
			networkState = navigator.network.connection.type;

			states[Connection.UNKNOWN]  = 'Unknown connection';
		    states[Connection.ETHERNET] = 'Ethernet connection';
		    states[Connection.WIFI]     = 'WiFi connection';
		    states[Connection.CELL_2G]  = 'Cell 2G connection';
		    states[Connection.CELL_3G]  = 'Cell 3G connection';
		    states[Connection.CELL_4G]  = 'Cell 4G connection';
		    states[Connection.NONE]     = 'No network connection';

			if (states[networkState] == "No network connection")
			{
				$("#notice-error").html('');

				var object = {};

				object["message"] = "You don't appear to have network connection. Please check your connection and try again.";
				var template = Handlebars.templates['error-template.tmpl'];
				var html = template(object);

				$("#notice-error").html(html);

				$("#notice_overlay").show();

				setTimeout('$("#notice_overlay").hide();', 3000);
			}
			else
			{
				if (responseText == "") {

					if (ajaxOptions == "timeout" || ajaxOptions == "parsererror") {
						$("#notice-error").html('');

						var object = {};

						object["message"] = "Something appeared to go very wrong. Please try again or contact support.";
						var template = Handlebars.templates['error-template.tmpl'];
						var html = template(object);

						$("#notice-error").html(html);

						$("#notice_overlay").show();

						setTimeout('$("#notice_overlay").hide();', 3000);
					}
				}
				else {
					var json = JSON.parse(responseText);

					console.log(json);

					var object = {};

					if (json.meta) {
						object["message"] = json.meta.error_detail;
					}
					else {
						object["message"] = json.error;
					}


					var template = Handlebars.templates['error-template.tmpl'];
					var html = template(object);

					$("#notice-error").html(html);

					$("#notice_overlay").show();

					setTimeout('$("#notice_overlay").hide();', 3000);
				}
			}
		}
		else {
			if (responseText == "") {

				if (ajaxOptions == "timeout" || ajaxOptions == "parsererror") {

					$("#notice-error").html('');

					var object = {};

					object["message"] = "Something appeared to go very wrong. Please try again.";

				
					var template = Handlebars.templates['error-template.tmpl'];
					var html = template(object);

					$("#notice-error").html(html);

					$("#notice_overlay").show();

					setTimeout('$("#notice_overlay").hide();', 3000);
				}
			}
			else {
				var json = JSON.parse(responseText);

				console.log(json);

				var object = {};

				if (json.meta) {
					object["message"] = json.meta.error_detail;
				}
				else {
					object["message"] = json.error;
				}


				var template = Handlebars.templates['error-template.tmpl'];
				var html = template(object);

				$("#notice-error").html(html);

				$("#notice_overlay").show();

				setTimeout('$("#notice_overlay").hide();', 3000);
			}
		}*/


	},
	handle: function(message, type, httpcode) {

		Spinner.off();

		$("#notice-error").html('');

		var object = {};

		object["message"] = message;

		/*var source   = $("#error-template").html();
		var template = Handlebars.compile(source);*/

		var template = Handlebars.templates['error-template.tmpl'];
		var html = template(object);

		$("#notice-error").html(html);

		Util.openPop();

		Util.closePopTimeout(3000);
	},
	token: function() {
		Garbage.erase();
		Page.show("#!/loginArea");
		Error.handle("Please login again.", "", "");
	},
	show: function(message) {
		Error.handle(message, "", "");
		//alert(message);

	}

}

var pBar = {
	increase: function() {

		var progress = $(".progress").attr('data-progress');

	    if (parseInt(progress) <= 100)
	    {
			var randomnumber=Math.floor(Math.random()*15)

	        var newProgress = parseInt(progress) + parseInt(randomnumber);

			if (parseInt(newProgress) >= 98)
			{
				newProgress = 98;
				$(".progress_bar").hide();
				$("#progress_status").html("Please Wait...");
			}

			$(".progress").attr('data-progress', newProgress);

			$(".progress_bar_inner").html(newProgress+"%");

	        $(".progress").attr("style", "width: "+newProgress+"%");
	    }
	    else
	    {
			$(".progress").attr('data-progress', '0');
	    }

	},
	halt: function() {

	}
}

var Stats = {
	toggleChange: function() {

		var obj = {};
		obj["message"] = "Please select the range of the states from the items below:";

		/*var source   = $("#warning-template").html();
		var template = Handlebars.compile(source);*/

		var template = Handlebars.templates['stats-select-template.tmpl']
		var html = template(obj);

		$("#notice-error").html(html);

		Util.openPop();
	},
	charts: function(a) {

		var string = "['','Check-ins'],";
		console.log(a.checkins_history);

		chartData = [];

		

		
	},
	build: function(a) {

		var low = 0;
		var high = 0;
		var med = 0;

		var xD = "";
		var yD = "";

		$(a.checkins_history).each(function(key, value) {
			$.each(value, function(key, value){

				if (parseInt(value) >= parseInt(high)) {
					high = value;
				}

				xD = xD + value + ",";
 			});
		});

		med = Math.round(parseInt(med) / 2);

		xD = xD.substring(0, (xD.length -1));

		higher = parseInt(high) + 2;


		var googleChart = "http://chart.googleapis.com/chart?chxr=0,0,"+higher+"&chxt=y&chs=600x200&cht=lc&chco=1a5a95&chds=0,"+higher+"&chd=t:"+xD+"&chg=14.3,-1,1,1&chls=2,4,0&chm=B,C5D4B5BB,0,0,0"

		//console.log(googleChart);
		//var imageURL = "<img src='"+googleChart+"' height='175' width='320' />";
		//$("#lineGraphArea").css("background", "url("+googleChart+") no-repeat center center;"); 
		//$("#lineGraphArea").css("background-color", "#FFF");

		$('<img src="'+googleChart+'" height="100" width="300" />').insertAfter('#lineGraphArea p');

	}
}

var Page = {
	show: function(a,b){
	},
	change: function(page, type, reverse) {

		//refreshScroll.go();

		$("a").focus();

		$("#emptylink-beer").focus();

		$("#beerSearchTermSearch").blur();

		var new_page = page.replace("!/", "");

		if (new_page != "") {

			pageState = { state: { page: page, transition: type, reverse: reverse }, title: "", url: page };

			console.log(pageState.state.page + " " + pageState.url);

			window.history.pushState(pageState.state, pageState.title, pageState.url);

			Page.transitions(page, type, reverse);
		}
	},
	transitions: function(page, type, reverse) {

		Tabs.magic(page);

		page = page.replace("!/", "");

		console.log("THE PAGE IS: " + page);

		checkHash(page);

		page_fragments = page.split("/");

		page = page_fragments[0];

		var toPage = $(page);

		var fromPage = $("#container div.active_page");

		console.log(fromPage);

		var m = false;

		var fromID = $(fromPage).attr("id");

		if (fromID || type != "push") {

			console.log("Offset: " + window.pageYOffset);

			if (type == "push") {

				myHistory.push(fromID);

				console.log(myHistory);	

				var prevPage = "#"+fromPage.attr("id");

				scrollPosition[prevPage] = window.pageYOffset;
			}
			else if (type == "back") {

				var prevPage = "#"+fromPage.attr("id");

				scrollPosition[prevPage] = window.pageYOffset;

			}
			else {
				myHistory = [];
				console.log("history empty");
			}


			if (page == "#startArea" || page == "#locationArea" || page == "#confirmArea" || page == "#searchlocationArea" || page == "#loginArea" || page == "#registerArea" || page == "#resetPasswordArea" || page == "#photoEditArea") {
				$("#tab_bar").removeClass('show').addClass("hide");
				m = true;
			}
			else {
				$("#tab_bar").removeClass('hide').addClass("show");
				
			}

			var prevPage = "#" + fromPage.attr("id");

			console.log("PREV PAGE: " + prevPage);

			if (!reverse) {	

				if (page == "#statsArea") {
					$("#statsAreaContent").html('<div class="loading_inner"><img src="assets/images/spinner.gif" width="24" height="24" /><br /><br /><p>Loading...</p></div>');
				}

				fromPage.removeClass("show").removeClass("active_page");
				toPage.addClass("show").addClass("active_page");

				switch (page) {
					case "#yourArea":
						Feed.your_profile();
						break;
					case "#profileArea":
						Feed.profile(page_fragments[1], page_fragments[2], page_fragments[3]);
						break;
					case "#friendsArea":
						if (page_fragments[1]) {
						}
						else {
							Feed.friends(false, true);
						}
						break;
					case "#venueArea":
						Feed.venue(page_fragments[1], page_fragments[2], page_fragments[3]);
						break;
					case "#indCheckin":
						Feed.checkin(page_fragments[1], page_fragments[2], page_fragments[3]);
						break;
					case "#statsArea":
						
						if (page_fragments[1]) {
							Feed.stats(page_fragments[1]);
						}
						else {

							var dis = myStorage.view("statsRangeSettings");
							var rad = 30;

							if (!dis) {
								Feed.stats(30);
							}
							else {
								Feed.stats(dis);
							}
						}
 
						break;
					case "#statsAreaNewBeers":
						Feed.stats_new_beers();
						break;
					case "#statsAreaBeerStyle":
						Feed.stats_beer_styles(page_fragments[1]);
						break;
					case "#statsAreaNewVenues":
						Feed.stats_new_venues();
						break;
					case "#locationArea":
						Geolocate.venues(page_fragments[1]);
						break;
					case "#findBeer":
						$(".location_bar").show();
						Geolocate.find_beer(page_fragments[1]);
						break;
					case "#wishListArea":
						Feed.wishlist(page_fragments[1], page_fragments[2], page_fragments[3]);
						break;
					case "#userFriendList":
						Feed.user_friends(page_fragments[1], page_fragments[2]);
						break;
					case "#beerArea":
						Feed.beer(page_fragments[1], page_fragments[2], page_fragments[3]);
						break;
					case "#addCellarArea":
						var bid = $("#beer_template").attr("data-beer");
						Cellar.go(bid);
						break;
					case "#proposeEditArea":
						var bid = $("#beer_template").attr("data-beer");
						propose.go_to_edit(bid);
						break;
					case "#proposeRateArea":
						var bid = $("#beer_template").attr("data-beer");
						Beer.go_to_rate(bid);
						break;
					case "#proposeBarCodeArea":
						var bid = $("#beer_template").attr("data-beer");
						$("#barcode_bid").val(bid);
						break;
					case "#drinkArea":
						//Geolocate.saveForCheckin();
						break;
					case "#breweryArea":
						Feed.brewery(page_fragments[1], page_fragments[2]);
						break;
					case "#discoverArea":
						//Geolocate.store();
						break;
					case "#photoGallery":
						Feed.media(page_fragments[1], page_fragments[2]);
						break;
					case "#photoSingle":
						Feed.media_single(page_fragments[1], page_fragments[2]);
						break;
					case "#friendlistArea":
						Feed.friend_requests();
						break;
					case "#notificationsArea":
						Feed.notifications();
						break;
					case "#confirmArea":
						if (page_fragments[2] && page_fragments[2] == "loc") {
							Feed.resubmit(page_fragments[1], page_fragments[2], page_fragments[3]);
						}
						else {
							Feed.confirm(page_fragments[1], page_fragments[2], page_fragments[3]);
						}
						break;
					default:
						break;

				}

				if (page == "#startArea" || page == "#locationArea" || page == "#confirmArea" || page == "#searchlocationArea" || page == "#loginArea" || page == "#registerArea" || page == "#resetPasswordArea" || page == "#photoEditArea") {
					Page.scrollMe(page, true, true);

				}
				else {
					Page.scrollMe(page, true, false);
				}


			}
			else {

				console.log("not reverse");

				fromPage.removeClass("show").removeClass("active_page");
				toPage.addClass("show").addClass("active_page");

				if (page == "#beerArea" || page == "#venueArea" || page == "#friendsArea" || page == "#breweryArea" || page == "#profileArea" || page == "#yourArea" || page == "#listCheckinsArea" || page == "#wishlistArea" || page == "#statsArea" || page == "#discoverBars") {
					Page.scrollMe(page, false);
				}
				else {
					Page.scrollMe(page, true);
				}
			}
		}
	},
	endtrans: function(toPage, fromPage, type, reverse) {

		fromPage.removeClass("show " + type + " out " + reverse);
		fromPage.addClass("hide");
		toPage.removeClass(type + " in " + reverse);
	},
	scrollMe: function(page, a,b) {

		if (page === "#registerArea" || page === "#resetPasswordArea" || page === "#loginArea" || page == "#startArea") {
			$("#container").css("margin", "86px auto 1px");
		}
		else {
			$("#container").css("margin", "42px auto 42px");
		}

		console.log(scrollPosition);

		if (a) {
			window.scroll(0,0);
			//myScroll.scrollTo(0,0,0);
			

		}
		else {

			if (scrollPosition[page]) {
				console.log("scrolling to " + scrollPosition[page]);
				window.scroll(0,scrollPosition[page]);
			}
			else {
				console.log("Not set: " + page);
				window.scroll(0,0);
			}
			
		}
	

		
	}


}

var Location = {
	remove_location: function(a) {
		$(a).parent().parent().remove();
		$(".addLocationBtn").show();
		$("#foursquare_id").val('');
		$("#4sq").val("off");
		$("#foursquare_social").hide();
	}

}


var Nav = {
	removeA: function(arr) {
	    var what, a = arguments, L = a.length, ax;
	    while (L > 1 && arr.length) {
	        what = a[--L];
	        while ((ax= arr.indexOf(what)) !== -1) {
	            arr.splice(ax, 1);
	        }
	    }
	    return arr;
	},
	goBack:function() {
		
		console.log("back button fired");
		
		reverse = true;

		console.log(reverse);

		clearAjax();
		
		/*window.history.back();

		console.log("HASH: " + window.location.hash);

		var hash = window.location.hash;*/

		console.log("LENGTH: " + myHistory.length);

		if (myHistory.length == 0) {

			Page.exit();
		}
		else {
			console.log("BEFORE POP: " + history);

			var fromPage = $("#container div.active_page");

			var fromID = $(fromPage).attr("id");

			console.log("fromID: " + fromID);

			if (fromID == "cheersArea") {

				console.log("BEFORE: " + myHistory);

				Nav.removeA(myHistory, 'confirmArea');
				Nav.removeA(myHistory, 'locationArea');
				Nav.removeA(myHistory, 'searchlocationArea');
				Nav.removeA(myHistory, 'cheersArea');

				console.log("AFTER: " + myHistory);

				hash = myHistory.pop();

				Page.change("#!/"+hash, "back", true);

				checkHash("#"+hash);

			}
			else {
				hash = myHistory.pop();

				Page.change("#!/"+hash, "back", true);

				checkHash("#"+hash);
			}
		}
	},
	threeBar: function(a, b, c, d) {
		$(a).parent().parent().find("li a").removeClass("active");

		$(a).addClass("active");

		$("."+c).hide();
		$("#"+d).show();

		if (b == "friends") {
			$("#nearby_bar").hide();
			Feed.friends(null, null);
		}
		else if (b == "pub")
		{
			$("#nearby_bar").hide();
			Feed.pub();
		}
		else {
			$("#nearby_bar").show();
			Geolocate.around_pub();
		}
	}
}

var Spinner = {
	off: function() {
		$('#refresh').show();
		$(".apploader").hide();
	},
	on: function() {
		$(".apploader").show();
		$("#refresh").hide();
	}
}

var Menu = {
	off: function() {
		$("#android_menu").addClass("hide");
	},
	on: function() {
		$("#android_menu").addClass("on");
	}
}

var actionSheet = {
	create: function(items) {

		var template = Handlebars.templates['default-popup-template.tmpl'];
		var html = template(items);

		$("#notice-error").html(html);

		Util.openPop();
	}
}


var MenuToggle = {
	beer: function() {

		var youC = $("#beer_template div.profile_stats a.youCounter p").html();

		if (parseInt(youC) >= 1) {

			var blob = {
				message: "What would you like to do?",
				items: [
					{
						title: "Propose an Edit",
						button: false,
						href: "#!/proposeEditArea"
					},
					{
						title: "Flag Duplicate",
						button: true,
						onclick: "propose.flag();"
					},
					{
						title: "Change Rating",
						button: false,
						href: "#!/proposeRateArea"
					},
					{
						title: "Refresh",
						button: true,
						onclick: "Refresh.pull()"
					}
				]
			}

			actionSheet.create(blob);

		}
		else {

			var blob = {
				message: "What would you like to do?",
				items: [
					{
						title: "Propose an Edit",
						button: false,
						href: "#!/proposeEditArea"
					},
					{
						title: "Flag Duplicate",
						button: true,
						onclick: "propose.flag();"
					},
					{
						title: "Refresh",
						button: true,
						onclick: "Refresh.pull();"
					}
				]
			}

			actionSheet.create(blob);

		}

		
	},
	stats: function() {

		var blob = {
			message: "Please select the range of the stats:",
			items: [
				{
					title: "Last 7 Days",
					button: false,
					href: "#!/statsArea/7"
				},
				{
					title: "Last 30 Days",
					button: false,
					href: "#!/statsArea/30"
				},
				{
					title: "Last 60 Days",
					button: false,
					href: "#!/statsArea/60"
				},
				{
					title: "Last 90 Days",
					button: false,
					href: "#!/statsArea/90"
				}
			]
		}

		actionSheet.create(blob);
	},
	profile_picture_callback: function(buttonIndex) {

		Util.closePop();

		

		var pictureSource = navigator.camera.PictureSourceType;
        var destinationType = navigator.camera.DestinationType;
		var encoding = navigator.camera.EncodingType;
        
		if (buttonIndex == 0) {
			$(".change_avatar").addClass("loading");
			navigator.camera.getPicture(Photo.getSuccessProfile, Photo.getFail, {quality: 45, destinationType: destinationType.FILE_URI, sourceType: pictureSource.PHOTOLIBRARY, correctOrientation: true, encodingType: encoding.JPEG, targetWidth: 910, targetHeight: 910, allowEdit: true});
		}
		else if (buttonIndex == 1) {
			$(".change_avatar").addClass("loading");
			navigator.camera.getPicture(Photo.getSuccessProfile, Photo.getFail, {quality: 45, destinationType: destinationType.FILE_URI, sourceType: pictureSource.CAMERA, correctOrientation: true, encodingType: encoding.JPEG, saveToPhotoAlbum: true, targetWidth: 910, targetHeight: 910, allowEdit: true});

		}
	 	else {

		}

	},
	profile_picture: function() {

		if ($(".change_avatar").hasClass("loading")) {

		}
		else {
			var blob = {
			message: "Where would you like to take the picture from?",
			items: [
					{
						title: "Photo Library",
						button: true,
						onclick: "MenuToggle.profile_picture_callback(1);"
					},
					{
						title: "Camera",
						button: true,
						onclick: "MenuToggle.profile_picture_callback(1);"
					},
				]
			}

			actionSheet.create(blob);
		}
	},
	share: function() {

		var checkin_id = $("#check_view").attr('data-checkin');

		if ($("#deleteCheckin_"+checkin_id).length != 0) {

			var blob = {
				message: "Where would you like to share?",
				items: [
					{
						title: "Facebook",
						button: true,
						onclick: "Share.checkin('facebook', "+checkin_id+");"
					},
					{
						title: "Twitter",
						button: true,
						onclick: "Share.checkin('twitter', "+checkin_id+");"
					},
				]
			}

			actionSheet.create(blob);
		}
	},
	find_friends_callback: function() {

		Util.closePop();

		Page.change("#!/friendSearchArea", "push");

	},
	find_friends: function() {

		var blob = {
			message: "What would you like to do?",
			items: [
				{
					title: "Find Friends",
					button: true,
					onclick: "MenuToggle.find_friends_callback();"
				},
				{
					title: "Refresh",
					button: true,
					onclick: "Refresh.pull();"
				}
				
			]
		}

		actionSheet.create(blob);
	},
	checkin: function() {

		var checkin_id = $("#check_view").attr('data-checkin');

		if ($("#deleteCheckin_"+checkin_id).length != 0) {

			$("#checkin-settings").show();

			if ($("#check_view div.photo_current").length != 0) {

				var photo_id = $("#check_view div.photo_current").attr("data-photo");

				var blob = {
					message: "What would you like to do?",
					items: [
						{
							title: "Share on Facebook",
							button: true,
							onclick: "Share.checkin('facebook', "+checkin_id+");"
						},
						{
							title: "Share on Twitter",
							button: true,
							onclick: "Share.checkin('twitter', "+checkin_id+");"
						},
						{
							title: "Refresh",
							button: true,
							onclick: "Refresh.pull();"
						},
						{
							title: "Delete this Checkin",
							button: true,
							btnClass: "red_btn",
							onclick: "Checkin.start("+checkin_id+");"
						},
						{
							title: "Delete this Photo",
							button: true,
							btnClass: "red_btn",
							onclick: "Photo.start_delete_photo("+photo_id+");"
						}
						
					]
				}

				actionSheet.create(blob);
			}
 			else {

 				var blob = {
					message: "What would you like to do?",
					items: [
						{
							title: "Share on Facebook",
							button: true,
							onclick: "Share.checkin('facebook', "+checkin_id+");"
						},
						{
							title: "Share on Twitter",
							button: true,
							onclick: "Share.checkin('twitter', "+checkin_id+");"
						},
						{
							title: "Refresh",
							button: true,
							onclick: "Refresh.pull();"
						},
						{
							title: "Delete this Checkin",
							button: true,
							btnClass: "red_btn",
							onclick: "Checkin.start("+checkin_id+");"
						}
						
					]
				}

				actionSheet.create(blob);
 			}
		}
		else {
			if ($("#check_view div.photo_current").length != 0) {
				MenuToggle.photo_flag();
			}
			else {
				MenuToggle.simple_refresh();
			}
		}
	},
	simple_refresh: function() {

		var blob = {
			message: "What would you like to do?",
			items: [
				{
					title: "Refresh",
					button: true,
					onclick: "Refresh.pull();"
				}

			]
		}

		actionSheet.create(blob);

	},
	photo_flag: function() {

		var photo_id = $("#check_view div.photo_current").attr("data-photo");

		var blob = {
			message: "What's wrong with photo?",
			items: [
				{
					title: "Offensive Material",
					button: true,
					onclick: "Photo.flag("+photo_id+", 1);"
				},
				{
					title: "Sexual Content",
					button: true,
					onclick: "Photo.flag("+photo_id+", 2);"
				},
				{
					title: "Blatant Spam",
					button: true,
					onclick: "Photo.flag("+photo_id+", 3);"
				},
				{
					title: "Refresh",
					button: true,
					onclick: "Refresh.pull();"
				},

			]
		}

		actionSheet.create(blob);

	},
	bars_callback: function(buttonIndex) {

		Util.closePop();

		if (buttonIndex == 0) {

			Loading.on();

			myStorage.save("distanceBars", 5);

			Discover.bars_geolocate();
		}
		else if (buttonIndex == 1) {

			Loading.on();
			
			myStorage.save("distanceBars", 15);

			Discover.bars_geolocate();

		}
	 	else if (buttonIndex == 2) {

	 		Loading.on();

	 		myStorage.save("distanceBars", 30);

			Discover.bars_geolocate();

		}
		else if (buttonIndex == 3) {

	 		Loading.on();

	 		myStorage.save("distanceBars", 50);

			Discover.bars_geolocate();
		}

	},
	bars: function() {

		var blob = {
			message: "Select a Radius to search for Bars",
			items: [
				{
					title: "5 Miles",
					button: true,
					onclick: "MenuToggle.bars_callback(0);"
				},
				{
					title: "10 Miles",
					button: true,
					onclick: "MenuToggle.bars_callback(1);"
				},
				{
					title: "15 Miles",
					button: true,
					onclick: "MenuToggle.bars_callback(2);"
				},
				{
					title: "30 Miles",
					button: true,
					onclick: "MenuToggle.bars_callback(3);"
				},
				{
					title: "50 Miles",
					button: true,
					onclick: "MenuToggle.bars_callback(4);"
				},
				{
					title: "Refresh",
					button: true,
					onclick: "Refresh.pull();"
				}
			]
		}

		actionSheet.create(blob);

	},
	breweries_callback: function() {

		Util.closePop();

		if (buttonIndex == 0) {

			myStorage.save("distanceBreweries", 5);

			Discover.breweries_geolocate();
		}
		else if (buttonIndex == 1) {
			
			myStorage.save("distanceBreweries", 15);

			Discover.breweries_geolocate();

		}
	 	else if (buttonIndex == 2) {

	 		myStorage.save("distanceBreweries", 30);

			Discover.breweries_geolocate();

		}
		else if (buttonIndex == 3) {

			myStorage.save("distanceBreweries", 50);

			Discover.breweries_geolocate();

		}


	},
	breweries: function() {

		var blob = {
			message: "Select a Radius to search for Breweries",
			items: [
				{
					title: "5 Miles",
					button: true,
					onclick: "MenuToggle.breweries_callback(0);"
				},
				{
					title: "10 Miles",
					button: true,
					onclick: "MenuToggle.breweries_callback(1);"
				},
				{
					title: "15 Miles",
					button: true,
					onclick: "MenuToggle.breweries_callback(2);"
				},
				{
					title: "30 Miles",
					button: true,
					onclick: "MenuToggle.breweries_callback(3);"
				},
				{
					title: "50 Miles",
					button: true,
					onclick: "MenuToggle.breweries_callback(4);"
				},
				{
					title: "Refresh",
					button: true,
					onclick: "Refresh.pull();"
				}
			]
		}

		actionSheet.create(blob);


	},
	beers_callback: function() {

		Util.closePop();

		if (buttonIndex == 0) {

			Loading.on();

			myStorage.save("distanceBeers", 5);

			Discover.beers_geolocate();
		}
		else if (buttonIndex == 1) {

			Loading.on();
			
			myStorage.save("distanceBeers", 15);

			Discover.beers_geolocate();

		}
	 	else if (buttonIndex == 2) {

	 		Loading.on();

	 		myStorage.save("distanceBeers", 30);

			Discover.beers_geolocate();

		}
		else if (buttonIndex == 3) {

			Loading.on();

	 		myStorage.save("distanceBeers", 50);

			Discover.beers_geolocate();

		}

	},
	beers: function() {

		var blob = {
			message: "Select a Radius to search for Beers",
			items: [
				{
					title: "5 Miles",
					button: true,
					onclick: "MenuToggle.beers_callback(0);"
				},
				{
					title: "10 Miles",
					button: true,
					onclick: "MenuToggle.beers_callback(1);"
				},
				{
					title: "15 Miles",
					button: true,
					onclick: "MenuToggle.beers_callback(2);"
				},
				{
					title: "30 Miles",
					button: true,
					onclick: "MenuToggle.beers_callback(3);"
				},
				{
					title: "50 Miles",
					button: true,
					onclick: "MenuToggle.beers_callback(4);"
				},
				{
					title: "Refresh",
					button: true,
					onclick: "Refresh.pull();"
				}
			]
		}

		actionSheet.create(blob);
	},
	distinct_callback: function(buttonIndex) {

		Util.closePop();

		var a = $("#badgeUserName").val();

		if (buttonIndex == 0) {
			$("#currentFilter").val("date");
			Feed.distinct_beer(a, false, "date", false);
			
		}
		else if (buttonIndex == 1) {
			$("#currentFilter").val("beer_name");
			Feed.distinct_beer(a, false, "beer_name", false);
			
		}
		else if (buttonIndex == 2) {
			$("#currentFilter").val("checkin");
			Feed.distinct_beer(a, false, "checkin", false);
			
		}
		else if (buttonIndex == 3) {
			$("#currentFilter").val("highest_rated_you");
			Feed.distinct_beer(a, false, "highest_rated_you", false);
			
		}
		else if (buttonIndex == 4) {
			$("#currentFilter").val("lowest_rated_you");
			Feed.distinct_beer(a, false, "lowest_rated_you", false);
		}

	},
	distinct: function() {

		var blob = {
			message: "Please select sort type:",
			items: [
				{
					title: "Date (Descending)",
					button: true,
					onclick: "MenuToggle.distinct_callback(0);"
				},
				{
					title: "Beer Name",
					button: true,
					onclick: "MenuToggle.distinct_callback(1);"
				},
				{
					title: "Checkin",
					button: true,
					onclick: "MenuToggle.distinct_callback(2);"
				},
				{
					title: "Highest Rated",
					button: true,
					onclick: "MenuToggle.distinct_callback(3);"
				},
				{
					title: "Lowest Rated",
					button: true,
					onclick: "MenuToggle.distinct_callback(4);"
				},
				{
					title: "Refresh",
					button: true,
					onclick: "Refresh.pull();"
				}
			]
		}

		actionSheet.create(blob);
	}
}

var Directions =  {
	start: function(a,b) {

		venuePH_Lat = a;
		venuePH_Lng	= b;

		$("#directions").hide();
		$("#directionsLoader").show();

		if (geo.geolocation) {
			watchId = geo.watchPosition(Geolocate.finish, Geolocate.error, opts); 
		}
		else
		{
			Error.handle("You browser doesn't support Geolcation");
		}
	},
	finish: function(pos) {

		geo.clearWatch(watchId);
			
		$("#directions").show();
		$("#directionsLoader").hide();

		var urlLink = "http://maps.google.com/maps?saddr="+pos.coords.latitude+","+pos.coords.longitude+"&daddr="+venuePH_Lat+","+venuePH_Lng;

		var act = new MozActivity({ name: "view", data: { type: "url", url: urlLink }});

		act.onerror = function() { alert("Can't view the url: " + urlLink); };

		//window.location.href = "http://maps.google.com?saddr="+pos.coords.latitude+","+pos.coords.longitude+"&daddr="+venuePH_Lat+","+venuePH_Lng;
	}
}

var Refresh = {
	pull: function() {

		$(".refresh").addClass("loading");

		var currentPage = $("#container div.active_page").attr('id');

		console.log(currentPage + " IS ACTIVE");

		if (currentPage == "friendsArea") {
			
			var activeArea = $(".activity-tab:visible").attr('id');

			if (activeArea == "friendsAreaContent") {
				Feed.friends(true);
			}
			else if (activeArea == "publicAreaContent") {
				Feed.pub(true);
			}
			else {
				Geolocate.around_pub();
			}
		
		}
		else if (currentPage == "userBadgeArea") {
			Feed.user_badges(null, 'beer', 'tab');
		}
		else if (currentPage == "findBeer") {
			Geolocate.find_beer(findBeer, true);
		}
		else if (currentPage == "venueArea") {
			var venue_id = $("#venue_tempalte").attr('data-venue');
			Feed.venue_full(venue_id);
		}
		else if (currentPage == "beerArea") {
			var bid = $("#beer_template").attr("data-beer");
			Feed.beer_full(bid);
		}
		else if (currentPage == "breweryArea") {
			var brewery_id = $("#brewery_template").attr("data-brewery");
			Feed.brewery(brewery_id, "full");
		}
		else if (currentPage == "yourArea") {
			Feed.your_profile(true);
		}
		else if (currentPage == "indCheckin") {
			var checkin_id = $("#check_view").attr("data-checkin");
			Feed.checkin(checkin_id, true);
		}
		else if (currentPage == "statsArea") {
			var a = $("#ageParam").val();

			if (a != "") {
				var dis = myStorage.view("statsRangeSettings");
				var rad = 30;

				if (!dis) {
					Feed.stats(30);
				}
				else {
					Feed.stats(dis);
				}
			}
			else {
				Feed.stats(a);
			}
		}
		else if (currentPage == "userFriendList") {
			var user_name = $("#user_profile").attr("data-username");
			Feed.user_friends(user_name, "full");
		}
		else if (currentPage == "wishListArea") {
			var user_name =  $("#activeUser").val();
			var is_your = $("#activeUserYou").val()
			Feed.wishlist(user_name, "full", user_name);
		}
		else if (currentPage == "listCheckinsArea") {
			var user_name =  $("#activeUser").val();
			Feed.full_activity(user_name);
		}
		else if (currentPage == "locationArea") {
			Geolocate.venues(globalBID, true);
		}
		else if (currentPage == "drinkArea") {
			var drinkArea = $(".drink-up-tab:visible").attr('id');

			if (drinkArea == "drinkAreaContent") {
				init.Recent();
			}
			else {
				Feed.recommend();
			}
		}
		else if (currentPage == "profileSettingsArea") {
			init.Social();
		}
		else if (currentPage == "friendlistArea") {
		
			var activeArea = $("div.friends-tab").attr('id');

			if (activeArea == "pendingFriends") {
				Feed.friend_requests(false, true, "pending");
			}
			else {
				Feed.friend_requests(false, true, "friends");
			}
		}
		else if (currentPage == "profileArea") {
			var user_name = $("#user_profile").attr("data-username");
			Feed.profile_full(user_name);
		}
		else if (currentPage == "discoverBeers") {
			Discover.beers_geolocate();
		}
		else if (currentPage == "distinctArea") {
			var user_name = $("#badgeUserName").val();
			Feed.distinct_beer(user_name);
		}
		else if (currentPage == "discoverBars") {
			$("#discoverBarsSearch").val('');
			Discover.bars_geolocate();	
		}
		else if (currentPage == "notificationsArea") {

			var aw = $(".note-panel:visible").attr('id');

			if (aw == "note-areas") {
				Feed.notifications(true);
			}
			else {
				Feed.notifications(true, true);
			}
		}
		else {

			refreshScroll.go();
		}

	},
	page: function(b, a) {

		window.scroll(0,0);
		Spinner.on();

		if (a == "friends")
		{
			var activeArea = $(".activity-tab:visible").attr('id');

			if (activeArea == "friendsAreaContent") {
				Feed.friends(true);
			}
			else if (activeArea == "publicAreaContent") {
				Feed.pub(true);
			}
			else {
				Geolocate.around_pub();
			}
		}
		else if (a == "findBeer") {
			Geolocate.find_beer(findBeer, true);
		}
		else if (a == "profile")
		{
			var user_name = $("#user_profile").attr("data-username");
			Feed.profile(user_name);
		}
		else if (a == "your_profile") {
			Feed.your_profile();
		}
		else if (a == "settings") {
			init.Social();
		}
		else if (a == "discoverFriends") {
			Discover.friends_geolocate();
		}
		else if (a == "checkin") {
			var checkin_id = $("#check_view").attr("data-checkin");
			Feed.checkin(checkin_id, true);
		}
		else if (a == "locations")
		{
			$("#venue-search-term").val('');
			Geolocate.venues(globalBID, true);
		}
		else if (a == "checkin") {

			var checkin_id = $("#check_view").attr("data-checkin");

			Feed.checkin(checkin_id, true);

		}
		else if (a == "drinkup") {

			var drinkArea = $(".drink-up-tab:visible").attr('id');

			if (drinkArea == "drinkAreaContent") {
				init.Recent();
			}
			else {
				Feed.recommend();
			}
		}
		else if (a == "friend-requests")
		{
			Garbage.clean("myFriends");
			Feed.friend_requests();
		}
		else if (a == "locations") {
			Geolocate.venues(globalBID, true);
		}
		else if (a == "you") {
			Feed.your_profile(true);
		}
		else if (a == "notifications") {

			var aw = $(".note-panel:visible").attr('id');

			console.log("IDSA: " + aw);

			if (aw == "note-areas") {
				Feed.notifications(true);
			}
			else {
				Feed.notifications(true, true);
			}
		}
	}
}
var Limiter = {
	limit: function(field, counter, max) {

		if ($("#"+field).val() == "") {
			$("#"+counter).html("140");
		}
		else {
			var charLen = $("#"+field).val().length;

			var diff = 140 - parseInt(charLen);

			if (diff < 0) {
				$("#"+counter).html("0");
				$("#"+field).val($("#"+field).val().substring(0, max));
			}
			else {
				$("#"+counter).html(diff);
			}
		}

	}
}


var Toggle = {
	tabs: function(a,b,c,d) {
		$("."+d+ " li a").removeClass("active");
		$(".top-tab").removeClass('active');
		$(a).addClass('active');

		$("."+b).hide();
		$("#"+c).show();
	}
}


var Tabs = {
	magic: function(hash) {

		$("#tab_bar_nav a").removeClass("active");

		switch (hash) {
			case "#!/yourArea":
				$(".tab_yourtab").addClass("active");
				break;
			case "#!/notificationsArea":
				$(".tab_notices").addClass("active");
				break;
			case "#!/friendsArea":
				$(".tab_pub").addClass("active");
				break;
			case "#!/drinkArea":
				$(".tab_drinkup").addClass("active");
				break;
			case "#!/friendlistArea":
				$(".tab_friends").addClass("active");
				break;
			case "#!/discoverArea":
			 	$(".tab_discover").addClass("active");
				break;
			case "#!/discoverBeers":
				$(".tab_discover").addClass("active");
				break;
			default:
				break;
		}
	},
	venue: function(a,b,c) {
		$("#venue_tabs ul li a").removeClass("active");
		$(a).addClass("active");
		$("."+b).removeClass('show').addClass('hide');
		$("#"+c).removeClass('hide').addClass('show');
	}
}

function activateStar(i)
{
	$('.checkin_rating_bar li a').removeClass('on');

	$("#rating_score").val(i);

	for(a = 1; a <= 5; a++)
	{
		if (a <= i)
		{
			$("#rating_"+a).addClass('on');
		}
	}
}

var Profile = {
	your_tabs: function(a,b,c,d) {
		$("#your_profile_tabs ul li a").removeClass("active");
		$(a).addClass('active');

		$(".your_profile_three_tab").hide();

		if (b == "activity") {

			if ($("#your_activity_stream_profile").html() != "") {
				$("#your_activity_stream_profile").show();
			}
			else {
				Feed.your_profile();
			}
		}
		else if (b == "wish_list") {
			if ($("#your_wishlist_stream_profile div.list_box").length != 0) {
				$("#your_wishlist_stream_profile").show();
			}
			else
			{
				Feed.wishlist(c, true, false);
			}
		}
		else {
			if ($("#your_friends_stream_profile div.list_box").length != 0) {
				$("#your_friends_stream_profile").show();
			}
			else
			{
				Feed.user_friends(c, true, false);
			}
		}
	},
	tabs: function(a, b, c) {

		$("#profile_tabs ul li a").removeClass("active");
		$(a).addClass('active');

		$(".profile_three_tab").hide();

		if (b == "activity") {

			if ($("#activity_stream_profile").html() != "") {
				$("#activity_stream_profile").show();
			}
			else {
				Feed.profile(c);
			}


		}
		else if (b == "wish_list") {
			if ($("#wishlist_stream_profile div.list_box").length != 0) {
				$("#wishlist_stream_profile").show();
			}
			else
			{
				Feed.wishlist(c, false, false);
			}
		}
		else {
			if ($("#friends_stream_profile div.list_box").length != 0) {
				$("#friends_stream_profile").show();
			}
			else
			{
				Feed.user_friends(c, false, false);
			}
		}
	}
}

var Filter = {
	toggle: function(a) {

		if ($("#"+a).hasClass('vis')) {
			$("#"+a).show();
			$("#"+a).removeClass("vis");
		}
		else {
			$("#"+a).addClass("vis");
			$("#"+a).hide();
		}

	}
}

var Loading = {
	on: function(a){
		$("#loading-overlay").addClass("loading");
	},
	off: function(a) {
		$("#loading-overlay").removeClass("loading");
	}
}

var init = {
	setUpGeo: function() {
		Geolocate.store();
	},
	Social: function(a) {

		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var c =  parseInt(Math.random()*99999999);

			var h  = host + "/account/usersettings?access_token="+token+"&_"+c;

			$.ajax({
				url: h,
				type: "GET",
				data: "",
				dataType: "json",
			    error: function(html)
				{
					// error goes here
				},
				success: function(html)
				{
					myStorage.save("socialSettings", html.response);

					Settings.init(html.response);

					refreshScroll.go();
				}
			});
		}
	},
	Recent: function(a) {
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var url_post;

			if (a) {
				
				$("#recent_beer_loader").show();
				$("#recent_beer_more").hide();

				var offset = $(".beer_recent").length;
				url_post = host + "/helpers/refresh_recent?access_token="+token+"&offset="+offset;
			}
			else {
				url_post = host + "/helpers/refresh_recent?access_token="+token;
			}

			$.ajax({
				url: url_post,
				type: "GET",
				data: "",
				dataType: "json",
			    error: function(html)
				{
					Spinner.off();

					if (a) {

						$("#recent_beer_loader").hide();
						$("#recent_beer_more").show();
						Error.ajax_error(xhr, ajaxOptions, thrownError);
					}

					// error goes here
				},
				success: function(html)
				{
					if (html.meta.code == 200)
					{
						if (html.notifications.unread_count.friends >= 1) {
							$("#pendingFriendsNotice").prepend('<span class="pending">!</span>');
						}
						else {
							$("#pendingFriendsNotice span.pending").remove();
						}

						var source   = $("#drink-up-template").html();

						Spinner.off();

						if (a) {

							if (html.response.count == 0) {
								$("#recent_beer_loader").hide();
								$("#recent_beer_more").hide();
							}
							else {
								$("#recent_beer_loader").hide();
								$("#recent_beer_more").show();
							}

							var template = Handlebars.templates['drink-up-template.tmpl'];
							var drinkUp = template(html.response);

							$("#drinkAreaContentArea").append(drinkUp);
						}
						else {

							if (html.response.count == 0) {

								var obj = {};
								obj["h2_message"] = "You haven't checked in any beers yet!";
								obj["h3_message"] = "Starting searching today!";

								var template = Handlebars.templates['empty-list-box.tmpl']

								var drinkUp = template(obj);

								$("#drinkAreaContentArea").html(drinkUp);
							}
							else {
								/*var template = Handlebars.compile(source);
								var drinkUp = template(html.response);*/

								var template = Handlebars.templates['drink-up-template.tmpl'];
								var drinkUp = template(html.response);

								$("#drinkAreaContentArea").html(drinkUp);

								if ($(".beer_recent").length >= 5 && $("#recent_beer_more").length == 0) {
									$("#drinkAreaContentArea").after('<div id="recent_beer_loader" class="loading_inner" style="display: none;"><img src="assets/images/spinner.gif" width="24" height="24" /></div><a rel="action-btn" id="recent_beer_more" href="javascript:void(0);" onclick="init.Recent(true);" class="yellow_btn small">See More Recent Beers</a>');

								}
							}


						}	

						
						refreshScroll.go();
					}
				}
			});
		}
	},
	setupUser: function(a){
		var token = Validate.token();

		if (!token)
		{
			Error.token();
		}
		else
		{
			var yourProfile = myStorage.view("yourProfile");

			if (!yourProfile) {

			}
			else {

				console.log("full template now");
				
				Template.your_full_profile("yourAreaContent", yourProfile);
			}

			$.ajax({
				url: host + "/user/info?access_token="+token,
				type: "GET",
				data: "",
				dataType: "json",
			    error: function(html)
				{
					// error goes here
				},
				success: function(html)
				{
					if (html.meta.code == 200)
					{
						Notifications.set(html.notifications);

						if (html.notifications.unread_count.friends >= 1) {
							$("#pendingFriendsNotice").prepend('<span class="pending">!</span>');
						}
						else {
							$("#pendingFriendsNotice span.pending").remove();
						}

						myStorage.save("userInfo", html.response);

						if (a) {

							if (a == "twitter") {
								if (html.response.user.contact.twitter) {
									console.log("linked");
								}
								else {
									console.log("unlinked");
								}
							}
							else if (a == "facebook") {

								if (html.response.user.contact.facebook) {
									console.log("linked");
								}
								else {
									console.log("unlinked");
								}
							}
							else if (a == "foursquare") {

								if (html.response.user.contact.foursquare) {
									console.log("linked");
								}
								else {
									console.log("unlinked");
								}
							}
							else {
								console.log("unlinked");
							}
						}
						else {
							/*var source   = $("#drink-up-template").html();
							var template = Handlebars.compile(source);*/

							if (html.response.user.recent_brews.count == 0) {
								var obj = {};
								obj["h2_message"] = "You haven't checked in any beers yet!";
								obj["h3_message"] = "Starting searching today!";

								var template = Handlebars.templates['empty-list-box.tmpl']

								var drinkUp = template(obj);

								$("#drinkAreaContentArea").html(drinkUp);
							}
							else {
								var template = Handlebars.templates['drink-up-template.tmpl'];

								var drinkUp = template(html.response.user.recent_brews);

								$("#drinkAreaContentArea").html(drinkUp);

								if ($(".beer_recent").length >= 5 && $("#recent_beer_more").length == 0) {
									$("#drinkAreaContentArea").after('<div id="recent_beer_loader" class="loading_inner" style="display: none;"><img src="assets/images/spinner.gif" width="24" height="24" /></div><a rel="action-btn" id="recent_beer_more" href="javascript:void(0);" onclick="init.Recent(true);" class="yellow_btn small">See More Recent Beers</a>');

								}

							}

							var template = Handlebars.templates['your-profile-template.tmpl'];
							var yourProfile = template(html.response);

							$("#yourAreaContent").html(yourProfile);

			
							if (html.response.user.checkins.count == 0) {

								var obj = {};
								obj["h2_message"] = "You haven't checked in any beers yet!";
								obj["h3_message"] = "";

								var template = Handlebars.templates['empty-list-box.tmpl']

								var yourCheckins = template(obj);

								$("#your_activity_stream_profile_content").html(yourCheckins);
							}
							else {
								var template = Handlebars.templates['activity-template.tmpl'];

								var yourCheckins = template(html.response.user);

								$("#your_activity_stream_profile_content").html(yourCheckins);
							}
						}

						refreshScroll.go();

					}
				}
			});

		}
	},
	legacy: function() {
		if (localStorage.getItem('untappd_id') && localStorage.getItem('untappd_user'))
		{
			clearAjax();

			var user_id = localStorage.getItem('untappd_id');
			var user_name = localStorage.getItem('untappd_user');

			var args = "user_id="+user_id+"&user_name="+user_name;

			ajaxStatement = $.ajax({
				url: host + "/app_exchange_token?client_id="+client_id+"&client_secret="+client_secret,
				type: "POST",
				data: args,
				dataType: "json",
			    error: function(html)
				{
					List.user_country();
					//window.location.href = "#!/startArea";
					Page.change("#!/startArea", "start");
				},
				success: function(html)
				{
					if (html.meta.code == 200)
					{
						myStorage.token(html.response.access_token);

						myStorage.token(html.response.access_token);

						init.setUpGeo();
						init.setupUser();
						init.Social();

						if (html.response.default_load) {
							Feed.friends(null);
							Page.change("#!/friendsArea", "start");
							//window.location.href = "#!/drinkArea";
						}
						else {
							//window.location.href = "#!/friendsArea";
							Page.change("#!/friendsArea", "start");
						}
					}
					else
					{
						Error.handle(html.meta.error_detail, html.meta.error_type, html.meta.code);
						List.user_country();
						//window.location.href = "#!/startArea";
						Page.change("#!/startArea", "start");
					}
				}
			});
		}
		else
		{
			List.user_country();
			//window.location.href = "#!/startArea";
			Page.change("#!/startArea", "start");

		}


	}
}

var Util = {
	closePop: function() {
		//$("body").removeClass("overlayOpen");
		$("#notice_overlay").hide();
		$("#notice-error").hide();
	},
	openPop: function() {
		$("#notice-error").show();
		$("#notice_overlay").show();
		//$("body").addClass("overlayOpen");
	},
	closePopTimeout: function(time) {
		setTimeout('$("#notice_overlay").hide(); $("#notice-error").hide();', time);
	}
}

var refreshScroll = {
	go: function() {
		setTimeout(function () {
			$(".lazy").unveil();
		}, 0);
	}
}


