$(function() {

	var caption_on = false;
	init();

	/* Prompt user when leaving the guide via back button. */
	$(window).bind('beforeunload', function(){
    	return 'You will be exiting the guide.';
	});


	// Initialize module
	function init() {
		/* Check if we have a value for captions saved. */
		if(supports_html5_storage && localStorage.getItem('caption')){
			caption_on = JSON.parse(localStorage.getItem('caption'));
		}
		if (caption_on) {
			$(".info").show();
		}
		moveTo("#gallery");
	}


	// Move to requested page
	function moveTo(id) {

		var curr = $('.card:visible').attr('id');

		$(".card").hide();
		$(""+id).show();

		scrollTo(0,-1);
	}


	/* Link to sp page */
   	$("a").click(function (e) {
		var target = $(this).attr('href');
		
		moveTo(target);
		return false;
	});

	/* Go to group index page */
	$(".group h2").click(function (e) {
		var target = "#"+$(this).attr("data-id");
		moveTo(target);
		return false;
	});

	/* Back to the index page */
	$(".back").click(function (e) {
		moveTo("#gallery");
		return false;
	});

	/*  Move from sp to sp. */
	$(".button").click(function () {
		var target = $(this).attr("href");
		moveTo(target);
		return false;
    });

	/* When we click on an image, three things can happen:
	   1. click on left part of image: move to previous card
	   2. click on right part of image: move to next card
	   3. Click on center of image: toggle caption
	*/
	$(".panel").click(function (e) {

		var middle = $(this).width() / 2;

		var l = $(this).width() / 3;
		var c = l + $(this).width() / 3;
		

		var x = e.pageX - $(this).offset().left;


		if (x > l && x < c) {
			toggle_caption();
			return true;
		}	
		
		else if (x < l) {
			goToPrev(this);
			var next = ($(this).prev().length) ?
				$(this).prev() : $(this).parent().find(":last-child");
		}
		else if (x > c) {
			var next = ($(this).next().length) ?
				$(this).next() : $(this).parent().find(":first");
			goToNext(this);
		}
		
		//$(this).hide();
		//$(next).show();
	});



	$('.panel').swipe({
		swipeLeft: function() {
			goToPrev(this);
		},
		swipeRight: function() {
			goToNext(this);
		}
	});

	function goToNext(panel) {
		var next = ($(panel).next().length) ?
			$(panel).next() : $(panel).parent().find(":first");

		$(panel).hide();
        $(next).show();
	}

	function goToPrev(panel) {
		var next = ($(panel).prev().length) ?
			$(panel).prev() : $(panel).parent().find(":last-child");
		
		$(panel).hide();
        $(next).show();
	}

	/*  Captions */
	$(".menuButton").click(function () {
		$("#options").toggle();
	});

	$("#captions-menu").change(function () {
		caption_on = true;
				$(".info").toggle();
    });


	function toggle_caption() {
		caption_on = (caption_on) ? false : true;
		$(".info").toggle();
		if (supports_html5_storage)
			save_options('caption', caption_on);
	}		

	function save_options(name, value) {
		localStorage.setItem(name, JSON.stringify(value));
	}

	function supports_html5_storage() {
  		try {
    		return 'localStorage' in window && window['localStorage'] !== null;
  		} catch (e) {
    		return false;
  		}
	}

});
