$(document).ready(function(){

	$('#holiday-type').on('change', function() {
    	refreshList();
	});


	$('#selection').on('change', function() {
		refreshList();
	});

	function refreshList() {
		var state,
			year
			holidayType ='';

		holidayType = $('input[name=holiday-type]:checked').val();

		$('ul.holidays').html('');

		state = $('#select-state').val();
		year  = $('#select-year').val();

		if( state != 'Bundesland' && year != 'Jahr' ) {

			$('#info-text').hide();


			if( holidayType == 'Feiertage' ) {
				// console.log('Send Request: Feiertage');
				getXMLForHolidays(state, year);
			} else if( holidayType == 'Ferien' ) {
				// console.log('Send Request: Ferien');
				getXMLForSeasons(state, year);
			}
		}
		else
		{
			$('#info-text').show();
		}		
	}


	function getXMLForHolidays(state, year) {

		var html = '',
			arrayTage = new Array('Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag'),
			arrayMonate = ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'];

		$.ajax({
	        type: "GET",
			url: "xml/holidays.xml",
			dataType: "xml",
			success: function(xml) {
	 			$(xml).find('holidays[state =' + state + '][year =' + year + ']').each(function() {
	 				$(this).find('holiday').each(function() {
						var title = $(this).attr('title'),
							date = $(this).attr('date'),
							wochentag,
							monat;

						wochentag = arrayTage[new Date(date).getDay()];

						arr = date.split('/');

						monat = arrayMonate[arr[1]-1];
						dateOutput = arr[2] + '. ' + monat;

						html += '<li><div class="ui-li-aside">'+ dateOutput + '</div><h2 class="ui-li-heading">' + title +'</h2><p class="ui-li-desc">' + wochentag + '</p></li>';
					});
				});

				$('ul.holidays').append(html);

				$('ul.holidays').listview('refresh');
			}
		})//.fail(function(ts) { alert(ts.responseText) });	
	}

	function getXMLForSeasons(state, year) {

		var html = '';

		$.ajax({
	        type: "GET",
			url: "xml/holiday-season.xml",
			dataType: "xml",
			success: function(xml) {
	 			$(xml).find('holidays[state =' + state + '][year =' + year + ']').each(function() {
	 				$(this).find('holiday').each(function() {
						var title = $(this).attr('title'),
							startdate = $(this).attr('start-date'),
							enddate = $(this).attr('end-date');

						startarr = startdate.split('/');
						dateOutput = startarr[2] + '.' + startarr[1];

						endarr = enddate.split('/');
						dateOutput += ' - ' + endarr[2] + '.' + endarr[1] + '.' + endarr[0];

						html += '<li><div class="ui-li-aside">'+ dateOutput + '</div><h2 class="ui-li-heading">' + title +'</h2></li>';
					});
				});

				$('ul.holidays').append(html);

				$('ul.holidays').listview('refresh');
			}
		})//.fail(function(ts) { alert(ts.responseText) });	
	}
});