// App specific
$(function() {
    window.isPaidVersion = true;
    window.packageName = "cloud4apps.quiz.uscitizen";
    window.quizName = "us_citizenship";
});

// App specific
function loadAppSpecificData(){
    loadStates();
    loadstateSenators();
}

$(document).delegate('#settingsPage', 'pageshow', function() {
    var globalVariables = window.localStorage.getObject('globalVariables');
    if (!globalVariables) return;
    if (globalVariables.zipCode) $('#zipCode').val(globalVariables.zipCode);
    if (globalVariables.your_representative) $('#representatives').val(globalVariables.your_representative);
    if (globalVariables.your_senators) $('#senators').val(globalVariables.your_senators);
    if (globalVariables.your_governor) $('#governor').val(globalVariables.your_governor);
    if (globalVariables.capital_of_your_state) $('#capital').val(globalVariables.capital_of_your_state);
});


function loadStates() {
    //$.getJSON('data/us_states-en.json', function(data) {
        window.us_states = us_states_en;
    //});
}

function loadstateSenators() {
    //$.getJSON('data/us_state_senators-en.json', function(data) {
        window.us_state_senators = us_state_senators_en;
    //});
}

function isZipCodeDefined(zip) {
    if (zip === undefined || zip == null || zip == '' || isNaN(zip)) return false;
    else return true;
}

function getMyLegislators() {
    var zip = $('#zipCode').val();
    if (!isZipCodeDefined(zip)) {
        $().toastmessage('showNoticeToast', 'Please enter a zip code first');
        return;
    }

    var url = 'https://congress.api.sunlightfoundation.com/legislators/locate?zip=' + zip + '&apikey=36b32c003a3042c288f6cf432c7cf96d';
    $.mobile.loading('show', {text: 'loading', textVisible: true});
    $.get(url, getMyLegislatorsReturn);
}

function getMyLegislatorsReturn(data) {
    $.mobile.loading('hide');
    if (data == null || data === undefined || data.results === undefined || data.results.length === undefined || data.results.length == 0) return;
    var your_representative = null;
    var your_senators = null;
    var stateId = null;
    for (var idx = 0; idx < data.results.length; idx++) {
        var result = data.results[idx];
        if (stateId == null) stateId = result.state;
        var fullName = result.first_name;
        if (result.middle_name !== null) fullName += ' ' + result.middle_name;
        fullName += ' ' + result.last_name;
        if (result.chamber == 'house') {
            if (your_representative == null) your_representative = fullName;
            else your_representative += ', ' + fullName;
        } else if (result.chamber == 'senate') {
            if (your_senators == null) your_senators = fullName;
            else your_senators += ', ' + fullName;
        }
    }
    $('#representatives').val(your_representative);
    $('#senators').val(your_senators);
    if (!stateId) return;
    $('#capital').val(window.us_states[stateId]);
    $('#governor').val(window.us_state_senators[stateId]);
}

function closeSettingsDialog() {
    var globalVariables = {
        zipCode: $('#zipCode').val(),
        your_representative: $('#representatives').val(),
        your_senators: $('#senators').val(),
        your_governor: $('#governor').val(),
        capital_of_your_state: $('#capital').val()
    };
    window.localStorage.setObject('globalVariables', globalVariables);
    $.mobile.changePage('#takeTestPage', {changeHash: false, reverse: true});
}

function getMyLocation() {
    if (navigator.geolocation) navigator.geolocation.getCurrentPosition(showPosition);
}

function showPosition(position) {
    if (position === undefined || position.coords === undefined) return;
    // Get zip from geolocation
    var url = 'http://ws.geonames.org/findNearbyPostalCodesJSON?formatted=true&lat=' + position.coords.latitude + '&lng=' + position.coords.longitude + '&maxRows=1&username=ljbotero';
    $.mobile.loading('show', {text: 'loading', textVisible: true});
    
    ajaxOptions = {
            type: 'GET',
            url: url,
            async: false,
            crossDomain: true,
            contentType: "application/json",
            dataType: "jsonp",
            success: gotZipFromposition,
          };
    $.ajax(ajaxOptions);
}

function gotZipFromposition(data) {
    $.mobile.loading('hide');
    if (data == null || data === undefined || data.postalCodes === undefined || data.postalCodes.length === undefined || data.postalCodes.length == 0) return;
    var zip = data.postalCodes[0].postalCode;
    $('#zipCode').val(zip);
}
