/*global window */
function errorHandler(message, url, linenumber) {
    try {
        var error, trace;
        error = message + ' on line ' + linenumber + ' for ' + url;
        trace = printStackTrace();
        alert(error + '\n\n' + trace);
    } catch (e) {
        if (isUndefined(message))
            alert("Unknown error");
        else
            alert(message);
    }
    return true;
}

$(function() {
    //window.onerror = errorHandler;
    window.quizToLoad = null;
    window.buildNavIndexLock = false;
    window.nextQuestionLock = false;
    window.lastQuizLoaded = null;
    /**
     * Enum for tri-state values.
     * 
     * @enum {number}
     */
    window.modes = {
        /** @expose */
        PRACTICE_MODE : 1,
        /** @expose */
        LEARNING_MODE : 2,
        /** @expose */
        QUIZ_MODE : 3
    };
    
    if(window.isPaidVersion === false){
        $('#upgradeButton').show();
    }
});

Storage.prototype.setObject = function(key, value) {
    this.setItem(key, JSON.stringify(value));
};

Storage.prototype.getObject = function(key) {
    var value = this.getItem(key);
    return value && JSON.parse(value);
};

function isUndefined(obj) {
    try {
        if (obj === undefined || obj == 'undefined' || obj == null || !obj)
            return true;
    } catch (e) {
    }
    return false;
}

// Generic functions
function fisherYates(myArray) {
    var i = myArray.length, j, tempi, tempj;
    if (i === 0)
        return false;
    while (--i) {
        j = Math.floor(Math.random() * (i + 1));
        tempi = myArray[i];
        tempj = myArray[j];
        myArray[i] = tempj;
        myArray[j] = tempi;
    }
}

function hasQuestions() {
    if (isUndefined(window.currentQuizOriginal))
        return false;
    if (isUndefined(window.currentQuizOriginal.questions))
        return false;
    return true;
}

function findAnswersWithHighestScore(answersArray) {
    return $.grep(answersArray, function(answer) {
        if (isNaN(answer.answerScore))
            return false;
        var score = parseInt(answer.answerScore);
        return (score > 0);
    });
}

Array.prototype.remove = function(name, value) {
    var rest = $.grep(this, function(item) {
        return (item[name] !== value);
    });

    this.length = 0;
    this.push.apply(this, rest);
    return this;
};

Array.prototype.removeEmpty = function(name) {
    var rest = $
            .grep(
                    this,

                    function(item) {
                        var value = item[name];
                        return ((!isUndefined(value) && value !== '' && value !== '0') || (Object.prototype.toString
                                .call(value) === '[object Array]' && value.length > 0));
                    });

    this.length = 0;
    this.push.apply(this, rest);
    return this;
};

Array.prototype.removeAllExcept = function(name, value) {
    var rest = $.grep(this, function(item) {
        return (item[name] === value);
    });

    this.length = 0;
    this.push.apply(this, rest);
    return this;
};

function getRandomNumber(maxNumber, excludeNumber) {
    var rnd = 0;
    if (maxNumber < 1)
        return rnd;
    do {
        rnd = Math.floor(Math.random() * (maxNumber + 1));
    } while (rnd === excludeNumber);
    return rnd;
}

function displayRandomImage(question, img) {
    if (window.displayRandomImageLastQuestion == question) {
        window.displayRandomImageFailures++;
        if (window.displayRandomImageFailures > 3) {
            $(img).hide();
            return;
        }
    } else {
        window.displayRandomImageFailures = 0;
        window.displayRandomImageLastQuestion = question;
    }
    $(img).show();
    $(img).attr('src', 'images/loading5.gif');

    var success = function(data) {
        if (!data || !data.responseData || !data.responseData.results
                || data.responseData.results.length <= 0) {
            displayRandomImage(question, img);
            return;
        }
        var imageUrl = data.responseData.results[0].url;
        $.ajax({
            url : imageUrl,
            type : 'HEAD',
            success : function() {
                $(img).attr('src', imageUrl);
            },
            error : function(e1, e2) {
                displayRandomImage(question, img);
            }
        });
    };

    $
            .getJSON(
                    'https://ajax.googleapis.com/ajax/services/search/images?callback=?',
                    {
                        q : question,
                        v : '1.0',
                        imgsz : 'medium|large',
                        rsz : 1,
                        imgtype : 'photo',
                        safe : 'active',
                        as_rights : 'cc_publicdomain',
                        start : getRandomNumber(50, null)
                    }, success);
}

Number.prototype.toOrdinal = function() {
    var n = this % 100;
    var suffix = [ 'th', 'st', 'nd', 'rd', 'th' ];
    var ord = n < 21 ? (n < 4 ? suffix[n] : suffix[0])
            : (n % 10 > 4 ? suffix[0] : suffix[n % 10]);
    return this + ord;
};

// Licensing & Purchaing
function appstore(link, type) {
    try{
        var appstores = cordova.require("cordova/plugin/appstore");
        appstores.show({
            link : link,
            type : type
        }, function() {
            // console.info("PhoneGap Plugin: Appstore: show: callback success");
        }, function() {
            console.error("PhoneGap Plugin: Appstore: show: callback error");
        });
    } catch (e){
        console.error("PhoneGap Plugin: Appstore: show: callback error");
    }
}

function purchase() {
    $.mobile.loading('show', {
        text : 'Please wait',
        textVisible : true
    });    
    window.setTimeout(function() {        
        appstore(window.packageName, "app");
        $.mobile.loading('hide');
    }, 800);
}

// Platform
function onLoad(parent) {
    $.mobile.buttonMarkup.hoverDelay = true;
    // $.mobile.ignoreContentEnabled = true;
    $.mobile.defaultPageTransition = 'flip';
    $.mobile.pushStateEnabled = false;
    $().toastmessage({
        position : 'middle-right'
    });
    // $('#mainBody').show();
    localize();
    loadQuiz(window.quizName);
    if (typeof loadAppSpecificData == 'function')
        loadAppSpecificData();
}

$(document).ready(function() {
    onLoad(window.parent.document);
});

// Data loading functions
function validateData(questions) {
    // $.each(questions, function(index, value){
    // var q = findAnswersWithHighestScore(value.answers)
    // if (q.length == 0)
    // throw "error on question #" + value.id;
    // });
}

function dataLoaded(data, defaultCallback) {
    $.mobile.loading('hide');
    if (window.lastQuizLoaded !== null
            && window.lastQuizLoaded == window.quizToLoad) {
        return;
    }
    if (isUndefined(data) || isUndefined(data.questions)) {
        return;
    }
    window.lastQuizLoaded = window.quizToLoad;
    data.questions.removeEmpty('question');
    validateData(data.questions);
    window.currentQuizOriginal = data;
    $('.quiz_name').html(data.name);
    var imagePath = data.imagePath;
    if (!imagePath)
        imagePath = 'images/pixel.png';
    $('#quiz_img').attr('src', imagePath);
    // Set questions set 
    //$('#questionSetsContainer').empty();
    var tmp = $('#questionSetTmp').tmpl(window.currentQuizOriginal);
    tmp.appendTo('#questionSetsContainer');
}

function localized(data, defaultCallback) {
    defaultCallback(data);
    $.mobile.changePage('#takeTestPage', {
        changeHash : false,
        transition : 'none'
    });
}

function localize() {
    var lang, opts;
    lang = null;
    opts = {
        language : lang,
        pathPrefix : 'data',
        callback : localized
    };
    $("[data-localize]").localize('values', opts);
}

function loadQuiz(quizName) {
    $.mobile.loading('show', {
        text : 'loading',
        textVisible : true
    });
    var lang, opts;
    lang = null; // "es";
    opts = {
        language : lang,
        callback : dataLoaded,
        pathPrefix : 'data'
    };
    window.quizToLoad = quizName;
    $.localize(quizName, opts);
}

// Quiz Navigation
function buildCurrentQuizIndex() {
    window.currentQuizIndex = {};
    var q = window.currentQuiz.questions;
    for (var i = 0; i < q.length; i++) {
        window.currentQuizIndex[q[i].id] = i;
        delete q[i].timesWrong;
        for (var j = 0; j < q[i].answers.length; j++) {
            delete q[i].answers[j].selected;
        }
    }
}

function buildNavIndex(quizData) {
    if (window.buildNavIndexLock == true)
        return;
    window.buildNavIndexLock = true;
    $.mobile.loading('show', {
        text : 'loading',
        textVisible : true
    });
    window.setTimeout(function() {
        try {
            window.currentQuiz = jQuery.extend(true, {}, quizData);
            var q = window.currentQuiz.questions;
            if (window.currentMode == window.modes.QUIZ_MODE
                    || window.currentMode == window.modes.PRACTICE_MODE)
                fisherYates(q);
            // Re-assign ids and navigation
            var currentId = 0;
            for (var i = 0; i < q.length; i++) {
                if (isUndefined(q[i]))
                    continue;
                q[i].id = 'question' + currentId;
                q[i].nextId = 'question' + (currentId + 1);
                currentId++;
                var a = q[i].answers;
                // Set answer ids
                var answerSize = quizData.answerSize;
                if (!answerSize || answerSize < a.length)
                    answerSize = a.length;
                for (var j = 0; j < answerSize; j++) {
                    if (isUndefined(a[j]))
                        a[j] = {
                            answer : '',
                            answerScore : 0
                        };
                    a[j].id = 'a' + j;
                }
                if (window.currentMode == window.modes.LEARNING_MODE) {                    
                    // Remove empty answers
                    a.removeEmpty('answer');
                    if (q[i].showAllAnswers !== true)
                        a.removeEmpty('answerScore');
                    // Just leave the correct answers
                    a = findAnswersWithHighestScore(a);
                } else if (window.currentMode == window.modes.PRACTICE_MODE
                        || window.currentMode == window.modes.QUIZ_MODE) {
                    // Replace empty answers with random answers from other
                    // questions
                    fillEmptyQuestionsWithRandom(q, a, i);
                }

                if (window.currentMode == window.modes.QUIZ_MODE) {
                    // Remove audio cues
                    q[i].audio = '';
                }
                if (isUndefined(a) || a.length == 0) {
                    continue;
                }
                // scramble answers
                fisherYates(a);
            }
            q.removeEmpty('answers');
            // set end of quiz
            var quizLength = q.length - 1;
            if (window.currentMode == window.modes.QUIZ_MODE
                    && quizLength > window.currentQuizOriginal.quizSize - 1)
                quizLength = window.currentQuizOriginal.quizSize - 1;
            q[quizLength].nextId = 'results';
            // Remove remaining questions
            while (quizLength + 1 < q.length)
                q.pop();
            // Build questions index
            buildCurrentQuizIndex();
            buildVariablesIndex();
            // window.currentQuestionIdx = -1;
            // Clear question ids on pages to force full page refresh when new
            // tests start
            $('input[type="hidden"]').each(function(i) {
                $(this).val('')
            });
            nextQuestion();
        } finally {
            // $.mobile.loading('hide');
            window.buildNavIndexLock = false;
        }
    }, 100);
}

function fillEmptyQuestionsWithRandom(q, a, i) {
    if (q.length <= 1)
        return;
    jQuery.each(a,

            function() {
                if (!isUndefined(this.answer) && this.answer.length > 0)
                    return true;
                var foundSameAnswer;
                var randomAnswer;
                do {
                    var randomQuestionIdx = getRandomNumber(q.length - 1, i);
                    var randomAnswers = q[randomQuestionIdx].answers;
                    var randomAnswerIdx = getRandomNumber(
                            randomAnswers.length - 1, -1);
                    randomAnswer = randomAnswers[randomAnswerIdx].answer;
                    foundSameAnswer = false;
                    for (var aIdx = 0; aIdx < a.length; aIdx++) {
                        var aText = a[aIdx].answer;
                        if (randomAnswer != aText)
                            continue;
                        foundSameAnswer = true;
                        break;
                    }
                } while (foundSameAnswer);
                this.answer = randomAnswer;
            });
}

function bindUserAnswersToData() {
    if (window.currentQuestionIdx < 0)
        return;
    var currQuestion = window.currentQuiz.questions[window.currentQuestionIdx];
    var userAnswers = $("input[name='" + currQuestion.id
            + "AnswersField']:checked");
    for (var i = 0; i < currQuestion.answers.length; i++) {
        var a = currQuestion.answers[i];
        delete a.selected;
    }
    $(userAnswers).each(function(ua) {
        if (!$(this).is(':checked'))
            return userAnswers;

        for (var i = 0; i < currQuestion.answers.length; i++) {
            var a = currQuestion.answers[i];
            if (a.id === this.id) {
                a.selected = true;
                break;
            }
        }
    });
    return userAnswers;
}

function validateAnswerToCurrentQuestion() {
    if (window.currentQuestionIdx < 0)
        return true;
    var currQuestion = window.currentQuiz.questions[window.currentQuestionIdx];
    if (currQuestion.answers.length <= 1
            || window.currentMode == window.modes.LEARNING_MODE)
        return true;
    var userSelections = $.grep(currQuestion.answers, function(answer) {
        return (answer.selected === true);
    });
    if (userSelections.length <= 0) {
        $().toastmessage('showErrorToast', 'Please choose an answer');
        return false;
    }
    if (window.currentMode == window.modes.PRACTICE_MODE) {
        var userScore = calculateScoreQuestion(currQuestion.answers);
        if (userScore !== 100) {
            // $().toastmessage('showErrorToast', 'Wrong answer. Try again');
            if (isUndefined(currQuestion.timesWrong))
                currQuestion.timesWrong = 0;
            currQuestion.timesWrong++;
            return false;
        }
    }
    return true;
}

function displayCurrentQuestion() {
    displayQuestion(window.currentPage, window.currentQuestionIdx);
    // refresh
    var page = window.currentPage;
    var qIdx = window.currentQuestionIdx;
    for (var idx = 2; idx < window.Pages.length; idx++) {
        page++;
        qIdx++;
        if (page >= window.Pages.length)
            page = 0;
        if (qIdx >= window.currentQuiz.questions.length)
            break;
        else
            displayQuestion(page, qIdx);
    }

    var questionsPage = '#questionsPage' + window.currentPage;
    $.mobile.changePage(questionsPage, {
        changeHash : false
    });

    var answerContent = '#answerContent' + window.currentPage;
    $(answerContent + " input[name='answersField']").checkboxradio('refresh');
}

function displayQuestion(current_page, current_question_idx) {
    window.Pages[current_page].questionIdx = current_question_idx;

    var currQuestion = window.currentQuiz.questions[current_question_idx];

    var answerContent = '#answerContent' + current_page;

    var currentPageAnswerId = $(answerContent + ' input[type="hidden"]').val();
    if (currentPageAnswerId && currentPageAnswerId === currQuestion.id)
        return;

    $(answerContent).empty();
    var scoreQuestions = findAnswersWithHighestScore(currQuestion.answers);
    var tmp = null
    if (scoreQuestions.length > 1)
        tmp = $('#questionContentMultipleTmp').tmpl(currQuestion);
    else
        tmp = $('#questionContentTmp').tmpl({
            q : currQuestion,
            page : window.currentQuestionIdx + 1,
            total : window.currentQuiz.questions.length
        });
    tmp.appendTo(answerContent);

    var audioControls = '#audioControls' + current_page;
    $(audioControls).empty();
    var tmp1 = $('#questionAudioTmp').tmpl(currQuestion);
    tmp1.appendTo(audioControls);

    var img = $('#' + currQuestion.id + 'ImageField');
    if (!$(img).attr('src')) {
        var imgSearch = currQuestion.question;
        if (!isUndefined(currQuestion.imgSearch))
            imgSearch = currQuestion.imgSearch;
        displayRandomImage(imgSearch, img);
    }
    var questionsPage = '#questionsPage' + current_page;
    $(questionsPage).trigger('create');
}

function buildNavPages() {
    var firstPage = $('#questionsPage0');
    if ($(firstPage).length > 0)
        return;
    window.Pages = [ {
        pageId : 0
    }, {
        pageId : 1
    }, {
        pageId : 2
    }, {
        pageId : 3
    } ];
    var tmp = $('#questionPageTmp').tmpl({
        pages : window.Pages
    });
    tmp.appendTo('#mainBody');
    $('.nextQuestionButton').off('vclick');
    $('.nextQuestionButton').on('vclick', nextQuestion);
    $('.prevQuestionButton').off('vclick');
    $('.prevQuestionButton').on('vclick', previousQuestion);
    $('.exitTestButton').off('vclick');
    $('.exitTestButton').on('vclick', exitTest);
}

function previousQuestion() {
    if (window.nextQuestionLock === true)
        return;
    window.nextQuestionLock = true;
    try {
        window.currentQuestionIdx--;

        window.currentPage--;
        if (window.currentPage < 0)
            window.currentPage = window.Pages.length - 1;

        if (window.currentQuestionIdx < 0) {
            if (exitTest() == true)
                return;
        }
        displayCurrentQuestion();
    } finally {
        window.setTimeout(function() {
            window.nextQuestionLock = false;
        }, 500);
    }
}

function exitTest() {
    if (window.currentMode == window.modes.LEARNING_MODE) {
        window.currentQuestionIdx = window.localStorage.setItem(
                'currentQuestionIdx', window.currentQuestionIdx);
        $.mobile.changePage('#takeTestPage', {
            changeHash : false
        });
        return true;
    }
    if (window.confirm('Are you sure you want to quit the test?') == true) {
        $.mobile.changePage('#takeTestPage', {
            changeHash : false
        });
        return true;
    }
    return false;
}

function recomputeNewQuestions() {
    window.currentQuiz.questions = $.grep(window.currentQuiz.questions,
            function(item) {
                return (!isNaN(item.timesWrong));
            });

}

function nextQuestion() {
    if (window.nextQuestionLock === true)
        return;
    window.nextQuestionLock = true;
    try {
        var answer = bindUserAnswersToData();
        if (validateAnswerToCurrentQuestion() !== true) {
            $.each(answer, function(index, value) {
                $(value).parent().children('label:first').css(
                        'background-color', '#C43729');
            });
            return;
        }

        window.currentQuestionIdx++;

        if (isUndefined(window.currentPage))
            window.currentPage = 1;
        else
            window.currentPage++;
        if (window.currentPage >= window.Pages.length)
            window.currentPage = 0;

        if (window.currentQuestionIdx === 0) {
            displayCurrentQuestion();
            return;
        }

        if (window.currentQuestionIdx >= window.currentQuiz.questions.length) {
            if (window.currentMode == window.modes.LEARNING_MODE) {
                $.mobile.changePage('#takeTestPage', {
                    changeHash : false
                });
            } else if (window.currentMode == window.modes.PRACTICE_MODE) {
                // Re-compute new questions - eliminate the ones user got right
                recomputeNewQuestions();
                if (window.currentQuiz.questions.length == 0) {
                    $().toastmessage('showNoticeToast', 'Well done!');
                    $.mobile.changePage('#takeTestPage', {
                        changeHash : false
                    });
                    return;
                }
                $().toastmessage(
                        'showNoticeToast',
                        'Let try once again the '
                                + window.currentQuiz.questions.length
                                + ' questions you missed');

                window.currentQuestionIdx = -1;
                buildNavIndex(window.currentQuiz);
            } else {
                $.mobile.changePage('#resultsPage', {
                    changeHash : false
                });
            }
            return;
        }
        displayCurrentQuestion();
    } finally {
        window.setTimeout(function() {
            window.nextQuestionLock = false;
        }, 500);
    }
}

function startPracticeTest(questionSetStart, questionSetEnd) {
    var quiz = jQuery.extend(false, {}, window.currentQuizOriginal);
    quiz.questions = [];
    for (var idx = questionSetStart - 1; idx < questionSetEnd; idx++) {
        if (isUndefined(window.currentQuizOriginal.questions[idx]))
            break;
        quiz.questions.push(window.currentQuizOriginal.questions[idx]);
    }
    window.currentQuestionIdx = -1;
    buildNavIndex(quiz);
}

function startTest(mode) {
    if (!hasQuestions()) {
        return;
    }
    if (!areAllVariablesSet()) {
        $.mobile.changePage('#settingsPage');
        return;
    }
    window.currentMode = mode;
    buildNavPages();
    if (window.currentMode == window.modes.PRACTICE_MODE)
        $.mobile.changePage('#questionSetDialog');
    else if (window.currentMode == window.modes.LEARNING_MODE) {
        window.currentQuestionIdx = window.localStorage
                .getItem('currentQuestionIdx');
        if (isUndefined(window.currentQuestionIdx) || window.currentQuestionIdx < 0)
            window.currentQuestionIdx = 0;
        window.currentQuestionIdx--;
        buildNavIndex(window.currentQuizOriginal);
    } else {
        window.currentQuestionIdx = -1;
        buildNavIndex(window.currentQuizOriginal);
    }
}

function calculateScoreQuestion(answers) {
    if (!answers)
        return -1;
    var totalUserScore = 0;
    var totalAnswerScore = 0;
    for (var l = 0; l < answers.length; l++) {
        var a = answers[l];
        if (!a)
            continue;
        var answerScore = 0;
        if (!isNaN(a.answerScore))
            answerScore = parseInt(a.answerScore);
        totalAnswerScore += answerScore;
        if (answerScore === 0)
            answerScore = -1;
        if (a.selected === true)
            totalUserScore += answerScore;
    }
    if (totalUserScore === totalAnswerScore)
        return 100;
    else
        return 0;
}

function calculateScore() {
    var results = {};
    var maxScore = 0;
    results.totalScore = 0;
    if (isUndefined(window.currentQuiz)) {
        $.mobile.changePage('#takeTestPage', {
            changeHash : false
        });
        return;
    }
    jQuery.each(window.currentQuiz.questions, function() {
        var userScore = calculateScoreQuestion(this.answers);
        if (userScore >= 0) {
            results.totalScore += userScore;
            maxScore += 100;
        }
    });
    results.percentageScore = (results.totalScore * 100) / maxScore;
    results.percentageScoreFixed = results.percentageScore.toFixed(2);
    // window.localStorage.times = window.localStorage.times + 1;
    return results;
}

function displayResults(results) {
    if (isUndefined(results))
        return;
    // Display results
    $('.resultScore').html(results.percentageScoreFixed);
    var quizName = window.currentQuizOriginal.name;
    var quizData = getStoredData(quizName);
    $('.resultTries').html(quizData.length.toOrdinal());

    var scoreAssesment = '';
    for (idx in window.currentQuiz.results) {
        var maxScore = window.currentQuiz.results[idx].maxScore;
        if (results.percentageScore > maxScore)
            continue;
        scoreAssesment = window.currentQuiz.results[idx].text;
        $('#resultText').html(window.currentQuiz.results[idx].text);
        var imagePath = window.currentQuiz.results[idx].imagePath;
        if (imagePath) {
            $('#resultImage').attr('src', imagePath);
            $('#resultImage').show();
        } else
            $('#resultImage').hide();
        var videoPath = window.currentQuiz.results[idx].videoPath;
        var path = videoPath;
        if ($.isArray(videoPath)) {
            var idx = getRandomNumber(videoPath.length - 1, null);
            var path = videoPath[idx];
        }
        if (path) {
            $('#resultVideo').attr('src', path);
            $('#resultVideo').show();
        } else
            $('#resultVideo').hide();
        break;
    }
}

function displayChart(quizName) {
    var quizData = getStoredData(quizName);
    if (!quizData || quizData.length == 0)
        return false;
    var vals = [];
    for (var tryNumber = 0; tryNumber < quizData.length; tryNumber++) {
        vals.push([ tryNumber, quizData[tryNumber].score ]);
    }
    $.jqplot('plotChart', [ vals ], {
        title : 'Your Score Over Time',
        axes : {
            xaxis : {
                tickOptions : {
                    formatString : "%'d"
                },
                autoscale : true,
                min : 0
            },
            yaxis : {
                tickOptions : {
                    formatString : "%%%'d"
                },
                autoscale : true,
                min : 0,
                max : 100,
                labelRenderer : $.jqplot.CanvasAxisLabelRenderer
            }
        }
    });
    return true;
}

function getStoredData(quizName) {
    var quizData = window.localStorage.getObject(quizName);
    if (isUndefined(quizData))
        quizData = [];
    return quizData;
}

function storeResults(results) {
    if (isUndefined(results))
        return;
    var quizName = window.currentQuizOriginal.name;
    var quizData = getStoredData(quizName);
    var thisQuiz = {
        date : new Date(),
        score : results.percentageScore
    };
    quizData.push(thisQuiz);
    window.localStorage.setObject(quizName, quizData);
}

// Variables (settings)

function buildVariablesIndex() {
    window.variablesIndex = window.localStorage.getObject('globalVariables');
}

function findVariables(text) {
    if (isUndefined(window.variablesIndex))
        return text;
    if (text.indexOf('[') >= 0 && text.indexOf(']') >= 0) {
        for ( var name in window.variablesIndex) {
            var val = window.variablesIndex[name];
            if (val)
                text = text.replace('[' + name + ']', val);
        }
    }
    return text;
}

// Page Load Events
$(document).delegate('#resultsPage', 'pageshow', function() {
    var results = calculateScore();
    storeResults(results);
    displayResults(results);
});

$(document).delegate('#takeTestPage', 'pageshow', function() {
    $('.answerPage').remove();
});

$(document).delegate('#scoresPage', 'pageshow', showScores);

function showScores() {
    var quizName = window.currentQuizOriginal.name;
    if (!displayChart(quizName)) {
        $.mobile.changePage('#takeTestPage', {
            changeHash : false
        });
        $().toastmessage('showNoticeToast',
                'No scores found. Please take the quiz at least once');
    }
}

// Export the Symbols to prevent JS optimization removing functions
$(function() {
    window['startTest'] = startTest;
    window['startPracticeTest'] = startPracticeTest;
    window['previousQuestion'] = previousQuestion;
    window['nextQuestion'] = nextQuestion;
    window['findVariables'] = findVariables;
});

function areAllVariablesSet() {
    var globalVariables = window.localStorage.getObject('globalVariables');
    if (!globalVariables)
        return false;
    for ( var idx in globalVariables) {
        var varVal = globalVariables[idx];
        if (!varVal)
            return false;
    }
    return true;
}