// ThreeSVG.js r47 - http://github.com/mrdoob/three.js
'use strict';var THREE=THREE||{};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;
(function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c)window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"RequestCancelAnimationFrame"];if(!window.requestAnimationFrame)window.requestAnimationFrame=function(b){var c=(new Date).getTime(),f=Math.max(0,16-(c-a)),g=window.setTimeout(function(){b(c+f)},f);a=c+f;return g};if(!window.cancelAnimationFrame)window.cancelAnimationFrame=
function(a){clearTimeout(a)}})();THREE.Color=function(a){void 0!==a&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},copyGammaToLinear:function(a){this.r=a.r*a.r;this.g=a.g*a.g;this.b=a.b*a.b;return this},copyLinearToGamma:function(a){this.r=Math.sqrt(a.r);this.g=Math.sqrt(a.g);this.b=Math.sqrt(a.b);return this},convertGammaToLinear:function(){var a=this.r,b=this.g,c=this.b;this.r=a*a;this.g=b*b;this.b=c*c;return this},convertLinearToGamma:function(){this.r=Math.sqrt(this.r);this.g=Math.sqrt(this.g);
this.b=Math.sqrt(this.b);return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,e,f;if(0===c)this.r=this.g=this.b=0;else switch(d=Math.floor(6*a),e=6*a-d,a=c*(1-b),f=c*(1-b*e),b=c*(1-b*(1-e)),d){case 1:this.r=f;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=f;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=c;this.g=a;this.b=f;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=
Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return Math.floor(255*this.r)<<16^Math.floor(255*this.g)<<8^Math.floor(255*this.b)},getContextStyle:function(){return"rgb("+Math.floor(255*this.r)+","+Math.floor(255*this.g)+","+Math.floor(255*this.b)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
equals:function(a){return a.x===this.x&&a.y===this.y}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},
addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.z=this.y=this.x=0;return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},
cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.x=c*a.z-d*a.y;this.y=d*a.x-b*a.z;this.z=b*a.y-c*a.x;return this},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);
this.y=Math.asin(a.n13);1.0E-5<Math.abs(b)?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return 1.0E-4>this.lengthSq()}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=void 0!==d?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=void 0!==a.w?a.w:1},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-
b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Frustum=function(){this.planes=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4]};
THREE.Frustum.prototype.setFromMatrix=function(a){var b,c=this.planes;c[0].set(a.n41-a.n11,a.n42-a.n12,a.n43-a.n13,a.n44-a.n14);c[1].set(a.n41+a.n11,a.n42+a.n12,a.n43+a.n13,a.n44+a.n14);c[2].set(a.n41+a.n21,a.n42+a.n22,a.n43+a.n23,a.n44+a.n24);c[3].set(a.n41-a.n21,a.n42-a.n22,a.n43-a.n23,a.n44-a.n24);c[4].set(a.n41-a.n31,a.n42-a.n32,a.n43-a.n33,a.n44-a.n34);c[5].set(a.n41+a.n31,a.n42+a.n32,a.n43+a.n33,a.n44+a.n34);for(a=0;6>a;a++)b=c[a],b.divideScalar(Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z))};
THREE.Frustum.prototype.contains=function(a){for(var b=this.planes,c=a.matrixWorld,d=THREE.Frustum.__v1.set(c.getColumnX().length(),c.getColumnY().length(),c.getColumnZ().length()),d=-a.geometry.boundingSphere.radius*Math.max(d.x,Math.max(d.y,d.z)),e=0;6>e;e++)if(a=b[e].x*c.n14+b[e].y*c.n24+b[e].z*c.n34+b[e].w,a<=d)return!1;return!0};THREE.Frustum.__v1=new THREE.Vector3;
THREE.Ray=function(a,b){function c(a,b,c){k.sub(c,a);q=k.dot(b);y=p.add(a,o.copy(b).multiplyScalar(q));return u=c.distanceTo(y)}function d(a,b,c,d){k.sub(d,b);p.sub(c,b);o.sub(a,b);E=k.dot(k);t=k.dot(p);v=k.dot(o);B=p.dot(p);w=p.dot(o);z=1/(E*B-t*t);G=(B*v-t*w)*z;C=(E*w-t*v)*z;return 0<=G&&0<=C&&1>G+C}this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3;this.intersectScene=function(a){return this.intersectObjects(a.children)};this.intersectObjects=function(a){var b,c,d=[];for(b=0,
c=a.length;b<c;b++)Array.prototype.push.apply(d,this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d};var e=new THREE.Vector3,f=new THREE.Vector3,g=new THREE.Vector3,h=new THREE.Vector3,l=new THREE.Vector3,j=new THREE.Vector3,i=new THREE.Vector3,m=new THREE.Vector3,n=new THREE.Vector3;this.intersectObject=function(a){for(var b,k=[],o=0,p=a.children.length;o<p;o++)Array.prototype.push.apply(k,this.intersectObject(a.children[o]));if(a instanceof THREE.Particle){o=
c(this.origin,this.direction,a.matrixWorld.getPosition());if(o>a.scale.x)return[];b={distance:o,point:a.position,face:null,object:a};k.push(b)}else if(a instanceof THREE.Mesh){o=c(this.origin,this.direction,a.matrixWorld.getPosition());p=THREE.Frustum.__v1.set(a.matrixWorld.getColumnX().length(),a.matrixWorld.getColumnY().length(),a.matrixWorld.getColumnZ().length());if(o>a.geometry.boundingSphere.radius*Math.max(p.x,Math.max(p.y,p.z)))return k;var q,t,v=a.geometry,u=v.vertices,r;a.matrixRotationWorld.extractRotation(a.matrixWorld);
for(o=0,p=v.faces.length;o<p;o++)if(b=v.faces[o],l.copy(this.origin),j.copy(this.direction),r=a.matrixWorld,i=r.multiplyVector3(i.copy(b.centroid)).subSelf(l),m=a.matrixRotationWorld.multiplyVector3(m.copy(b.normal)),q=j.dot(m),!(1.0E-4>Math.abs(q))&&(t=m.dot(i)/q,!(0>t)&&(a.doubleSided||(a.flipSided?0<q:0>q))))if(n.add(l,j.multiplyScalar(t)),b instanceof THREE.Face3)e=r.multiplyVector3(e.copy(u[b.a].position)),f=r.multiplyVector3(f.copy(u[b.b].position)),g=r.multiplyVector3(g.copy(u[b.c].position)),
d(n,e,f,g)&&(b={distance:l.distanceTo(n),point:n.clone(),face:b,object:a},k.push(b));else if(b instanceof THREE.Face4&&(e=r.multiplyVector3(e.copy(u[b.a].position)),f=r.multiplyVector3(f.copy(u[b.b].position)),g=r.multiplyVector3(g.copy(u[b.c].position)),h=r.multiplyVector3(h.copy(u[b.d].position)),d(n,e,f,h)||d(n,f,g,h)))b={distance:l.distanceTo(n),point:n.clone(),face:b,object:a},k.push(b)}return k};var k=new THREE.Vector3,p=new THREE.Vector3,o=new THREE.Vector3,q,y,u,E,t,v,B,w,z,G,C};
THREE.Rectangle=function(){function a(){f=d-b;g=e-c}var b,c,d,e,f,g,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return f};this.getHeight=function(){return g};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(f,g,i,m){h=!1;b=f;c=g;d=i;e=m;a()};this.addPoint=function(f,g){h?(h=!1,b=f,c=g,d=f,e=g):(b=b<f?b:f,c=c<g?c:g,d=d>f?d:f,e=e>g?e:g);a()};this.add3Points=
function(f,g,i,m,n,k){h?(h=!1,b=f<i?f<n?f:n:i<n?i:n,c=g<m?g<k?g:k:m<k?m:k,d=f>i?f>n?f:n:i>n?i:n,e=g>m?g>k?g:k:m>k?m:k):(b=f<i?f<n?f<b?f:b:n<b?n:b:i<n?i<b?i:b:n<b?n:b,c=g<m?g<k?g<c?g:c:k<c?k:c:m<k?m<c?m:c:k<c?k:c,d=f>i?f>n?f>d?f:d:n>d?n:d:i>n?i>d?i:d:n>d?n:d,e=g>m?g>k?g>e?g:e:k>e?k:e:m>k?m>e?m:e:k>e?k:e);a()};this.addRectangle=function(f){h?(h=!1,b=f.getLeft(),c=f.getTop(),d=f.getRight(),e=f.getBottom()):(b=b<f.getLeft()?b:f.getLeft(),c=c<f.getTop()?c:f.getTop(),d=d>f.getRight()?d:f.getRight(),e=e>
f.getBottom()?e:f.getBottom());a()};this.inflate=function(f){b-=f;c-=f;d+=f;e+=f;a()};this.minSelf=function(f){b=b>f.getLeft()?b:f.getLeft();c=c>f.getTop()?c:f.getTop();d=d<f.getRight()?d:f.getRight();e=e<f.getBottom()?e:f.getBottom();a()};this.intersects=function(a){return d<a.getLeft()||b>a.getRight()||e<a.getTop()||c>a.getBottom()?!1:!0};this.empty=function(){h=!0;e=d=c=b=0;a()};this.isEmpty=function(){return h}};
THREE.Math={clamp:function(a,b,c){return a<b?b:a>c?c:a},clampBottom:function(a,b){return a<b?b:a},mapLinear:function(a,b,c,d,e){return d+(a-b)*(e-d)/(c-b)},random16:function(){return(65280*Math.random()+255*Math.random())/65535},randInt:function(a,b){return a+Math.floor(Math.random()*(b-a+1))},randFloat:function(a,b){return a+Math.random()*(b-a)},randFloatSpread:function(a){return a*(0.5-Math.random())}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,e,f,g,h,l,j,i,m,n,k,p,o){this.set(void 0!==a?a:1,b||0,c||0,d||0,e||0,void 0!==f?f:1,g||0,h||0,l||0,j||0,void 0!==i?i:1,m||0,n||0,k||0,p||0,void 0!==o?o:1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,e,f,g,h,l,j,i,m,n,k,p,o){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=f;this.n23=g;this.n24=h;this.n31=l;this.n32=j;this.n33=i;this.n34=m;this.n41=n;this.n42=k;this.n43=p;this.n44=o;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,f=THREE.Matrix4.__v3;f.sub(a,b).normalize();if(0===f.length())f.z=1;d.cross(c,f).normalize();0===d.length()&&(f.x+=1.0E-4,d.cross(c,f).normalize());e.cross(f,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=f.x;this.n21=d.y;this.n22=e.y;this.n23=f.y;this.n31=d.z;this.n32=e.z;this.n33=f.z;return this},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,f=a.n14,g=a.n21,h=a.n22,l=a.n23,j=a.n24,i=a.n31,m=a.n32,n=a.n33,k=a.n34,p=a.n41,o=a.n42,q=a.n43,
y=a.n44,u=b.n11,E=b.n12,t=b.n13,v=b.n14,B=b.n21,w=b.n22,z=b.n23,G=b.n24,C=b.n31,I=b.n32,A=b.n33,K=b.n34,M=b.n41,L=b.n42,Q=b.n43,S=b.n44;this.n11=c*u+d*B+e*C+f*M;this.n12=c*E+d*w+e*I+f*L;this.n13=c*t+d*z+e*A+f*Q;this.n14=c*v+d*G+e*K+f*S;this.n21=g*u+h*B+l*C+j*M;this.n22=g*E+h*w+l*I+j*L;this.n23=g*t+h*z+l*A+j*Q;this.n24=g*v+h*G+l*K+j*S;this.n31=i*u+m*B+n*C+k*M;this.n32=i*E+m*w+n*I+k*L;this.n33=i*t+m*z+n*A+k*Q;this.n34=i*v+m*G+n*K+k*S;this.n41=p*u+o*B+q*C+y*M;this.n42=p*E+o*w+q*I+y*L;this.n43=p*t+o*
z+q*A+y*Q;this.n44=p*v+o*G+q*K+y*S;return this},multiplySelf:function(a){return this.multiply(this,a)},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=
a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*
c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*
a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,f=this.n22,g=this.n23,h=this.n24,l=this.n31,j=this.n32,i=this.n33,m=this.n34,n=this.n41,k=this.n42,p=this.n43,o=this.n44;return d*g*j*n-c*h*j*n-d*f*i*n+b*h*i*n+c*f*m*n-b*g*m*n-d*g*l*k+c*h*l*k+d*e*i*k-a*h*i*k-c*e*m*k+a*g*m*k+d*f*l*p-b*h*l*p-d*e*j*p+a*h*j*p+b*e*m*p-a*f*m*p-c*f*l*o+b*g*l*o+c*e*j*o-a*g*j*o-b*e*i*o+a*f*i*o},transpose:function(){var a;
a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n34=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;
a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;
a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},
setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},
setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,f=a.x,g=a.y,h=a.z,l=e*f,j=e*g;this.set(l*f+c,l*g-d*h,l*h+d*g,0,l*g+d*h,j*g+c,j*h-d*f,0,l*h-d*g,j*h+d*f,e*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){return THREE.Matrix4.__v1.set(this.n14,this.n24,this.n34)},getColumnX:function(){return THREE.Matrix4.__v1.set(this.n11,this.n21,this.n31)},getColumnY:function(){return THREE.Matrix4.__v1.set(this.n12,
this.n22,this.n32)},getColumnZ:function(){return THREE.Matrix4.__v1.set(this.n13,this.n23,this.n33)},getInverse:function(a){var b=a.n11,c=a.n12,d=a.n13,e=a.n14,f=a.n21,g=a.n22,h=a.n23,l=a.n24,j=a.n31,i=a.n32,m=a.n33,n=a.n34,k=a.n41,p=a.n42,o=a.n43,q=a.n44;this.n11=h*n*p-l*m*p+l*i*o-g*n*o-h*i*q+g*m*q;this.n12=e*m*p-d*n*p-e*i*o+c*n*o+d*i*q-c*m*q;this.n13=d*l*p-e*h*p+e*g*o-c*l*o-d*g*q+c*h*q;this.n14=e*h*i-d*l*i-e*g*m+c*l*m+d*g*n-c*h*n;this.n21=l*m*k-h*n*k-l*j*o+f*n*o+h*j*q-f*m*q;this.n22=d*n*k-e*m*k+
e*j*o-b*n*o-d*j*q+b*m*q;this.n23=e*h*k-d*l*k-e*f*o+b*l*o+d*f*q-b*h*q;this.n24=d*l*j-e*h*j+e*f*m-b*l*m-d*f*n+b*h*n;this.n31=g*n*k-l*i*k+l*j*p-f*n*p-g*j*q+f*i*q;this.n32=e*i*k-c*n*k-e*j*p+b*n*p+c*j*q-b*i*q;this.n33=c*l*k-e*g*k+e*f*p-b*l*p-c*f*q+b*g*q;this.n34=e*g*j-c*l*j-e*f*i+b*l*i+c*f*n-b*g*n;this.n41=h*i*k-g*m*k-h*j*p+f*m*p+g*j*o-f*i*o;this.n42=c*m*k-d*i*k+d*j*p-b*m*p-c*j*o+b*i*o;this.n43=d*g*k-c*h*k-d*f*p+b*h*p+c*f*o-b*g*o;this.n44=c*h*j-d*g*j+d*f*i-b*h*i-c*f*m+b*g*m;this.multiplyScalar(1/a.determinant());
return this},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,e=a.z,f=Math.cos(c),c=Math.sin(c),g=Math.cos(d),d=Math.sin(d),h=Math.cos(e),e=Math.sin(e);switch(b){case "YXZ":var l=g*h,j=g*e,i=d*h,m=d*e;this.n11=l+m*c;this.n12=i*c-j;this.n13=f*d;this.n21=f*e;this.n22=f*h;this.n23=-c;this.n31=j*c-i;this.n32=m+l*c;this.n33=f*g;break;case "ZXY":l=g*h;j=g*e;i=d*h;m=d*e;this.n11=l-m*c;this.n12=-f*e;this.n13=i+j*c;this.n21=j+i*c;this.n22=f*h;this.n23=m-l*c;this.n31=-f*d;this.n32=c;this.n33=f*g;break;case "ZYX":l=
f*h;j=f*e;i=c*h;m=c*e;this.n11=g*h;this.n12=i*d-j;this.n13=l*d+m;this.n21=g*e;this.n22=m*d+l;this.n23=j*d-i;this.n31=-d;this.n32=c*g;this.n33=f*g;break;case "YZX":l=f*g;j=f*d;i=c*g;m=c*d;this.n11=g*h;this.n12=m-l*e;this.n13=i*e+j;this.n21=e;this.n22=f*h;this.n23=-c*h;this.n31=-d*h;this.n32=j*e+i;this.n33=l-m*e;break;case "XZY":l=f*g;j=f*d;i=c*g;m=c*d;this.n11=g*h;this.n12=-e;this.n13=d*h;this.n21=l*e+m;this.n22=f*h;this.n23=j*e-i;this.n31=i*e-j;this.n32=c*h;this.n33=m*e+l;break;default:l=f*h,j=f*
e,i=c*h,m=c*e,this.n11=g*h,this.n12=-g*e,this.n13=d,this.n21=j+i*d,this.n22=l-m*d,this.n23=-c*g,this.n31=m-l*d,this.n32=i+j*d,this.n33=f*g}return this},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,f=b+b,g=c+c,h=d+d,a=b*f,l=b*g,b=b*h,j=c*g,c=c*h,d=d*h,f=e*f,g=e*g,e=e*h;this.n11=1-(j+d);this.n12=l-e;this.n13=b+g;this.n21=l+e;this.n22=1-(a+d);this.n23=c-f;this.n31=b-g;this.n32=c+f;this.n33=1-(a+j);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=
a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},compose:function(a,b,c){var d=THREE.Matrix4.__m1,e=THREE.Matrix4.__m2;d.identity();d.setRotationFromQuaternion(b);e.setScale(c.x,c.y,c.z);this.multiply(d,e);this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},decompose:function(a,b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,f=THREE.Matrix4.__v3;d.set(this.n11,this.n21,this.n31);e.set(this.n12,this.n22,this.n32);f.set(this.n13,
this.n23,this.n33);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;c.x=d.length();c.y=e.length();c.z=f.length();a.x=this.n14;a.y=this.n24;a.z=this.n34;d=THREE.Matrix4.__m1;d.copy(this);d.n11/=c.x;d.n21/=c.x;d.n31/=c.x;d.n12/=c.y;d.n22/=c.y;d.n32/=c.y;d.n13/=c.z;d.n23/=c.z;d.n33/=c.z;b.setFromRotationMatrix(d);return[a,b,c]},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34;
return this},extractRotation:function(a){var b=THREE.Matrix4.__v1,c=1/b.set(a.n11,a.n21,a.n31).length(),d=1/b.set(a.n12,a.n22,a.n32).length(),b=1/b.set(a.n13,a.n23,a.n33).length();this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*b;this.n23=a.n23*b;this.n33=a.n33*b;return this},rotateByAxis:function(a,b){if(1===a.x&&0===a.y&&0===a.z)return this.rotateX(b);if(0===a.x&&1===a.y&&0===a.z)return this.rotateY(b);if(0===a.x&&0===a.y&&1===
a.z)return this.rotateZ(b);var c=a.x,d=a.y,e=a.z,f=Math.sqrt(c*c+d*d+e*e),c=c/f,d=d/f,e=e/f,f=c*c,g=d*d,h=e*e,l=Math.cos(b),j=Math.sin(b),i=1-l,m=c*d*i,n=c*e*i,i=d*e*i,c=c*j,k=d*j,j=e*j,e=f+(1-f)*l,f=m+j,d=n-k,m=m-j,g=g+(1-g)*l,j=i+c,n=n+k,i=i-c,h=h+(1-h)*l,l=this.n11,c=this.n21,k=this.n31,p=this.n41,o=this.n12,q=this.n22,y=this.n32,u=this.n42,E=this.n13,t=this.n23,v=this.n33,B=this.n43;this.n11=e*l+f*o+d*E;this.n21=e*c+f*q+d*t;this.n31=e*k+f*y+d*v;this.n41=e*p+f*u+d*B;this.n12=m*l+g*o+j*E;this.n22=
m*c+g*q+j*t;this.n32=m*k+g*y+j*v;this.n42=m*p+g*u+j*B;this.n13=n*l+i*o+h*E;this.n23=n*c+i*q+h*t;this.n33=n*k+i*y+h*v;this.n43=n*p+i*u+h*B;return this},rotateX:function(a){var b=this.n12,c=this.n22,d=this.n32,e=this.n42,f=this.n13,g=this.n23,h=this.n33,l=this.n43,j=Math.cos(a),a=Math.sin(a);this.n12=j*b+a*f;this.n22=j*c+a*g;this.n32=j*d+a*h;this.n42=j*e+a*l;this.n13=j*f-a*b;this.n23=j*g-a*c;this.n33=j*h-a*d;this.n43=j*l-a*e;return this},rotateY:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,
f=this.n13,g=this.n23,h=this.n33,l=this.n43,j=Math.cos(a),a=Math.sin(a);this.n11=j*b-a*f;this.n21=j*c-a*g;this.n31=j*d-a*h;this.n41=j*e-a*l;this.n13=j*f+a*b;this.n23=j*g+a*c;this.n33=j*h+a*d;this.n43=j*l+a*e;return this},rotateZ:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,f=this.n12,g=this.n22,h=this.n32,l=this.n42,j=Math.cos(a),a=Math.sin(a);this.n11=j*b+a*f;this.n21=j*c+a*g;this.n31=j*d+a*h;this.n41=j*e+a*l;this.n12=j*f-a*b;this.n22=j*g-a*c;this.n32=j*h-a*d;this.n42=j*l-a*e;return this},
translate:function(a){var b=a.x,c=a.y,a=a.z;this.n14=this.n11*b+this.n12*c+this.n13*a+this.n14;this.n24=this.n21*b+this.n22*c+this.n23*a+this.n24;this.n34=this.n31*b+this.n32*c+this.n33*a+this.n34;this.n44=this.n41*b+this.n42*c+this.n43*a+this.n44;return this}};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,f=a.n32*a.n21-a.n31*a.n22,g=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,l=-a.n32*a.n11+a.n31*a.n12,j=a.n23*a.n12-a.n22*a.n13,i=-a.n23*a.n11+a.n21*a.n13,m=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*g+a.n31*j;if(0===a)return null;a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*f;c[3]=a*g;c[4]=a*h;c[5]=a*l;c[6]=a*j;c[7]=a*i;c[8]=a*m;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,f){var g;g=new THREE.Matrix4;g.n11=2*e/(b-a);g.n12=0;g.n13=(b+a)/(b-a);g.n14=0;g.n21=0;g.n22=2*e/(d-c);g.n23=(d+c)/(d-c);g.n24=0;g.n31=0;g.n32=0;g.n33=-(f+e)/(f-e);g.n34=-2*f*e/(f-e);g.n41=0;g.n42=0;g.n43=-1;g.n44=0;return g};THREE.Matrix4.makePerspective=function(a,b,c,d){var e,a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,f){var g,h,l,j;g=new THREE.Matrix4;h=b-a;l=c-d;j=f-e;g.n11=2/h;g.n12=0;g.n13=0;g.n14=-((b+a)/h);g.n21=0;g.n22=2/l;g.n23=0;g.n24=-((c+d)/l);g.n31=0;g.n32=0;g.n33=-2/j;g.n34=-((f+e)/j);g.n41=0;g.n42=0;g.n43=0;g.n44=1;return g};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.name="";this.id=THREE.Object3DCount++;this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},add:function(a){if(-1===
this.children.indexOf(a)){void 0!==a.parent&&a.parent.remove(a);a.parent=this;this.children.push(a);for(var b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.addObject(a)}},remove:function(a){var b=this.children.indexOf(a);if(-1!==b){a.parent=void 0;this.children.splice(b,1);for(b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.removeObject(a)}},getChildByName:function(a,b){var c,d,e;for(c=0,d=this.children.length;c<d;c++){e=this.children[c];if(e.name===
a||b&&(e=e.getChildByName(a,b),void 0!==e))return e}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(1!==this.scale.x||1!==this.scale.y||1!==this.scale.z)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(a){this.matrixAutoUpdate&&
this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,a=!0;for(var b=0,c=this.children.length;b<c;b++)this.children[b].updateMatrixWorld(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=g[f]=g[f]||new THREE.RenderableObject;f++;return a}function b(){var a=j[l]=j[l]||new THREE.RenderableVertex;l++;return a}function c(a,b){return b.z-a.z}function d(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;if(0<=e&&0<=f&&0<=g&&0<=h)return!0;if(0>e&&0>f||0>g&&0>h)return!1;0>e?c=Math.max(c,e/(e-f)):0>f&&(d=Math.min(d,e/(e-f)));0>g?c=Math.max(c,g/(g-h)):0>h&&(d=Math.min(d,g/(g-h)));if(d<c)return!1;a.lerpSelf(b,c);b.lerpSelf(a,1-d);return!0}
var e,f,g=[],h,l,j=[],i,m,n=[],k,p=[],o,q,y=[],u,E,t=[],v={objects:[],sprites:[],lights:[],elements:[]},B=new THREE.Vector3,w=new THREE.Vector4,z=new THREE.Matrix4,G=new THREE.Matrix4,C=new THREE.Frustum,I=new THREE.Vector4,A=new THREE.Vector4;this.projectVector=function(a,b){b.matrixWorldInverse.getInverse(b.matrixWorld);z.multiply(b.projectionMatrix,b.matrixWorldInverse);z.multiplyVector3(a);return a};this.unprojectVector=function(a,b){b.projectionMatrixInverse.getInverse(b.projectionMatrix);z.multiply(b.matrixWorld,
b.projectionMatrixInverse);z.multiplyVector3(a);return a};this.pickingRay=function(a,b){var c;a.z=-1;c=new THREE.Vector3(a.x,a.y,1);this.unprojectVector(a,b);this.unprojectVector(c,b);c.subSelf(a).normalize();return new THREE.Ray(a,c)};this.projectGraph=function(b,d){f=0;v.objects.length=0;v.sprites.length=0;v.lights.length=0;var g=function(b){if(!1!==b.visible){(b instanceof THREE.Mesh||b instanceof THREE.Line)&&(!1===b.frustumCulled||C.contains(b))?(z.multiplyVector3(B.copy(b.position)),e=a(),e.object=
b,e.z=B.z,v.objects.push(e)):b instanceof THREE.Sprite||b instanceof THREE.Particle?(z.multiplyVector3(B.copy(b.position)),e=a(),e.object=b,e.z=B.z,v.sprites.push(e)):b instanceof THREE.Light&&v.lights.push(b);for(var c=0,d=b.children.length;c<d;c++)g(b.children[c])}};g(b);d&&v.objects.sort(c);return v};this.projectScene=function(a,e,f){var g=e.near,B=e.far,T,N,r,s,x,D,F,J,H,O,P,U,X,V,W,R;E=q=k=m=0;v.elements.length=0;void 0===e.parent&&(console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it..."),
a.add(e));a.updateMatrixWorld();e.matrixWorldInverse.getInverse(e.matrixWorld);z.multiply(e.projectionMatrix,e.matrixWorldInverse);C.setFromMatrix(z);v=this.projectGraph(a,!1);for(a=0,T=v.objects.length;a<T;a++)if(H=v.objects[a].object,O=H.matrixWorld,U=H.material,l=0,H instanceof THREE.Mesh){P=H.geometry;X=H.geometry.materials;s=P.vertices;V=P.faces;W=P.faceVertexUvs;P=H.matrixRotationWorld.extractRotation(O);for(N=0,r=s.length;N<r;N++)h=b(),h.positionWorld.copy(s[N].position),O.multiplyVector3(h.positionWorld),
h.positionScreen.copy(h.positionWorld),z.multiplyVector4(h.positionScreen),h.positionScreen.x/=h.positionScreen.w,h.positionScreen.y/=h.positionScreen.w,h.visible=h.positionScreen.z>g&&h.positionScreen.z<B;for(s=0,N=V.length;s<N;s++){r=V[s];if(r instanceof THREE.Face3)if(x=j[r.a],D=j[r.b],F=j[r.c],x.visible&&D.visible&&F.visible&&(H.doubleSided||H.flipSided!=0>(F.positionScreen.x-x.positionScreen.x)*(D.positionScreen.y-x.positionScreen.y)-(F.positionScreen.y-x.positionScreen.y)*(D.positionScreen.x-
x.positionScreen.x)))J=n[m]=n[m]||new THREE.RenderableFace3,m++,i=J,i.v1.copy(x),i.v2.copy(D),i.v3.copy(F);else continue;else if(r instanceof THREE.Face4)if(x=j[r.a],D=j[r.b],F=j[r.c],J=j[r.d],x.visible&&D.visible&&F.visible&&J.visible&&(H.doubleSided||H.flipSided!=(0>(J.positionScreen.x-x.positionScreen.x)*(D.positionScreen.y-x.positionScreen.y)-(J.positionScreen.y-x.positionScreen.y)*(D.positionScreen.x-x.positionScreen.x)||0>(D.positionScreen.x-F.positionScreen.x)*(J.positionScreen.y-F.positionScreen.y)-
(D.positionScreen.y-F.positionScreen.y)*(J.positionScreen.x-F.positionScreen.x))))R=p[k]=p[k]||new THREE.RenderableFace4,k++,i=R,i.v1.copy(x),i.v2.copy(D),i.v3.copy(F),i.v4.copy(J);else continue;i.normalWorld.copy(r.normal);P.multiplyVector3(i.normalWorld);i.centroidWorld.copy(r.centroid);O.multiplyVector3(i.centroidWorld);i.centroidScreen.copy(i.centroidWorld);z.multiplyVector3(i.centroidScreen);F=r.vertexNormals;for(x=0,D=F.length;x<D;x++)J=i.vertexNormalsWorld[x],J.copy(F[x]),P.multiplyVector3(J);
for(x=0,D=W.length;x<D;x++)if(R=W[x][s])for(F=0,J=R.length;F<J;F++)i.uvs[x][F]=R[F];i.material=U;i.faceMaterial=null!==r.materialIndex?X[r.materialIndex]:null;i.z=i.centroidScreen.z;v.elements.push(i)}}else if(H instanceof THREE.Line){G.multiply(z,O);s=H.geometry.vertices;x=b();x.positionScreen.copy(s[0].position);G.multiplyVector4(x.positionScreen);for(N=1,r=s.length;N<r;N++)if(x=b(),x.positionScreen.copy(s[N].position),G.multiplyVector4(x.positionScreen),D=j[l-2],I.copy(x.positionScreen),A.copy(D.positionScreen),
d(I,A))I.multiplyScalar(1/I.w),A.multiplyScalar(1/A.w),H=y[q]=y[q]||new THREE.RenderableLine,q++,o=H,o.v1.positionScreen.copy(I),o.v2.positionScreen.copy(A),o.z=Math.max(I.z,A.z),o.material=U,v.elements.push(o)}for(a=0,T=v.sprites.length;a<T;a++)if(H=v.sprites[a].object,O=H.matrixWorld,H instanceof THREE.Particle&&(w.set(O.n14,O.n24,O.n34,1),z.multiplyVector4(w),w.z/=w.w,0<w.z&&1>w.z))g=t[E]=t[E]||new THREE.RenderableParticle,E++,u=g,u.x=w.x/w.w,u.y=w.y/w.w,u.z=w.z,u.rotation=H.rotation.z,u.scale.x=
H.scale.x*Math.abs(u.x-(w.x+e.projectionMatrix.n11)/(w.w+e.projectionMatrix.n14)),u.scale.y=H.scale.y*Math.abs(u.y-(w.y+e.projectionMatrix.n22)/(w.w+e.projectionMatrix.n24)),u.material=H.material,v.elements.push(u);f&&v.elements.sort(c);return v}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,void 0!==d?d:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),f=Math.cos(c),c=Math.sin(c),g=a*b,h=d*e;this.w=g*f-h*c;this.x=g*c+h*f;this.y=d*b*f+a*e*c;this.z=a*e*f-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);
this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.n11+a.n22+a.n33))/2;this.x=Math.sqrt(Math.max(0,b+a.n11-a.n22-a.n33))/2;this.y=Math.sqrt(Math.max(0,b-a.n11+a.n22-a.n33))/2;this.z=Math.sqrt(Math.max(0,b-a.n11-a.n22+a.n33))/2;this.x=0>a.n32-a.n23?-Math.abs(this.x):Math.abs(this.x);this.y=0>a.n13-a.n31?-Math.abs(this.y):Math.abs(this.y);this.z=0>a.n21-a.n12?-Math.abs(this.z):Math.abs(this.z);
this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);0===a?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},multiplySelf:function(a){var b=
this.x,c=this.y,d=this.z,e=this.w,f=a.x,g=a.y,h=a.z,a=a.w;this.x=b*a+e*f+c*h-d*g;this.y=c*a+e*g+d*f-b*h;this.z=d*a+e*h+b*g-c*f;this.w=e*a-b*f-c*g-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,f=this.x,g=this.y,h=this.z,l=this.w,j=l*c+g*e-h*d,i=l*d+h*c-f*e,m=l*e+f*d-g*c,c=-f*
c-g*d-h*e;b.x=j*l+c*-f+i*-h-m*-g;b.y=i*l+c*-g+m*-f-j*-h;b.z=m*l+c*-h+j*-g-i*-f;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;0>e?(c.w=-b.w,c.x=-b.x,c.y=-b.y,c.z=-b.z,e=-e):c.copy(b);if(1<=Math.abs(e))return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var f=Math.acos(e),e=Math.sqrt(1-e*e);if(0.001>Math.abs(e))return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;b=Math.sin((1-d)*f)/e;d=Math.sin(d*f)/e;c.w=a.w*b+c.w*d;c.x=a.x*b+c.x*d;c.y=a.y*b+c.y*d;c.z=a.z*b+c.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,d,e,f){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materialIndex=f;this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,e,f,g){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materialIndex=g;this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};
THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.materials=[];this.faces=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a,new THREE.Vector3(1,1,1));for(var c=0,d=this.vertices.length;c<d;c++)a.multiplyVector3(this.vertices[c].position);c=0;for(d=this.faces.length;c<d;c++){var e=this.faces[c];b.multiplyVector3(e.normal);for(var f=0,g=e.vertexNormals.length;f<g;f++)b.multiplyVector3(e.vertexNormals[f]);a.multiplyVector3(e.centroid)}},computeCentroids:function(){var a,b,c;for(a=0,b=this.faces.length;a<
b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(){var a,
b,c,d,e,f,g=new THREE.Vector3,h=new THREE.Vector3;for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],d=this.vertices[c.a],e=this.vertices[c.b],f=this.vertices[c.c],g.sub(f.position,e.position),h.sub(d.position,e.position),g.crossSelf(h),g.isZero()||g.normalize(),c.normal.copy(g)},computeVertexNormals:function(){var a,b,c,d;if(void 0===this.__tmpVertices){d=this.__tmpVertices=Array(this.vertices.length);for(a=0,b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;for(a=0,b=this.faces.length;a<b;a++)if(c=
this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=this.__tmpVertices;for(a=0,b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),
d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));for(a=0,b=this.vertices.length;a<b;a++)d[a].normalize();for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,
b,c,d,e,f,D){h=a.vertices[b].position;l=a.vertices[c].position;j=a.vertices[d].position;i=g[e];m=g[f];n=g[D];k=l.x-h.x;p=j.x-h.x;o=l.y-h.y;q=j.y-h.y;y=l.z-h.z;u=j.z-h.z;E=m.u-i.u;t=n.u-i.u;v=m.v-i.v;B=n.v-i.v;w=1/(E*B-t*v);I.set((B*k-v*p)*w,(B*o-v*q)*w,(B*y-v*u)*w);A.set((E*p-t*k)*w,(E*q-t*o)*w,(E*u-t*y)*w);G[b].addSelf(I);G[c].addSelf(I);G[d].addSelf(I);C[b].addSelf(A);C[c].addSelf(A);C[d].addSelf(A)}var b,c,d,e,f,g,h,l,j,i,m,n,k,p,o,q,y,u,E,t,v,B,w,z,G=[],C=[],I=new THREE.Vector3,A=new THREE.Vector3,
K=new THREE.Vector3,M=new THREE.Vector3,L=new THREE.Vector3;for(b=0,c=this.vertices.length;b<c;b++)G[b]=new THREE.Vector3,C[b]=new THREE.Vector3;for(b=0,c=this.faces.length;b<c;b++)f=this.faces[b],g=this.faceVertexUvs[0][b],f instanceof THREE.Face3?a(this,f.a,f.b,f.c,0,1,2):f instanceof THREE.Face4&&(a(this,f.a,f.b,f.c,0,1,2),a(this,f.a,f.b,f.d,0,1,3));var Q=["a","b","c","d"];for(b=0,c=this.faces.length;b<c;b++){f=this.faces[b];for(d=0;d<f.vertexNormals.length;d++)L.copy(f.vertexNormals[d]),e=f[Q[d]],
z=G[e],K.copy(z),K.subSelf(L.multiplyScalar(L.dot(z))).normalize(),M.cross(f.vertexNormals[d],z),e=M.dot(C[e]),e=0>e?-1:1,f.vertexTangents[d]=new THREE.Vector4(K.x,K.y,K.z,e)}this.hasTangents=!0},computeBoundingBox:function(){if(0<this.vertices.length){var a;a=this.vertices[0].position;this.boundingBox?(this.boundingBox.min.copy(a),this.boundingBox.max.copy(a)):this.boundingBox={min:a.clone(),max:a.clone()};for(var b=this.boundingBox.min,c=this.boundingBox.max,d=1,e=this.vertices.length;d<e;d++){a=
this.vertices[d].position;if(a.x<b.x)b.x=a.x;else if(a.x>c.x)c.x=a.x;if(a.y<b.y)b.y=a.y;else if(a.y>c.y)c.y=a.y;if(a.z<b.z)b.z=a.z;else if(a.z>c.z)c.z=a.z}}},computeBoundingSphere:function(){for(var a,b=0,c=0,d=this.vertices.length;c<d;c++)a=this.vertices[c].position.length(),a>b&&(b=a);this.boundingSphere={radius:b}},mergeVertices:function(){var a={},b=[],c=[],d,e=Math.pow(10,4),f,g;for(f=0,g=this.vertices.length;f<g;f++)d=this.vertices[f].position,d=[Math.round(d.x*e),Math.round(d.y*e),Math.round(d.z*
e)].join("_"),void 0===a[d]?(a[d]=f,b.push(this.vertices[f]),c[f]=b.length-1):c[f]=c[a[d]];for(f=0,g=this.faces.length;f<g;f++)if(a=this.faces[f],a instanceof THREE.Face3)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c];else if(a instanceof THREE.Face4)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c],a.d=c[a.d];this.vertices=b}};THREE.GeometryCount=0;
THREE.Camera=function(){if(arguments.length)return console.warn("DEPRECATED: Camera() is now PerspectiveCamera() or OrthographicCamera()."),new THREE.PerspectiveCamera(arguments[0],arguments[1],arguments[2],arguments[3]);THREE.Object3D.call(this);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4;this.projectionMatrixInverse=new THREE.Matrix4};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;
THREE.Camera.prototype.lookAt=function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)};THREE.OrthographicCamera=function(a,b,c,d,e,f){THREE.Camera.call(this);this.left=a;this.right=b;this.top=c;this.bottom=d;this.near=void 0!==e?e:0.1;this.far=void 0!==f?f:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=new THREE.Camera;THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;
THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.PerspectiveCamera=function(a,b,c,d){THREE.Camera.call(this);this.fov=void 0!==a?a:50;this.aspect=void 0!==b?b:1;this.near=void 0!==c?c:0.1;this.far=void 0!==d?d:2E3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=new THREE.Camera;THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;
THREE.PerspectiveCamera.prototype.setLens=function(a,b){this.fov=2*Math.atan((void 0!==b?b:43.25)/(2*a));this.fov*=180/Math.PI;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,d,e,f){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=e;this.height=f;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,
this.far)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0;this.onlyShadow=this.castShadow=!1;this.shadowCameraLeft=-500;this.shadowCameraTop=this.shadowCameraRight=500;this.shadowCameraBottom=-500;this.shadowCameraVisible=!1;this.shadowBias=0;this.shadowDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowMatrix=this.shadowCamera=this.shadowMapSize=
this.shadowMap=null};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.Material=function(a){a=a||{};this.name="";this.id=THREE.MaterialCount++;this.opacity=void 0!==a.opacity?a.opacity:1;this.transparent=void 0!==a.transparent?a.transparent:!1;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.depthTest=void 0!==a.depthTest?a.depthTest:!0;this.depthWrite=void 0!==a.depthWrite?a.depthWrite:!0;this.polygonOffset=void 0!==a.polygonOffset?a.polygonOffset:!1;this.polygonOffsetFactor=void 0!==a.polygonOffsetFactor?a.polygonOffsetFactor:0;this.polygonOffsetUnits=
void 0!==a.polygonOffsetUnits?a.polygonOffsetUnits:0;this.alphaTest=void 0!==a.alphaTest?a.alphaTest:0;this.overdraw=void 0!==a.overdraw?a.overdraw:!1};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=void 0!==a.linewidth?a.linewidth:1;this.linecap=void 0!==a.linecap?a.linecap:"round";this.linejoin=void 0!==a.linejoin?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:
!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=void 0!==a.ambient?new THREE.Color(a.ambient):new THREE.Color(328965);this.wrapAround=void 0!==a.wrapAround?a.wrapAround:!1;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;
this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:
"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=void 0!==a.ambient?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=void 0!==a.specular?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=void 0!==a.shininess?a.shininess:30;this.metal=void 0!==a.metal?a.metal:!1;this.perPixel=void 0!==a.perPixel?a.perPixel:!1;this.wrapAround=void 0!==a.wrapAround?a.wrapAround:
!1;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:
!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;
THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.size=void 0!==a.size?a.size:1;this.sizeAttenuation=void 0!==a.sizeAttenuation?a.sizeAttenuation:!0;this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.Texture=function(a,b,c,d,e,f,g,h){this.id=THREE.TextureCount++;this.image=a;this.mapping=void 0!==b?b:new THREE.UVMapping;this.wrapS=void 0!==c?c:THREE.ClampToEdgeWrapping;this.wrapT=void 0!==d?d:THREE.ClampToEdgeWrapping;this.magFilter=void 0!==e?e:THREE.LinearFilter;this.minFilter=void 0!==f?f:THREE.LinearMipMapLinearFilter;this.format=void 0!==g?g:THREE.RGBAFormat;this.type=void 0!==h?h:THREE.UnsignedByteType;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.generateMipmaps=
!0;this.needsUpdate=!1;this.onUpdate=null};THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter,this.format,this.type);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};
THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;
THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.material=b;this.type=void 0!==c?c:THREE.LineStrip;this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere())};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b;if(b instanceof Array)console.warn("DEPRECATED: Mesh material can no longer be an Array. Using material at index 0..."),this.material=b[0];if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};
for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;
THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(void 0!==this.morphTargetDictionary[a])return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var c,d=this.children.length;for(c=0;c<d;c++)this.children[c].update(this.skinMatrix,b)};
THREE.Sprite=function(a){THREE.Object3D.call(this);this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:new THREE.Texture;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.useScreenCoordinates=void 0!==a.useScreenCoordinates?a.useScreenCoordinates:!0;this.mergeWith3D=void 0!==a.mergeWith3D?a.mergeWith3D:!this.useScreenCoordinates;this.affectedByDistance=void 0!==a.affectedByDistance?a.affectedByDistance:!this.useScreenCoordinates;
this.scaleByViewport=void 0!==a.scaleByViewport?a.scaleByViewport:!this.affectedByDistance;this.alignment=a.alignment instanceof THREE.Vector2?a.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(1!==this.scale.x||1!==this.scale.y)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);
THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.overrideMaterial=this.fog=null;this.matrixAutoUpdate=!1;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.addObject=function(a){if(a instanceof THREE.Light)-1===this.lights.indexOf(a)&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&-1===this.objects.indexOf(a)){this.objects.push(a);this.__objectsAdded.push(a);var b=this.__objectsRemoved.indexOf(a);-1!==b&&this.__objectsRemoved.splice(b,1)}for(b=0;b<a.children.length;b++)this.addObject(a.children[b])};
THREE.Scene.prototype.removeObject=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);-1!==b&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),-1!==b&&(this.objects.splice(b,1),this.__objectsRemoved.push(a),b=this.__objectsAdded.indexOf(a),-1!==b&&this.__objectsAdded.splice(b,1)));for(b=0;b<a.children.length;b++)this.removeObject(a.children[b])};
THREE.SVGRenderer=function(){function a(a,b,c,d){var e,f,g,h,j,i;for(e=0,f=a.length;e<f;e++)g=a[e],h=g.color,g instanceof THREE.DirectionalLight?(j=g.matrixWorld.getPosition(),i=c.dot(j),0>=i||(i*=g.intensity,d.r+=h.r*i,d.g+=h.g*i,d.b+=h.b*i)):g instanceof THREE.PointLight&&(j=g.matrixWorld.getPosition(),i=c.dot(G.sub(j,b).normalize()),0>=i||(i*=0==g.distance?1:1-Math.min(b.distanceTo(j)/g.distance,1),0!=i&&(i*=g.intensity,d.r+=h.r*i,d.g+=h.g*i,d.b+=h.b*i)))}function b(a){null==C[a]&&(C[a]=document.createElementNS("http://www.w3.org/2000/svg",
"path"),0==L&&C[a].setAttribute("shape-rendering","crispEdges"));return C[a]}function c(a){a=0.5*(a+1);return 0>a?0:1<a?1:a}var d=this,e,f,g,h=new THREE.Projector,l=document.createElementNS("http://www.w3.org/2000/svg","svg"),j,i,m,n,k,p,o,q,y=new THREE.Rectangle,u=new THREE.Rectangle,E=!1,t=new THREE.Color,v=new THREE.Color,B=new THREE.Color,w=new THREE.Color,z,G=new THREE.Vector3,C=[],I=[],A,K,M,L=1;this.domElement=l;this.sortElements=this.sortObjects=this.autoClear=!0;this.info={render:{vertices:0,
faces:0}};this.setQuality=function(a){switch(a){case "high":L=1;break;case "low":L=0}};this.setSize=function(a,b){j=a;i=b;m=j/2;n=i/2;l.setAttribute("viewBox",-m+" "+-n+" "+j+" "+i);l.setAttribute("width",j);l.setAttribute("height",i);y.set(-m,-n,m,n)};this.clear=function(){for(;0<l.childNodes.length;)l.removeChild(l.childNodes[0])};this.render=function(i,j){var C,G,r,s;this.autoClear&&this.clear();d.info.render.vertices=0;d.info.render.faces=0;e=h.projectScene(i,j,this.sortElements);f=e.elements;
g=e.lights;M=K=0;if(E=0<g.length){v.setRGB(0,0,0);B.setRGB(0,0,0);w.setRGB(0,0,0);for(C=0,G=g.length;C<G;C++)s=g[C],r=s.color,s instanceof THREE.AmbientLight?(v.r+=r.r,v.g+=r.g,v.b+=r.b):s instanceof THREE.DirectionalLight?(B.r+=r.r,B.g+=r.g,B.b+=r.b):s instanceof THREE.PointLight&&(w.r+=r.r,w.g+=r.g,w.b+=r.b)}for(C=0,G=f.length;C<G;C++)if(r=f[C],s=r.material,s=s instanceof THREE.MeshFaceMaterial?r.faceMaterial:s,!(null==s||0==s.opacity))if(u.empty(),r instanceof THREE.RenderableParticle)k=r,k.x*=
m,k.y*=-n;else if(r instanceof THREE.RenderableLine){if(k=r.v1,p=r.v2,k.positionScreen.x*=m,k.positionScreen.y*=-n,p.positionScreen.x*=m,p.positionScreen.y*=-n,u.addPoint(k.positionScreen.x,k.positionScreen.y),u.addPoint(p.positionScreen.x,p.positionScreen.y),y.intersects(u)){r=k;var x=p,D=M++;null==I[D]&&(I[D]=document.createElementNS("http://www.w3.org/2000/svg","line"),0==L&&I[D].setAttribute("shape-rendering","crispEdges"));A=I[D];A.setAttribute("x1",r.positionScreen.x);A.setAttribute("y1",r.positionScreen.y);
A.setAttribute("x2",x.positionScreen.x);A.setAttribute("y2",x.positionScreen.y);s instanceof THREE.LineBasicMaterial&&(A.setAttribute("style","fill: none; stroke: "+s.color.getContextStyle()+"; stroke-width: "+s.linewidth+"; stroke-opacity: "+s.opacity+"; stroke-linecap: "+s.linecap+"; stroke-linejoin: "+s.linejoin),l.appendChild(A))}}else if(r instanceof THREE.RenderableFace3){if(k=r.v1,p=r.v2,o=r.v3,k.positionScreen.x*=m,k.positionScreen.y*=-n,p.positionScreen.x*=m,p.positionScreen.y*=-n,o.positionScreen.x*=
m,o.positionScreen.y*=-n,u.addPoint(k.positionScreen.x,k.positionScreen.y),u.addPoint(p.positionScreen.x,p.positionScreen.y),u.addPoint(o.positionScreen.x,o.positionScreen.y),y.intersects(u)){var x=k,D=p,F=o;d.info.render.vertices+=3;d.info.render.faces++;A=b(K++);A.setAttribute("d","M "+x.positionScreen.x+" "+x.positionScreen.y+" L "+D.positionScreen.x+" "+D.positionScreen.y+" L "+F.positionScreen.x+","+F.positionScreen.y+"z");s instanceof THREE.MeshBasicMaterial?t.copy(s.color):s instanceof THREE.MeshLambertMaterial?
E?(t.r=v.r,t.g=v.g,t.b=v.b,a(g,r.centroidWorld,r.normalWorld,t),t.r=Math.max(0,Math.min(s.color.r*t.r,1)),t.g=Math.max(0,Math.min(s.color.g*t.g,1)),t.b=Math.max(0,Math.min(s.color.b*t.b,1))):t.copy(s.color):s instanceof THREE.MeshDepthMaterial?(z=1-s.__2near/(s.__farPlusNear-r.z*s.__farMinusNear),t.setRGB(z,z,z)):s instanceof THREE.MeshNormalMaterial&&t.setRGB(c(r.normalWorld.x),c(r.normalWorld.y),c(r.normalWorld.z));s.wireframe?A.setAttribute("style","fill: none; stroke: "+t.getContextStyle()+"; stroke-width: "+
s.wireframeLinewidth+"; stroke-opacity: "+s.opacity+"; stroke-linecap: "+s.wireframeLinecap+"; stroke-linejoin: "+s.wireframeLinejoin):A.setAttribute("style","fill: "+t.getContextStyle()+"; fill-opacity: "+s.opacity);l.appendChild(A)}}else if(r instanceof THREE.RenderableFace4&&(k=r.v1,p=r.v2,o=r.v3,q=r.v4,k.positionScreen.x*=m,k.positionScreen.y*=-n,p.positionScreen.x*=m,p.positionScreen.y*=-n,o.positionScreen.x*=m,o.positionScreen.y*=-n,q.positionScreen.x*=m,q.positionScreen.y*=-n,u.addPoint(k.positionScreen.x,
k.positionScreen.y),u.addPoint(p.positionScreen.x,p.positionScreen.y),u.addPoint(o.positionScreen.x,o.positionScreen.y),u.addPoint(q.positionScreen.x,q.positionScreen.y),y.intersects(u))){var x=k,D=p,F=o,J=q;d.info.render.vertices+=4;d.info.render.faces++;A=b(K++);A.setAttribute("d","M "+x.positionScreen.x+" "+x.positionScreen.y+" L "+D.positionScreen.x+" "+D.positionScreen.y+" L "+F.positionScreen.x+","+F.positionScreen.y+" L "+J.positionScreen.x+","+J.positionScreen.y+"z");s instanceof THREE.MeshBasicMaterial?
t.copy(s.color):s instanceof THREE.MeshLambertMaterial?E?(t.r=v.r,t.g=v.g,t.b=v.b,a(g,r.centroidWorld,r.normalWorld,t),t.r=Math.max(0,Math.min(s.color.r*t.r,1)),t.g=Math.max(0,Math.min(s.color.g*t.g,1)),t.b=Math.max(0,Math.min(s.color.b*t.b,1))):t.copy(s.color):s instanceof THREE.MeshDepthMaterial?(z=1-s.__2near/(s.__farPlusNear-r.z*s.__farMinusNear),t.setRGB(z,z,z)):s instanceof THREE.MeshNormalMaterial&&t.setRGB(c(r.normalWorld.x),c(r.normalWorld.y),c(r.normalWorld.z));s.wireframe?A.setAttribute("style",
"fill: none; stroke: "+t.getContextStyle()+"; stroke-width: "+s.wireframeLinewidth+"; stroke-opacity: "+s.opacity+"; stroke-linecap: "+s.wireframeLinecap+"; stroke-linejoin: "+s.wireframeLinejoin):A.setAttribute("style","fill: "+t.getContextStyle()+"; fill-opacity: "+s.opacity);l.appendChild(A)}}};THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};
THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};THREE.RenderableObject=function(){this.z=this.object=null};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.material=null};
THREE.ImageUtils={crossOrigin:"",loadTexture:function(a,b,c){var d=new Image,e=new THREE.Texture(d,b);d.onload=function(){e.needsUpdate=!0;c&&c(this)};d.crossOrigin=this.crossOrigin;d.src=a;return e},loadTextureCube:function(a,b,c){var d,e=[],f=new THREE.Texture(e,b);e.loadCount=0;for(b=0,d=a.length;b<d;++b)e[b]=new Image,e[b].onload=function(){e.loadCount+=1;if(6===e.loadCount)f.needsUpdate=!0;c&&c(this)},e[b].crossOrigin="",e[b].src=a[b];return f},getNormalMap:function(a,b){var c=function(a){var b=
Math.sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2]);return[a[0]/b,a[1]/b,a[2]/b]},b=b|1,d=a.width,e=a.height,f=document.createElement("canvas");f.width=d;f.height=e;var g=f.getContext("2d");g.drawImage(a,0,0);for(var h=g.getImageData(0,0,d,e).data,l=g.createImageData(d,e),j=l.data,i=0;i<d;i++)for(var m=1;m<e;m++){var n=0>m-1?e-1:m-1,k=(m+1)%e,p=0>i-1?d-1:i-1,o=(i+1)%d,q=[],y=[0,0,h[4*(m*d+i)]/255*b];q.push([-1,0,h[4*(m*d+p)]/255*b]);q.push([-1,-1,h[4*(n*d+p)]/255*b]);q.push([0,-1,h[4*(n*d+i)]/255*b]);q.push([1,
-1,h[4*(n*d+o)]/255*b]);q.push([1,0,h[4*(m*d+o)]/255*b]);q.push([1,1,h[4*(k*d+o)]/255*b]);q.push([0,1,h[4*(k*d+i)]/255*b]);q.push([-1,1,h[4*(k*d+p)]/255*b]);n=[];p=q.length;for(k=0;k<p;k++){var o=q[k],u=q[(k+1)%p],o=[o[0]-y[0],o[1]-y[1],o[2]-y[2]],u=[u[0]-y[0],u[1]-y[1],u[2]-y[2]];n.push(c([o[1]*u[2]-o[2]*u[1],o[2]*u[0]-o[0]*u[2],o[0]*u[1]-o[1]*u[0]]))}q=[0,0,0];for(k=0;k<n.length;k++)q[0]+=n[k][0],q[1]+=n[k][1],q[2]+=n[k][2];q[0]/=n.length;q[1]/=n.length;q[2]/=n.length;y=4*(m*d+i);j[y]=255*((q[0]+
1)/2)|0;j[y+1]=255*(q[1]+0.5)|0;j[y+2]=255*q[2]|0;j[y+3]=255}g.putImageData(l,0,0);return f}};
