// ThreeWebGL.js r47 - http://github.com/mrdoob/three.js
'use strict';var THREE=THREE||{};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;
(function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c)window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"RequestCancelAnimationFrame"];if(!window.requestAnimationFrame)window.requestAnimationFrame=function(b){var c=(new Date).getTime(),f=Math.max(0,16-(c-a)),h=window.setTimeout(function(){b(c+f)},f);a=c+f;return h};if(!window.cancelAnimationFrame)window.cancelAnimationFrame=
function(a){clearTimeout(a)}})();THREE.Color=function(a){void 0!==a&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},copyGammaToLinear:function(a){this.r=a.r*a.r;this.g=a.g*a.g;this.b=a.b*a.b;return this},copyLinearToGamma:function(a){this.r=Math.sqrt(a.r);this.g=Math.sqrt(a.g);this.b=Math.sqrt(a.b);return this},convertGammaToLinear:function(){var a=this.r,b=this.g,c=this.b;this.r=a*a;this.g=b*b;this.b=c*c;return this},convertLinearToGamma:function(){this.r=Math.sqrt(this.r);this.g=Math.sqrt(this.g);
this.b=Math.sqrt(this.b);return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,e,f;if(0===c)this.r=this.g=this.b=0;else switch(d=Math.floor(6*a),e=6*a-d,a=c*(1-b),f=c*(1-b*e),b=c*(1-b*(1-e)),d){case 1:this.r=f;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=f;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=c;this.g=a;this.b=f;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=
Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return Math.floor(255*this.r)<<16^Math.floor(255*this.g)<<8^Math.floor(255*this.b)},getContextStyle:function(){return"rgb("+Math.floor(255*this.r)+","+Math.floor(255*this.g)+","+Math.floor(255*this.b)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
equals:function(a){return a.x===this.x&&a.y===this.y}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},
addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.z=this.y=this.x=0;return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},
cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.x=c*a.z-d*a.y;this.y=d*a.x-b*a.z;this.z=b*a.y-c*a.x;return this},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);
this.y=Math.asin(a.n13);1.0E-5<Math.abs(b)?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return 1.0E-4>this.lengthSq()}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=void 0!==d?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=void 0!==a.w?a.w:1},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-
b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Frustum=function(){this.planes=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4]};
THREE.Frustum.prototype.setFromMatrix=function(a){var b,c=this.planes;c[0].set(a.n41-a.n11,a.n42-a.n12,a.n43-a.n13,a.n44-a.n14);c[1].set(a.n41+a.n11,a.n42+a.n12,a.n43+a.n13,a.n44+a.n14);c[2].set(a.n41+a.n21,a.n42+a.n22,a.n43+a.n23,a.n44+a.n24);c[3].set(a.n41-a.n21,a.n42-a.n22,a.n43-a.n23,a.n44-a.n24);c[4].set(a.n41-a.n31,a.n42-a.n32,a.n43-a.n33,a.n44-a.n34);c[5].set(a.n41+a.n31,a.n42+a.n32,a.n43+a.n33,a.n44+a.n34);for(a=0;6>a;a++)b=c[a],b.divideScalar(Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z))};
THREE.Frustum.prototype.contains=function(a){for(var b=this.planes,c=a.matrixWorld,d=THREE.Frustum.__v1.set(c.getColumnX().length(),c.getColumnY().length(),c.getColumnZ().length()),d=-a.geometry.boundingSphere.radius*Math.max(d.x,Math.max(d.y,d.z)),e=0;6>e;e++)if(a=b[e].x*c.n14+b[e].y*c.n24+b[e].z*c.n34+b[e].w,a<=d)return!1;return!0};THREE.Frustum.__v1=new THREE.Vector3;
THREE.Ray=function(a,b){function c(a,b,c){o.sub(c,a);t=o.dot(b);z=m.add(a,r.copy(b).multiplyScalar(t));return y=c.distanceTo(z)}function d(a,b,c,d){o.sub(d,b);m.sub(c,b);r.sub(a,b);J=o.dot(o);K=o.dot(m);u=o.dot(r);B=m.dot(m);H=m.dot(r);A=1/(J*B-K*K);M=(B*u-K*H)*A;N=(J*H-K*u)*A;return 0<=M&&0<=N&&1>M+N}this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3;this.intersectScene=function(a){return this.intersectObjects(a.children)};this.intersectObjects=function(a){var b,c,d=[];for(b=0,
c=a.length;b<c;b++)Array.prototype.push.apply(d,this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d};var e=new THREE.Vector3,f=new THREE.Vector3,h=new THREE.Vector3,i=new THREE.Vector3,k=new THREE.Vector3,l=new THREE.Vector3,j=new THREE.Vector3,n=new THREE.Vector3,p=new THREE.Vector3;this.intersectObject=function(a){for(var b,m=[],o=0,r=a.children.length;o<r;o++)Array.prototype.push.apply(m,this.intersectObject(a.children[o]));if(a instanceof THREE.Particle){o=
c(this.origin,this.direction,a.matrixWorld.getPosition());if(o>a.scale.x)return[];b={distance:o,point:a.position,face:null,object:a};m.push(b)}else if(a instanceof THREE.Mesh){o=c(this.origin,this.direction,a.matrixWorld.getPosition());r=THREE.Frustum.__v1.set(a.matrixWorld.getColumnX().length(),a.matrixWorld.getColumnY().length(),a.matrixWorld.getColumnZ().length());if(o>a.geometry.boundingSphere.radius*Math.max(r.x,Math.max(r.y,r.z)))return m;var t,u,g=a.geometry,z=g.vertices,y;a.matrixRotationWorld.extractRotation(a.matrixWorld);
for(o=0,r=g.faces.length;o<r;o++)if(b=g.faces[o],k.copy(this.origin),l.copy(this.direction),y=a.matrixWorld,j=y.multiplyVector3(j.copy(b.centroid)).subSelf(k),n=a.matrixRotationWorld.multiplyVector3(n.copy(b.normal)),t=l.dot(n),!(1.0E-4>Math.abs(t))&&(u=n.dot(j)/t,!(0>u)&&(a.doubleSided||(a.flipSided?0<t:0>t))))if(p.add(k,l.multiplyScalar(u)),b instanceof THREE.Face3)e=y.multiplyVector3(e.copy(z[b.a].position)),f=y.multiplyVector3(f.copy(z[b.b].position)),h=y.multiplyVector3(h.copy(z[b.c].position)),
d(p,e,f,h)&&(b={distance:k.distanceTo(p),point:p.clone(),face:b,object:a},m.push(b));else if(b instanceof THREE.Face4&&(e=y.multiplyVector3(e.copy(z[b.a].position)),f=y.multiplyVector3(f.copy(z[b.b].position)),h=y.multiplyVector3(h.copy(z[b.c].position)),i=y.multiplyVector3(i.copy(z[b.d].position)),d(p,e,f,i)||d(p,f,h,i)))b={distance:k.distanceTo(p),point:p.clone(),face:b,object:a},m.push(b)}return m};var o=new THREE.Vector3,m=new THREE.Vector3,r=new THREE.Vector3,t,z,y,J,K,u,B,H,A,M,N};
THREE.Rectangle=function(){function a(){f=d-b;h=e-c}var b,c,d,e,f,h,i=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return f};this.getHeight=function(){return h};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(f,h,j,n){i=!1;b=f;c=h;d=j;e=n;a()};this.addPoint=function(f,h){i?(i=!1,b=f,c=h,d=f,e=h):(b=b<f?b:f,c=c<h?c:h,d=d>f?d:f,e=e>h?e:h);a()};this.add3Points=
function(f,h,j,n,p,o){i?(i=!1,b=f<j?f<p?f:p:j<p?j:p,c=h<n?h<o?h:o:n<o?n:o,d=f>j?f>p?f:p:j>p?j:p,e=h>n?h>o?h:o:n>o?n:o):(b=f<j?f<p?f<b?f:b:p<b?p:b:j<p?j<b?j:b:p<b?p:b,c=h<n?h<o?h<c?h:c:o<c?o:c:n<o?n<c?n:c:o<c?o:c,d=f>j?f>p?f>d?f:d:p>d?p:d:j>p?j>d?j:d:p>d?p:d,e=h>n?h>o?h>e?h:e:o>e?o:e:n>o?n>e?n:e:o>e?o:e);a()};this.addRectangle=function(f){i?(i=!1,b=f.getLeft(),c=f.getTop(),d=f.getRight(),e=f.getBottom()):(b=b<f.getLeft()?b:f.getLeft(),c=c<f.getTop()?c:f.getTop(),d=d>f.getRight()?d:f.getRight(),e=e>
f.getBottom()?e:f.getBottom());a()};this.inflate=function(f){b-=f;c-=f;d+=f;e+=f;a()};this.minSelf=function(f){b=b>f.getLeft()?b:f.getLeft();c=c>f.getTop()?c:f.getTop();d=d<f.getRight()?d:f.getRight();e=e<f.getBottom()?e:f.getBottom();a()};this.intersects=function(a){return d<a.getLeft()||b>a.getRight()||e<a.getTop()||c>a.getBottom()?!1:!0};this.empty=function(){i=!0;e=d=c=b=0;a()};this.isEmpty=function(){return i}};
THREE.Math={clamp:function(a,b,c){return a<b?b:a>c?c:a},clampBottom:function(a,b){return a<b?b:a},mapLinear:function(a,b,c,d,e){return d+(a-b)*(e-d)/(c-b)},random16:function(){return(65280*Math.random()+255*Math.random())/65535},randInt:function(a,b){return a+Math.floor(Math.random()*(b-a+1))},randFloat:function(a,b){return a+Math.random()*(b-a)},randFloatSpread:function(a){return a*(0.5-Math.random())}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,e,f,h,i,k,l,j,n,p,o,m,r){this.set(void 0!==a?a:1,b||0,c||0,d||0,e||0,void 0!==f?f:1,h||0,i||0,k||0,l||0,void 0!==j?j:1,n||0,p||0,o||0,m||0,void 0!==r?r:1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,e,f,h,i,k,l,j,n,p,o,m,r){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=f;this.n23=h;this.n24=i;this.n31=k;this.n32=l;this.n33=j;this.n34=n;this.n41=p;this.n42=o;this.n43=m;this.n44=r;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,f=THREE.Matrix4.__v3;f.sub(a,b).normalize();if(0===f.length())f.z=1;d.cross(c,f).normalize();0===d.length()&&(f.x+=1.0E-4,d.cross(c,f).normalize());e.cross(f,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=f.x;this.n21=d.y;this.n22=e.y;this.n23=f.y;this.n31=d.z;this.n32=e.z;this.n33=f.z;return this},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,f=a.n14,h=a.n21,i=a.n22,k=a.n23,l=a.n24,j=a.n31,n=a.n32,p=a.n33,o=a.n34,m=a.n41,r=a.n42,t=a.n43,
z=a.n44,y=b.n11,J=b.n12,K=b.n13,u=b.n14,B=b.n21,H=b.n22,A=b.n23,M=b.n24,N=b.n31,I=b.n32,S=b.n33,ua=b.n34,ka=b.n41,$=b.n42,Z=b.n43,D=b.n44;this.n11=c*y+d*B+e*N+f*ka;this.n12=c*J+d*H+e*I+f*$;this.n13=c*K+d*A+e*S+f*Z;this.n14=c*u+d*M+e*ua+f*D;this.n21=h*y+i*B+k*N+l*ka;this.n22=h*J+i*H+k*I+l*$;this.n23=h*K+i*A+k*S+l*Z;this.n24=h*u+i*M+k*ua+l*D;this.n31=j*y+n*B+p*N+o*ka;this.n32=j*J+n*H+p*I+o*$;this.n33=j*K+n*A+p*S+o*Z;this.n34=j*u+n*M+p*ua+o*D;this.n41=m*y+r*B+t*N+z*ka;this.n42=m*J+r*H+t*I+z*$;this.n43=
m*K+r*A+t*S+z*Z;this.n44=m*u+r*M+t*ua+z*D;return this},multiplySelf:function(a){return this.multiply(this,a)},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=
a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=
this.n21*b+this.n22*c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*
a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,f=this.n22,h=this.n23,i=this.n24,k=this.n31,l=this.n32,j=this.n33,n=this.n34,p=this.n41,o=this.n42,m=this.n43,r=this.n44;return d*h*l*p-c*i*l*p-d*f*j*p+b*i*j*p+c*f*n*p-b*h*n*p-d*h*k*o+c*i*k*o+d*e*j*o-a*i*j*o-c*e*n*o+a*h*n*o+d*f*k*m-b*i*k*m-d*e*l*m+a*i*l*m+b*e*n*m-a*f*n*m-c*f*k*r+b*h*k*r+c*e*l*r-a*h*l*r-
b*e*j*r+a*f*j*r},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n34=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;
a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=
this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=
this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,
0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,f=a.x,h=a.y,i=a.z,k=e*f,l=e*h;this.set(k*f+c,k*h-d*i,k*i+d*h,0,k*h+d*i,l*h+c,l*i-d*f,0,k*i-d*h,l*i+d*f,e*i*i+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){return THREE.Matrix4.__v1.set(this.n14,this.n24,this.n34)},getColumnX:function(){return THREE.Matrix4.__v1.set(this.n11,this.n21,this.n31)},getColumnY:function(){return THREE.Matrix4.__v1.set(this.n12,
this.n22,this.n32)},getColumnZ:function(){return THREE.Matrix4.__v1.set(this.n13,this.n23,this.n33)},getInverse:function(a){var b=a.n11,c=a.n12,d=a.n13,e=a.n14,f=a.n21,h=a.n22,i=a.n23,k=a.n24,l=a.n31,j=a.n32,n=a.n33,p=a.n34,o=a.n41,m=a.n42,r=a.n43,t=a.n44;this.n11=i*p*m-k*n*m+k*j*r-h*p*r-i*j*t+h*n*t;this.n12=e*n*m-d*p*m-e*j*r+c*p*r+d*j*t-c*n*t;this.n13=d*k*m-e*i*m+e*h*r-c*k*r-d*h*t+c*i*t;this.n14=e*i*j-d*k*j-e*h*n+c*k*n+d*h*p-c*i*p;this.n21=k*n*o-i*p*o-k*l*r+f*p*r+i*l*t-f*n*t;this.n22=d*p*o-e*n*o+
e*l*r-b*p*r-d*l*t+b*n*t;this.n23=e*i*o-d*k*o-e*f*r+b*k*r+d*f*t-b*i*t;this.n24=d*k*l-e*i*l+e*f*n-b*k*n-d*f*p+b*i*p;this.n31=h*p*o-k*j*o+k*l*m-f*p*m-h*l*t+f*j*t;this.n32=e*j*o-c*p*o-e*l*m+b*p*m+c*l*t-b*j*t;this.n33=c*k*o-e*h*o+e*f*m-b*k*m-c*f*t+b*h*t;this.n34=e*h*l-c*k*l-e*f*j+b*k*j+c*f*p-b*h*p;this.n41=i*j*o-h*n*o-i*l*m+f*n*m+h*l*r-f*j*r;this.n42=c*n*o-d*j*o+d*l*m-b*n*m-c*l*r+b*j*r;this.n43=d*h*o-c*i*o-d*f*m+b*i*m+c*f*r-b*h*r;this.n44=c*i*l-d*h*l+d*f*j-b*i*j-c*f*n+b*h*n;this.multiplyScalar(1/a.determinant());
return this},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,e=a.z,f=Math.cos(c),c=Math.sin(c),h=Math.cos(d),d=Math.sin(d),i=Math.cos(e),e=Math.sin(e);switch(b){case "YXZ":var k=h*i,l=h*e,j=d*i,n=d*e;this.n11=k+n*c;this.n12=j*c-l;this.n13=f*d;this.n21=f*e;this.n22=f*i;this.n23=-c;this.n31=l*c-j;this.n32=n+k*c;this.n33=f*h;break;case "ZXY":k=h*i;l=h*e;j=d*i;n=d*e;this.n11=k-n*c;this.n12=-f*e;this.n13=j+l*c;this.n21=l+j*c;this.n22=f*i;this.n23=n-k*c;this.n31=-f*d;this.n32=c;this.n33=f*h;break;case "ZYX":k=
f*i;l=f*e;j=c*i;n=c*e;this.n11=h*i;this.n12=j*d-l;this.n13=k*d+n;this.n21=h*e;this.n22=n*d+k;this.n23=l*d-j;this.n31=-d;this.n32=c*h;this.n33=f*h;break;case "YZX":k=f*h;l=f*d;j=c*h;n=c*d;this.n11=h*i;this.n12=n-k*e;this.n13=j*e+l;this.n21=e;this.n22=f*i;this.n23=-c*i;this.n31=-d*i;this.n32=l*e+j;this.n33=k-n*e;break;case "XZY":k=f*h;l=f*d;j=c*h;n=c*d;this.n11=h*i;this.n12=-e;this.n13=d*i;this.n21=k*e+n;this.n22=f*i;this.n23=l*e-j;this.n31=j*e-l;this.n32=c*i;this.n33=n*e+k;break;default:k=f*i,l=f*
e,j=c*i,n=c*e,this.n11=h*i,this.n12=-h*e,this.n13=d,this.n21=l+j*d,this.n22=k-n*d,this.n23=-c*h,this.n31=n-k*d,this.n32=j+l*d,this.n33=f*h}return this},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,f=b+b,h=c+c,i=d+d,a=b*f,k=b*h,b=b*i,l=c*h,c=c*i,d=d*i,f=e*f,h=e*h,e=e*i;this.n11=1-(l+d);this.n12=k-e;this.n13=b+h;this.n21=k+e;this.n22=1-(a+d);this.n23=c-f;this.n31=b-h;this.n32=c+f;this.n33=1-(a+l);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=
a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},compose:function(a,b,c){var d=THREE.Matrix4.__m1,e=THREE.Matrix4.__m2;d.identity();d.setRotationFromQuaternion(b);e.setScale(c.x,c.y,c.z);this.multiply(d,e);this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},decompose:function(a,b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,f=THREE.Matrix4.__v3;d.set(this.n11,this.n21,this.n31);e.set(this.n12,this.n22,this.n32);f.set(this.n13,
this.n23,this.n33);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;c.x=d.length();c.y=e.length();c.z=f.length();a.x=this.n14;a.y=this.n24;a.z=this.n34;d=THREE.Matrix4.__m1;d.copy(this);d.n11/=c.x;d.n21/=c.x;d.n31/=c.x;d.n12/=c.y;d.n22/=c.y;d.n32/=c.y;d.n13/=c.z;d.n23/=c.z;d.n33/=c.z;b.setFromRotationMatrix(d);return[a,b,c]},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34;
return this},extractRotation:function(a){var b=THREE.Matrix4.__v1,c=1/b.set(a.n11,a.n21,a.n31).length(),d=1/b.set(a.n12,a.n22,a.n32).length(),b=1/b.set(a.n13,a.n23,a.n33).length();this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*b;this.n23=a.n23*b;this.n33=a.n33*b;return this},rotateByAxis:function(a,b){if(1===a.x&&0===a.y&&0===a.z)return this.rotateX(b);if(0===a.x&&1===a.y&&0===a.z)return this.rotateY(b);if(0===a.x&&0===a.y&&1===
a.z)return this.rotateZ(b);var c=a.x,d=a.y,e=a.z,f=Math.sqrt(c*c+d*d+e*e),c=c/f,d=d/f,e=e/f,f=c*c,h=d*d,i=e*e,k=Math.cos(b),l=Math.sin(b),j=1-k,n=c*d*j,p=c*e*j,j=d*e*j,c=c*l,o=d*l,l=e*l,e=f+(1-f)*k,f=n+l,d=p-o,n=n-l,h=h+(1-h)*k,l=j+c,p=p+o,j=j-c,i=i+(1-i)*k,k=this.n11,c=this.n21,o=this.n31,m=this.n41,r=this.n12,t=this.n22,z=this.n32,y=this.n42,J=this.n13,K=this.n23,u=this.n33,B=this.n43;this.n11=e*k+f*r+d*J;this.n21=e*c+f*t+d*K;this.n31=e*o+f*z+d*u;this.n41=e*m+f*y+d*B;this.n12=n*k+h*r+l*J;this.n22=
n*c+h*t+l*K;this.n32=n*o+h*z+l*u;this.n42=n*m+h*y+l*B;this.n13=p*k+j*r+i*J;this.n23=p*c+j*t+i*K;this.n33=p*o+j*z+i*u;this.n43=p*m+j*y+i*B;return this},rotateX:function(a){var b=this.n12,c=this.n22,d=this.n32,e=this.n42,f=this.n13,h=this.n23,i=this.n33,k=this.n43,l=Math.cos(a),a=Math.sin(a);this.n12=l*b+a*f;this.n22=l*c+a*h;this.n32=l*d+a*i;this.n42=l*e+a*k;this.n13=l*f-a*b;this.n23=l*h-a*c;this.n33=l*i-a*d;this.n43=l*k-a*e;return this},rotateY:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,
f=this.n13,h=this.n23,i=this.n33,k=this.n43,l=Math.cos(a),a=Math.sin(a);this.n11=l*b-a*f;this.n21=l*c-a*h;this.n31=l*d-a*i;this.n41=l*e-a*k;this.n13=l*f+a*b;this.n23=l*h+a*c;this.n33=l*i+a*d;this.n43=l*k+a*e;return this},rotateZ:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,f=this.n12,h=this.n22,i=this.n32,k=this.n42,l=Math.cos(a),a=Math.sin(a);this.n11=l*b+a*f;this.n21=l*c+a*h;this.n31=l*d+a*i;this.n41=l*e+a*k;this.n12=l*f-a*b;this.n22=l*h-a*c;this.n32=l*i-a*d;this.n42=l*k-a*e;return this},
translate:function(a){var b=a.x,c=a.y,a=a.z;this.n14=this.n11*b+this.n12*c+this.n13*a+this.n14;this.n24=this.n21*b+this.n22*c+this.n23*a+this.n24;this.n34=this.n31*b+this.n32*c+this.n33*a+this.n34;this.n44=this.n41*b+this.n42*c+this.n43*a+this.n44;return this}};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,f=a.n32*a.n21-a.n31*a.n22,h=-a.n33*a.n12+a.n32*a.n13,i=a.n33*a.n11-a.n31*a.n13,k=-a.n32*a.n11+a.n31*a.n12,l=a.n23*a.n12-a.n22*a.n13,j=-a.n23*a.n11+a.n21*a.n13,n=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*h+a.n31*l;if(0===a)return null;a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*f;c[3]=a*h;c[4]=a*i;c[5]=a*k;c[6]=a*l;c[7]=a*j;c[8]=a*n;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,f){var h;h=new THREE.Matrix4;h.n11=2*e/(b-a);h.n12=0;h.n13=(b+a)/(b-a);h.n14=0;h.n21=0;h.n22=2*e/(d-c);h.n23=(d+c)/(d-c);h.n24=0;h.n31=0;h.n32=0;h.n33=-(f+e)/(f-e);h.n34=-2*f*e/(f-e);h.n41=0;h.n42=0;h.n43=-1;h.n44=0;return h};THREE.Matrix4.makePerspective=function(a,b,c,d){var e,a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,f){var h,i,k,l;h=new THREE.Matrix4;i=b-a;k=c-d;l=f-e;h.n11=2/i;h.n12=0;h.n13=0;h.n14=-((b+a)/i);h.n21=0;h.n22=2/k;h.n23=0;h.n24=-((c+d)/k);h.n31=0;h.n32=0;h.n33=-2/l;h.n34=-((f+e)/l);h.n41=0;h.n42=0;h.n43=0;h.n44=1;return h};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.name="";this.id=THREE.Object3DCount++;this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},add:function(a){if(-1===
this.children.indexOf(a)){void 0!==a.parent&&a.parent.remove(a);a.parent=this;this.children.push(a);for(var b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.addObject(a)}},remove:function(a){var b=this.children.indexOf(a);if(-1!==b){a.parent=void 0;this.children.splice(b,1);for(b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.removeObject(a)}},getChildByName:function(a,b){var c,d,e;for(c=0,d=this.children.length;c<d;c++){e=this.children[c];if(e.name===
a||b&&(e=e.getChildByName(a,b),void 0!==e))return e}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(1!==this.scale.x||1!==this.scale.y||1!==this.scale.z)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(a){this.matrixAutoUpdate&&
this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,a=!0;for(var b=0,c=this.children.length;b<c;b++)this.children[b].updateMatrixWorld(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=h[f]=h[f]||new THREE.RenderableObject;f++;return a}function b(){var a=l[k]=l[k]||new THREE.RenderableVertex;k++;return a}function c(a,b){return b.z-a.z}function d(a,b){var c=0,d=1,e=a.z+a.w,g=b.z+b.w,f=-a.z+a.w,h=-b.z+b.w;if(0<=e&&0<=g&&0<=f&&0<=h)return!0;if(0>e&&0>g||0>f&&0>h)return!1;0>e?c=Math.max(c,e/(e-g)):0>g&&(d=Math.min(d,e/(e-g)));0>f?c=Math.max(c,f/(f-h)):0>h&&(d=Math.min(d,f/(f-h)));if(d<c)return!1;a.lerpSelf(b,c);b.lerpSelf(a,1-d);return!0}
var e,f,h=[],i,k,l=[],j,n,p=[],o,m=[],r,t,z=[],y,J,K=[],u={objects:[],sprites:[],lights:[],elements:[]},B=new THREE.Vector3,H=new THREE.Vector4,A=new THREE.Matrix4,M=new THREE.Matrix4,N=new THREE.Frustum,I=new THREE.Vector4,S=new THREE.Vector4;this.projectVector=function(a,b){b.matrixWorldInverse.getInverse(b.matrixWorld);A.multiply(b.projectionMatrix,b.matrixWorldInverse);A.multiplyVector3(a);return a};this.unprojectVector=function(a,b){b.projectionMatrixInverse.getInverse(b.projectionMatrix);A.multiply(b.matrixWorld,
b.projectionMatrixInverse);A.multiplyVector3(a);return a};this.pickingRay=function(a,b){var c;a.z=-1;c=new THREE.Vector3(a.x,a.y,1);this.unprojectVector(a,b);this.unprojectVector(c,b);c.subSelf(a).normalize();return new THREE.Ray(a,c)};this.projectGraph=function(b,d){f=0;u.objects.length=0;u.sprites.length=0;u.lights.length=0;var h=function(b){if(!1!==b.visible){(b instanceof THREE.Mesh||b instanceof THREE.Line)&&(!1===b.frustumCulled||N.contains(b))?(A.multiplyVector3(B.copy(b.position)),e=a(),e.object=
b,e.z=B.z,u.objects.push(e)):b instanceof THREE.Sprite||b instanceof THREE.Particle?(A.multiplyVector3(B.copy(b.position)),e=a(),e.object=b,e.z=B.z,u.sprites.push(e)):b instanceof THREE.Light&&u.lights.push(b);for(var c=0,g=b.children.length;c<g;c++)h(b.children[c])}};h(b);d&&u.objects.sort(c);return u};this.projectScene=function(a,e,f){var h=e.near,D=e.far,g,B,ba,pa,Q,L,W,ya,ca,Ea,Ba,Na,Oa,Pa,Ta,Ua;J=t=o=n=0;u.elements.length=0;void 0===e.parent&&(console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it..."),
a.add(e));a.updateMatrixWorld();e.matrixWorldInverse.getInverse(e.matrixWorld);A.multiply(e.projectionMatrix,e.matrixWorldInverse);N.setFromMatrix(A);u=this.projectGraph(a,!1);for(a=0,g=u.objects.length;a<g;a++)if(ca=u.objects[a].object,Ea=ca.matrixWorld,Na=ca.material,k=0,ca instanceof THREE.Mesh){Ba=ca.geometry;Oa=ca.geometry.materials;pa=Ba.vertices;Pa=Ba.faces;Ta=Ba.faceVertexUvs;Ba=ca.matrixRotationWorld.extractRotation(Ea);for(B=0,ba=pa.length;B<ba;B++)i=b(),i.positionWorld.copy(pa[B].position),
Ea.multiplyVector3(i.positionWorld),i.positionScreen.copy(i.positionWorld),A.multiplyVector4(i.positionScreen),i.positionScreen.x/=i.positionScreen.w,i.positionScreen.y/=i.positionScreen.w,i.visible=i.positionScreen.z>h&&i.positionScreen.z<D;for(pa=0,B=Pa.length;pa<B;pa++){ba=Pa[pa];if(ba instanceof THREE.Face3)if(Q=l[ba.a],L=l[ba.b],W=l[ba.c],Q.visible&&L.visible&&W.visible&&(ca.doubleSided||ca.flipSided!=0>(W.positionScreen.x-Q.positionScreen.x)*(L.positionScreen.y-Q.positionScreen.y)-(W.positionScreen.y-
Q.positionScreen.y)*(L.positionScreen.x-Q.positionScreen.x)))ya=p[n]=p[n]||new THREE.RenderableFace3,n++,j=ya,j.v1.copy(Q),j.v2.copy(L),j.v3.copy(W);else continue;else if(ba instanceof THREE.Face4)if(Q=l[ba.a],L=l[ba.b],W=l[ba.c],ya=l[ba.d],Q.visible&&L.visible&&W.visible&&ya.visible&&(ca.doubleSided||ca.flipSided!=(0>(ya.positionScreen.x-Q.positionScreen.x)*(L.positionScreen.y-Q.positionScreen.y)-(ya.positionScreen.y-Q.positionScreen.y)*(L.positionScreen.x-Q.positionScreen.x)||0>(L.positionScreen.x-
W.positionScreen.x)*(ya.positionScreen.y-W.positionScreen.y)-(L.positionScreen.y-W.positionScreen.y)*(ya.positionScreen.x-W.positionScreen.x))))Ua=m[o]=m[o]||new THREE.RenderableFace4,o++,j=Ua,j.v1.copy(Q),j.v2.copy(L),j.v3.copy(W),j.v4.copy(ya);else continue;j.normalWorld.copy(ba.normal);Ba.multiplyVector3(j.normalWorld);j.centroidWorld.copy(ba.centroid);Ea.multiplyVector3(j.centroidWorld);j.centroidScreen.copy(j.centroidWorld);A.multiplyVector3(j.centroidScreen);W=ba.vertexNormals;for(Q=0,L=W.length;Q<
L;Q++)ya=j.vertexNormalsWorld[Q],ya.copy(W[Q]),Ba.multiplyVector3(ya);for(Q=0,L=Ta.length;Q<L;Q++)if(Ua=Ta[Q][pa])for(W=0,ya=Ua.length;W<ya;W++)j.uvs[Q][W]=Ua[W];j.material=Na;j.faceMaterial=null!==ba.materialIndex?Oa[ba.materialIndex]:null;j.z=j.centroidScreen.z;u.elements.push(j)}}else if(ca instanceof THREE.Line){M.multiply(A,Ea);pa=ca.geometry.vertices;Q=b();Q.positionScreen.copy(pa[0].position);M.multiplyVector4(Q.positionScreen);for(B=1,ba=pa.length;B<ba;B++)if(Q=b(),Q.positionScreen.copy(pa[B].position),
M.multiplyVector4(Q.positionScreen),L=l[k-2],I.copy(Q.positionScreen),S.copy(L.positionScreen),d(I,S))I.multiplyScalar(1/I.w),S.multiplyScalar(1/S.w),ca=z[t]=z[t]||new THREE.RenderableLine,t++,r=ca,r.v1.positionScreen.copy(I),r.v2.positionScreen.copy(S),r.z=Math.max(I.z,S.z),r.material=Na,u.elements.push(r)}for(a=0,g=u.sprites.length;a<g;a++)if(ca=u.sprites[a].object,Ea=ca.matrixWorld,ca instanceof THREE.Particle&&(H.set(Ea.n14,Ea.n24,Ea.n34,1),A.multiplyVector4(H),H.z/=H.w,0<H.z&&1>H.z))h=K[J]=K[J]||
new THREE.RenderableParticle,J++,y=h,y.x=H.x/H.w,y.y=H.y/H.w,y.z=H.z,y.rotation=ca.rotation.z,y.scale.x=ca.scale.x*Math.abs(y.x-(H.x+e.projectionMatrix.n11)/(H.w+e.projectionMatrix.n14)),y.scale.y=ca.scale.y*Math.abs(y.y-(H.y+e.projectionMatrix.n22)/(H.w+e.projectionMatrix.n24)),y.material=ca.material,u.elements.push(y);f&&u.elements.sort(c);return u}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,void 0!==d?d:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),f=Math.cos(c),c=Math.sin(c),h=a*b,i=d*e;this.w=h*f-i*c;this.x=h*c+i*f;this.y=d*b*f+a*e*c;this.z=a*e*f-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);
this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.n11+a.n22+a.n33))/2;this.x=Math.sqrt(Math.max(0,b+a.n11-a.n22-a.n33))/2;this.y=Math.sqrt(Math.max(0,b-a.n11+a.n22-a.n33))/2;this.z=Math.sqrt(Math.max(0,b-a.n11-a.n22+a.n33))/2;this.x=0>a.n32-a.n23?-Math.abs(this.x):Math.abs(this.x);this.y=0>a.n13-a.n31?-Math.abs(this.y):Math.abs(this.y);this.z=0>a.n21-a.n12?-Math.abs(this.z):Math.abs(this.z);
this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);0===a?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},multiplySelf:function(a){var b=
this.x,c=this.y,d=this.z,e=this.w,f=a.x,h=a.y,i=a.z,a=a.w;this.x=b*a+e*f+c*i-d*h;this.y=c*a+e*h+d*f-b*i;this.z=d*a+e*i+b*h-c*f;this.w=e*a-b*f-c*h-d*i;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,f=this.x,h=this.y,i=this.z,k=this.w,l=k*c+h*e-i*d,j=k*d+i*c-f*e,n=k*e+f*d-h*c,c=-f*
c-h*d-i*e;b.x=l*k+c*-f+j*-i-n*-h;b.y=j*k+c*-h+n*-f-l*-i;b.z=n*k+c*-i+l*-h-j*-f;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;0>e?(c.w=-b.w,c.x=-b.x,c.y=-b.y,c.z=-b.z,e=-e):c.copy(b);if(1<=Math.abs(e))return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var f=Math.acos(e),e=Math.sqrt(1-e*e);if(0.001>Math.abs(e))return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;b=Math.sin((1-d)*f)/e;d=Math.sin(d*f)/e;c.w=a.w*b+c.w*d;c.x=a.x*b+c.x*d;c.y=a.y*b+c.y*d;c.z=a.z*b+c.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,d,e,f){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materialIndex=f;this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,e,f,h){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materialIndex=h;this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};
THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.materials=[];this.faces=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a,new THREE.Vector3(1,1,1));for(var c=0,d=this.vertices.length;c<d;c++)a.multiplyVector3(this.vertices[c].position);c=0;for(d=this.faces.length;c<d;c++){var e=this.faces[c];b.multiplyVector3(e.normal);for(var f=0,h=e.vertexNormals.length;f<h;f++)b.multiplyVector3(e.vertexNormals[f]);a.multiplyVector3(e.centroid)}},computeCentroids:function(){var a,b,c;for(a=0,b=this.faces.length;a<
b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(){var a,
b,c,d,e,f,h=new THREE.Vector3,i=new THREE.Vector3;for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],d=this.vertices[c.a],e=this.vertices[c.b],f=this.vertices[c.c],h.sub(f.position,e.position),i.sub(d.position,e.position),h.crossSelf(i),h.isZero()||h.normalize(),c.normal.copy(h)},computeVertexNormals:function(){var a,b,c,d;if(void 0===this.__tmpVertices){d=this.__tmpVertices=Array(this.vertices.length);for(a=0,b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;for(a=0,b=this.faces.length;a<b;a++)if(c=
this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=this.__tmpVertices;for(a=0,b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),
d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));for(a=0,b=this.vertices.length;a<b;a++)d[a].normalize();for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,
b,c,d,e,f,A){i=a.vertices[b].position;k=a.vertices[c].position;l=a.vertices[d].position;j=h[e];n=h[f];p=h[A];o=k.x-i.x;m=l.x-i.x;r=k.y-i.y;t=l.y-i.y;z=k.z-i.z;y=l.z-i.z;J=n.u-j.u;K=p.u-j.u;u=n.v-j.v;B=p.v-j.v;H=1/(J*B-K*u);I.set((B*o-u*m)*H,(B*r-u*t)*H,(B*z-u*y)*H);S.set((J*m-K*o)*H,(J*t-K*r)*H,(J*y-K*z)*H);M[b].addSelf(I);M[c].addSelf(I);M[d].addSelf(I);N[b].addSelf(S);N[c].addSelf(S);N[d].addSelf(S)}var b,c,d,e,f,h,i,k,l,j,n,p,o,m,r,t,z,y,J,K,u,B,H,A,M=[],N=[],I=new THREE.Vector3,S=new THREE.Vector3,
ua=new THREE.Vector3,ka=new THREE.Vector3,$=new THREE.Vector3;for(b=0,c=this.vertices.length;b<c;b++)M[b]=new THREE.Vector3,N[b]=new THREE.Vector3;for(b=0,c=this.faces.length;b<c;b++)f=this.faces[b],h=this.faceVertexUvs[0][b],f instanceof THREE.Face3?a(this,f.a,f.b,f.c,0,1,2):f instanceof THREE.Face4&&(a(this,f.a,f.b,f.c,0,1,2),a(this,f.a,f.b,f.d,0,1,3));var Z=["a","b","c","d"];for(b=0,c=this.faces.length;b<c;b++){f=this.faces[b];for(d=0;d<f.vertexNormals.length;d++)$.copy(f.vertexNormals[d]),e=f[Z[d]],
A=M[e],ua.copy(A),ua.subSelf($.multiplyScalar($.dot(A))).normalize(),ka.cross(f.vertexNormals[d],A),e=ka.dot(N[e]),e=0>e?-1:1,f.vertexTangents[d]=new THREE.Vector4(ua.x,ua.y,ua.z,e)}this.hasTangents=!0},computeBoundingBox:function(){if(0<this.vertices.length){var a;a=this.vertices[0].position;this.boundingBox?(this.boundingBox.min.copy(a),this.boundingBox.max.copy(a)):this.boundingBox={min:a.clone(),max:a.clone()};for(var b=this.boundingBox.min,c=this.boundingBox.max,d=1,e=this.vertices.length;d<
e;d++){a=this.vertices[d].position;if(a.x<b.x)b.x=a.x;else if(a.x>c.x)c.x=a.x;if(a.y<b.y)b.y=a.y;else if(a.y>c.y)c.y=a.y;if(a.z<b.z)b.z=a.z;else if(a.z>c.z)c.z=a.z}}},computeBoundingSphere:function(){for(var a,b=0,c=0,d=this.vertices.length;c<d;c++)a=this.vertices[c].position.length(),a>b&&(b=a);this.boundingSphere={radius:b}},mergeVertices:function(){var a={},b=[],c=[],d,e=Math.pow(10,4),f,h;for(f=0,h=this.vertices.length;f<h;f++)d=this.vertices[f].position,d=[Math.round(d.x*e),Math.round(d.y*e),
Math.round(d.z*e)].join("_"),void 0===a[d]?(a[d]=f,b.push(this.vertices[f]),c[f]=b.length-1):c[f]=c[a[d]];for(f=0,h=this.faces.length;f<h;f++)if(a=this.faces[f],a instanceof THREE.Face3)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c];else if(a instanceof THREE.Face4)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c],a.d=c[a.d];this.vertices=b}};THREE.GeometryCount=0;
THREE.Spline=function(a){function b(a,b,c,d,e,f,h){a=0.5*(c-a);d=0.5*(d-b);return(2*(b-c)+a+d)*h+(-3*(b-c)-2*a-d)*f+a*e+b}this.points=a;var c=[],d={x:0,y:0,z:0},e,f,h,i,k,l,j,n,p;this.initFromArray=function(a){this.points=[];for(var b=0;b<a.length;b++)this.points[b]={x:a[b][0],y:a[b][1],z:a[b][2]}};this.getPoint=function(a){e=(this.points.length-1)*a;f=Math.floor(e);h=e-f;c[0]=0===f?f:f-1;c[1]=f;c[2]=f>this.points.length-2?f:f+1;c[3]=f>this.points.length-3?f:f+2;l=this.points[c[0]];j=this.points[c[1]];
n=this.points[c[2]];p=this.points[c[3]];i=h*h;k=h*i;d.x=b(l.x,j.x,n.x,p.x,h,i,k);d.y=b(l.y,j.y,n.y,p.y,h,i,k);d.z=b(l.z,j.z,n.z,p.z,h,i,k);return d};this.getControlPointsArray=function(){var a,b,c=this.points.length,d=[];for(a=0;a<c;a++)b=this.points[a],d[a]=[b.x,b.y,b.z];return d};this.getLength=function(a){var b,c,d,e=b=b=0,f=new THREE.Vector3,h=new THREE.Vector3,i=[],j=0;i[0]=0;a||(a=100);c=this.points.length*a;f.copy(this.points[0]);for(a=1;a<c;a++)b=a/c,d=this.getPoint(b),h.copy(d),j+=h.distanceTo(f),
f.copy(d),b*=this.points.length-1,b=Math.floor(b),b!=e&&(i[b]=j,e=b);i[i.length]=j;return{chunks:i,total:j}};this.reparametrizeByArcLength=function(a){var b,c,d,e,f,h,i=[],j=new THREE.Vector3,l=this.getLength();i.push(j.copy(this.points[0]).clone());for(b=1;b<this.points.length;b++){c=l.chunks[b]-l.chunks[b-1];h=Math.ceil(a*c/l.total);e=(b-1)/(this.points.length-1);f=b/(this.points.length-1);for(c=1;c<h-1;c++)d=e+c*(1/h)*(f-e),d=this.getPoint(d),i.push(j.copy(d).clone());i.push(j.copy(this.points[b]).clone())}this.points=
i}};THREE.Edge=function(a,b,c,d){this.vertices=[a,b];this.vertexIndices=[c,d];this.faces=[];this.faceIndices=[]};THREE.Camera=function(){if(arguments.length)return console.warn("DEPRECATED: Camera() is now PerspectiveCamera() or OrthographicCamera()."),new THREE.PerspectiveCamera(arguments[0],arguments[1],arguments[2],arguments[3]);THREE.Object3D.call(this);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4;this.projectionMatrixInverse=new THREE.Matrix4};
THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.lookAt=function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)};THREE.OrthographicCamera=function(a,b,c,d,e,f){THREE.Camera.call(this);this.left=a;this.right=b;this.top=c;this.bottom=d;this.near=void 0!==e?e:0.1;this.far=void 0!==f?f:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=new THREE.Camera;
THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.PerspectiveCamera=function(a,b,c,d){THREE.Camera.call(this);this.fov=void 0!==a?a:50;this.aspect=void 0!==b?b:1;this.near=void 0!==c?c:0.1;this.far=void 0!==d?d:2E3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=new THREE.Camera;
THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;THREE.PerspectiveCamera.prototype.setLens=function(a,b){this.fov=2*Math.atan((void 0!==b?b:43.25)/(2*a));this.fov*=180/Math.PI;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,d,e,f){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=e;this.height=f;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,
this.far)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0;this.onlyShadow=this.castShadow=!1;this.shadowCameraLeft=-500;this.shadowCameraTop=this.shadowCameraRight=500;this.shadowCameraBottom=-500;this.shadowCameraVisible=!1;this.shadowBias=0;this.shadowDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowMatrix=this.shadowCamera=this.shadowMapSize=
this.shadowMap=null};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.SpotLight=function(a,b,c,d){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0;this.castShadow=void 0!==d?d:!1;this.onlyShadow=!1;this.shadowCameraNear=50;this.shadowCameraFar=5E3;this.shadowCameraFov=50;this.shadowCameraVisible=!1;this.shadowBias=0;this.shadowDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowMatrix=this.shadowCamera=this.shadowMapSize=this.shadowMap=null};
THREE.SpotLight.prototype=new THREE.Light;THREE.SpotLight.prototype.constructor=THREE.SpotLight;
THREE.Material=function(a){a=a||{};this.name="";this.id=THREE.MaterialCount++;this.opacity=void 0!==a.opacity?a.opacity:1;this.transparent=void 0!==a.transparent?a.transparent:!1;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.depthTest=void 0!==a.depthTest?a.depthTest:!0;this.depthWrite=void 0!==a.depthWrite?a.depthWrite:!0;this.polygonOffset=void 0!==a.polygonOffset?a.polygonOffset:!1;this.polygonOffsetFactor=void 0!==a.polygonOffsetFactor?a.polygonOffsetFactor:0;this.polygonOffsetUnits=
void 0!==a.polygonOffsetUnits?a.polygonOffsetUnits:0;this.alphaTest=void 0!==a.alphaTest?a.alphaTest:0;this.overdraw=void 0!==a.overdraw?a.overdraw:!1};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=void 0!==a.linewidth?a.linewidth:1;this.linecap=void 0!==a.linecap?a.linecap:"round";this.linejoin=void 0!==a.linejoin?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:
!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=void 0!==a.ambient?new THREE.Color(a.ambient):new THREE.Color(328965);this.wrapAround=void 0!==a.wrapAround?a.wrapAround:!1;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;
this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:
"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=void 0!==a.ambient?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=void 0!==a.specular?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=void 0!==a.shininess?a.shininess:30;this.metal=void 0!==a.metal?a.metal:!1;this.perPixel=void 0!==a.perPixel?a.perPixel:!1;this.wrapAround=void 0!==a.wrapAround?a.wrapAround:
!1;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:
!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;
THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(a){console.warn("DEPRECATED: MeshShaderMaterial() is now ShaderMaterial().");return new THREE.ShaderMaterial(a)};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.size=void 0!==a.size?a.size:1;this.sizeAttenuation=void 0!==a.sizeAttenuation?a.sizeAttenuation:!0;this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ShaderMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.fragmentShader=void 0!==a.fragmentShader?a.fragmentShader:"void main() {}";this.vertexShader=void 0!==a.vertexShader?a.vertexShader:"void main() {}";this.uniforms=void 0!==a.uniforms?a.uniforms:{};this.attributes=a.attributes;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.fog=void 0!==
a.fog?a.fog:!1;this.lights=void 0!==a.lights?a.lights:!1;this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1};THREE.ShaderMaterial.prototype=new THREE.Material;THREE.ShaderMaterial.prototype.constructor=THREE.ShaderMaterial;
THREE.Texture=function(a,b,c,d,e,f,h,i){this.id=THREE.TextureCount++;this.image=a;this.mapping=void 0!==b?b:new THREE.UVMapping;this.wrapS=void 0!==c?c:THREE.ClampToEdgeWrapping;this.wrapT=void 0!==d?d:THREE.ClampToEdgeWrapping;this.magFilter=void 0!==e?e:THREE.LinearFilter;this.minFilter=void 0!==f?f:THREE.LinearMipMapLinearFilter;this.format=void 0!==h?h:THREE.RGBAFormat;this.type=void 0!==i?i:THREE.UnsignedByteType;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.generateMipmaps=
!0;this.needsUpdate=!1;this.onUpdate=null};THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter,this.format,this.type);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};
THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;
THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.DataTexture=function(a,b,c,d,e,f,h,i,k,l){THREE.Texture.call(this,null,f,h,i,k,l,d,e);this.image={data:a,width:b,height:c}};THREE.DataTexture.prototype=new THREE.Texture;THREE.DataTexture.prototype.constructor=THREE.DataTexture;
THREE.DataTexture.prototype.clone=function(){var a=new THREE.DataTexture(this.image.data,this.image.width,this.image.height,this.format,this.type,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a};THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.ParticleSystem=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b;this.sortParticles=!1;if(this.geometry)this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius;this.frustumCulled=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;
THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.material=b;this.type=void 0!==c?c:THREE.LineStrip;this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere())};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b;if(b instanceof Array)console.warn("DEPRECATED: Mesh material can no longer be an Array. Using material at index 0..."),this.material=b[0];if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};
for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;
THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(void 0!==this.morphTargetDictionary[a])return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var c,d=this.children.length;for(c=0;c<d;c++)this.children[c].update(this.skinMatrix,b)};
THREE.SkinnedMesh=function(a,b){THREE.Mesh.call(this,a,b);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var c,d,e,f,h,i;if(void 0!==this.geometry.bones){for(c=0;c<this.geometry.bones.length;c++)e=this.geometry.bones[c],f=e.pos,h=e.rotq,i=e.scl,d=this.addBone(),d.name=e.name,d.position.set(f[0],f[1],f[2]),d.quaternion.set(h[0],h[1],h[2],h[3]),d.useQuaternion=!0,void 0!==i?d.scale.set(i[0],i[1],i[2]):d.scale.set(1,1,1);for(c=0;c<this.bones.length;c++)e=this.geometry.bones[c],
d=this.bones[c],-1===e.parent?this.add(d):this.bones[e.parent].add(d);this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;THREE.SkinnedMesh.prototype.addBone=function(a){void 0===a&&(a=new THREE.Bone(this));this.bones.push(a);return a};
THREE.SkinnedMesh.prototype.updateMatrixWorld=function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1;for(var a=0,b=this.children.length;a<b;a++){var c=this.children[a];c instanceof THREE.Bone?c.update(this.identityMatrix,!1):c.updateMatrixWorld(!0)}for(var b=this.bones.length,c=this.bones,d=this.boneMatrices,a=0;a<b;a++)c[a].skinMatrix.flattenToArrayOffset(d,
16*a)};
THREE.SkinnedMesh.prototype.pose=function(){this.updateMatrixWorld(!0);for(var a,b=[],c=0;c<this.bones.length;c++){a=this.bones[c];var d=new THREE.Matrix4;d.getInverse(a.skinMatrix);b.push(d);a.skinMatrix.flattenToArrayOffset(this.boneMatrices,16*c)}if(void 0===this.geometry.skinVerticesA){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];for(a=0;a<this.geometry.skinIndices.length;a++){var c=this.geometry.vertices[a].position,e=this.geometry.skinIndices[a].x,f=this.geometry.skinIndices[a].y,d=
new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesA.push(b[e].multiplyVector3(d));d=new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesB.push(b[f].multiplyVector3(d));1!==this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y&&(c=0.5*(1-(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y)),this.geometry.skinWeights[a].x+=c,this.geometry.skinWeights[a].y+=c)}}};THREE.Ribbon=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b};
THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.addLevel=function(a,b){void 0===b&&(b=0);for(var b=Math.abs(b),c=0;c<this.LODs.length&&!(b<this.LODs[c].visibleAtDistance);c++);this.LODs.splice(c,0,{visibleAtDistance:b,object3D:a});this.add(a)};
THREE.LOD.prototype.update=function(a){if(1<this.LODs.length){a.matrixWorldInverse.getInverse(a.matrixWorld);a=a.matrixWorldInverse;a=-(a.n31*this.position.x+a.n32*this.position.y+a.n33*this.position.z+a.n34);this.LODs[0].object3D.visible=!0;for(var b=1;b<this.LODs.length;b++)if(a>=this.LODs[b].visibleAtDistance)this.LODs[b-1].object3D.visible=!1,this.LODs[b].object3D.visible=!0;else break;for(;b<this.LODs.length;b++)this.LODs[b].object3D.visible=!1}};
THREE.Sprite=function(a){THREE.Object3D.call(this);this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:new THREE.Texture;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.useScreenCoordinates=void 0!==a.useScreenCoordinates?a.useScreenCoordinates:!0;this.mergeWith3D=void 0!==a.mergeWith3D?a.mergeWith3D:!this.useScreenCoordinates;this.affectedByDistance=void 0!==a.affectedByDistance?a.affectedByDistance:!this.useScreenCoordinates;
this.scaleByViewport=void 0!==a.scaleByViewport?a.scaleByViewport:!this.affectedByDistance;this.alignment=a.alignment instanceof THREE.Vector2?a.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(1!==this.scale.x||1!==this.scale.y)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);
THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.overrideMaterial=this.fog=null;this.matrixAutoUpdate=!1;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.addObject=function(a){if(a instanceof THREE.Light)-1===this.lights.indexOf(a)&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&-1===this.objects.indexOf(a)){this.objects.push(a);this.__objectsAdded.push(a);var b=this.__objectsRemoved.indexOf(a);-1!==b&&this.__objectsRemoved.splice(b,1)}for(b=0;b<a.children.length;b++)this.addObject(a.children[b])};
THREE.Scene.prototype.removeObject=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);-1!==b&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),-1!==b&&(this.objects.splice(b,1),this.__objectsRemoved.push(a),b=this.__objectsAdded.indexOf(a),-1!==b&&this.__objectsAdded.splice(b,1)));for(b=0;b<a.children.length;b++)this.removeObject(a.children[b])};
THREE.Fog=function(a,b,c){this.color=new THREE.Color(a);this.near=void 0!==b?b:1;this.far=void 0!==c?c:1E3};THREE.FogExp2=function(a,b){this.color=new THREE.Color(a);this.density=void 0!==b?b:2.5E-4};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform float flipEnvMap;\nuniform int combine;\n#endif",
envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( flipEnvMap * vReflect.x, vReflect.yz ) );\n#ifdef GAMMA_INPUT\ncubeColor.xyz *= cubeColor.xyz;\n#endif\nif ( combine == 1 ) {\ngl_FragColor.xyz = mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity );\n} else {\ngl_FragColor.xyz = gl_FragColor.xyz * cubeColor.xyz;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",
map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform vec4 offsetRepeat;\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",map_fragment:"#ifdef USE_MAP\n#ifdef GAMMA_INPUT\nvec4 texelColor = texture2D( map, vUv );\ntexelColor.xyz *= texelColor.xyz;\ngl_FragColor = gl_FragColor * texelColor;\n#else\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif\n#endif",
lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_lambert_pars_vertex:"uniform vec3 ambient;\nuniform vec3 diffuse;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#endif\n#ifdef WRAP_AROUND\nuniform vec3 wrapRGB;\n#endif",
lights_lambert_vertex:"vLightWeighting = vec3( 0.0 );\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\n#ifdef WRAP_AROUND\nfloat directionalLightWeightingFull = max( dot( transformedNormal, dirVector ), 0.0 );\nfloat directionalLightWeightingHalf = max( 0.5 * dot( transformedNormal, dirVector ) + 0.5, 0.0 );\nvec3 directionalLightWeighting = mix( vec3( directionalLightWeightingFull ), vec3( directionalLightWeightingHalf ), wrapRGB );\n#else\nfloat directionalLightWeighting = max( dot( transformedNormal, dirVector ), 0.0 );\n#endif\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\n#ifdef WRAP_AROUND\nfloat pointLightWeightingFull = max( dot( transformedNormal, lVector ), 0.0 );\nfloat pointLightWeightingHalf = max( 0.5 * dot( transformedNormal, lVector ) + 0.5, 0.0 );\nvec3 pointLightWeighting = mix( vec3 ( pointLightWeightingFull ), vec3( pointLightWeightingHalf ), wrapRGB );\n#else\nfloat pointLightWeighting = max( dot( transformedNormal, lVector ), 0.0 );\n#endif\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting * lDistance;\n}\n#endif\nvLightWeighting = vLightWeighting * diffuse + ambient * ambientLightColor;",
lights_phong_pars_vertex:"#if MAX_POINT_LIGHTS > 0\n#ifndef PHONG_PER_PIXEL\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif",lights_phong_vertex:"#if MAX_POINT_LIGHTS > 0\n#ifndef PHONG_PER_PIXEL\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nvPointLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#endif",
lights_phong_pars_fragment:"uniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\n#ifdef PHONG_PER_PIXEL\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#else\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif\n#ifdef WRAP_AROUND\nuniform vec3 wrapRGB;\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",
lights_phong_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\n#if MAX_POINT_LIGHTS > 0\nvec3 pointDiffuse  = vec3( 0.0 );\nvec3 pointSpecular = vec3( 0.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\n#ifdef PHONG_PER_PIXEL\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz + vViewPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\n#else\nvec3 lVector = normalize( vPointLight[ i ].xyz );\nfloat lDistance = vPointLight[ i ].w;\n#endif\n#ifdef WRAP_AROUND\nfloat pointDiffuseWeightFull = max( dot( normal, lVector ), 0.0 );\nfloat pointDiffuseWeightHalf = max( 0.5 * dot( normal, lVector ) + 0.5, 0.0 );\nvec3 pointDiffuseWeight = mix( vec3 ( pointDiffuseWeightFull ), vec3( pointDiffuseWeightHalf ), wrapRGB );\n#else\nfloat pointDiffuseWeight = max( dot( normal, lVector ), 0.0 );\n#endif\npointDiffuse  += diffuse * pointLightColor[ i ] * pointDiffuseWeight * lDistance;\nvec3 pointHalfVector = normalize( lVector + viewPosition );\nfloat pointDotNormalHalf = max( dot( normal, pointHalfVector ), 0.0 );\nfloat pointSpecularWeight = max( pow( pointDotNormalHalf, shininess ), 0.0 );\n#ifdef PHYSICALLY_BASED_SHADING\nvec3 schlick = specular + vec3( 1.0 - specular ) * pow( dot( lVector, pointHalfVector ), 5.0 );\npointSpecular += schlick * pointLightColor[ i ] * pointSpecularWeight * pointDiffuseWeight * lDistance;\n#else\npointSpecular += specular * pointLightColor[ i ] * pointSpecularWeight * pointDiffuseWeight * lDistance;\n#endif\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec3 dirDiffuse  = vec3( 0.0 );\nvec3 dirSpecular = vec3( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\n#ifdef WRAP_AROUND\nfloat dirDiffuseWeightFull = max( dot( normal, dirVector ), 0.0 );\nfloat dirDiffuseWeightHalf = max( 0.5 * dot( normal, dirVector ) + 0.5, 0.0 );\nvec3 dirDiffuseWeight = mix( vec3( dirDiffuseWeightFull ), vec3( dirDiffuseWeightHalf ), wrapRGB );\n#else\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\n#endif\ndirDiffuse  += diffuse * directionalLightColor[ i ] * dirDiffuseWeight;\nvec3 dirHalfVector = normalize( dirVector + viewPosition );\nfloat dirDotNormalHalf = max( dot( normal, dirHalfVector ), 0.0 );\nfloat dirSpecularWeight = max( pow( dirDotNormalHalf, shininess ), 0.0 );\n#ifdef PHYSICALLY_BASED_SHADING\nvec3 schlick = specular + vec3( 1.0 - specular ) * pow( dot( dirVector, dirHalfVector ), 5.0 );\ndirSpecular += schlick * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight;\n#else\ndirSpecular += specular * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight;\n#endif\n}\n#endif\nvec3 totalDiffuse = vec3( 0.0 );\nvec3 totalSpecular = vec3( 0.0 );\n#if MAX_DIR_LIGHTS > 0\ntotalDiffuse += dirDiffuse;\ntotalSpecular += dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalDiffuse += pointDiffuse;\ntotalSpecular += pointSpecular;\n#endif\n#ifdef METAL\ngl_FragColor.xyz = gl_FragColor.xyz * ( totalDiffuse + ambientLightColor * ambient + totalSpecular );\n#else\ngl_FragColor.xyz = gl_FragColor.xyz * ( totalDiffuse + ambientLightColor * ambient ) + totalSpecular;\n#endif",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\n#ifdef GAMMA_INPUT\nvColor = color * color;\n#else\nvColor = color;\n#endif\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\nuniform float morphTargetInfluences[ 8 ];\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0, 0.0, 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\nuniform sampler2D shadowMap[ MAX_SHADOWS ];\nuniform vec2 shadowMapSize[ MAX_SHADOWS ];\nuniform float shadowDarkness[ MAX_SHADOWS ];\nuniform float shadowBias[ MAX_SHADOWS ];\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nfloat unpackDepth( const in vec4 rgba_depth ) {\nconst vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\nfloat depth = dot( rgba_depth, bit_shift );\nreturn depth;\n}\n#endif",
shadowmap_fragment:"#ifdef USE_SHADOWMAP\nvec3 shadowColor = vec3( 1.0 );\nfloat fDepth;\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvec3 shadowCoord = vShadowCoord[ i ].xyz / vShadowCoord[ i ].w;\nif ( shadowCoord.z <= 1.0 ) {\nshadowCoord.z += shadowBias[ i ];\nbvec4 shadowTest = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\nif ( all( shadowTest ) ) {\n#ifdef SHADOWMAP_SOFT\nfloat shadow = 0.0;\nconst float shadowDelta = 1.0 / 9.0;\nfloat xPixelOffset = 1.0 / shadowMapSize[ i ].x;\nfloat yPixelOffset = 1.0 / shadowMapSize[ i ].y;\nfloat dx0 = -1.25 * xPixelOffset;\nfloat dy0 = -1.25 * yPixelOffset;\nfloat dx1 = 1.25 * xPixelOffset;\nfloat dy1 = 1.25 * yPixelOffset;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, 0.0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, 0.0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy1 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy1 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy1 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nshadowColor = shadowColor * vec3( ( 1.0 - shadowDarkness[ i ] * shadow ) );\n#else\nvec4 rgbaDepth = texture2D( shadowMap[ i ], shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < shadowCoord.z )\nshadowColor = shadowColor * vec3( 1.0 - shadowDarkness[ i ] );\n#endif\n}\n}\n}\n#ifdef GAMMA_OUTPUT\nshadowColor *= shadowColor;\n#endif\ngl_FragColor.xyz = gl_FragColor.xyz * shadowColor;\n#endif",
shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nuniform mat4 shadowMatrix[ MAX_SHADOWS ];\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\n#ifdef USE_MORPHTARGETS\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( morphed, 1.0 );\n#else\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( position, 1.0 );\n#endif\n}\n#endif",alphatest_fragment:"#ifdef ALPHATEST\nif ( gl_FragColor.a < ALPHATEST ) discard;\n#endif",
linear_to_gamma_fragment:"#ifdef GAMMA_OUTPUT\ngl_FragColor.xyz = sqrt( gl_FragColor.xyz );\n#endif"};
THREE.UniformsUtils={merge:function(a){var b,c,d,e={};for(b=0;b<a.length;b++)for(c in d=this.clone(a[b]),d)e[c]=d[c];return e},clone:function(a){var b,c,d,e={};for(b in a)for(c in e[b]={},a[b])d=a[b][c],e[b][c]=d instanceof THREE.Color||d instanceof THREE.Vector2||d instanceof THREE.Vector3||d instanceof THREE.Vector4||d instanceof THREE.Matrix4||d instanceof THREE.Texture?d.clone():d instanceof Array?d.slice():d;return e}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},flipEnvMap:{type:"f",value:-1},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},morphTargetInfluences:{type:"f",value:0}},fog:{fogDensity:{type:"f",
value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",
value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},shadowmap:{shadowMap:{type:"tv",value:6,texture:[]},shadowMapSize:{type:"v2v",value:[]},shadowBias:{type:"fv1",value:[]},shadowDarkness:{type:"fv1",value:[]},shadowMatrix:{type:"m4v",value:[]}}};
THREE.ShaderLib={depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}"},normal:{uniforms:{opacity:{type:"f",
value:1}},vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}",fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}"},basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.shadowmap]),vertexShader:[THREE.ShaderChunk.map_pars_vertex,
THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,
THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,
THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(328965)},wrapRGB:{type:"v3",value:new THREE.Vector3(1,1,1)}}]),vertexShader:["varying vec3 vLightWeighting;",
THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_lambert_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,
"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.ShaderChunk.lights_lambert_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform float opacity;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,
THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3 ( 1.0 ), opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,"gl_FragColor.xyz = gl_FragColor.xyz * vLightWeighting;",THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,
THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30},wrapRGB:{type:"v3",value:new THREE.Vector3(1,1,1)}}]),vertexShader:["varying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_phong_pars_vertex,THREE.ShaderChunk.color_pars_vertex,
THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = -mvPosition.xyz;\nvec3 transformedNormal = normalMatrix * normal;\nvNormal = transformedNormal;",
THREE.ShaderChunk.lights_phong_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,
THREE.ShaderChunk.lights_phong_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3 ( 1.0 ), opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lights_phong_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.particle,
THREE.UniformsLib.shadowmap]),vertexShader:["uniform float size;\nuniform float scale;",THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;",THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",
THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},depthRGBA:{uniforms:{},vertexShader:[THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",
THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n"),fragmentShader:"vec4 pack_depth( const in float depth ) {\nconst vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );\nconst vec4 bit_mask  = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );\nvec4 res = fract( depth * bit_shift );\nres -= res.xxyz * bit_mask;\nreturn res;\n}\nvoid main() {\ngl_FragData[ 0 ] = pack_depth( gl_FragCoord.z );\n}"}};
THREE.WebGLRenderer=function(a){function b(a,b){var c=a.vertices.length,d=b.material;if(d.attributes){if(void 0===a.__webglCustomAttributesList)a.__webglCustomAttributesList=[];for(var e in d.attributes){var f=d.attributes[e];if(!f.__webglInitialized||f.createUniqueBuffers){f.__webglInitialized=!0;var h=1;"v2"===f.type?h=2:"v3"===f.type?h=3:"v4"===f.type?h=4:"c"===f.type&&(h=3);f.size=h;f.array=new Float32Array(c*h);f.buffer=g.createBuffer();f.buffer.belongsToAttribute=e;f.needsUpdate=!0}a.__webglCustomAttributesList.push(f)}}}
function c(a,b){if(a.material&&!(a.material instanceof THREE.MeshFaceMaterial))return a.material;if(0<=b.materialIndex)return a.geometry.materials[b.materialIndex]}function d(a){return a instanceof THREE.MeshBasicMaterial&&!a.envMap||a instanceof THREE.MeshDepthMaterial?!1:a&&void 0!==a.shading&&a.shading===THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading}function e(a){return a.map||a.lightMap||a instanceof THREE.ShaderMaterial?!0:!1}function f(a,b,c){var d,e,f,h,i=a.vertices;h=i.length;
var j=a.colors,l=j.length,n=a.__vertexArray,m=a.__colorArray,k=a.__sortArray,p=a.__dirtyVertices,o=a.__dirtyColors,r=a.__webglCustomAttributesList;if(c.sortParticles){Va.multiplySelf(c.matrixWorld);for(d=0;d<h;d++)e=i[d].position,Ia.copy(e),Va.multiplyVector3(Ia),k[d]=[Ia.z,d];k.sort(function(a,b){return b[0]-a[0]});for(d=0;d<h;d++)e=i[k[d][1]].position,f=3*d,n[f]=e.x,n[f+1]=e.y,n[f+2]=e.z;for(d=0;d<l;d++)f=3*d,e=j[k[d][1]],m[f]=e.r,m[f+1]=e.g,m[f+2]=e.b;if(r)for(j=0,l=r.length;j<l;j++)if(i=r[j],
void 0===i.boundTo||"vertices"===i.boundTo)if(f=0,e=i.value.length,1===i.size)for(d=0;d<e;d++)h=k[d][1],i.array[d]=i.value[h];else if(2===i.size)for(d=0;d<e;d++)h=k[d][1],h=i.value[h],i.array[f]=h.x,i.array[f+1]=h.y,f+=2;else if(3===i.size)if("c"===i.type)for(d=0;d<e;d++)h=k[d][1],h=i.value[h],i.array[f]=h.r,i.array[f+1]=h.g,i.array[f+2]=h.b,f+=3;else for(d=0;d<e;d++)h=k[d][1],h=i.value[h],i.array[f]=h.x,i.array[f+1]=h.y,i.array[f+2]=h.z,f+=3;else if(4===i.size)for(d=0;d<e;d++)h=k[d][1],h=i.value[h],
i.array[f]=h.x,i.array[f+1]=h.y,i.array[f+2]=h.z,i.array[f+3]=h.w,f+=4}else{if(p)for(d=0;d<h;d++)e=i[d].position,f=3*d,n[f]=e.x,n[f+1]=e.y,n[f+2]=e.z;if(o)for(d=0;d<l;d++)e=j[d],f=3*d,m[f]=e.r,m[f+1]=e.g,m[f+2]=e.b;if(r)for(j=0,l=r.length;j<l;j++)if(i=r[j],i.needsUpdate&&(void 0===i.boundTo||"vertices"===i.boundTo))if(e=i.value.length,f=0,1===i.size)for(d=0;d<e;d++)i.array[d]=i.value[d];else if(2===i.size)for(d=0;d<e;d++)h=i.value[d],i.array[f]=h.x,i.array[f+1]=h.y,f+=2;else if(3===i.size)if("c"===
i.type)for(d=0;d<e;d++)h=i.value[d],i.array[f]=h.r,i.array[f+1]=h.g,i.array[f+2]=h.b,f+=3;else for(d=0;d<e;d++)h=i.value[d],i.array[f]=h.x,i.array[f+1]=h.y,i.array[f+2]=h.z,f+=3;else if(4===i.size)for(d=0;d<e;d++)h=i.value[d],i.array[f]=h.x,i.array[f+1]=h.y,i.array[f+2]=h.z,i.array[f+3]=h.w,f+=4}if(p||c.sortParticles)g.bindBuffer(g.ARRAY_BUFFER,a.__webglVertexBuffer),g.bufferData(g.ARRAY_BUFFER,n,b);if(o||c.sortParticles)g.bindBuffer(g.ARRAY_BUFFER,a.__webglColorBuffer),g.bufferData(g.ARRAY_BUFFER,
m,b);if(r)for(j=0,l=r.length;j<l;j++)if(i=r[j],i.needsUpdate||c.sortParticles)g.bindBuffer(g.ARRAY_BUFFER,i.buffer),g.bufferData(g.ARRAY_BUFFER,i.array,b)}function h(a,b){return b.z-a.z}function i(a,b,c){if(a.length)for(var d=0,g=a.length;d<g;d++)W=ba=null,Q=L=Oa=Na=Ba=-1,a[d].render(b,c,cc,dc),W=ba=null,Q=L=Oa=Na=Ba=-1}function k(a,b,c,d,g,e,f,h){var i,j,l,n;b?(j=a.length-1,n=b=-1):(j=0,b=a.length,n=1);for(var m=j;m!==b;m+=n)if(i=a[m],i.render){j=i.object;l=i.buffer;if(h)i=h;else{i=i[c];if(!i)continue;
f&&D.setBlending(i.blending);D.setDepthTest(i.depthTest);D.setDepthWrite(i.depthWrite);z(i.polygonOffset,i.polygonOffsetFactor,i.polygonOffsetUnits)}D.setObjectFaces(j);l instanceof THREE.BufferGeometry?D.renderBufferDirect(d,g,e,i,l,j):D.renderBuffer(d,g,e,i,l,j)}}function l(a,b,c,d,g,e,f){for(var h,i,j=0,l=a.length;j<l;j++)if(h=a[j],i=h.object,i.visible){if(f)h=f;else{h=h[b];if(!h)continue;e&&D.setBlending(h.blending);D.setDepthTest(h.depthTest);D.setDepthWrite(h.depthWrite);z(h.polygonOffset,h.polygonOffsetFactor,
h.polygonOffsetUnits)}D.renderImmediateObject(c,d,g,h,i)}}function j(a,b,c){a.push({buffer:b,object:c,opaque:null,transparent:null})}function n(a){for(var b in a.attributes)if(a.attributes[b].needsUpdate)return!0;return!1}function p(a){for(var b in a.attributes)a.attributes[b].needsUpdate=!1}function o(a,b){for(var c=a.length-1;0<=c;c--)a[c].object===b&&a.splice(c,1)}function m(a,b){for(var c=a.length-1;0<=c;c--)a[c]===b&&a.splice(c,1)}function r(a,b,c,d,e){d.program||D.initMaterial(d,b,c,e);if(d.morphTargets&&
!e.__webglMorphTargetInfluences){e.__webglMorphTargetInfluences=new Float32Array(D.maxMorphTargets);for(var f=0,h=D.maxMorphTargets;f<h;f++)e.__webglMorphTargetInfluences[f]=0}var i=!1,f=d.program,h=f.uniforms,j=d.uniforms;f!==ba&&(g.useProgram(f),ba=f,i=!0);if(d.id!==Q)Q=d.id,i=!0;if(i||a!==W)g.uniformMatrix4fv(h.projectionMatrix,!1,a._projectionMatrixArray),a!==W&&(W=a);if(i){if(c&&d.fog)if(j.fogColor.value=c.color,c instanceof THREE.Fog)j.fogNear.value=c.near,j.fogFar.value=c.far;else if(c instanceof
THREE.FogExp2)j.fogDensity.value=c.density;if(d instanceof THREE.MeshPhongMaterial||d instanceof THREE.MeshLambertMaterial||d.lights){var l,n=0,m=0,k=0,p,o,r,t=ec,u=t.directional.colors,z=t.directional.positions,y=t.point.colors,A=t.point.positions,K=t.point.distances,M=0,I=0,N=r=0;for(c=0,i=b.length;c<i;c++)if(l=b[c],!l.onlyShadow)if(p=l.color,o=l.intensity,r=l.distance,l instanceof THREE.AmbientLight)D.gammaInput?(n+=p.r*p.r,m+=p.g*p.g,k+=p.b*p.b):(n+=p.r,m+=p.g,k+=p.b);else if(l instanceof THREE.DirectionalLight)r=
3*M,D.gammaInput?(u[r]=p.r*p.r*o*o,u[r+1]=p.g*p.g*o*o,u[r+2]=p.b*p.b*o*o):(u[r]=p.r*o,u[r+1]=p.g*o,u[r+2]=p.b*o),ib.copy(l.matrixWorld.getPosition()),ib.subSelf(l.target.matrixWorld.getPosition()),ib.normalize(),z[r]=ib.x,z[r+1]=ib.y,z[r+2]=ib.z,M+=1;else if(l instanceof THREE.PointLight||l instanceof THREE.SpotLight)N=3*I,D.gammaInput?(y[N]=p.r*p.r*o*o,y[N+1]=p.g*p.g*o*o,y[N+2]=p.b*p.b*o*o):(y[N]=p.r*o,y[N+1]=p.g*o,y[N+2]=p.b*o),l=l.matrixWorld.getPosition(),A[N]=l.x,A[N+1]=l.y,A[N+2]=l.z,K[I]=r,
I+=1;for(c=3*M,i=u.length;c<i;c++)u[c]=0;for(c=3*I,i=y.length;c<i;c++)y[c]=0;t.point.length=I;t.directional.length=M;t.ambient[0]=n;t.ambient[1]=m;t.ambient[2]=k;c=ec;j.ambientLightColor.value=c.ambient;j.directionalLightColor.value=c.directional.colors;j.directionalLightDirection.value=c.directional.positions;j.pointLightColor.value=c.point.colors;j.pointLightPosition.value=c.point.positions;j.pointLightDistance.value=c.point.distances}if(d instanceof THREE.MeshBasicMaterial||d instanceof THREE.MeshLambertMaterial||
d instanceof THREE.MeshPhongMaterial)j.opacity.value=d.opacity,D.gammaInput?j.diffuse.value.copyGammaToLinear(d.color):j.diffuse.value=d.color,(j.map.texture=d.map)&&j.offsetRepeat.value.set(d.map.offset.x,d.map.offset.y,d.map.repeat.x,d.map.repeat.y),j.lightMap.texture=d.lightMap,j.envMap.texture=d.envMap,j.flipEnvMap.value=d.envMap instanceof THREE.WebGLRenderTargetCube?1:-1,j.reflectivity.value=d.reflectivity,j.refractionRatio.value=d.refractionRatio,j.combine.value=d.combine,j.useRefract.value=
d.envMap&&d.envMap.mapping instanceof THREE.CubeRefractionMapping;if(d instanceof THREE.LineBasicMaterial)j.diffuse.value=d.color,j.opacity.value=d.opacity;else if(d instanceof THREE.ParticleBasicMaterial)j.psColor.value=d.color,j.opacity.value=d.opacity,j.size.value=d.size,j.scale.value=H.height/2,j.map.texture=d.map;else if(d instanceof THREE.MeshPhongMaterial)j.shininess.value=d.shininess,D.gammaInput?(j.ambient.value.copyGammaToLinear(d.ambient),j.specular.value.copyGammaToLinear(d.specular)):
(j.ambient.value=d.ambient,j.specular.value=d.specular),d.wrapAround&&j.wrapRGB.value.copy(d.wrapRGB);else if(d instanceof THREE.MeshLambertMaterial)D.gammaInput?j.ambient.value.copyGammaToLinear(d.ambient):j.ambient.value=d.ambient,d.wrapAround&&j.wrapRGB.value.copy(d.wrapRGB);else if(d instanceof THREE.MeshDepthMaterial)j.mNear.value=a.near,j.mFar.value=a.far,j.opacity.value=d.opacity;else if(d instanceof THREE.MeshNormalMaterial)j.opacity.value=d.opacity;if(e.receiveShadow&&!d._shadowPass&&j.shadowMatrix){i=
c=0;for(n=b.length;i<n;i++)if(m=b[i],m.castShadow&&(m instanceof THREE.SpotLight||m instanceof THREE.DirectionalLight))j.shadowMap.texture[c]=m.shadowMap,j.shadowMapSize.value[c]=m.shadowMapSize,j.shadowMatrix.value[c]=m.shadowMatrix,j.shadowDarkness.value[c]=m.shadowDarkness,j.shadowBias.value[c]=m.shadowBias,c++}b=d.uniformsList;for(j=0,c=b.length;j<c;j++)if(m=f.uniforms[b[j][1]])if(i=b[j][0],k=i.type,n=i.value,"i"===k)g.uniform1i(m,n);else if("f"===k)g.uniform1f(m,n);else if("v2"===k)g.uniform2f(m,
n.x,n.y);else if("v3"===k)g.uniform3f(m,n.x,n.y,n.z);else if("v4"===k)g.uniform4f(m,n.x,n.y,n.z,n.w);else if("c"===k)g.uniform3f(m,n.r,n.g,n.b);else if("fv1"===k)g.uniform1fv(m,n);else if("fv"===k)g.uniform3fv(m,n);else if("v2v"===k){if(!i._array)i._array=new Float32Array(2*n.length);for(k=0,t=n.length;k<t;k++)u=2*k,i._array[u]=n[k].x,i._array[u+1]=n[k].y;g.uniform2fv(m,i._array)}else if("v3v"===k){if(!i._array)i._array=new Float32Array(3*n.length);for(k=0,t=n.length;k<t;k++)u=3*k,i._array[u]=n[k].x,
i._array[u+1]=n[k].y,i._array[u+2]=n[k].z;g.uniform3fv(m,i._array)}else if("v4v"==k){if(!i._array)i._array=new Float32Array(4*n.length);for(k=0,t=n.length;k<t;k++)u=4*k,i._array[u]=n[k].x,i._array[u+1]=n[k].y,i._array[u+2]=n[k].z,i._array[u+3]=n[k].w;g.uniform4fv(m,i._array)}else if("m4"===k){if(!i._array)i._array=new Float32Array(16);n.flattenToArray(i._array);g.uniformMatrix4fv(m,!1,i._array)}else if("m4v"===k){if(!i._array)i._array=new Float32Array(16*n.length);for(k=0,t=n.length;k<t;k++)n[k].flattenToArrayOffset(i._array,
16*k);g.uniformMatrix4fv(m,!1,i._array)}else if("t"===k){if(g.uniform1i(m,n),m=i.texture)if(m.image instanceof Array&&6===m.image.length){if(i=m,6===i.image.length)if(i.needsUpdate){if(!i.image.__webglTextureCube)i.image.__webglTextureCube=g.createTexture();g.activeTexture(g.TEXTURE0+n);g.bindTexture(g.TEXTURE_CUBE_MAP,i.image.__webglTextureCube);n=[];for(m=0;6>m;m++){k=n;t=m;if(D.autoScaleCubemaps){if(u=i.image[m],y=uc,!(u.width<=y&&u.height<=y))A=Math.max(u.width,u.height),z=Math.floor(u.width*
y/A),y=Math.floor(u.height*y/A),A=document.createElement("canvas"),A.width=z,A.height=y,A.getContext("2d").drawImage(u,0,0,u.width,u.height,0,0,z,y),u=A}else u=i.image[m];k[t]=u}m=n[0];k=0===(m.width&m.width-1)&&0===(m.height&m.height-1);t=B(i.format);u=B(i.type);J(g.TEXTURE_CUBE_MAP,i,k);for(m=0;6>m;m++)g.texImage2D(g.TEXTURE_CUBE_MAP_POSITIVE_X+m,0,t,t,u,n[m]);i.generateMipmaps&&k&&g.generateMipmap(g.TEXTURE_CUBE_MAP);i.needsUpdate=!1;if(i.onUpdated)i.onUpdated()}else g.activeTexture(g.TEXTURE0+
n),g.bindTexture(g.TEXTURE_CUBE_MAP,i.image.__webglTextureCube)}else m instanceof THREE.WebGLRenderTargetCube?(i=m,g.activeTexture(g.TEXTURE0+n),g.bindTexture(g.TEXTURE_CUBE_MAP,i.__webglTexture)):D.setTexture(m,n)}else if("tv"===k){if(!i._array){i._array=[];for(k=0,t=i.texture.length;k<t;k++)i._array[k]=n+k}g.uniform1iv(m,i._array);for(k=0,t=i.texture.length;k<t;k++)(m=i.texture[k])&&D.setTexture(m,i._array[k])}(d instanceof THREE.ShaderMaterial||d instanceof THREE.MeshPhongMaterial||d.envMap)&&
null!==h.cameraPosition&&g.uniform3f(h.cameraPosition,a.position.x,a.position.y,a.position.z);(d instanceof THREE.MeshPhongMaterial||d instanceof THREE.MeshLambertMaterial||d instanceof THREE.ShaderMaterial||d.skinning)&&null!==h.viewMatrix&&g.uniformMatrix4fv(h.viewMatrix,!1,a._viewMatrixArray);d.skinning&&(g.uniformMatrix4fv(h.cameraInverseMatrix,!1,a._viewMatrixArray),g.uniformMatrix4fv(h.boneGlobalMatrices,!1,e.boneMatrices))}g.uniformMatrix4fv(h.modelViewMatrix,!1,e._modelViewMatrixArray);h.normalMatrix&&
g.uniformMatrix3fv(h.normalMatrix,!1,e._normalMatrixArray);(d instanceof THREE.ShaderMaterial||d.envMap||d.skinning||e.receiveShadow)&&null!==h.objectMatrix&&g.uniformMatrix4fv(h.objectMatrix,!1,e._objectMatrixArray);return f}function t(a,b){a._modelViewMatrix.multiplyToArray(b.matrixWorldInverse,a.matrixWorld,a._modelViewMatrixArray);var c=THREE.Matrix4.makeInvert3x3(a._modelViewMatrix);c&&c.transposeIntoArray(a._normalMatrixArray)}function z(a,b,c){Pa!==a&&(a?g.enable(g.POLYGON_OFFSET_FILL):g.disable(g.POLYGON_OFFSET_FILL),
Pa=a);if(a&&(Ta!==b||Ua!==c))g.polygonOffset(b,c),Ta=b,Ua=c}function y(a,b){var c;"fragment"===a?c=g.createShader(g.FRAGMENT_SHADER):"vertex"===a&&(c=g.createShader(g.VERTEX_SHADER));g.shaderSource(c,b);g.compileShader(c);return!g.getShaderParameter(c,g.COMPILE_STATUS)?(console.error(g.getShaderInfoLog(c)),console.error(b),null):c}function J(a,b,c){c?(g.texParameteri(a,g.TEXTURE_WRAP_S,B(b.wrapS)),g.texParameteri(a,g.TEXTURE_WRAP_T,B(b.wrapT)),g.texParameteri(a,g.TEXTURE_MAG_FILTER,B(b.magFilter)),
g.texParameteri(a,g.TEXTURE_MIN_FILTER,B(b.minFilter))):(g.texParameteri(a,g.TEXTURE_WRAP_S,g.CLAMP_TO_EDGE),g.texParameteri(a,g.TEXTURE_WRAP_T,g.CLAMP_TO_EDGE),g.texParameteri(a,g.TEXTURE_MAG_FILTER,u(b.magFilter)),g.texParameteri(a,g.TEXTURE_MIN_FILTER,u(b.minFilter)))}function K(a,b){g.bindRenderbuffer(g.RENDERBUFFER,a);b.depthBuffer&&!b.stencilBuffer?(g.renderbufferStorage(g.RENDERBUFFER,g.DEPTH_COMPONENT16,b.width,b.height),g.framebufferRenderbuffer(g.FRAMEBUFFER,g.DEPTH_ATTACHMENT,g.RENDERBUFFER,
a)):b.depthBuffer&&b.stencilBuffer?(g.renderbufferStorage(g.RENDERBUFFER,g.DEPTH_STENCIL,b.width,b.height),g.framebufferRenderbuffer(g.FRAMEBUFFER,g.DEPTH_STENCIL_ATTACHMENT,g.RENDERBUFFER,a)):g.renderbufferStorage(g.RENDERBUFFER,g.RGBA4,b.width,b.height)}function u(a){switch(a){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return g.NEAREST;default:return g.LINEAR}}function B(a){switch(a){case THREE.RepeatWrapping:return g.REPEAT;case THREE.ClampToEdgeWrapping:return g.CLAMP_TO_EDGE;
case THREE.MirroredRepeatWrapping:return g.MIRRORED_REPEAT;case THREE.NearestFilter:return g.NEAREST;case THREE.NearestMipMapNearestFilter:return g.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return g.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return g.LINEAR;case THREE.LinearMipMapNearestFilter:return g.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return g.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return g.BYTE;case THREE.UnsignedByteType:return g.UNSIGNED_BYTE;case THREE.ShortType:return g.SHORT;
case THREE.UnsignedShortType:return g.UNSIGNED_SHORT;case THREE.IntType:return g.INT;case THREE.UnsignedShortType:return g.UNSIGNED_INT;case THREE.FloatType:return g.FLOAT;case THREE.AlphaFormat:return g.ALPHA;case THREE.RGBFormat:return g.RGB;case THREE.RGBAFormat:return g.RGBA;case THREE.LuminanceFormat:return g.LUMINANCE;case THREE.LuminanceAlphaFormat:return g.LUMINANCE_ALPHA}return 0}var a=a||{},H=void 0!==a.canvas?a.canvas:document.createElement("canvas"),A=void 0!==a.precision?a.precision:
"mediump",M=void 0!==a.alpha?a.alpha:!0,N=void 0!==a.premultipliedAlpha?a.premultipliedAlpha:!0,I=void 0!==a.antialias?a.antialias:!1,S=void 0!==a.stencil?a.stencil:!0,ua=void 0!==a.preserveDrawingBuffer?a.preserveDrawingBuffer:!1,ka=void 0!==a.clearColor?new THREE.Color(a.clearColor):new THREE.Color(0),$=void 0!==a.clearAlpha?a.clearAlpha:0,Z=void 0!==a.maxLights?a.maxLights:4;this.domElement=H;this.context=null;this.autoUpdateScene=this.autoUpdateObjects=this.sortObjects=this.autoClearStencil=this.autoClearDepth=
this.autoClearColor=this.autoClear=!0;this.shadowMapEnabled=this.physicallyBasedShading=this.gammaOutput=this.gammaInput=!1;this.shadowMapCullFrontFaces=this.shadowMapSoft=this.shadowMapAutoUpdate=!0;this.maxMorphTargets=8;this.autoScaleCubemaps=!0;this.renderPluginsPre=[];this.renderPluginsPost=[];this.info={memory:{programs:0,geometries:0,textures:0},render:{calls:0,vertices:0,faces:0,points:0}};var D=this,g,Sa=[],ba=null,pa=null,Q=-1,L=null,W=null,ya=0,ca=null,Ea=null,Ba=null,Na=null,Oa=null,Pa=
null,Ta=null,Ua=null,nb=null,Fb=0,Pb=0,Ab=0,Gb=0,cc=0,dc=0,Qb=new THREE.Frustum,Va=new THREE.Matrix4,Ia=new THREE.Vector4,ib=new THREE.Vector3,ec={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[]}};g=function(){var a;try{if(!(a=H.getContext("experimental-webgl",{alpha:M,premultipliedAlpha:N,antialias:I,stencil:S,preserveDrawingBuffer:ua})))throw"Error creating WebGL context.";console.log(navigator.userAgent+" | "+a.getParameter(a.VERSION)+
" | "+a.getParameter(a.VENDOR)+" | "+a.getParameter(a.RENDERER)+" | "+a.getParameter(a.SHADING_LANGUAGE_VERSION))}catch(b){console.error(b)}return a}();g.clearColor(0,0,0,1);g.clearDepth(1);g.clearStencil(0);g.enable(g.DEPTH_TEST);g.depthFunc(g.LEQUAL);g.frontFace(g.CCW);g.cullFace(g.BACK);g.enable(g.CULL_FACE);g.enable(g.BLEND);g.blendEquation(g.FUNC_ADD);g.blendFunc(g.SRC_ALPHA,g.ONE_MINUS_SRC_ALPHA);g.clearColor(ka.r,ka.g,ka.b,$);this.context=g;var fc=g.getParameter(g.MAX_VERTEX_TEXTURE_IMAGE_UNITS);
g.getParameter(g.MAX_TEXTURE_SIZE);var uc=g.getParameter(g.MAX_CUBE_MAP_TEXTURE_SIZE);this.getContext=function(){return g};this.supportsVertexTextures=function(){return 0<fc};this.setSize=function(a,b){H.width=a;H.height=b;this.setViewport(0,0,H.width,H.height)};this.setViewport=function(a,b,c,d){Fb=a;Pb=b;Ab=c;Gb=d;g.viewport(Fb,Pb,Ab,Gb)};this.setScissor=function(a,b,c,d){g.scissor(a,b,c,d)};this.enableScissorTest=function(a){a?g.enable(g.SCISSOR_TEST):g.disable(g.SCISSOR_TEST)};this.setClearColorHex=
function(a,b){ka.setHex(a);$=b;g.clearColor(ka.r,ka.g,ka.b,$)};this.setClearColor=function(a,b){ka.copy(a);$=b;g.clearColor(ka.r,ka.g,ka.b,$)};this.getClearColor=function(){return ka};this.getClearAlpha=function(){return $};this.clear=function(a,b,c){var d=0;if(void 0===a||a)d|=g.COLOR_BUFFER_BIT;if(void 0===b||b)d|=g.DEPTH_BUFFER_BIT;if(void 0===c||c)d|=g.STENCIL_BUFFER_BIT;g.clear(d)};this.clearTarget=function(a,b,c,d){this.setRenderTarget(a);this.clear(b,c,d)};this.addPostPlugin=function(a){a.init(this);
this.renderPluginsPost.push(a)};this.addPrePlugin=function(a){a.init(this);this.renderPluginsPre.push(a)};this.deallocateObject=function(a){if(a.__webglInit)if(a.__webglInit=!1,delete a._modelViewMatrix,delete a._normalMatrixArray,delete a._modelViewMatrixArray,delete a._objectMatrixArray,a instanceof THREE.Mesh)for(var b in a.geometry.geometryGroups){var c=a.geometry.geometryGroups[b];g.deleteBuffer(c.__webglVertexBuffer);g.deleteBuffer(c.__webglNormalBuffer);g.deleteBuffer(c.__webglTangentBuffer);
g.deleteBuffer(c.__webglColorBuffer);g.deleteBuffer(c.__webglUVBuffer);g.deleteBuffer(c.__webglUV2Buffer);g.deleteBuffer(c.__webglSkinVertexABuffer);g.deleteBuffer(c.__webglSkinVertexBBuffer);g.deleteBuffer(c.__webglSkinIndicesBuffer);g.deleteBuffer(c.__webglSkinWeightsBuffer);g.deleteBuffer(c.__webglFaceBuffer);g.deleteBuffer(c.__webglLineBuffer);if(c.numMorphTargets)for(var d=0,e=c.numMorphTargets;d<e;d++)g.deleteBuffer(c.__webglMorphTargetsBuffers[d]);if(c.__webglCustomAttributesList)for(d in d=
void 0,c.__webglCustomAttributesList)g.deleteBuffer(c.__webglCustomAttributesList[d].buffer);D.info.memory.geometries--}else if(a instanceof THREE.Ribbon)a=a.geometry,g.deleteBuffer(a.__webglVertexBuffer),g.deleteBuffer(a.__webglColorBuffer),D.info.memory.geometries--;else if(a instanceof THREE.Line)a=a.geometry,g.deleteBuffer(a.__webglVertexBuffer),g.deleteBuffer(a.__webglColorBuffer),D.info.memory.geometries--;else if(a instanceof THREE.ParticleSystem)a=a.geometry,g.deleteBuffer(a.__webglVertexBuffer),
g.deleteBuffer(a.__webglColorBuffer),D.info.memory.geometries--};this.deallocateTexture=function(a){if(a.__webglInit)a.__webglInit=!1,g.deleteTexture(a.__webglTexture),D.info.memory.textures--};this.updateShadowMap=function(a,b){ba=null;Q=L=Oa=Na=Ba=-1;this.shadowMapPlugin.update(a,b)};this.renderBufferImmediate=function(a,b,c){if(!a.__webglVertexBuffer)a.__webglVertexBuffer=g.createBuffer();if(!a.__webglNormalBuffer)a.__webglNormalBuffer=g.createBuffer();a.hasPos&&(g.bindBuffer(g.ARRAY_BUFFER,a.__webglVertexBuffer),
g.bufferData(g.ARRAY_BUFFER,a.positionArray,g.DYNAMIC_DRAW),g.enableVertexAttribArray(b.attributes.position),g.vertexAttribPointer(b.attributes.position,3,g.FLOAT,!1,0,0));if(a.hasNormal){g.bindBuffer(g.ARRAY_BUFFER,a.__webglNormalBuffer);if(c===THREE.FlatShading){var d,e,f,h,i,j,n,m,k,l,p=3*a.count;for(l=0;l<p;l+=9)c=a.normalArray,d=c[l],e=c[l+1],f=c[l+2],h=c[l+3],j=c[l+4],m=c[l+5],i=c[l+6],n=c[l+7],k=c[l+8],d=(d+h+i)/3,e=(e+j+n)/3,f=(f+m+k)/3,c[l]=d,c[l+1]=e,c[l+2]=f,c[l+3]=d,c[l+4]=e,c[l+5]=f,
c[l+6]=d,c[l+7]=e,c[l+8]=f}g.bufferData(g.ARRAY_BUFFER,a.normalArray,g.DYNAMIC_DRAW);g.enableVertexAttribArray(b.attributes.normal);g.vertexAttribPointer(b.attributes.normal,3,g.FLOAT,!1,0,0)}g.drawArrays(g.TRIANGLES,0,a.count);a.count=0};this.renderBufferDirect=function(a,b,c,d,e,f){if(0!==d.opacity&&(c=r(a,b,c,d,f),a=c.attributes,b=!1,d=16777215*e.id+2*c.id+(d.wireframe?1:0),d!==L&&(L=d,b=!0),f instanceof THREE.Mesh)){f=e.offsets;d=0;for(c=f.length;d<c;++d)b&&(g.bindBuffer(g.ARRAY_BUFFER,e.vertexPositionBuffer),
g.vertexAttribPointer(a.position,e.vertexPositionBuffer.itemSize,g.FLOAT,!1,0,12*f[d].index),0<=a.normal&&e.vertexNormalBuffer&&(g.bindBuffer(g.ARRAY_BUFFER,e.vertexNormalBuffer),g.vertexAttribPointer(a.normal,e.vertexNormalBuffer.itemSize,g.FLOAT,!1,0,12*f[d].index)),0<=a.uv&&e.vertexUvBuffer&&(e.vertexUvBuffer?(g.bindBuffer(g.ARRAY_BUFFER,e.vertexUvBuffer),g.vertexAttribPointer(a.uv,e.vertexUvBuffer.itemSize,g.FLOAT,!1,0,8*f[d].index),g.enableVertexAttribArray(a.uv)):g.disableVertexAttribArray(a.uv)),
0<=a.color&&e.vertexColorBuffer&&(g.bindBuffer(g.ARRAY_BUFFER,e.vertexColorBuffer),g.vertexAttribPointer(a.color,e.vertexColorBuffer.itemSize,g.FLOAT,!1,0,16*f[d].index)),g.bindBuffer(g.ELEMENT_ARRAY_BUFFER,e.vertexIndexBuffer)),g.drawElements(g.TRIANGLES,f[d].count,g.UNSIGNED_SHORT,2*f[d].start),D.info.render.calls++,D.info.render.vertices+=f[d].count,D.info.render.faces+=f[d].count/3}};this.renderBuffer=function(a,b,c,d,e,f){if(0!==d.opacity){var h,i,c=r(a,b,c,d,f),b=c.attributes,a=!1,c=16777215*
e.id+2*c.id+(d.wireframe?1:0);c!==L&&(L=c,a=!0);if(!d.morphTargets&&0<=b.position)a&&(g.bindBuffer(g.ARRAY_BUFFER,e.__webglVertexBuffer),g.vertexAttribPointer(b.position,3,g.FLOAT,!1,0,0));else if(f.morphTargetBase){c=d.program.attributes;-1!==f.morphTargetBase?(g.bindBuffer(g.ARRAY_BUFFER,e.__webglMorphTargetsBuffers[f.morphTargetBase]),g.vertexAttribPointer(c.position,3,g.FLOAT,!1,0,0)):0<=c.position&&(g.bindBuffer(g.ARRAY_BUFFER,e.__webglVertexBuffer),g.vertexAttribPointer(c.position,3,g.FLOAT,
!1,0,0));if(f.morphTargetForcedOrder.length){h=0;var j=f.morphTargetForcedOrder;for(i=f.morphTargetInfluences;h<d.numSupportedMorphTargets&&h<j.length;)g.bindBuffer(g.ARRAY_BUFFER,e.__webglMorphTargetsBuffers[j[h]]),g.vertexAttribPointer(c["morphTarget"+h],3,g.FLOAT,!1,0,0),f.__webglMorphTargetInfluences[h]=i[j[h]],h++}else{var j=[],n=-1,l=0;i=f.morphTargetInfluences;var m,k=i.length;h=0;for(-1!==f.morphTargetBase&&(j[f.morphTargetBase]=!0);h<d.numSupportedMorphTargets;){for(m=0;m<k;m++)!j[m]&&i[m]>
n&&(l=m,n=i[l]);g.bindBuffer(g.ARRAY_BUFFER,e.__webglMorphTargetsBuffers[l]);g.vertexAttribPointer(c["morphTarget"+h],3,g.FLOAT,!1,0,0);f.__webglMorphTargetInfluences[h]=n;j[l]=1;n=-1;h++}}null!==d.program.uniforms.morphTargetInfluences&&g.uniform1fv(d.program.uniforms.morphTargetInfluences,f.__webglMorphTargetInfluences)}if(a){if(e.__webglCustomAttributesList)for(h=0,i=e.__webglCustomAttributesList.length;h<i;h++)c=e.__webglCustomAttributesList[h],0<=b[c.buffer.belongsToAttribute]&&(g.bindBuffer(g.ARRAY_BUFFER,
c.buffer),g.vertexAttribPointer(b[c.buffer.belongsToAttribute],c.size,g.FLOAT,!1,0,0));0<=b.color&&(g.bindBuffer(g.ARRAY_BUFFER,e.__webglColorBuffer),g.vertexAttribPointer(b.color,3,g.FLOAT,!1,0,0));0<=b.normal&&(g.bindBuffer(g.ARRAY_BUFFER,e.__webglNormalBuffer),g.vertexAttribPointer(b.normal,3,g.FLOAT,!1,0,0));0<=b.tangent&&(g.bindBuffer(g.ARRAY_BUFFER,e.__webglTangentBuffer),g.vertexAttribPointer(b.tangent,4,g.FLOAT,!1,0,0));0<=b.uv&&(e.__webglUVBuffer?(g.bindBuffer(g.ARRAY_BUFFER,e.__webglUVBuffer),
g.vertexAttribPointer(b.uv,2,g.FLOAT,!1,0,0),g.enableVertexAttribArray(b.uv)):g.disableVertexAttribArray(b.uv));0<=b.uv2&&(e.__webglUV2Buffer?(g.bindBuffer(g.ARRAY_BUFFER,e.__webglUV2Buffer),g.vertexAttribPointer(b.uv2,2,g.FLOAT,!1,0,0),g.enableVertexAttribArray(b.uv2)):g.disableVertexAttribArray(b.uv2));d.skinning&&0<=b.skinVertexA&&0<=b.skinVertexB&&0<=b.skinIndex&&0<=b.skinWeight&&(g.bindBuffer(g.ARRAY_BUFFER,e.__webglSkinVertexABuffer),g.vertexAttribPointer(b.skinVertexA,4,g.FLOAT,!1,0,0),g.bindBuffer(g.ARRAY_BUFFER,
e.__webglSkinVertexBBuffer),g.vertexAttribPointer(b.skinVertexB,4,g.FLOAT,!1,0,0),g.bindBuffer(g.ARRAY_BUFFER,e.__webglSkinIndicesBuffer),g.vertexAttribPointer(b.skinIndex,4,g.FLOAT,!1,0,0),g.bindBuffer(g.ARRAY_BUFFER,e.__webglSkinWeightsBuffer),g.vertexAttribPointer(b.skinWeight,4,g.FLOAT,!1,0,0))}f instanceof THREE.Mesh?(d.wireframe?(d=d.wireframeLinewidth,d!==nb&&(g.lineWidth(d),nb=d),a&&g.bindBuffer(g.ELEMENT_ARRAY_BUFFER,e.__webglLineBuffer),g.drawElements(g.LINES,e.__webglLineCount,g.UNSIGNED_SHORT,
0)):(a&&g.bindBuffer(g.ELEMENT_ARRAY_BUFFER,e.__webglFaceBuffer),g.drawElements(g.TRIANGLES,e.__webglFaceCount,g.UNSIGNED_SHORT,0)),D.info.render.calls++,D.info.render.vertices+=e.__webglFaceCount,D.info.render.faces+=e.__webglFaceCount/3):f instanceof THREE.Line?(f=f.type===THREE.LineStrip?g.LINE_STRIP:g.LINES,d=d.linewidth,d!==nb&&(g.lineWidth(d),nb=d),g.drawArrays(f,0,e.__webglLineCount),D.info.render.calls++):f instanceof THREE.ParticleSystem?(g.drawArrays(g.POINTS,0,e.__webglParticleCount),D.info.render.calls++,
D.info.render.points+=e.__webglParticleCount):f instanceof THREE.Ribbon&&(g.drawArrays(g.TRIANGLE_STRIP,0,e.__webglVertexCount),D.info.render.calls++)}};this.render=function(a,b,c,d){var e,f,j,n,m=a.lights,p=a.fog;Q=-1;this.autoUpdateObjects&&this.initWebGLObjects(a);void 0===b.parent&&(console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it..."),a.add(b));this.autoUpdateScene&&a.updateMatrixWorld();i(this.renderPluginsPre,a,b);D.info.render.calls=0;D.info.render.vertices=0;D.info.render.faces=
0;D.info.render.points=0;b.matrixWorldInverse.getInverse(b.matrixWorld);if(!b._viewMatrixArray)b._viewMatrixArray=new Float32Array(16);b.matrixWorldInverse.flattenToArray(b._viewMatrixArray);if(!b._projectionMatrixArray)b._projectionMatrixArray=new Float32Array(16);b.projectionMatrix.flattenToArray(b._projectionMatrixArray);Va.multiply(b.projectionMatrix,b.matrixWorldInverse);Qb.setFromMatrix(Va);this.setRenderTarget(c);(this.autoClear||d)&&this.clear(this.autoClearColor,this.autoClearDepth,this.autoClearStencil);
n=a.__webglObjects;for(d=0,e=n.length;d<e;d++)if(f=n[d],j=f.object,f.render=!1,j.visible&&(!(j instanceof THREE.Mesh||j instanceof THREE.ParticleSystem)||!j.frustumCulled||Qb.contains(j))){j.matrixWorld.flattenToArray(j._objectMatrixArray);t(j,b);var o=f,r=o.object,u=o.buffer,y=void 0,y=y=void 0,y=r.material;if(y instanceof THREE.MeshFaceMaterial){if(y=u.materialIndex,0<=y)y=r.geometry.materials[y],y.transparent?(o.transparent=y,o.opaque=null):(o.opaque=y,o.transparent=null)}else if(y)y.transparent?
(o.transparent=y,o.opaque=null):(o.opaque=y,o.transparent=null);f.render=!0;if(this.sortObjects)j.renderDepth?f.z=j.renderDepth:(Ia.copy(j.position),Va.multiplyVector3(Ia),f.z=Ia.z)}this.sortObjects&&n.sort(h);n=a.__webglObjectsImmediate;for(d=0,e=n.length;d<e;d++)if(f=n[d],j=f.object,j.visible)j.matrixAutoUpdate&&j.matrixWorld.flattenToArray(j._objectMatrixArray),t(j,b),j=f.object.material,j.transparent?(f.transparent=j,f.opaque=null):(f.opaque=j,f.transparent=null);a.overrideMaterial?(this.setBlending(a.overrideMaterial.blending),
this.setDepthTest(a.overrideMaterial.depthTest),this.setDepthWrite(a.overrideMaterial.depthWrite),z(a.overrideMaterial.polygonOffset,a.overrideMaterial.polygonOffsetFactor,a.overrideMaterial.polygonOffsetUnits),k(a.__webglObjects,!1,"",b,m,p,!0,a.overrideMaterial),l(a.__webglObjectsImmediate,"",b,m,p,!1,a.overrideMaterial)):(this.setBlending(THREE.NormalBlending),k(a.__webglObjects,!0,"opaque",b,m,p,!1),l(a.__webglObjectsImmediate,"opaque",b,m,p,!1),k(a.__webglObjects,!1,"transparent",b,m,p,!0),l(a.__webglObjectsImmediate,
"transparent",b,m,p,!0));i(this.renderPluginsPost,a,b);c&&c.generateMipmaps&&c.minFilter!==THREE.NearestFilter&&c.minFilter!==THREE.LinearFilter&&(c instanceof THREE.WebGLRenderTargetCube?(g.bindTexture(g.TEXTURE_CUBE_MAP,c.__webglTexture),g.generateMipmap(g.TEXTURE_CUBE_MAP),g.bindTexture(g.TEXTURE_CUBE_MAP,null)):(g.bindTexture(g.TEXTURE_2D,c.__webglTexture),g.generateMipmap(g.TEXTURE_2D),g.bindTexture(g.TEXTURE_2D,null)));this.setDepthTest(!0);this.setDepthWrite(!0)};this.renderImmediateObject=
function(a,b,c,d,e){var f=r(a,b,c,d,e);L=-1;D.setObjectFaces(e);e.immediateRenderCallback?e.immediateRenderCallback(f,g,Qb):e.render(function(a){D.renderBufferImmediate(a,f,d.shading)})};this.initWebGLObjects=function(a){if(!a.__webglObjects)a.__webglObjects=[],a.__webglObjectsImmediate=[],a.__webglSprites=[],a.__webglFlares=[];for(;a.__objectsAdded.length;){var h=a.__objectsAdded[0],i=a,l=void 0,k=void 0,r=void 0;if(!h.__webglInit)if(h.__webglInit=!0,h._modelViewMatrix=new THREE.Matrix4,h._normalMatrixArray=
new Float32Array(9),h._modelViewMatrixArray=new Float32Array(16),h._objectMatrixArray=new Float32Array(16),h.matrixWorld.flattenToArray(h._objectMatrixArray),h instanceof THREE.Mesh){if(k=h.geometry,k instanceof THREE.Geometry){if(void 0===k.geometryGroups){var t=k,u=void 0,y=void 0,z=void 0,A=void 0,H=void 0,B=void 0,J=void 0,K={},M=t.morphTargets.length;t.geometryGroups={};for(u=0,y=t.faces.length;u<y;u++)z=t.faces[u],A=z.materialIndex,B=void 0!==A?A:-1,void 0===K[B]&&(K[B]={hash:B,counter:0}),
J=K[B].hash+"_"+K[B].counter,void 0===t.geometryGroups[J]&&(t.geometryGroups[J]={faces3:[],faces4:[],materialIndex:A,vertices:0,numMorphTargets:M}),H=z instanceof THREE.Face3?3:4,65535<t.geometryGroups[J].vertices+H&&(K[B].counter+=1,J=K[B].hash+"_"+K[B].counter,void 0===t.geometryGroups[J]&&(t.geometryGroups[J]={faces3:[],faces4:[],materialIndex:A,vertices:0,numMorphTargets:M})),z instanceof THREE.Face3?t.geometryGroups[J].faces3.push(u):t.geometryGroups[J].faces4.push(u),t.geometryGroups[J].vertices+=
H;t.geometryGroupsList=[];var N=void 0;for(N in t.geometryGroups)t.geometryGroups[N].id=ya++,t.geometryGroupsList.push(t.geometryGroups[N])}for(l in k.geometryGroups)if(r=k.geometryGroups[l],!r.__webglVertexBuffer){var I=r;I.__webglVertexBuffer=g.createBuffer();I.__webglNormalBuffer=g.createBuffer();I.__webglTangentBuffer=g.createBuffer();I.__webglColorBuffer=g.createBuffer();I.__webglUVBuffer=g.createBuffer();I.__webglUV2Buffer=g.createBuffer();I.__webglSkinVertexABuffer=g.createBuffer();I.__webglSkinVertexBBuffer=
g.createBuffer();I.__webglSkinIndicesBuffer=g.createBuffer();I.__webglSkinWeightsBuffer=g.createBuffer();I.__webglFaceBuffer=g.createBuffer();I.__webglLineBuffer=g.createBuffer();if(I.numMorphTargets){var Q=void 0,$=void 0;I.__webglMorphTargetsBuffers=[];for(Q=0,$=I.numMorphTargets;Q<$;Q++)I.__webglMorphTargetsBuffers.push(g.createBuffer())}D.info.memory.geometries++;var L=r,Z=h,W=Z.geometry,ba=L.faces3,ca=L.faces4,S=3*ba.length+4*ca.length,ka=1*ba.length+2*ca.length,ua=3*ba.length+4*ca.length,pa=
c(Z,L),Ba=e(pa),Ea=d(pa),Na=pa.vertexColors?pa.vertexColors:!1;L.__vertexArray=new Float32Array(3*S);if(Ea)L.__normalArray=new Float32Array(3*S);if(W.hasTangents)L.__tangentArray=new Float32Array(4*S);if(Na)L.__colorArray=new Float32Array(3*S);if(Ba){if(0<W.faceUvs.length||0<W.faceVertexUvs.length)L.__uvArray=new Float32Array(2*S);if(1<W.faceUvs.length||1<W.faceVertexUvs.length)L.__uv2Array=new Float32Array(2*S)}if(Z.geometry.skinWeights.length&&Z.geometry.skinIndices.length)L.__skinVertexAArray=
new Float32Array(4*S),L.__skinVertexBArray=new Float32Array(4*S),L.__skinIndexArray=new Float32Array(4*S),L.__skinWeightArray=new Float32Array(4*S);L.__faceArray=new Uint16Array(3*ka);L.__lineArray=new Uint16Array(2*ua);if(L.numMorphTargets){L.__morphTargetsArrays=[];for(var Oa=0,Ua=L.numMorphTargets;Oa<Ua;Oa++)L.__morphTargetsArrays.push(new Float32Array(3*S))}L.__webglFaceCount=3*ka;L.__webglLineCount=2*ua;if(pa.attributes){if(void 0===L.__webglCustomAttributesList)L.__webglCustomAttributesList=
[];var Sa=void 0;for(Sa in pa.attributes){var Pa=pa.attributes[Sa],Fa={},Ta;for(Ta in Pa)Fa[Ta]=Pa[Ta];if(!Fa.__webglInitialized||Fa.createUniqueBuffers){Fa.__webglInitialized=!0;var Ia=1;"v2"===Fa.type?Ia=2:"v3"===Fa.type?Ia=3:"v4"===Fa.type?Ia=4:"c"===Fa.type&&(Ia=3);Fa.size=Ia;Fa.array=new Float32Array(S*Ia);Fa.buffer=g.createBuffer();Fa.buffer.belongsToAttribute=Sa;Pa.needsUpdate=!0;Fa.__original=Pa}L.__webglCustomAttributesList.push(Fa)}}L.__inittedArrays=!0;k.__dirtyVertices=!0;k.__dirtyMorphTargets=
!0;k.__dirtyElements=!0;k.__dirtyUvs=!0;k.__dirtyNormals=!0;k.__dirtyTangents=!0;k.__dirtyColors=!0}}}else if(h instanceof THREE.Ribbon){if(k=h.geometry,!k.__webglVertexBuffer){var ib=k;ib.__webglVertexBuffer=g.createBuffer();ib.__webglColorBuffer=g.createBuffer();D.info.memory.geometries++;var Va=k,nb=Va.vertices.length;Va.__vertexArray=new Float32Array(3*nb);Va.__colorArray=new Float32Array(3*nb);Va.__webglVertexCount=nb;k.__dirtyVertices=!0;k.__dirtyColors=!0}}else if(h instanceof THREE.Line){if(k=
h.geometry,!k.__webglVertexBuffer){var Fb=k;Fb.__webglVertexBuffer=g.createBuffer();Fb.__webglColorBuffer=g.createBuffer();D.info.memory.geometries++;var Rb=k,Pb=h,Ab=Rb.vertices.length;Rb.__vertexArray=new Float32Array(3*Ab);Rb.__colorArray=new Float32Array(3*Ab);Rb.__webglLineCount=Ab;b(Rb,Pb);k.__dirtyVertices=!0;k.__dirtyColors=!0}}else if(h instanceof THREE.ParticleSystem&&(k=h.geometry,!k.__webglVertexBuffer)){var Gb=k;Gb.__webglVertexBuffer=g.createBuffer();Gb.__webglColorBuffer=g.createBuffer();
D.info.geometries++;var Hb=k,Qb=h,vc=Hb.vertices.length;Hb.__vertexArray=new Float32Array(3*vc);Hb.__colorArray=new Float32Array(3*vc);Hb.__sortArray=[];Hb.__webglParticleCount=vc;b(Hb,Qb);k.__dirtyVertices=!0;k.__dirtyColors=!0}if(!h.__webglActive){if(h instanceof THREE.Mesh)if(k=h.geometry,k instanceof THREE.BufferGeometry)j(i.__webglObjects,k,h);else for(l in k.geometryGroups)r=k.geometryGroups[l],j(i.__webglObjects,r,h);else h instanceof THREE.Ribbon||h instanceof THREE.Line||h instanceof THREE.ParticleSystem?
(k=h.geometry,j(i.__webglObjects,k,h)):void 0!==THREE.MarchingCubes&&h instanceof THREE.MarchingCubes||h.immediateRenderCallback?i.__webglObjectsImmediate.push({object:h,opaque:null,transparent:null}):h instanceof THREE.Sprite?i.__webglSprites.push(h):h instanceof THREE.LensFlare&&i.__webglFlares.push(h);h.__webglActive=!0}a.__objectsAdded.splice(0,1)}for(;a.__objectsRemoved.length;){var Ja=a.__objectsRemoved[0],gc=a;Ja instanceof THREE.Mesh||Ja instanceof THREE.ParticleSystem||Ja instanceof THREE.Ribbon||
Ja instanceof THREE.Line?o(gc.__webglObjects,Ja):Ja instanceof THREE.Sprite?m(gc.__webglSprites,Ja):Ja instanceof THREE.LensFlare?m(gc.__webglFlares,Ja):(Ja instanceof THREE.MarchingCubes||Ja.immediateRenderCallback)&&o(gc.__webglObjectsImmediate,Ja);Ja.__webglActive=!1;a.__objectsRemoved.splice(0,1)}for(var wc=0,cc=a.__webglObjects.length;wc<cc;wc++){var Qa=a.__webglObjects[wc].object,R=Qa.geometry,Sb=void 0,Ib=void 0,za=void 0;if(Qa instanceof THREE.Mesh)if(R instanceof THREE.BufferGeometry)R.__dirtyVertices=
!1,R.__dirtyElements=!1,R.__dirtyUvs=!1,R.__dirtyNormals=!1,R.__dirtyColors=!1;else{for(var xc=0,dc=R.geometryGroupsList.length;xc<dc;xc++)if(Sb=R.geometryGroupsList[xc],za=c(Qa,Sb),Ib=za.attributes&&n(za),R.__dirtyVertices||R.__dirtyMorphTargets||R.__dirtyElements||R.__dirtyUvs||R.__dirtyNormals||R.__dirtyColors||R.__dirtyTangents||Ib){var O=Sb,ec=Qa,Ga=g.DYNAMIC_DRAW,fc=!R.dynamic,hc=za;if(O.__inittedArrays){var Fc=d(hc),yc=hc.vertexColors?hc.vertexColors:!1,Gc=e(hc),Hc=Fc===THREE.SmoothShading,
v=void 0,C=void 0,Ma=void 0,x=void 0,Jb=void 0,ob=void 0,Ra=void 0,ic=void 0,jb=void 0,Kb=void 0,Lb=void 0,E=void 0,F=void 0,G=void 0,X=void 0,Wa=void 0,Xa=void 0,Ya=void 0,Tb=void 0,Za=void 0,$a=void 0,ab=void 0,Ub=void 0,bb=void 0,cb=void 0,db=void 0,Vb=void 0,eb=void 0,fb=void 0,gb=void 0,Wb=void 0,pb=void 0,qb=void 0,rb=void 0,jc=void 0,sb=void 0,tb=void 0,ub=void 0,kc=void 0,T=void 0,Ic=void 0,vb=void 0,Mb=void 0,Nb=void 0,Ha=void 0,Jc=void 0,qa=void 0,ja=0,oa=0,kb=0,lb=0,Ka=0,va=0,Y=0,wa=0,
la=0,w=0,ma=0,s=0,Ca=void 0,ra=O.__vertexArray,Xb=O.__uvArray,Yb=O.__uv2Array,La=O.__normalArray,da=O.__tangentArray,sa=O.__colorArray,ea=O.__skinVertexAArray,fa=O.__skinVertexBArray,ga=O.__skinIndexArray,ha=O.__skinWeightArray,zc=O.__morphTargetsArrays,Ac=O.__webglCustomAttributesList,q=void 0,hb=O.__faceArray,Da=O.__lineArray,xa=ec.geometry,uc=xa.__dirtyElements,Kc=xa.__dirtyUvs,Rc=xa.__dirtyNormals,Sc=xa.__dirtyTangents,Tc=xa.__dirtyColors,Uc=xa.__dirtyMorphTargets,Bb=xa.vertices,U=O.faces3,V=
O.faces4,na=xa.faces,Bc=xa.faceVertexUvs[0],Cc=xa.faceVertexUvs[1],Cb=xa.skinVerticesA,Db=xa.skinVerticesB,Eb=xa.skinIndices,wb=xa.skinWeights,xb=xa.morphTargets;if(xa.__dirtyVertices){for(v=0,C=U.length;v<C;v++)x=na[U[v]],E=Bb[x.a].position,F=Bb[x.b].position,G=Bb[x.c].position,ra[oa]=E.x,ra[oa+1]=E.y,ra[oa+2]=E.z,ra[oa+3]=F.x,ra[oa+4]=F.y,ra[oa+5]=F.z,ra[oa+6]=G.x,ra[oa+7]=G.y,ra[oa+8]=G.z,oa+=9;for(v=0,C=V.length;v<C;v++)x=na[V[v]],E=Bb[x.a].position,F=Bb[x.b].position,G=Bb[x.c].position,X=Bb[x.d].position,
ra[oa]=E.x,ra[oa+1]=E.y,ra[oa+2]=E.z,ra[oa+3]=F.x,ra[oa+4]=F.y,ra[oa+5]=F.z,ra[oa+6]=G.x,ra[oa+7]=G.y,ra[oa+8]=G.z,ra[oa+9]=X.x,ra[oa+10]=X.y,ra[oa+11]=X.z,oa+=12;g.bindBuffer(g.ARRAY_BUFFER,O.__webglVertexBuffer);g.bufferData(g.ARRAY_BUFFER,ra,Ga)}if(Uc)for(Ha=0,Jc=xb.length;Ha<Jc;Ha++){ma=0;for(v=0,C=U.length;v<C;v++)x=na[U[v]],E=xb[Ha].vertices[x.a].position,F=xb[Ha].vertices[x.b].position,G=xb[Ha].vertices[x.c].position,qa=zc[Ha],qa[ma]=E.x,qa[ma+1]=E.y,qa[ma+2]=E.z,qa[ma+3]=F.x,qa[ma+4]=F.y,
qa[ma+5]=F.z,qa[ma+6]=G.x,qa[ma+7]=G.y,qa[ma+8]=G.z,ma+=9;for(v=0,C=V.length;v<C;v++)x=na[V[v]],E=xb[Ha].vertices[x.a].position,F=xb[Ha].vertices[x.b].position,G=xb[Ha].vertices[x.c].position,X=xb[Ha].vertices[x.d].position,qa=zc[Ha],qa[ma]=E.x,qa[ma+1]=E.y,qa[ma+2]=E.z,qa[ma+3]=F.x,qa[ma+4]=F.y,qa[ma+5]=F.z,qa[ma+6]=G.x,qa[ma+7]=G.y,qa[ma+8]=G.z,qa[ma+9]=X.x,qa[ma+10]=X.y,qa[ma+11]=X.z,ma+=12;g.bindBuffer(g.ARRAY_BUFFER,O.__webglMorphTargetsBuffers[Ha]);g.bufferData(g.ARRAY_BUFFER,zc[Ha],Ga)}if(wb.length){for(v=
0,C=U.length;v<C;v++)x=na[U[v]],bb=wb[x.a],cb=wb[x.b],db=wb[x.c],ha[w]=bb.x,ha[w+1]=bb.y,ha[w+2]=bb.z,ha[w+3]=bb.w,ha[w+4]=cb.x,ha[w+5]=cb.y,ha[w+6]=cb.z,ha[w+7]=cb.w,ha[w+8]=db.x,ha[w+9]=db.y,ha[w+10]=db.z,ha[w+11]=db.w,eb=Eb[x.a],fb=Eb[x.b],gb=Eb[x.c],ga[w]=eb.x,ga[w+1]=eb.y,ga[w+2]=eb.z,ga[w+3]=eb.w,ga[w+4]=fb.x,ga[w+5]=fb.y,ga[w+6]=fb.z,ga[w+7]=fb.w,ga[w+8]=gb.x,ga[w+9]=gb.y,ga[w+10]=gb.z,ga[w+11]=gb.w,pb=Cb[x.a],qb=Cb[x.b],rb=Cb[x.c],ea[w]=pb.x,ea[w+1]=pb.y,ea[w+2]=pb.z,ea[w+3]=1,ea[w+4]=qb.x,
ea[w+5]=qb.y,ea[w+6]=qb.z,ea[w+7]=1,ea[w+8]=rb.x,ea[w+9]=rb.y,ea[w+10]=rb.z,ea[w+11]=1,sb=Db[x.a],tb=Db[x.b],ub=Db[x.c],fa[w]=sb.x,fa[w+1]=sb.y,fa[w+2]=sb.z,fa[w+3]=1,fa[w+4]=tb.x,fa[w+5]=tb.y,fa[w+6]=tb.z,fa[w+7]=1,fa[w+8]=ub.x,fa[w+9]=ub.y,fa[w+10]=ub.z,fa[w+11]=1,w+=12;for(v=0,C=V.length;v<C;v++)x=na[V[v]],bb=wb[x.a],cb=wb[x.b],db=wb[x.c],Vb=wb[x.d],ha[w]=bb.x,ha[w+1]=bb.y,ha[w+2]=bb.z,ha[w+3]=bb.w,ha[w+4]=cb.x,ha[w+5]=cb.y,ha[w+6]=cb.z,ha[w+7]=cb.w,ha[w+8]=db.x,ha[w+9]=db.y,ha[w+10]=db.z,ha[w+
11]=db.w,ha[w+12]=Vb.x,ha[w+13]=Vb.y,ha[w+14]=Vb.z,ha[w+15]=Vb.w,eb=Eb[x.a],fb=Eb[x.b],gb=Eb[x.c],Wb=Eb[x.d],ga[w]=eb.x,ga[w+1]=eb.y,ga[w+2]=eb.z,ga[w+3]=eb.w,ga[w+4]=fb.x,ga[w+5]=fb.y,ga[w+6]=fb.z,ga[w+7]=fb.w,ga[w+8]=gb.x,ga[w+9]=gb.y,ga[w+10]=gb.z,ga[w+11]=gb.w,ga[w+12]=Wb.x,ga[w+13]=Wb.y,ga[w+14]=Wb.z,ga[w+15]=Wb.w,pb=Cb[x.a],qb=Cb[x.b],rb=Cb[x.c],jc=Cb[x.d],ea[w]=pb.x,ea[w+1]=pb.y,ea[w+2]=pb.z,ea[w+3]=1,ea[w+4]=qb.x,ea[w+5]=qb.y,ea[w+6]=qb.z,ea[w+7]=1,ea[w+8]=rb.x,ea[w+9]=rb.y,ea[w+10]=rb.z,
ea[w+11]=1,ea[w+12]=jc.x,ea[w+13]=jc.y,ea[w+14]=jc.z,ea[w+15]=1,sb=Db[x.a],tb=Db[x.b],ub=Db[x.c],kc=Db[x.d],fa[w]=sb.x,fa[w+1]=sb.y,fa[w+2]=sb.z,fa[w+3]=1,fa[w+4]=tb.x,fa[w+5]=tb.y,fa[w+6]=tb.z,fa[w+7]=1,fa[w+8]=ub.x,fa[w+9]=ub.y,fa[w+10]=ub.z,fa[w+11]=1,fa[w+12]=kc.x,fa[w+13]=kc.y,fa[w+14]=kc.z,fa[w+15]=1,w+=16;0<w&&(g.bindBuffer(g.ARRAY_BUFFER,O.__webglSkinVertexABuffer),g.bufferData(g.ARRAY_BUFFER,ea,Ga),g.bindBuffer(g.ARRAY_BUFFER,O.__webglSkinVertexBBuffer),g.bufferData(g.ARRAY_BUFFER,fa,Ga),
g.bindBuffer(g.ARRAY_BUFFER,O.__webglSkinIndicesBuffer),g.bufferData(g.ARRAY_BUFFER,ga,Ga),g.bindBuffer(g.ARRAY_BUFFER,O.__webglSkinWeightsBuffer),g.bufferData(g.ARRAY_BUFFER,ha,Ga))}if(Tc&&yc){for(v=0,C=U.length;v<C;v++)x=na[U[v]],Ra=x.vertexColors,ic=x.color,3===Ra.length&&yc===THREE.VertexColors?(Za=Ra[0],$a=Ra[1],ab=Ra[2]):ab=$a=Za=ic,sa[la]=Za.r,sa[la+1]=Za.g,sa[la+2]=Za.b,sa[la+3]=$a.r,sa[la+4]=$a.g,sa[la+5]=$a.b,sa[la+6]=ab.r,sa[la+7]=ab.g,sa[la+8]=ab.b,la+=9;for(v=0,C=V.length;v<C;v++)x=na[V[v]],
Ra=x.vertexColors,ic=x.color,4===Ra.length&&yc===THREE.VertexColors?(Za=Ra[0],$a=Ra[1],ab=Ra[2],Ub=Ra[3]):Ub=ab=$a=Za=ic,sa[la]=Za.r,sa[la+1]=Za.g,sa[la+2]=Za.b,sa[la+3]=$a.r,sa[la+4]=$a.g,sa[la+5]=$a.b,sa[la+6]=ab.r,sa[la+7]=ab.g,sa[la+8]=ab.b,sa[la+9]=Ub.r,sa[la+10]=Ub.g,sa[la+11]=Ub.b,la+=12;0<la&&(g.bindBuffer(g.ARRAY_BUFFER,O.__webglColorBuffer),g.bufferData(g.ARRAY_BUFFER,sa,Ga))}if(Sc&&xa.hasTangents){for(v=0,C=U.length;v<C;v++)x=na[U[v]],jb=x.vertexTangents,Wa=jb[0],Xa=jb[1],Ya=jb[2],da[Y]=
Wa.x,da[Y+1]=Wa.y,da[Y+2]=Wa.z,da[Y+3]=Wa.w,da[Y+4]=Xa.x,da[Y+5]=Xa.y,da[Y+6]=Xa.z,da[Y+7]=Xa.w,da[Y+8]=Ya.x,da[Y+9]=Ya.y,da[Y+10]=Ya.z,da[Y+11]=Ya.w,Y+=12;for(v=0,C=V.length;v<C;v++)x=na[V[v]],jb=x.vertexTangents,Wa=jb[0],Xa=jb[1],Ya=jb[2],Tb=jb[3],da[Y]=Wa.x,da[Y+1]=Wa.y,da[Y+2]=Wa.z,da[Y+3]=Wa.w,da[Y+4]=Xa.x,da[Y+5]=Xa.y,da[Y+6]=Xa.z,da[Y+7]=Xa.w,da[Y+8]=Ya.x,da[Y+9]=Ya.y,da[Y+10]=Ya.z,da[Y+11]=Ya.w,da[Y+12]=Tb.x,da[Y+13]=Tb.y,da[Y+14]=Tb.z,da[Y+15]=Tb.w,Y+=16;g.bindBuffer(g.ARRAY_BUFFER,O.__webglTangentBuffer);
g.bufferData(g.ARRAY_BUFFER,da,Ga)}if(Rc&&Fc){for(v=0,C=U.length;v<C;v++)if(x=na[U[v]],Jb=x.vertexNormals,ob=x.normal,3===Jb.length&&Hc)for(T=0;3>T;T++)vb=Jb[T],La[va]=vb.x,La[va+1]=vb.y,La[va+2]=vb.z,va+=3;else for(T=0;3>T;T++)La[va]=ob.x,La[va+1]=ob.y,La[va+2]=ob.z,va+=3;for(v=0,C=V.length;v<C;v++)if(x=na[V[v]],Jb=x.vertexNormals,ob=x.normal,4===Jb.length&&Hc)for(T=0;4>T;T++)vb=Jb[T],La[va]=vb.x,La[va+1]=vb.y,La[va+2]=vb.z,va+=3;else for(T=0;4>T;T++)La[va]=ob.x,La[va+1]=ob.y,La[va+2]=ob.z,va+=3;
g.bindBuffer(g.ARRAY_BUFFER,O.__webglNormalBuffer);g.bufferData(g.ARRAY_BUFFER,La,Ga)}if(Kc&&Bc&&Gc){for(v=0,C=U.length;v<C;v++)if(Ma=U[v],x=na[Ma],Kb=Bc[Ma],void 0!==Kb)for(T=0;3>T;T++)Mb=Kb[T],Xb[kb]=Mb.u,Xb[kb+1]=Mb.v,kb+=2;for(v=0,C=V.length;v<C;v++)if(Ma=V[v],x=na[Ma],Kb=Bc[Ma],void 0!==Kb)for(T=0;4>T;T++)Mb=Kb[T],Xb[kb]=Mb.u,Xb[kb+1]=Mb.v,kb+=2;0<kb&&(g.bindBuffer(g.ARRAY_BUFFER,O.__webglUVBuffer),g.bufferData(g.ARRAY_BUFFER,Xb,Ga))}if(Kc&&Cc&&Gc){for(v=0,C=U.length;v<C;v++)if(Ma=U[v],x=na[Ma],
Lb=Cc[Ma],void 0!==Lb)for(T=0;3>T;T++)Nb=Lb[T],Yb[lb]=Nb.u,Yb[lb+1]=Nb.v,lb+=2;for(v=0,C=V.length;v<C;v++)if(Ma=V[v],x=na[Ma],Lb=Cc[Ma],void 0!==Lb)for(T=0;4>T;T++)Nb=Lb[T],Yb[lb]=Nb.u,Yb[lb+1]=Nb.v,lb+=2;0<lb&&(g.bindBuffer(g.ARRAY_BUFFER,O.__webglUV2Buffer),g.bufferData(g.ARRAY_BUFFER,Yb,Ga))}if(uc){for(v=0,C=U.length;v<C;v++)x=na[U[v]],hb[Ka]=ja,hb[Ka+1]=ja+1,hb[Ka+2]=ja+2,Ka+=3,Da[wa]=ja,Da[wa+1]=ja+1,Da[wa+2]=ja,Da[wa+3]=ja+2,Da[wa+4]=ja+1,Da[wa+5]=ja+2,wa+=6,ja+=3;for(v=0,C=V.length;v<C;v++)x=
na[V[v]],hb[Ka]=ja,hb[Ka+1]=ja+1,hb[Ka+2]=ja+3,hb[Ka+3]=ja+1,hb[Ka+4]=ja+2,hb[Ka+5]=ja+3,Ka+=6,Da[wa]=ja,Da[wa+1]=ja+1,Da[wa+2]=ja,Da[wa+3]=ja+3,Da[wa+4]=ja+1,Da[wa+5]=ja+2,Da[wa+6]=ja+2,Da[wa+7]=ja+3,wa+=8,ja+=4;g.bindBuffer(g.ELEMENT_ARRAY_BUFFER,O.__webglFaceBuffer);g.bufferData(g.ELEMENT_ARRAY_BUFFER,hb,Ga);g.bindBuffer(g.ELEMENT_ARRAY_BUFFER,O.__webglLineBuffer);g.bufferData(g.ELEMENT_ARRAY_BUFFER,Da,Ga)}if(Ac)for(T=0,Ic=Ac.length;T<Ic;T++)if(q=Ac[T],q.__original.needsUpdate){s=0;if(1===q.size)if(void 0===
q.boundTo||"vertices"===q.boundTo){for(v=0,C=U.length;v<C;v++)x=na[U[v]],q.array[s]=q.value[x.a],q.array[s+1]=q.value[x.b],q.array[s+2]=q.value[x.c],s+=3;for(v=0,C=V.length;v<C;v++)x=na[V[v]],q.array[s]=q.value[x.a],q.array[s+1]=q.value[x.b],q.array[s+2]=q.value[x.c],q.array[s+3]=q.value[x.d],s+=4}else{if("faces"===q.boundTo){for(v=0,C=U.length;v<C;v++)Ca=q.value[U[v]],q.array[s]=Ca,q.array[s+1]=Ca,q.array[s+2]=Ca,s+=3;for(v=0,C=V.length;v<C;v++)Ca=q.value[V[v]],q.array[s]=Ca,q.array[s+1]=Ca,q.array[s+
2]=Ca,q.array[s+3]=Ca,s+=4}}else if(2===q.size)if(void 0===q.boundTo||"vertices"===q.boundTo){for(v=0,C=U.length;v<C;v++)x=na[U[v]],E=q.value[x.a],F=q.value[x.b],G=q.value[x.c],q.array[s]=E.x,q.array[s+1]=E.y,q.array[s+2]=F.x,q.array[s+3]=F.y,q.array[s+4]=G.x,q.array[s+5]=G.y,s+=6;for(v=0,C=V.length;v<C;v++)x=na[V[v]],E=q.value[x.a],F=q.value[x.b],G=q.value[x.c],X=q.value[x.d],q.array[s]=E.x,q.array[s+1]=E.y,q.array[s+2]=F.x,q.array[s+3]=F.y,q.array[s+4]=G.x,q.array[s+5]=G.y,q.array[s+6]=X.x,q.array[s+
7]=X.y,s+=8}else{if("faces"===q.boundTo){for(v=0,C=U.length;v<C;v++)G=F=E=Ca=q.value[U[v]],q.array[s]=E.x,q.array[s+1]=E.y,q.array[s+2]=F.x,q.array[s+3]=F.y,q.array[s+4]=G.x,q.array[s+5]=G.y,s+=6;for(v=0,C=V.length;v<C;v++)X=G=F=E=Ca=q.value[V[v]],q.array[s]=E.x,q.array[s+1]=E.y,q.array[s+2]=F.x,q.array[s+3]=F.y,q.array[s+4]=G.x,q.array[s+5]=G.y,q.array[s+6]=X.x,q.array[s+7]=X.y,s+=8}}else if(3===q.size){var P;P="c"===q.type?["r","g","b"]:["x","y","z"];if(void 0===q.boundTo||"vertices"===q.boundTo){for(v=
0,C=U.length;v<C;v++)x=na[U[v]],E=q.value[x.a],F=q.value[x.b],G=q.value[x.c],q.array[s]=E[P[0]],q.array[s+1]=E[P[1]],q.array[s+2]=E[P[2]],q.array[s+3]=F[P[0]],q.array[s+4]=F[P[1]],q.array[s+5]=F[P[2]],q.array[s+6]=G[P[0]],q.array[s+7]=G[P[1]],q.array[s+8]=G[P[2]],s+=9;for(v=0,C=V.length;v<C;v++)x=na[V[v]],E=q.value[x.a],F=q.value[x.b],G=q.value[x.c],X=q.value[x.d],q.array[s]=E[P[0]],q.array[s+1]=E[P[1]],q.array[s+2]=E[P[2]],q.array[s+3]=F[P[0]],q.array[s+4]=F[P[1]],q.array[s+5]=F[P[2]],q.array[s+
6]=G[P[0]],q.array[s+7]=G[P[1]],q.array[s+8]=G[P[2]],q.array[s+9]=X[P[0]],q.array[s+10]=X[P[1]],q.array[s+11]=X[P[2]],s+=12}else if("faces"===q.boundTo){for(v=0,C=U.length;v<C;v++)G=F=E=Ca=q.value[U[v]],q.array[s]=E[P[0]],q.array[s+1]=E[P[1]],q.array[s+2]=E[P[2]],q.array[s+3]=F[P[0]],q.array[s+4]=F[P[1]],q.array[s+5]=F[P[2]],q.array[s+6]=G[P[0]],q.array[s+7]=G[P[1]],q.array[s+8]=G[P[2]],s+=9;for(v=0,C=V.length;v<C;v++)X=G=F=E=Ca=q.value[V[v]],q.array[s]=E[P[0]],q.array[s+1]=E[P[1]],q.array[s+2]=E[P[2]],
q.array[s+3]=F[P[0]],q.array[s+4]=F[P[1]],q.array[s+5]=F[P[2]],q.array[s+6]=G[P[0]],q.array[s+7]=G[P[1]],q.array[s+8]=G[P[2]],q.array[s+9]=X[P[0]],q.array[s+10]=X[P[1]],q.array[s+11]=X[P[2]],s+=12}}else if(4===q.size)if(void 0===q.boundTo||"vertices"===q.boundTo){for(v=0,C=U.length;v<C;v++)x=na[U[v]],E=q.value[x.a],F=q.value[x.b],G=q.value[x.c],q.array[s]=E.x,q.array[s+1]=E.y,q.array[s+2]=E.z,q.array[s+3]=E.w,q.array[s+4]=F.x,q.array[s+5]=F.y,q.array[s+6]=F.z,q.array[s+7]=F.w,q.array[s+8]=G.x,q.array[s+
9]=G.y,q.array[s+10]=G.z,q.array[s+11]=G.w,s+=12;for(v=0,C=V.length;v<C;v++)x=na[V[v]],E=q.value[x.a],F=q.value[x.b],G=q.value[x.c],X=q.value[x.d],q.array[s]=E.x,q.array[s+1]=E.y,q.array[s+2]=E.z,q.array[s+3]=E.w,q.array[s+4]=F.x,q.array[s+5]=F.y,q.array[s+6]=F.z,q.array[s+7]=F.w,q.array[s+8]=G.x,q.array[s+9]=G.y,q.array[s+10]=G.z,q.array[s+11]=G.w,q.array[s+12]=X.x,q.array[s+13]=X.y,q.array[s+14]=X.z,q.array[s+15]=X.w,s+=16}else if("faces"===q.boundTo){for(v=0,C=U.length;v<C;v++)G=F=E=Ca=q.value[U[v]],
q.array[s]=E.x,q.array[s+1]=E.y,q.array[s+2]=E.z,q.array[s+3]=E.w,q.array[s+4]=F.x,q.array[s+5]=F.y,q.array[s+6]=F.z,q.array[s+7]=F.w,q.array[s+8]=G.x,q.array[s+9]=G.y,q.array[s+10]=G.z,q.array[s+11]=G.w,s+=12;for(v=0,C=V.length;v<C;v++)X=G=F=E=Ca=q.value[V[v]],q.array[s]=E.x,q.array[s+1]=E.y,q.array[s+2]=E.z,q.array[s+3]=E.w,q.array[s+4]=F.x,q.array[s+5]=F.y,q.array[s+6]=F.z,q.array[s+7]=F.w,q.array[s+8]=G.x,q.array[s+9]=G.y,q.array[s+10]=G.z,q.array[s+11]=G.w,q.array[s+12]=X.x,q.array[s+13]=X.y,
q.array[s+14]=X.z,q.array[s+15]=X.w,s+=16}g.bindBuffer(g.ARRAY_BUFFER,q.buffer);g.bufferData(g.ARRAY_BUFFER,q.array,Ga)}fc&&(delete O.__inittedArrays,delete O.__colorArray,delete O.__normalArray,delete O.__tangentArray,delete O.__uvArray,delete O.__uv2Array,delete O.__faceArray,delete O.__vertexArray,delete O.__lineArray,delete O.__skinVertexAArray,delete O.__skinVertexBArray,delete O.__skinIndexArray,delete O.__skinWeightArray)}}R.__dirtyVertices=!1;R.__dirtyMorphTargets=!1;R.__dirtyElements=!1;
R.__dirtyUvs=!1;R.__dirtyNormals=!1;R.__dirtyColors=!1;R.__dirtyTangents=!1;za.attributes&&p(za)}else if(Qa instanceof THREE.Ribbon){if(R.__dirtyVertices||R.__dirtyColors){var yb=R,Lc=g.DYNAMIC_DRAW,Zb=void 0,$b=void 0,lc=void 0,zb=void 0,mc=void 0,Mc=yb.vertices,Nc=yb.colors,Vc=Mc.length,Wc=Nc.length,nc=yb.__vertexArray,oc=yb.__colorArray,Xc=yb.__dirtyColors;if(yb.__dirtyVertices){for(Zb=0;Zb<Vc;Zb++)lc=Mc[Zb].position,zb=3*Zb,nc[zb]=lc.x,nc[zb+1]=lc.y,nc[zb+2]=lc.z;g.bindBuffer(g.ARRAY_BUFFER,yb.__webglVertexBuffer);
g.bufferData(g.ARRAY_BUFFER,nc,Lc)}if(Xc){for($b=0;$b<Wc;$b++)mc=Nc[$b],zb=3*$b,oc[zb]=mc.r,oc[zb+1]=mc.g,oc[zb+2]=mc.b;g.bindBuffer(g.ARRAY_BUFFER,yb.__webglColorBuffer);g.bufferData(g.ARRAY_BUFFER,oc,Lc)}}R.__dirtyVertices=!1;R.__dirtyColors=!1}else if(Qa instanceof THREE.Line){za=c(Qa,Sb);Ib=za.attributes&&n(za);if(R.__dirtyVertices||R.__dirtyColors||Ib){var mb=R,Dc=g.DYNAMIC_DRAW,ac=void 0,bc=void 0,pc=void 0,ia=void 0,qc=void 0,Oc=mb.vertices,Pc=mb.colors,Yc=Oc.length,Zc=Pc.length,rc=mb.__vertexArray,
sc=mb.__colorArray,$c=mb.__dirtyColors,Ec=mb.__webglCustomAttributesList,tc=void 0,Qc=void 0,ta=void 0,Ob=void 0,Aa=void 0,aa=void 0;if(mb.__dirtyVertices){for(ac=0;ac<Yc;ac++)pc=Oc[ac].position,ia=3*ac,rc[ia]=pc.x,rc[ia+1]=pc.y,rc[ia+2]=pc.z;g.bindBuffer(g.ARRAY_BUFFER,mb.__webglVertexBuffer);g.bufferData(g.ARRAY_BUFFER,rc,Dc)}if($c){for(bc=0;bc<Zc;bc++)qc=Pc[bc],ia=3*bc,sc[ia]=qc.r,sc[ia+1]=qc.g,sc[ia+2]=qc.b;g.bindBuffer(g.ARRAY_BUFFER,mb.__webglColorBuffer);g.bufferData(g.ARRAY_BUFFER,sc,Dc)}if(Ec)for(tc=
0,Qc=Ec.length;tc<Qc;tc++)if(aa=Ec[tc],aa.needsUpdate&&(void 0===aa.boundTo||"vertices"===aa.boundTo)){ia=0;Ob=aa.value.length;if(1===aa.size)for(ta=0;ta<Ob;ta++)aa.array[ta]=aa.value[ta];else if(2===aa.size)for(ta=0;ta<Ob;ta++)Aa=aa.value[ta],aa.array[ia]=Aa.x,aa.array[ia+1]=Aa.y,ia+=2;else if(3===aa.size)if("c"===aa.type)for(ta=0;ta<Ob;ta++)Aa=aa.value[ta],aa.array[ia]=Aa.r,aa.array[ia+1]=Aa.g,aa.array[ia+2]=Aa.b,ia+=3;else for(ta=0;ta<Ob;ta++)Aa=aa.value[ta],aa.array[ia]=Aa.x,aa.array[ia+1]=Aa.y,
aa.array[ia+2]=Aa.z,ia+=3;else if(4===aa.size)for(ta=0;ta<Ob;ta++)Aa=aa.value[ta],aa.array[ia]=Aa.x,aa.array[ia+1]=Aa.y,aa.array[ia+2]=Aa.z,aa.array[ia+3]=Aa.w,ia+=4;g.bindBuffer(g.ARRAY_BUFFER,aa.buffer);g.bufferData(g.ARRAY_BUFFER,aa.array,Dc)}}R.__dirtyVertices=!1;R.__dirtyColors=!1;za.attributes&&p(za)}else if(Qa instanceof THREE.ParticleSystem)za=c(Qa,Sb),Ib=za.attributes&&n(za),(R.__dirtyVertices||R.__dirtyColors||Qa.sortParticles||Ib)&&f(R,g.DYNAMIC_DRAW,Qa),R.__dirtyVertices=!1,R.__dirtyColors=
!1,za.attributes&&p(za)}};this.initMaterial=function(a,b,c,d){var e,f,h,i,j;a instanceof THREE.MeshDepthMaterial?j="depth":a instanceof THREE.MeshNormalMaterial?j="normal":a instanceof THREE.MeshBasicMaterial?j="basic":a instanceof THREE.MeshLambertMaterial?j="lambert":a instanceof THREE.MeshPhongMaterial?j="phong":a instanceof THREE.LineBasicMaterial?j="basic":a instanceof THREE.ParticleBasicMaterial&&(j="particle_basic");if(j){var k=THREE.ShaderLib[j];a.uniforms=THREE.UniformsUtils.clone(k.uniforms);
a.vertexShader=k.vertexShader;a.fragmentShader=k.fragmentShader}var n,l;f=k=0;for(n=0,l=b.length;n<l;n++)e=b[n],e.onlyShadow||(e instanceof THREE.DirectionalLight&&f++,e instanceof THREE.PointLight&&k++,e instanceof THREE.SpotLight&&k++);k+f<=Z?n=f:(n=Math.ceil(Z*f/(k+f)),k=Z-n);e=n;f=k;var m=0;for(k=0,n=b.length;k<n;k++)l=b[k],l.castShadow&&(l instanceof THREE.SpotLight||l instanceof THREE.DirectionalLight)&&m++;var p=50;if(void 0!==d&&d instanceof THREE.SkinnedMesh)p=d.bones.length;var o;a:{n=a.fragmentShader;
l=a.vertexShader;var k=a.uniforms,b=a.attributes,c={map:!!a.map,envMap:!!a.envMap,lightMap:!!a.lightMap,vertexColors:a.vertexColors,fog:c,useFog:a.fog,sizeAttenuation:a.sizeAttenuation,skinning:a.skinning,morphTargets:a.morphTargets,maxMorphTargets:this.maxMorphTargets,maxDirLights:e,maxPointLights:f,maxBones:p,shadowMapEnabled:this.shadowMapEnabled&&d.receiveShadow,shadowMapSoft:this.shadowMapSoft,maxShadows:m,alphaTest:a.alphaTest,metal:a.metal,perPixel:a.perPixel,wrapAround:a.wrapAround},r,d=[];
j?d.push(j):(d.push(n),d.push(l));for(r in c)d.push(r),d.push(c[r]);j=d.join();for(r=0,d=Sa.length;r<d;r++)if(Sa[r].code===j){o=Sa[r].program;break a}r=g.createProgram();d=[0<fc?"#define VERTEX_TEXTURES":"",D.gammaInput?"#define GAMMA_INPUT":"",D.gammaOutput?"#define GAMMA_OUTPUT":"",D.physicallyBasedShading?"#define PHYSICALLY_BASED_SHADING":"","#define MAX_DIR_LIGHTS "+c.maxDirLights,"#define MAX_POINT_LIGHTS "+c.maxPointLights,"#define MAX_SHADOWS "+c.maxShadows,"#define MAX_BONES "+c.maxBones,
c.map?"#define USE_MAP":"",c.envMap?"#define USE_ENVMAP":"",c.lightMap?"#define USE_LIGHTMAP":"",c.vertexColors?"#define USE_COLOR":"",c.skinning?"#define USE_SKINNING":"",c.morphTargets?"#define USE_MORPHTARGETS":"",c.perPixel?"#define PHONG_PER_PIXEL":"",c.wrapAround?"#define WRAP_AROUND":"",c.shadowMapEnabled?"#define USE_SHADOWMAP":"",c.shadowMapSoft?"#define SHADOWMAP_SOFT":"",c.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
e=["precision "+A+" float;","#define MAX_DIR_LIGHTS "+c.maxDirLights,"#define MAX_POINT_LIGHTS "+c.maxPointLights,"#define MAX_SHADOWS "+c.maxShadows,c.alphaTest?"#define ALPHATEST "+c.alphaTest:"",D.gammaInput?"#define GAMMA_INPUT":"",D.gammaOutput?"#define GAMMA_OUTPUT":"",D.physicallyBasedShading?"#define PHYSICALLY_BASED_SHADING":"",c.useFog&&c.fog?"#define USE_FOG":"",c.useFog&&c.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",c.map?"#define USE_MAP":"",c.envMap?"#define USE_ENVMAP":"",c.lightMap?
"#define USE_LIGHTMAP":"",c.vertexColors?"#define USE_COLOR":"",c.metal?"#define METAL":"",c.perPixel?"#define PHONG_PER_PIXEL":"",c.wrapAround?"#define WRAP_AROUND":"",c.shadowMapEnabled?"#define USE_SHADOWMAP":"",c.shadowMapSoft?"#define SHADOWMAP_SOFT":"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");g.attachShader(r,y("fragment",e+n));g.attachShader(r,y("vertex",d+l));g.linkProgram(r);g.getProgramParameter(r,g.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+
g.getProgramParameter(r,g.VALIDATE_STATUS)+", gl error ["+g.getError()+"]");r.uniforms={};r.attributes={};var t,d="viewMatrix,modelViewMatrix,projectionMatrix,normalMatrix,objectMatrix,cameraPosition,cameraInverseMatrix,boneGlobalMatrices,morphTargetInfluences".split(",");for(t in k)d.push(t);t=d;for(d=0,k=t.length;d<k;d++)n=t[d],r.uniforms[n]=g.getUniformLocation(r,n);d="position,normal,uv,uv2,tangent,color,skinVertexA,skinVertexB,skinIndex,skinWeight".split(",");for(t=0;t<c.maxMorphTargets;t++)d.push("morphTarget"+
t);for(o in b)d.push(o);o=d;for(t=0,b=o.length;t<b;t++)c=o[t],r.attributes[c]=g.getAttribLocation(r,c);r.id=Sa.length;Sa.push({program:r,code:j});D.info.memory.programs=Sa.length;o=r}a.program=o;o=a.program.attributes;0<=o.position&&g.enableVertexAttribArray(o.position);0<=o.color&&g.enableVertexAttribArray(o.color);0<=o.normal&&g.enableVertexAttribArray(o.normal);0<=o.tangent&&g.enableVertexAttribArray(o.tangent);a.skinning&&0<=o.skinVertexA&&0<=o.skinVertexB&&0<=o.skinIndex&&0<=o.skinWeight&&(g.enableVertexAttribArray(o.skinVertexA),
g.enableVertexAttribArray(o.skinVertexB),g.enableVertexAttribArray(o.skinIndex),g.enableVertexAttribArray(o.skinWeight));if(a.attributes)for(i in a.attributes)void 0!==o[i]&&0<=o[i]&&g.enableVertexAttribArray(o[i]);if(a.morphTargets)for(i=a.numSupportedMorphTargets=0;i<this.maxMorphTargets;i++)t="morphTarget"+i,0<=o[t]&&(g.enableVertexAttribArray(o[t]),a.numSupportedMorphTargets++);a.uniformsList=[];for(h in a.uniforms)a.uniformsList.push([a.uniforms[h],h])};this.setFaceCulling=function(a,b){a?(!b||
"ccw"===b?g.frontFace(g.CCW):g.frontFace(g.CW),"back"===a?g.cullFace(g.BACK):"front"===a?g.cullFace(g.FRONT):g.cullFace(g.FRONT_AND_BACK),g.enable(g.CULL_FACE)):g.disable(g.CULL_FACE)};this.setObjectFaces=function(a){if(ca!==a.doubleSided)a.doubleSided?g.disable(g.CULL_FACE):g.enable(g.CULL_FACE),ca=a.doubleSided;if(Ea!==a.flipSided)a.flipSided?g.frontFace(g.CW):g.frontFace(g.CCW),Ea=a.flipSided};this.setDepthTest=function(a){Na!==a&&(a?g.enable(g.DEPTH_TEST):g.disable(g.DEPTH_TEST),Na=a)};this.setDepthWrite=
function(a){Oa!==a&&(g.depthMask(a),Oa=a)};this.setBlending=function(a){if(a!==Ba){switch(a){case THREE.AdditiveBlending:g.blendEquation(g.FUNC_ADD);g.blendFunc(g.SRC_ALPHA,g.ONE);break;case THREE.SubtractiveBlending:g.blendEquation(g.FUNC_ADD);g.blendFunc(g.ZERO,g.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:g.blendEquation(g.FUNC_ADD);g.blendFunc(g.ZERO,g.SRC_COLOR);break;default:g.blendEquationSeparate(g.FUNC_ADD,g.FUNC_ADD),g.blendFuncSeparate(g.SRC_ALPHA,g.ONE_MINUS_SRC_ALPHA,g.ONE,
g.ONE_MINUS_SRC_ALPHA)}Ba=a}};this.setTexture=function(a,b){if(a.needsUpdate){if(!a.__webglInit)a.__webglInit=!0,a.__webglTexture=g.createTexture(),D.info.memory.textures++;g.activeTexture(g.TEXTURE0+b);g.bindTexture(g.TEXTURE_2D,a.__webglTexture);var c=a.image,d=0===(c.width&c.width-1)&&0===(c.height&c.height-1),e=B(a.format),f=B(a.type);J(g.TEXTURE_2D,a,d);a instanceof THREE.DataTexture?g.texImage2D(g.TEXTURE_2D,0,e,c.width,c.height,0,e,f,c.data):g.texImage2D(g.TEXTURE_2D,0,e,e,f,a.image);a.generateMipmaps&&
d&&g.generateMipmap(g.TEXTURE_2D);a.needsUpdate=!1;if(a.onUpdated)a.onUpdated()}else g.activeTexture(g.TEXTURE0+b),g.bindTexture(g.TEXTURE_2D,a.__webglTexture)};this.setRenderTarget=function(a){var b=a instanceof THREE.WebGLRenderTargetCube;if(a&&!a.__webglFramebuffer){if(void 0===a.depthBuffer)a.depthBuffer=!0;if(void 0===a.stencilBuffer)a.stencilBuffer=!0;a.__webglTexture=g.createTexture();var c=0===(a.width&a.width-1)&&0===(a.height&a.height-1),d=B(a.format),e=B(a.type);if(b){a.__webglFramebuffer=
[];a.__webglRenderbuffer=[];g.bindTexture(g.TEXTURE_CUBE_MAP,a.__webglTexture);J(g.TEXTURE_CUBE_MAP,a,c);for(c=0;6>c;c++){a.__webglFramebuffer[c]=g.createFramebuffer();a.__webglRenderbuffer[c]=g.createRenderbuffer();g.texImage2D(g.TEXTURE_CUBE_MAP_POSITIVE_X+c,0,d,a.width,a.height,0,d,e,null);var f=a,h=g.TEXTURE_CUBE_MAP_POSITIVE_X+c;g.bindFramebuffer(g.FRAMEBUFFER,a.__webglFramebuffer[c]);g.framebufferTexture2D(g.FRAMEBUFFER,g.COLOR_ATTACHMENT0,h,f.__webglTexture,0);K(a.__webglRenderbuffer[c],a)}}else a.__webglFramebuffer=
g.createFramebuffer(),a.__webglRenderbuffer=g.createRenderbuffer(),g.bindTexture(g.TEXTURE_2D,a.__webglTexture),J(g.TEXTURE_2D,a,c),g.texImage2D(g.TEXTURE_2D,0,d,a.width,a.height,0,d,e,null),d=g.TEXTURE_2D,g.bindFramebuffer(g.FRAMEBUFFER,a.__webglFramebuffer),g.framebufferTexture2D(g.FRAMEBUFFER,g.COLOR_ATTACHMENT0,d,a.__webglTexture,0),K(a.__webglRenderbuffer,a);b?g.bindTexture(g.TEXTURE_CUBE_MAP,null):g.bindTexture(g.TEXTURE_2D,null);g.bindRenderbuffer(g.RENDERBUFFER,null);g.bindFramebuffer(g.FRAMEBUFFER,
null)}a?(b=b?a.__webglFramebuffer[a.activeCubeFace]:a.__webglFramebuffer,d=a.width,a=a.height,c=e=0):(b=null,d=Ab,a=Gb,e=Fb,c=Pb);b!==pa&&(g.bindFramebuffer(g.FRAMEBUFFER,b),g.viewport(e,c,d,a),pa=b);cc=d;dc=a};this.shadowMapPlugin=new THREE.ShadowMapPlugin;this.addPrePlugin(this.shadowMapPlugin);this.addPostPlugin(new THREE.SpritePlugin);this.addPostPlugin(new THREE.LensFlarePlugin)};
THREE.WebGLRenderTarget=function(a,b,c){this.width=a;this.height=b;c=c||{};this.wrapS=void 0!==c.wrapS?c.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=void 0!==c.wrapT?c.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=void 0!==c.magFilter?c.magFilter:THREE.LinearFilter;this.minFilter=void 0!==c.minFilter?c.minFilter:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.format=void 0!==c.format?c.format:THREE.RGBAFormat;this.type=void 0!==c.type?c.type:
THREE.UnsignedByteType;this.depthBuffer=void 0!==c.depthBuffer?c.depthBuffer:!0;this.stencilBuffer=void 0!==c.stencilBuffer?c.stencilBuffer:!0;this.generateMipmaps=!0};
THREE.WebGLRenderTarget.prototype.clone=function(){var a=new THREE.WebGLRenderTarget(this.width,this.height);a.wrapS=this.wrapS;a.wrapT=this.wrapT;a.magFilter=this.magFilter;a.minFilter=this.minFilter;a.offset.copy(this.offset);a.repeat.copy(this.repeat);a.format=this.format;a.type=this.type;a.depthBuffer=this.depthBuffer;a.stencilBuffer=this.stencilBuffer;return a};THREE.WebGLRenderTargetCube=function(a,b,c){THREE.WebGLRenderTarget.call(this,a,b,c);this.activeCubeFace=0};
THREE.WebGLRenderTargetCube.prototype=new THREE.WebGLRenderTarget;THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube;THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};THREE.RenderableObject=function(){this.z=this.object=null};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.material=null};
THREE.BufferGeometry=function(){this.id=THREE.GeometryCount++;this.vertexColorArray=this.vertexUvArray=this.vertexNormalArray=this.vertexPositionArray=this.vertexIndexArray=this.vertexColorBuffer=this.vertexUvBuffer=this.vertexNormalBuffer=this.vertexPositionBuffer=this.vertexIndexBuffer=null;this.dynamic=!1;this.boundingSphere=this.boundingBox=null;this.morphTargets=[]};THREE.BufferGeometry.prototype={constructor:THREE.BufferGeometry,computeBoundingBox:function(){},computeBoundingSphere:function(){}};
THREE.CameraHelper=function(a){function b(a,b,d){c(a,d);c(b,d)}function c(a,b){d.lineGeometry.vertices.push(new THREE.Vertex(new THREE.Vector3));d.lineGeometry.colors.push(new THREE.Color(b));void 0===d.pointMap[a]&&(d.pointMap[a]=[]);d.pointMap[a].push(d.lineGeometry.vertices.length-1)}THREE.Object3D.call(this);var d=this;this.lineGeometry=new THREE.Geometry;this.lineMaterial=new THREE.LineBasicMaterial({color:16777215,vertexColors:THREE.FaceColors});this.pointMap={};b("n1","n2",16755200);b("n2",
"n4",16755200);b("n4","n3",16755200);b("n3","n1",16755200);b("f1","f2",16755200);b("f2","f4",16755200);b("f4","f3",16755200);b("f3","f1",16755200);b("n1","f1",16755200);b("n2","f2",16755200);b("n3","f3",16755200);b("n4","f4",16755200);b("p","n1",16711680);b("p","n2",16711680);b("p","n3",16711680);b("p","n4",16711680);b("u1","u2",43775);b("u2","u3",43775);b("u3","u1",43775);b("c","t",16777215);b("p","c",3355443);b("cn1","cn2",3355443);b("cn3","cn4",3355443);b("cf1","cf2",3355443);b("cf3","cf4",3355443);
this.update(a);this.lines=new THREE.Line(this.lineGeometry,this.lineMaterial,THREE.LinePieces);this.add(this.lines)};THREE.CameraHelper.prototype=new THREE.Object3D;THREE.CameraHelper.prototype.constructor=THREE.CameraHelper;
THREE.CameraHelper.prototype.update=function(a){function b(a,b,f,h){THREE.CameraHelper.__v.set(b,f,h);THREE.CameraHelper.__projector.unprojectVector(THREE.CameraHelper.__v,THREE.CameraHelper.__c);a=c.pointMap[a];if(void 0!==a){b=0;for(f=a.length;b<f;b++)c.lineGeometry.vertices[a[b]].position.copy(THREE.CameraHelper.__v)}}var c=this;THREE.CameraHelper.__c.projectionMatrix.copy(a.projectionMatrix);b("c",0,0,-1);b("t",0,0,1);b("n1",-1,-1,-1);b("n2",1,-1,-1);b("n3",-1,1,-1);b("n4",1,1,-1);b("f1",-1,-1,
1);b("f2",1,-1,1);b("f3",-1,1,1);b("f4",1,1,1);b("u1",0.7,1.1,-1);b("u2",-0.7,1.1,-1);b("u3",0,2,-1);b("cf1",-1,0,1);b("cf2",1,0,1);b("cf3",0,-1,1);b("cf4",0,1,1);b("cn1",-1,0,-1);b("cn2",1,0,-1);b("cn3",0,-1,-1);b("cn4",0,1,-1);this.lineGeometry.__dirtyVertices=!0};THREE.CameraHelper.__projector=new THREE.Projector;THREE.CameraHelper.__v=new THREE.Vector3;THREE.CameraHelper.__c=new THREE.Camera;
THREE.LensFlare=function(a,b,c,d,e){THREE.Object3D.call(this);this.lensFlares=[];this.positionScreen=new THREE.Vector3;this.customUpdateCallback=void 0;void 0!==a&&this.add(a,b,c,d,e)};THREE.LensFlare.prototype=new THREE.Object3D;THREE.LensFlare.prototype.constructor=THREE.LensFlare;THREE.LensFlare.prototype.supr=THREE.Object3D.prototype;
THREE.LensFlare.prototype.add=function(a,b,c,d,e,f){void 0===b&&(b=-1);void 0===c&&(c=0);void 0===f&&(f=1);void 0===e&&(e=new THREE.Color(16777215));if(void 0===d)d=THREE.NormalBlending;c=Math.min(c,Math.max(0,c));this.lensFlares.push({texture:a,size:b,distance:c,x:0,y:0,z:0,scale:1,rotation:1,opacity:f,color:e,blending:d})};
THREE.LensFlare.prototype.updateLensFlares=function(){var a,b=this.lensFlares.length,c,d=2*-this.positionScreen.x,e=2*-this.positionScreen.y;for(a=0;a<b;a++)c=this.lensFlares[a],c.x=this.positionScreen.x+d*c.distance,c.y=this.positionScreen.y+e*c.distance,c.wantedRotation=0.25*c.x*Math.PI,c.rotation+=0.25*(c.wantedRotation-c.rotation)};
THREE.MarchingCubes=function(a,b){THREE.Object3D.call(this);this.material=b;this.init=function(a){this.resolution=a;this.isolation=80;this.size=a;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(3*this.size3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=0;this.hasNormal=
this.hasPos=!1;this.positionArray=new Float32Array(3*this.maxCount);this.normalArray=new Float32Array(3*this.maxCount)};this.lerp=function(a,b,e){return a+(b-a)*e};this.VIntX=function(a,b,e,f,h,i,k,l,j,n){h=(h-j)/(n-j);j=this.normal_cache;b[f]=i+h*this.delta;b[f+1]=k;b[f+2]=l;e[f]=this.lerp(j[a],j[a+3],h);e[f+1]=this.lerp(j[a+1],j[a+4],h);e[f+2]=this.lerp(j[a+2],j[a+5],h)};this.VIntY=function(a,b,e,f,h,i,k,l,j,n){h=(h-j)/(n-j);j=this.normal_cache;b[f]=i;b[f+1]=k+h*this.delta;b[f+2]=l;b=a+3*this.yd;
e[f]=this.lerp(j[a],j[b],h);e[f+1]=this.lerp(j[a+1],j[b+1],h);e[f+2]=this.lerp(j[a+2],j[b+2],h)};this.VIntZ=function(a,b,e,f,h,i,k,l,j,n){h=(h-j)/(n-j);j=this.normal_cache;b[f]=i;b[f+1]=k;b[f+2]=l+h*this.delta;b=a+3*this.zd;e[f]=this.lerp(j[a],j[b],h);e[f+1]=this.lerp(j[a+1],j[b+1],h);e[f+2]=this.lerp(j[a+2],j[b+2],h)};this.compNorm=function(a){var b=3*a;0===this.normal_cache[b]&&(this.normal_cache[b]=this.field[a-1]-this.field[a+1],this.normal_cache[b+1]=this.field[a-this.yd]-this.field[a+this.yd],
this.normal_cache[b+2]=this.field[a-this.zd]-this.field[a+this.zd])};this.polygonize=function(a,b,e,f,h,i){var k=f+1,l=f+this.yd,j=f+this.zd,n=k+this.yd,p=k+this.zd,o=f+this.yd+this.zd,m=k+this.yd+this.zd,r=0,t=this.field[f],z=this.field[k],y=this.field[l],J=this.field[n],K=this.field[j],u=this.field[p],B=this.field[o],H=this.field[m];t<h&&(r|=1);z<h&&(r|=2);y<h&&(r|=8);J<h&&(r|=4);K<h&&(r|=16);u<h&&(r|=32);B<h&&(r|=128);H<h&&(r|=64);var A=THREE.edgeTable[r];if(0===A)return 0;var M=this.delta,N=a+
M,I=b+M,M=e+M;A&1&&(this.compNorm(f),this.compNorm(k),this.VIntX(3*f,this.vlist,this.nlist,0,h,a,b,e,t,z));A&2&&(this.compNorm(k),this.compNorm(n),this.VIntY(3*k,this.vlist,this.nlist,3,h,N,b,e,z,J));A&4&&(this.compNorm(l),this.compNorm(n),this.VIntX(3*l,this.vlist,this.nlist,6,h,a,I,e,y,J));A&8&&(this.compNorm(f),this.compNorm(l),this.VIntY(3*f,this.vlist,this.nlist,9,h,a,b,e,t,y));A&16&&(this.compNorm(j),this.compNorm(p),this.VIntX(3*j,this.vlist,this.nlist,12,h,a,b,M,K,u));A&32&&(this.compNorm(p),
this.compNorm(m),this.VIntY(3*p,this.vlist,this.nlist,15,h,N,b,M,u,H));A&64&&(this.compNorm(o),this.compNorm(m),this.VIntX(3*o,this.vlist,this.nlist,18,h,a,I,M,B,H));A&128&&(this.compNorm(j),this.compNorm(o),this.VIntY(3*j,this.vlist,this.nlist,21,h,a,b,M,K,B));A&256&&(this.compNorm(f),this.compNorm(j),this.VIntZ(3*f,this.vlist,this.nlist,24,h,a,b,e,t,K));A&512&&(this.compNorm(k),this.compNorm(p),this.VIntZ(3*k,this.vlist,this.nlist,27,h,N,b,e,z,u));A&1024&&(this.compNorm(n),this.compNorm(m),this.VIntZ(3*
n,this.vlist,this.nlist,30,h,N,I,e,J,H));A&2048&&(this.compNorm(l),this.compNorm(o),this.VIntZ(3*l,this.vlist,this.nlist,33,h,a,I,e,y,B));r<<=4;for(h=f=0;-1!=THREE.triTable[r+h];)a=r+h,b=a+1,e=a+2,this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[a],3*THREE.triTable[b],3*THREE.triTable[e],i),h+=3,f++;return f};this.posnormtriv=function(a,b,e,f,h,i){var k=3*this.count;this.positionArray[k]=a[e];this.positionArray[k+1]=a[e+1];this.positionArray[k+2]=a[e+2];this.positionArray[k+3]=a[f];this.positionArray[k+
4]=a[f+1];this.positionArray[k+5]=a[f+2];this.positionArray[k+6]=a[h];this.positionArray[k+7]=a[h+1];this.positionArray[k+8]=a[h+2];this.normalArray[k]=b[e];this.normalArray[k+1]=b[e+1];this.normalArray[k+2]=b[e+2];this.normalArray[k+3]=b[f];this.normalArray[k+4]=b[f+1];this.normalArray[k+5]=b[f+2];this.normalArray[k+6]=b[h];this.normalArray[k+7]=b[h+1];this.normalArray[k+8]=b[h+2];this.hasNormal=this.hasPos=!0;this.count+=3;this.count>=this.maxCount-3&&i(this)};this.begin=function(){this.count=0;
this.hasNormal=this.hasPos=!1};this.end=function(a){if(0!==this.count){for(var b=3*this.count;b<this.positionArray.length;b++)this.positionArray[b]=0;a(this)}};this.addBall=function(a,b,e,f,h){var i=this.size*Math.sqrt(f/h),k=e*this.size,l=b*this.size,j=a*this.size,n=Math.floor(k-i);1>n&&(n=1);k=Math.floor(k+i);k>this.size-1&&(k=this.size-1);var p=Math.floor(l-i);1>p&&(p=1);l=Math.floor(l+i);l>this.size-1&&(l=this.size-1);var o=Math.floor(j-i);1>o&&(o=1);i=Math.floor(j+i);i>this.size-1&&(i=this.size-
1);for(var m,r,t,z,y,J,K,j=n;j<k;j++){t=this.size2*j;y=j/this.size-e;J=y*y;for(n=p;n<l;n++){r=t+this.size*n;m=n/this.size-b;K=m*m;for(m=o;m<i;m++)z=m/this.size-a,z=f/(1.0E-6+z*z+K+J)-h,0<z&&(this.field[r+m]+=z)}}};this.addPlaneX=function(a,b){var e,f,h,i,k,l=this.size,j=this.yd,n=this.zd,p=this.field,o=l*Math.sqrt(a/b);o>l&&(o=l);for(e=0;e<o;e++)if(f=e/l,f*=f,i=a/(1.0E-4+f)-b,0<i)for(f=0;f<l;f++){k=e+f*j;for(h=0;h<l;h++)p[n*h+k]+=i}};this.addPlaneY=function(a,b){var e,f,h,i,k,l,j=this.size,n=this.yd,
p=this.zd,o=this.field,m=j*Math.sqrt(a/b);m>j&&(m=j);for(f=0;f<m;f++)if(e=f/j,e*=e,i=a/(1.0E-4+e)-b,0<i){k=f*n;for(e=0;e<j;e++){l=k+e;for(h=0;h<j;h++)o[p*h+l]+=i}}};this.addPlaneZ=function(a,b){var e,f,h,i,k,l,j=this.size,n=this.yd,p=this.zd,o=this.field,m=j*Math.sqrt(a/b);m>j&&(m=j);for(h=0;h<m;h++)if(e=h/j,e*=e,i=a/(1.0E-4+e)-b,0<i){k=p*h;for(f=0;f<j;f++){l=k+f*n;for(e=0;e<j;e++)o[l+e]+=i}}};this.reset=function(){var a;for(a=0;a<this.size3;a++)this.normal_cache[3*a]=0,this.field[a]=0};this.render=
function(a){this.begin();var b,e,f,h,i,k,l,j,n,p=this.size-2;for(h=1;h<p;h++){n=this.size2*h;l=(h-this.halfsize)/this.halfsize;for(f=1;f<p;f++){j=n+this.size*f;k=(f-this.halfsize)/this.halfsize;for(e=1;e<p;e++)i=(e-this.halfsize)/this.halfsize,b=j+e,this.polygonize(i,k,l,b,this.isolation,a)}}this.end(a)};this.generateGeometry=function(){var a=0,b=new THREE.Geometry,e=[];this.render(function(f){var h,i,k,l,j,n,p,o;for(h=0;h<f.count;h++)p=3*h,j=p+1,o=p+2,i=f.positionArray[p],k=f.positionArray[j],l=
f.positionArray[o],n=new THREE.Vector3(i,k,l),i=f.normalArray[p],k=f.normalArray[j],l=f.normalArray[o],p=new THREE.Vector3(i,k,l),p.normalize(),j=new THREE.Vertex(n),b.vertices.push(j),e.push(p);n=f.count/3;for(h=0;h<n;h++)p=3*(a+h),j=p+1,o=p+2,i=e[p],k=e[j],l=e[o],p=new THREE.Face3(p,j,o,[i,k,l]),b.faces.push(p);a+=n;f.count=0});return b};this.init(a)};THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
THREE.LensFlarePlugin=function(){function a(a){var c=b.createProgram(),d=b.createShader(b.FRAGMENT_SHADER),e=b.createShader(b.VERTEX_SHADER);b.shaderSource(d,a.fragmentShader);b.shaderSource(e,a.vertexShader);b.compileShader(d);b.compileShader(e);b.attachShader(c,d);b.attachShader(c,e);b.linkProgram(c);return c}var b,c,d,e,f,h,i,k,l,j,n,p,o;this.init=function(m){b=m.context;c=m;d=new Float32Array(16);e=new Uint16Array(6);m=0;d[m++]=-1;d[m++]=-1;d[m++]=0;d[m++]=0;d[m++]=1;d[m++]=-1;d[m++]=1;d[m++]=
0;d[m++]=1;d[m++]=1;d[m++]=1;d[m++]=1;d[m++]=-1;d[m++]=1;d[m++]=0;d[m++]=1;m=0;e[m++]=0;e[m++]=1;e[m++]=2;e[m++]=0;e[m++]=2;e[m++]=3;f=b.createBuffer();h=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,f);b.bufferData(b.ARRAY_BUFFER,d,b.STATIC_DRAW);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,h);b.bufferData(b.ELEMENT_ARRAY_BUFFER,e,b.STATIC_DRAW);i=b.createTexture();k=b.createTexture();b.bindTexture(b.TEXTURE_2D,i);b.texImage2D(b.TEXTURE_2D,0,b.RGB,16,16,0,b.RGB,b.UNSIGNED_BYTE,null);b.texParameteri(b.TEXTURE_2D,
b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.NEAREST);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.NEAREST);b.bindTexture(b.TEXTURE_2D,k);b.texImage2D(b.TEXTURE_2D,0,b.RGBA,16,16,0,b.RGBA,b.UNSIGNED_BYTE,null);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.NEAREST);
b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.NEAREST);0>=b.getParameter(b.MAX_VERTEX_TEXTURE_IMAGE_UNITS)?(l=!1,j=a(THREE.ShaderFlares.lensFlare)):(l=!0,j=a(THREE.ShaderFlares.lensFlareVertexTexture));n={};p={};n.vertex=b.getAttribLocation(j,"position");n.uv=b.getAttribLocation(j,"uv");p.renderType=b.getUniformLocation(j,"renderType");p.map=b.getUniformLocation(j,"map");p.occlusionMap=b.getUniformLocation(j,"occlusionMap");p.opacity=b.getUniformLocation(j,"opacity");p.color=b.getUniformLocation(j,
"color");p.scale=b.getUniformLocation(j,"scale");p.rotation=b.getUniformLocation(j,"rotation");p.screenPosition=b.getUniformLocation(j,"screenPosition");o=!1};this.render=function(a,d,e,z){var a=a.__webglFlares,y=a.length;if(y){var J=new THREE.Vector3,K=z/e,u=0.5*e,B=0.5*z,H=16/z,A=new THREE.Vector2(H*K,H),M=new THREE.Vector3(1,1,0),N=new THREE.Vector2(1,1),I=p,H=n;b.useProgram(j);o||(b.enableVertexAttribArray(n.vertex),b.enableVertexAttribArray(n.uv),o=!0);b.uniform1i(I.occlusionMap,0);b.uniform1i(I.map,
1);b.bindBuffer(b.ARRAY_BUFFER,f);b.vertexAttribPointer(H.vertex,2,b.FLOAT,!1,16,0);b.vertexAttribPointer(H.uv,2,b.FLOAT,!1,16,8);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,h);b.disable(b.CULL_FACE);b.depthMask(!1);var S,ua,ka,$,Z;for(S=0;S<y;S++)if(H=16/z,A.set(H*K,H),$=a[S],J.set($.matrixWorld.n14,$.matrixWorld.n24,$.matrixWorld.n34),d.matrixWorldInverse.multiplyVector3(J),d.projectionMatrix.multiplyVector3(J),M.copy(J),N.x=M.x*u+u,N.y=M.y*B+B,l||0<N.x&&N.x<e&&0<N.y&&N.y<z){b.activeTexture(b.TEXTURE1);
b.bindTexture(b.TEXTURE_2D,i);b.copyTexImage2D(b.TEXTURE_2D,0,b.RGB,N.x-8,N.y-8,16,16,0);b.uniform1i(I.renderType,0);b.uniform2f(I.scale,A.x,A.y);b.uniform3f(I.screenPosition,M.x,M.y,M.z);b.disable(b.BLEND);b.enable(b.DEPTH_TEST);b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0);b.activeTexture(b.TEXTURE0);b.bindTexture(b.TEXTURE_2D,k);b.copyTexImage2D(b.TEXTURE_2D,0,b.RGBA,N.x-8,N.y-8,16,16,0);b.uniform1i(I.renderType,1);b.disable(b.DEPTH_TEST);b.activeTexture(b.TEXTURE1);b.bindTexture(b.TEXTURE_2D,
i);b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0);$.positionScreen.copy(M);$.customUpdateCallback?$.customUpdateCallback($):$.updateLensFlares();b.uniform1i(I.renderType,2);b.enable(b.BLEND);for(ua=0,ka=$.lensFlares.length;ua<ka;ua++)if(Z=$.lensFlares[ua],0.001<Z.opacity&&0.001<Z.scale)M.x=Z.x,M.y=Z.y,M.z=Z.z,H=Z.size*Z.scale/z,A.x=H*K,A.y=H,b.uniform3f(I.screenPosition,M.x,M.y,M.z),b.uniform2f(I.scale,A.x,A.y),b.uniform1f(I.rotation,Z.rotation),b.uniform1f(I.opacity,Z.opacity),b.uniform3f(I.color,
Z.color.r,Z.color.g,Z.color.b),c.setBlending(Z.blending),c.setTexture(Z.texture,1),b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0)}b.enable(b.CULL_FACE);b.enable(b.DEPTH_TEST);b.depthMask(!0)}}};
THREE.ShadowMapPlugin=function(){var a,b,c,d,e=new THREE.Frustum,f=new THREE.Matrix4;this.init=function(e){a=e.context;b=e;var e=THREE.ShaderLib.depthRGBA,f=THREE.UniformsUtils.clone(e.uniforms);c=new THREE.ShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:f});d=new THREE.ShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:f,morphTargets:!0});c._shadowPass=!0;d._shadowPass=!0};this.render=function(a,c){b.shadowMapEnabled&&b.shadowMapAutoUpdate&&
this.update(a,c)};this.update=function(h){var i,k,l,j,n,p,o,m,r,t=h.lights;a.clearColor(1,1,1,1);a.disable(a.BLEND);b.shadowMapCullFrontFaces&&a.cullFace(a.FRONT);b.setDepthTest(!0);for(i=0,k=t.length;i<k;i++)if(m=t[i],m.castShadow){if(!m.shadowMap)m.shadowMap=new THREE.WebGLRenderTarget(m.shadowMapWidth,m.shadowMapHeight,{minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,format:THREE.RGBAFormat}),m.shadowMapSize=new THREE.Vector2(m.shadowMapWidth,m.shadowMapHeight),m.shadowMatrix=new THREE.Matrix4;
if(!m.shadowCamera){if(m instanceof THREE.SpotLight)m.shadowCamera=new THREE.PerspectiveCamera(m.shadowCameraFov,m.shadowMapWidth/m.shadowMapHeight,m.shadowCameraNear,m.shadowCameraFar);else if(m instanceof THREE.DirectionalLight)m.shadowCamera=new THREE.OrthographicCamera(m.shadowCameraLeft,m.shadowCameraRight,m.shadowCameraTop,m.shadowCameraBottom,m.shadowCameraNear,m.shadowCameraFar);else{console.error("Unsupported light type for shadow");continue}h.add(m.shadowCamera);b.autoUpdateScene&&h.updateMatrixWorld()}if(m.shadowCameraVisible&&
!m.cameraHelper)m.cameraHelper=new THREE.CameraHelper(m.shadowCamera),m.shadowCamera.add(m.cameraHelper);l=m.shadowMap;j=m.shadowMatrix;n=m.shadowCamera;n.position.copy(m.matrixWorld.getPosition());n.lookAt(m.target.matrixWorld.getPosition());n.updateMatrixWorld();n.matrixWorldInverse.getInverse(n.matrixWorld);if(m.cameraHelper)m.cameraHelper.lines.visible=m.shadowCameraVisible;m.shadowCameraVisible&&m.cameraHelper.update(m.shadowCamera);j.set(0.5,0,0,0.5,0,0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);j.multiplySelf(n.projectionMatrix);
j.multiplySelf(n.matrixWorldInverse);if(!n._viewMatrixArray)n._viewMatrixArray=new Float32Array(16);n.matrixWorldInverse.flattenToArray(n._viewMatrixArray);if(!n._projectionMatrixArray)n._projectionMatrixArray=new Float32Array(16);n.projectionMatrix.flattenToArray(n._projectionMatrixArray);f.multiply(n.projectionMatrix,n.matrixWorldInverse);e.setFromMatrix(f);b.setRenderTarget(l);b.clear();r=h.__webglObjects;for(l=0,j=r.length;l<j;l++)if(p=r[l],m=p.object,p.render=!1,m.visible&&m.castShadow&&(!(m instanceof
THREE.Mesh)||!m.frustumCulled||e.contains(m)))m.matrixWorld.flattenToArray(m._objectMatrixArray),m._modelViewMatrix.multiplyToArray(n.matrixWorldInverse,m.matrixWorld,m._modelViewMatrixArray),p.render=!0;for(l=0,j=r.length;l<j;l++)if(p=r[l],p.render)m=p.object,p=p.buffer,b.setObjectFaces(m),o=m.customDepthMaterial?m.customDepthMaterial:m.geometry.morphTargets.length?d:c,p instanceof THREE.BufferGeometry?b.renderBufferDirect(n,t,null,o,p,m):b.renderBuffer(n,t,null,o,p,m);r=h.__webglObjectsImmediate;
for(l=0,j=r.length;l<j;l++)p=r[l],m=p.object,m.visible&&m.castShadow&&(m.matrixAutoUpdate&&m.matrixWorld.flattenToArray(m._objectMatrixArray),m._modelViewMatrix.multiplyToArray(n.matrixWorldInverse,m.matrixWorld,m._modelViewMatrixArray),b.renderImmediateObject(n,t,null,c,m))}h=b.getClearColor();i=b.getClearAlpha();a.clearColor(h.r,h.g,h.b,i);a.enable(a.BLEND);b.shadowMapCullFrontFaces&&a.cullFace(a.BACK)}};
THREE.SpritePlugin=function(){function a(a,b){return b.z-a.z}var b,c,d,e,f,h,i,k,l,j;this.init=function(a){b=a.context;c=a;d=new Float32Array(16);e=new Uint16Array(6);a=0;d[a++]=-1;d[a++]=-1;d[a++]=0;d[a++]=1;d[a++]=1;d[a++]=-1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=0;d[a++]=-1;d[a++]=1;d[a++]=0;a=d[a++]=0;e[a++]=0;e[a++]=1;e[a++]=2;e[a++]=0;e[a++]=2;e[a++]=3;f=b.createBuffer();h=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,f);b.bufferData(b.ARRAY_BUFFER,d,b.STATIC_DRAW);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,
h);b.bufferData(b.ELEMENT_ARRAY_BUFFER,e,b.STATIC_DRAW);var a=THREE.ShaderSprite.sprite,p=b.createProgram(),o=b.createShader(b.FRAGMENT_SHADER),m=b.createShader(b.VERTEX_SHADER);b.shaderSource(o,a.fragmentShader);b.shaderSource(m,a.vertexShader);b.compileShader(o);b.compileShader(m);b.attachShader(p,o);b.attachShader(p,m);b.linkProgram(p);i=p;k={};l={};k.position=b.getAttribLocation(i,"position");k.uv=b.getAttribLocation(i,"uv");l.uvOffset=b.getUniformLocation(i,"uvOffset");l.uvScale=b.getUniformLocation(i,
"uvScale");l.rotation=b.getUniformLocation(i,"rotation");l.scale=b.getUniformLocation(i,"scale");l.alignment=b.getUniformLocation(i,"alignment");l.color=b.getUniformLocation(i,"color");l.map=b.getUniformLocation(i,"map");l.opacity=b.getUniformLocation(i,"opacity");l.useScreenCoordinates=b.getUniformLocation(i,"useScreenCoordinates");l.affectedByDistance=b.getUniformLocation(i,"affectedByDistance");l.screenPosition=b.getUniformLocation(i,"screenPosition");l.modelViewMatrix=b.getUniformLocation(i,"modelViewMatrix");
l.projectionMatrix=b.getUniformLocation(i,"projectionMatrix");j=!1};this.render=function(d,e,o,m){var d=d.__webglSprites,r=d.length;if(r){var t=k,z=l,y=m/o,o=0.5*o,J=0.5*m,K=!0;b.useProgram(i);j||(b.enableVertexAttribArray(t.position),b.enableVertexAttribArray(t.uv),j=!0);b.disable(b.CULL_FACE);b.enable(b.BLEND);b.depthMask(!0);b.bindBuffer(b.ARRAY_BUFFER,f);b.vertexAttribPointer(t.position,2,b.FLOAT,!1,16,0);b.vertexAttribPointer(t.uv,2,b.FLOAT,!1,16,8);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,h);b.uniformMatrix4fv(z.projectionMatrix,
!1,e._projectionMatrixArray);b.activeTexture(b.TEXTURE0);b.uniform1i(z.map,0);for(var u,B=[],t=0;t<r;t++)if(u=d[t],u.visible&&0!==u.opacity)u.useScreenCoordinates?u.z=-u.position.z:(u._modelViewMatrix.multiplyToArray(e.matrixWorldInverse,u.matrixWorld,u._modelViewMatrixArray),u.z=-u._modelViewMatrix.n34);d.sort(a);for(t=0;t<r;t++)u=d[t],u.visible&&0!==u.opacity&&u.map&&u.map.image&&u.map.image.width&&(u.useScreenCoordinates?(b.uniform1i(z.useScreenCoordinates,1),b.uniform3f(z.screenPosition,(u.position.x-
o)/o,(J-u.position.y)/J,Math.max(0,Math.min(1,u.position.z)))):(b.uniform1i(z.useScreenCoordinates,0),b.uniform1i(z.affectedByDistance,u.affectedByDistance?1:0),b.uniformMatrix4fv(z.modelViewMatrix,!1,u._modelViewMatrixArray)),e=u.map.image.width/(u.scaleByViewport?m:1),B[0]=e*y*u.scale.x,B[1]=e*u.scale.y,b.uniform2f(z.uvScale,u.uvScale.x,u.uvScale.y),b.uniform2f(z.uvOffset,u.uvOffset.x,u.uvOffset.y),b.uniform2f(z.alignment,u.alignment.x,u.alignment.y),b.uniform1f(z.opacity,u.opacity),b.uniform3f(z.color,
u.color.r,u.color.g,u.color.b),b.uniform1f(z.rotation,u.rotation),b.uniform2fv(z.scale,B),u.mergeWith3D&&!K?(b.enable(b.DEPTH_TEST),K=!0):!u.mergeWith3D&&K&&(b.disable(b.DEPTH_TEST),K=!1),c.setBlending(u.blending),c.setTexture(u.map,0),b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0));b.enable(b.CULL_FACE);b.enable(b.DEPTH_TEST);b.depthMask(!0)}}};
THREE.ShaderFlares={lensFlareVertexTexture:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"precision mediump float;\nuniform sampler2D map;\nuniform float opacity;\nuniform int renderType;\nuniform vec3 color;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * vVisibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"},
lensFlare:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"precision mediump float;\nuniform sampler2D map;\nuniform sampler2D occlusionMap;\nuniform float opacity;\nuniform int renderType;\nuniform vec3 color;\nvarying vec2 vUV;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * visibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"}};
THREE.ShaderSprite={sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"precision mediump float;\nuniform vec3 color;\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 texture = texture2D( map, vUV );\ngl_FragColor = vec4( color * texture.xyz, texture.a * opacity );\n}"}};
THREE.ImageUtils={crossOrigin:"",loadTexture:function(a,b,c){var d=new Image,e=new THREE.Texture(d,b);d.onload=function(){e.needsUpdate=!0;c&&c(this)};d.crossOrigin=this.crossOrigin;d.src=a;return e},loadTextureCube:function(a,b,c){var d,e=[],f=new THREE.Texture(e,b);e.loadCount=0;for(b=0,d=a.length;b<d;++b)e[b]=new Image,e[b].onload=function(){e.loadCount+=1;if(6===e.loadCount)f.needsUpdate=!0;c&&c(this)},e[b].crossOrigin="",e[b].src=a[b];return f},getNormalMap:function(a,b){var c=function(a){var b=
Math.sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2]);return[a[0]/b,a[1]/b,a[2]/b]},b=b|1,d=a.width,e=a.height,f=document.createElement("canvas");f.width=d;f.height=e;var h=f.getContext("2d");h.drawImage(a,0,0);for(var i=h.getImageData(0,0,d,e).data,k=h.createImageData(d,e),l=k.data,j=0;j<d;j++)for(var n=1;n<e;n++){var p=0>n-1?e-1:n-1,o=(n+1)%e,m=0>j-1?d-1:j-1,r=(j+1)%d,t=[],z=[0,0,i[4*(n*d+j)]/255*b];t.push([-1,0,i[4*(n*d+m)]/255*b]);t.push([-1,-1,i[4*(p*d+m)]/255*b]);t.push([0,-1,i[4*(p*d+j)]/255*b]);t.push([1,
-1,i[4*(p*d+r)]/255*b]);t.push([1,0,i[4*(n*d+r)]/255*b]);t.push([1,1,i[4*(o*d+r)]/255*b]);t.push([0,1,i[4*(o*d+j)]/255*b]);t.push([-1,1,i[4*(o*d+m)]/255*b]);p=[];m=t.length;for(o=0;o<m;o++){var r=t[o],y=t[(o+1)%m],r=[r[0]-z[0],r[1]-z[1],r[2]-z[2]],y=[y[0]-z[0],y[1]-z[1],y[2]-z[2]];p.push(c([r[1]*y[2]-r[2]*y[1],r[2]*y[0]-r[0]*y[2],r[0]*y[1]-r[1]*y[0]]))}t=[0,0,0];for(o=0;o<p.length;o++)t[0]+=p[o][0],t[1]+=p[o][1],t[2]+=p[o][2];t[0]/=p.length;t[1]/=p.length;t[2]/=p.length;z=4*(n*d+j);l[z]=255*((t[0]+
1)/2)|0;l[z+1]=255*(t[1]+0.5)|0;l[z+2]=255*t[2]|0;l[z+3]=255}h.putImageData(k,0,0);return f}};
