
// This uses require.js to structure javascript:
// http://requirejs.org/docs/api.html#define

define(function(require) {
    var xmlDoc;
    var settings = null;
    var hasLocalStorage = 'localStorage' in window;
    var numberOfImportantVerbs = 0;
    var numberOfIrregularVerbs = 0;
    var settingsShown = false;
    var soluction = "";    
    var numberOfVerbs = 1;
    var numberOfTries = 0;
    var numberOfSuccess = 0;
    var settingsChanged = false;
    var verbListBeforeConfig = "";

    //
    // methods processing UI events
    //

    // Settings button 
    document.getElementById('btn_settings').addEventListener('click', function(e)
    {
        document.getElementById('div_settings').style.height= window.innerHeight - 50 + 'px';
        document.getElementById('div_container').style.display = "none";
        document.getElementById('div_settings').style.display = "inline";
        document.getElementById('btn_back').style.display = "inline";
        document.getElementById('btn_settings').style.display = "none";
        document.getElementById('div_counter').style.display = "none";
        settingsShown = true; 

        document.getElementById('input_verblist').value = ""; 

        if ((settings.verbList !== null) && (settings.verbList.length > 0))
        {
            for (i = 0; i < settings.verbList.length - 1; i++)
            {
                document.getElementById('input_verblist').value += settings.verbList[i] + " ";
            }

            document.getElementById('input_verblist').value += settings.verbList[settings.verbList.length - 1]; // last item
            
            verbListBeforeConfig = document.getElementById('input_verblist').value;
        }
    });

    document.addEventListener('visibilitychange', function()
    {
        if (document.hidden)
        {
        }
        else
        {
        }
    });

    window.addEventListener('resize', function()
    {
        if (settingsShown)
        {
            document.getElementById('div_settings').style.height= window.innerHeight - 50 + 'px';
        }
    });


     // back button on settings page 
    document.getElementById('btn_back').addEventListener('click', function(e)
    {
        document.getElementById('div_container').style.display = "block";
        document.getElementById('div_settings').style.display = "none";
        document.getElementById('btn_back').style.display = "none";
        document.getElementById('btn_settings').style.display = "inline";
        document.getElementById('div_counter').style.display = "inline";
        settingsShown = false;

        settings.verbList = new Array();
        settings.verbList = document.getElementById('input_verblist').value.toLowerCase().split(/\W/m);
 
        // removing non-words from array
        var filteredVerbList = new Array();

        if ((settings.verbList !== null) && (settings.verbList.length > 0))
        {
            var errorstring = "";

            for (i = 0; i < settings.verbList.length; i++)
            {
                if (settings.verbList[i].length > 1)
                {
                    var xPathStringInfinitiv = "/verbos/verbo[@infinitivo='" + settings.verbList[i] + "']";

                    var nsResolver = xmlDoc.createNSResolver( xmlDoc.ownerDocument == null ? xmlDoc.documentElement : xmlDoc.ownerDocument.documentElement);
                    var iteratorInfinitiv = xmlDoc.evaluate(xPathStringInfinitiv, xmlDoc, nsResolver, XPathResult.ANY_TYPE, null);

                    var verbNode = iteratorInfinitiv.iterateNext();

                    if (verbNode)
                    {
                        filteredVerbList.push(settings.verbList[i]);
                    }
                    else
                    {
                        errorstring += settings.verbList[i] + ", ";
                    }
                }
            }

            if (errorstring != "")
            {
                errorstring = errorstring.substr(0, errorstring.length - 2);
                window.alert("Removiendo " + errorstring);
            }

            settings.verbList = filteredVerbList;

            if (hasLocalStorage)
            {
                try
                {
                    localStorage.setItem('settings2', JSON.stringify(settings));
                }
                catch(e)    
                {
                    console.error("Parsing error: ", e);
                }
            }
        }

        if (solucion !== null)
        {
            document.getElementById('input_solucion').value = "";
        }
 
        if ((settingsChanged || (verbListBeforeConfig != document.getElementById('input_verblist').value.toLowerCase())) && (solucion !== null))
        {
            readRanddomVerbFromFromXMLAndShow();
            settingsChanged = false;
        }
    });

    document.getElementById('input_solucion').addEventListener("keyup", function(e)
    {
        if (e.keyCode === 13)
        {
            e.preventDefault();
            onUserInputComplete(e);
        }
    });

    document.getElementById('btn_check').addEventListener('click', onUserInputComplete);
    
    function onUserInputComplete(e)
    {
        var tocheck = document.getElementById('input_solucion').value;

        if (tocheck === solucion)
        {
            // check successful, input found to be the correct solution
            document.getElementById('img_success').style.visibility = "visible";
            document.getElementById('btn_check').blur();
            document.getElementById('btn_check').style.backgroundImage = "url(../img/icons/ArrowLeft.png)";
            numberOfSuccess++;
            numberOfTries++;
 
            document.getElementById('p_counter').innerHTML = numberOfSuccess + "-" + numberOfTries + "-" + numberOfVerbs;
            // solution is no longer needed, using it to indicate that
            // next verb can be shown
            solucion = null;
            // TODO delay?
        }
        else if ((solucion == null) || (tocheck == "")) // TODO remove or, another button instead
        {
            // soluction already shown or proceeding to next verb by checking empty input field
            document.getElementById('input_solucion').value = "";
            document.getElementById('img_success').style.visibility = "hidden";
            
            document.getElementById('btn_check').style.backgroundImage = "url(../img/icons/button4.png)";

            numberOfVerbs++;
            document.getElementById('p_counter').innerHTML = numberOfSuccess + "-" + numberOfTries + "-" + numberOfVerbs;
            readRanddomVerbFromFromXMLAndShow();
            document.getElementById('btn_check').blur();
        }
        else
        {
            // check not successful, showing error dialog
            document.getElementById('img_success').style.visibility = "hidden";

            document.getElementById('btn_check').style.backgroundImage = "url(../img/icons/button4.png)";
            document.getElementById('input_solucion').blur(); 
            document.getElementById('msg_error_dlg').style.display = "inline";
            numberOfTries++;

            document.getElementById('p_counter').innerHTML = numberOfSuccess + "-" + numberOfTries + "-" + numberOfVerbs;
        }
    }

    document.getElementById('btn_next').addEventListener("click", function(e)
    {
       document.getElementById('msg_error_dlg').style.display = "none";
    });

    document.getElementById('btn_solucion').addEventListener("click", function(e)
    {
        document.getElementById('input_solucion').value = solucion + " (" + document.getElementById('input_solucion').value + ")";
        solucion = null;
        document.getElementById('msg_error_dlg').style.display = "none";
        document.getElementById('btn_check').style.backgroundImage = "url(../img/icons/ArrowLeft.png)";
    });

    screen.addEventListener("mozorientationchange", function (e)
    {
        e.preventDefault();       
    });

    //
    // auxiliary functions
    //

    function readRanddomVerbFromFromXMLAndShow()
    {
        var xPathStringInfinitiv;
        var xPathStringFormNode;
        var xPathFormaPrefix;

        document.getElementById('desc_verb_form').innerHTML = "";

        if ((settings.useVerbList) && (settings.verbList !== null) && (settings.verbList.length > 0))
        {
            var randomVerbNumber = Math.round(Math.random() * (settings.verbList.length - 1));

            var infinitivForm = settings.verbList[randomVerbNumber];
            xPathStringInfinitiv = "/verbos/verbo[@infinitivo='" + infinitivForm + "']/attribute::infinitivo";

            xPathStringFormNode = "/verbos/verbo[@infinitivo='" + infinitivForm + "']/descendant::forma";
            xPathFormaPrefix = "/verbos/verbo[@infinitivo='" + infinitivForm + "']/descendant::forma["

        }        
        else if (settings.iregulares)
        {
            var randomVerbNumber = Math.round(Math.random() * (numberOfIregularVerbs-1)) + 1;
            xPathStringInfinitiv = "/verbos/verbo[@regular='iregular'][" + randomVerbNumber + "]/attribute::infinitivo";

            xPathStringFormNode = "/verbos/verbo[@regular='iregular'][" + randomVerbNumber + "]/descendant::forma";
            xPathFormaPrefix = "/verbos/verbo[@regular='iregular'][" + randomVerbNumber + "]/descendant::forma["
        }
        else
        {
            var randomVerbNumber = Math.round(Math.random() * 7) + 1;

            xPathStringInfinitiv = "/verbos/verbo[@id='" + randomVerbNumber + "']/attribute::infinitivo";

            xPathStringFormNode = "/verbos/verbo[@id='" + randomVerbNumber + "']/descendant::forma";
            xPathFormaPrefix = "/verbos/verbo[@id='" + randomVerbNumber + "']/descendant::forma["
        }

        var nsResolver = xmlDoc.createNSResolver( xmlDoc.ownerDocument == null ? xmlDoc.documentElement : xmlDoc.ownerDocument.documentElement);

        var iteratorInfinitiv = xmlDoc.evaluate(xPathStringInfinitiv, xmlDoc, nsResolver, XPathResult.ANY_TYPE, null);

        var iteratorFormaNode = xmlDoc.evaluate(xPathStringFormNode, xmlDoc, nsResolver, XPathResult.ANY_TYPE, null); 

        var verbNode = iteratorInfinitiv.iterateNext();

        var formaRandomNumberMapping = calculateFormaRandomNumberMapping(iteratorFormaNode);

        var randomFormaNumberUnmapped = Math.round(Math.random() * (formaRandomNumberMapping.length - 2)) + 1; // -2: zero based array, but position "0" is invalid

        var randomFormaNumber = formaRandomNumberMapping[randomFormaNumberUnmapped];

        var iteratorFormToAsk = xmlDoc.evaluate(xPathFormaPrefix + randomFormaNumber + "]", xmlDoc, nsResolver, XPathResult.ANY_TYPE, null);

        var formaToAskNode = iteratorFormToAsk.iterateNext();

        var personaNumber = 0;
       
        if (formaToAskNode.attributes['c'])
        {
            personaNumber = formaToAskNode.attributes['c'].textContent;
        }
 
        var formaAncestor1 = formaToAskNode.parentNode.nodeName;

        var formaAncestor2 = formaToAskNode.parentNode.parentNode.nodeName;

        var formaAncestor3 = formaToAskNode.parentNode.parentNode.parentNode.nodeName;
        if (formaAncestor3 == "verbo")
        {
            formaAncestor3 = "";
        }

        if (formaAncestor2 == "verbo")
        {
            formaAncestor2 = "";
            formaAncestor3 = "";
        }

        var xPathDescription = "";

        if (formaAncestor2 == "")
        {
            if (personaNumber == 0)
            {

                xPathDescription = "/verbos/textos/" + formaAncestor1 + "/forma[1]/attribute::forma";
            }
            else
            {
                xPathDescription = "/verbos/textos/" + formaAncestor1 + "/forma[@c='" + personaNumber + "']/attribute::forma";
            }
        }
        else if (formaAncestor3 == "")
        {
            if (personaNumber == '0')
            {

                xPathDescription = "/verbos/textos/" + "/" + formaAncestor2 + "/" + formaAncestor1 + "/forma[1]/attribute::forma";
            }
            else
            {
                xPathDescription = "/verbos/textos/" + "/" + formaAncestor2 + "/" + formaAncestor1 + "/forma[@c='" + personaNumber + "']/attribute::forma";
            }
        }
        else
        {
            xPathDescription = "/verbos/textos/" + formaAncestor3 + "/" + formaAncestor2 + "/" + formaAncestor1 + "/forma[@c='" + personaNumber + "']/attribute::forma";
        }

        iteratorDescriptionOfVerbForm = xmlDoc.evaluate(xPathDescription, xmlDoc, nsResolver, XPathResult.ANY_TYPE, null);

        var descriptionNode = iteratorDescriptionOfVerbForm.iterateNext();
        
        solucion = formaToAskNode.textContent;
        document.getElementById('desc_verb_form').innerHTML = descriptionNode.textContent + " " + verbNode.textContent;
    }    

    function on_settings_changed(e)
    {
        settingsChanged = true;

        settings = new Object();
        
        if (document.getElementById('input_presenteindicativo').checked)
        {
            settings.presenteindicativo = true;
        }
        else
        {
            settings.presenteindicativo = false;
        }

        if (document.getElementById('input_preteritoindicativo').checked)
        {
            settings.preteritoindicativo = true;
        }
        else
        {
            settings.preteritoindicativo = false;
        }

        if (document.getElementById('input_conditional').checked)
        {
            settings.conditional = true;
        }
        else
        {
            settings.conditional = false;
        }

        if (document.getElementById('input_participio').checked)
        {
            settings.participio = true;
        }
        else
        {
            settings.participio = false;
        }

        if (document.getElementById('input_presentesubjuntivo').checked)
        {
            settings.presentesubjuntivo = true;
        }
        else
        {
            settings.presentesubjuntivo = false;
        }

        if (document.getElementById('input_imperfectosubjuntivo').checked)
        {
            settings.imperfectosubjuntivo = true;
        }
        else
        {
            settings.imperfectosubjuntivo = false;
        }

        if (document.getElementById('input_imperfectoindicativo').checked)
        {
            settings.imperfectoindicativo = true;
        }
        else
        {
            settings.imperfectoindicativo = false;
        }

        if (document.getElementById('input_futuro').checked)
        {
            settings.futuro = true;
        }
        else
        {
            settings.futuro = false;
        }

        if (document.getElementById('input_gerundio').checked)
        {
            settings.gerundio = true;
        }
        else
        {
            settings.gerundio = false;
        }
 
        if (document.getElementById('input_imperativo').checked)
        {
            settings.imperativo = true;
        }
        else
        {
            settings.imperativo = false;
        }

        if (e.target.id != 'inputcheckbox_verblist')
        {
            if (document.getElementById('input_iregulares').checked)
            {
                settings.iregulares = true;
                if (document.getElementById('inputcheckbox_verblist').checked == true)
                {
                    document.getElementById('inputcheckbox_verblist').checked = false;
                }
            }
            else
            {
                settings.iregulares = false;
            }
        }

        if (document.getElementById('inputcheckbox_verblist').checked)
        {
            settings.useVerbList = true; 
            if (document.getElementById('input_iregulares').checked == true)
            {
                document.getElementById('input_iregulares').checked = false;
            }
        }
        else
        {
            settings.useVerbList = false;
        }

        if (hasLocalStorage)
        {
            try
            {
                localStorage.setItem('settings2', JSON.stringify(settings));
            }
            catch(e)    
            {
                console.error("Parsing error: ", e);
            }
        }

        if (settings.soloimportantes)
        {
            calculateNumberOfImportantVerbs()
        }

        if (settings.iregulares)
        {
            calculateNumberOfIrregularVerbs();
        }

       
    }

    //
    // initialization
    //
    xmlDoc = document.implementation.createDocument("", "test", null);
    xmlDoc.addEventListener("load", verbosLoaded, false);      
    xmlDoc.load('verbos.xml');

    function verbosLoaded(e)
    {

        if (hasLocalStorage)
        {
            try
            {
                settings = JSON.parse(localStorage.getItem('settings2'));
            }
            catch(e)    
            {
               // TODO            
            }
        }

        if (settings == null)
        {
            settings = new Object();
            settings.soloimportantes = false;
            settings.iregulares = false;
            settings.presenteindicativo = true;
            settings.preteritoindicativo = true;
            settings.conditional = true;
            settings.participio = true;
            settings.presentesubjuntivo = true;
            settings.imperfectosubjuntivo = true;
            settings.futuro = true;
            settings.gerundio = true;
            settings.imperativo = true;
            settings.imperfectoindicativo = true;
            settings.verbList = null;
            settings.useVerbList = false;
        }

        document.getElementById('input_iregulares').checked = settings.iregulares;
        document.getElementById('input_presenteindicativo').checked = settings.presenteindicativo;
        document.getElementById('input_preteritoindicativo').checked = settings.preteritoindicativo;
        document.getElementById('input_conditional').checked = settings.conditional;
        document.getElementById('input_participio').checked = settings.participio;
        document.getElementById('input_presentesubjuntivo').checked = settings.presentesubjuntivo;
        document.getElementById('input_imperfectosubjuntivo').checked = settings.imperfectosubjuntivo;
        document.getElementById('input_imperfectoindicativo').checked = settings.imperfectoindicativo;
        document.getElementById('input_futuro').checked = settings.futuro;
        document.getElementById('input_gerundio').checked = settings.gerundio;
        document.getElementById('input_imperativo').checked = settings.imperativo;

        if (settings.soloimportantes)
        {
            calculateNumberOfImportantVerbs()
        }

        if (settings.iregulares)
        {
            calculateNumberOfIrregularVerbs();
        }

        if ((settings.verbList !== null) && (settings.verbList.length > 0))
        {
            if (settings.useVerbList)
            { 
                document.getElementById('inputcheckbox_verblist').checked = true;
            }   
           
            document.getElementById('input_verblist').value = ""; 

            for (i = 0; i < settings.verbList.length - 1; i++)
            {
                document.getElementById('input_verblist').value += settings.verbList[i] + " ";
            }

            document.getElementById('input_verblist').value += settings.verbList[settings.verbList.length - 1]; // last item
        }
        else
        {
           settings.useVerbList = false; 
           document.getElementById('input_verblist').value = "";

           document.getElementById('inputcheckbox_verblist').checked = false;
        }
        
        document.getElementById('input_presenteindicativo').addEventListener('change', on_settings_changed);
        document.getElementById('input_preteritoindicativo').addEventListener('change', on_settings_changed);
        document.getElementById('input_conditional').addEventListener('change', on_settings_changed);
        document.getElementById('input_participio').addEventListener('change', on_settings_changed);
        document.getElementById('input_presentesubjuntivo').addEventListener('change', on_settings_changed);
        document.getElementById('input_imperfectosubjuntivo').addEventListener('change', on_settings_changed);
        document.getElementById('input_imperfectoindicativo').addEventListener('change', on_settings_changed);
        document.getElementById('input_futuro').addEventListener('change', on_settings_changed);
        document.getElementById('input_gerundio').addEventListener('change', on_settings_changed);
        document.getElementById('input_imperativo').addEventListener('change', on_settings_changed);

        document.getElementById('input_iregulares').addEventListener('change', on_settings_changed);
        document.getElementById('inputcheckbox_verblist').addEventListener('change', on_settings_changed);

        readRanddomVerbFromFromXMLAndShow();
        document.getElementById('head_or_id').style.display="inline";
        document.getElementById('div_container').style.display="block";

        var divheight = Math.round(window.innerHeight/10);
        var btnheight = Math.round((divheight - 40) / 2);

        document.getElementById('btn_next').style.marginTop = btnheight + "px";   
        document.getElementById('btn_solucion').style.marginTop = btnheight + "px";   

        document.getElementById('msg_error').style.top = Math.round(window.innerHeight/2) + "px";
        document.getElementById('msg_error').style.left = Math.round(window.innerWidth/25) + "px";
        document.getElementById('input_solucion').style.width = Math.round(window.innerWidth*0.66) + "px";
    }

    /*
    * My idea: Iterate forma nodes. If the user wants a forma to be practiced, add counter to array.
    * The random number (max is length of array) can be matched directly to the forma number.
    * parameter the iterator (forma elements of a single verb)
    * returns the mapping array
    */
    function calculateFormaRandomNumberMapping(iteratorFormaNode)
    {
        var result = new Array();
        // working "1" based in order to make the default case 1-1, 2-2, 3-3... instead of 0-1, 1-2, ...
        result.push(0);

        var counter = 1;
        var formaNode = iteratorFormaNode.iterateNext();

        while (formaNode)
        {
            var parentNodeName = formaNode.parentNode.nodeName;
            var grandparentNodeName = formaNode.parentNode.parentNode.nodeName;
            var grandgrandparentNodeName = formaNode.parentNode.parentNode.parentNode.nodeName;


            if ((grandparentNodeName === "presente") && (grandgrandparentNodeName === "indicativo"))
            {
                if (settings.presenteindicativo)
                {
                    result.push(counter);

                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
                }
            }

            if ((grandparentNodeName === "imperfecto") && (grandgrandparentNodeName === "indicativo"))
            {
                if (settings.imperfectoindicativo)
                {
                    result.push(counter);

                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
                }
            }

            if ((grandparentNodeName === "preterito") && (grandgrandparentNodeName === "indicativo"))
            {
                if (settings.preteritoindicativo)
                {
                    result.push(counter);

                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
 
                }
            }
 
            if ((grandparentNodeName === "futuro") && (grandgrandparentNodeName === "indicativo"))
            {
                if (settings.futuro)
                {
                    result.push(counter);

                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
 
                }
            }
 
            if ((grandparentNodeName === "condicional") && (grandgrandparentNodeName === "indicativo"))
            {
                if (settings.conditional)
                {
                    result.push(counter);

                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
 
                }
            }
           
            if ((grandparentNodeName === "presente") && (grandgrandparentNodeName === "subjuntivo"))
            {
                if (settings.presentesubjuntivo)
                {
                    result.push(counter);

                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
 
                }
            }
 
            if ((grandparentNodeName === "imperfecto") && (grandgrandparentNodeName === "subjuntivo"))
            {
                if (settings.imperfectosubjuntivo)
                {
                    result.push(counter);

                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
 
                }
            }
  
            if (parentNodeName === "gerundio")
            {
                if (settings.gerundio)
                {
                    result.push(counter);
                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
 
                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
                }
            }
  
            if (parentNodeName === "participio")
            {
                if (settings.participio)
                {
                    result.push(counter);
                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
 
                    // two times because there is imperativo twice,
                    // but must not be more probable
                    // presente etc. double probability, gerundio and 
                    // participio three times the probability
                    // and imperativo (incl. negativo) one time
                    result.push(counter);
                }
            }
 
            if ((grandparentNodeName === "imperativo") || (grandparentNodeName === "imperativonegativo"))
            {
                if (settings.imperativo)
                {
                    result.push(counter);
                }
            }
           
            counter++;
            formaNode = iteratorFormaNode.iterateNext();
        }

        return result;
    }

    /*
    * Calculates the number of important verbs to be used to generate the random    * number
    */
    function calculateNumberOfImportantVerbs()
    {
        var xPathStringImportant = "count(/verbos/verbo[@importancia='1'])";
 
        var nsResolver = xmlDoc.createNSResolver( xmlDoc.ownerDocument == null ? xmlDoc.documentElement : xmlDoc.ownerDocument.documentElement);

        var importantVerbCount = xmlDoc.evaluate(xPathStringImportant, xmlDoc, nsResolver, XPathResult.ANY_TYPE, null);

        numberOfImportantVerbs = importantVerbCount.numberValue;
    }

    /*
    * Calculates the number of irregular verbs to be used to generate the random    * number
    */
    function calculateNumberOfIrregularVerbs()
    {
        //var xPathStringIrregular = "count(/verbos/verbo[@regular='iregular'])";
 
//        var nsResolver = xmlDoc.createNSResolver( xmlDoc.ownerDocument == null ? xmlDoc.documentElement : xmlDoc.ownerDocument.documentElement);

  //      var irregularVerbCount = xmlDoc.evaluate(xPathStringIrregular, xmlDoc, nsResolver, XPathResult.ANY_TYPE, null);

        numberOfIregularVerbs = 7;
    }


});
