const DB_NAME = "VestibularMetodista";
const DB_VERSION = 1;

var db = null;
var request = indexedDB.open(DB_NAME, DB_VERSION);
var cont = 0;

request.onerror = function(evt) {
  alert("Database error: " + evt + " -- " + evt.message + " -- " + evt.target.errorCode);
  alert("A aplicação não tem permissão para montar as materias!");
};

request.onsuccess = function(evt) {
  db = this.result;
  obterPontuacaoTotal();
};

request.onupgradeneeded = function(evt) {
  db = evt.target.result;

  var materiaStore = db.createObjectStore("materia", { keyPath: "id", autoIncrement: true });  
  carregarMaterias(materiaStore);
}

function carregarMaterias(materiaStore) {
  carregarPerguntasPortugues(materiaStore);
  carregarPerguntasHistoria(materiaStore);
  carregarPerguntasGeografia(materiaStore);
  carregarPerguntasBiologia(materiaStore);
  carregarPerguntasQuimica(materiaStore);
  carregarPerguntasMatematica(materiaStore);
  carregarPerguntasFisica(materiaStore);
  carregarPerguntasAtualidades(materiaStore);
}

function criarItem(item, id) {
  $("#materias").append('<li data-role="itensMaterias"><a href="#" onclick="clicou(' + id + ');">'+item+'</a></li>');
  $("#materias").listview('refresh');
}

function clicou(id) {
  document.forms[0].action = 'perguntas.html?materia_id=' + id;
  document.forms[0].submit();
}

function getMateriaStore() {
  return db.transaction(["materia"], "readwrite").objectStore("materia");
}

function obterPontuacaoTotal() {
  var total = 0;
  var materiaStore = getMateriaStore();

  materiaStore.openCursor().onsuccess = function (event) {
    var cursor = event.target.result;
    if (cursor) {
      total = total + cursor.value.pontuacao;
      cursor.continue();
    } else {

      var pontuacao = document.getElementById("pontuacao");
      pontuacao.innerHTML = "Pontuação: " + total;
    }
  };
}

function Materia(nome, perguntas) {
  this.nome = nome;
  this.perguntas = perguntas;
  this.pontuacao = 0;
}

function Pergunta(numero, titulo, descricao, respondido, acertou, imagem, alternativas) {
  this.numero = numero;
  this.titulo = titulo;
  this.descricao = descricao;
  this.respondido = respondido;
  this.acertou = acertou;
  this.imagem = imagem;
  this.alternativas = alternativas;
}

function Alternativa(numero, descricao, correta, selecionado) {
  this.numero = numero;
  this.descricao = descricao;
  this.correta = correta;
  this.selecionado = selecionado;
}

function carregarPerguntasPortugues(materiaStore) {
  var cont = 0;  
  var perguntas = new Array();
  var alternativas;

/*

  alternativas = [
    new Alternativa(1, ),
    new Alternativa(2, ),
    new Alternativa(3, ),
    new Alternativa(4, ),
    new Alternativa(5, )
  ];
  perguntas[cont] = new Pergunta(cont + 1, alternativas);
  cont++;

*/

  alternativas = [
    new Alternativa(1, "a leoa não compreende a frase do coelho.", 0, 0),
    new Alternativa(2, "ser comum, no mundo selvagem, as fêmeas agredirem os machos.", 0, 0),
    new Alternativa(3, "a ambiguidade na comunicação sempre finalizar em agressão.", 0, 0),
    new Alternativa(4, "a coroa ser indicativo de poder, seja entre animais, seja no mundo civilizado.", 0, 0),
    new Alternativa(5, "o leão compreende a palavra coroa em sentido figurado.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "<i>(<b>Folha de S.Paulo</b>, jul/2011)</i></p><p>Considerando a mensagem da tirinha de Níquel Náusea, é correto afirmar que o humor resulta de", 0, 0, "img/perguntas/img0001.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "O pronome está empregado indevidamente, pois o correto seria as quais.", 0, 0),
    new Alternativa(2, "A estrutura da frase está correta, mas os antecedentes do pronome estão distantes.", 0, 0),
    new Alternativa(3, "O pronome tem vários antecedentes e o verbo está no singular.", 0, 0),
    new Alternativa(4, "O pronome refere-se apenas à palavra nicotina.", 1, 0),
    new Alternativa(5, "Há uma ambiguidade na relação: pronome e antecedentes.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Considerando a advertência dos maços de cigarro, assinale a alternativa que apresenta a explicação <b>correta</b> a respeito do pronome relativo <b>que</b>.", 0, 0, "img/perguntas/img0002.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Quincas Borba.", 0, 0),
    new Alternativa(2, "Macunaíma.", 0, 0),
    new Alternativa(3, "Memórias póstumas de Brás Cubas.", 0, 0),
    new Alternativa(4, "Ubirajara.", 0, 0),
    new Alternativa(5, "Memórias de um sargento de milícias.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Romance que apresenta como protagonista um tipo de malandro simpático e brincalhão, nasce do resultado de uma <b>pisadela e um beliscão</b>; segundo Mário de Andrade, aproxima-se da figura do pícaro espanhol, uma personagem que vive à margem da sociedade e está sempre à procura de novas aventuras. Pertence a uma obra considerada precursora do Realismo. Essa obra é", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "polissíndeto.", 1, 0),
    new Alternativa(2, "pleonasmo.", 0, 0),
    new Alternativa(3, "anacoluto.", 0, 0),
    new Alternativa(4, "assíndeto.", 0, 0),
    new Alternativa(5, "anástrofe.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "O VERBO NO INFINITO<br/>Ser criado, gerar-se, transformar<br/>O amor em carne e a carne em amor; nascer Respirar, e chorar, e adormecer<br/>E se nutrir para poder chorar<br/>Para poder nutrir-se; e despertar Um dia à luz e ver, ao mundo e ouvir E começar a amar e então sorrir<br/>E então sorrir para poder chorar.<br/>E crescer, e saber, e ser, e haver E perder, e sofrer, e ter horror<br/>De ser e amar, e se sentir maldito<br/>E esquecer tudo ao vir um novo amor E viver esse amor até morrer<br/>E ir conjugar o verbo no infinito...<br/><i>(Vinícius de Moraes)</i><br/>Há, no processo de construção do poema, o uso de", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Rodrigo Cambará, de Um certo capitão Rodrigo.", 0, 0),
    new Alternativa(2, "Fabiano, de Vidas secas.", 1, 0),
    new Alternativa(3, "Pedro Bala, de Capitães da areia.", 0, 0),
    new Alternativa(4, "Bento Santiago, de Dom Casmurro.", 0, 0),
    new Alternativa(5, "Riobaldo, de Grande sertão: veredas.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Conteve-se, notou que os meninos estavam perto, com certeza iam admirar-se ouvindo-o falar só. E, pensando bem, ele não era homem: era apenas um cabra ocupado em guardar coisas dos outros. Vermelho, queimado, tinha os olhos azuis, a barba e os cabelos ruivos; mas como vivia em terra alheia, cuidava de animais alheios, descobria-se, encolhia-se na presença dos brancos e julgava-se cabra.<br/>A descrição da personagem do fragmento refere-se a", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Sujeito simples; verbo transitivo indireto, objetos indiretos.", 1, 0),
    new Alternativa(2, "Sujeito simples; verbo transitivo direto, objetos indiretos.", 0, 0),
    new Alternativa(3, "Sujeito composto; verbo transitivo indireto, objetos indiretos.", 0, 0),
    new Alternativa(4, "Sujeito simples; verbo transitivo direto, complementos nominais.", 0, 0),
    new Alternativa(5, "Sujeito inexistente; verbo transitivo indireto, objetos indiretos.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "<i>(<b>Revista Isto é</b>, set/2011)</i></p><p>Na peça publicitária, assinale a alternativa que apresenta a classificação sintática correta do primeiro período presente.", 0, 0, "img/perguntas/img0003.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "trovadoresca portuguesa, pois trata-se de uma cantiga de amor.", 1, 0),
    new Alternativa(2, "romântica em virtude do sofrimento amoroso, causado pela separação.", 0, 0),
    new Alternativa(3, "realista, pois apesar da linguagem formal, o desejo sexual está explícito.", 0, 0),
    new Alternativa(4, "simbolista, com traços fortes de dor e sofrimento.", 0, 0),
    new Alternativa(5, "moderna, com a retomada de temas da poesia medieval.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "ESTES MEUS OLHOS NUNCA PERDERAN<br/>Estes meus olhos nunca perderán, senhor, gran coita, mentr’eu vivo for.<br/>E direi-vos, fremosa mia senhor,<br/>destes meus olhos a coita que han: choran e cegan quand’alguén non veen, e ora cegan per alguén que veen.<br/>Guisado tẽen de nunca perder<br/>meus olhos coita e meu coraçón.<br/>E estas coitas, senhor, minhas son; mais-los meus olhos, per alguén veer, choran e cegan quand’alguén non veen, e ora cegan per alguén que veen.<br/>E nunca ja poderei haver ben,<br/>pois que Amor ja non quer, nen quer Deus. Mais os cativos destes olhos meus morrerán sempre por veer alguén:<br/>choran e cegan quand’alguén non veen,<br/>e ora cegan per alguén que veen.</p><p>(João Garcia de Guilhade)</p><p>O texto apresenta características da poesia", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "literatura produzida em Portugal durante o período das grandes conquistas.", 0, 0),
    new Alternativa(2, "Romantismo brasileiro em sua primeira fase, marcado por influências francesas.", 0, 0),
    new Alternativa(3, "literatura produzida no Brasil, durante o período chamado Quinhentismo.", 1, 0),
    new Alternativa(4, "Barroco brasileiro que apresentou diversos traços religiosos.", 0, 0),
    new Alternativa(5, "Arcadismo, estética literária do século XVIII.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Duas linhas de produção se destacam nesse momento histórico: a literatura de viagem e literatura de catequese. São escritos de conquistadores e missionários.</p><p>O trecho apresenta informações sobre a/o", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "o vale subterrâneo está localizado a quatro quilômetros e meio de Hanói.", 0, 0),
    new Alternativa(2, "durante os bombardeios dos norte-americanos a caverna serviu de refúgio.", 1, 0),
    new Alternativa(3, "há apenas uma grande caverna no Parque Nacional Phong Nha-Ke Bang.", 0, 0),
    new Alternativa(4, "a Associação Britânica de Pesquisas em Cavernas explora a caverna Phong Nha-Ke Bang.", 0, 0),
    new Alternativa(5, "a caverna de Hang Son Doong é considerada a maior do mundo porque suas estalagmites chegam a 70 metros.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "<i>(<b>Revista Planeta</b>, set/2011)</i></p><p>Sobre o texto, é correto afirmar que", 0, 0, "img/perguntas/img0004.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "uma crítica à situação vivida pelos pobres em moradias rudimentares, construídas em locais inadequados.", 1, 0),
    new Alternativa(2, "certo preconceito com os pobres que vivem em becos e em locais perigosos.", 0, 0),
    new Alternativa(3, "que, mesmo com a divulgação de alerta sobre os perigos, os pobres, teimosamente, moram em barrancos.", 0, 0),
    new Alternativa(4, "valores do mundo capitalista no desejo dos pobres de sair do universo de miséria.", 0, 0),
    new Alternativa(5, "uma análise ingênua da realidade vivida pelos pobres nos barrancos, onde constroem suas moradias.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "(<i>Vielas, Palavras.</i> Org. Nadia Costa e Ana Luiza Caetano. SBC: Ed. Lamparina Luminosa, 2011)</p><p>No texto, pode-se perceber", 0, 0, "img/perguntas/img0005.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "mais da metade dos lares brasileiros mudou.", 1, 0),
    new Alternativa(2, "o núcleo tradicional está preservado em todas as famílias brasileiras.", 0, 0),
    new Alternativa(3, "poucos ousam romper com o antigo modelo de família.", 0, 0),
    new Alternativa(4, "mais da metade dos lares são formados por pai, mãe e filhos.", 0, 0),
    new Alternativa(5, "não tem nada mais a contar, quem ousou romper com o núcleo tradicional.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "<i>(<b>Revista Planeta</b>, set/2011)</i></p><p>Sobre o texto, é correto afirmar que", 0, 0, "img/perguntas/img0006.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "“Vejam como são as coisas. Vasco da Gama, navegador preeminente de D. Manoel, tinha um primo, o tal Luis de Camões.”", 0, 0),
    new Alternativa(2, "“Camões cantou, em uma obra humanista, a conquista das Índias por seu primo de linhagem materna, Vasco.”", 0, 0),
    new Alternativa(3, "“Em um desenho de Camões não podem faltar o mar, os louros e o rei.”", 1, 0),
    new Alternativa(4, "“É aí que começa sua história. Além da cultura acumulada nos anos de Coimbra, que disputa com Lisboa o berço do poeta, Camões agora ganharia o mar.”", 0, 0),
    new Alternativa(5, "“Uma espécie de Vinícius de Moraes da época. Até que se enamorou da irmã do rei. Resultado: foi degredado para Constância.”", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "<i>(<b>Revista Língua Portuguesa</b>, nov/2008)</i></p><p>Ao analisar o texto e a imagem, pode-se observar que o trecho que mais diretamente relaciona o verbal e o não verbal é", 0, 0, "img/perguntas/img0007.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "igurativa, criando frases sem sentido e incoerentes.", 0, 0),
    new Alternativa(2, "conotativa, marcada pelo jogo semântico com termos sintáticos.", 1, 0),
    new Alternativa(3, "informativa, sobre os termos de uma oração.", 0, 0),
    new Alternativa(4, "denotativa, explica as questões relativas ao sujeito e predicado.", 0, 0),
    new Alternativa(5, "persuasiva, pois tenta convencer uma provável leitora.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "<b>Pausa Poética</b><br/>Sujeito sem predicados Objeto<br/>Sem voz<br/>Passivo<br/>Já meio pretérito<br/>Vendedor de artigos indefinidos<br/>Procura por subordinada<br/>Que possua<br/>Alguns adjetivos<br/>Nem precisam ser superlativos<br/>Desde que não venha precedida<br/>De relativos e transitivos<br/>para um encontro vocálico<br/>Com vista a uma conjugação mais que perfeita E possível caso genitivo.</p><p><i>(Paulo César Souza)</i></p><p>O texto apresenta uma linguagem", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "segue os padrões da norma culta da Língua Portuguesa.", 1, 0),
    new Alternativa(2, "fere as regras básicas para o uso do pronome junto ao verbo, pois ele está depois do verbo.", 0, 0),
    new Alternativa(3, "o uso da mesóclise está adequado, mas há problemas de concordância verbal.", 0, 0),
    new Alternativa(4, "difere das expressões cultas e adequadas ao se usar o pronome oblíquo.", 0, 0),
    new Alternativa(5, "revela descuido em relação ao uso de pronomes pessoais.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "<i><b>Acredita-se</b> que a maratona surgiu em 490 a.C., quando o guerreiro ateniense Fidípides correu 42 quilômetros, da baía de Maratona até Atenas, para anunciar a vitória grega sobre os invasores persas – <b>convertendo-se</b> imediatamente em herói. Diz a lenda que ao concluir o percurso Fidípides teria morrido. Suas últimas palavras teriam sido: “<b>Rejubilem-se!</b> Vencemos!</i></p><p>Sobre a colocação pronominal assinalada no trecho, pode-se dizer que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "metáfora, pois toma a imagem da lama pelas águas de março.", 0, 0),
    new Alternativa(2, "incoerência, porque a música de Tom Jobim não menciona lama.", 0, 0),
    new Alternativa(3, "intertextualidade, por buscar a letra da música de Tom Jobim para compor o seu texto.", 1, 0),
    new Alternativa(4, "ausência de sensibilidade, pois há uma aproximação do texto do outro.", 0, 0),
    new Alternativa(5, "ironia, porque a luta do homem contra a natureza não é poética.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "O fragmento do texto, de Ruy Castro, publicado da Folha de S. Paulo em 15/01/2011 sobre a catástrofe que se abateu sobre as cidades da região serrana do Rio de Janeiro, apresenta", 0, 0, "img/perguntas/img0014.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "poética.", 0, 0),
    new Alternativa(2, "metalinguística.", 1, 0),
    new Alternativa(3, "emotiva.", 0, 0),
    new Alternativa(4, "fática.", 0, 0),
    new Alternativa(5, "referencial.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Considerando a fala do cão e a construção da tirinha, é correto afirmar que a função da linguagem é", 0, 0, "img/perguntas/img0015.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "No futuro, não haverá transplante de órgãos devido ao grande número de pessoas que necessitam e ao pequeno número de doadores.", 0, 0),
    new Alternativa(2, "Os laboratórios médicos encontraram uma forma de regeneração de órgãos a partir de células dos próprios pacientes.", 1, 0),
    new Alternativa(3, "Atualmente, os transplantes de coração, rim e bexiga foram substituídos pelos órgãos bioartificiais.", 0, 0),
    new Alternativa(4, "Os órgãos bioartificiais ainda não foram testados em humanos e por isso, hoje, só existe o transplante de órgãos.", 0, 0),
    new Alternativa(5, "A facilidade em encontrar doadores compatíveis inviabiliza a nova técnica com órgãos bio artificiais.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Leia o texto publicado na Revista <b>National geographic</b>, de março de 2011, e marque a alternativa correta.</p><p><b>Milagre da vida</b></p><p><b>No futuro, quando precisar de um novo órgão, uma pessoa poderá obter outro, cultivado no laboratório das próprias células</b></p><p>Milhões de pessoas estão na fila por transplante de órgãos no mundo; todos os dias, centenas morrem nessa espera. Não só há escassez de órgãos saudáveis, mas também é preciso haver grande compatibilidade entre doador e paciente para que o sistema imune deste último não rejeite o órgão transplantado. Agora, um novo tipo de solução está sendo aperfeiçoado nos laboratórios médicos: órgãos bioartificiais, cultivados nas células dos próprios pacientes. Trinta pessoas já receberam bexiga produzida com essa técnica, e logo será possível usar outros órgãos desse tipo.</p><p>A técnica de produção da bexiga foi desenvolvida por Anthony Atala, do Instituto Wake Forest de Medicina Regenerativa. Os cientistas retiram células saudáveis da bexiga enferma do paciente, fazem com que se multipliquem em placas de cultura e depois as transferem para uma matriz com formato de bola e feita em parte de colágeno, a proteína encontrada na cartilagem. As células musculares ficam na porção externa e, na interna, estão as uroteliais (que recobrem o trato urinário).", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Romantismo.", 0, 0),
    new Alternativa(2, "Realismo.", 1, 0),
    new Alternativa(3, "Arcadismo.", 0, 0),
    new Alternativa(4, "Barroco.", 0, 0),
    new Alternativa(5, "Modernismo.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Leia o texto e marque a alternativa correta que indica a definição de uma escola literária.</p><p><i>O escritor quer o espírito livre de jugos, o pensamento livre de preconceitos e respeitos inúteis, o coração livre de vaidades, incorruptível e intemerato. Só assim serão grandes e fecundas as suas obras: só assim merecerá o lugar de censor entre os homens, porque o terá alcançado, não pelo favor das turbas inconstantes e injustas, ou pelo patronato degradante dos grandes e ilustres, mas elevando- se naturalmente sobre todos pela ciência, pelo paciente estudo de si mesmo e dos outros</i> [...]", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "o desejo de criar um semelhante aos humanos está presente na cultura de diversos povos, a partir do século XX.", 0, 0),
    new Alternativa(2, "os robôs povoam o imaginário humano há séculos, aparecendo inclusive em obras literárias.", 1, 0),
    new Alternativa(3, "o espelho foi criado para permitir que o homem se visse e criasse um robô.", 0, 0),
    new Alternativa(4, "os robôs são criações científicas e por isso o tema não apresenta nenhuma relação com a literatura.", 0, 0),
    new Alternativa(5, "como o homem não pode criar um robô, inventou as histórias literárias sobre os mesmos.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "NÓS, OS OUTROS (fragmento)</p><p><i>O espelho é o primeiro robô da história. Bem antes de Freud e do Facebook, quando se pegou mirando na lâmina de um lago, a ideia de um outro eu, o narcisopiteco mal caraminholava direito – mas já caraminholaria como seria lindo ter outro dele para fazer o serviço sujo de matar um javali sem ser comido por tigres, um outro para guardar a comida, um outro para resgatar a mulher caso ela desse pitaco aos pitecos vizinhos. Se o sonho, como sugere Jorge Luis Borges, é “a primeira ficção do homem”, o espelho é a lâmina que divide o ser natural do ser cultural, o ser incriado do ser inventado. No ato de forjar uma representação de si mesmo, o homem lhe empresta a ambição de anjo ou de demônio que funcione a seu bel prazer. Só que nem sempre essa representação fica sob controle. E quando o ser inventado dá tilt, o ser incriado dá pau. Se o homem é apaixonado pelo apocalipse, a ideia de que um ser inventado por ele venha a destruí-lo faz com que, de tempos em tempos, apareça uma nova narrativa para a velha história do medroso Cronos devorando seus filhos.</i></p><p><i>Esse outro que contém o poder do um, feito à imagem e semelhança, ensinando o homem a brincar de deus, manifestou-se em diversas formas. Das pinturas rupestres aos Moai da Ilha de Páscoa, as representações ficcionais do humano eram usadas para sua proteção. Na chave do mito, dizem as lendas que uma civilização na Ilha de Creta tinha um gigante de bronze chamado Talos, que patrulhava o litoral para evitar a aproximação do inimigo. Na Odisseia, de Homero, Ulisses, ou Odisseu, luta contra Talos, descobrindo seu ponto fraco: um tampão na perna por onde escorria o óleo que fazia o gigante se mover. Já no livro 18 da Ilíada, ficamos sabendo que Hefesto, o deus grego das forjas, o Vulcano dos romanos, tinha como ajudantes “duas donzelas feitas de ouro que são exatamente como moças vivas; podem pensar, falar e usar os músculos; podem fiar e tecer...”</i></p><p><i>Mas o primeiro robô consistente remonta ao século 17. «Segundo perdidas fórmulas da cabala, um rabino construiu do barro um homem artificial – o Golem – para que este tangesse os sinos da sinagoga e fizesse os trabalhos pesados», conta o austríaco Gustav Meyrink no romance O Golem, de 1915. «Não era um homem como os outros; mal o animava uma vida apagada e vegetativa. Esta durava até a noite e devia seu poder ao influxo de uma inscrição mágica que colocavam atrás de seus dentes e que atraía as livres forças siderais do universo. Uma tarde, antes da oração da noite, o rabino se esqueceu de retirar o selo da boca do Golem e este caiu em frenesi, correu pelas ruelas escuras e destroçou aqueles que se puseram à sua frente. O rabino, por fim, o deteve e quebrou o selo que o animava. A criatura caiu sem vida. Só restou a raquítica figura de barro que ainda hoje está à mostra na sinagoga de Praga.” A palavra escrita na testa do Golem era «emet», que significa «verdade» em hebraico; sem a partícula «e», sobra «met», «morto».</i></p><p>De acordo com o texto, pode-se afirmar que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Tom Jobim não apreciava o trabalho de Elis Regina, mas devido à popularidade da cantora entregou-lhe várias músicas.", 0, 0),
    new Alternativa(2, "ao corrigir seu erro de avaliação, Tom Jobim fez de Elis Regina uma cantora famosa o que resultou na gravação de “Elis & Tom” em 1974.", 0, 0),
    new Alternativa(3, "o nome de Elis Regina nunca foi oficialmente registrado na história da Bossa Nova por culpa de Tom Jobim.", 0, 0),
    new Alternativa(4, "o erro de avaliação de Tom Jobim causou danos irreparáveis à imagem de Elis Regina até sua morte.", 0, 0),
    new Alternativa(5, "o julgamento equivocado de Tom Jobim ficou redimido a partir da gravação de “Elis & Tom” em 1974.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Sobre o fragmento do texto de Oswaldo Mendes, é correto afirmar que", 0, 0, "img/perguntas/img0016.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "I - Romantismo / II - Barroco / III - Parnasianismo / IV - Simbolismo.", 1, 0),
    new Alternativa(2, "I - Parnasianismo / II - Romantismo / III - Barroco / IV - Simbolismo.", 0, 0),
    new Alternativa(3, "I - Romantismo / II - Barroco /III - Simbolismo / IV - Parnasianismo.", 0, 0),
    new Alternativa(4, "I - Parnasianismo / II - Barroco / III - Simbolismo / IV - Romantismo.", 0, 0),
    new Alternativa(5, "I - Romantismo / II - Parnasianismo / III - Barroco / IV - Simbolismo.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Assinale a alternativa correta que indica as estéticas literárias, respectivamente.</p><p>I. Ó Guerreiros da Taba sagrada.<br/>Ó Guerreiros da Tribo Tupi,<br/>Falam Deuses nos cantos do Piaga,<br/>Ó Guerreiros, meus cantos ouvi.</p><p>II. Entre as partes do todo a melhor parte<br/>Foi a parte, em que Deus pôs o amor todo<br/>Se na parte do peito o quis pôr todo,<br/>O peito foi do todo a melhor parte.</p><p>III. Longe do estéril turbilhão da rua,<br/>Beneditino, escreve! No aconchego<br/>Do claustro, na paciência e no sonego,<br/>Trabalha, e teima, e lima, e sofre, e sua!</p><p>IV. Cristais diluídos de clarões álacres<br/>desejos, vibrações, ânsias, alentos,<br/>fulvas vitórias, triunfamentos acres,<br/>os mais estranhos estremecimentos.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "não expressa uma crítica sobre os assaltos, na grande cidade.", 0, 0),
    new Alternativa(2, "a distração dos motoristas é responsável pelas mortes no congestionamento.", 0, 0),
    new Alternativa(3, "o narrador anônimo avalia um aspecto da violência na metrópole.", 1, 0),
    new Alternativa(4, "os assaltantes vivem em condições precárias devido à poluição do ar.", 0, 0),
    new Alternativa(5, "dá ênfase ao cenário urbano e o narrador é indiferente aos fatos.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Sobre o texto 11, de 100 histórias colhidas na rua, de Fernando Bonassi, é correto afirmar que", 0, 0, "img/perguntas/img0017.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "assume o fado de mulher-poeta expondo suas antíteses, parodiando Carlos Drummond de Andrade.", 1, 0),
    new Alternativa(2, "apresenta o destino inevitável das mulheres que desejam o casamento.", 0, 0),
    new Alternativa(3, "coloca a mulher em igualdade aos homens e critica Carlos Drummond de Andrade.", 0, 0),
    new Alternativa(4, "procura delegar poeticamente as tarefas mais pesadas aos homens.", 0, 0),
    new Alternativa(5, "afirma que sua sina é escrever e recusa-se ao trabalho pesado.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Sobre o poema de Adélia Prado, é correto afirmar que a autora", 0, 0, "img/perguntas/img0018.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "versos metrificados, rimas raras e subjetividade.", 0, 0),
    new Alternativa(2, "misticismo, subjetividade e poesia plástica.", 0, 0),
    new Alternativa(3, "descritividade, postura reflexiva e preocupação social.", 1, 0),
    new Alternativa(4, "ironia, realismo geográfico e sentimentalismo.", 0, 0),
    new Alternativa(5, "alegorização, sentimentalismo e subjetividade.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "O RIO (fragmento)</p><p><i>Da lagoa da Estaca a Apolinário</i></p><p>Sempre pensara em<br/>ir caminho do mar.<br/>Para os bichos e rios<br/>nascer já é caminhar.<br/>Eu não sei o que os rios<br/>têm de homem do mar;<br/>sei que se sente o mesmo<br/>e exigente chamar.<br/>Eu já nasci descendo<br/>a serra que se diz do Jacarará,<br/>entre caraibeiras<br/>de que só sei por ouvir contar<br/>(pois, também como gente,<br/>não consigo me lembrar dessas<br/>primeiras léguas<br/>de meu caminhar).<br/>Deste tudo que me lembro,<br/>lembro-me bem de que baixava<br/>entre terras de sede<br/>que das margens me vigiavam.<br/>Rio menino, eu temia<br/>aquela grande sede de palha,<br/>grande sede sem fundo<br/>que águas meninas cobiçava.<br/>Por isso é que ao descer<br/>caminho de pedras eu buscava,<br/>que não leito de areia<br/>com suas bocas multiplicadas.<br/>Leito de pedra abaixo<br/>rio menino eu saltava.<br/>Saltei até encontrar<br/>as terras fêmeas da Mata.</p><p>A poesia apresenta aspectos comuns na obra de João Cabral de Melo Neto, como", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "resulta de uma sensibilidade e de um pensamento profundamente envolvido com o processo que o gerou, isto é, a cultura deste país, de acordo com a prosa regionalista de 1930.", 0, 0),
    new Alternativa(2, "é indecifrável, trata-se, na verdade, de um enigma que se renova a cada leitura, prejudicando a compreensão.", 0, 0),
    new Alternativa(3, "é uma vertente do universal, situada no sertão, por isso tanta confusão.", 0, 0),
    new Alternativa(4, "coloca-se em primeiro plano a questão do ambíguo, das diversas possibilidades de sentido que continuam a brotar do chão roseano", 1, 0),
    new Alternativa(5, "apresenta muitas dificuldades de compreensão, por se tratar apenas de uma modalidade linguística arcaica.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "<b>O desafio de Guimarães Rosa</b></p><p></p><p>Há 50 anos Guimarães Rosa (1908-1967) publicava de uma vez dois monumentos da literatura brasileira: o romance <b>Grande Sertão: Veredas</b> e a coleção de novelas e romances chamada <b>Corpo de Baile.</b> Meio século, e no entanto ainda há pessoas, inclusive intelectuais, que dizem não entender o que ele escreveu. Ótimo sinal. Não se pode desqualificar isso como obtusidade. O motivo parece muito outro, ou seja: a linguagem de Rosa permanece como desafio, como fator de deslocamento da situação cômoda do leitor condicionado por clichês. O texto que de algum modo não provoca uma reação desse tipo ou já faz parte da história ou nem chegará a fazer parte dela.</p><p>￼Sobre a linguagem utilizada por Guimarães Rosa, pode-se afirmar que", 0, 0, "img/perguntas/img0029.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Rubem Fonseca; Agosto.", 0, 0),
    new Alternativa(2, "Machado Assis; Memórias Póstumas de Brás Cubas.", 1, 0),
    new Alternativa(3, "Aluísio Azevedo; O mulato.", 0, 0),
    new Alternativa(4, "José de Alencar; Senhora.", 0, 0),
    new Alternativa(5, "Raul Pompéia; O Ateneu.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Considerado o maior escritor em prosa da literatura brasileira______________________ é um autor múltiplo, inventivo, original. Além de iniciar o Realismo brasileiro, em 1881, com _________________________________, na mesma obra realiza a superação desse estilo, dando um salto para a modernidade literária, que antecipa em vários aspectos.</p><p><i>Emília Amaral</i></p><p>A alternativa que completa, corretamente, as lacunas é", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "intertextualidade.", 1, 0),
    new Alternativa(2, "metáforas.", 0, 0),
    new Alternativa(3, "falta de métrica.", 0, 0),
    new Alternativa(4, "poema ligado ao Modernismo.", 0, 0),
    new Alternativa(5, "falta de originalidade.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "ANTOLOGIA</p><p>A vida<br>Com cada coisa em seu lugar.<br>Não vale a pena a dor de ser vivida.<br>Os corpos se entendem mas as almas não.<br>A única coisa a fazer é tocar um tango argentino.<br><br>Vou-me embora pra Pasárgada! Aqui eu não sou feliz.<br>Quero esquecer tudo:<br>- A dor de ser homem...<br>este anseio infinito e vão<br> De possuir o que me possui.<br><br>Quero descansar<br>Humildemente pensando na vida e nas mulheres que amei...<br> Na vida inteira que podia ter sido e não foi.<br><br>Quero descansar.<br>Morrer.<br>Morrer de corpo e alma.<br>Completamente<br>(Todas as manhãs o aeroporto em frente me dá lições de partir.)<br><br>Quando a indesejada das gentes chegar<br> Encontrará lavrado o campo, a casa limpa.<br> A mesa posta,<br>Com cada coisa em seu lugar.<br><br></p><p>Assinale a alternativa que explica o título do poema de Manuel Bandeira.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Há uma incorreção grave, pois a palavra milhão é masculina e não admite o emprego do sinal de crase.", 0, 0),
    new Alternativa(2, "A preposição a sempre recebe o sinal de crase, independente do termo a que se refere.", 0, 0),
    new Alternativa(3, "Não há incorreção, pois está concordando com um termo oculto, evitando a repetição.", 1, 0),
    new Alternativa(4, "O texto refere-se às vozes das mulheres que sempre são discriminadas, nesse caso o emprego da crase é correto.", 0, 0),
    new Alternativa(5, "O erro do emprego do sinal de crase revela o desconhecimento das regras da norma padrão.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Assinale a alternativa que explica, corretamente, o emprego do sinal de crase na expressão <b>à de um milhão.</b>", 0, 0, "img/perguntas/img0030.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "despertou.", 0, 0),
    new Alternativa(2, "xingo ou praga.", 0, 0),
    new Alternativa(3, "a algazarra não deixou.", 0, 0),
    new Alternativa(4, "saber ao certo.", 0, 0),
    new Alternativa(5, "tinha o sono sereno.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Agenor Soronho tinha o sono sereno, a roda esquerda lhe colhera mesmo o pescoço, e a algazarra não deixou que se ouvisse xingo ou praga assim não se pôde saber ao certo se o carreiro despertou ou não, antes de desencarnar.</p><p><i>Guimarães Rosa</i></p><p>No trecho há um <b>eufemismo</b>. A alternativa que apresenta essa figura de linguagem é", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "há um erro, pois o criador da mensagem usou inadequadamente a palavra cartão, confundindo o consumidor.", 0, 0),
    new Alternativa(2, "existe certa ambiguidade na construção, ao permitir uma duplicidade na interpretação do sentido da palavra cartão.", 0, 0),
    new Alternativa(3, "estabelece um jogo antitético entre o presente e cartão, mostrando que não há preocupação com o consumidor.", 0, 0),
    new Alternativa(4, "cria uma confusão na mente do leitor, quando se refere paradoxalmente ao cartão.", 0, 0),
    new Alternativa(5, "ironiza o consumidor que só dá um cartão de presente no dia das mães, por não ter como ￼pagar o presente.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Sobre a frase abaixo, pode-se afirmar que", 0, 0, "img/perguntas/img0031.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "o autor exclui a pontuação quase que totalmente, mas esse procedimento não revela nada além da dificuldade enfrentada pelo leitor.", 0, 0),
    new Alternativa(2, "há uma glamorização do crime ao se defenderem os 111 mortos na chacina.", 0, 0),
    new Alternativa(3, "as mortes são inevitáveis nos conflitos entre policiais e presidiários amotinados.", 0, 0),
    new Alternativa(4, "a última frase mostra a perplexidade dos animais diante da barbárie humana.", 1, 0),
    new Alternativa(5, "não há uma visão imparcial da chacina do Carandiru, o autor condenou a ação dos policiais armados.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Haja o que houver a que tempo for será a noite mais preta de todas as noites negras em que os deuses das chances dormem pesadamente e sobrevoam corvos insanos dos piores Demônios do Brasil terra de contrastes e chacinas convocando a face carcomida da morte violenta destes à mostra quando homens da lei entram para o que der e vier deixando cem gramas de almas no esgoto da covardia contra homens desprezíveis cujas nucas explodem feito ovos e braços inúteis pedem clemência sob camas já tampas de sarcófago. Só mesmo cães assustados salvam-se, mascando genitálias.</p><p><i>Fernando Bonassi</i></p><p>Sobre o texto, é correto afirmar que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "há uma visão realística da atualidade sem a intervenção subjetiva do autor.", 0, 0),
    new Alternativa(2, "há uma prosa inovadora, intertextualidade, com um realismo brutal urbano, de denúncia.", 1, 0),
    new Alternativa(3, "o texto não pode ser considerado literário, pois está mais próximo da matéria jornalística.", 0, 0),
    new Alternativa(4, "há apenas a denúncia da marginalidade urbana.", 0, 0),
    new Alternativa(5, "a ironia empregada pelo autor desfaz a carga literária do texto.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Cena 9<br>CANÇÃO DO EXÍLIO</p><p>Minha terra tem campos de futebol onde cadáveres amanhecem emborcados pra atrapalhar os jogos. Tem uma pedrinha cor-de-bile que faz “tuim” na cabeça da gente. Tem também muros de bloco (sem pintura, é claro, que tinta é a maior frescura quando falta mistura), onde pousam cacos de vidro pra espantar malaco. Minha terra tem HK, AR 15, M 21, 45 e 38 (na minha terra, 32 é uma piada). As sirenes que aqui apitam, apitam de repente e sem hora marcada. Elas não são mais as das fábricas, que fecharam. São mesmo é dos camburoes, que vem fazer aleijados, trazer tranquilidade e aflição.</p><p><i>Fernando Bonassi</i></p><p>Sobre essa produção literária contemporânea, é correto afirmar que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Deus a que o trecho faz referência é o protetor dos sertanejos, não há outras conotações possíveis.", 0, 0),
    new Alternativa(2, "O castigo divino é algo que deve ser enfrentado pelo homem que se arrepende de seus atos.", 0, 0),
    new Alternativa(3, "Deus avalia os atos, bons ou ruins, mas não desampara aquele que muda de atitude.", 1, 0),
    new Alternativa(4, "Se o homem se arrepender de seus atos, Deus lhe dará amparo com esporas e rédeas.", 0, 0),
    new Alternativa(5, "Deus observa o homem a todo instante e sua punição será inevitável.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Então eles trouxeram, uma noite, muito à escondida, o padre, que o confessou e conversou com ele, muito tempo, dando-lhe conselhos que o faziam chorar.<br>- Mas será que Deus vai ter pena de mim, com tanta ruindade que fiz, e tendo nas costas tanto pecado mortal?!<br>- Tem, meu filho. <b>Deus mede a espora pela rédea, e não tira o estribo do pé de arrependido nenhum...</b><br>E por aí foi, com um sermão comprido, que acabou depondo o doente num desvencido torpor.</p><p>A frase assinalada tem uma explicação coerente na alternativa:", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "há a reprodução de uma situação muito corriqueira, em virtude do aumento de pet-shop, nas cidades.", 0, 0),
    new Alternativa(2, "o pet-shop atende a pessoas de todas as classes sociais e não apenas aos mais ricos.", 0, 0),
    new Alternativa(3, "há um exibicionismo muito grande da dona do cãozinho, que age de maneira altruísta.", 0, 0),
    new Alternativa(4, "a marcha pelo capitalismo selvagem não tem relação com a classe social mais abastada.", 0, 0),
    new Alternativa(5, "o cartunista tratou com ironia a situação social dos discriminados.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Português)", "Sobre a charge de Angeli, é correto afirmar que", 0, 0, "img/perguntas/img0032.png", alternativas);
  cont++;

  materiaStore.add(new Materia("Português", perguntas));
}

function carregarPerguntasHistoria(materiaStore) {
  var cont = 0;  
  var perguntas = new Array();
  var alternativas;

  alternativas = [
    new Alternativa(1, "Abraão.", 0, 0),
    new Alternativa(2, "Gilbral Tarik.", 0, 0),
    new Alternativa(3, "Maomé.", 1, 0),
    new Alternativa(4, "Iatreb.", 0, 0),
    new Alternativa(5, "Moisés.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "Ele nasceu em Meca, em 570, e era membro da tribo dos coraixitas. Durante anos participou de caravanas comerciais pelos desertos. Entrou em contato com religiões monoteístas como o judaísmo e o cristianismo.<br/>As informações anteriores se referem a", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "I, II, III e IV.", 1, 0),
    new Alternativa(2, "II e III.", 0, 0),
    new Alternativa(3, "II e IV", 0, 0),
    new Alternativa(4, "III e IV", 0, 0),
    new Alternativa(5, "I, II e IV", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "Sobre o movimento das Cruzadas, é correto afirmar que<br/>I. foi decisivo para a reafirmação política e religiosa da Igreja Católica Ocidental.<br/>II. serviu para consolidar o comércio no Mediterrâneo.<br/>III. a Igreja concedia privilégios espirituais por meio do dízimo e das indulgências, para atrair guerreiros.<br/>IV. o indivíduo que se engajava nesse movimento possuía forte sentimento religioso.<br/>Estão corretas", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "I - 2, II - 3, III - 1, IV - 5, V - 4.", 0, 0),
    new Alternativa(2, "I - 3, II - 1, III - 2, IV - 4, V - 5.", 1, 0),
    new Alternativa(3, "I - 4, II - 5, III - 3, IV - 2, V - 1.", 0, 0),
    new Alternativa(4, "I - 5, II - 2, III - 4, IV - 3, V - 1.", 0, 0),
    new Alternativa(5, "I - 2, II - 4, III - 5, IV - 1, V - 3.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "Relacione as frases com seus autores.<br/>I. “Prefiro cheiro de cavalo a cheiro de povo”.<br/>II. “Só morto sairei do Catete”.<br/>III. “O meu primeiro ato como presidente será mandar para a cadeia um bocado de corruptos”.<br/>IV. “Os homens fazem a sua própria história, mas não a fazem como querem...”<br/>V. “O homem é bom por natureza. É a sociedade que o corrompe.”<br/><br/>1. Getúlio Vargas.<br/>2. Fernando Collor de Melo.<br/>3. João Batista de Oliveira Figueiredo.<br/>4. Karl Marx.<br/>5. Jean-Jacques Rousseau.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "O Congresso Nacional elegeu o general Humberto de Alencar Castelo Branco como novo presidente da República, sendo este um dos principais articuladores do golpe militar.", 0, 0),
    new Alternativa(2, "A campanha para recuperação das perdas salariais resultou em grandes greves, com a participação de milhares de trabalhadores e dessas lutas apareceram nomes como o de Luiz Inácio da Silva, o Lula.", 0, 0),
    new Alternativa(3, "Com a derrota das Diretas-Já, as atenções se voltaram para o Colégio Eleitoral, onde seria eleito o futuro presidente tendo como candidatos Paulo Maluf e Tancredo Neves.", 0, 0),
    new Alternativa(4, "A música e o cinema foram muito explorados para difundir uma ideologia que associava o regime militar a valores positivos, como patriotismo e desenvolvimento.", 1, 0),
    new Alternativa(5, "Dutra preferiu promover a abertura do mercado nacional, com o objetivo de combater a alta de preços. Ao contrário do que ocorreu no Estado Novo.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "“O período de maior repressão política do regime militar coincide com o da fase de consolidação de uma cultura de massa e a consequente expansão da indústria fonográfica. Entre 1970 e 1976, a indústria do disco cresceu em faturamento, no Brasil em 1.375%.</p><p>(ARAÚJO, Paulo Cesar de. <i>Eu não sou cachorro,não.</i> Rio de Janeiro: Record, 2002 p.19.)</p><p>Assinale a alternativa que se refere ao período destacado no texto.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Lei Áurea.", 0, 0),
    new Alternativa(2, "Lei da Anistia.", 1, 0),
    new Alternativa(3, "Legislação Trabalhista.", 0, 0),
    new Alternativa(4, "Lei de Terras.", 0, 0),
    new Alternativa(5, "Lei Falcão.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "De no 6.683, ela foi promulgada pelo presidente João Figueiredo em 28 de agosto de 1979. Trata-se da", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Marcatismo.", 0, 0),
    new Alternativa(2, "Plano Marshal.", 1, 0),
    new Alternativa(3, "Doutrina Monroe.", 0, 0),
    new Alternativa(4, "Pacto de Varsóvia.", 0, 0),
    new Alternativa(5, "New Deal.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "Seu objetivo principal era combater a influência comunista na Europa Ocidental. Era um programa de ajuda econômica dos Estados Unidos para a reconstrução dos países europeus destruídos pela guerra. Trata-se do/da", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Simon Bolívar tinha um ideal republicano determinado e libertou o Norte da América do Sul a partir da Venezuela.", 0, 0),
    new Alternativa(2, "os novos Estados latino-americanos conseguiram sua independência política, mas mantiveram sua dependência econômica.", 0, 0),
    new Alternativa(3, "os caudilhos surgiram durante o movimento de independência. Esses caudilhos buscavam garantir sua parcela de poder.", 0, 0),
    new Alternativa(4, "no Haiti o processo de independência foi muito particular, pois uma revolta de escravos liderada por Toussaint-Loverture e Dessalines criou uma República negra.", 1, 0),
    new Alternativa(5, "o processo de independência do Peru foi conduzido por San Martin e Bolívar e o governo foi entregue ao general José Sucre.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "A América espanhola iniciou, no século XIX, seu processo de independência em relação à sua metrópole. Esse processo não surtiu o efeito desejado, pois as mudanças estruturais foram mantidas, ou seja, permaneceram a dependência do mercado externo e a exclusão social da maioria da população. Sobre a independência da América espanhola e daqueles que participaram do processo, <b>NÃO</b> é correto afirmar que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "I, II, III e IV.", 0, 0),
    new Alternativa(2, "II, III e IV.", 0, 0),
    new Alternativa(3, "I, II, III, IV e V.", 1, 0),
    new Alternativa(4, "III, IV e V.", 0, 0),
    new Alternativa(5, "I, III, IV e V.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "Leia o texto e responda:</p><p>“A Revolução Francesa não deve ser considerada apenas como uma revolução burguesa. Embora esta tenha sido a ideologia e a sua forma dominante, ela foi o produto da confluência de quatro movimentos distintos: uma revolução aristocrática (1787-1789), uma revolução burguesa (1789-1799), uma revolução camponesa (1789-1793) e uma revolução do proletariado urbano (1792-1794). Também não se deve supor que a revolução tenha começado em 1789, pois neste ano começa a tomada do poder pela burguesia e não o início do processo revolucionário. Este começou dois anos antes, em 1787, com a revolta da aristocracia contra a monarquia absolutista. Foi este fato que criou as condições e a oportunidade para a burguesia tomar o poder. Por outro lado, sem a revolta dos camponeses, o regime feudal não teria sido destruído por completo e sem a contra-revolução da aristocracia que culminou com o apelo à intervenção estrangeira, não teria se desenvolvido a revolução do proletariado urbano. E, finalmente, sem este último, a burguesia não teria resistido à invasão estrangeira e, portanto, permitido que a revolução chegasse a seu termo lógico e historicamente possível”.</p><p><i>(FLORENZANO, Modesto. As Revoluções Burguesas. São Paulo: Brasiliense, p. 15-16)</i></p><p>Sobre o contexto da Revolução Francesa, podemos afirmar que</p><p>I - a burguesia soube assumir as insatisfações do período e, liderando os diversos grupos sociais foi possível derrubar as estruturas políticas vigentes. </p><p>II - tornava-se imperativo eliminar a política mercantilista para que houvesse o progresso capitalista apregoado pelos fisiocratas e teóricos liberais. </p><p>III - o terceiro estado, sustentava com tributos toda a estrutura administrativa, as forças armadas e os privilégios, especialmente os da luxuosa corte francesa. </p><p>IV - a nobreza, embora uma parte dela defendesse a diminuição do poder real, não admitiria perder tradicionais direitos feudais para resolver a crise econômica nacional. </p><p>V - nas cidades onde os privilégios da aristocracia eram mais gritantes, os trabalhadores urbanos chegaram a invadir e incendiar castelos e a massacrar elementos da nobreza, num período que ficou conhecido como Grande Medo.</p><p>Estão corretas as afirmativas", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "o metalismo, idéia que relacionava a riqueza individual à riqueza do Estado mercantil.", 0, 0),
    new Alternativa(2, "o intervencionismo, concepção que atrelava as atividades econômicas aos interesses do Estado.", 1, 0),
    new Alternativa(3, "o tributarismo, que media o bom desempenho das finanças do Estado através do pagamento de impostos.", 0, 0),
    new Alternativa(4, "o industrialismo, que procurava incentivar a auto-suficiência manufatureira como elemento de afirmação do Estado.", 0, 0),
    new Alternativa(5, "o colonialismo, que relacionava a riqueza do Estado ao desenvolvimento interno das áreas coloniais.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "A política econômica dos países mercantilistas traduziu-se por um conjunto de medidas destinadas a atrair e manter a maior quantidade de metais preciosos em seus territórios. A característica básica dessas medidas era", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "uma vitória da aristocracia diante das conquistas feitas pela burguesia no período revolucionário.", 0, 0),
    new Alternativa(2, "um período de consolidação das conquistas burguesas feitas durante a revolução.", 1, 0),
    new Alternativa(3, "a retomada do princípio da legitimidade defendido pelos reis absolutos.", 0, 0),
    new Alternativa(4, "um período de crise da economia capitalista e de afirmação do autoritarismo político.", 0, 0),
    new Alternativa(5, "uma fase de retrocesso político e de profunda crise econômica.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "Pode-se afirmar que a Revolução Francesa foi um movimento anti-absolutista, inspirado pelas idéias iluministas e resultado da mobilização do terceiro estado contra os privilégios da nobreza e do clero. O governo de Napoleão Bonaparte que se seguiu à Revolução pode ser entendido como", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "o conflito pelo direito de extração da borracha no atual estado do Mato Grosso, durante o Segundo Reinado.", 0, 0),
    new Alternativa(2, "o incidente provocado pela forte presença de imigrantes bolivianos em São Paulo, durante o governo de José Sarney.", 0, 0),
    new Alternativa(3, "a disputa pela região do atual estado do Acre, pertencente à Bolívia até 1903, ocorrida na República Velha.", 1, 0),
    new Alternativa(4, "a má repercussão da ação da Polícia Federal no combate ao tráfico de drogas, ocorrida no governo de Fernando Collor.", 0, 0),
    new Alternativa(5, "a guerra entre os dois países pelo direito de navegação no Rio Madeira, durante o período colonial.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "O atual foco de atrito entre Brasil e Bolívia, provocado pelas medidas tomadas pelo presidente boliviano Evo Morales em relação à exploração do gás, não é o primeiro a exigir a intervenção da diplomacia entre as duas nações. Nesse contexto, pode-se apontar também", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "denunciar a tortura como método utilizado pelos grupos terroristas.", 0, 0),
    new Alternativa(2, "negar a prática da tortura pelos governos militares.", 0, 0),
    new Alternativa(3, "justificar a tortura como método legítimo de combate ao terrorismo.", 1, 0),
    new Alternativa(4, "defender a tortura praticada sem o conhecimento do governo.", 0, 0),
    new Alternativa(5, "fornecer aos militares uma definição neutra de uma prática condenável.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (História)", "“Numa cartilha preparada pelo DOPS paulista em 1973, o verbete \'Torturadores\' tinha a seguinte definição: Expressão utilizada pela subversão para designar todos aqueles que se empenham ou colaboram na prisão de subversivos terroristas”.(GASPARI, Elio. <b>A ditadura escancarada</b>. São Paulo: Companhia das Letras, 2002, p.25)</p><p>A definição feita pelo DOPS visava", 0, 0, "", alternativas);
  cont++;

  materiaStore.add(new Materia("História", perguntas));
}

function carregarPerguntasGeografia(materiaStore) {
  var cont = 0;  
  var perguntas = new Array();
  var alternativas;

  alternativas = [
    new Alternativa(1, "São Paulo.", 0, 0),
    new Alternativa(2, "Rio de Janeiro", 0, 0),
    new Alternativa(3, "Paraná.", 0, 0),
    new Alternativa(4, "Espírito santo.", 0, 0),
    new Alternativa(5, "Minas Gerais.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "Uma nova divisão política do Brasil está em tramitação no Congresso, e deve ser concluída até 2015 com a criação de 18 estados em todas as atuais regiões do país. Dentre essa nova divisão, todos os 26 estados e o Distrito Federal permanecerão, porém alguns terão modificações territoriais como a saída para o mar, por um estado da região Sudeste.<br/>Esse estado seria", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Centro-Sul, Centro oeste, Nordeste e Leste.", 0, 0),
    new Alternativa(2, "Centro-Sul, Nordeste, Amazônia e Sudeste.", 0, 0),
    new Alternativa(3, "Região concentrada, Centro oeste, Nordeste e Amazônia.", 1, 0),
    new Alternativa(4, "Centro, Sudeste, Nordeste e Amazônia.", 0, 0),
    new Alternativa(5, "Centro-Norte, Centro-Oeste, Nordeste e Sudeste.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "Considerando o processo histórico de ocupação e transformação do território pela sociedade, que nos levou ao atual estágio do meio técnico-científico-informacional, o geógrafo Milton Santos e sua equipe propuseram uma outra regionalização para o território brasileiro, uma divisão regional em “quatro Brasis”<br/>Essas regiões são", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Portugal, República Checa e Polônia.", 0, 0),
    new Alternativa(2, "Reino Unido, Dinamarca e Hungria.", 1, 0),
    new Alternativa(3, "França, Alemanha e Itália.", 0, 0),
    new Alternativa(4, "Letônia, Romênia e Espanha.", 0, 0),
    new Alternativa(5, "Grécia, Suíça e Itália.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "“A União Européia (UE), composta por 27 países, apresenta um sistema político historicamente único, vem evoluindo há mais de 50 anos”.<br/>Onze países da UE não adotaram o Euro como moeda oficial.<br/>Assinale a alternativa que indica apenas países que NÃO aderiram ao EURO, como moeda oficial.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "I e II apenas.", 0, 0),
    new Alternativa(2, "III e IV apenas.", 1, 0),
    new Alternativa(3, "III, IV e V.", 0, 0),
    new Alternativa(4, "I, II e V.", 0, 0),
    new Alternativa(5, "V apenas.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "Analise a tabela.</p><p>Considere as afirmações sobre a situação dos continentes em relação a esses meios de comunicação.</p><p>I. os dois continentes em melhor situação são Oceania e Américas.II. os dois continentes em pior situação são África e Europa.<br/>III. os dois continentes em melhor situação são Europa e Oceania.<br/>IV. os dois continentes em pior situação são África e Ásia.<br/>V. a Ásia, por ser muito populosa, apresenta o maior número de telefones fixos por habitante.</p><p>Estão corretas", 0, 0, "img/perguntas/img0013.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Líbia.", 0, 0),
    new Alternativa(2, "Iêmen.", 0, 0),
    new Alternativa(3, "Egito.", 1, 0),
    new Alternativa(4, "Bahrein", 0, 0),
    new Alternativa(5, "Irã.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "<b>Após 18 dias de protestos, Mubarak renuncia</b></p><p>Começou, no dia 25 de janeiro, uma data que ganhou um caráter histórico, principalmente na internet. Naquela terça-feira, a população começou uma jornada que durou 18 dias e derrubou o presidente Hosni Mubarak. Naquele momento, o líder que estava no poder há 30 anos ainda tinha poderes. No dia 28, ele cortou o acesso à internet e declarou toque de recolher. As medidas foram ignoradas pela população, mas Mubarak disse que não iria renunciar. Em pronunciamento, disse apenas que buscaria “reformas democráticas” para responder aos anseios da população.</p><p>[...] Por fim, no final da tarde da sexta-feira, dia 11 de fevereiro, Suleiman, em um rápido pronunciamento na TV estatal, informou que Mubarak renunciava, abrindo um novo capítulo na história do país.</p><p><i>(Disponível em: http://noticias.terra.com.br/mundo/noticias/. Acesso em: Fev/2011)</i></p><p>O país, cujo povo derrubou o ditador Hosni Mubarak é", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "americano.", 0, 0),
    new Alternativa(2, "Oriente Médio.", 0, 0),
    new Alternativa(3, "europeu.", 1, 0),
    new Alternativa(4, "asiático.", 0, 0),
    new Alternativa(5, "norte-americano.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "De acordo com as estimativas da Organização Mundial de Turismo (OMT), em 2007 o intenso fluxo de turistas pelo mundo foi responsável pela geração de uma receita da ordem de 850 bilhões de dólares.</p><p>Analise a tabela ao lado e responda à questão.</p><p>Segundo a tabela, o continente que mais arrecadou turistas foi", 0, 0, "img/perguntas/img0019.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "televisão.", 0, 0),
    new Alternativa(2, "rádio.", 1, 0),
    new Alternativa(3, "computador.", 0, 0),
    new Alternativa(4, "sistemas multimídia.", 0, 0),
    new Alternativa(5, "satélite.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "No meio técnico-científico-informacional, os fluxos de informação ocorrem de modo instantâneo por uma rede mundial de computadores. A informação é o elemento fundamental para imprimir agilidade aos processos de uma empresa, elevando sua competitividade. No meio geográfico atual, os negócios expandiram-se pelos continentes e elevou-se o volume de mercadorias e de investimentos no mercado internacional.</p><p>Esse meio técnico-científico-informacional também modificou as relações sociais, o modo de vida das pessoas, criou novas relações de trabalho, introduziu formas de lazer e de entretenimento antes inexistentes.</p><p><i>(LUCCI, Ellian; BRANCO, Anselmo L.; MENDONÇA, Claudio. Território e Sociedade no Mundo Globalizado. SP: Ed. Saraiva, 2010)</i></p><p>Assinale abaixo, o tipo de comunicação que não faz parte do meio técnico-científico-informacional atual.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Índia.", 0, 0),
    new Alternativa(2, "China.", 1, 0),
    new Alternativa(3, "Paquistão.", 0, 0),
    new Alternativa(4, "Mongólia.", 0, 0),
    new Alternativa(5, "Irã.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "<b>Qual país tem mais fusos horários?</b></p><p>É a Rússia, maior país do mundo em extensão longitudinal. Ao todo, 11 fusos horários e mais de 10 mil quilômetros, separam a região oeste do extremo leste. Assim, quando é meio-dia na capital, Moscou, já são 9 horas da noite nas cidades do extremo leste.</p><p>Em 2o lugar vêm os EUA, com 9 fusos – incluem-se aí o Havaí, outras ilhas do Pacífico e o Alasca. O Canadá é o terceiro, com 6 horários diferentes.</p><p>Se fosse levar em conta apenas a área do território, esse país deveria vir em seguida, com 5 fusos. Ocorre que o governo obriga todos os relógios do país a ser ajustados em um único horário: o da capital. Isso pode ser bom para os negócios, mas é ruim para os habitantes da região oeste, que na maior parte do ano só vêem o Sol nascer às 9 da manhã. Pior ainda para quem cruzar a fronteira com o Afeganistão ao meio-dia: terá de voltar os ponteiros do relógio para as 8h30min.</p><p><i>(FEIJÓ, Bruno Vieira. Superinteressante. Ed. 233. São Paulo: Abril, maio 2006.)</i></p><p>Qual país teria 5 fusos e adota um único horário para um território muito extenso?", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "A vegetação homogênea do Pantanal.", 0, 0),
    new Alternativa(2, "A caatinga que vem sendo agredida pela irrigação, pela criação de pastos e por latifúndios.", 0, 0),
    new Alternativa(3, "A formação latifoliada da Mata Atlântica, com os climas tropical litorâneo úmido e subtropical úmido.", 0, 0),
    new Alternativa(4, "Os campos sulinos de áreas planas e de clima subtropical.", 0, 0),
    new Alternativa(5, "O cerrado com vegetação das savanas e clima tropical típico.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "Segundo ecossistema mais extenso do território brasileiro, distribui-se pelas regiões Centro- Oeste, Nordeste e Sudeste, pelas mais variadas formas de relevo e é muito aproveitado para o cultivo da soja e do café. Assinale a alternativa que corresponde ao ecossistema em questão.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Paquistão.", 0, 0),
    new Alternativa(2, "Líbano.", 0, 0),
    new Alternativa(3, "Irã.", 1, 0),
    new Alternativa(4, "Índia.", 0, 0),
    new Alternativa(5, "Israel.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "Assinale a alternativa que corresponde ao país que, em 2006, decidiu retomar as suas pesquisas com enriquecimento de urânio, provocando preocupação às grandes potências que temem o desenvolvimento de armamento atômico.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "redução da mortalidade infantil e da melhora das condições de saneamento básico.", 1, 0),
    new Alternativa(2, "melhora das condições de saneamento básico e da diminuição do desemprego.", 0, 0),
    new Alternativa(3, "redução da mortalidade infantil e da melhora dos índices de alfabetização.", 0, 0),
    new Alternativa(4, "melhora dos índices de alfabetização e da melhora das condições de saneamento básico.", 0, 0),
    new Alternativa(5, "melhora dos índices de alfabetização e da diminuição do desemprego.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "Ao longo do século XX, ampliou-se significativamente a expectativa de vida do brasileiro. Apesar da desigualdade dos índices regionais (principalmente Sul e Nordeste), essa diferença vem diminuindo nos últimos anos. Para o IBGE, essa diminuição é consequência direta da", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "desde 1950, com a consolidação da indústria brasileira, o país passa a viver um processo de subordinação da agricultura à indústria.", 0, 0),
    new Alternativa(2, "há subutilização do espaço agrícola com o predomínio do cultivo de lavouras permanentes.", 0, 0),
    new Alternativa(3, "há predomínio de produção de gêneros destinados à exportação em detrimento de produtos alimentícios para o mercado interno.", 0, 0),
    new Alternativa(4, "apesar da subordinação dessa atividade à indústria, o Brasil não depende da importação de alimentos para abastecer o mercado interno.", 1, 0),
    new Alternativa(5, "há predomónio de agricultura extensiva com baixa produtividade nas regiões Norte, Nordeste e Centro-Oeste.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Geografia)", "Sobre o espaço e a atividade agropecuária brasileira NÃO podemos afirmar que", 0, 0, "", alternativas);
  cont++;

  materiaStore.add(new Materia("Geografia", perguntas));
}

function carregarPerguntasBiologia(materiaStore) {
  var cont = 0;  
  var perguntas = new Array();
  var alternativas;

  alternativas = [
    new Alternativa(1, "ameba.", 0, 0),
    new Alternativa(2, "vibrião colérico.", 1, 0),
    new Alternativa(3, "euglena.", 0, 0),
    new Alternativa(4, "planária.", 0, 0),
    new Alternativa(5, "anelídeo.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "São organismos que não apresentam mitocôndrias em sua organização celular:", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Está presente em todas as espécies de seres vivos.", 0, 0),
    new Alternativa(2, "É um método de nutrição específico dos vertebrados.", 0, 0),
    new Alternativa(3, "Não está presente nos fungos.", 0, 0),
    new Alternativa(4, "É um método de nutrição específico dos eucariontes.", 0, 0),
    new Alternativa(5, "É um método de nutrição específico dos animais e fungos.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "A respeito do método de nutrição heterotrófica, é correto afirmar.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Os genes envolvidos apresentam segregação independente, o que implica que devem estar presentes no mesmo cromossomo.", 1, 0),
    new Alternativa(2, "A cor da pele é determinada por uma herança com essa característica.", 0, 0),
    new Alternativa(3, "Apresentam efeito cumulativo dos genes envolvidos como resultado fenotípico.", 0, 0),
    new Alternativa(4, "Há fenótipos intermediários.", 0, 0),
    new Alternativa(5, "Nesse tipo de herança não há genes com comportamento de dominância ou recessividade.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "Assinale a alternativa que contém a única afirmação <b>INCORRETA</b> a respeito das heranças poligênicas.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "reações de quebra da glicose que ocorrem no citoplasma.", 0, 0),
    new Alternativa(2, "descarboxilações que ocorrem na matriz mitocondrial durante o Ciclo de Krebs.", 1, 0),
    new Alternativa(3, "reações de oxido-redução que ocorrem nas cristas mitocondriais.", 0, 0),
    new Alternativa(4, "forma proporcional do Ciclo de Krebs e da Cadeia Respiratória que ocorre no interior das mitocôndrias.", 0, 0),
    new Alternativa(5, "vários processos catabólicos que ocorrem nas mitocôndrias e no citoplasma.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "O gás carbônico, eliminado a partir da respiração celular, provém de", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "mitocôncrias e citoesqueleto.", 0, 0),
    new Alternativa(2, "membrana plasmática e lisossomos.", 0, 0),
    new Alternativa(3, "retículo e complexo de Golgi.", 1, 0),
    new Alternativa(4, "ribossomos e peroxissomos.", 0, 0),
    new Alternativa(5, "carioteca e nucléolos.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "São estruturas celulares bem desenvolvidas, em células do pâncreas e da tireóide,", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "é a mesma em todos os organismos de uma mesma espécie.", 0, 0),
    new Alternativa(2, "é a mesma em todas as células de um mesmo organismo.", 1, 0),
    new Alternativa(3, "constitui o código genético dos organismos vivos.", 0, 0),
    new Alternativa(4, "pode ser a mesma em organismo de uma mesma classe ou ordem.", 0, 0),
    new Alternativa(5, "é única para cada célula, mesmo em um único organismo.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "A respeito da sequência de bases nitrogenadas do DNA das células, é correto afirmar que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "a fotossíntese.", 0, 0),
    new Alternativa(2, "a movimentação de organelas dentro do citoplasma de células vegetais.", 0, 0),
    new Alternativa(3, "o controle da entrada e saída de gases e da perda de água em folhas verdes.", 1, 0),
    new Alternativa(4, "a divisão celular em células eucariontes.", 0, 0),
    new Alternativa(5, "o transporte através das membranas celulares.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "E um processo que envolve a participação direta dos estômatos:", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "a respiração, a digestão e a sudorese.", 1, 0),
    new Alternativa(2, "a mastigação e a deglutição.", 0, 0),
    new Alternativa(3, "os reflexos motores, como o reflexo patelar.", 0, 0),
    new Alternativa(4, "piscar e tossir.", 0, 0),
    new Alternativa(5, "os sonhos, o sono e a memória.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "São exemplos de funções controladas pelo sistema nervoso autonômico:", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "ocorreu apenas osmose.", 0, 0),
    new Alternativa(2, "as membranas das células das folhas de alface são impermeáveis ao sal.", 0, 0),
    new Alternativa(3, "ocorreu apenas difusão de sal.", 0, 0),
    new Alternativa(4, "as membranas das células das folhas de alface são pouco permeáveis ao sal.", 1, 0),
    new Alternativa(5, "as membranas das células das folha de alface são impermeáveis à água.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "Uma salada de alface foi temperada com sal e óleo. Após algumas horas, as folhas parecem estar murchas e, mesmo quando lavadas, continuam com sabor salgado. Tendo em vista os fenômenos de transporte que ocorreram nas células da folha de alface e segundo as observações destacadas acima, podemos afirmar que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "será prejudicado o fluxo de substâncias inorgânicas nesta árvore, por redução da pressão no interior do floema.", 0, 0),
    new Alternativa(2, "será prejudicado o fluxo de substâncias entre as porções heterotróficas e as porções autotróficas.", 0, 0),
    new Alternativa(3, "a perda da capilaridade prejudicará o fluxo de substâncias orgânicas nesta árvore.", 1, 0),
    new Alternativa(4, "será prejudicado o fluxo de substâncias inorgânicas nesta árvore, por perda da capilaridade.", 0, 0),
    new Alternativa(5, "se o floema foi atingido, o xilema também foi, então a árvore não sobrevivera", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "Foi realizado um corte em uma árvore, formando um anel ao redor do seu tronco, a 20cm do solo, de forma a atingir o floema. Nestas condições, podemos afirmar que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "haverá aumento do consumo de oxigênio e da produção de ATP.", 0, 0),
    new Alternativa(2, "haverá aumento do consumo de oxigênio e redução da produção de ATP.", 1, 0),
    new Alternativa(3, "haverá redução do consumo de oxigênio e da produção de ATP.", 0, 0),
    new Alternativa(4, "haverá redução do consumo de oxigênio e aumento na produção de ATP.", 0, 0),
    new Alternativa(5, "haverá o bloqueio do funcionamento do ciclo de Krebs.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "Os hormônios tireoidianos T3 e T4 são desacopladores da cadeia respiratória, pois impedem o funcionamento da ATP sintetase presente no complexo V deste sistema. Se houver aumento nas concentrações de T3 e T4 no sangue, podemos afirmar que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "autossômica dominante.", 1, 0),
    new Alternativa(2, "autossômica recessiva.", 0, 0),
    new Alternativa(3, "recessiva.", 0, 0),
    new Alternativa(4, "autossômica ligada ao X.", 0, 0),
    new Alternativa(5, "dominante ligada ao X.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Biologia)", "Um indivíduo apresenta determinada característica. Esta característica foi herdada por todas as suas filhas e por nenhum dos seus filhos homens. Supondo que essa herança dependa de um único gene, trata-se, provavelmente, de uma herança genética do tipo", 0, 0, "", alternativas);
  cont++;

  materiaStore.add(new Materia("Biologia", perguntas));
}

function carregarPerguntasQuimica(materiaStore) {
  var cont = 0;  
  var perguntas = new Array();
  var alternativas;

  alternativas = [
    new Alternativa(1, "aumenta a energia de ativação da reação de combustão.", 0, 0),
    new Alternativa(2, "aumenta a concentração de gás hidrogênio disponível para a combustão.", 0, 0),
    new Alternativa(3, "aumenta a concentração de comburente disponível para a queima.", 1, 0),
    new Alternativa(4, "diminui a energia de ativação da reação de combustão.", 0, 0),
    new Alternativa(5, "facilita o combate ao fogo.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "<b>Queimadas causam mais de 75% da emissão de gás carbônico no brasil</b></p><p>As queimadas são responsáveis por mais de 75% da emissão de gás carbônico no Brasil, segundo o Instituto Brasileiro de Geografia e Estatística (IBGE).</p><p>O vento é um fator que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "2.", 0, 0),
    new Alternativa(2, "20.", 0, 0),
    new Alternativa(3, "40.", 1, 0),
    new Alternativa(4, "60.", 0, 0),
    new Alternativa(5, "50.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "<b>governo e indústria de alimentos fecham acordo para reduzir sódio</b></p><p>Segundo o Ministério da Saúde, o brasileiro consome, em média, 9,6 gramas diárias de sal. A Organização Mundial da Saúde recomenda que consumo máximo não ultrapasse 5 gramas diárias. O excesso de sal na dieta está associado a maior risco de doenças como hipertensão, problemas cardiovasculares, renais e cânceres.</p><p>A indústria alimentícia e o Ministério da Saúde firmaram em abril de 2011, um termo de compromisso de redução gradual na quantidade de sódio de 16 tipos de alimentos. As primeiras reduções vão ocorrer com massas instantâneas, pães e bisnaguinhas, a partir de 2012.</p><p><i>(Disponível em: http://www.topmed.com.br. Acesso em: set/2011)</i></p><p>Calcule, aproximadamente, a porcentagem (%) em massa de sódio nas 5g de sal (cloreto de sódio). Dado: massas molares (g.mol-1): Na = 23; Cl = 35,5", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "apresenta a função éter e amida.", 0, 0),
    new Alternativa(2, "apresenta a função álcool e fenol.", 1, 0),
    new Alternativa(3, "possui 6 ligações pi(π).", 0, 0),
    new Alternativa(4, "possui cadeia carbônica saturada.", 0, 0),
    new Alternativa(5, "possui 16 carbonos secundários.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "O Ano Internacional da Química (AIQ-2011) tem como meta promover, no âmbito mundial, o conhecimento e a educação em Química para todos os níveis. Vamos celebrar os inúmeros benefícios que a Química traz para a Humanidade e pensar no seu papel primordial para o desenvolvimento de um mundo sustentável. A descoberta da morfina em 1805 possibilitou o tratamento sintomático da dor. O assistente de farmácia Freidrich Sertuner, isolou este alcalóide opiáceo a partir da resina da papoula (Papaver somniferum L.), e em alusão à sonolência que causava, Sertüner denominou este opiácio em homenagem ao deus dos sonhos: Morpheu. O principal uso da morfina é no tratamento da dor oncológica e da dor aguda.</p><p>A respeito da molécula da morfina, podemos afirmar que", 0, 0, "img/perguntas/img0008.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "é um hidrocarboneto aromático.", 0, 0),
    new Alternativa(2, "pode ser produzido através de matéria orgânica.", 1, 0),
    new Alternativa(3, "sua fórmula molecular é C2H6.", 0, 0),
    new Alternativa(4, "apresenta cadeia insaturada.", 0, 0),
    new Alternativa(5, "é uma molécula polar.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "O gás natural é uma mistura de hidrocarbonetos leves encontrada no subsolo, na qual o metano tem uma participação superior a 70 % em volume. O gás natural é um combustível fóssil e uma energia não-renovável e representa 20,7% da matriz energética mundial.<br/>Sobre o metano, é correto afirmar que", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "oxirredução.", 0, 0),
    new Alternativa(2, "esterificação.", 0, 0),
    new Alternativa(3, "neutralização.", 0, 0),
    new Alternativa(4, "fissão nuclear.", 1, 0),
    new Alternativa(5, "fusão nuclear.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "O mundo acompanhou atônito aos eventos ocorridos nos reatores das usinas nucleares do Japão, logo após o terremoto seguido de tsunami em 11 de março de 2011.</p><p>Num reator nuclear, a enorme quantidade de energia é produzida por meio de reações de", 0, 0, "img/perguntas/img0020.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "F, F, F.", 0, 0),
    new Alternativa(2, "F, V, V.", 0, 0),
    new Alternativa(3, "V, F, V.", 0, 0),
    new Alternativa(4, "V, V, V.", 0, 0),
    new Alternativa(5, "V, F, F.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "Julgue as afirmações abaixo como (F) falsas ou (V) verdadeiras e assinale a alternativa correta.</p><p>I - ( ) O estado físico dos reagentes e produtos influi no valor do calor de reação (∆H).</p><p>II - ( ) A síntese da água em qualquer estado físico é um processo endotérmico.</p><p>III - ( ) A quebra de ligações, a evaporação e a solidificação são fenômenos endotérmicos.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "observa-se que o ecstasy é um nitrocomposto.", 0, 0),
    new Alternativa(2, "é um composto alifático.", 0, 0),
    new Alternativa(3, "é um composto aromático.", 1, 0),
    new Alternativa(4, "apresenta fórmula molecular C9H7NO2.", 0, 0),
    new Alternativa(5, "apresenta cadeia saturada.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "O ecstasy foi acidentalmente isolado pelos laboratórios Merck, em 1912. É uma droga que permite ao consumidor um acréscimo de energia e consequentemente mais prazer. Os efeitos físicos são taquicardia, aumento da pressão sanguínea, secura da boca, diminuição do apetite, dilatação das pupilas, dificuldade em caminhar, reflexos exaltados, vontade de urinar, tremores, transpiração, caimbras ou dores musculares.</p><p>A respeito da molécula do ecstasy podemos afirmar corretamente que", 0, 0, "img/perguntas/img0021.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "200 g de soluto se a solução preparada tiver a concentração de 0,5 mol/L.", 0, 0),
    new Alternativa(2, "uma concentração de 0,5 mol/L se adicionarmos 4 g de NaOH.", 1, 0),
    new Alternativa(3, "uma solução que solidifica a uma temperatura superior a de uma solução de mesma concentração de glicose.", 0, 0),
    new Alternativa(4, "uma solução não-eletrolítica.", 0, 0),
    new Alternativa(5, "uma solução com 0,5 mol/L íons Na+ , se adicionarmos 2 g de NaOH.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "Ao prepararmos 200 mL de uma solução aquosa de hidróxido de sódio (NaOH), teremos,</p><p>Dado: massa molar do NaOH = 40g.mol-1,", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "29,6 u.", 1, 0),
    new Alternativa(2, "28,4 u.", 0, 0),
    new Alternativa(3, "28,0 u.", 0, 0),
    new Alternativa(4, "30,0 u.", 0, 0),
    new Alternativa(5, "29,0 u.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "Considere que um elemento químico seja formado por dois isótopos com as seguintes características:</p><p><b>Obs. Considere a massa de um próton ou de um nêutron como 1 u (unidade de massa atômica).</b></p><p>A massa atômica que podemos esperar para esse elemento químico é", 0, 0, "img/perguntas/img0033.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "2,5 gramas.", 0, 0),
    new Alternativa(2, "5,0 gramas.", 1, 0),
    new Alternativa(3, "7,5 gramas.", 0, 0),
    new Alternativa(4, "80,0 gramas.", 0, 0),
    new Alternativa(5, "120,0 gramas.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "Certa quantidade de gás neônio ocupou 6 litros nas condições ambientes, quando colocado no interior de um cilindro (veja figura abaixo) com embolo móvel e de atrito desprezível.</p><p>Dados: Ne=20u Volume molar nas condições ambientes(25oC/1atm)=24litros/mol</p><p>A massa de gás neônio no interior do cilindro nessas condições é", 0, 0, "img/perguntas/img0034.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "a - 60oC, a espécie química está totalmente líquida.", 0, 0),
    new Alternativa(2, "a 0oC, a espécie química está sofrendo fusão.", 0, 0),
    new Alternativa(3, "a ebulição da espécie química ocorre a +80oC.", 0, 0),
    new Alternativa(4, "a 0oC, os estados líquido e gasoso estão presentes.", 1, 0),
    new Alternativa(5, "no intervalo de tempo de 10 a 20 minutos, podemos encontrar somente a substância sólida.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "Ao analisar uma espécie química em laboratório, obteve-se o seguinte gráfico como resultado do seu aquecimento:</p><p>Todas as alternativas a respeito da espécie química estão <b>incorretas</b>, exceto", 0, 0, "img/perguntas/img0035.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "V2W.", 0, 0),
    new Alternativa(2, "M3T2.", 0, 0),
    new Alternativa(3, "X2R.", 0, 0),
    new Alternativa(4, "JL3.", 0, 0),
    new Alternativa(5, "F2G.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Química)", "Na tabela acima, os símbolos dos elementos químicos foram substituídos por letras arbitrariamente escolhidas. A letra Z representa o símbolo de um gás nobre. Baseado na posição dos elementos mencionados na tabela periódica acima, assinale qual das fórmulas seguintes deve ser a correta.", 0, 0, "img/perguntas/img0036.png", alternativas);
  cont++;

  materiaStore.add(new Materia("Química", perguntas));
}

function carregarPerguntasMatematica(materiaStore) {
  var cont = 0;  
  var perguntas = new Array();
  var alternativas;

  alternativas = [
    new Alternativa(1, "6 anos.", 0, 0),
    new Alternativa(2, "12 anos.", 0, 0),
    new Alternativa(3, "30 anos.", 0, 0),
    new Alternativa(4, "20 anos.", 1, 0),
    new Alternativa(5, "24 anos.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "“Finalmente, o Congresso Nacional legislou em benefício do trabalhador. Segundo a nova lei, para os trabalhadores que tiverem até um ano de trabalho na mesma empresa, o aviso prévio terá 30 dias, direito já garantido pela Constituição. Para aqueles que trabalham por um período maior do que um ano na mesma empresa, devem ser acrescentados três dias para cada ano de serviço, sendo o acréscimo máximo de 60 dias por pessoa.”<br/><i>(Disponível em: http://primeiraedicao.com.br/noticia. Acesso em: set/2011)</i><br/>Analisando esta notícia, podemos concluir que o trabalhador terá direito a 90 dias de aviso prévio após trabalhar na mesma empresa por um período de", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "Gráfico A", 0, 0),
    new Alternativa(2, "Gráfico B", 0, 0),
    new Alternativa(3, "Gráfico C", 1, 0),
    new Alternativa(4, "Gráfico D", 0, 0),
    new Alternativa(5, "Gráfico E", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "Uma <i>lan house</i>, na tentativa de conquistar clientes assíduos, oferece aos mesmos o seguinte plano para pagamento mensal: até 20 horas, R$ 60,00 e, acima de 20 horas, são cobrados R$ 2,00 por hora excedente. O gráfico que melhor representa a função que relaciona quantidade de horas e preço é:", 0, 0, "img/perguntas/img0009.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "108°.", 0, 0),
    new Alternativa(2, "1080°.", 0, 0),
    new Alternativa(3, "288°.", 0, 0),
    new Alternativa(4, "2880°.", 1, 0),
    new Alternativa(5, "3880°.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "Luisa confecciona caixas para presente. Quando alguém quer embalar pedras preciosas, ela sugere a embalagem a seguir.</p><p>O desenho representa um poliedro convexo que possui 5 faces quadrangulares e 2 pentagonais. Desta forma, pode-se afirmar que a soma dos ângulos das faces deste poliedro é igual a", 0, 0, "img/perguntas/img0010.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "1,10; 2,50; 4,50.", 0, 0),
    new Alternativa(2, "2,50; 1,10; 4,50.", 0, 0),
    new Alternativa(3, "4,50; 2,50; 1,10.", 1, 0),
    new Alternativa(4, "2,50; 4,50; 1,10.", 0, 0),
    new Alternativa(5, "4,50; 1,10; 2,50.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "Segundo o guia Alimentar para a população brasileira, a alimentação saudável deve fornecer todos os nutrientes necessários a uma boa nutrição e consequente manutenção da saúde.</p><p>Jorge é chefe de departamento e, preocupado em incentivar a boa alimentação de seus funcionários, sugeriu três dias de lanche saudável por semana.</p><p>Assim que termina a semana, Jorge apresenta a planilha de gastos com a alimentação.</p><p>Com base na planilha, podemos afirmar que o preço do lanche, da barra de ceral e do suco, em reais, foi respectivamente,", 0, 0, "img/perguntas/img0011.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "29,7 x 21.", 0, 0),
    new Alternativa(2, "21 x 14,8.", 0, 0),
    new Alternativa(3, "14,8 x 10,5.", 1, 0),
    new Alternativa(4, "21 x 10,5.", 0, 0),
    new Alternativa(5, "14,8 x 7,4.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "Algumas folhas de papel, em função do seu tamanho padronizado, são denominadas A0, A1, A2, A3 etc., conforme mostra tabela abaixo:</p><p><table><th>Folha</th><th>￼Dimensões (em cm)</th><tr><td>A0</td><td>118,9 x 84,1</td></tr><tr><td>A1</td><td>84,1 x 59,4</td></tr><tr><td>A2</td><td>59,4 x 42,0</td></tr><tr><td>A3</td><td>42,0 x 29,7</td></tr></table></p><p>Observe que, dividindo-se a folha A0 ao meio, obtém-se A1 (Figura 1); dividindo-se a folha A1 ao meio, obtém-se A2 (Figura 2), e assim por diante.</p><p>Pode-se afirmar que as dimensões, em cm, da folha A6 são, aproximadamente,", 0, 0, "img/perguntas/img0022.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "40,00.", 0, 0),
    new Alternativa(2, "400,00.", 0, 0),
    new Alternativa(3, "56,00.", 0, 0),
    new Alternativa(4, "56,00.", 0, 0),
    new Alternativa(5, "560,00.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "Roberto está tentando diminuir as despesas da casa, para isto fez um levantamento dos salários de 2010 e de como foi empregado o salário do mês de dezembro deste mesmo ano. Os resultados foram representados nos gráficos a seguir.</p><p>Roberto concluiu que pode diminuir suas despesas com lazer, pois no mês de dezembro, o valor gasto com o lazer, em reais, foi", 0, 0, "img/perguntas/img0023.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "5/33", 1, 0),
    new Alternativa(2, "5/36", 0, 0),
    new Alternativa(3, "1/36", 0, 0),
    new Alternativa(4, "2/15", 0, 0),
    new Alternativa(5, "1/18", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "O jogo da memória, muito conhecido por crianças e adultos, é formado por peças que apresentam uma figura em um dos lados, sendo que a mesma figura aparece em duas peças distintas. Para começar o jogo, as peças são postas com as figuras voltadas para baixo, para que não possam ser vistas, e cabe ao jogador virar duas peças seguidas com figuras iguais.</p><p>O jogo de memória do Dudu possui doze peças, sendo que as seis figuras distintas estão representadas no desenho ao lado.</p><p>A probabilidade de, no início do jogo, Dudu virar uma peça cuja figura é um sol e, em seguida, sem desvirar a primeira, virar uma segunda peça que seja diferente da primeira é", 0, 0, "img/perguntas/img0024.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "prisma reto de base triangular.", 0, 0),
    new Alternativa(2, "prisma reto de base quadrada.", 0, 0),
    new Alternativa(3, "prisma reto de base hexagonal.", 0, 0),
    new Alternativa(4, "cilindro.", 1, 0),
    new Alternativa(5, "tetraedro.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "Maria é uma senhora que produzia e vendia balas de coco em saquinhos plásticos. Como suas vendas aumentaram muito e sua clientela ficou mais exigente, ela decidiu substituir as embalagens e escolher, dentre as opções abaixo, aquela que possibilitasse a colocação da maior quantidade de balas (maior volume).</p><p>Dentre as opções anteriores, dona Maria deve escolher a embalagem em forma de", 0, 0, "img/perguntas/img0025.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "novembro.", 0, 0),
    new Alternativa(2, "setembro.", 0, 0),
    new Alternativa(3, "maio.", 0, 0),
    new Alternativa(4, "agosto.", 0, 0),
    new Alternativa(5, "junho.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "Dois jornais A e B de uma cidade venderam, em janeiro, 640 e 5640 exemplares, respectivamente. Mensalmente, o jornal A aumenta a vendagem seguindo uma progressão geométrica de razão 3/2. Por outro lado, o jornal B tem suas vendas reduzidas, mensalmente, em 156 unidades. Ambos venderão o mesmo número de exemplares no mês de", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "5,6.", 1, 0),
    new Alternativa(2, "1,28.", 0, 0),
    new Alternativa(3, "1", 0, 0),
    new Alternativa(4, "2,8.", 0, 0),
    new Alternativa(5, "4,64.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "Calcule o perímetro do retângulo ABCD da figura abaixo, sendo o ponto 0, o centro desse retângulo.</p><p>Dados: senx = 0,6</p><p>Assinale a alterntiva correta.", 0, 0, "img/perguntas/img0037.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "1/2.", 0, 0),
    new Alternativa(2, "3/4.", 0, 0),
    new Alternativa(3, "6/35.", 0, 0),
    new Alternativa(4, "1/35.", 1, 0),
    new Alternativa(5, "12/35", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Matemática)", "Numa urna foram depositadas fichas contendo, cada uma, um único anagrama da palavra ALEMANHA. Extraindo-se uma dessas fichas ao acaso, a probabilidade de que ela contenha um anagrama com vogais e consoantes alternadas é", 0, 0, "", alternativas);
  cont++;

  materiaStore.add(new Materia("Matemática", perguntas));
}

function carregarPerguntasFisica(materiaStore) {
  var cont = 0;  
  var perguntas = new Array();
  var alternativas;

  alternativas = [
    new Alternativa(1, "5,0 m/s.", 0, 0),
    new Alternativa(2, "6,0 m/s.", 0, 0),
    new Alternativa(3, "7,0 m/s.", 0, 0),
    new Alternativa(4, "8,0 m/s.", 1, 0),
    new Alternativa(5, "9,0 m/s.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Em obras da construção civil, é muito comum vermos um operário (no solo) lançando tijolos para outro operário, que se encontra situado no piso superior. Considerando o lançamento de cada tijolo como sendo vertical, a resistência do ar nula, a aceleração da gravidade local igual a 10 m/s2 e a distância entre as mãos do operário lançador e a do operário receptor igual 3,2 m, o valor da velocidade com que cada tijolo deve ser lançado, de modo que tal chegue às mãos do operário receptor com uma velocidade nula, deve ser de", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "1 m/s.", 0, 0),
    new Alternativa(2, "3 m/s.", 1, 0),
    new Alternativa(3, "5 m/s.", 0, 0),
    new Alternativa(4, "6 m/s.", 0, 0),
    new Alternativa(5, "7 m/s.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Um homem, parado sobre uma escada rolante de 12 m de comprimento, leva 6 s para descê-la. Este homem leva 12 s para subir esta mesma escada rolante, porém caminhando contra o movimento de descida. Com base nas informações do texto, é possível afirmar que a velocidade imposta pelo homem na ação de subida foi de", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "15 °C.", 0, 0),
    new Alternativa(2, "25 °C.", 0, 0),
    new Alternativa(3, "50 °C.", 0, 0),
    new Alternativa(4, "66 °C.", 0, 0),
    new Alternativa(5, "70 °C.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Em uma cozinha situada ao nível do mar, uma chaleira contendo 1 litro de água é aquecida até o ponto em que esta água começa a ferver. A seguir, para que a água pare de ferver, a fonte quente é desligada e esta quantidade de água é introduzida em um calorímetro ideal, que já continha 500 ml de água a 10 °C. Qual é a temperatura final de equilíbrio no interior do calorímetro?", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "1h.", 0, 0),
    new Alternativa(2, "6h.", 0, 0),
    new Alternativa(3, "9h.", 0, 0),
    new Alternativa(4, "12h.", 0, 0),
    new Alternativa(5, "18h.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Uma bateria de automóvel, completamente carregada, pode liberar até 1,3 ∙ 10^5 C de carga.</p><p>Sabendo que uma lâmpada necessita de uma corrente elétrica de 2,0 A para ficar em regime normal de funcionamento, quanto tempo, aproximadamente, que essa lâmpada ficaria acesa, caso fosse ligada nessa bateria?", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "foi constante entre os instantes t = 0 e t = 5s.", 0, 0),
    new Alternativa(2, "era de 8 m/s2 no instante t = 5s.", 0, 0),
    new Alternativa(3, "era de 2 m/s2 no instante t = 3s.", 1, 0),
    new Alternativa(4, "não foi constante em nenhum trecho da trajetória.", 0, 0),
    new Alternativa(5, "teve o mesmo sentido do movimento após o instante t = 5s.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Num experimento de laboratório, alguns alunos observaram o movimento de um objeto em trajetória retilínea, medindo-se a velocidade (v) em cada segundo a partir do instante t=0s até t=10s. Os resultados obtidos foram registrados na tabela abaixo.</p><p>De acordo com a tabela, pode-se afirmar que a aceleração do objeto", 0, 0, "img/perguntas/img0026.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "2,50 . 105 Pa.", 0, 0),
    new Alternativa(2, "1,25 . 105 Pa.", 0, 0),
    new Alternativa(3, "26,0 . 105 Pa.", 0, 0),
    new Alternativa(4, "3,5 . 105 Pa.", 1, 0),
    new Alternativa(5, "2,6 . 105 Pa.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Um mergulhador encontra-se numa caverna a 25m de profundidade em relação à superfície do mar. Considerando a pressão atmosférica na superfície desse mar igual a 1,0 × 105 Pa, a densidade da água desse mar igual a 1,0 × 103 kg/m3 e a aceleração da gravidade local no valor de 10 m/s2, pode-se afirmar que a pressão total sobre o mergulhador é de", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "é correta e a frequência aparente, nestas condições, é aproximadamente 7% menor que a frequência real.", 1, 0),
    new Alternativa(2, "é incorreta, pois as características do som dependem apenas do meio no qual ele se propaga.", 0, 0),
    new Alternativa(3, "é correta e a frequência aparente, nestas condições, é aproximadamente 13,6% maior que a frequência real.", 0, 0),
    new Alternativa(4, "é incorreta, pois, pelo efeito Doppler, para que haja alteração na frequência aparente, o ouvinte também deve estar em movimento.", 0, 0),
    new Alternativa(5, "é correta e a frequência aparente, nestas condições, é aproximadamente 25% menor.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Uma pessoa encontra-se parada numa praça quando vê uma ambulância se aproximar com velocidade constante de 90 km/h. Assim que ambulância passa pela praça, a pessoa nota que o som da sirene parece ficar diferente. Sabendo-se que a velocidade do som no ar é de 340 m/s, pode-se concluir que a impressão da pessoa", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "E = 1,5 . 10-1 N/C é vertical e aponta para cima.", 0, 0),
    new Alternativa(2, "E = 6,0 . 10-1 N/C é horizontal e orientado no sentido do plano do papel.", 0, 0),
    new Alternativa(3, "E = 1,5 N/C é horizontal e orientado no sentido do leitor.", 0, 0),
    new Alternativa(4, "E = 6,0 . 107 N/C é vertical e aponta para baixo.", 0, 0),
    new Alternativa(5, "E = 1,5 N/C é vertical e aponta para cima.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Uma partícula P, com carga negativa, penetra em um campo magnético uniforme B->, de intensidade B = 5,0 . 10-4T, com velocidade v = 3,0 . 103 m/s, conforme a figura acima.</p><p>Sendo E-> o campo elétrico na mesma região onde atua o campo magnético e, sabendo-se que a partícula ingressou em ambos os campos numa trajetória retilínea e horizontal, pode-se afirmar que", 0, 0, "img/perguntas/img0027.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "33,6.", 0, 0),
    new Alternativa(2, "8,4.", 0, 0),
    new Alternativa(3, "8.", 0, 0),
    new Alternativa(4, "33600.", 1, 0),
    new Alternativa(5, "560.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Um professor de Física resolve avaliar a potência de um ferro elétrico. Para isso, realiza o seguinte experimento: retira a capa plástica que recobre o ferro elétrico e o coloca numa bacia contendo 4 litros de água (= 4kg). Após 1 minuto, verifica que a temperatura da água variou 2 oC. Admita que não há perdas de calor para o ambiente e que o calor específico da água = 4,2 J/g.oC.</p><p>A quantidade de calor, em joules (J), trocada entre o ferro elétrico e a água foi de", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "33600.", 0, 0),
    new Alternativa(2, "120.", 0, 0),
    new Alternativa(3, "252.", 0, 0),
    new Alternativa(4, "504.", 0, 0),
    new Alternativa(5, "560.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Um professor de Física resolve avaliar a potência de um ferro elétrico. Para isso, realiza o seguinte experimento: retira a capa plástica que recobre o ferro elétrico e o coloca numa bacia contendo 4 litros de água (= 4kg). Após 1 minuto, verifica que a temperatura da água variou 2 oC. Admita que não há perdas de calor para o ambiente e que o calor específico da água = 4,2 J/g.oC.</p><p>A potência elétrica, em watts (W), do ferro elétrico é", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "67200.", 0, 0),
    new Alternativa(2, "1,12.", 1, 0),
    new Alternativa(3, "1120.", 0, 0),
    new Alternativa(4, "1,008.", 0, 0),
    new Alternativa(5, "7200.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Física)", "Um professor de Física resolve avaliar a potência de um ferro elétrico. Para isso, realiza o seguinte experimento: retira a capa plástica que recobre o ferro elétrico e o coloca numa bacia contendo 4 litros de água (= 4kg). Após 1 minuto, verifica que a temperatura da água variou 2 oC. Admita que não há perdas de calor para o ambiente e que o calor específico da água = 4,2 J/g.oC.</p><p>Se este ferro elétrico for utilizado durante 2 horas, seu consumo, em kWh, será de", 0, 0, "", alternativas);
  cont++;

  materiaStore.add(new Materia("Física", perguntas));
}

function carregarPerguntasAtualidades(materiaStore) {
  var cont = 0;  
  var perguntas = new Array();
  var alternativas;

  alternativas = [
    new Alternativa(1, "Israel desocupou o território palestino depois de pressão internacional.", 0, 0),
    new Alternativa(2, "Egito e Israel depois de três décadas de confrontos na fronteira, encontram a paz.", 0, 0),
    new Alternativa(3, "Os EUA são favoráveis a inserção da Palestina na ONU.", 0, 0),
    new Alternativa(4, "A disputa territorial entre Israel e Palestina continua, mesmo com a pressão internacional.", 1, 0),
    new Alternativa(5, "A Turquia vive o melhor momento democrático depois de um período intenso de radicalização islâmica.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "<b>Primavera árabe coincide com um outono para Israel</b><br/>Com o ataque à sua embaixada no Cairo, seu embaixador expulso da Turquia e os palestinos buscando o reconhecimento de seu Estado na ONU, Israel se vê cada vez mais isolado.<br/>Aluf Benn, editor-chefe do jornal esquerdista Haaretz, reconhece que Binyamin Netenyahu não pode ser culpado pelos acontecimentos no Cairo, pela ascensão de um partido de inspiração islâmica na Turquia ou pelo programa nuclear iraniano. Mas, ecoando críticas feitas pelo governo Barack Obama, diz que Netanyahu “nada fez para amenizar as consequências nefastas dos problemas citados”.<br/>Em opinião consonante com a do governo israelense, Eli Shaked, ex-embaixador israelense no Cairo, respondeu aos críticos que “o Egito não avança no rumo da democracia, e sim no da radicalização islâmica”. “Ocorre o mesmo na Turquia e em Gaza. Foi exatamente o que ocorreu no Irã em 1979.”<br/>Os possíveis efeitos colaterais das disputas diplomáticas já vieram à tona. A crescente hostilidade por parte do Egito pode exigir uma reelaboração radical da doutrina defensiva israelense que, nas últimas três décadas, contou com a paz na sua fronteira sul. A ameaça feita pela Turquia na semana passada aos planos israelenses para a exploração de jazidas de gás no Mediterrâneo Oriental pode prejudicar o acordo de Israel com o Chipre para a exploração de recursos energéticos e poderia aprofundar as tensões com o Líbano envolvendo os direitos de perfuração.<br/>Tradicionalmente, muitos líderes árabes usaram Israel como bode expiatório, voltando a fúria do seu público contra o Estado judaico e responsabilizando o país por seus problemas. Mas outra interpretação predomina no exterior – muçulmanos, árabes e boa parte da população mundial acreditam que Israel ocupa injustamente os territórios palestinos. “O mundo está cansado desse conflito e furioso conosco, pois nos enxerga como conquistadores que governam outro povo”, disse Binyamin Bem-Eliezer, parlamentar do Partido Trabalhista e ex-ministro da Defesa de Israel. “Se eu fosse Netanyahu, optaria por reconhecer o Estado palestino. Poderíamos, então, negociar a definição das fronteiras e garantia da segurança. Restou-nos um único aliado, os EUA, e mesmo esse relacionamento está desgastado.”<br/><i>(O Estado de S.Paulo – 13/09/2011)</i><br/>Assinale a alternativa correta.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "A França produz menos energia por meio das usinas nucleares em comparação com o uso de hidrelétrica.", 0, 0),
    new Alternativa(2, "Os complexos nucleares na França não apresentam perigo uma vez que nunca houve vazamento.", 0, 0),
    new Alternativa(3, "No incidente na usina nuclear de Marcoule, segundo as autoridades, não ocorreu vazamento.", 1, 0),
    new Alternativa(4, "A França solicitou o fechamento de 58 reatores nucleares, que poderiam causar danos nas localidades próximas.", 0, 0),
    new Alternativa(5, "O acidente na usina nuclear na França causou a morte de funcionários pelo alto índice de radioatividade.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "Leia o texto e observe o mapa. Marque a alternativa correta.", 0, 0, "img/perguntas/img0012.png", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "EC no 29 discute investimento tanto para saúde quanto para educação.", 0, 0),
    new Alternativa(2, "O Brasil debate sobre investimento na saúde para a aprovação da EC no29.", 1, 0),
    new Alternativa(3, "A população é contra a criação de impostos para a saúde.", 0, 0),
    new Alternativa(4, "Com um novo imposto, as administrações públicas se isentam da responsabilidade sobre a verba da saúde.", 0, 0),
    new Alternativa(5, "A criação da EC no29 tem o objetivo de criar uma nova fonte de financiamento.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "<b>Por mais critérios para o investimento em saúde</b><br/>Com a iminência da votação da regulamentação da emenda constitucional no 29, o financiamento para a saúde voltou à pauta. Infelizmente, sempre que o assunto é discutido, pontos fundamentais são contornados e fatos diversionistas prejudicam o debate e protelam as decisões realmente importantes.<br/>Na situação atual, dinheiro de qualquer fonte será uma boa notícia para a saúde. Se o Congresso e o governo decidirem que a criação de um novo tributo é viável, o setor e a população agradecerão e farão bom uso desses recursos, desde que eles cheguem ao destino. O que não é aceitável é condicionar a regulamentação da emenda constitucional à criação de uma nova fonte de financiamento. Essa relação trava qualquer avanço, já que a criação de impostos é tema delicado e “embaralha” a discussão. Existem argumentos sólidos – além de um repúdio natural da sociedade – contrários à medida. Ao amarrar os assuntos, os opositores da EC no 29 se aproveitam da legítima objeção ao aumento da carga tributária para barrar a emenda da saúde, um tema completamente distinto.<br/>A EC no 29 não exige necessariamente aumento de gastos. A regra determina um percentual mínimo de investimentos. Ou seja: do Orçamento já existente, uma certa porcentagem deve ser aplicada em saúde.<br/>Quem (Estados, municípios ou União) ainda não cumpre o estabelecido (e muitos cumprem, o que prova a viabilidade da medida) deverá buscar fundos em projetos menos prioritários, enxugar despesas e evitar desperdícios para atingir o exigido. No fim, é um estímulo para a melhoria de gestão.<br/><i>(O Estado de S.Paulo – 13/09/2011)</i><br/>Assinale a alternativa correta.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "A internet sofrerá modificações que restringirá seu uso.", 0, 0),
    new Alternativa(2, "Os internautas terão de mudar seus domínios atuais para os novos.", 0, 0),
    new Alternativa(3, "Mesmo com os novos domínios previstos para 2012, as empresas não poderão usar a marca de seus produtos.", 0, 0),
    new Alternativa(4, "O Brasil ficará de fora das modificações uma vez que está vivendo um período de introdução da banda larga.", 0, 0),
    new Alternativa(5, "A partir de 2012 as empresas poderão inovar vários domínios da internet.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "<b>Internet ganhará novos domínios em 2012</b><br/>Endereços da internet conhecidos de praticamente todos os usuários da rede -”.com”, “.org” ou “.net”- estão prestes a se diversificar. A partir de janeiro de 2012, as empresas poderão aposentar o tradicional padrão e escolher termos com que se identifiquem, como “www.iphone.apple” ou “www. hamburger.mcdonalds”.<br/>Segundo Rob Beckstrom, presidente da Icann (Internet Corporation for Assigned Names and Numbers), autoridade que controla os domínios mundiais de internet, a rede passa a conviver com termos mais criativos.<br/>No Brasil para participar da Futurecom 2011, Beckstrom falou à Folha.<br><b>Grande mudança</b><br/>Essa é a terceira e mais significativa ampliação dos domínios da internet. Os primeiros “pontos” eram o “.gov” e “.mil” para o governo dos Estados Unidos. Depois vieram “.com”. e os domínios de países como o “.com.br”. Agora a internet está madura para novos endereços.<br/>Empresas interessadas em comprar esses novos domínios deverão pagar US$ 185 mil inicialmente e uma taxa de manutenção de US$ 25 mil por ano. Também serão necessárias adaptações técnicas, mas imaginamos que os benefícios podem superar os custos.<br/>De 12 de janeiro a 12 de abril as empresas poderão submeter à Icann os domínios em que estão interessadas.<br/><b>Nova estrutura</b><br/>Esse sistema levou seis anos para ser desenvolvido. Permite adaptar os novos endereços à estrutura atual.<br/><b>Inovação</b><br/>O novo sistema trará mais inovação à internet. Marcas e empresas poderão atrelar já no endereço uma referência ao seu produto. Será possível criar domínios “produto.marca” e até distribuir endereços secundários para seus clientes, como “sobrenome.produto”. Esse seria um esforço de fidelização dessas empresas.<br/><b>Futuro do “.com”</b><br/>Os endereços “.com” não devem morrer em breve. Atualmente existem 9 milhões deles. Embora não devam ter um fim próximo, esses endereços verão uma concorrência significativa das novas possibilidades.<br/><i>(Folha de S.Paulo – 13/09/2011)</i><br>De acordo com o texto, assinale a alternativa correta.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "desigualdade escolar entre negros e brancos.", 0, 0),
    new Alternativa(2, "racismo na primeira infância.", 0, 0),
    new Alternativa(3, "racismo no Ensino Fundamental.", 0, 0),
    new Alternativa(4, "desigualdade social dos negros e ao racismo.", 1, 0),
    new Alternativa(5, "falta de escolas para os negros.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "<b>Para debater desigualdade racial, ONU institui 2011 como ano dos afrodescendentes</b></p><p>Com o intuito de combater o racismo e as desigualdades econômicas e sociais dos negros, a Organização das Nações Unidas (ONU) instituiu 2011 como o Ano Internacional dos Afrodescendentes. Eles estão entre os que mais sofrem com discriminação e dificuldade de acesso a serviços básicos, como educação, segundo o órgão.</p><p>O Fundo das Nações Unidas para a Infância (UNICEF), em parceria com a Secretaria de Políticas de Promoção da Igualdade Racial (Seppir), lançou, no final do ano passado, a campanha “Por uma infância sem racismo”.</p><p>A taxa de analfabetismo entre a população branca de 15 anos ou mais é de 6,1%, enquanto que para os negros e pardos é de 14,1 % – diferença de 131,1%. Os dados são do Instituto Brasileiro de Geografia e Estatística (IBGE) e constam no 4o Relatório Nacional sobre os Direitos Humanos no Brasil, lançado em dezembro no último ano.</p><p>Entre os que estudaram, considerando a população com 25 anos ou mais, a média de escolaridade da população negra e parda é de 5,8 anos, contra 7,8 anos para a população branca. A campanha do UNICEF tem o objetivo de mobilizar a sociedade brasileira para assegurar a igualdade étnico-racial desde a infância. “Quando os pais e professores promovem a interação e o conhecimento sobre o diverso, estão incentivando à igualdade”, ressalta. “A criança que pode estar em diferentes espaços cresce aprendendo a respeitar o outro.”</p><p>Mais da metade de população brasileira tem ascendência africana. De acordo com dados do IBGE de 2009, 51,1% dos brasileiros se reconhecem como pretos ou pardos.</p><p>Com a segunda maior população negra do planeta (e primeira fora do continente africano), a missão do Brasil no ano temático da ONU é “chamar atenção para as persistentes desigualdades que ainda afetam esta parte importante da população brasileira”, segundo um comunicado da instituição.</p><p><i>(Disponível em: http://www.clicrbs.com.br/especial. Acesso em: fev/2011)</i></p><p>Os principais objetivos da campanha são o combate à/ao", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "bens de consumo.", 0, 0),
    new Alternativa(2, "produtos eletroeletrônicos.", 0, 0),
    new Alternativa(3, "publicações sobre a população afrodescendente.", 0, 0),
    new Alternativa(4, "saneamento básico.", 0, 0),
    new Alternativa(5, "educação.", 1, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "<b>Para debater desigualdade racial, ONU institui 2011 como ano dos afrodescendentes</b></p><p>Com o intuito de combater o racismo e as desigualdades econômicas e sociais dos negros, a Organização das Nações Unidas (ONU) instituiu 2011 como o Ano Internacional dos Afrodescendentes. Eles estão entre os que mais sofrem com discriminação e dificuldade de acesso a serviços básicos, como educação, segundo o órgão.</p><p>O Fundo das Nações Unidas para a Infância (UNICEF), em parceria com a Secretaria de Políticas de Promoção da Igualdade Racial (Seppir), lançou, no final do ano passado, a campanha “Por uma infância sem racismo”.</p><p>A taxa de analfabetismo entre a população branca de 15 anos ou mais é de 6,1%, enquanto que para os negros e pardos é de 14,1 % – diferença de 131,1%. Os dados são do Instituto Brasileiro de Geografia e Estatística (IBGE) e constam no 4o Relatório Nacional sobre os Direitos Humanos no Brasil, lançado em dezembro no último ano.</p><p>Entre os que estudaram, considerando a população com 25 anos ou mais, a média de escolaridade da população negra e parda é de 5,8 anos, contra 7,8 anos para a população branca. A campanha do UNICEF tem o objetivo de mobilizar a sociedade brasileira para assegurar a igualdade étnico-racial desde a infância. “Quando os pais e professores promovem a interação e o conhecimento sobre o diverso, estão incentivando à igualdade”, ressalta. “A criança que pode estar em diferentes espaços cresce aprendendo a respeitar o outro.”</p><p>Mais da metade de população brasileira tem ascendência africana. De acordo com dados do IBGE de 2009, 51,1% dos brasileiros se reconhecem como pretos ou pardos.</p><p>Com a segunda maior população negra do planeta (e primeira fora do continente africano), a missão do Brasil no ano temático da ONU é “chamar atenção para as persistentes desigualdades que ainda afetam esta parte importante da população brasileira”, segundo um comunicado da instituição.</p><p><i>(Disponível em: http://www.clicrbs.com.br/especial. Acesso em: fev/2011)</i></p><p>Um dos grandes entraves para a população negra, segundo o texto, é o acesso à", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "O tremor de terra no Japão gerou muitos problemas, mas todos solucionados.", 0, 0),
    new Alternativa(2, "A Segunda Guerra Mundial gerou uma crise intensa no Japão, diferente do atual terremoto que fortaleceu o país.", 0, 0),
    new Alternativa(3, "O Japão nunca tinha enfrentado uma crise com tantos problemas humanitários.", 0, 0),
    new Alternativa(4, "O tremor de terra no Japão gerou uma crise econômica e humanitária parecida com a ocorrida na Segunda Guerra Mundial.", 1, 0),
    new Alternativa(5, "O Japão enfrenta muitas dificuldades após o terremoto, porém a economia permanece estável.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "Leia o texto publicado no <b>Jornal da Tarde</b>, de 14 de março de 2011 e assinale a alternativa correta.</p><p><b>Pior crise desde a 2a. guerra</b></p><p><b>Para premiê Naoto Kan, desabastecimento e risco de desastre atômico agravam tragédia</b></p><p>O primeiro-ministro do Japão, Naoto Kan, afirmou ontem que o país vive sua mais grave crise desde a devastação provocada pela 2a. Guerra, há 65 anos. A crise humanitária provocada pelo terremoto seguido de tsunami e a ameaça de um desastre nuclear se agravam a cada dia, com centenas de milhares de pessoas em abrigos provisórios e inúmeras cidades com falta de água, comida e combustível.</p><p>Quase 2 milhões de residências estão sem energia e o governo começará hoje a racionar eletricidade em Tóquio para evitar um blecaute no sistema. Estão sem água 1,4 milhão de pessoas e os serviços de transporte continuam interrompidos em várias áreas do nordeste do país.</p><p>Estradas parcialmente destruídas e linhas de trem interrompidas dificultam as operações de resgate e de distribuição de suprimentos.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "No Centro e na Zona Sul a gasolina está mais cara do que nas outras localidades da cidade.", 1, 0),
    new Alternativa(2, "O preço do etanol na região Oeste está mais barato comparado ao Centro.", 0, 0),
    new Alternativa(3, "A Zona Leste tem o melhor preço de gasolina e diesel.", 0, 0),
    new Alternativa(4, "A região Norte apresenta um preço menor no diesel e maior na gasolina.", 0, 0),
    new Alternativa(5, "As Zonas Norte e Sul são as melhores opções para abastecer em São Paulo.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "Leia o gráfico e assinale a alternativa correta.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "apenas cercar a cidade de Jerusalém.", 0, 0),
    new Alternativa(2, "cercar por todos os lados todo o território sobre o qual exerce soberania.", 0, 0),
    new Alternativa(3, "isolar a maioria da população palestina, sem perder o controle sobre a região além-muro, ainda que permitindo parcial autonomia aos palestinos.", 1, 0),
    new Alternativa(4, "isolar a maioria da população palestina, renunciando a manter qualquer controle sobre o território e as populações que ficarem além-muro.", 0, 0),
    new Alternativa(5, "separar de modo absoluto, ou total, de um lado do muro os judeus e, do outro, os palestinos.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "Com o chamado “muro de proteção”, que está sendo construído desde 2002, com previsão de ser concluído em 2007, o Estado de Israel pretende", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "I, II, III e IV.", 1, 0),
    new Alternativa(2, "I e III.", 0, 0),
    new Alternativa(3, "I, II e IV.", 0, 0),
    new Alternativa(4, "I e II.", 0, 0),
    new Alternativa(5, "II, III e IV.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "A utilização de células-tronco para curar doenças representa um grande salto no progresso da medicina, visto que essas células, aplicadas ao organismo humano, podem regenerar qualquer órgão que seria dado como irreversivelmente perdido ou em vias de se perder. Sobre o tema, considere as afirmações seguintes.</p><p><b>I -</b> Existem células-tronco adultas, presentes em vários tecidos, como medula óssea, pele, sangue, fígado etc., porém são menos capacitadas que as embrionárias na cura de doenças.<br><b>II -</b> As células-tronco embrionárias, obtidas durante a primeira semana após a fertilização do óvulo pelo espermatozóide, são muito capacitadas, podendo atuar na formação dos mais diversos tecidos do organismo.<br><b>III -</b> A clonagem terapêutica permite criar células-tronco embrionárias a partir de células de uma pessoa, mediante a transferência do núcleo de uma célula adulta para um óvulo do qual o núcleo foi removido.<br><b>IV -</b> A legislação brasileira permite a utilização de células-tronco de embriões, desde que obtidas por fertilização in vitro, congeladas há mais de 3 anos e mediante autorização dos pais.<br></p><p>São verdadeiras as seguintes afirmações:", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "As células-tronco adultas têm a mesma capacidade de curar doenças que as células-tronco embrionárias.", 0, 0),
    new Alternativa(2, "Não existem células-tronco adultas.", 0, 0),
    new Alternativa(3, "As células-tronco adultas têm menos capacidade de curar doenças que as células-tronco embrionárias.", 1, 0),
    new Alternativa(4, "A legislação brasileira não permite o uso de células-tronco embrionárias, visto que sua obtenção depende da morte dos embriões humanos (óvulo já fecundado pelo espermatozóide).", 0, 0),
    new Alternativa(5, "A legislação brasileira permite apenas a utilização de células-tronco adultas.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "As pesquisas com células-tronco abrem grandes perspectivas para o futuro da medicina, tornando possível a formação ou regeneração dos mais diversos tecidos ou órgãos do corpo, enfim, a recuperação da saúde em situações antes impensáveis. Sobre o tema, assinale a alternativa correta.", 0, 0, "", alternativas);
  cont++;

  alternativas = [
    new Alternativa(1, "que o movimento abandonou as ações terroristas, admitindo conviver com o Estado de Israel.", 1, 0),
    new Alternativa(2, "a decepção da população com os líderes palestinos anteriores, que mantinham negociações com Israel.", 0, 0),
    new Alternativa(3, "o apoio da população às ações terroristas que conseguiram expulsar os colonos israelenses dos territórios palestinos ocupados.", 0, 0),
    new Alternativa(4, "a independência do povo e do Estado Palestino em face do domínio israelense.", 0, 0),
    new Alternativa(5, "a decepção da população com o Fatah, que governava a Palestina sem reconhecer ou dialogar com o Estado de Israel.", 0, 0)
  ];
  perguntas[cont] = new Pergunta(cont + 1, "Conhecimentos gerais (Atualidades)", "O Movimento de Resistência Islâmica, conhecido como Hamas, disputou e venceu as eleições daAutoridadeNacionalPalestina ANP.Essefatoindica", 0, 0, "", alternativas);
  cont++;

  materiaStore.add(new Materia("Atualidades", perguntas));
}
