const DB_NAME = "VestibularMetodista";
const DB_VERSION = 1;

var db = null;
var request = indexedDB.open(DB_NAME, DB_VERSION);
var cont = 0;

request.onerror = function(evt) {
  alert("Erro no banco de dados: " + evt + " -- " + evt.message + " -- " + evt.target.errorCode);
  alert("A aplicação não tem permissão para montar as perguntas!");
};

request.onsuccess = function(evt) {
  db = this.result;
  listarPerguntas();
};

request.onupgradeneeded = function(evt) {
  db = evt.target.result;
}

$.urlParam = function(param) {
  var url = window.location.href;
  return url.substring(url.indexOf("=") + 1);
}

function voltarMaterias() {
  document.forms[0].action = 'materias.html';
  document.forms[0].submit();
}

function limparListaPerguntas() {
  var listaPerguntas = document.getElementById("perguntas");
  listaPerguntas.innerHTML = "";
}

function getMateriaStore() {
  return db.transaction(["materia"], "readwrite").objectStore("materia");
}

function listarPerguntas() {
  obterPontuacaoPorMateria();

  var materiaId = $.urlParam("materia_id");
  var materiaStore = getMateriaStore();

  materiaStore.openCursor().onsuccess = function (event) {
    var cursor = event.target.result;
    if (cursor && cursor.value.id == materiaId) {
      var perguntas = cursor.value.perguntas;
      var pergunta = null;
      for(i = 0; i < perguntas.length; i++) {
        if(perguntas[i].respondido == 0) {
          pergunta = perguntas[i];
          break;
        }
      }

      mostrarPergunta(materiaId, perguntas, pergunta);
    }
    if(cursor != null) {
      cursor.continue();
    }
  };
}

function mostrarPergunta(materiaId, perguntas, pergunta) {
  limparListaPerguntas();
  var radio = null;
  var perguntaId = 0;
  var podeResponder = null;

  if(perguntas != null) {
    if(pergunta == null) {
      pergunta = perguntas[perguntas.length - 1];
    }

    perguntaId = pergunta.numero;
    podeResponder = pergunta.respondido == 0;
    for(i = 0; i < pergunta.alternativas.length; i++) {
      var alternativa = pergunta.alternativas[i];
      if(i == 0) {
        var imagem = pergunta.imagem == "" ? "" : "<p><img src='" + pergunta.imagem + "' class='imagem'></p>";
        var tituloQuestao = "<b>Questão " + perguntaId + ")</b> "+ pergunta.titulo + imagem + "<p>" + pergunta.descricao + "</p>";
        radio = montarQuestao(tituloQuestao);
      }
      adicionarOpcao(radio, alternativa.numero, 'alternativa', alternativa.numero, alternativa.descricao, materiaId, perguntaId, 
      alternativa.correta, alternativa.selecionado == 1, podeResponder);
    }
    exibirQuestao(radio);
    configurarBotoesProximoEAnterior(materiaId, perguntaId, podeResponder);
    temQuestaoAnterior(perguntas, perguntaId);
    temProximaQuestao(perguntas, perguntaId);
  }
}

function montarQuestao(titulo) {
  var radio = $('<fieldset data-role="controlgroup"></fieldset>');
  var titulo = criarQuestaoTitulo(titulo);
  radio.prepend(titulo);
  radio.load();

  return radio;
}

function criarQuestaoTitulo(titulo) {
  return $('<legend>' + titulo + '</legend>');
}

function exibirQuestao(radio) {
  $('#perguntas').append(radio).trigger('create');
}

function criarQuestaoOpcaoInput(idOpcao, nameOpcao, valor, idMateria, idPergunta, isCorreta, alternativaSelecionada, podeResponder) {
  var input = null;

  if(podeResponder) {
    input = $('<input/>')
      .attr({
  	'type': 'radio',
  	'name': nameOpcao,
  	'id': idOpcao,
  	'value': valor,
  	'data-value' : isCorreta 
      });
    input.attr('onclick', 'responder(' + idMateria + ', ' + idPergunta + ', ' + idOpcao + ', ' + isCorreta + ')');
  } else {
    input = $('<input/>')
      .attr({
  	'type': 'radio',
  	'name': nameOpcao, 
  	'id': idOpcao, 
  	'value': valor,
  	'data-value': isCorreta,
  	'checked': alternativaSelecionada
      });
    if(isCorreta == '1') {
      input.attr('data-theme','g');
    } else {
      input.attr('data-theme','f');
    }
  }

  return input;
}

function criarQuestaoOpcaoLabel(idOpcao, descricaoResposta) {
  var label = $('<label/>')
    .attr({
      'for':idOpcao
    }).text(descricaoResposta);

  return label;
}

function adicionarOpcao(radio, idOpcao, nameOpcao, valor, descricaoResposta, materiaId, perguntaId, isCorreta, alternativaSelecionada, podeResponder) {
  var input = criarQuestaoOpcaoInput(idOpcao, nameOpcao, valor, materiaId, perguntaId, isCorreta, alternativaSelecionada, podeResponder);
  var label = criarQuestaoOpcaoLabel(idOpcao, descricaoResposta);
  radio.append(input, label);

  return radio;
}

function configurarBotoesProximoEAnterior(materiaId, perguntaId, podeResponder) {
  $('input[name=alternativa]:radio').checkboxradio('refresh');

  $('#anterior')
    .attr({
      'display' : 'inline',
      'onclick' : 'questaoAnterior(' + materiaId + ', ' + perguntaId + ');'
    });
  $('#proximo')
    .attr({
      'display' : 'inline',
      'onclick' : 'proximaQuestao(' + materiaId + ', ' + perguntaId + ');'
    });

  $('#divProxAnt').css("display","inline");
}

function responder(materiaId, perguntaId, alternativaId, isCorreta) {
  var materiaStore = getMateriaStore();

  var request = materiaStore.get(materiaId);
  request.onsuccess = function(event) {
    var materia = request.result;
    var pergunta = null;
    var perguntas = materia.perguntas;
    for(i = 0; i < perguntas.length; i++) {
      if(perguntas[i].numero == perguntaId) {
        pergunta = perguntas[i];
        pergunta.respondido = 1;

        for(i = 0; i < pergunta.alternativas.length; i++) {
          var alternativa = pergunta.alternativas[i];
          if(alternativa.numero == alternativaId) {
            alternativa.selecionado = 1;
            if(alternativa.correta) {
              pergunta.acertou = 1;
              materia.pontuacao += 100;
            }

            showRespostaCorretaEIncorreta(perguntaId, alternativaId, isCorreta);
          }
        }

        break;
      }
    }
  
    materiaStore.put(materia);
  }
}

function proximaQuestao(materiaId, perguntaId) {
  var materiaStore = getMateriaStore();

  materiaStore.openCursor().onsuccess = function (event) {
    var cursor = event.target.result;
    if (cursor && cursor.value.id == materiaId) {
      var perguntas = cursor.value.perguntas;
      var pergunta = null;

      for(i = 0; i < perguntas.length; i++) {
        if(perguntas[i].numero > perguntaId) {
          pergunta = perguntas[i];
          break;
        }
      }

      mostrarPergunta(materiaId, perguntas, pergunta);
    }

    if(cursor != null) {
      cursor.continue();
    }
  };
}

function questaoAnterior(materiaId, perguntaId) {
  var materiaStore = getMateriaStore();

  materiaStore.openCursor().onsuccess = function (event) {
    var cursor = event.target.result;
    if (cursor && cursor.value.id == materiaId) {
      var perguntas = cursor.value.perguntas;
      var pergunta = null;

      for(i = perguntas.length - 1; i >= 0; i--) {
        if(perguntas[i].numero < perguntaId) {
          pergunta = perguntas[i];
          break;
        }
      }

      mostrarPergunta(materiaId, perguntas, pergunta);
    }

    if(cursor != null) {
      cursor.continue();
    }
  };
}

function showRespostaCorretaEIncorreta(perguntaId, alternativaId, isCorreta) {
  var nameRadio = $('#'+alternativaId).attr('name');
  var select = $('input[name='+nameRadio+']:radio');
  select.checkboxradio('disable');
  
  select.each(function() {
    if($(this).is(':checked')) {
      obterPontuacaoPorMateria();
      var dataValue = $(this).attr("data-value");
      if(dataValue == '1') {
        $(this).next().removeClass('ui-body-c ui-btn-up-c ui-btn-down-c').addClass('ui-body-g ui-btn-up-g ui-btn-down-g').attr('data-theme', 'g');
        $(this).checkboxradio('refresh');
      } else {
        $(this).next().removeClass('ui-body-c ui-btn-up-c ui-btn-down-c').addClass('ui-body-f ui-btn-up-f ui-btn-down-f').attr('data-theme', 'f');
        $(this).checkboxradio('refresh');
        showRespostaCorreta(select);
      }
    }
  });
}

function showRespostaCorreta(select) {
  select.each(function() {
    var dataValue = $(this).attr("data-value");
    if(dataValue == '1') {
      $(this).next().removeClass('ui-body-c ui-btn-up-c ui-btn-down-c').addClass('ui-body-g ui-btn-up-g ui-btn-down-g').attr('data-theme', 'g');
      $(this).checkboxradio('refresh');
    }
  });
}

function obterPontuacaoPorMateria() {
  var materiaId = $.urlParam("materia_id");
  var materiaStore = getMateriaStore();

  materiaStore.openCursor().onsuccess = function (event) {
    var cursor = event.target.result;
    if (cursor && cursor.value.id == materiaId) {
      var pontuacao = document.getElementById("pontuacao");
      pontuacao.innerHTML = "Pontuação: " + cursor.value.pontuacao;
    }
    if(cursor != null) {
      cursor.continue();
    }
  };
}

function temProximaQuestao(perguntas, perguntaId) {
  var temProxima = false;
  for(i = 0; i < perguntas.length; i++) {
    if(perguntas[i].numero > perguntaId) {
      temProxima = true;
      break;
    }
  }
  desabilitaHabilitaProximo(temProxima);
}

function temQuestaoAnterior(perguntas, perguntaId) {
  var temAnterior = false;
  for(i = 0; i < perguntas.length; i++) {
    if(perguntas[i].numero < perguntaId) {
      temAnterior = true;
      break;
    }
  }
  desabilitaHabilitaAnterior(temAnterior);
}

function desabilitaHabilitaProximo(temProximo) {
  desabilitaHabilita('#proximo', temProximo);
}

function desabilitaHabilitaAnterior(temAnterior) {
  desabilitaHabilita('#anterior', temAnterior);
}

function desabilitaHabilita(id, tem) {
  if(tem) {
    $(id).button('enable');
  } else {
    $(id).button('disable');
  }

  $(id).button('refresh');
}
