var gateway = "http://vsakos.tk/vesti/news/news.php";

var currentnews;
var currenturl;

var rss = {
	"blic": {
		"name": "Blic Online",
		"feed": {
			"danasnje": "Današnje vesti",
			"vesti": "Vesti",
			"zabava": "Zabava",
			"kultura": "Kultura",
			"slobodno": "Slobodno vreme",
			"auto": "Auto",
			"it": "IT",
			"komentar": "Komentar"
		}
	},
	"kurir": {
		"name": "Kurir",
		"feed": {
			"vesti": "Vesti",
			"zabava": "Zabava",
			"sport": "Sport",
			"stars": "Stars",
			"crna": "Crna Hronika",
			"sex": "Sex",
			"planeta": "Planeta"
		}
	},
	"b92": {
		"name": "B92",
		"feed": {
			"najnovije": "Najnovije",
			"vesti": "Vesti",
			"sport": "Sport",
			"zivot": "Život",
			"tehnopolis": "Tehnopolis",
			"english": "English",
			"biz": "Biz",
			"kultura": "Kultura",
			"automobili": "Automobili",
			"putovanja": "Putovanja",
			"zdravlje": "Zdravlje"
		}
	},
	"press": {
		"name": "Press Online",
		"feed": {
			"info": "Info",
			"zabava": "Zabava",
			"sport": "Sport",
			"svet": "Svet",
			"kolumne": "Kolumne"
		}
	},
	"rts": {
		"name": "RTS",
		"feed": {
			"vesti": "Vesti",
			"politika": "Politika",
			"region": "Region",
			"svet": "Svet",
			"danas": "Srbija danas",
			"hronika": "Hronika",
			"drustvo": "Društvo",
			
		}
	},
	"telegraf": {
		"name": "Telegraf",
		"feed": "vesti"
	},
	"politika": {
		"name": "Politika",
		"feed": {
			"svet": "Svet",
			"politika": "Politika",
			"komentari": "Komentari",
			"pogledi": "Pogledi",
			"pogledisastrane": "Pogledi sa strane",
			"temadana": "Tema dana",
			"sport": "Sport",
			"kultura": "Kultura",
			"spektar": "Spektar"
		}
	},
	"novosti": {
		"name": "Večernje Novosti",
		"feed": "vesti"
	},
	"alo": {
		"name": "Alo",
		"feed": "vesti"
	},
	"021": {	// paff
		"name": "021 - Novi Sad",
		"feed": "vesti"
	},
	"24sata": {
		"name": "24 Sata",
		"feed": {
			"vesti": "Vesti",
			"sport": "Sport",
			"sou": "Šou",
			"specijal": "Specijal",
			"novisad": "Novi Sad"
		}
	}
};

$(document).ready(function() {
	$.each(rss, function(key, val) {
		if(typeof val.feed == "string") {
			$("#drawer #main .content").append('<a href="#" data-type="feed" data-rss="'+key+'" data-feed="vesti">'+val.name+'</a>');
		}
		else {
			$("#drawer #main .content").append('<a href="#" data-type="rss" data-rss="'+key+'">'+val.name+'</a>');
		}
	});

	$("#drawer a[data-type='rss']").click(function() {
		var feed = $(this).data("rss");
		$("#drawer #rss .content").html("");
		$("#drawer #rss .header h1").text(rss[feed].name);
		$.each(rss[feed].feed, function(key, val) {
			$("#drawer #rss .content").append('<a href="#" data-type="feed" data-rss="'+feed+'" data-feed="'+key+'">'+val+'</a>');
		});
		$("#drawer #main").addClass("out");
		$("#drawer #rss").removeClass("out");
	});

	$(document).delegate("#drawer a[data-type='feed']", "click", function() {
		var feed = $(this).data("rss");
		var link = $(this).data("feed");

		$("#news .content").html("");
		$("#news .content").removeClass("empty");
		if(typeof rss[feed].feed == "string") {
			$("#news .header h1").text(rss[feed].name);
		}
		else {
			$("#news .header h1").text(rss[feed].name+" - "+rss[feed].feed[link]);
		}

		$("#loading").show();

		$.getJSON(gateway+"?p=rss&news="+feed+"&feed="+link+"&callback=?").done(function(data) {

			$.each(data, function(key, val) {
				$("#news .content").append('<a href="#" data-type="article" data-rss="'+feed+'" data-link="'+val.link+'">'+val.title+'</a>');
			});

			if($(".showdrawer").length) {
				$(".showdrawer").removeClass("showdrawer");
			}

			$(".current").addClass("out").removeClass("current");
			$("#news").addClass("current").removeClass("out");

			$("#loading").hide();

		}).fail(function() {
			alert("Ucitavanje nije uspelo! Proverite internet konekciju!");
			$("#loading").hide();
		});
	});

	$(document).delegate("#news a[data-type='article']", "click", function() {
		var parse = $(this).data("rss");
		var link = $(this).data("link");

		$("#article .content").html("");

		var article = getStorage("vesti-"+link);

		if(article) {
			$("#article .header h1").text(article.title);

			$.each(article.content, function(key, val) {
				if(val.text) {
					$("#article .content").append('<p>'+val.text+'</p>');
				}
				else if(val.image) {
					$("#article .content").append('<img src="'+val.image+'" alt>');
				}
			});

			$("#article .content").append('<p class="source">Izvor: '+article.source+'</p>');

			//$("[href='#save']").hide();

			$(".current").addClass("out").removeClass("current");
			$("#article").addClass("current").removeClass("out");
		}
		else {
			$("#loading").show();

			$.getJSON(gateway+"?p=article&parse="+parse+"&url="+link+"&callback=?").done(function(data) {

				var list = getStorage("vesti-saved") || [];
				list.push(link);
				while(list.length > 10) {
					var first = list.shift();
					localStorage.removeItem("vesti-"+first);
				}
				setStorage("vesti-saved", list);
				setStorage("vesti-"+link, data);


				$("#article .header h1").text(data.title);

				$.each(data.content, function(key, val) {
					if(val.text) {
						$("#article .content").append('<p>'+val.text+'</p>');
					}
					else if(val.image) {
						$("#article .content").append('<img src="'+val.image+'" alt>');
					}
				});

				$("#article .content").append('<p class="source">Izvor: '+data.source+'</p>');

				$("[href='#save']").show();

				$(".current").addClass("out").removeClass("current");
				$("#article").addClass("current").removeClass("out");

				$("#loading").hide();

			}).fail(function() {
				alert("Ucitavanje nije uspelo! Proverite internet konekciju!");
				$("#loading").hide();
			});
		}
	});

	$("#saved").click(function() {
		showSaved();
	});

	$(".header .button").click(function(e) {
		e.preventDefault();
		var href = $(this).attr("href");
		if(href == "#drawer") {
			if($(".showdrawer").length) {
				$(".showdrawer").removeClass("showdrawer");
			}
			else {
				$(this).parents(".page").addClass("showdrawer");
			}
			
		}
		else {
			if($(this).parents("#drawer").length) {
				$(this).parents(".page").addClass("out");
				$(href).removeClass("out");
			}
			else {
				$(this).parents(".page").addClass("out").removeClass("current");
				$(href).removeClass("out").addClass("current");
			}
		}
	});

	showSaved();
});

function showSaved() {
	$(".showdrawer").removeClass("showdrawer");
	var list = getStorage("vesti-saved") || [];
	$("#news .content").html("");
	$("#news .content").removeClass("empty");
	$("#news .header h1").text("Nedavno pročitani vesti");

	list.reverse();

	$.each(list, function(key, val) {
		var article = getStorage("vesti-"+val);

		$("#news .content").append('<a href="#" data-type="article" data-rss="" data-link="'+val+'">'+article.title+'</a>');
	});

	if(list.length == 0) {
		$("#news .content").addClass("empty").append('<div class="menuarrow">Čitajte najnovije vesti!</div>');
	}

	if(!$("#news").hasClass("current")) {
		$(".current").addClass("out").removeClass("current");
		$("#news").addClass("current").removeClass("out");
	}
}


function getStorage(key) {
	if(localStorage.getItem(key)) {
		return JSON.parse(localStorage.getItem(key));
	}
	else {
		return false;
	}
}

function setStorage(key, value) {
	localStorage.setItem(key, JSON.stringify(value));
}