
// check if supports vibrate or not.
var supportsVibrate = "vibrate" in navigator;

if (!supportsVibrate) {
	window.alert("Sorry, your device doesn't support Vibration API. You can't use this app!");
}


$(document).ready(function(){

	// Fire and stop persistent vibration
	$('#keepVibrationOn').on('mousedown', function(){
		startPeristentVibrate(200, 0);
	});
	$('#keepVibrationOn').on('mouseup', function(){
		stopVibrate();
	});


	// Vibrate once
	$('#vibrateOnce').on('click', function(){
		navigator.vibrate([1000]);
	});

});




/*******************************
VIBRATION API functions
*******************************/

/**
Persistent Vibration
**/
var vibrateInterval;

// Starts vibration at passed in level
function startVibrate(duration) {
	navigator.vibrate(duration);
	console.log("YEAAAHHH!!!");
}

// Stops vibration
function stopVibrate() {
	// Clear interval and stop persistent vibrating 
	if(vibrateInterval) clearInterval(vibrateInterval);
	navigator.vibrate(0);
}

// Start persistent vibration at given duration and interval
// Assumes a number value is given
function startPeristentVibrate(duration, interval) {
	vibrateInterval = setInterval(function() {
		startVibrate(duration);
	}, interval);
}