(function (){
    'use strict';

    angular
    .module('viki-controllers')
    .constant('ACTIVITY_PAGE', {
        'URL' : '/v4/users/',
        'PARAM': 'with_paging=true&token=',
        'TITLE': 'MY PROFILE'
    })
    .controller('appActivityController', ['ACTIVITY_PAGE','$scope', '$rootScope', '$http', '$state', '$stateParams', 'api','getData', 'shareFavorites', function(ACTIVITY_PAGE,$scope,$rootScope,$http,$state,$stateParams,api,getData,shareFavorites){
        if(!$rootScope.loginUser){
            $state.go('login');
            return;
        }
        $scope.title = ACTIVITY_PAGE.TITLE;
        if($rootScope.previousState === 'detail-page'){
            $scope.tab = 2;
        }
        else{
            $scope.tab = 1;
        }
        var user = $rootScope.loginUser;
        $rootScope.dpUrl = user.images.avatar.url;
        $scope.userName = user.name;
        $scope.joinDate = user.created_at;
        var tempArrayOfVideosFavorite = [];
        var tempArrayOfVideosActivity = [];
        $scope.setTab = function(newValue){
          $scope.tab = newValue;
        };
        $scope.isSet = function(tabName){
          return $scope.tab === tabName;
        };
        $scope.checker = api.process_url;
        $scope.loadVideos = function(url){
            if(url.indexOf("activities.json") > -1){
                $scope.loadActivites(url);
            }
            else{
                $scope.loadFavorites(url);
            }
        };
        $scope.loadActivites = function(url){
            getData.fromUrl(url.replace(api.app_url,'') + '&app=' + api.app_id + '&t=' + api.currentTime())
            .then(function(requested){
                for (var i = 0; i < requested.data.response.length; i++) {
                    tempArrayOfVideosActivity.push(requested.data.response[i]);
                }
                $scope.activity_videos = tempArrayOfVideosActivity;
                $scope.next = requested.data.pagination.next;
                if($scope.next){
                   $scope.next = $scope.next.replace('&app='+api.app_id, '');
                }
            });
        };
        $rootScope.loadFavorites = function(url){
            getData.fromUrl(url.replace(api.app_url,'') + '&app=' + api.app_id + '&t=' + api.currentTime())
            .then(function(requested){
                for (var i = 0; i < requested.data.response.length; i++) {
                    tempArrayOfVideosFavorite.push(requested.data.response[i]);
                }
                $scope.favorite_videos = tempArrayOfVideosFavorite;
                $scope.next = requested.data.pagination.next;
                if($scope.next){
                   $scope.next = $scope.next.replace('&app='+api.app_id, '');
                }
                shareFavorites.updateList(tempArrayOfVideosFavorite);
            });
        };
        $rootScope.firstLoadFavorites = function(){
            tempArrayOfVideosFavorite = [];
            $scope.loadFavorites(api.app_url + ACTIVITY_PAGE.URL+ user.id +'/subscriptions.json?' + ACTIVITY_PAGE.PARAM + $rootScope.loginToken);
        };
        $scope.firstLoadActivites = function(){
            tempArrayOfVideosActivity = [];
            $scope.loadActivites(api.app_url + ACTIVITY_PAGE.URL+ user.id +'/activities.json?type=watch&' + ACTIVITY_PAGE.PARAM + $rootScope.loginToken);
        };
        $rootScope.firstLoadFavorites();
        $scope.firstLoadActivites();
    }]);
})();