(function (){
	'use strict';

	angular
	.module('viki-controllers')
	.controller('appCategoryController', ['$rootScope', '$scope', 'getData', '$stateParams', 'api', 'scrollVideos', function($rootScope,$scope,getData,$stateParams,api,scrollVideos) {
		var url, urlCate, tempData = {};
		var countries, languages, genres;
		var tempArrayOfVideos = [];
		var countries_obj = {};
		$scope.timeFilter = {};
		$scope.country = {};
		$scope.mainVal = {};
		var videosList = angular.element('#videosList');

		$scope.sortingSub = [
								{ name : 'newest_video', value : 'New'},
								{ name : 'views_recent', value : 'Popular'}
							];
		$scope.sortingMain = [
								{ name : 'subtitle_completion', value : 'Languages'},
								{ name : 'origin_country', value : 'Countries'},
								{ name : 'genre', value : 'Genres'}
							];
		switch($stateParams.page){
			case 'movies':
				$scope.title = "Movies";
				urlCate = 'movies/';
				url = 'films.json';
				getLnG();
				break;
			case 'tv':
				$scope.title = "TV";
				urlCate = 'series/';
				url = 'series.json';
				getLnG();
				break;
			case 'news':
				$scope.title = "News";
				urlCate = 'news/';
				url = 'news_clips.json';
				getData.fromUrl('/v4/' + urlCate +'countries.json?app=' + api.app_id + '&t=' + api.currentTime())
				.then(function(requested){
					countries_obj = requested.data;
					$scope.countries_list = objToArr(countries_obj,'Countries');
					if(tempData.countryName !== 'All Countries' && tempData.countryName){
						$scope.country.obj = countries_obj[tempData.cateTypeAttr];
					}
					else{
						$scope.country.obj = $scope.countries_list[0];
					}
				});
				break;
			default:
		}
		$scope.loadVideos = function(url,reset) {
			if(reset){
				tempArrayOfVideos = [];
			}
			getData.fromUrl(url.replace(api.app_url,'') + '&t=' + api.currentTime()).then(function(requested){
				for (var i = 0; i < requested.data.response.length; i++) {
					tempArrayOfVideos.push(requested.data.response[i]);
				}
				$scope.videos = tempArrayOfVideos;
				$scope.next = requested.data.pagination.next;
				setTimeout(function(){
					if($scope.filtered.length < 3){
						$scope.loadVideos($scope.next,false);
					}
				}, 500);
			});
		};
		$scope.reload = function(){
            resetAll();
			sessionStorage.clear();
			videosList.scrollTop(0);
			$scope.loadVideos(urlGenerator(),true);
		};
		if($rootScope.previousState === 'home' || $rootScope.previousState === 'settings' || $rootScope.previousState === 'activities' || $rootScope.previousState === $rootScope.currentState){
			sessionStorage.clear();
		}
		if($rootScope.previousState === 'search'){
			$scope.reload();
		}
		if(sessionStorage.getItem($stateParams.page)){
			tempData = JSON.parse(sessionStorage.getItem($stateParams.page));
			if(tempData.timeAttr === 'newest_video'){
				$scope.timeFilter.filter = $scope.sortingSub[0];
			}
			else{
				$scope.timeFilter.filter = $scope.sortingSub[1];
			}
			if(tempData.countryName){
				$scope.accTitle = tempData.countryName;
			}
			else{
				$scope.accTitle = "Browse by";
			}
			$scope.selectedCode = tempData.countryValue;
		}
		else{
			resetAll();
		}
		var pageObj = scrollVideos.getList() || {};
		if($.isEmptyObject(pageObj)){
			$scope.loadVideos(urlGenerator());
		}else{
			$scope.videos = pageObj.loadedVideos;
			tempArrayOfVideos = pageObj.loadedVideos;
			$scope.next = pageObj.next;
			setTimeout(function(){
				videosList.scrollTop(pageObj.position);
			}, 100);
		}
		$scope.checker = api.process_url;

		$scope.updateSub = function(val){
			tempData.timeAttr = val;
			$scope.loadVideos(urlGenerator(),true);
			videosList.scrollTop(0);
		};
		$scope.check = false;
		$scope.toggleDrop = function(){
			$scope.check = !$scope.check;
		};
		$scope.filterSelect = function(name){
			$scope.vCheck = true;
			tempData.cateTypeAttr = name.id;
			$scope.accTitle = name.name.en;
			tempData.countryName = name.name.en;
			$scope.loadVideos(urlGenerator(),true);
			videosList.scrollTop(0);
		};
		$scope.newsFilter = function(val){
			tempData.timeAttr = 'newest_video';
			tempData.cateNameAttr = 'origin_country';
			tempData.cateTypeAttr = val.id;
			tempData.countryName = val.name.en;
			$scope.loadVideos(urlGenerator(),true);
			videosList.scrollTop(0);
		};
		$scope.filterAttr = function(main){
			$scope.vCheck = false;
			$scope.selectedCode = main.value;
			tempData.cateNameAttr = main.name;
			tempData.countryValue = main.value;
			switch(main.name){
				case 'subtitle_completion':
					$scope.mainVal.data = languages;
					break;
				case 'origin_country':
					$scope.mainVal.data = countries;
					break;
				case 'genre':
					$scope.mainVal.data = genres;
					break;
				default:
			}
			$scope.selectedVal = tempData.countryName;
		};

		$scope.$on("$stateChangeStart", function() {
			sessionStorage.setItem($stateParams.page, JSON.stringify(tempData));
			var temp = {
				loadedVideos : $scope.videos,
				position : angular.element('.video-list').scrollTop(),
				next : $scope.next
			};
			scrollVideos.updateList(temp);
		});

		$scope.newsReset = function(){
			$scope.country.obj = $scope.countries_list[0];
		};

		function resetAll(){
			$scope.accTitle = "Browse by";
            $scope.timeFilter.filter = $scope.sortingSub[1];
            if($stateParams.page === 'news'){
            	tempData.timeAttr = 'newest_video';
            }
            else{
            	tempData.timeAttr = 'views_recent';
            }
			tempData.cateNameAttr = '';
			tempData.cateTypeAttr = '';
			scrollVideos.destroyList();
		}

		function getLnG(){
			getData.fromUrl('/v4/' + urlCate +'countries.json?app=' + api.app_id + '&t=' + api.currentTime())
			.then(function(requested){
				countries = objToArr(requested.data,'Countries');
			});
			getData.fromUrl('/v4/' + urlCate +'languages.json?app=' + api.app_id + '&t=' + api.currentTime())
			.then(function(requested){
				languages = objToArr(requested.data,'Languages');
			});
			getData.fromUrl('/v4/' + urlCate +'genres.json?app=' + api.app_id + '&t=' + api.currentTime())
			.then(function(requested){
				genres = requested.data;
				var temp = {
							id: '',
							name: {en : 'All Genres'}
						};
				genres.splice(0,0,temp);
			});
		}
		function objToArr(obj,name){
			var arr = [];
			arr[0] = {
						id: '',
						name: {en : 'All ' + name}
					};
			for(var key in obj){
				if(obj.hasOwnProperty(key)){
					obj[key].id = key;
					arr.push(obj[key]);
				}
			}
			return arr;
		}
		function urlGenerator(){
			var urlReturn = api.app_url + '/v4/' + url + '?per_page=' + api.app_count + '&with_paging=true&sort='+ tempData.timeAttr;
			if(tempData.cateTypeAttr){
				urlReturn += '&' + tempData.cateNameAttr + '=' + tempData.cateTypeAttr;
			}
			return urlReturn + '&app=' + api.app_id;
		}
	}]);
})();