(function (){
    'use strict';

    angular
    .module('viki-controllers')
    .constant('DETAILS_PAGE', {
        'FACEBOOK' : 'http://www.facebook.com/sharer/sharer.php?u=',
        'TWITTER': 'http://twitter.com/share?url='
    })
    .controller('appVideoDetails', ['DETAILS_PAGE','$rootScope','$scope','$state','api','getData','postData','shareData', 'shareFavorites', function(DETAILS_PAGE,$rootScope,$scope,$state,api,getData,postData,shareData,shareFavorites){

        var tempArrayOfVideos = [];
        $scope.videoObj = shareData.getVideo() || {};

        if($.isEmptyObject($scope.videoObj)){
            $state.go('home');
            return;
        }
        $scope.tab = 2;
        $scope.setTab = function(newValue){
          $scope.tab = newValue;
        };
        $scope.isSet = function(tabName){
          return $scope.tab === tabName;
        };
        if($rootScope.previousState !== 'player' && $rootScope.previousState !== 'detail-page') {
            $rootScope.prevToDetails = $rootScope.subState;
        }
        $scope.language = $rootScope.selectedLang;
        $scope.share = true;
        $scope.isFavorite = false;
        $scope.loadVideos = function(url){
            getData.fromUrl(url.replace(api.app_url,'') + '&app=' + api.app_id + '&t=' + api.currentTime()).then(function(requested){
                for (var i = 0; i < requested.data.response.length; i++) {
                    tempArrayOfVideos.push(requested.data.response[i]);
                }
                $scope.videos = tempArrayOfVideos;
                $scope.next = requested.data.pagination.next;
                if($scope.next){
                   $scope.next = $scope.next.replace('&app='+api.app_id, '');
                }
            });
        };
        if($scope.videoObj.type === "film" || $scope.videoObj.type === "movie" || $scope.videoObj.type === "news" || $scope.videoObj.type === "news_clip"){
            $scope.title = $scope.videoObj.titles.en;
        }
        else if($scope.videoObj.type === "episode" || $scope.videoObj.type === "clip"){
            $scope.title = 'EP:' + $scope.videoObj.number + ' ' + $scope.videoObj.container.titles.en;

            $scope.details_back = function(){
                getData.fromUrl($scope.videoObj.container.url.api.replace(api.app_url,'') + '?app=' + api.app_id + '&t=' + api.currentTime())
                .then(function(requested){
                    shareData.updateVideo(requested.data);
                    $state.go($state.current, {}, {reload: true});
                });
            };
        }
        else{
            $scope.tab = 1;
            $scope.title = $scope.videoObj.titles.en;
            $scope.count = $scope.videoObj.episodes.count;
            if($scope.videoObj.episodes.url){
                var url = $scope.videoObj.episodes.url.api + '?with_paging=true&per_page=10';
                if(!$scope.videoObj['flags']['on_air']){
                    url += '&direction=asc';
                }
                $scope.loadVideos(url);
            }
        }

        if($rootScope.inSession){
            var favList = shareFavorites.getList();
            for(var i=0; i<favList.length; i++){
                if (favList[i].id === $scope.videoObj.id) {
                    $scope.isFavorite = true;
                }
            }
        }

        $scope.clickPlay = function(id){
            $state.go('player');
            shareData.updateVideo(id);
        };

        $scope.isSelected = function(lang){
            var active = $rootScope.selectedLang === lang;
            return active;
        };

        $scope.setLang = function(code){
            $rootScope.selectedLang = code;
             $scope.language = $rootScope.selectedLang;
        };

        $scope.checker = api.process_url;
        $scope.check = false;

        $scope.shareToggle = function(){
            $scope.check = !$scope.check;
        };

        $scope.shareWith = function(site) {
            $scope.check = !$scope.check;
            var siteUrl;
            if(site === 'fb'){
                siteUrl = DETAILS_PAGE.FACEBOOK;
            }
            else if(site === 'tw'){
                siteUrl = DETAILS_PAGE.TWITTER;
            }
            if($scope.videoObj.url.fb){
                siteUrl += $scope.videoObj.url.fb;
            }
            else{
                siteUrl += $scope.videoObj.url.web;
            }
            window.open(siteUrl, '_blank');
        };
        $scope.addToFav = function(){
            if($rootScope.inSession){
                postData.toUrl('/v4/users/' + $rootScope.loginUser.id + '/subscriptions.json?app=' + api.app_id + '&t=' + api.currentTime() + '&token=' + $rootScope.loginToken, {"resource_id": $scope.videoObj.id})
                .then(function(){
                    $scope.isFavorite = true;
                    $scope.videoObj.subscriptions.count += 1;
                });
            }
            else{
                $state.go('login');
            }
        };
        $scope.deleteFav = function(){
            postData.deleteItem('/v4/users/' + $rootScope.loginUser.id + '/subscriptions/'+ $scope.videoObj.id +'.json?app=' + api.app_id + '&t=' + api.currentTime() + '&token=' + $rootScope.loginToken)
            .then(function(){
                $scope.isFavorite = false;
                $scope.videoObj.subscriptions.count -= 1;
            });
        };
        $scope.isSubtitlesEmpty = function(obj){
            if($.isEmptyObject(obj)) {
                return true;
            }
            else{
                return false;
            }
        };

    }]);

})();