(function(){
    'use strict';

    angular
    .module('viki-controllers', [])
     .constant('GLOBAL_PAGE', {
        'LANGUAGE' : 'vikiSubtitleLanguage',
        'MAILTO' : 'mobile@viki.com',
        'MAILSUBJECT' : 'Viki Feedback'
    })
    .controller('globalController', ['GLOBAL_PAGE','$scope', '$location', '$rootScope', '$window', '$state', '$http', 'api', 'preloadData', 'authService' , 'getData', 'shareFavorites', function(GLOBAL_PAGE,$scope,$location,$rootScope,$window,$state,$http,api,preloadData,authService,getData,shareFavorites){
        window.screen.mozLockOrientation("portrait");

        var hash = window.location.hash;
       
         document.querySelector("body").onfocus = function(){
          
            var el = $rootScope.currentState === 'player';
           
             if(el) {              
              
                window.screen.mozLockOrientation("landscape");
               
            }else{
                window.screen.mozLockOrientation("portrait");
            }
        };
        
        
      
        //default subtitle language
        if(localStorage.getItem(GLOBAL_PAGE.LANGUAGE)){
            $rootScope.selectedLang = localStorage.getItem(GLOBAL_PAGE.LANGUAGE);
        }
        else{
            $rootScope.selectedLang = 'en';
            localStorage.setItem(GLOBAL_PAGE.LANGUAGE, $rootScope.selectedLang);
        }

        //store subtitle langugae locally
        $rootScope.$watch('selectedLang', function(){
            localStorage.setItem(GLOBAL_PAGE.LANGUAGE, $rootScope.selectedLang);
        });

        //highlighting selected drawer menu
        $scope.isActive = function (viewLocation) {
            var active = (viewLocation === $location.path());
            return active;
        };

        $rootScope.$on('$stateChangeSuccess', function(ev, to, toParams, from, fromParams) {
            $rootScope.previousState = from.name;
            $rootScope.currentState = to.name;
            $rootScope.subState = fromParams.page;
        });

        $scope.details_back = function(){
            if($rootScope.previousState === 'player' && $rootScope.prevToDetails){
                $state.go('category',{page : $rootScope.prevToDetails});
            }
            else if(($rootScope.previousState === 'detail-page' || $rootScope.previousState === 'player') && !$rootScope.prevToDetails){
                $state.go('home');
            }
            else{
                $window.history.back();
            }
        };

        var checkOsVersion = function(versionValue){
            var actions = {
        			"18.0": function () {
        				return "1.0.1";
        				},
        				"18.1": function () {
        					return "1.1";
        					},
        					"26.0": function () {
        						return "1.2";
        						},
        						"28.0": function () {
        							return "1.3";
        							},
        							"30.0": function () {
        								return "1.4";
        								},
        								"32.0": function () {
        									return "2.0";
        									}
        								};
        	if (typeof actions[versionValue] !== "function") {
        		return "";
        		}
        	return actions[versionValue]();
        	};

        $scope.getEmailDetails = function(){
            //Email Us Tab data
            $scope.mailTo=GLOBAL_PAGE.MAILTO;
            $scope.mailSubject=GLOBAL_PAGE.MAILSUBJECT;
            //timezone
            var date = new Date();
            var dateString=date.toString();
            var localTime=dateString.substring((dateString.indexOf('('))+1,dateString.lastIndexOf(')'));
            $scope.timeZone=localTime;
            //device OS details
            var deviceData=(navigator.userAgent).toString();
            $scope.firefoxOs=checkOsVersion(deviceData.substring((deviceData.length)-4,deviceData.length));
            //application name
        };

        var request = window.navigator.mozApps.getSelf();
        request.onsuccess = function() {
            if (request.result) {
                 // Pull the name of the app out of the App object
                $scope.versionNumber=request.result.manifest.version;
                $scope.appName=request.result.manifest.name;
            }
        };
           /* */
        if(hash.indexOf('access_token') > -1){
          console.log('INSIDE FB AUTO LOGIN');
                $rootScope.isFb = true;
                var hash2 = window.location.href,
                startPos = hash2.indexOf('access_token=') + 'access_token='.length,
                endPos = Math.min(hash2.indexOf('&expires_in=')),
                accessToken = hash2.substring(startPos, endPos);
            console.log('fb access token:'+accessToken);
                $rootScope.fbToken = accessToken;
                var data = {
                    'facebook_token': accessToken
                };

            var isFb=localStorage.getItem("logoutFb");

            if(isFb){

                localStorage.removeItem('logoutFb');
                $rootScope.loginToken=$rootScope.fbToken;
                authService.logoutReq();
                $state.go('home');
            }else{
                authService.loginReq('/v5/sessions.json?app=' + api.app_id + '&t=' + api.currentTime(),data)
                    .then(function(requested){
                        if(requested.status !== 200){
                            utils.status.show('Error logging in. Try again.');
                            $scope.error_message =  requested.data.error;
                            $scope.error_submit = true;
                        }
                        else{
                            localStorage.setItem('authToken', requested.data.token);
                            $rootScope.loginToken = requested.data.token;
                            $rootScope.loginUser = requested.data.user;
                            $rootScope.inSession = true;
                            $state.go('activities');
                        }
                    });
            }

        }
        else if(localStorage.getItem('authToken')){

            console.log('INSIDE viki normal AUTO LOGIN with token:'+localStorage.getItem('authToken'));
            $rootScope.loginToken = localStorage.getItem('authToken');

            var isFb=localStorage.getItem("logoutFb");
            console.log('isFb:'+isFb);
            if(isFb){

                localStorage.removeItem('logoutFb');
                authService.logoutReq();
                $state.go('home');
            }else {
                authService.retrieveSes('/v5/sessions/' + $rootScope.loginToken + '.json?app=' + api.app_id + '&t=' + api.currentTime())
                    .then(function (requested) {
                        $rootScope.loginUser = requested.data.user;
                        $rootScope.inSession = true;
                        $rootScope.dpUrl = requested.data.user.images.avatar.url;
                        $state.go('home');
                        getData.fromUrl('/v4/users/' + requested.data.user.id + '/subscriptions.json?with_paging=true&token=' + $rootScope.loginToken + '&app=' + api.app_id + '&t=' + api.currentTime())
                            .then(function (requested) {
                                shareFavorites.updateList(requested.data.response);
                            });
                    });
            }
        }
        else{
            $state.go('home');
        }
            //testing code
      window.addEventListener("orientationchange", function() {
    // Announce the new orientation number
    alert(window.orientation);
}, false);



    }]);

})();